/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.basic.validator;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.IProtocolFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.ProtocolException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.validator.IValidazioneDocumenti;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.validator.ValidazioneResult;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoServizioParteComune;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoServizioParteSpecifica;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Documento;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Fruitore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.TipiDocumentoConversazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.TipiDocumentoCoordinamento;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.TipiDocumentoInterfaccia;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.TipiDocumentoLivelloServizio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.TipiDocumentoSemiformale;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.TipiDocumentoSicurezza;
import it.link.pdd.tools.migrazione_govway.utils.resources.HttpUtilities;
import it.link.pdd.tools.migrazione_govway.utils.wsdl.DefinitionWrapper;
import it.link.pdd.tools.migrazione_govway.utils.wsdl.WSDLUtilities;
import it.link.pdd.tools.migrazione_govway.utils.xml.AbstractXMLUtils;
import it.link.pdd.tools.migrazione_govway.utils.xml.XMLUtils;
import it.link.pdd.tools.migrazione_govway.utils.xml.XSDUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.w3c.dom.Document;

public class ValidazioneDocumenti
implements IValidazioneDocumenti {
    protected IProtocolFactory protocolFactory;
    protected Logger log;
    protected AbstractXMLUtils xmlUtils = null;
    protected XSDUtils xsdUtils = null;
    protected WSDLUtilities wsdlUtilities = null;

    public ValidazioneDocumenti(IProtocolFactory factory) {
        this.log = factory.getLogger();
        this.protocolFactory = factory;
        this.xmlUtils = XMLUtils.getInstance();
        this.xsdUtils = new XSDUtils(this.xmlUtils);
        this.wsdlUtilities = WSDLUtilities.getInstance(this.xmlUtils);
    }

    @Override
    public IProtocolFactory getProtocolFactory() {
        return this.protocolFactory;
    }

    @Override
    public ValidazioneResult validaInterfacciaWsdlParteComune(AccordoServizioParteComune accordoServizioParteComune) {
        DefinitionWrapper wsdl;
        Document d;
        String objectInEsame = null;
        ValidazioneResult result = new ValidazioneResult();
        result.setEsito(false);
        try {
            objectInEsame = "[InterfacciaWSDL Definitoria] ";
            byte[] wsdlDefinitorio = null;
            if (accordoServizioParteComune.getByteWsdlDefinitorio() != null) {
                wsdlDefinitorio = accordoServizioParteComune.getByteWsdlDefinitorio();
            } else if (accordoServizioParteComune.getWsdlDefinitorio() != null) {
                wsdlDefinitorio = this.readDocumento(accordoServizioParteComune.getWsdlDefinitorio());
            }
            if (wsdlDefinitorio != null) {
                this.xmlUtils.newDocument(wsdlDefinitorio);
                this.xsdUtils.getTargetNamespace(wsdlDefinitorio);
            }
        }
        catch (Exception e) {
            result.setMessaggioErrore(objectInEsame + " Documento non valido: " + e.getMessage());
            result.setException(e);
            return result;
        }
        try {
            objectInEsame = "[InterfacciaWSDL Concettuale] ";
            byte[] wsdlConcettuale = null;
            if (accordoServizioParteComune.getByteWsdlConcettuale() != null) {
                wsdlConcettuale = accordoServizioParteComune.getByteWsdlConcettuale();
            } else if (accordoServizioParteComune.getWsdlConcettuale() != null) {
                wsdlConcettuale = this.readDocumento(accordoServizioParteComune.getWsdlConcettuale());
            }
            if (wsdlConcettuale != null) {
                d = this.xmlUtils.newDocument(wsdlConcettuale);
                this.wsdlUtilities.getTargetNamespace(wsdlConcettuale);
                this.wsdlUtilities.removeSchemiIntoTypes(d);
                wsdl = new DefinitionWrapper(d, this.xmlUtils, false, false);
                wsdl.valida(false);
            }
        }
        catch (Exception e) {
            result.setMessaggioErrore(objectInEsame + " Documento non valido: " + e.getMessage());
            result.setException(e);
            return result;
        }
        try {
            objectInEsame = "[InterfacciaWSDL Erogatore] ";
            byte[] wsdlErogatore = null;
            if (accordoServizioParteComune.getByteWsdlLogicoErogatore() != null) {
                wsdlErogatore = accordoServizioParteComune.getByteWsdlLogicoErogatore();
            } else if (accordoServizioParteComune.getWsdlLogicoErogatore() != null) {
                wsdlErogatore = this.readDocumento(accordoServizioParteComune.getWsdlLogicoErogatore());
            }
            if (wsdlErogatore != null) {
                d = this.xmlUtils.newDocument(wsdlErogatore);
                this.wsdlUtilities.getTargetNamespace(wsdlErogatore);
                this.wsdlUtilities.removeSchemiIntoTypes(d);
                wsdl = new DefinitionWrapper(d, this.xmlUtils, false, false);
                wsdl.valida(false);
            }
        }
        catch (Exception e) {
            result.setMessaggioErrore(objectInEsame + " Documento non valido: " + e.getMessage());
            result.setException(e);
            return result;
        }
        try {
            objectInEsame = "[InterfacciaWSDL Fruitore] ";
            byte[] wsdlFruitore = null;
            if (accordoServizioParteComune.getByteWsdlLogicoFruitore() != null) {
                wsdlFruitore = accordoServizioParteComune.getByteWsdlLogicoFruitore();
            } else if (accordoServizioParteComune.getWsdlLogicoFruitore() != null) {
                wsdlFruitore = this.readDocumento(accordoServizioParteComune.getWsdlLogicoFruitore());
            }
            if (wsdlFruitore != null) {
                d = this.xmlUtils.newDocument(wsdlFruitore);
                this.wsdlUtilities.getTargetNamespace(wsdlFruitore);
                this.wsdlUtilities.removeSchemiIntoTypes(d);
                wsdl = new DefinitionWrapper(d, this.xmlUtils, false, false);
                wsdl.valida(false);
            }
        }
        catch (Exception e) {
            result.setMessaggioErrore(objectInEsame + " Documento non valido: " + e.getMessage());
            result.setException(e);
            return result;
        }
        result.setEsito(true);
        return result;
    }

    @Override
    public ValidazioneResult validaSpecificaConversazione(AccordoServizioParteComune accordoServizioParteComune) {
        ValidazioneResult result = new ValidazioneResult();
        result.setEsito(true);
        return result;
    }

    @Override
    public ValidazioneResult validaInterfacciaWsdlParteSpecifica(AccordoServizioParteSpecifica accordoServizioParteSpecifica, AccordoServizioParteComune accordoServizioParteComune) {
        DefinitionWrapper wsdlParteSpecifica;
        Document d;
        ValidazioneResult result = new ValidazioneResult();
        result.setEsito(false);
        String tipoWsdl = null;
        byte[] wsdlImplementativoFruitore = null;
        byte[] wsdlImplementativoErogatore = null;
        byte[] wsdlLogicoFruitore = null;
        byte[] wsdlLogicoErogatore = null;
        try {
            tipoWsdl = "ImplementativoFruitore";
            if (accordoServizioParteSpecifica.getByteWsdlImplementativoFruitore() != null) {
                wsdlImplementativoFruitore = accordoServizioParteSpecifica.getByteWsdlImplementativoFruitore();
            } else if (accordoServizioParteSpecifica.getWsdlImplementativoFruitore() != null) {
                wsdlImplementativoFruitore = this.readDocumento(accordoServizioParteSpecifica.getWsdlImplementativoFruitore());
            }
            tipoWsdl = "ImplementativoErogatore";
            if (accordoServizioParteSpecifica.getByteWsdlImplementativoErogatore() != null) {
                wsdlImplementativoErogatore = accordoServizioParteSpecifica.getByteWsdlImplementativoErogatore();
            } else if (accordoServizioParteSpecifica.getWsdlImplementativoErogatore() != null) {
                wsdlImplementativoErogatore = this.readDocumento(accordoServizioParteSpecifica.getWsdlImplementativoErogatore());
            }
            tipoWsdl = "LogicoFruitore";
            if (accordoServizioParteComune.getByteWsdlLogicoFruitore() != null) {
                wsdlLogicoFruitore = accordoServizioParteComune.getByteWsdlLogicoFruitore();
            } else if (accordoServizioParteComune.getWsdlLogicoFruitore() != null) {
                wsdlLogicoFruitore = this.readDocumento(accordoServizioParteComune.getWsdlLogicoFruitore());
            }
            tipoWsdl = "LogicoErogatore";
            if (accordoServizioParteComune.getByteWsdlLogicoErogatore() != null) {
                wsdlLogicoErogatore = accordoServizioParteComune.getByteWsdlLogicoErogatore();
            } else if (accordoServizioParteComune.getWsdlLogicoErogatore() != null) {
                wsdlLogicoErogatore = this.readDocumento(accordoServizioParteComune.getWsdlLogicoErogatore());
            }
        }
        catch (Exception e) {
            result.setMessaggioErrore("Raccolta wsdl " + tipoWsdl + " non riuscita: " + e.getMessage());
            result.setException(e);
            return result;
        }
        Vector<String> portTypesWSDL_erogatore = new Vector<String>();
        tipoWsdl = "LogicoErogatore";
        try {
            if (wsdlLogicoErogatore != null) {
                Document dParteComune = this.xmlUtils.newDocument(wsdlLogicoErogatore);
                this.wsdlUtilities.removeSchemiIntoTypes(dParteComune);
                DefinitionWrapper wsdlParteCoumune = new DefinitionWrapper(dParteComune, this.xmlUtils, false, false);
                for (QName pt : wsdlParteCoumune.getAllPortTypes().keySet()) {
                    portTypesWSDL_erogatore.add(pt.getLocalPart());
                }
            }
        }
        catch (Exception e) {
            result.setMessaggioErrore("Lettura wsdl " + tipoWsdl + " (comprensione port types) non riuscita: " + e.getMessage());
            result.setException(e);
            return result;
        }
        if (portTypesWSDL_erogatore.size() == 0 && wsdlImplementativoErogatore != null) {
            result.setMessaggioErrore("Per poter fornire un WSDL Implementativo Erogatore, \u00e8 necessario prima definire un wsdl logico erogatore valido nell'accordo di servizio parte comune");
            return result;
        }
        Vector<String> portTypesWSDL_fruitore = new Vector<String>();
        tipoWsdl = "LogicoFruitore";
        try {
            if (wsdlLogicoFruitore != null) {
                Document dParteComune = this.xmlUtils.newDocument(wsdlLogicoFruitore);
                this.wsdlUtilities.removeSchemiIntoTypes(dParteComune);
                DefinitionWrapper wsdlParteCoumune = new DefinitionWrapper(dParteComune, this.xmlUtils, false, false);
                for (QName pt : wsdlParteCoumune.getAllPortTypes().keySet()) {
                    portTypesWSDL_fruitore.add(pt.getLocalPart());
                }
            }
        }
        catch (Exception e) {
            result.setMessaggioErrore("Lettura wsdl " + tipoWsdl + " (comprensione port types) non riuscita: " + e.getMessage());
            result.setException(e);
            return result;
        }
        if (portTypesWSDL_fruitore.size() == 0 && wsdlImplementativoFruitore != null) {
            result.setMessaggioErrore("Per poter fornire un WSDL Implementativo Fruitore, \u00e8 necessario prima definire un wsdl logico fruitore valido nell'accordo di servizio parte comune");
            return result;
        }
        if (wsdlImplementativoErogatore != null && wsdlImplementativoFruitore != null) {
            result.setMessaggioErrore("Non \u00e8 possibile definire sia il WSDL implementativo erogatore che il WSDL implementativo fruitore");
            return result;
        }
        try {
            if (wsdlImplementativoErogatore != null) {
                d = this.xmlUtils.newDocument(wsdlImplementativoErogatore);
                this.wsdlUtilities.getTargetNamespace(wsdlImplementativoErogatore);
                this.wsdlUtilities.removeSchemiIntoTypes(d);
                wsdlParteSpecifica = new DefinitionWrapper(d, this.xmlUtils, false, false);
                wsdlParteSpecifica.validaBinding(portTypesWSDL_erogatore);
                this.checkPortTypeInBinding(wsdlParteSpecifica);
            }
        }
        catch (Exception e) {
            result.setMessaggioErrore("WSDL Implementativo Erogatore non valido: " + e.getMessage());
            result.setException(e);
            return result;
        }
        try {
            if (wsdlImplementativoFruitore != null) {
                d = this.xmlUtils.newDocument(wsdlImplementativoFruitore);
                this.wsdlUtilities.getTargetNamespace(wsdlImplementativoFruitore);
                this.wsdlUtilities.removeSchemiIntoTypes(d);
                wsdlParteSpecifica = new DefinitionWrapper(d, this.xmlUtils, false, false);
                wsdlParteSpecifica.validaBinding(portTypesWSDL_fruitore);
                this.checkPortTypeInBinding(wsdlParteSpecifica);
            }
        }
        catch (Exception e) {
            result.setMessaggioErrore("WSDL Implementativo Fruitore non valido: " + e.getMessage());
            result.setException(e);
            return result;
        }
        result.setEsito(true);
        return result;
    }

    private void checkPortTypeInBinding(DefinitionWrapper wsdlParteSpecifica) throws Exception {
        Hashtable<QName, QName> mapBindingToPortTypeImplemented = wsdlParteSpecifica.getMapPortTypesImplementedBinding();
        ArrayList<String> portTypes = new ArrayList<String>();
        StringBuffer bf = new StringBuffer();
        Enumeration<QName> bindings = mapBindingToPortTypeImplemented.keys();
        while (bindings.hasMoreElements()) {
            QName binding = bindings.nextElement();
            QName portType = mapBindingToPortTypeImplemented.get(binding);
            String portTypeName = portType.getLocalPart();
            if (portTypes.contains(portTypeName)) continue;
            portTypes.add(portTypeName);
            if (bf.length() > 0) {
                bf.append(",");
            }
            bf.append(portTypeName);
        }
        if (portTypes.size() > 1) {
            throw new Exception("Trovato pi\u00f9 di un port type implementato dai binding presenti: " + bf.toString());
        }
    }

    @Override
    public ValidazioneResult validaInterfacciaWsdlParteSpecifica(Fruitore fruitore, AccordoServizioParteSpecifica accordoServizioParteSpecifica, AccordoServizioParteComune accordoServizioParteComune) {
        AccordoServizioParteSpecifica as = new AccordoServizioParteSpecifica();
        as.setByteWsdlImplementativoErogatore(fruitore.getByteWsdlImplementativoErogatore());
        as.setByteWsdlImplementativoFruitore(fruitore.getByteWsdlImplementativoFruitore());
        as.setWsdlImplementativoErogatore(fruitore.getWsdlImplementativoErogatore());
        as.setWsdlImplementativoFruitore(fruitore.getWsdlImplementativoFruitore());
        return this.validaInterfacciaWsdlParteSpecifica(as, accordoServizioParteComune);
    }

    @Override
    public ValidazioneResult valida(Documento documento) {
        ValidazioneResult result = new ValidazioneResult();
        result.setEsito(false);
        if (TipiDocumentoInterfaccia.WSDL.equals(documento.getTipo()) || TipiDocumentoConversazione.WSBL.equals(documento.getTipo()) || TipiDocumentoConversazione.BPEL.equals(documento.getTipo()) || TipiDocumentoCoordinamento.BPEL.equals(documento.getTipo()) || TipiDocumentoCoordinamento.WSCDL.equals(documento.getTipo()) || TipiDocumentoLivelloServizio.WSAGREEMENT.equals(documento.getTipo()) || TipiDocumentoLivelloServizio.WSLA.equals(documento.getTipo()) || TipiDocumentoSemiformale.XML.equals(documento.getTipo()) || TipiDocumentoSicurezza.WSPOLICY.equals(documento.getTipo()) || TipiDocumentoSicurezza.XACML_POLICY.equals(documento.getTipo())) {
            try {
                byte[] doc = null;
                if (documento.getByteContenuto() != null) {
                    doc = documento.getByteContenuto();
                } else if (documento.getFile() != null) {
                    doc = this.readDocumento(documento.getFile());
                }
                if (doc != null) {
                    this.xmlUtils.newDocument(doc);
                    this.xsdUtils.getTargetNamespace(doc);
                }
            }
            catch (Exception e) {
                result.setMessaggioErrore("Documento " + documento.getFile() + " (ruolo:" + documento.getRuolo() + ") non valido: " + e.getMessage());
                result.setException(e);
                return result;
            }
        }
        result.setEsito(true);
        return result;
    }

    @Override
    public ValidazioneResult validaDocumenti(AccordoServizioParteComune accordoServizioParteComune) {
        ValidazioneResult v;
        int i;
        for (i = 0; i < accordoServizioParteComune.sizeAllegatoList(); ++i) {
            v = this.valida(accordoServizioParteComune.getAllegato(i));
            if (v.isEsito()) continue;
            return v;
        }
        for (i = 0; i < accordoServizioParteComune.sizeSpecificaSemiformaleList(); ++i) {
            v = this.valida(accordoServizioParteComune.getSpecificaSemiformale(i));
            if (v.isEsito()) continue;
            return v;
        }
        if (accordoServizioParteComune.getServizioComposto() != null) {
            for (i = 0; i < accordoServizioParteComune.getServizioComposto().sizeSpecificaCoordinamentoList(); ++i) {
                v = this.valida(accordoServizioParteComune.getServizioComposto().getSpecificaCoordinamento(i));
                if (v.isEsito()) continue;
                return v;
            }
        }
        ValidazioneResult result = new ValidazioneResult();
        result.setEsito(true);
        return result;
    }

    @Override
    public ValidazioneResult validaDocumenti(AccordoServizioParteSpecifica accordoServizioParteSpecifica) {
        ValidazioneResult v;
        int i;
        for (i = 0; i < accordoServizioParteSpecifica.sizeAllegatoList(); ++i) {
            v = this.valida(accordoServizioParteSpecifica.getAllegato(i));
            if (v.isEsito()) continue;
            return v;
        }
        for (i = 0; i < accordoServizioParteSpecifica.sizeSpecificaSemiformaleList(); ++i) {
            v = this.valida(accordoServizioParteSpecifica.getSpecificaSemiformale(i));
            if (v.isEsito()) continue;
            return v;
        }
        for (i = 0; i < accordoServizioParteSpecifica.sizeSpecificaLivelloServizioList(); ++i) {
            v = this.valida(accordoServizioParteSpecifica.getSpecificaLivelloServizio(i));
            if (v.isEsito()) continue;
            return v;
        }
        for (i = 0; i < accordoServizioParteSpecifica.sizeSpecificaSicurezzaList(); ++i) {
            v = this.valida(accordoServizioParteSpecifica.getSpecificaSicurezza(i));
            if (v.isEsito()) continue;
            return v;
        }
        ValidazioneResult result = new ValidazioneResult();
        result.setEsito(true);
        return result;
    }

    @Override
    public ValidazioneResult validaDocumenti(AccordoCooperazione accordoCooperazione) {
        ValidazioneResult v;
        int i;
        for (i = 0; i < accordoCooperazione.sizeAllegatoList(); ++i) {
            v = this.valida(accordoCooperazione.getAllegato(i));
            if (v.isEsito()) continue;
            return v;
        }
        for (i = 0; i < accordoCooperazione.sizeSpecificaSemiformaleList(); ++i) {
            v = this.valida(accordoCooperazione.getSpecificaSemiformale(i));
            if (v.isEsito()) continue;
            return v;
        }
        ValidazioneResult result = new ValidazioneResult();
        result.setEsito(true);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] readDocumento(String fileName) throws ProtocolException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            if (fileName.startsWith("http://") || fileName.startsWith("file://")) {
                byte[] file = HttpUtilities.requestHTTPFile(fileName);
                if (file == null) {
                    throw new Exception("byte[] is null");
                }
                bout.write(file);
            } else {
                File f = new File(fileName);
                if (f.exists()) {
                    FileInputStream file = null;
                    try {
                        file = new FileInputStream(f);
                        byte[] reads = new byte[65536];
                        int letti = 0;
                        while ((letti = file.read(reads)) >= 0) {
                            bout.write(reads, 0, letti);
                        }
                    }
                    finally {
                        try {
                            if (file != null) {
                                file.close();
                            }
                        }
                        catch (Exception exception) {}
                    }
                }
                throw new Exception("File [" + fileName + "] non esistente");
            }
            bout.flush();
            bout.close();
            if (bout.size() > 0) {
                return bout.toByteArray();
            }
        }
        catch (Exception e) {
            this.log.warn("File " + fileName + ", lettura documento non riuscita:", (Throwable)e);
        }
        throw new ProtocolException("Contenuto non letto?? File [" + fileName + "]");
    }
}

