/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.basic.validator;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.OpenSPCoop2Message;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.Busta;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.IProtocolFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.ProtocolException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.config.IProtocolVersionManager;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.config.ITraduttore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.MessaggiFaultErroreCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.validator.IValidatoreErrori;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.validator.ProprietaValidazioneErrori;
import javax.xml.soap.SOAPFault;
import org.slf4j.Logger;

public class ValidatoreErrori
implements IValidatoreErrori {
    protected IProtocolFactory protocolFactory;
    private ITraduttore costanti;
    protected Logger log = null;

    public ValidatoreErrori(IProtocolFactory protocolFactory) throws ProtocolException {
        this.protocolFactory = protocolFactory;
        this.costanti = protocolFactory.createTraduttore();
        this.log = protocolFactory.getLogger();
    }

    @Override
    public IProtocolFactory getProtocolFactory() {
        return this.protocolFactory;
    }

    @Override
    public boolean isBustaErrore(Busta busta, OpenSPCoop2Message msg, ProprietaValidazioneErrori proprietaValidazioneErrori) {
        boolean eccezioneProcessamento = false;
        try {
            if (msg != null && msg.getSOAPBody() != null && msg.getSOAPBody().hasFault()) {
                SOAPFault soapFault = msg.getSOAPBody().getFault();
                String faultS = soapFault.getFaultString();
                if (faultS != null) {
                    faultS = faultS.trim();
                }
                return this.costanti.toString(MessaggiFaultErroreCooperazione.FAULT_STRING_PROCESSAMENTO).equals(faultS) || this.costanti.toString(MessaggiFaultErroreCooperazione.FAULT_STRING_VALIDAZIONE).equals(faultS);
            }
        }
        catch (Exception e) {
            this.log.error("Errore durante l'analisi per comprendere se un msg e' una busta Errore: " + e.getMessage(), (Throwable)e);
        }
        IProtocolVersionManager pManager = null;
        try {
            pManager = this.protocolFactory.createProtocolVersionManager(proprietaValidazioneErrori.getVersioneProtocollo());
        }
        catch (Exception e) {
            this.log.error("Errore durante la createProtocolManager: " + e.getMessage(), (Throwable)e);
        }
        if (eccezioneProcessamento) {
            return true;
        }
        if (pManager.isIgnoraEccezioniLivelloNonGrave() || proprietaValidazioneErrori.isIgnoraEccezioniNonGravi()) {
            return busta.containsEccezioniGravi();
        }
        return busta.sizeListaEccezioni() > 0;
    }

    @Override
    public boolean isBustaErroreProcessamento(Busta busta, OpenSPCoop2Message msg, ProprietaValidazioneErrori proprietaValidazioneErrori) {
        boolean eccezioneProcessamento = false;
        try {
            if (msg != null && msg.getSOAPBody() != null && msg.getSOAPBody().hasFault()) {
                SOAPFault soapFault = msg.getSOAPBody().getFault();
                String faultS = soapFault.getFaultString();
                if (faultS != null) {
                    faultS = faultS.trim();
                }
                if (this.costanti.toString(MessaggiFaultErroreCooperazione.FAULT_STRING_PROCESSAMENTO).equals(faultS)) {
                    eccezioneProcessamento = true;
                }
            }
        }
        catch (Exception e) {
            this.log.error("Errore durante l'analisi per comprendere se un msg e' una busta Errore: " + e.getMessage(), (Throwable)e);
        }
        return eccezioneProcessamento;
    }

    @Override
    public boolean isBustaErroreIntestazione(Busta busta, OpenSPCoop2Message msg, ProprietaValidazioneErrori proprietaValidazioneErrori) {
        boolean eccezioneProcessamento = false;
        try {
            if (msg != null && msg.getSOAPBody() != null && msg.getSOAPBody().hasFault()) {
                SOAPFault soapFault = msg.getSOAPBody().getFault();
                String faultS = soapFault.getFaultString();
                if (faultS != null) {
                    faultS = faultS.trim();
                }
                if (this.costanti.toString(MessaggiFaultErroreCooperazione.FAULT_STRING_VALIDAZIONE).equals(faultS)) {
                    return true;
                }
                if (this.costanti.toString(MessaggiFaultErroreCooperazione.FAULT_STRING_PROCESSAMENTO).equals(faultS)) {
                    eccezioneProcessamento = true;
                }
            }
        }
        catch (Exception e) {
            this.log.error("Errore durante l'analisi per comprendere se un msg e' una busta Errore: " + e.getMessage(), (Throwable)e);
        }
        IProtocolVersionManager pManager = null;
        try {
            pManager = this.protocolFactory.createProtocolVersionManager(proprietaValidazioneErrori.getVersioneProtocollo());
        }
        catch (Exception e) {
            this.log.error("Errore durante la createProtocolManager: " + e.getMessage(), (Throwable)e);
        }
        if (eccezioneProcessamento) {
            return false;
        }
        if (pManager.isIgnoraEccezioniLivelloNonGrave() || proprietaValidazioneErrori.isIgnoraEccezioniNonGravi()) {
            return busta.containsEccezioniGravi();
        }
        return busta.sizeListaEccezioni() > 0;
    }
}

