/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.basic.tracciamento;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.OpenSPCoop2Message;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.OpenSPCoop2MessageFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.SOAPVersion;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.SoapUtils;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.XMLUtils;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.basic.Utilities;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.basic.tracciamento.XMLTracciaRootElement;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.IProtocolFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.ProtocolException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.XMLRootElement;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.config.ITraduttore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.CodiceErroreCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.ContestoCodificaEccezione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.Inoltro;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.LivelloRilevanza;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.ProfiloDiCollaborazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.SubCodiceErrore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.TipoOraRegistrazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.tracciamento.IXMLTracciaBuilder;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.tracciamento.Eccezione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.tracciamento.Riscontro;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.tracciamento.Traccia;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.tracciamento.Trasmissione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.tracciamento.constants.TipoCodificaEccezione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.tracciamento.constants.TipoInoltro;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.tracciamento.constants.TipoProfiloCollaborazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.tracciamento.constants.TipoRilevanzaEccezione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.tracciamento.constants.TipoTempo;
import it.link.pdd.tools.migrazione_govway.utils.xml.AbstractXMLUtils;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPFactory;
import org.slf4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLTracciaBuilder
implements IXMLTracciaBuilder {
    protected Logger log;
    protected IProtocolFactory factory;
    protected OpenSPCoop2MessageFactory fac = null;
    protected AbstractXMLUtils xmlUtils;

    @Override
    public IProtocolFactory getProtocolFactory() {
        return this.factory;
    }

    public XMLTracciaBuilder(IProtocolFactory factory) {
        this.log = factory.getLogger();
        this.factory = factory;
        this.fac = OpenSPCoop2MessageFactory.getMessageFactory();
        this.xmlUtils = XMLUtils.getInstance();
    }

    @Override
    public SOAPElement toElement(it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.tracciamento.Traccia tracciaObject) throws ProtocolException {
        String tmpId = null;
        try {
            SOAPElement traccia;
            Traccia tracciaBase;
            if (tracciaObject.sizeProperties() > 0) {
                tmpId = tracciaObject.removeProperty("@@@@@-----@@@@-----IDTRACCIA-DB----@@@@@-----@@@@");
            }
            if ((tracciaBase = tracciaObject.getTraccia()).getBustaXml() == null) {
                if (tracciaObject.getBustaAsByteArray() != null) {
                    tracciaBase.setBustaXml(new String(tracciaObject.getBustaAsByteArray()));
                } else if (tracciaObject.getBustaAsElement() != null) {
                    OpenSPCoop2Message msg = OpenSPCoop2MessageFactory.getMessageFactory().createEmptySOAPMessage(SOAPVersion.SOAP11);
                    tracciaBase.setBustaXml(msg.getAsString((Node)tracciaObject.getBustaAsElement(), false));
                }
            }
            ITraduttore protocolTraduttore = this.factory.createTraduttore();
            if (tracciaBase != null && tracciaBase.getBusta() != null) {
                if (tracciaBase.getBusta().getProfiloCollaborazione() != null && tracciaBase.getBusta().getProfiloCollaborazione().getBase() == null && tracciaBase.getBusta().getProfiloCollaborazione().getTipo() != null) {
                    tracciaBase.getBusta().getProfiloCollaborazione().setBase(this.getBaseValueProfiloCollaborazione(protocolTraduttore, tracciaBase.getBusta().getProfiloCollaborazione().getTipo()));
                }
                if (tracciaBase.getBusta().getProfiloTrasmissione() != null && tracciaBase.getBusta().getProfiloTrasmissione().getInoltro() != null && tracciaBase.getBusta().getProfiloTrasmissione().getInoltro().getBase() == null && tracciaBase.getBusta().getProfiloTrasmissione().getInoltro().getTipo() != null) {
                    tracciaBase.getBusta().getProfiloTrasmissione().getInoltro().setBase(this.getBaseValueInoltro(protocolTraduttore, tracciaBase.getBusta().getProfiloTrasmissione().getInoltro().getTipo()));
                }
                if (tracciaBase.getBusta().getOraRegistrazione() != null && tracciaBase.getBusta().getOraRegistrazione().getSorgente() != null && tracciaBase.getBusta().getOraRegistrazione().getSorgente().getBase() == null && tracciaBase.getBusta().getOraRegistrazione().getSorgente().getTipo() != null) {
                    tracciaBase.getBusta().getOraRegistrazione().getSorgente().setBase(this.getBaseValueTipoTempo(protocolTraduttore, tracciaBase.getBusta().getOraRegistrazione().getSorgente().getTipo()));
                }
                if (tracciaBase.getBusta().getTrasmissioni() != null && tracciaBase.getBusta().getTrasmissioni().sizeTrasmissioneList() > 0) {
                    for (Trasmissione trasmissione : tracciaBase.getBusta().getTrasmissioni().getTrasmissioneList()) {
                        if (trasmissione.getOraRegistrazione() == null || trasmissione.getOraRegistrazione().getSorgente() == null || trasmissione.getOraRegistrazione().getSorgente().getBase() != null || trasmissione.getOraRegistrazione().getSorgente().getTipo() == null) continue;
                        trasmissione.getOraRegistrazione().getSorgente().setBase(this.getBaseValueTipoTempo(protocolTraduttore, trasmissione.getOraRegistrazione().getSorgente().getTipo()));
                    }
                }
                if (tracciaBase.getBusta().getRiscontri() != null && tracciaBase.getBusta().getRiscontri().sizeRiscontroList() > 0) {
                    for (Riscontro riscontro : tracciaBase.getBusta().getRiscontri().getRiscontroList()) {
                        if (riscontro.getOraRegistrazione() == null || riscontro.getOraRegistrazione().getSorgente() == null || riscontro.getOraRegistrazione().getSorgente().getBase() != null || riscontro.getOraRegistrazione().getSorgente().getTipo() == null) continue;
                        riscontro.getOraRegistrazione().getSorgente().setBase(this.getBaseValueTipoTempo(protocolTraduttore, riscontro.getOraRegistrazione().getSorgente().getTipo()));
                    }
                }
                if (tracciaBase.getBusta().getEccezioni() != null && tracciaBase.getBusta().getEccezioni().sizeEccezioneList() > 0) {
                    for (Eccezione eccezione : tracciaBase.getBusta().getEccezioni().getEccezioneList()) {
                        if (eccezione.getCodice() != null && eccezione.getCodice().getBase() == null && eccezione.getCodice().getTipo() != null) {
                            eccezione.getCodice().setBase(this.getBaseValueCodiceEccezione(protocolTraduttore, eccezione.getCodice().getTipo(), eccezione.getCodice().getSottotipo()));
                        }
                        if (eccezione.getContestoCodifica() != null && eccezione.getContestoCodifica().getBase() == null && eccezione.getContestoCodifica().getTipo() != null) {
                            eccezione.getContestoCodifica().setBase(this.getBaseValueContestoCodifica(protocolTraduttore, eccezione.getContestoCodifica().getTipo()));
                        }
                        if (eccezione.getRilevanza() == null || eccezione.getRilevanza().getBase() != null || eccezione.getRilevanza().getTipo() == null) continue;
                        eccezione.getRilevanza().setBase(this.getBaseValueRilevanzaEccezione(protocolTraduttore, eccezione.getRilevanza().getTipo()));
                    }
                }
            }
            byte[] xmlTraccia = it.link.pdd.tools.migrazione_govway.openspcoop2_core.tracciamento.utils.XMLUtils.generateTraccia(tracciaBase);
            Element elementTraccia = this.xmlUtils.newElement(xmlTraccia);
            SOAPFactory sf = SoapUtils.getSoapFactory(SOAPVersion.SOAP11);
            SOAPElement sOAPElement = traccia = sf.createElement(elementTraccia);
            return sOAPElement;
        }
        catch (Exception e) {
            this.log.error("XMLBuilder.buildElement_Tracciamento error: " + e.getMessage(), (Throwable)e);
            throw new ProtocolException("XMLBuilder.buildElement_Tracciamento error: " + e.getMessage(), e);
        }
        finally {
            if (tmpId != null && tracciaObject != null) {
                tracciaObject.addProperty("@@@@@-----@@@@-----IDTRACCIA-DB----@@@@@-----@@@@", tmpId);
            }
        }
    }

    @Override
    public String toString(it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.tracciamento.Traccia traccia) throws ProtocolException {
        SOAPElement tracciamento = this.toElement(traccia);
        return Utilities.toString(this.log, tracciamento);
    }

    @Override
    public byte[] toByteArray(it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.tracciamento.Traccia traccia) throws ProtocolException {
        SOAPElement tracciamento = this.toElement(traccia);
        return Utilities.toByteArray(this.log, tracciamento);
    }

    private String getBaseValueProfiloCollaborazione(ITraduttore protocolTraduttore, TipoProfiloCollaborazione tipoProfiloCollaborazione) {
        switch (tipoProfiloCollaborazione) {
            case ONEWAY: {
                return protocolTraduttore.toString(ProfiloDiCollaborazione.ONEWAY);
            }
            case SINCRONO: {
                return protocolTraduttore.toString(ProfiloDiCollaborazione.SINCRONO);
            }
            case ASINCRONO_ASIMMETRICO: {
                return protocolTraduttore.toString(ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO);
            }
            case ASINCRONO_SIMMETRICO: {
                return protocolTraduttore.toString(ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO);
            }
            case SCONOSCIUTO: {
                return protocolTraduttore.toString(ProfiloDiCollaborazione.UNKNOWN);
            }
        }
        return null;
    }

    private String getBaseValueInoltro(ITraduttore protocolTraduttore, TipoInoltro tipoInoltro) {
        switch (tipoInoltro) {
            case INOLTRO_CON_DUPLICATI: {
                return protocolTraduttore.toString(Inoltro.CON_DUPLICATI);
            }
            case INOLTRO_SENZA_DUPLICATI: {
                return protocolTraduttore.toString(Inoltro.SENZA_DUPLICATI);
            }
            case SCONOSCIUTO: {
                return protocolTraduttore.toString(Inoltro.UNKNOWN);
            }
        }
        return null;
    }

    private String getBaseValueTipoTempo(ITraduttore protocolTraduttore, TipoTempo tipoTempo) {
        switch (tipoTempo) {
            case LOCALE: {
                return protocolTraduttore.toString(TipoOraRegistrazione.LOCALE);
            }
            case SCONOSCIUTO: {
                return protocolTraduttore.toString(TipoOraRegistrazione.UNKNOWN);
            }
            case SINCRONIZZATO: {
                return protocolTraduttore.toString(TipoOraRegistrazione.SINCRONIZZATO);
            }
        }
        return null;
    }

    private String getBaseValueCodiceEccezione(ITraduttore protocolTraduttore, Integer codice, Integer subCodice) {
        CodiceErroreCooperazione errore = CodiceErroreCooperazione.toCodiceErroreCooperazione(codice);
        if (subCodice == null) {
            return protocolTraduttore.toString(errore);
        }
        SubCodiceErrore sub = new SubCodiceErrore();
        sub.setSubCodice(subCodice);
        return protocolTraduttore.toString(errore, sub);
    }

    private String getBaseValueContestoCodifica(ITraduttore protocolTraduttore, TipoCodificaEccezione codifica) {
        switch (codifica) {
            case ECCEZIONE_PROCESSAMENTO: {
                return protocolTraduttore.toString(ContestoCodificaEccezione.PROCESSAMENTO);
            }
            case ECCEZIONE_VALIDAZIONE_PROTOCOLLO: {
                return protocolTraduttore.toString(ContestoCodificaEccezione.INTESTAZIONE);
            }
            case SCONOSCIUTO: {
                return null;
            }
        }
        return null;
    }

    private String getBaseValueRilevanzaEccezione(ITraduttore protocolTraduttore, TipoRilevanzaEccezione codifica) {
        switch (codifica) {
            case DEBUG: {
                return protocolTraduttore.toString(LivelloRilevanza.DEBUG);
            }
            case ERROR: {
                return protocolTraduttore.toString(LivelloRilevanza.ERROR);
            }
            case FATAL: {
                return protocolTraduttore.toString(LivelloRilevanza.FATAL);
            }
            case INFO: {
                return protocolTraduttore.toString(LivelloRilevanza.INFO);
            }
            case WARN: {
                return protocolTraduttore.toString(LivelloRilevanza.WARN);
            }
            case SCONOSCIUTO: {
                return protocolTraduttore.toString(LivelloRilevanza.UNKNOWN);
            }
        }
        return null;
    }

    @Override
    public XMLRootElement getXMLRootElement() throws ProtocolException {
        return new XMLTracciaRootElement();
    }
}

