/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.basic.tracciamento;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.commons.CoreException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.OpenspcoopAppender;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.basic.Utilities;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.basic.tracciamento.TracciamentoConnectionResult;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.Allegato;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.Busta;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.Eccezione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.IProtocolFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.Riscontro;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.Trasmissione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.tracciamento.ITracciamentoOpenSPCoopAppender;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.tracciamento.Traccia;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.tracciamento.TracciamentoException;
import it.link.pdd.tools.migrazione_govway.utils.TipiDatabase;
import it.link.pdd.tools.migrazione_govway.utils.jdbc.CustomKeyGeneratorObject;
import it.link.pdd.tools.migrazione_govway.utils.jdbc.InsertAndGeneratedKey;
import it.link.pdd.tools.migrazione_govway.utils.jdbc.InsertAndGeneratedKeyJDBCType;
import it.link.pdd.tools.migrazione_govway.utils.jdbc.InsertAndGeneratedKeyObject;
import it.link.pdd.tools.migrazione_govway.utils.jdbc.JDBCUtilities;
import it.link.pdd.tools.migrazione_govway.utils.resources.GestoreJNDI;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import javax.sql.DataSource;
import org.slf4j.Logger;

public class TracciamentoOpenSPCoopAppenderDB
implements ITracciamentoOpenSPCoopAppender {
    protected Properties appenderProperties;
    protected DataSource ds = null;
    protected String datasource = null;
    protected String connectionViaJDBC_url = null;
    protected String connectionViaJDBC_driverJDBC = null;
    protected String connectionViaJDBC_username = null;
    protected String connectionViaJDBC_password = null;
    protected boolean singleConnection = false;
    protected static Connection singleConnection_connection = null;
    protected static String singleConnection_source = null;
    protected String tipoDatabase = null;
    protected boolean openspcoopConnection = false;
    protected boolean addIdTransazione = false;
    protected boolean addGdoForAllTables = false;
    protected boolean debug = false;
    protected Logger log = null;
    protected IProtocolFactory protocolFactory;

    @Override
    public IProtocolFactory getProtocolFactory() {
        return this.protocolFactory;
    }

    public TracciamentoOpenSPCoopAppenderDB(IProtocolFactory factory) {
        this.log = factory.getLogger();
        this.protocolFactory = factory;
    }

    protected synchronized void initConnection(DataSource dsA, String dataSourceS) throws Exception {
        if (singleConnection_connection == null) {
            try {
                singleConnection_source = dataSourceS;
                singleConnection_connection = dsA.getConnection();
            }
            catch (Exception e) {
                throw new Exception("Inizializzazione single connection (via datasource) non riuscita", e);
            }
        }
    }

    protected synchronized void initConnection(String jdbcUrl, String jdbcDriver, String username, String password) throws Exception {
        if (singleConnection_connection == null) {
            try {
                singleConnection_source = "url:" + jdbcUrl + " driver:" + jdbcDriver + " username:" + username + " password:" + password;
                singleConnection_connection = username == null ? DriverManager.getConnection(jdbcUrl) : DriverManager.getConnection(jdbcUrl, username, password);
            }
            catch (Exception e) {
                throw new Exception("Inizializzazione single connection (via jdbc connection) non riuscita", e);
            }
        }
    }

    protected Connection getConnectionViaJDBC() throws SQLException {
        if (this.connectionViaJDBC_username == null) {
            return DriverManager.getConnection(this.connectionViaJDBC_url);
        }
        return DriverManager.getConnection(this.connectionViaJDBC_url, this.connectionViaJDBC_username, this.connectionViaJDBC_password);
    }

    /*
     * Unable to fully structure code
     */
    protected TracciamentoConnectionResult getConnection(Connection conOpenSPCoopPdD, String methodName) throws Exception {
        cr = new TracciamentoConnectionResult();
        cr.setReleaseConnection(false);
        con = null;
        if (this.debug) {
            this.log.info("@@ [" + methodName + "] SINGLE CONNECTION[" + this.singleConnection + "] OPEN[" + this.openspcoopConnection + "]");
        }
        if (!this.singleConnection) {
            if (this.openspcoopConnection && conOpenSPCoopPdD != null) {
                if (this.debug) {
                    this.log.info("@@ [" + methodName + "] GET_CONNECTION, USE CONNECTION OPENSPCOOP");
                }
                con = conOpenSPCoopPdD;
            } else if (this.ds != null) {
                try {
                    con = this.ds.getConnection();
                    if (con == null) {
                        throw new Exception("Connessione non fornita");
                    }
                    cr.setReleaseConnection(true);
                    if (!this.debug) ** GOTO lbl38
                    this.log.info("@@ [" + methodName + "] GET_CONNECTION, USE CONNECTION FROM DATASOURCE");
                }
                catch (Exception e) {
                    throw new Exception("Errore durante il recupero di una connessione dal datasource [" + this.datasource + "]: " + e.getMessage());
                }
            } else {
                try {
                    con = this.getConnectionViaJDBC();
                    if (con == null) {
                        throw new Exception("Connessione non fornita");
                    }
                    cr.setReleaseConnection(true);
                    if (!this.debug) ** GOTO lbl38
                    this.log.info("@@ [" + methodName + "] GET_CONNECTION, USE CONNECTION VIA JDBC");
                }
                catch (Exception e) {
                    throw new Exception("Errore durante il recupero di una connessione via jdbc url[" + this.connectionViaJDBC_url + "] driver[" + this.connectionViaJDBC_driverJDBC + "] username[" + this.connectionViaJDBC_username + "] password[" + this.connectionViaJDBC_password + "]: " + e.getMessage());
                }
            }
        } else {
            con = TracciamentoOpenSPCoopAppenderDB.singleConnection_connection;
            if (con == null) {
                throw new Exception("Connessione (singleConnection enabled) non fornita dalla sorgente [" + TracciamentoOpenSPCoopAppenderDB.singleConnection_source + "]");
            }
            if (this.debug) {
                this.log.info("@@ [" + methodName + "] GET_CONNECTION, SINGLE CONNECTION");
            }
        }
lbl38:
        // 8 sources

        cr.setConnection(con);
        return cr;
    }

    protected void releaseConnection(TracciamentoConnectionResult connectionResult, String methodName) throws SQLException {
        if (this.debug) {
            this.log.info("@@ [" + methodName + "] RELEASE_CONNECTION [" + connectionResult.isReleaseConnection() + "]?");
        }
        if (connectionResult.isReleaseConnection()) {
            if (this.debug) {
                this.log.info("@@ [" + methodName + "] RELEASE_CONNECTION effettuato");
            }
            connectionResult.getConnection().close();
        }
    }

    @Override
    public void initializeAppender(OpenspcoopAppender appenderProperties) throws TracciamentoException {
        try {
            String debug;
            String addGdoForAllTablesString;
            String addIdTransazioneString;
            this.appenderProperties = new Properties();
            if (appenderProperties.sizePropertyList() > 0) {
                String openspcoopConnectionString;
                for (int i = 0; i < appenderProperties.sizePropertyList(); ++i) {
                    this.appenderProperties.put(appenderProperties.getProperty(i).getNome(), appenderProperties.getProperty(i).getValore());
                }
                this.datasource = this.appenderProperties.getProperty("datasource");
                if (this.datasource == null) {
                    this.connectionViaJDBC_url = this.appenderProperties.getProperty("connectionUrl");
                    if (this.connectionViaJDBC_url == null) {
                        throw new TracciamentoException("Propriet\u00e0 'datasource' e 'connectionUrl' non definite (almeno una delle due \u00e8 obbligatoria)");
                    }
                }
                this.tipoDatabase = this.appenderProperties.getProperty("tipoDatabase");
                if (this.tipoDatabase == null) {
                    throw new TracciamentoException("Proprieta' 'tipoDatabase' non definita");
                }
                if (!TipiDatabase.isAMember(this.tipoDatabase)) {
                    throw new TracciamentoException("Proprieta' 'tipoDatabase' presenta un tipo [" + this.tipoDatabase + "] non supportato");
                }
                String singleConnectionString = this.appenderProperties.getProperty("singleConnection");
                if (singleConnectionString != null && "true".equals(singleConnectionString = singleConnectionString.trim())) {
                    this.singleConnection = true;
                }
                if ((openspcoopConnectionString = this.appenderProperties.getProperty("usePdDConnection")) != null && "true".equals(openspcoopConnectionString = openspcoopConnectionString.trim())) {
                    this.openspcoopConnection = true;
                }
            } else {
                throw new TracciamentoException("Propriet\u00e0 'datasource' e 'connectionUrl' non definite (almeno una delle due \u00e8 obbligatoria)");
            }
            if (this.datasource != null) {
                Properties ctx = new Properties();
                ctx = it.link.pdd.tools.migrazione_govway.utils.Utilities.readProperties("context-", this.appenderProperties);
                GestoreJNDI jndi = new GestoreJNDI(ctx);
                if (this.singleConnection) {
                    if (singleConnection_connection == null) {
                        DataSource ds = (DataSource)jndi.lookup(this.datasource);
                        this.initConnection(ds, this.datasource);
                    }
                } else {
                    this.ds = (DataSource)jndi.lookup(this.datasource);
                }
            }
            if (this.connectionViaJDBC_url != null) {
                this.connectionViaJDBC_driverJDBC = this.appenderProperties.getProperty("connectionDriver");
                if (this.connectionViaJDBC_driverJDBC == null) {
                    throw new TracciamentoException("Propriet\u00e0 'connectionDriver' non definita (obbligatoria nella modalita' 'connection via jdbc')");
                }
                this.connectionViaJDBC_username = this.appenderProperties.getProperty("connectionUsername");
                if (this.connectionViaJDBC_username != null) {
                    this.connectionViaJDBC_password = this.appenderProperties.getProperty("connectionPassword");
                    if (this.connectionViaJDBC_password == null) {
                        throw new TracciamentoException("Propriet\u00e0 'connectionPassword' non definita (obbligatoria nella modalita' 'connection via jdbc' se viene definita la proprieta' 'connectionUsername')");
                    }
                }
                Class.forName(this.connectionViaJDBC_driverJDBC);
                if (this.singleConnection && singleConnection_connection == null) {
                    this.initConnection(this.connectionViaJDBC_url, this.connectionViaJDBC_driverJDBC, this.connectionViaJDBC_username, this.connectionViaJDBC_password);
                }
            }
            if ((addIdTransazioneString = this.appenderProperties.getProperty("addIdTransazione")) != null && "true".equals(addIdTransazioneString = addIdTransazioneString.trim())) {
                this.addIdTransazione = true;
            }
            if ((addGdoForAllTablesString = this.appenderProperties.getProperty("addGdoForAllTables")) != null && "true".equals(addGdoForAllTablesString = addGdoForAllTablesString.trim())) {
                this.addGdoForAllTables = true;
            }
            if ((debug = this.appenderProperties.getProperty("debug")) != null && "true".equals(debug = debug.trim())) {
                this.debug = true;
            }
        }
        catch (Exception e) {
            throw new TracciamentoException("Errore durante l'inizializzazione dell'appender: " + e.getMessage(), e);
        }
    }

    @Override
    public void log(Connection conOpenSPCoopPdD, Traccia traccia) throws TracciamentoException {
        if (traccia == null) {
            throw new TracciamentoException("Errore durante il tracciamento: traccia is null");
        }
        Busta busta = traccia.getBusta();
        if (busta == null) {
            throw new TracciamentoException("Errore durante il tracciamento di un busta: busta is null");
        }
        Date gdo = traccia.getGdo();
        IDSoggetto idSoggetto = traccia.getIdSoggetto();
        String tipoMessaggio = traccia.getTipoMessaggio().getTipo();
        String location = traccia.getLocation();
        String idCorrelazioneApplicativa = traccia.getCorrelazioneApplicativa();
        String idCorrelazioneApplicativaRisposta = traccia.getCorrelazioneApplicativaRisposta();
        String idTransazione = traccia.getProperty("ID");
        if (this.debug) {
            this.log.debug("@@ log[" + busta.getID() + "] ....");
        }
        Statement stmt = null;
        ResultSet rs = null;
        Connection con = null;
        TracciamentoConnectionResult cr = null;
        try {
            String[] propertiesNames;
            int index;
            int i;
            long idtraccia;
            cr = this.getConnection(conOpenSPCoopPdD, "traccia.log");
            con = cr.getConnection();
            if (this.debug) {
                this.log.debug("@@ log[" + busta.getID() + "] (getConnection finished) ....");
            }
            if (!TipiDatabase.isAMember(this.tipoDatabase)) {
                throw new TracciamentoException("Tipo database [" + this.tipoDatabase + "] non supportato");
            }
            TipiDatabase tipo = TipiDatabase.toEnumConstant(this.tipoDatabase);
            Timestamp gdoT = new Timestamp(gdo.getTime());
            Timestamp oraRegistrazioneT = null;
            Timestamp scadenzaT = null;
            if (busta.getOraRegistrazione() != null) {
                oraRegistrazioneT = new Timestamp(busta.getOraRegistrazione().getTime());
            }
            if (busta.getScadenza() != null) {
                scadenzaT = new Timestamp(busta.getScadenza().getTime());
            }
            int confermaRicezione = -1;
            confermaRicezione = busta.isConfermaRicezione() ? 1 : 0;
            String headerProtocollo = null;
            if (traccia.getBustaAsElement() != null) {
                headerProtocollo = Utilities.toString(this.log, traccia.getBustaAsElement());
            } else if (traccia.getBustaAsString() != null) {
                headerProtocollo = traccia.getBustaAsString();
            } else if (traccia.getBustaAsByteArray() != null) {
                headerProtocollo = new String(traccia.getBustaAsByteArray());
            }
            if (this.debug) {
                this.log.debug("@@ log[" + busta.getID() + "] (prima inserimento traccia) ....");
            }
            ArrayList<InsertAndGeneratedKeyObject> listInsertAndGeneratedKeyObject = new ArrayList<InsertAndGeneratedKeyObject>();
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("gdo", gdoT, InsertAndGeneratedKeyJDBCType.TIMESTAMP));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("gdo_int", gdoT.getTime(), InsertAndGeneratedKeyJDBCType.LONG));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("pdd_codice", idSoggetto.getCodicePorta(), InsertAndGeneratedKeyJDBCType.STRING));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("pdd_tipo_soggetto", idSoggetto.getTipo(), InsertAndGeneratedKeyJDBCType.STRING));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("pdd_nome_soggetto", idSoggetto.getNome(), InsertAndGeneratedKeyJDBCType.STRING));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("pdd_ruolo", traccia.getTipoPdD().getTipo(), InsertAndGeneratedKeyJDBCType.STRING));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("tipo_messaggio", tipoMessaggio, InsertAndGeneratedKeyJDBCType.STRING));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("esito_elaborazione", traccia.getEsitoElaborazioneMessaggioTracciato().getEsito().toString(), InsertAndGeneratedKeyJDBCType.STRING));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("dettaglio_esito_elaborazione", traccia.getEsitoElaborazioneMessaggioTracciato().getDettaglio(), InsertAndGeneratedKeyJDBCType.STRING));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("idporta_mittente", busta.getIdentificativoPortaMittente(), InsertAndGeneratedKeyJDBCType.STRING));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("mittente", busta.getMittente(), InsertAndGeneratedKeyJDBCType.STRING));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("tipo_mittente", busta.getTipoMittente(), InsertAndGeneratedKeyJDBCType.STRING));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("indirizzo_mittente", busta.getIndirizzoMittente(), InsertAndGeneratedKeyJDBCType.STRING));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("idporta_destinatario", busta.getIdentificativoPortaDestinatario(), InsertAndGeneratedKeyJDBCType.STRING));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("destinatario", busta.getDestinatario(), InsertAndGeneratedKeyJDBCType.STRING));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("tipo_destinatario", busta.getTipoDestinatario(), InsertAndGeneratedKeyJDBCType.STRING));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("indirizzo_destinatario", busta.getIndirizzoDestinatario(), InsertAndGeneratedKeyJDBCType.STRING));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("profilo_collaborazione", busta.getProfiloDiCollaborazioneValue(), InsertAndGeneratedKeyJDBCType.STRING));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("profilo_collaborazione_meta", busta.getProfiloDiCollaborazione() == null ? null : busta.getProfiloDiCollaborazione().getEngineValue(), InsertAndGeneratedKeyJDBCType.STRING));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("servizio_correlato", busta.getServizioCorrelato(), InsertAndGeneratedKeyJDBCType.STRING));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("tipo_servizio_correlato", busta.getTipoServizioCorrelato(), InsertAndGeneratedKeyJDBCType.STRING));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("collaborazione", busta.getCollaborazione(), InsertAndGeneratedKeyJDBCType.STRING));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("versione_servizio", busta.getVersioneServizio(), InsertAndGeneratedKeyJDBCType.INT));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("servizio", busta.getServizio(), InsertAndGeneratedKeyJDBCType.STRING));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("tipo_servizio", busta.getTipoServizio(), InsertAndGeneratedKeyJDBCType.STRING));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("azione", busta.getAzione(), InsertAndGeneratedKeyJDBCType.STRING));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("id_messaggio", busta.getID(), InsertAndGeneratedKeyJDBCType.STRING));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("ora_registrazione", oraRegistrazioneT, InsertAndGeneratedKeyJDBCType.TIMESTAMP));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("tipo_ora_reg", busta.getTipoOraRegistrazioneValue(), InsertAndGeneratedKeyJDBCType.STRING));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("tipo_ora_reg_meta", busta.getTipoOraRegistrazione() == null ? null : busta.getTipoOraRegistrazione().getEngineValue(), InsertAndGeneratedKeyJDBCType.STRING));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("rif_messaggio", busta.getRiferimentoMessaggio(), InsertAndGeneratedKeyJDBCType.STRING));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("scadenza", scadenzaT, InsertAndGeneratedKeyJDBCType.TIMESTAMP));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("inoltro", busta.getInoltroValue(), InsertAndGeneratedKeyJDBCType.STRING));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("inoltro_meta", busta.getInoltro() == null ? null : busta.getInoltro().getEngineValue(), InsertAndGeneratedKeyJDBCType.STRING));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("conferma_ricezione", confermaRicezione, InsertAndGeneratedKeyJDBCType.INT));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("sequenza", busta.getSequenza(), InsertAndGeneratedKeyJDBCType.LONG));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("location", location, InsertAndGeneratedKeyJDBCType.STRING));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("correlazione_applicativa", idCorrelazioneApplicativa, InsertAndGeneratedKeyJDBCType.STRING));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("correlazione_risposta", idCorrelazioneApplicativaRisposta, InsertAndGeneratedKeyJDBCType.STRING));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("sa_fruitore", busta.getServizioApplicativoFruitore(), InsertAndGeneratedKeyJDBCType.STRING));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("sa_erogatore", busta.getServizioApplicativoErogatore(), InsertAndGeneratedKeyJDBCType.STRING));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("protocollo", traccia.getProtocollo(), InsertAndGeneratedKeyJDBCType.STRING));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("digest", busta.getDigest(), InsertAndGeneratedKeyJDBCType.STRING));
            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("soap_element", headerProtocollo, InsertAndGeneratedKeyJDBCType.STRING));
            if (this.addIdTransazione) {
                listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("id_transazione", idTransazione, InsertAndGeneratedKeyJDBCType.STRING));
            }
            if ((idtraccia = InsertAndGeneratedKey.insertAndReturnGeneratedKey(con, tipo, new CustomKeyGeneratorObject("tracce", "id", "seq_tracce", "tracce_init_seq"), listInsertAndGeneratedKeyObject.toArray(new InsertAndGeneratedKeyObject[1]))) <= 0L) {
                throw new Exception("ID autoincrementale non ottenuto");
            }
            traccia.setId(idtraccia);
            if (this.debug) {
                this.log.debug("@@ log[" + busta.getID() + "] (traccia inserita) ....");
            }
            String gdoColumnName = "";
            String gdoColumnValue = "";
            if (this.addGdoForAllTables) {
                gdoColumnName = " , gdo";
                gdoColumnValue = " , ?";
            }
            String sqlString = null;
            if (this.debug) {
                this.log.debug("@@ log[" + busta.getID() + "] (inserimento " + busta.sizeListaRiscontri() + " riscontri) ....");
            }
            for (i = 0; i < busta.sizeListaRiscontri(); ++i) {
                Riscontro riscontro = busta.getRiscontro(i);
                sqlString = "INSERT INTO tracce_riscontri (idtraccia, riscontro, ora_registrazione, tipo_ora_reg, tipo_ora_reg_meta" + gdoColumnName + ") VALUES (?, ?, ?, ?, ?" + gdoColumnValue + ")";
                stmt = con.prepareStatement(sqlString);
                index = 1;
                stmt.setLong(index++, idtraccia);
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, index++, riscontro.getID());
                if (riscontro.getOraRegistrazione() != null) {
                    stmt.setTimestamp(index++, new Timestamp(riscontro.getOraRegistrazione().getTime()));
                } else {
                    stmt.setTimestamp(index++, null);
                }
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, index++, riscontro.getTipoOraRegistrazioneValue(this.protocolFactory));
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, index++, riscontro.getTipoOraRegistrazione().getEngineValue());
                if (this.addGdoForAllTables) {
                    stmt.setTimestamp(index++, gdoT);
                }
                stmt.executeUpdate();
                stmt.close();
            }
            if (this.debug) {
                this.log.debug("@@ log[" + busta.getID() + "] (inserimento " + busta.sizeListaRiscontri() + " riscontri effettuato) ....");
            }
            if (this.debug) {
                this.log.debug("@@ log[" + busta.getID() + "] (inserimento " + busta.sizeListaTrasmissioni() + " trasmissioni) ....");
            }
            for (i = 0; i < busta.sizeListaTrasmissioni(); ++i) {
                Trasmissione trasmissione = busta.getTrasmissione(i);
                sqlString = "INSERT INTO tracce_trasmissioni (idtraccia, origine, tipo_origine, indirizzo_origine, idporta_origine , destinazione, tipo_destinazione, indirizzo_destinazione, idporta_destinazione, ora_registrazione, tipo_ora_reg, tipo_ora_reg_meta" + gdoColumnName + ") VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?" + gdoColumnValue + ")";
                stmt = con.prepareStatement(sqlString);
                index = 1;
                stmt.setLong(index++, idtraccia);
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, index++, trasmissione.getOrigine());
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, index++, trasmissione.getTipoOrigine());
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, index++, trasmissione.getIndirizzoOrigine());
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, index++, trasmissione.getIdentificativoPortaOrigine());
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, index++, trasmissione.getDestinazione());
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, index++, trasmissione.getTipoDestinazione());
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, index++, trasmissione.getIndirizzoDestinazione());
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, index++, trasmissione.getIdentificativoPortaDestinazione());
                if (trasmissione.getOraRegistrazione() != null) {
                    stmt.setTimestamp(index++, new Timestamp(trasmissione.getOraRegistrazione().getTime()));
                } else {
                    stmt.setTimestamp(index++, null);
                }
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, index++, trasmissione.getTempoValue(this.protocolFactory));
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, index++, trasmissione.getTempo().getEngineValue());
                if (this.addGdoForAllTables) {
                    stmt.setTimestamp(index++, gdoT);
                }
                stmt.executeUpdate();
                stmt.close();
            }
            if (this.debug) {
                this.log.debug("@@ log[" + busta.getID() + "] (inserimento " + busta.sizeListaTrasmissioni() + " trasmissioni effettuato) ....");
            }
            if (this.debug) {
                this.log.debug("@@ log[" + busta.getID() + "] (inserimento " + busta.sizeListaEccezioni() + " eccezioni) ....");
            }
            for (i = 0; i < busta.sizeListaEccezioni(); ++i) {
                Eccezione eccezione = busta.getEccezione(i);
                String subCodiceMeta = "";
                String subCodiceMetaInsert = "";
                if (eccezione.getSubCodiceEccezione() != null && eccezione.getSubCodiceEccezione().getSubCodice() != null) {
                    subCodiceMeta = "subcodice_eccezione_meta,";
                    subCodiceMetaInsert = "?,";
                }
                sqlString = "INSERT INTO tracce_eccezioni (idtraccia, contesto_codifica, contesto_codifica_meta, codice_eccezione, codice_eccezione_meta, " + subCodiceMeta + " rilevanza, rilevanza_meta, posizione" + gdoColumnName + ") VALUES (?, ?, ?, ?, ?, " + subCodiceMetaInsert + " ?, ? , ? " + gdoColumnValue + ")";
                stmt = con.prepareStatement(sqlString);
                int index2 = 1;
                stmt.setLong(index2++, idtraccia);
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, index2++, eccezione.getContestoCodificaValue(this.protocolFactory));
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, index2++, eccezione.getContestoCodifica().getEngineValue());
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, index2++, eccezione.getCodiceEccezioneValue(this.protocolFactory));
                stmt.setInt(index2++, eccezione.getCodiceEccezione().getCodice());
                if (eccezione.getSubCodiceEccezione() != null && eccezione.getSubCodiceEccezione().getSubCodice() != null) {
                    stmt.setInt(index2++, eccezione.getSubCodiceEccezione().getSubCodice());
                }
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, index2++, eccezione.getRilevanzaValue(this.protocolFactory));
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, index2++, eccezione.getRilevanza().getEngineValue());
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, index2++, eccezione.getDescrizione(this.protocolFactory));
                if (this.addGdoForAllTables) {
                    stmt.setTimestamp(index2++, gdoT);
                }
                stmt.executeUpdate();
                stmt.close();
            }
            if (this.debug) {
                this.log.debug("@@ log[" + busta.getID() + "] (inserimento " + busta.sizeListaEccezioni() + " eccezioni effettuato) ....");
            }
            if (this.debug) {
                this.log.debug("@@ log[" + busta.getID() + "] (inserimento " + traccia.sizeListaAllegati() + " allegati) ....");
            }
            for (i = 0; i < traccia.sizeListaAllegati(); ++i) {
                Allegato allegato = traccia.getAllegato(i);
                sqlString = "INSERT INTO tracce_allegati (idtraccia, content_id, content_location, content_type, digest" + gdoColumnName + ") VALUES (?, ?, ?, ?, ?" + gdoColumnValue + ")";
                stmt = con.prepareStatement(sqlString);
                int index3 = 1;
                stmt.setLong(index3++, idtraccia);
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, index3++, allegato.getContentId());
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, index3++, allegato.getContentLocation());
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, index3++, allegato.getContentType());
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, index3++, allegato.getDigest());
                if (this.addGdoForAllTables) {
                    stmt.setTimestamp(index3++, gdoT);
                }
                stmt.executeUpdate();
                stmt.close();
            }
            if (this.debug) {
                this.log.debug("@@ log[" + busta.getID() + "] (inserimento " + traccia.sizeListaAllegati() + " allegati effettuato) ....");
            }
            if ((propertiesNames = busta.getPropertiesNames()) != null) {
                if (this.debug) {
                    this.log.debug("@@ log[" + busta.getID() + "] (inserimento " + propertiesNames.length + " ext-protocol-info) ....");
                }
                for (int i2 = 0; i2 < propertiesNames.length; ++i2) {
                    sqlString = "INSERT INTO tracce_ext_protocol_info (idtraccia, name, value" + gdoColumnName + ") VALUES (?, ?, ?" + gdoColumnValue + ")";
                    stmt = con.prepareStatement(sqlString);
                    int index4 = 1;
                    stmt.setLong(index4++, idtraccia);
                    JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, index4++, propertiesNames[i2]);
                    JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, index4++, busta.getProperty(propertiesNames[i2]));
                    if (this.addGdoForAllTables) {
                        stmt.setTimestamp(index4++, gdoT);
                    }
                    stmt.executeUpdate();
                    stmt.close();
                }
                if (this.debug) {
                    this.log.debug("@@ log[" + busta.getID() + "] (inserimento " + propertiesNames.length + " effettuato) ....");
                }
            }
            if (this.debug) {
                this.log.debug("@@ log[" + busta.getID() + "] completato");
            }
        }
        catch (Exception e) {
            throw new TracciamentoException("Errore durante il tracciamento di una busta: " + e.getMessage() + "\nL'id del messaggio della busta era: " + busta.getID(), e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                this.releaseConnection(cr, "traccia.log");
            }
            catch (Exception exception) {}
        }
    }

    public String getTipoDatabase() {
        return this.tipoDatabase;
    }

    public void setTipoDatabase(String tipoDatabase) {
        this.tipoDatabase = tipoDatabase;
    }

    @Override
    public void isAlive() throws CoreException {
        Connection con = null;
        Statement stmtTest = null;
        TracciamentoConnectionResult cr = null;
        try {
            cr = this.getConnection(null, "traccia.isAlive");
            con = cr.getConnection();
            stmtTest = con.createStatement();
            stmtTest.execute("SELECT * from db_info");
        }
        catch (Exception e) {
            throw new CoreException("Connessione al database Tracciamento non disponibile: " + e.getMessage(), e);
        }
        finally {
            try {
                if (stmtTest != null) {
                    stmtTest.close();
                }
            }
            catch (Exception exception) {}
            try {
                this.releaseConnection(cr, "traccia.isAlive");
            }
            catch (Exception exception) {}
        }
    }
}

