/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.basic.tracciamento;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.basic.ProtocolliRegistrati;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.basic.tracciamento.DriverTracciamentoUtilities;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.IProtocolFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.TipoTraccia;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.tracciamento.DriverTracciamentoException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.tracciamento.DriverTracciamentoNotFoundException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.tracciamento.FiltroRicercaTracce;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.tracciamento.FiltroRicercaTracceConPaginazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.tracciamento.IDriverTracciamento;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.tracciamento.Traccia;
import it.link.pdd.tools.migrazione_govway.utils.LoggerWrapperFactory;
import it.link.pdd.tools.migrazione_govway.utils.StringWrapper;
import it.link.pdd.tools.migrazione_govway.utils.TipiDatabase;
import it.link.pdd.tools.migrazione_govway.utils.resources.GestoreJNDI;
import it.link.pdd.tools.migrazione_govway.utils.sql.ISQLQueryObject;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.sql.DataSource;
import org.slf4j.Logger;

public class DriverTracciamento
implements IDriverTracciamento {
    DataSource datasource = null;
    Connection connection = null;
    boolean connectionOpenViaJDBCInCostructor = false;
    String tipoDatabase = null;
    private Logger log = null;
    public static final String IDTRACCIA = "@@@@@-----@@@@-----IDTRACCIA-DB----@@@@@-----@@@@";
    private Vector<String> properties;
    protected IProtocolFactory protocolFactory;
    private ProtocolliRegistrati protocolliRegistrati;

    public void setProperties(Vector<String> properties) {
        this.properties = properties;
    }

    public DriverTracciamento(IProtocolFactory factory) {
        this.log = factory.getLogger();
        this.protocolFactory = factory;
    }

    @Override
    public IProtocolFactory getProtocolFactory() {
        return this.protocolFactory;
    }

    public void init(ProtocolliRegistrati protocolliRegistrati, String nomeDataSource, String tipoDatabase, Properties jndiContext) throws DriverTracciamentoException {
        this.init(protocolliRegistrati, nomeDataSource, tipoDatabase, jndiContext, null);
    }

    public void init(ProtocolliRegistrati protocolliRegistrati, String nomeDataSource, String tipoDatabase, Properties jndiContext, Logger log) throws DriverTracciamentoException {
        this.protocolliRegistrati = protocolliRegistrati;
        try {
            this.log = log == null ? LoggerWrapperFactory.getLogger("DRIVER_DB_LOGANALIZER") : log;
        }
        catch (Exception e) {
            throw new DriverTracciamentoException("Errore durante l'inizializzazione del logger...", e);
        }
        try {
            this.log.info("Inizializzo DriverLogAnalyzer...");
            GestoreJNDI gestoreJNDI = new GestoreJNDI(jndiContext);
            this.datasource = (DataSource)gestoreJNDI.lookup(nomeDataSource);
            if (this.datasource == null) {
                throw new Exception("datasource is null");
            }
            this.log.info("Inizializzo DriverLogAnalyzer terminata.");
        }
        catch (Exception e) {
            this.log.error("Errore durante la ricerca del datasource...", (Throwable)e);
            throw new DriverTracciamentoException("Errore durante la ricerca del datasource...", e);
        }
        try {
            this.log.info("Inizializzo ISQLQueryObject...");
            if (!TipiDatabase.isAMember(tipoDatabase)) {
                throw new Exception("Tipo database non gestito");
            }
            this.tipoDatabase = tipoDatabase;
            this.log.info("Inizializzo ISQLQueryObject terminata.");
        }
        catch (Exception e) {
            this.log.error("Errore durante la ricerca del SQLQueryObject...", (Throwable)e);
            throw new DriverTracciamentoException("Errore durante la ricerca del SQLQueryObject...", e);
        }
    }

    public void init(ProtocolliRegistrati protocolliRegistrati, DataSource dataSourceObject, String tipoDatabase) throws DriverTracciamentoException {
        this.init(protocolliRegistrati, dataSourceObject, tipoDatabase, null);
    }

    public void init(ProtocolliRegistrati protocolliRegistrati, DataSource dataSourceObject, String tipoDatabase, Logger log) throws DriverTracciamentoException {
        this.protocolliRegistrati = protocolliRegistrati;
        try {
            this.log = log == null ? LoggerWrapperFactory.getLogger("DRIVER_DB_LOGANALIZER") : log;
        }
        catch (Exception e) {
            throw new DriverTracciamentoException("Errore durante l'inizializzazione del logger...", e);
        }
        try {
            this.datasource = dataSourceObject;
            if (this.datasource == null) {
                throw new Exception("datasource is null");
            }
        }
        catch (Exception e) {
            this.log.error("Errore durante la ricerca del datasource...", (Throwable)e);
            throw new DriverTracciamentoException("Errore durante la ricerca del datasource...", e);
        }
        try {
            this.log.info("Inizializzo ISQLQueryObject...");
            if (!TipiDatabase.isAMember(tipoDatabase)) {
                throw new Exception("Tipo database non gestito");
            }
            this.tipoDatabase = tipoDatabase;
            this.log.info("Inizializzo ISQLQueryObject terminata.");
        }
        catch (Exception e) {
            this.log.error("Errore durante la ricerca del SQLQueryObject...", (Throwable)e);
            throw new DriverTracciamentoException("Errore durante la ricerca del SQLQueryObject...", e);
        }
    }

    public void init(ProtocolliRegistrati protocolliRegistrati, Connection connection, String tipoDatabase, Logger log) throws DriverTracciamentoException {
        this.protocolliRegistrati = protocolliRegistrati;
        try {
            this.log = log;
        }
        catch (Exception e) {
            throw new DriverTracciamentoException("Errore durante l'inizializzazione del logger...", e);
        }
        this.connection = connection;
        try {
            this.log.info("Inizializzo ISQLQueryObject...");
            if (!TipiDatabase.isAMember(tipoDatabase)) {
                throw new Exception("Tipo database non gestito");
            }
            this.tipoDatabase = tipoDatabase;
            this.log.info("Inizializzo ISQLQueryObject terminata.");
        }
        catch (Exception e) {
            this.log.error("Errore durante la ricerca del SQLQueryObject...", (Throwable)e);
            throw new DriverTracciamentoException("Errore durante la ricerca del SQLQueryObject...", e);
        }
    }

    public void init(ProtocolliRegistrati protocolliRegistrati, String urlJDBC, String driverJDBC, String username, String password, String tipoDatabase, Logger log) throws DriverTracciamentoException {
        this.protocolliRegistrati = protocolliRegistrati;
        try {
            this.log = log;
        }
        catch (Exception e) {
            throw new DriverTracciamentoException("Errore durante l'inizializzazione del logger...", e);
        }
        try {
            Class.forName(driverJDBC);
            this.connection = username != null ? DriverManager.getConnection(urlJDBC, username, password) : DriverManager.getConnection(urlJDBC);
            this.connectionOpenViaJDBCInCostructor = true;
        }
        catch (Exception e) {
            this.log.error("Errore durante l'inizializzazione della connessione...", (Throwable)e);
            throw new DriverTracciamentoException("Errore durante l'inizializzazione della connessione...", e);
        }
        try {
            this.log.info("Inizializzo ISQLQueryObject...");
            if (!TipiDatabase.isAMember(tipoDatabase)) {
                throw new Exception("Tipo database non gestito");
            }
            this.tipoDatabase = tipoDatabase;
            this.log.info("Inizializzo ISQLQueryObject terminata.");
        }
        catch (Exception e) {
            this.log.error("Errore durante la ricerca del SQLQueryObject...", (Throwable)e);
            throw new DriverTracciamentoException("Errore durante la ricerca del SQLQueryObject...", e);
        }
    }

    @Override
    public int countTracce(FiltroRicercaTracce filtro) throws DriverTracciamentoException {
        Connection connectionDB = null;
        Statement pstmt = null;
        ResultSet rs = null;
        int contatore = 0;
        try {
            if (this.connection != null) {
                connectionDB = this.connection;
            } else {
                connectionDB = this.datasource.getConnection();
                if (connectionDB == null) {
                    throw new Exception("Connection non ottenuta dal datasource[" + this.datasource + "]");
                }
            }
            ISQLQueryObject sqlQueryObject = DriverTracciamentoUtilities.createSQLQueryObj_countTracce(filtro, this.tipoDatabase);
            String sql = sqlQueryObject.createSQLQuery();
            StringWrapper sqlDebug = new StringWrapper(sqlQueryObject.createSQLQuery());
            DriverTracciamentoUtilities.setValuesSearch(sqlDebug, filtro, 1);
            this.log.debug("Query: " + sqlDebug);
            pstmt = connectionDB.prepareStatement(sql);
            DriverTracciamentoUtilities.setValuesSearch(pstmt, filtro, 1);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                contatore = rs.getInt("countTracce");
            }
            rs.close();
            pstmt.close();
            this.log.debug("Query found " + contatore + " rows");
            int n = contatore;
            return n;
        }
        catch (Exception e) {
            throw new DriverTracciamentoException("Tracciamento exception: " + e.getMessage(), e);
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception exception) {}
            try {
                pstmt.close();
            }
            catch (Exception exception) {}
            try {
                if (this.connection == null) {
                    connectionDB.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public List<Traccia> getTracce(FiltroRicercaTracceConPaginazione filtro) throws DriverTracciamentoException, DriverTracciamentoNotFoundException {
        Connection connectionDB = null;
        Statement pstmt = null;
        ResultSet rs = null;
        ArrayList<Traccia> tracce = new ArrayList<Traccia>();
        try {
            if (this.connection != null) {
                connectionDB = this.connection;
            } else {
                connectionDB = this.datasource.getConnection();
                if (connectionDB == null) {
                    throw new Exception("Connection non ottenuta dal datasource[" + this.datasource + "]");
                }
            }
            ISQLQueryObject sqlQueryObject = DriverTracciamentoUtilities.createSQLQueryObj_searchTracce(filtro, this.tipoDatabase);
            String sql = sqlQueryObject.createSQLQuery();
            StringWrapper sqlDebug = new StringWrapper(sqlQueryObject.createSQLQuery());
            DriverTracciamentoUtilities.setValuesSearch(sqlDebug, filtro, 1);
            this.log.debug("Query: " + sqlDebug);
            pstmt = connectionDB.prepareStatement(sql);
            DriverTracciamentoUtilities.setValuesSearch(pstmt, filtro, 1);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                Long idTraccia = rs.getLong("idTraccia");
                Traccia traccia = DriverTracciamentoUtilities.getTraccia(connectionDB, this.tipoDatabase, this.log, idTraccia, this.properties, this.protocolliRegistrati);
                tracce.add(traccia);
            }
            rs.close();
            pstmt.close();
            this.log.debug("Query found " + tracce.size() + " rows");
            if (tracce.size() > 0) {
                ArrayList<Traccia> arrayList = tracce;
                return arrayList;
            }
            try {
                throw new DriverTracciamentoNotFoundException("Non sono state trovate tracce che rispettano i criteri di ricerca impostati");
            }
            catch (DriverTracciamentoNotFoundException e) {
                throw e;
            }
            catch (Exception e) {
                throw new DriverTracciamentoException("Tracciamento exception: " + e.getMessage(), e);
            }
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception exception) {}
            try {
                pstmt.close();
            }
            catch (Exception exception) {}
            try {
                if (this.connection == null) {
                    connectionDB.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public int deleteTracce(FiltroRicercaTracce filtro) throws DriverTracciamentoException {
        int deleted = 0;
        Connection con = this.getConnection();
        Statement stmt = null;
        try {
            ISQLQueryObject sqlQueryObject = DriverTracciamentoUtilities.createSQLQueryObj_deleteTracce(filtro, this.tipoDatabase);
            String sql = sqlQueryObject.createSQLDelete();
            StringWrapper sqlDebug = new StringWrapper(sqlQueryObject.createSQLDelete());
            DriverTracciamentoUtilities.setValuesSearch(sqlDebug, filtro, 1);
            this.log.debug("Delete: " + sqlDebug);
            stmt = con.prepareStatement(sql);
            DriverTracciamentoUtilities.setValuesSearch(stmt, filtro, 1);
            deleted = stmt.executeUpdate();
            this.log.debug("Deleted " + deleted + " rows");
            int n = deleted;
            return n;
        }
        catch (Exception e) {
            throw new DriverTracciamentoException(e);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
            this.releaseConnection(con);
            this.log.debug("Tracce Eliminate: " + deleted);
        }
    }

    @Override
    public Traccia getTraccia(String idBusta, IDSoggetto codicePorta) throws DriverTracciamentoException, DriverTracciamentoNotFoundException {
        return this.getTraccia_engine(idBusta, codicePorta, false);
    }

    @Override
    public Traccia getTraccia(String idBusta, IDSoggetto codicePorta, boolean ricercaIdBustaComeRiferimentoMessaggio) throws DriverTracciamentoException, DriverTracciamentoNotFoundException {
        return this.getTraccia_engine(idBusta, codicePorta, ricercaIdBustaComeRiferimentoMessaggio);
    }

    private Traccia getTraccia_engine(String idBusta, IDSoggetto codicePorta, boolean rifMsg) throws DriverTracciamentoException, DriverTracciamentoNotFoundException {
        Connection connectionDB = null;
        Statement pstmt = null;
        ResultSet rs = null;
        Traccia tr = null;
        try {
            if (this.connection != null) {
                connectionDB = this.connection;
            } else {
                connectionDB = this.datasource.getConnection();
                if (connectionDB == null) {
                    throw new Exception("Connection non ottenuta dal datasource[" + this.datasource + "]");
                }
            }
            ISQLQueryObject sqlQueryObject = DriverTracciamentoUtilities.getSQLQueryObject(this.tipoDatabase);
            sqlQueryObject.addFromTable("tracce");
            sqlQueryObject.addSelectField("id");
            if (rifMsg) {
                sqlQueryObject.addWhereCondition("rif_messaggio=?");
            } else {
                sqlQueryObject.addWhereCondition("id_messaggio=?");
            }
            if (DriverTracciamentoUtilities.isDefined(codicePorta)) {
                if (DriverTracciamentoUtilities.isDefined(codicePorta.getCodicePorta())) {
                    sqlQueryObject.addWhereCondition("pdd_codice=?");
                }
                if (DriverTracciamentoUtilities.isDefined(codicePorta.getTipo())) {
                    sqlQueryObject.addWhereCondition("pdd_tipo_soggetto=?");
                }
                if (DriverTracciamentoUtilities.isDefined(codicePorta.getNome())) {
                    sqlQueryObject.addWhereCondition("pdd_nome_soggetto=?");
                }
            }
            sqlQueryObject.setANDLogicOperator(true);
            pstmt = connectionDB.prepareStatement(sqlQueryObject.toString());
            int index = 1;
            pstmt.setString(index++, idBusta);
            if (DriverTracciamentoUtilities.isDefined(codicePorta)) {
                if (DriverTracciamentoUtilities.isDefined(codicePorta.getCodicePorta())) {
                    pstmt.setString(index++, codicePorta.getCodicePorta());
                }
                if (DriverTracciamentoUtilities.isDefined(codicePorta.getTipo())) {
                    pstmt.setString(index++, codicePorta.getTipo());
                }
                if (DriverTracciamentoUtilities.isDefined(codicePorta.getNome())) {
                    pstmt.setString(index++, codicePorta.getNome());
                }
            }
            if ((rs = pstmt.executeQuery()).next()) {
                Long idTraccia = rs.getLong("id");
                tr = DriverTracciamentoUtilities.getTraccia(connectionDB, this.tipoDatabase, this.log, idTraccia, this.properties, this.protocolliRegistrati);
            }
            rs.close();
            pstmt.close();
            if (tr == null) {
                throw new DriverTracciamentoNotFoundException("Traccia non trovata (idBusta:" + idBusta + ") (dominio-porta:" + codicePorta + ") (rifmsg:" + rifMsg + ")");
            }
            Traccia traccia = tr;
            return traccia;
        }
        catch (DriverTracciamentoNotFoundException d) {
            throw d;
        }
        catch (Exception e) {
            throw new DriverTracciamentoException("Tracciamento exception: " + e.getMessage(), e);
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception exception) {}
            try {
                pstmt.close();
            }
            catch (Exception exception) {}
            try {
                if (this.connection == null) {
                    connectionDB.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public Traccia getTraccia(TipoTraccia tipoTraccia, Hashtable<String, String> propertiesRicerca) throws DriverTracciamentoException, DriverTracciamentoNotFoundException {
        Connection connectionDB = null;
        Statement pstmt = null;
        ResultSet rs = null;
        Traccia tr = null;
        try {
            if (this.connection != null) {
                connectionDB = this.connection;
            } else {
                connectionDB = this.datasource.getConnection();
                if (connectionDB == null) {
                    throw new Exception("Connection non ottenuta dal datasource[" + this.datasource + "]");
                }
            }
            ISQLQueryObject sqlQueryObject = DriverTracciamentoUtilities.getSQLQueryObject(this.tipoDatabase);
            sqlQueryObject.addFromTable("tracce");
            sqlQueryObject.addSelectField("id");
            if (propertiesRicerca != null && propertiesRicerca.size() > 0) {
                Enumeration<String> keys = propertiesRicerca.keys();
                while (keys.hasMoreElements()) {
                    String key = keys.nextElement();
                    if (IDTRACCIA.equals(key)) {
                        sqlQueryObject.addWhereCondition("id=?");
                        continue;
                    }
                    sqlQueryObject.addWhereCondition(key + "=?");
                }
            } else {
                throw new Exception("Properties di ricerca non fornite");
            }
            sqlQueryObject.addWhereCondition("tipo_messaggio=?");
            sqlQueryObject.setANDLogicOperator(true);
            pstmt = connectionDB.prepareStatement(sqlQueryObject.toString());
            int index = 1;
            Enumeration<String> keys = propertiesRicerca.keys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                String value = propertiesRicerca.get(key);
                if (IDTRACCIA.equals(key)) {
                    pstmt.setLong(index, Long.parseLong(value));
                } else {
                    pstmt.setString(index, value);
                }
                ++index;
            }
            pstmt.setString(index, tipoTraccia.toString());
            rs = pstmt.executeQuery();
            if (rs.next()) {
                Long idTraccia = rs.getLong("id");
                tr = DriverTracciamentoUtilities.getTraccia(connectionDB, this.tipoDatabase, this.log, idTraccia, this.properties, this.protocolliRegistrati);
            }
            rs.close();
            pstmt.close();
            if (tr == null) {
                throw new DriverTracciamentoNotFoundException("Traccia non trovata (sizeProperties:" + propertiesRicerca.size() + ") (tipo:" + tipoTraccia + ")");
            }
            Traccia traccia = tr;
            return traccia;
        }
        catch (DriverTracciamentoNotFoundException d) {
            throw d;
        }
        catch (Exception e) {
            throw new DriverTracciamentoException("Tracciamento exception: " + e.getMessage(), e);
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception exception) {}
            try {
                pstmt.close();
            }
            catch (Exception exception) {}
            try {
                if (this.connection == null) {
                    connectionDB.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void close() throws DriverTracciamentoException {
        try {
            if (this.connectionOpenViaJDBCInCostructor && this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
            }
        }
        catch (Exception e) {
            throw new DriverTracciamentoException(e.getMessage(), e);
        }
    }

    public Connection getConnection() {
        if (this.datasource == null) {
            return null;
        }
        Connection connectionDB = null;
        try {
            connectionDB = this.datasource.getConnection();
        }
        catch (Exception e) {
            return null;
        }
        return connectionDB;
    }

    public void releaseConnection(Connection connectionDB) {
        try {
            if (connectionDB != null) {
                connectionDB.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public String getTipoDatabase() {
        return this.tipoDatabase;
    }
}

