/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.basic.diagnostica;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.XMLUtils;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.basic.diagnostica.XMLDiagnosticoRootElement;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.IProtocolFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.ProtocolException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.XMLRootElement;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.diagnostica.IXMLDiagnosticoBuilder;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.diagnostica.MsgDiagnostico;
import org.slf4j.Logger;
import org.w3c.dom.Element;

public class XMLDiagnosticoBuilder
implements IXMLDiagnosticoBuilder {
    protected XMLUtils xmlUtils;
    protected Logger log;
    protected IProtocolFactory factory;

    @Override
    public IProtocolFactory getProtocolFactory() {
        return this.factory;
    }

    public XMLDiagnosticoBuilder(IProtocolFactory protocolFactory) {
        this.log = protocolFactory.getLogger();
        this.factory = protocolFactory;
        this.xmlUtils = XMLUtils.getInstance();
    }

    @Override
    public Element toElement(MsgDiagnostico msgDiag) throws ProtocolException {
        String tmpId = null;
        try {
            Element diagnostico;
            if (msgDiag.sizeProperties() > 0) {
                tmpId = msgDiag.removeProperty("@@@@@-----@@@@-----IDDIAGNOSTICI-DB----@@@@@-----@@@@");
            }
            byte[] xmlDiagnostico = it.link.pdd.tools.migrazione_govway.openspcoop2_core.diagnostica.utils.XMLUtils.generateMessaggioDiagnostico(msgDiag.getMessaggioDiagnostico());
            Element element = diagnostico = this.xmlUtils.newElement(xmlDiagnostico);
            return element;
        }
        catch (Exception e) {
            this.log.error("XMLBuilder.buildElement_Diagnostico error: " + e.getMessage(), (Throwable)e);
            throw new ProtocolException("XMLBuilder.buildElement_Diagnostico error: " + e.getMessage(), e);
        }
        finally {
            if (tmpId != null && msgDiag != null) {
                msgDiag.addProperty("@@@@@-----@@@@-----IDDIAGNOSTICI-DB----@@@@@-----@@@@", tmpId);
            }
        }
    }

    @Override
    public String toString(MsgDiagnostico msgDiag) throws ProtocolException {
        Element diagnostico = this.toElement(msgDiag);
        if (diagnostico == null) {
            throw new ProtocolException("Conversione in element non riuscita");
        }
        try {
            String xml = this.xmlUtils.toString(diagnostico, true);
            if (xml == null) {
                throw new Exception("Conversione in stringa non riuscita");
            }
            return xml;
        }
        catch (ProtocolException pe) {
            throw pe;
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
    }

    @Override
    public byte[] toByteArray(MsgDiagnostico msgDiag) throws ProtocolException {
        Element diagnostico = this.toElement(msgDiag);
        if (diagnostico == null) {
            throw new ProtocolException("Conversione in element non riuscita");
        }
        try {
            byte[] xml = this.xmlUtils.toByteArray(diagnostico, true);
            if (xml == null) {
                throw new ProtocolException("Conversione in bytes non riuscita");
            }
            return xml;
        }
        catch (ProtocolException pe) {
            throw pe;
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
    }

    @Override
    public XMLRootElement getXMLRootElement() throws ProtocolException {
        return new XMLDiagnosticoRootElement();
    }
}

