/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.basic.diagnostica;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.commons.CoreException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.OpenspcoopAppender;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDServizio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.basic.diagnostica.MsgDiagnosticoConnectionResult;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.IProtocolFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.config.IProtocolConfiguration;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.diagnostica.IMsgDiagnosticoOpenSPCoopAppender;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.diagnostica.MsgDiagnostico;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.diagnostica.MsgDiagnosticoCorrelazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.diagnostica.MsgDiagnosticoCorrelazioneApplicativa;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.diagnostica.MsgDiagnosticoCorrelazioneServizioApplicativo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.diagnostica.MsgDiagnosticoException;
import it.link.pdd.tools.migrazione_govway.utils.TipiDatabase;
import it.link.pdd.tools.migrazione_govway.utils.Utilities;
import it.link.pdd.tools.migrazione_govway.utils.jdbc.CustomKeyGeneratorObject;
import it.link.pdd.tools.migrazione_govway.utils.jdbc.InsertAndGeneratedKey;
import it.link.pdd.tools.migrazione_govway.utils.jdbc.InsertAndGeneratedKeyJDBCType;
import it.link.pdd.tools.migrazione_govway.utils.jdbc.InsertAndGeneratedKeyObject;
import it.link.pdd.tools.migrazione_govway.utils.jdbc.JDBCUtilities;
import it.link.pdd.tools.migrazione_govway.utils.resources.GestoreJNDI;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import javax.sql.DataSource;
import org.slf4j.Logger;

public class MsgDiagnosticoOpenSPCoopAppenderDB
implements IMsgDiagnosticoOpenSPCoopAppender {
    protected Properties appenderProperties;
    protected DataSource ds = null;
    protected String datasource = null;
    protected String connectionViaJDBC_url = null;
    protected String connectionViaJDBC_driverJDBC = null;
    protected String connectionViaJDBC_username = null;
    protected String connectionViaJDBC_password = null;
    protected boolean singleConnection = false;
    protected static Connection singleConnection_connection = null;
    protected static String singleConnection_source = null;
    protected String tipoDatabase = null;
    protected static boolean writeCorrelazione = true;
    protected boolean openspcoopConnection = false;
    protected boolean addIdTransazione = false;
    protected boolean addGdoForAllTables = false;
    protected boolean debug = false;
    protected Logger log = null;
    protected IProtocolFactory protocolFactory;
    protected IProtocolConfiguration protocolConfiguration;
    protected boolean forceIndex = false;

    @Override
    public IProtocolFactory getProtocolFactory() {
        return this.protocolFactory;
    }

    public void setForceIndex(boolean forceIndex) {
        this.forceIndex = forceIndex;
    }

    public MsgDiagnosticoOpenSPCoopAppenderDB(IProtocolFactory factory) {
        this.log = factory.getLogger();
        this.protocolFactory = factory;
    }

    protected synchronized void initConnection(DataSource dsA, String dataSourceS) throws Exception {
        if (singleConnection_connection == null) {
            try {
                singleConnection_source = dataSourceS;
                singleConnection_connection = dsA.getConnection();
            }
            catch (Exception e) {
                throw new Exception("Inizializzazione single connection (via datasource) non riuscita", e);
            }
        }
    }

    protected synchronized void initConnection(String jdbcUrl, String jdbcDriver, String username, String password) throws Exception {
        if (singleConnection_connection == null) {
            try {
                singleConnection_source = "url:" + jdbcUrl + " driver:" + jdbcDriver + " username:" + username + " password:" + password;
                singleConnection_connection = username == null ? DriverManager.getConnection(jdbcUrl) : DriverManager.getConnection(jdbcUrl, username, password);
            }
            catch (Exception e) {
                throw new Exception("Inizializzazione single connection (via jdbc connection) non riuscita", e);
            }
        }
    }

    protected Connection getConnectionViaJDBC() throws SQLException {
        if (this.connectionViaJDBC_username == null) {
            return DriverManager.getConnection(this.connectionViaJDBC_url);
        }
        return DriverManager.getConnection(this.connectionViaJDBC_url, this.connectionViaJDBC_username, this.connectionViaJDBC_password);
    }

    /*
     * Unable to fully structure code
     */
    protected MsgDiagnosticoConnectionResult getConnection(Connection conOpenSPCoopPdD, String methodName) throws Exception {
        con = null;
        cr = new MsgDiagnosticoConnectionResult();
        cr.setReleaseConnection(false);
        if (this.debug) {
            this.log.info("@@ [" + methodName + "] SINGLE CONNECTION[" + this.singleConnection + "] OPEN[" + this.openspcoopConnection + "]");
        }
        if (!this.singleConnection) {
            if (this.openspcoopConnection && conOpenSPCoopPdD != null) {
                if (this.debug) {
                    this.log.info("@@ [" + methodName + "] GET_CONNECTION, USE CONNECTION OPENSPCOOP");
                }
                con = conOpenSPCoopPdD;
            } else if (this.ds != null) {
                try {
                    con = this.ds.getConnection();
                    if (con == null) {
                        throw new Exception("Connessione non fornita");
                    }
                    cr.setReleaseConnection(true);
                    if (!this.debug) ** GOTO lbl38
                    this.log.info("@@ [" + methodName + "] GET_CONNECTION, USE CONNECTION FROM DATASOURCE");
                }
                catch (Exception e) {
                    throw new Exception("Errore durante il recupero di una connessione dal datasource [" + this.datasource + "]: " + e.getMessage());
                }
            } else {
                try {
                    con = this.getConnectionViaJDBC();
                    if (con == null) {
                        throw new Exception("Connessione non fornita");
                    }
                    cr.setReleaseConnection(true);
                    if (!this.debug) ** GOTO lbl38
                    this.log.info("@@ [" + methodName + "] GET_CONNECTION, USE CONNECTION VIA JDBC");
                }
                catch (Exception e) {
                    throw new Exception("Errore durante il recupero di una connessione via jdbc url[" + this.connectionViaJDBC_url + "] driver[" + this.connectionViaJDBC_driverJDBC + "] username[" + this.connectionViaJDBC_username + "] password[" + this.connectionViaJDBC_password + "]: " + e.getMessage());
                }
            }
        } else {
            con = MsgDiagnosticoOpenSPCoopAppenderDB.singleConnection_connection;
            if (con == null) {
                throw new Exception("Connessione (singleConnection enabled) non fornita dalla sorgente [" + MsgDiagnosticoOpenSPCoopAppenderDB.singleConnection_source + "]");
            }
            if (this.debug) {
                this.log.info("@@ [" + methodName + "] GET_CONNECTION, SINGLE CONNECTION");
            }
        }
lbl38:
        // 8 sources

        cr.setConnection(con);
        return cr;
    }

    protected void releaseConnection(MsgDiagnosticoConnectionResult connectionResult, String methodName) throws SQLException {
        if (this.debug) {
            this.log.info("@@ [" + methodName + "] RELEASE_CONNECTION [" + connectionResult.isReleaseConnection() + "]?");
        }
        if (connectionResult.isReleaseConnection()) {
            if (this.debug) {
                this.log.info("@@ [" + methodName + "] RELEASE_CONNECTION effettuato");
            }
            connectionResult.getConnection().close();
        }
    }

    @Override
    public void initializeAppender(OpenspcoopAppender appenderProperties) throws MsgDiagnosticoException {
        try {
            String debug;
            String addGdoForAllTablesString;
            String addIdTransazioneString;
            String correlazioneString;
            this.appenderProperties = new Properties();
            if (appenderProperties.sizePropertyList() > 0) {
                String openspcoopConnectionString;
                for (int i = 0; i < appenderProperties.sizePropertyList(); ++i) {
                    this.appenderProperties.put(appenderProperties.getProperty(i).getNome(), appenderProperties.getProperty(i).getValore());
                }
                this.datasource = this.appenderProperties.getProperty("datasource");
                if (this.datasource == null) {
                    this.connectionViaJDBC_url = this.appenderProperties.getProperty("connectionUrl");
                    if (this.connectionViaJDBC_url == null) {
                        throw new MsgDiagnosticoException("Propriet\u00e0 'datasource' e 'connectionUrl' non definite (almeno una delle due \u00e8 obbligatoria)");
                    }
                }
                this.tipoDatabase = this.appenderProperties.getProperty("tipoDatabase");
                if (this.tipoDatabase != null && !TipiDatabase.isAMember(this.tipoDatabase)) {
                    throw new MsgDiagnosticoException("Proprieta' 'tipoDatabase' presenta un tipo [" + this.tipoDatabase + "] non supportato");
                }
                String singleConnectionString = this.appenderProperties.getProperty("singleConnection");
                if (singleConnectionString != null && "true".equals(singleConnectionString = singleConnectionString.trim())) {
                    this.singleConnection = true;
                }
                if ((openspcoopConnectionString = this.appenderProperties.getProperty("usePdDConnection")) != null && "true".equals(openspcoopConnectionString = openspcoopConnectionString.trim())) {
                    this.openspcoopConnection = true;
                }
            } else {
                throw new MsgDiagnosticoException("Propriet\u00e0 'datasource' e 'connectionUrl' non definite (almeno una delle due \u00e8 obbligatoria)");
            }
            if (this.datasource != null) {
                Properties ctx = new Properties();
                ctx = Utilities.readProperties("context-", this.appenderProperties);
                GestoreJNDI jndi = new GestoreJNDI(ctx);
                if (this.singleConnection) {
                    if (singleConnection_connection == null) {
                        DataSource ds = (DataSource)jndi.lookup(this.datasource);
                        this.initConnection(ds, this.datasource);
                    }
                } else {
                    this.ds = (DataSource)jndi.lookup(this.datasource);
                }
            }
            if (this.connectionViaJDBC_url != null) {
                this.connectionViaJDBC_driverJDBC = this.appenderProperties.getProperty("connectionDriver");
                if (this.connectionViaJDBC_driverJDBC == null) {
                    throw new MsgDiagnosticoException("Propriet\u00e0 'connectionDriver' non definita (obbligatoria nella modalita' 'connection via jdbc')");
                }
                this.connectionViaJDBC_username = this.appenderProperties.getProperty("connectionUsername");
                if (this.connectionViaJDBC_username != null) {
                    this.connectionViaJDBC_password = this.appenderProperties.getProperty("connectionPassword");
                    if (this.connectionViaJDBC_password == null) {
                        throw new MsgDiagnosticoException("Propriet\u00e0 'connectionPassword' non definita (obbligatoria nella modalita' 'connection via jdbc' se viene definita la proprieta' 'connectionUsername')");
                    }
                }
                Class.forName(this.connectionViaJDBC_driverJDBC);
                if (this.singleConnection && singleConnection_connection == null) {
                    this.initConnection(this.connectionViaJDBC_url, this.connectionViaJDBC_driverJDBC, this.connectionViaJDBC_username, this.connectionViaJDBC_password);
                }
            }
            if ((correlazioneString = this.appenderProperties.getProperty("correlazione")) != null && "false".equalsIgnoreCase(correlazioneString)) {
                writeCorrelazione = false;
            }
            if ((addIdTransazioneString = this.appenderProperties.getProperty("addIdTransazione")) != null && "true".equals(addIdTransazioneString = addIdTransazioneString.trim())) {
                this.addIdTransazione = true;
            }
            if ((addGdoForAllTablesString = this.appenderProperties.getProperty("addGdoForAllTables")) != null && "true".equals(addGdoForAllTablesString = addGdoForAllTablesString.trim())) {
                this.addGdoForAllTables = true;
            }
            if ((debug = this.appenderProperties.getProperty("debug")) != null && "true".equals(debug = debug.trim())) {
                this.debug = true;
            }
            this.protocolConfiguration = this.protocolFactory.createProtocolConfiguration();
        }
        catch (Exception e) {
            throw new MsgDiagnosticoException("Errore durante l'inizializzazione dell'appender: " + e.getMessage(), e);
        }
    }

    private String getSQLStringValue(String value) {
        if (value != null && !"".equals(value)) {
            return value;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void log(Connection conOpenSPCoopPdD, MsgDiagnostico msgDiagnostico) throws MsgDiagnosticoException {
        Statement stmt = null;
        Connection con = null;
        String messaggio = msgDiagnostico.getMessaggio();
        MsgDiagnosticoConnectionResult cr = null;
        try {
            Date gdo = msgDiagnostico.getGdo();
            IDSoggetto idPorta = msgDiagnostico.getIdSoggetto();
            String idFunzione = msgDiagnostico.getIdFunzione();
            int severita = msgDiagnostico.getSeverita();
            String idBusta = msgDiagnostico.getIdBusta();
            String idBustaRisposta = msgDiagnostico.getIdBustaRisposta();
            String codiceDiagnostico = msgDiagnostico.getCodice();
            String idTransazione = msgDiagnostico.getProperty("ID");
            if (this.debug) {
                this.log.debug("@@ log idTransazione[" + idTransazione + "] idBusta[" + idBusta + "] ....");
            }
            TipiDatabase tipo = null;
            if (this.tipoDatabase != null) {
                if (!TipiDatabase.isAMember(this.tipoDatabase)) {
                    throw new MsgDiagnosticoException("Tipo database [" + this.tipoDatabase + "] non supportato");
                }
                tipo = TipiDatabase.toEnumConstant(this.tipoDatabase);
            }
            cr = this.getConnection(conOpenSPCoopPdD, "log");
            con = cr.getConnection();
            if (this.debug) {
                this.log.debug("@@ log idTransazione[" + idTransazione + "] idBusta[" + idBusta + "] (getConnection finished) ....");
            }
            String codiceDiagnosticoColumnName = "";
            String codiceDiagnosticoColumnValue = "";
            if (codiceDiagnostico != null) {
                codiceDiagnosticoColumnName = tipo == null ? " , codice" : "codice";
                codiceDiagnosticoColumnValue = " , ?";
            }
            String idTransazioneColumnName = "";
            String idTransazioneColumnValue = "";
            if (this.addIdTransazione) {
                idTransazioneColumnName = tipo == null ? " , id_transazione" : "id_transazione";
                idTransazioneColumnValue = " , ?";
            }
            if (tipo == null) {
                if (this.debug) {
                    this.log.debug("@@ log idTransazione[" + idTransazione + "] idBusta[" + idBusta + "] (inserimentoDiagnostico BackwardCompatible) ....");
                }
                String updateString = "INSERT INTO msgdiagnostici (gdo, pdd_codice, pdd_tipo_soggetto, pdd_nome_soggetto, idfunzione, severita, messaggio, idmessaggio, idmessaggio_risposta, protocollo" + codiceDiagnosticoColumnName + idTransazioneColumnName + ") VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?" + codiceDiagnosticoColumnValue + idTransazioneColumnValue + ")";
                int index = 1;
                stmt = con.prepareStatement(updateString);
                if (gdo != null) {
                    stmt.setTimestamp(index++, new Timestamp(gdo.getTime()));
                } else {
                    stmt.setTimestamp(index++, null);
                }
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, index++, idPorta.getCodicePorta());
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, index++, idPorta.getTipo());
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, index++, idPorta.getNome());
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, index++, idFunzione);
                stmt.setInt(index++, severita);
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, index++, messaggio);
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, index++, idBusta);
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, index++, idBustaRisposta);
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, index++, msgDiagnostico.getProtocollo());
                if (codiceDiagnostico != null) {
                    JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, index++, codiceDiagnostico);
                }
                if (this.addIdTransazione) {
                    JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, index++, idTransazione);
                }
                stmt.executeUpdate();
                stmt.close();
                if (this.debug) {
                    this.log.debug("@@ log idTransazione[" + idTransazione + "] idBusta[" + idBusta + "] (inserimentoDiagnostico BackwardCompatible terminato) ....");
                }
            } else {
                long iddiagnostico;
                if (this.debug) {
                    this.log.debug("@@ log idTransazione[" + idTransazione + "] idBusta[" + idBusta + "] (inserimentoDiagnostico) ....");
                }
                ArrayList<InsertAndGeneratedKeyObject> listInsertAndGeneratedKeyObject = new ArrayList<InsertAndGeneratedKeyObject>();
                Timestamp gdoT = null;
                if (gdo != null) {
                    gdoT = new Timestamp(gdo.getTime());
                }
                listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("gdo", gdoT, InsertAndGeneratedKeyJDBCType.TIMESTAMP));
                listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("pdd_codice", this.getSQLStringValue(idPorta.getCodicePorta()), InsertAndGeneratedKeyJDBCType.STRING));
                listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("pdd_tipo_soggetto", this.getSQLStringValue(idPorta.getTipo()), InsertAndGeneratedKeyJDBCType.STRING));
                listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("pdd_nome_soggetto", this.getSQLStringValue(idPorta.getNome()), InsertAndGeneratedKeyJDBCType.STRING));
                listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("idfunzione", this.getSQLStringValue(idFunzione), InsertAndGeneratedKeyJDBCType.STRING));
                listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("severita", severita, InsertAndGeneratedKeyJDBCType.INT));
                listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("messaggio", this.getSQLStringValue(messaggio), InsertAndGeneratedKeyJDBCType.STRING));
                listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("idmessaggio", this.getSQLStringValue(idBusta), InsertAndGeneratedKeyJDBCType.STRING));
                listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("idmessaggio_risposta", this.getSQLStringValue(idBustaRisposta), InsertAndGeneratedKeyJDBCType.STRING));
                listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("protocollo", this.getSQLStringValue(msgDiagnostico.getProtocollo()), InsertAndGeneratedKeyJDBCType.STRING));
                if (codiceDiagnostico != null) {
                    listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject(codiceDiagnosticoColumnName, this.getSQLStringValue(codiceDiagnostico), InsertAndGeneratedKeyJDBCType.STRING));
                }
                if (this.addIdTransazione) {
                    listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject(idTransazioneColumnName, this.getSQLStringValue(idTransazione), InsertAndGeneratedKeyJDBCType.STRING));
                }
                if ((iddiagnostico = InsertAndGeneratedKey.insertAndReturnGeneratedKey(con, tipo, new CustomKeyGeneratorObject("msgdiagnostici", "id", "seq_msgdiagnostici", "msgdiagnostici_init_seq"), listInsertAndGeneratedKeyObject.toArray(new InsertAndGeneratedKeyObject[1]))) <= 0L) {
                    throw new Exception("ID autoincrementale non ottenuto");
                }
                msgDiagnostico.setId(iddiagnostico);
                if (this.debug) {
                    this.log.debug("@@ log idTransazione[" + idTransazione + "] idBusta[" + idBusta + "] (inserimentoDiagnostico terminato) ....");
                }
            }
            if (this.debug) {
                this.log.debug("@@ log idTransazione[" + idTransazione + "] idBusta[" + idBusta + "] completato");
            }
        }
        catch (Exception e) {
            try {
                throw new MsgDiagnosticoException("Errore durante la registrazione del msg diagnostico: " + e.getMessage() + "\nIl messaggio era: " + messaggio, e);
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.releaseConnection(cr, "log");
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception gdo) {
            // empty catch block
        }
        try {
            this.releaseConnection(cr, "log");
            return;
        }
        catch (Exception gdo) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void logCorrelazione(Connection conOpenSPCoopPdD, MsgDiagnosticoCorrelazione msgDiagCorrelazione) throws MsgDiagnosticoException {
        if (!writeCorrelazione) return;
        Statement stmt = null;
        Connection con = null;
        MsgDiagnosticoConnectionResult cr = null;
        try {
            String idBusta = msgDiagCorrelazione.getIdBusta();
            Date gdo = msgDiagCorrelazione.getGdo();
            String porta = msgDiagCorrelazione.getNomePorta();
            boolean delegata = msgDiagCorrelazione.isDelegata();
            IDSoggetto idPorta = msgDiagCorrelazione.getIdSoggetto();
            IDSoggetto fruitore = null;
            IDServizio servizio = null;
            if (msgDiagCorrelazione.getInformazioniProtocollo() != null) {
                fruitore = msgDiagCorrelazione.getInformazioniProtocollo().getFruitore();
                servizio = new IDServizio();
                servizio.setAzione(msgDiagCorrelazione.getInformazioniProtocollo().getAzione());
                servizio.setServizio(msgDiagCorrelazione.getInformazioniProtocollo().getServizio());
                servizio.setSoggettoErogatore(msgDiagCorrelazione.getInformazioniProtocollo().getErogatore());
                servizio.setTipoServizio(msgDiagCorrelazione.getInformazioniProtocollo().getTipoServizio());
                servizio.setVersioneServizio("" + msgDiagCorrelazione.getInformazioniProtocollo().getVersioneServizio());
            }
            String idCorrelazioneApplicativa = msgDiagCorrelazione.getCorrelazioneApplicativa();
            String idTransazione = msgDiagCorrelazione.getProperty("ID");
            if (this.debug) {
                this.log.debug("@@ logCorrelazione idTransazione[" + idTransazione + "] idBusta[" + idBusta + "] ....");
            }
            TipiDatabase tipo = null;
            if (this.tipoDatabase != null) {
                if (!TipiDatabase.isAMember(this.tipoDatabase)) {
                    throw new MsgDiagnosticoException("Tipo database [" + this.tipoDatabase + "] non supportato");
                }
                tipo = TipiDatabase.toEnumConstant(this.tipoDatabase);
            }
            cr = this.getConnection(conOpenSPCoopPdD, "logCorrelazione");
            con = cr.getConnection();
            if (this.debug) {
                this.log.debug("@@ logCorrelazione idTransazione[" + idTransazione + "] idBusta[" + idBusta + "] (getConnection finished) ....");
            }
            String fruitoreColumnName = "";
            String fruitoreColumnValue = "";
            if (fruitore != null) {
                fruitoreColumnName = ", tipo_fruitore, fruitore";
                fruitoreColumnValue = ", ?, ?";
            }
            String idTransazioneColumnName = "";
            String idTransazioneColumnValue = "";
            if (this.addIdTransazione) {
                idTransazioneColumnName = tipo == null ? " , id_transazione" : "id_transazione";
                idTransazioneColumnValue = " , ?";
            }
            if (tipo == null) {
                if (this.debug) {
                    this.log.debug("@@ logCorrelazione idTransazione[" + idTransazione + "] idBusta[" + idBusta + "] (inserimento informazione correlazione backwardCompatible) ....");
                }
                String updateString = "INSERT INTO msgdiag_correlazione (idmessaggio, pdd_codice, pdd_tipo_soggetto, pdd_nome_soggetto, gdo, porta, delegata" + fruitoreColumnName + ", tipo_erogatore, erogatore, tipo_servizio, servizio, versione_servizio, azione, id_correlazione_applicativa, protocollo" + idTransazioneColumnName + ") VALUES (?, ?, ?, ?, ?, ?, ?" + fruitoreColumnValue + ", ?, ?, ? , ? , ? , ? , ?, ?" + idTransazioneColumnValue + ")";
                stmt = con.prepareStatement(updateString);
                int index = 1;
                if (idBusta == null) throw new Exception("Identificativo messaggio non definito");
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, index++, idBusta);
                if (idPorta == null) throw new Exception("IdentificativoPorta non definito");
                if (idPorta.getCodicePorta() == null) throw new Exception("IdentificativoPorta.codice non definito");
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, index++, idPorta.getCodicePorta());
                if (idPorta.getTipo() == null) throw new Exception("IdentificativoPorta.tipo non definito");
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, index++, idPorta.getTipo());
                if (idPorta.getNome() == null) throw new Exception("IdentificativoPorta.nome non definito");
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, index++, idPorta.getNome());
                if (gdo == null) throw new Exception("Data di registrazione non definita");
                stmt.setTimestamp(index++, new Timestamp(gdo.getTime()));
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, index++, porta);
                if (delegata) {
                    stmt.setInt(index++, 1);
                } else {
                    stmt.setInt(index++, 0);
                }
                if (fruitore != null) {
                    if (fruitore.getTipo() == null) throw new Exception("Tipo fruitore non definito");
                    JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, index++, fruitore.getTipo());
                    if (fruitore.getNome() == null) throw new Exception("Nome fruitore non definito");
                    JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, index++, fruitore.getNome());
                } else if (!this.protocolConfiguration.isSupportoAutenticazioneSoggetti()) {
                    throw new Exception("Fruitore non definito");
                }
                if (servizio == null) throw new Exception("IDServizio non definito");
                if (servizio.getSoggettoErogatore() == null) throw new Exception("Soggetto erogatore non definito");
                if (servizio.getSoggettoErogatore().getTipo() == null) throw new Exception("Tipo soggetto erogatore non definito");
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, index++, servizio.getSoggettoErogatore().getTipo());
                if (servizio.getSoggettoErogatore().getNome() == null) throw new Exception("Nome soggetto erogatore non definito");
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, index++, servizio.getSoggettoErogatore().getNome());
                if (servizio.getTipoServizio() == null) throw new Exception("Tipo servizio non definito");
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, index++, servizio.getTipoServizio());
                if (servizio.getServizio() == null) throw new Exception("Nome servizio non definito");
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, index++, servizio.getServizio());
                if (servizio.getVersioneServizio() == null) throw new Exception("Versione servizio non definita");
                stmt.setInt(index++, Integer.parseInt(servizio.getVersioneServizio()));
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, index++, servizio.getAzione());
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, index++, idCorrelazioneApplicativa);
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, index++, msgDiagCorrelazione.getProtocollo());
                if (this.addIdTransazione) {
                    JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, index++, idTransazione);
                }
                stmt.executeUpdate();
                stmt.close();
                if (this.debug) {
                    this.log.debug("@@ logCorrelazione idTransazione[" + idTransazione + "] idBusta[" + idBusta + "] (inserimento informazione correlazione backwardCompatible terminato) ....");
                }
            } else {
                long iddiagnostico;
                if (this.debug) {
                    this.log.debug("@@ logCorrelazione idTransazione[" + idTransazione + "] idBusta[" + idBusta + "] (inserimento informazione correlazione) ....");
                }
                ArrayList<InsertAndGeneratedKeyObject> listInsertAndGeneratedKeyObject = new ArrayList<InsertAndGeneratedKeyObject>();
                if (idBusta == null) throw new Exception("Identificativo messaggio non definito");
                listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("idmessaggio", this.getSQLStringValue(idBusta), InsertAndGeneratedKeyJDBCType.STRING));
                if (idPorta == null) throw new Exception("IdentificativoPorta non definito");
                if (idPorta.getCodicePorta() == null) throw new Exception("IdentificativoPorta.codice non definito");
                listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("pdd_codice", this.getSQLStringValue(idPorta.getCodicePorta()), InsertAndGeneratedKeyJDBCType.STRING));
                if (idPorta.getTipo() == null) throw new Exception("IdentificativoPorta.tipo non definito");
                listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("pdd_tipo_soggetto", this.getSQLStringValue(idPorta.getTipo()), InsertAndGeneratedKeyJDBCType.STRING));
                if (idPorta.getNome() == null) throw new Exception("IdentificativoPorta.nome non definito");
                listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("pdd_nome_soggetto", this.getSQLStringValue(idPorta.getNome()), InsertAndGeneratedKeyJDBCType.STRING));
                if (gdo == null) throw new Exception("Data di registrazione non definita");
                listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("gdo", new Timestamp(gdo.getTime()), InsertAndGeneratedKeyJDBCType.TIMESTAMP));
                listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("porta", this.getSQLStringValue(porta), InsertAndGeneratedKeyJDBCType.STRING));
                if (delegata) {
                    listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("delegata", 1, InsertAndGeneratedKeyJDBCType.INT));
                } else {
                    listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("delegata", 0, InsertAndGeneratedKeyJDBCType.INT));
                }
                if (fruitore != null) {
                    if (fruitore.getTipo() == null) throw new Exception("Tipo fruitore non definito");
                    listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("tipo_fruitore", this.getSQLStringValue(fruitore.getTipo()), InsertAndGeneratedKeyJDBCType.STRING));
                    if (fruitore.getNome() == null) throw new Exception("Nome fruitore non definito");
                    listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("fruitore", this.getSQLStringValue(fruitore.getNome()), InsertAndGeneratedKeyJDBCType.STRING));
                } else if (!this.protocolConfiguration.isSupportoAutenticazioneSoggetti()) {
                    throw new Exception("Fruitore non definito");
                }
                if (servizio == null) throw new Exception("IDServizio non definito");
                if (servizio.getSoggettoErogatore() == null) throw new Exception("Soggetto erogatore non definito");
                if (servizio.getSoggettoErogatore().getTipo() == null) throw new Exception("Tipo soggetto erogatore non definito");
                listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("tipo_erogatore", this.getSQLStringValue(servizio.getSoggettoErogatore().getTipo()), InsertAndGeneratedKeyJDBCType.STRING));
                if (servizio.getSoggettoErogatore().getNome() == null) throw new Exception("Nome soggetto erogatore non definito");
                listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("erogatore", this.getSQLStringValue(servizio.getSoggettoErogatore().getNome()), InsertAndGeneratedKeyJDBCType.STRING));
                if (servizio.getTipoServizio() == null) throw new Exception("Tipo servizio non definito");
                listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("tipo_servizio", this.getSQLStringValue(servizio.getTipoServizio()), InsertAndGeneratedKeyJDBCType.STRING));
                if (servizio.getServizio() == null) throw new Exception("Nome servizio non definito");
                listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("servizio", this.getSQLStringValue(servizio.getServizio()), InsertAndGeneratedKeyJDBCType.STRING));
                if (servizio.getVersioneServizio() == null) throw new Exception("Versione servizio non definita");
                listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("versione_servizio", Integer.parseInt(servizio.getVersioneServizio()), InsertAndGeneratedKeyJDBCType.INT));
                listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("azione", this.getSQLStringValue(servizio.getAzione()), InsertAndGeneratedKeyJDBCType.STRING));
                listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("id_correlazione_applicativa", this.getSQLStringValue(idCorrelazioneApplicativa), InsertAndGeneratedKeyJDBCType.STRING));
                listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("protocollo", this.getSQLStringValue(msgDiagCorrelazione.getProtocollo()), InsertAndGeneratedKeyJDBCType.STRING));
                if (this.addIdTransazione) {
                    listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject(idTransazioneColumnName, this.getSQLStringValue(idTransazione), InsertAndGeneratedKeyJDBCType.STRING));
                }
                if ((iddiagnostico = InsertAndGeneratedKey.insertAndReturnGeneratedKey(con, tipo, new CustomKeyGeneratorObject("msgdiag_correlazione", "id", "seq_msgdiag_correlazione", "msgdiag_correlazione_init_seq"), listInsertAndGeneratedKeyObject.toArray(new InsertAndGeneratedKeyObject[1]))) <= 0L) {
                    throw new Exception("ID autoincrementale non ottenuto");
                }
                msgDiagCorrelazione.setId(iddiagnostico);
                if (this.debug) {
                    this.log.debug("@@ logCorrelazione idTransazione[" + idTransazione + "] idBusta[" + idBusta + "] (inserimento informazione correlazione terminato) ....");
                }
            }
            if (this.debug) {
                this.log.debug("@@ logCorrelazione idTransazione[" + idTransazione + "] idBusta[" + idBusta + "] completato");
            }
        }
        catch (Exception e) {
            try {
                throw new MsgDiagnosticoException("Errore durante la registrazione del msg diagnostico di correlazione: " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.releaseConnection(cr, "logCorrelazione");
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception idBusta) {
            // empty catch block
        }
        try {
            this.releaseConnection(cr, "logCorrelazione");
            return;
        }
        catch (Exception idBusta) {
            return;
        }
    }

    @Override
    public void logCorrelazioneServizioApplicativo(Connection conOpenSPCoopPdD, MsgDiagnosticoCorrelazioneServizioApplicativo msgDiagCorrelazioneSA) throws MsgDiagnosticoException {
        if (writeCorrelazione) {
            Statement stmt = null;
            Connection con = null;
            ResultSet rs = null;
            MsgDiagnosticoConnectionResult cr = null;
            try {
                if (this.debug) {
                    this.log.debug("@@ logCorrelazioneServizioApplicativo idBusta[" + msgDiagCorrelazioneSA.getIdBusta() + "] delegata[" + msgDiagCorrelazioneSA.isDelegata() + "] ....");
                }
                cr = this.getConnection(conOpenSPCoopPdD, "logCorrelazioneServizioApplicativo");
                con = cr.getConnection();
                if (this.debug) {
                    this.log.debug("@@ logCorrelazioneServizioApplicativo idBusta[" + msgDiagCorrelazioneSA.getIdBusta() + "] delegata[" + msgDiagCorrelazioneSA.isDelegata() + "] (getConnection finished) ....");
                }
                StringBuffer selectString = new StringBuffer("SELECT ");
                if (this.forceIndex) {
                    selectString.append(" /*+ index(msgdiag_correlazione MSG_CORR_INDEX) */ ");
                }
                selectString.append(" id,gdo FROM msgdiag_correlazione WHERE idmessaggio=? AND delegata=?");
                stmt = con.prepareStatement(selectString.toString());
                String id = msgDiagCorrelazioneSA.getIdBusta();
                if (id == null) {
                    throw new Exception("Identificativo Messaggio non definito");
                }
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, 1, id);
                if (msgDiagCorrelazioneSA.isDelegata()) {
                    stmt.setInt(2, 1);
                } else {
                    stmt.setInt(2, 0);
                }
                long idCorrelazione = -1L;
                Timestamp gdoT = null;
                for (int tentativi = 0; tentativi < 10; ++tentativi) {
                    rs = stmt.executeQuery();
                    if (rs.next()) {
                        idCorrelazione = rs.getLong("id");
                        if (idCorrelazione == -1L) {
                            throw new Exception("ID Correlazione non esistente");
                        }
                        gdoT = rs.getTimestamp("gdo");
                    }
                    rs.close();
                    if (idCorrelazione > 0L) break;
                    Utilities.sleep(50L);
                }
                stmt.close();
                if (idCorrelazione <= 0L) {
                    throw new Exception("Non esiste una correlazione con l'id[" + id + "] e delegata[" + msgDiagCorrelazioneSA.isDelegata() + "]");
                }
                if (this.debug) {
                    this.log.debug("@@ logCorrelazioneServizioApplicativo idBusta[" + msgDiagCorrelazioneSA.getIdBusta() + "] delegata[" + msgDiagCorrelazioneSA.isDelegata() + "] (idCorrelazione prelevato) ....");
                }
                String gdoColumnName = "";
                String gdoColumnValue = "";
                if (this.addGdoForAllTables) {
                    gdoColumnName = " , gdo";
                    gdoColumnValue = " , ?";
                }
                selectString = new StringBuffer("SELECT ");
                selectString.append(" * FROM msgdiag_correlazione_sa WHERE id_correlazione=? AND servizio_applicativo=?");
                stmt = con.prepareStatement(selectString.toString());
                int index = 1;
                stmt.setLong(index++, idCorrelazione);
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, index++, msgDiagCorrelazioneSA.getServizioApplicativo());
                rs = stmt.executeQuery();
                boolean existsAlready = rs.next();
                rs.close();
                stmt.close();
                if (this.debug) {
                    this.log.debug("@@ logCorrelazioneServizioApplicativo idBusta[" + msgDiagCorrelazioneSA.getIdBusta() + "] delegata[" + msgDiagCorrelazioneSA.isDelegata() + "] (controllo esistenza) ....");
                }
                if (!existsAlready) {
                    if (this.debug) {
                        this.log.debug("@@ logCorrelazioneServizioApplicativo idBusta[" + msgDiagCorrelazioneSA.getIdBusta() + "] delegata[" + msgDiagCorrelazioneSA.isDelegata() + "] (inserimento) ....");
                    }
                    String updateString = "INSERT INTO msgdiag_correlazione_sa (id_correlazione, servizio_applicativo" + gdoColumnName + ") VALUES (?, ?" + gdoColumnValue + ")";
                    stmt = con.prepareStatement(updateString);
                    index = 1;
                    stmt.setLong(index++, idCorrelazione);
                    JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, index++, msgDiagCorrelazioneSA.getServizioApplicativo());
                    if (this.addGdoForAllTables) {
                        stmt.setTimestamp(index++, gdoT);
                    }
                    stmt.executeUpdate();
                    stmt.close();
                    if (this.debug) {
                        this.log.debug("@@ logCorrelazioneServizioApplicativo idBusta[" + msgDiagCorrelazioneSA.getIdBusta() + "] delegata[" + msgDiagCorrelazioneSA.isDelegata() + "] (inserimento completato) ....");
                    }
                }
                if (this.debug) {
                    this.log.debug("@@ logCorrelazioneServizioApplicativo idBusta[" + msgDiagCorrelazioneSA.getIdBusta() + "] delegata[" + msgDiagCorrelazioneSA.isDelegata() + "] completato");
                }
            }
            catch (Exception e) {
                throw new MsgDiagnosticoException("Errore durante la registrazione del msg diagnostico di correlazione: " + e.getMessage(), e);
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    this.releaseConnection(cr, "logCorrelazioneServizioApplicativo");
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public void logCorrelazioneApplicativaRisposta(Connection conOpenSPCoopPdD, MsgDiagnosticoCorrelazioneApplicativa msgDiagCorrelazioneApplicativa) throws MsgDiagnosticoException {
        if (writeCorrelazione) {
            Statement stmt = null;
            Connection con = null;
            ResultSet rs = null;
            MsgDiagnosticoConnectionResult cr = null;
            try {
                if (this.debug) {
                    this.log.debug("@@ logCorrelazioneApplicativaRisposta idBusta[" + msgDiagCorrelazioneApplicativa.getIdBusta() + "] delegata[" + msgDiagCorrelazioneApplicativa.isDelegata() + "] ....");
                }
                cr = this.getConnection(conOpenSPCoopPdD, "logCorrelazioneApplicativaRisposta");
                con = cr.getConnection();
                if (this.debug) {
                    this.log.debug("@@ logCorrelazioneApplicativaRisposta idBusta[" + msgDiagCorrelazioneApplicativa.getIdBusta() + "] delegata[" + msgDiagCorrelazioneApplicativa.isDelegata() + "] (getConnection finished) ....");
                }
                StringBuffer selectString = new StringBuffer("SELECT ");
                if (this.forceIndex) {
                    selectString.append(" /*+ index(msgdiag_correlazione MSG_CORR_INDEX) */ ");
                }
                selectString.append(" id FROM msgdiag_correlazione WHERE idmessaggio=? AND delegata=?");
                stmt = con.prepareStatement(selectString.toString());
                String idBusta = msgDiagCorrelazioneApplicativa.getIdBusta();
                if (idBusta == null) {
                    throw new Exception("Identificativo Messaggio non definito");
                }
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, 1, idBusta);
                if (msgDiagCorrelazioneApplicativa.isDelegata()) {
                    stmt.setInt(2, 1);
                } else {
                    stmt.setInt(2, 0);
                }
                long idCorrelazione = -1L;
                rs = stmt.executeQuery();
                if (rs.next()) {
                    idCorrelazione = rs.getLong("id");
                    if (idCorrelazione == -1L) {
                        throw new Exception("ID Correlazione non esistente");
                    }
                } else {
                    throw new Exception("Non esiste una correlazione con l'id[" + idBusta + "] e delegata[" + msgDiagCorrelazioneApplicativa.isDelegata() + "]");
                }
                rs.close();
                stmt.close();
                if (this.debug) {
                    this.log.debug("@@ logCorrelazioneApplicativaRisposta idBusta[" + msgDiagCorrelazioneApplicativa.getIdBusta() + "] delegata[" + msgDiagCorrelazioneApplicativa.isDelegata() + "] (letto idCorrelazione) ....");
                }
                String updateString = "UPDATE msgdiag_correlazione set id_correlazione_risposta=? WHERE id=?";
                stmt = con.prepareStatement(updateString);
                JDBCUtilities.setSQLStringValue((PreparedStatement)stmt, 1, msgDiagCorrelazioneApplicativa.getCorrelazione());
                stmt.setLong(2, idCorrelazione);
                stmt.executeUpdate();
                stmt.close();
                if (this.debug) {
                    this.log.debug("@@ logCorrelazioneApplicativaRisposta idBusta[" + msgDiagCorrelazioneApplicativa.getIdBusta() + "] delegata[" + msgDiagCorrelazioneApplicativa.isDelegata() + "] completato");
                }
            }
            catch (Exception e) {
                throw new MsgDiagnosticoException("Errore durante la registrazione del msg diagnostico di correlazione (id applicativo della risposta): " + e.getMessage(), e);
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    this.releaseConnection(cr, "logCorrelazioneApplicativaRisposta");
                }
                catch (Exception exception) {}
            }
        }
    }

    public String getTipoDatabase() {
        return this.tipoDatabase;
    }

    public void setTipoDatabase(String tipoDatabase) {
        this.tipoDatabase = tipoDatabase;
    }

    @Override
    public void isAlive() throws CoreException {
        Connection con = null;
        Statement stmtTest = null;
        MsgDiagnosticoConnectionResult cr = null;
        try {
            cr = this.getConnection(null, "isAlive");
            con = cr.getConnection();
            stmtTest = con.createStatement();
            stmtTest.execute("SELECT * from db_info");
        }
        catch (Exception e) {
            throw new CoreException("Connessione al database MsgDiagnostici non disponibile: " + e.getMessage(), e);
        }
        finally {
            try {
                if (stmtTest != null) {
                    stmtTest.close();
                }
            }
            catch (Exception exception) {}
            try {
                this.releaseConnection(cr, "isAlive");
            }
            catch (Exception exception) {}
        }
    }
}

