/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.basic.diagnostica;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.basic.diagnostica.TipoRicercaDiagnostici;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.diagnostica.FiltroRicercaDiagnostici;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.diagnostica.FiltroRicercaDiagnosticiConPaginazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.diagnostica.InformazioniProtocollo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.diagnostica.MsgDiagnostico;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.diagnostica.MsgDiagnosticoCorrelazione;
import it.link.pdd.tools.migrazione_govway.utils.StringWrapper;
import it.link.pdd.tools.migrazione_govway.utils.sql.ISQLQueryObject;
import it.link.pdd.tools.migrazione_govway.utils.sql.SQLObjectFactory;
import it.link.pdd.tools.migrazione_govway.utils.sql.SQLQueryObjectException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import org.slf4j.Logger;

public class DriverMsgDiagnosticiUtilities {
    private static final String format = "yyyy-MM-dd_HH:mm:ss.SSS";

    public static ISQLQueryObject createSQLQueryObj_searchMessaggiDiagnostici(FiltroRicercaDiagnosticiConPaginazione filter, String tipoDatabase) throws SQLQueryObjectException {
        return DriverMsgDiagnosticiUtilities.createSQLQueryObj(filter, tipoDatabase, TipoRicercaDiagnostici.MSGDIAGNOSTICI);
    }

    public static ISQLQueryObject createSQLQueryObj_countMessaggiDiagnostici(FiltroRicercaDiagnostici filter, String tipoDatabase) throws SQLQueryObjectException {
        return DriverMsgDiagnosticiUtilities.createSQLQueryObj(filter, tipoDatabase, TipoRicercaDiagnostici.COUNT_MSGDIAGNOSTICI);
    }

    public static ISQLQueryObject createSQLQueryObj_deleteMessaggiDiagnostici(FiltroRicercaDiagnostici filter, String tipoDatabase) throws SQLQueryObjectException {
        ISQLQueryObject from = DriverMsgDiagnosticiUtilities.createSQLQueryObj(filter, tipoDatabase, TipoRicercaDiagnostici.DELETE_MSGDIAGNOSTICI);
        ISQLQueryObject sqlQueryObjectDelete = SQLObjectFactory.createSQLQueryObject(tipoDatabase);
        sqlQueryObjectDelete.addDeleteTable("msgdiagnostici");
        sqlQueryObjectDelete.addWhereINSelectSQLCondition(false, "id", from);
        return sqlQueryObjectDelete;
    }

    public static ISQLQueryObject createSQLQueryObj_searchMsgDiagCorrelazione(FiltroRicercaDiagnosticiConPaginazione filter, String tipoDatabase) throws SQLQueryObjectException {
        return DriverMsgDiagnosticiUtilities.createSQLQueryObj(filter, tipoDatabase, TipoRicercaDiagnostici.MSGDIAGNOSTICI_CORRELAZIONE);
    }

    public static ISQLQueryObject createSQLQueryObj_countMsgDiagCorrelazione(FiltroRicercaDiagnostici filter, String tipoDatabase) throws SQLQueryObjectException {
        return DriverMsgDiagnosticiUtilities.createSQLQueryObj(filter, tipoDatabase, TipoRicercaDiagnostici.COUNT_MSGDIAGNOSTICI_CORRELAZIONE);
    }

    public static ISQLQueryObject createSQLQueryObj_deleteMsgDiagCorrelazione(FiltroRicercaDiagnostici filter, String tipoDatabase) throws SQLQueryObjectException {
        ISQLQueryObject from = DriverMsgDiagnosticiUtilities.createSQLQueryObj(filter, tipoDatabase, TipoRicercaDiagnostici.DELETE_MSGDIAGNOSTICI_CORRELAZIONE);
        ISQLQueryObject sqlQueryObjectDelete = SQLObjectFactory.createSQLQueryObject(tipoDatabase);
        sqlQueryObjectDelete.addDeleteTable("msgdiag_correlazione");
        sqlQueryObjectDelete.addWhereINSelectSQLCondition(false, "id", from);
        return sqlQueryObjectDelete;
    }

    private static boolean isJoinWithCorrelazione(FiltroRicercaDiagnostici filter, TipoRicercaDiagnostici tipoRicerca) {
        return DriverMsgDiagnosticiUtilities.isJoinWith(filter, tipoRicerca, false);
    }

    private static boolean isJoinWithCorrelazioneSA(FiltroRicercaDiagnostici filter, TipoRicercaDiagnostici tipoRicerca) {
        return DriverMsgDiagnosticiUtilities.isJoinWith(filter, tipoRicerca, true);
    }

    private static boolean isJoinWith(FiltroRicercaDiagnostici filter, TipoRicercaDiagnostici tipoRicerca, boolean correlazioneSA) {
        boolean joinWithCorrelazioneSA = false;
        boolean joinWithCorrelazione = false;
        switch (tipoRicerca) {
            case MSGDIAGNOSTICI: 
            case COUNT_MSGDIAGNOSTICI: 
            case DELETE_MSGDIAGNOSTICI: {
                joinWithCorrelazioneSA = DriverMsgDiagnosticiUtilities.isDefined(filter.getServizioApplicativo());
                joinWithCorrelazione = false;
                joinWithCorrelazione = DriverMsgDiagnosticiUtilities.isDefined(filter.isDelegata()) || DriverMsgDiagnosticiUtilities.isDefined(filter.getNomePorta()) || DriverMsgDiagnosticiUtilities.isDefined(filter.getRicercaSoloMessaggiCorrelatiInformazioniProtocollo()) && filter.getRicercaSoloMessaggiCorrelatiInformazioniProtocollo() != false || DriverMsgDiagnosticiUtilities.isDefined(filter.getInformazioniProtocollo()) || joinWithCorrelazioneSA || DriverMsgDiagnosticiUtilities.isDefined(filter.getCorrelazioneApplicativa()) || DriverMsgDiagnosticiUtilities.isDefined(filter.getCorrelazioneApplicativaRisposta()) || DriverMsgDiagnosticiUtilities.isDefined(filter.getFiltroSoggetti());
                break;
            }
            case MSGDIAGNOSTICI_CORRELAZIONE: 
            case COUNT_MSGDIAGNOSTICI_CORRELAZIONE: 
            case DELETE_MSGDIAGNOSTICI_CORRELAZIONE: {
                joinWithCorrelazioneSA = true;
                joinWithCorrelazione = true;
            }
        }
        if (correlazioneSA) {
            return joinWithCorrelazioneSA;
        }
        return joinWithCorrelazione;
    }

    private static ISQLQueryObject createSQLQueryObj(FiltroRicercaDiagnostici filter, String tipoDatabase, TipoRicercaDiagnostici tipoRicerca) throws SQLQueryObjectException {
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDatabase);
        boolean distinct = true;
        switch (tipoRicerca) {
            case MSGDIAGNOSTICI: {
                sqlQueryObject.setSelectDistinct(distinct);
                sqlQueryObject.addSelectAliasField("msgdiagnostici.id", "idMsgDiagnostico");
                sqlQueryObject.addSelectField("msgdiagnostici.gdo");
                break;
            }
            case MSGDIAGNOSTICI_CORRELAZIONE: {
                sqlQueryObject.setSelectDistinct(distinct);
                sqlQueryObject.addSelectAliasField("msgdiag_correlazione.id", "idMsgDiagCorrelazione");
                sqlQueryObject.addSelectField("msgdiag_correlazione.gdo");
                break;
            }
            case COUNT_MSGDIAGNOSTICI: {
                sqlQueryObject.addSelectCountField("msgdiagnostici.id", "countMsgDiagnostici", distinct);
                break;
            }
            case COUNT_MSGDIAGNOSTICI_CORRELAZIONE: {
                sqlQueryObject.addSelectCountField("msgdiag_correlazione.id", "countCorrelazioniMsgDiagnostici", distinct);
                break;
            }
            case DELETE_MSGDIAGNOSTICI: {
                sqlQueryObject.setSelectDistinct(distinct);
                sqlQueryObject.addSelectAliasField("msgdiagnostici.id", "idMsgDiagnostico");
                break;
            }
            case DELETE_MSGDIAGNOSTICI_CORRELAZIONE: {
                sqlQueryObject.setSelectDistinct(distinct);
                sqlQueryObject.addSelectAliasField("msgdiag_correlazione.id", "idMsgDiagCorrelazione");
            }
        }
        boolean joinWithCorrelazioneSA = DriverMsgDiagnosticiUtilities.isJoinWithCorrelazioneSA(filter, tipoRicerca);
        boolean joinWithCorrelazione = DriverMsgDiagnosticiUtilities.isJoinWithCorrelazione(filter, tipoRicerca);
        sqlQueryObject.addFromTable("msgdiagnostici");
        if (joinWithCorrelazione) {
            sqlQueryObject.addFromTable("msgdiag_correlazione");
        }
        if (joinWithCorrelazioneSA) {
            sqlQueryObject.addFromTable("msgdiag_correlazione_sa");
        }
        sqlQueryObject.setANDLogicOperator(true);
        if (joinWithCorrelazione) {
            sqlQueryObject.addWhereCondition("msgdiagnostici.idmessaggio=msgdiag_correlazione.idmessaggio");
            sqlQueryObject.addWhereCondition("msgdiagnostici.pdd_codice=msgdiag_correlazione.pdd_codice");
            sqlQueryObject.addWhereCondition("msgdiagnostici.pdd_tipo_soggetto=msgdiag_correlazione.pdd_tipo_soggetto");
            sqlQueryObject.addWhereCondition("msgdiagnostici.pdd_nome_soggetto=msgdiag_correlazione.pdd_nome_soggetto");
        }
        if (joinWithCorrelazioneSA) {
            sqlQueryObject.addWhereCondition("msgdiag_correlazione.id=msgdiag_correlazione_sa.id_correlazione");
        }
        if (DriverMsgDiagnosticiUtilities.isDefined(filter.getDataInizio())) {
            sqlQueryObject.addWhereCondition("msgdiagnostici.gdo>=?");
        }
        if (DriverMsgDiagnosticiUtilities.isDefined(filter.getDataFine())) {
            sqlQueryObject.addWhereCondition("msgdiagnostici.gdo<=?");
        }
        if (joinWithCorrelazione) {
            if (DriverMsgDiagnosticiUtilities.isDefined(filter.getDataInizio())) {
                sqlQueryObject.addWhereCondition("msgdiag_correlazione.gdo>=?");
            }
            if (DriverMsgDiagnosticiUtilities.isDefined(filter.getDataFine())) {
                sqlQueryObject.addWhereCondition("msgdiag_correlazione.gdo<=?");
            }
        }
        if (DriverMsgDiagnosticiUtilities.isDefined(filter.isDelegata())) {
            sqlQueryObject.addWhereCondition("msgdiag_correlazione.delegata=?");
        }
        if (DriverMsgDiagnosticiUtilities.isDefined(filter.getNomePorta())) {
            sqlQueryObject.addWhereCondition("msgdiag_correlazione.porta=?");
        }
        if (DriverMsgDiagnosticiUtilities.isDefined(filter.getIdFunzione())) {
            String idF = filter.getIdFunzione();
            if ("RicezioneContenutiApplicativi".equals(idF) || "Imbustamento".equals(idF) || "RicezioneBuste".equals(idF) || "Sbustamento".equals(idF)) {
                sqlQueryObject.addWhereLikeCondition("msgdiagnostici.idfunzione", idF, true, true);
            } else if ("InoltroBuste".equals(idF)) {
                sqlQueryObject.addWhereCondition(false, sqlQueryObject.getWhereLikeCondition("msgdiagnostici.idfunzione", idF), sqlQueryObject.getWhereLikeCondition("msgdiagnostici.idfunzione", "InoltroRisposte"));
            } else if ("ConsegnaContenutiApplicativi".equals(idF)) {
                sqlQueryObject.addWhereLikeCondition("msgdiagnostici.idfunzione", idF);
            } else {
                sqlQueryObject.addWhereCondition("msgdiagnostici.idfunzione=?");
            }
        }
        if (DriverMsgDiagnosticiUtilities.isDefined(filter.getDominio())) {
            if (DriverMsgDiagnosticiUtilities.isDefined(filter.getDominio().getCodicePorta())) {
                sqlQueryObject.addWhereCondition("msgdiagnostici.pdd_codice=?");
            }
            if (DriverMsgDiagnosticiUtilities.isDefined(filter.getDominio().getTipo())) {
                sqlQueryObject.addWhereCondition("msgdiagnostici.pdd_tipo_soggetto=?");
            }
            if (DriverMsgDiagnosticiUtilities.isDefined(filter.getDominio().getNome())) {
                sqlQueryObject.addWhereCondition("msgdiagnostici.pdd_nome_soggetto=?");
            }
        }
        if (DriverMsgDiagnosticiUtilities.isDefined(filter.getIdBustaRichiesta())) {
            sqlQueryObject.addWhereCondition("msgdiagnostici.idmessaggio=?");
        }
        if (DriverMsgDiagnosticiUtilities.isDefined(filter.getIdBustaRisposta())) {
            sqlQueryObject.addWhereCondition("msgdiagnostici.idmessaggio_risposta=?");
        }
        if (DriverMsgDiagnosticiUtilities.isDefined(filter.getInformazioniProtocollo())) {
            if (DriverMsgDiagnosticiUtilities.isDefined(filter.getInformazioniProtocollo().getFruitore())) {
                if (DriverMsgDiagnosticiUtilities.isDefined(filter.getInformazioniProtocollo().getFruitore().getTipo())) {
                    sqlQueryObject.addWhereCondition("msgdiag_correlazione.tipo_fruitore=?");
                }
                if (DriverMsgDiagnosticiUtilities.isDefined(filter.getInformazioniProtocollo().getFruitore().getNome())) {
                    sqlQueryObject.addWhereCondition("msgdiag_correlazione.fruitore=?");
                }
            }
            if (DriverMsgDiagnosticiUtilities.isDefined(filter.getInformazioniProtocollo().getErogatore())) {
                if (DriverMsgDiagnosticiUtilities.isDefined(filter.getInformazioniProtocollo().getErogatore().getTipo())) {
                    sqlQueryObject.addWhereCondition("msgdiag_correlazione.tipo_erogatore=?");
                }
                if (DriverMsgDiagnosticiUtilities.isDefined(filter.getInformazioniProtocollo().getErogatore().getNome())) {
                    sqlQueryObject.addWhereCondition("msgdiag_correlazione.erogatore=?");
                }
            }
            if (DriverMsgDiagnosticiUtilities.isDefined(filter.getInformazioniProtocollo().getTipoServizio())) {
                sqlQueryObject.addWhereCondition("msgdiag_correlazione.tipo_servizio=?");
            }
            if (DriverMsgDiagnosticiUtilities.isDefined(filter.getInformazioniProtocollo().getServizio())) {
                sqlQueryObject.addWhereCondition("msgdiag_correlazione.servizio=?");
            }
            if (DriverMsgDiagnosticiUtilities.isDefined(filter.getInformazioniProtocollo().getVersioneServizio())) {
                sqlQueryObject.addWhereCondition("msgdiag_correlazione.versione_servizio=?");
            }
            if (DriverMsgDiagnosticiUtilities.isDefined(filter.getInformazioniProtocollo().getAzione())) {
                sqlQueryObject.addWhereCondition("msgdiag_correlazione.azione=?");
            }
        }
        if (DriverMsgDiagnosticiUtilities.isDefined(filter.getServizioApplicativo())) {
            sqlQueryObject.addWhereCondition("msgdiag_correlazione_sa.servizio_applicativo=?");
        }
        if (DriverMsgDiagnosticiUtilities.isDefined(filter.getCorrelazioneApplicativa()) && DriverMsgDiagnosticiUtilities.isDefined(filter.getCorrelazioneApplicativaRisposta())) {
            sqlQueryObject.addWhereCondition(!filter.isCorrelazioneApplicativaOrMatch(), "msgdiag_correlazione.id_correlazione_applicativa=?", "msgdiag_correlazione.id_correlazione_risposta=?");
        } else if (DriverMsgDiagnosticiUtilities.isDefined(filter.getCorrelazioneApplicativa())) {
            sqlQueryObject.addWhereCondition("msgdiag_correlazione.id_correlazione_applicativa=?");
        } else if (DriverMsgDiagnosticiUtilities.isDefined(filter.getCorrelazioneApplicativaRisposta())) {
            sqlQueryObject.addWhereCondition("msgdiag_correlazione.id_correlazione_risposta=?");
        }
        if (DriverMsgDiagnosticiUtilities.isDefined(filter.getSeverita())) {
            sqlQueryObject.addWhereCondition("msgdiagnostici.severita<=?");
        }
        if (DriverMsgDiagnosticiUtilities.isDefined(filter.getCodice())) {
            sqlQueryObject.addWhereCondition("msgdiagnostici.codice=?");
        }
        if (DriverMsgDiagnosticiUtilities.isDefined(filter.getMessaggioCercatoInternamenteTestoDiagnostico())) {
            sqlQueryObject.addWhereLikeCondition("msgdiagnostici.messaggio", filter.getMessaggioCercatoInternamenteTestoDiagnostico(), true, true);
        }
        if (DriverMsgDiagnosticiUtilities.isDefined(filter.getProtocollo())) {
            sqlQueryObject.addWhereCondition("msgdiagnostici.protocollo=?");
        }
        if (filter.getProperties() != null) {
            Enumeration<String> keys = filter.getProperties().keys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                switch (tipoRicerca) {
                    case MSGDIAGNOSTICI: 
                    case COUNT_MSGDIAGNOSTICI: 
                    case DELETE_MSGDIAGNOSTICI: {
                        if ("@@@@@-----@@@@-----IDDIAGNOSTICI-DB----@@@@@-----@@@@".equals(key)) {
                            sqlQueryObject.addWhereCondition("msgdiagnostici.id=?");
                            break;
                        }
                        sqlQueryObject.addWhereCondition("msgdiagnostici." + key + "=?");
                        break;
                    }
                    case MSGDIAGNOSTICI_CORRELAZIONE: 
                    case COUNT_MSGDIAGNOSTICI_CORRELAZIONE: 
                    case DELETE_MSGDIAGNOSTICI_CORRELAZIONE: {
                        if ("@@@@@-----@@@@-----IDDIAGNOSTICI-DB----@@@@@-----@@@@".equals(key)) {
                            sqlQueryObject.addWhereCondition("msgdiag_correlazione.id=?");
                            break;
                        }
                        sqlQueryObject.addWhereCondition("msgdiag_correlazione." + key + "=?");
                    }
                }
            }
        }
        if (filter.getFiltroSoggetti() != null && filter.sizeFiltroSoggetti() > 0) {
            List<IDSoggetto> filtroSoggetti = filter.getFiltroSoggetti();
            StringBuffer query = new StringBuffer();
            for (int k = 0; k < filtroSoggetti.size(); ++k) {
                if (k > 0) {
                    query.append(" OR ");
                }
                query.append("( ");
                query.append("(msgdiag_correlazione.tipo_fruitore = ? AND msgdiag_correlazione.fruitore = ?)");
                query.append(" OR ");
                query.append("(msgdiag_correlazione.tipo_erogatore = ? AND msgdiag_correlazione.erogatore = ?)");
                query.append(" )");
            }
            sqlQueryObject.addWhereCondition(query.toString());
        }
        switch (tipoRicerca) {
            case MSGDIAGNOSTICI: 
            case MSGDIAGNOSTICI_CORRELAZIONE: {
                FiltroRicercaDiagnosticiConPaginazione f = (FiltroRicercaDiagnosticiConPaginazione)filter;
                if (f.getLimit() > 0) {
                    sqlQueryObject.setLimit(f.getLimit());
                }
                if (f.getOffset() > 0) {
                    sqlQueryObject.setOffset(f.getOffset());
                }
                sqlQueryObject.addOrderBy("gdo");
                sqlQueryObject.setSortType(f.isAsc());
                break;
            }
        }
        return sqlQueryObject;
    }

    public static int setValues_searchMessaggiDiagnostici(FiltroRicercaDiagnostici filter, Object object, int startIndex) throws SQLQueryObjectException, SQLException {
        return DriverMsgDiagnosticiUtilities.setValuesSearch(filter, object, startIndex, TipoRicercaDiagnostici.MSGDIAGNOSTICI);
    }

    public static int setValues_countMessaggiDiagnostici(FiltroRicercaDiagnostici filter, Object object, int startIndex) throws SQLQueryObjectException, SQLException {
        return DriverMsgDiagnosticiUtilities.setValuesSearch(filter, object, startIndex, TipoRicercaDiagnostici.COUNT_MSGDIAGNOSTICI);
    }

    public static int setValues_deleteMessaggiDiagnostici(FiltroRicercaDiagnostici filter, Object object, int startIndex) throws SQLQueryObjectException, SQLException {
        return DriverMsgDiagnosticiUtilities.setValuesSearch(filter, object, startIndex, TipoRicercaDiagnostici.DELETE_MSGDIAGNOSTICI);
    }

    public static int setValues_searchMsgDiagCorrelazione(FiltroRicercaDiagnostici filter, Object object, int startIndex) throws SQLQueryObjectException, SQLException {
        return DriverMsgDiagnosticiUtilities.setValuesSearch(filter, object, startIndex, TipoRicercaDiagnostici.MSGDIAGNOSTICI_CORRELAZIONE);
    }

    public static int setValues_countMsgDiagCorrelazione(FiltroRicercaDiagnostici filter, Object object, int startIndex) throws SQLQueryObjectException, SQLException {
        return DriverMsgDiagnosticiUtilities.setValuesSearch(filter, object, startIndex, TipoRicercaDiagnostici.COUNT_MSGDIAGNOSTICI_CORRELAZIONE);
    }

    public static int setValues_deleteMsgDiagCorrelazione(FiltroRicercaDiagnostici filter, Object object, int startIndex) throws SQLQueryObjectException, SQLException {
        return DriverMsgDiagnosticiUtilities.setValuesSearch(filter, object, startIndex, TipoRicercaDiagnostici.DELETE_MSGDIAGNOSTICI_CORRELAZIONE);
    }

    private static int setValuesSearch(FiltroRicercaDiagnostici filter, Object object, int startIndex, TipoRicercaDiagnostici tipoRicerca) throws SQLQueryObjectException, SQLException {
        String idF;
        SimpleDateFormat dateformat = new SimpleDateFormat(format);
        PreparedStatement pstmt = null;
        StringWrapper query = null;
        if (object instanceof PreparedStatement) {
            pstmt = (PreparedStatement)object;
        } else if (object instanceof StringWrapper) {
            query = (StringWrapper)object;
        } else {
            throw new SQLException("Tipo di parametro [" + object.getClass().getName() + "] non gestito");
        }
        if (DriverMsgDiagnosticiUtilities.isDefined(filter.getDataInizio())) {
            if (pstmt != null) {
                pstmt.setTimestamp(startIndex++, new Timestamp(filter.getDataInizio().getTime()));
            }
            if (query != null) {
                query.replaceFirst("\\?", "'" + dateformat.format(filter.getDataInizio()) + "'");
            }
        }
        if (DriverMsgDiagnosticiUtilities.isDefined(filter.getDataFine())) {
            if (pstmt != null) {
                pstmt.setTimestamp(startIndex++, new Timestamp(filter.getDataFine().getTime()));
            }
            if (query != null) {
                query.replaceFirst("\\?", "'" + dateformat.format(filter.getDataFine()) + "'");
            }
        }
        if (DriverMsgDiagnosticiUtilities.isJoinWithCorrelazione(filter, tipoRicerca)) {
            if (DriverMsgDiagnosticiUtilities.isDefined(filter.getDataInizio())) {
                if (pstmt != null) {
                    pstmt.setTimestamp(startIndex++, new Timestamp(filter.getDataInizio().getTime()));
                }
                if (query != null) {
                    query.replaceFirst("\\?", "'" + dateformat.format(filter.getDataInizio()) + "'");
                }
            }
            if (DriverMsgDiagnosticiUtilities.isDefined(filter.getDataFine())) {
                if (pstmt != null) {
                    pstmt.setTimestamp(startIndex++, new Timestamp(filter.getDataFine().getTime()));
                }
                if (query != null) {
                    query.replaceFirst("\\?", "'" + dateformat.format(filter.getDataFine()) + "'");
                }
            }
        }
        if (DriverMsgDiagnosticiUtilities.isDefined(filter.isDelegata())) {
            if (filter.isDelegata().booleanValue()) {
                if (pstmt != null) {
                    pstmt.setInt(startIndex++, 1);
                }
                if (query != null) {
                    query.replaceFirst("\\?", "1");
                }
            } else {
                if (pstmt != null) {
                    pstmt.setInt(startIndex++, 0);
                }
                if (query != null) {
                    query.replaceFirst("\\?", "0");
                }
            }
        }
        if (DriverMsgDiagnosticiUtilities.isDefined(filter.getNomePorta())) {
            if (pstmt != null) {
                pstmt.setString(startIndex++, filter.getNomePorta());
            }
            if (query != null) {
                query.replaceFirst("\\?", "'" + filter.getNomePorta() + "'");
            }
        }
        if (!(!DriverMsgDiagnosticiUtilities.isDefined(filter.getIdFunzione()) || "RicezioneContenutiApplicativi".equals(idF = filter.getIdFunzione()) || "Imbustamento".equals(idF) || "RicezioneBuste".equals(idF) || "Sbustamento".equals(idF) || "InoltroBuste".equals(idF) || "ConsegnaContenutiApplicativi".equals(idF))) {
            if (pstmt != null) {
                pstmt.setString(startIndex++, idF);
            }
            if (query != null) {
                query.replaceFirst("\\?", "'" + idF + "'");
            }
        }
        if (DriverMsgDiagnosticiUtilities.isDefined(filter.getDominio())) {
            if (DriverMsgDiagnosticiUtilities.isDefined(filter.getDominio().getCodicePorta())) {
                if (pstmt != null) {
                    pstmt.setString(startIndex++, filter.getDominio().getCodicePorta());
                }
                if (query != null) {
                    query.replaceFirst("\\?", "'" + filter.getDominio().getCodicePorta() + "'");
                }
            }
            if (DriverMsgDiagnosticiUtilities.isDefined(filter.getDominio().getTipo())) {
                if (pstmt != null) {
                    pstmt.setString(startIndex++, filter.getDominio().getTipo());
                }
                if (query != null) {
                    query.replaceFirst("\\?", "'" + filter.getDominio().getTipo() + "'");
                }
            }
            if (DriverMsgDiagnosticiUtilities.isDefined(filter.getDominio().getNome())) {
                if (pstmt != null) {
                    pstmt.setString(startIndex++, filter.getDominio().getNome());
                }
                if (query != null) {
                    query.replaceFirst("\\?", "'" + filter.getDominio().getNome() + "'");
                }
            }
        }
        if (DriverMsgDiagnosticiUtilities.isDefined(filter.getIdBustaRichiesta())) {
            if (pstmt != null) {
                pstmt.setString(startIndex++, filter.getIdBustaRichiesta());
            }
            if (query != null) {
                query.replaceFirst("\\?", "'" + filter.getIdBustaRichiesta() + "'");
            }
        }
        if (DriverMsgDiagnosticiUtilities.isDefined(filter.getIdBustaRisposta())) {
            if (pstmt != null) {
                pstmt.setString(startIndex++, filter.getIdBustaRisposta());
            }
            if (query != null) {
                query.replaceFirst("\\?", "'" + filter.getIdBustaRisposta() + "'");
            }
        }
        if (DriverMsgDiagnosticiUtilities.isDefined(filter.getInformazioniProtocollo())) {
            if (DriverMsgDiagnosticiUtilities.isDefined(filter.getInformazioniProtocollo().getFruitore())) {
                if (DriverMsgDiagnosticiUtilities.isDefined(filter.getInformazioniProtocollo().getFruitore().getTipo())) {
                    if (pstmt != null) {
                        pstmt.setString(startIndex++, filter.getInformazioniProtocollo().getFruitore().getTipo());
                    }
                    if (query != null) {
                        query.replaceFirst("\\?", "'" + filter.getInformazioniProtocollo().getFruitore().getTipo() + "'");
                    }
                }
                if (DriverMsgDiagnosticiUtilities.isDefined(filter.getInformazioniProtocollo().getFruitore().getNome())) {
                    if (pstmt != null) {
                        pstmt.setString(startIndex++, filter.getInformazioniProtocollo().getFruitore().getNome());
                    }
                    if (query != null) {
                        query.replaceFirst("\\?", "'" + filter.getInformazioniProtocollo().getFruitore().getNome() + "'");
                    }
                }
            }
            if (DriverMsgDiagnosticiUtilities.isDefined(filter.getInformazioniProtocollo().getErogatore())) {
                if (DriverMsgDiagnosticiUtilities.isDefined(filter.getInformazioniProtocollo().getErogatore().getTipo())) {
                    if (pstmt != null) {
                        pstmt.setString(startIndex++, filter.getInformazioniProtocollo().getErogatore().getTipo());
                    }
                    if (query != null) {
                        query.replaceFirst("\\?", "'" + filter.getInformazioniProtocollo().getErogatore().getTipo() + "'");
                    }
                }
                if (DriverMsgDiagnosticiUtilities.isDefined(filter.getInformazioniProtocollo().getErogatore().getNome())) {
                    if (pstmt != null) {
                        pstmt.setString(startIndex++, filter.getInformazioniProtocollo().getErogatore().getNome());
                    }
                    if (query != null) {
                        query.replaceFirst("\\?", "'" + filter.getInformazioniProtocollo().getErogatore().getNome() + "'");
                    }
                }
            }
            if (DriverMsgDiagnosticiUtilities.isDefined(filter.getInformazioniProtocollo().getTipoServizio())) {
                if (pstmt != null) {
                    pstmt.setString(startIndex++, filter.getInformazioniProtocollo().getTipoServizio());
                }
                if (query != null) {
                    query.replaceFirst("\\?", "'" + filter.getInformazioniProtocollo().getTipoServizio() + "'");
                }
            }
            if (DriverMsgDiagnosticiUtilities.isDefined(filter.getInformazioniProtocollo().getServizio())) {
                if (pstmt != null) {
                    pstmt.setString(startIndex++, filter.getInformazioniProtocollo().getServizio());
                }
                if (query != null) {
                    query.replaceFirst("\\?", "'" + filter.getInformazioniProtocollo().getServizio() + "'");
                }
            }
            if (DriverMsgDiagnosticiUtilities.isDefined(filter.getInformazioniProtocollo().getVersioneServizio())) {
                if (pstmt != null) {
                    pstmt.setInt(startIndex++, filter.getInformazioniProtocollo().getVersioneServizio());
                }
                if (query != null) {
                    query.replaceFirst("\\?", "" + filter.getInformazioniProtocollo().getVersioneServizio());
                }
            }
            if (DriverMsgDiagnosticiUtilities.isDefined(filter.getInformazioniProtocollo().getAzione())) {
                if (pstmt != null) {
                    pstmt.setString(startIndex++, filter.getInformazioniProtocollo().getAzione());
                }
                if (query != null) {
                    query.replaceFirst("\\?", "'" + filter.getInformazioniProtocollo().getAzione() + "'");
                }
            }
        }
        if (DriverMsgDiagnosticiUtilities.isDefined(filter.getServizioApplicativo())) {
            if (pstmt != null) {
                pstmt.setString(startIndex++, filter.getServizioApplicativo());
            }
            if (query != null) {
                query.replaceFirst("\\?", "'" + filter.getServizioApplicativo() + "'");
            }
        }
        if (DriverMsgDiagnosticiUtilities.isDefined(filter.getCorrelazioneApplicativa()) && DriverMsgDiagnosticiUtilities.isDefined(filter.getCorrelazioneApplicativaRisposta())) {
            if (pstmt != null) {
                pstmt.setString(startIndex++, filter.getCorrelazioneApplicativa());
            }
            if (query != null) {
                query.replaceFirst("\\?", "'" + filter.getCorrelazioneApplicativa() + "'");
            }
            if (pstmt != null) {
                pstmt.setString(startIndex++, filter.getCorrelazioneApplicativaRisposta());
            }
            if (query != null) {
                query.replaceFirst("\\?", "'" + filter.getCorrelazioneApplicativaRisposta() + "'");
            }
        } else if (DriverMsgDiagnosticiUtilities.isDefined(filter.getCorrelazioneApplicativa())) {
            if (pstmt != null) {
                pstmt.setString(startIndex++, filter.getCorrelazioneApplicativa());
            }
            if (query != null) {
                query.replaceFirst("\\?", "'" + filter.getCorrelazioneApplicativa() + "'");
            }
        } else if (DriverMsgDiagnosticiUtilities.isDefined(filter.getCorrelazioneApplicativaRisposta())) {
            if (pstmt != null) {
                pstmt.setString(startIndex++, filter.getCorrelazioneApplicativaRisposta());
            }
            if (query != null) {
                query.replaceFirst("\\?", "'" + filter.getCorrelazioneApplicativaRisposta() + "'");
            }
        }
        if (DriverMsgDiagnosticiUtilities.isDefined(filter.getSeverita())) {
            if (pstmt != null) {
                pstmt.setInt(startIndex++, filter.getSeverita());
            }
            if (query != null) {
                query.replaceFirst("\\?", "" + filter.getSeverita());
            }
        }
        if (DriverMsgDiagnosticiUtilities.isDefined(filter.getCodice())) {
            if (pstmt != null) {
                pstmt.setString(startIndex++, filter.getCodice());
            }
            if (query != null) {
                query.replaceFirst("\\?", "'" + filter.getCodice() + "'");
            }
        }
        if (DriverMsgDiagnosticiUtilities.isDefined(filter.getProtocollo())) {
            if (pstmt != null) {
                pstmt.setString(startIndex++, filter.getProtocollo());
            }
            if (query != null) {
                query.replaceFirst("\\?", "'" + filter.getProtocollo() + "'");
            }
        }
        if (filter.getProperties() != null) {
            Enumeration<String> keys = filter.getProperties().keys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                String value = filter.getProperties().get(key);
                if ("@@@@@-----@@@@-----IDDIAGNOSTICI-DB----@@@@@-----@@@@".equals(key)) {
                    if (pstmt != null) {
                        pstmt.setLong(startIndex++, Long.parseLong(value));
                    }
                    if (query == null) continue;
                    query.replaceFirst("\\?", value);
                    continue;
                }
                if (pstmt != null) {
                    pstmt.setString(startIndex++, value);
                }
                if (query == null) continue;
                query.replaceFirst("\\?", "'" + value + "'");
            }
        }
        if (filter.getFiltroSoggetti() != null && filter.sizeFiltroSoggetti() > 0) {
            List<IDSoggetto> filtroSoggetti = filter.getFiltroSoggetti();
            for (int k = 0; k < filtroSoggetti.size(); ++k) {
                IDSoggetto id = filtroSoggetti.get(k);
                if (pstmt != null) {
                    pstmt.setString(startIndex++, id.getTipo());
                }
                if (pstmt != null) {
                    pstmt.setString(startIndex++, id.getNome());
                }
                if (pstmt != null) {
                    pstmt.setString(startIndex++, id.getTipo());
                }
                if (pstmt != null) {
                    pstmt.setString(startIndex++, id.getNome());
                }
                if (query != null) {
                    query.replaceFirst("\\?", "'" + id.getTipo() + "'");
                }
                if (query != null) {
                    query.replaceFirst("\\?", "'" + id.getNome() + "'");
                }
                if (query != null) {
                    query.replaceFirst("\\?", "'" + id.getTipo() + "'");
                }
                if (query == null) continue;
                query.replaceFirst("\\?", "'" + id.getNome() + "'");
            }
        }
        return startIndex;
    }

    public static MsgDiagnostico getMsgDiagnostico(Connection c, String tipoDatabase, Logger log, long id, Vector<String> properties) throws Exception {
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDatabase);
        sqlQueryObject.addFromTable("msgdiagnostici");
        sqlQueryObject.addWhereCondition("id=?");
        log.debug("Eseguo query : " + sqlQueryObject.createSQLQuery().replaceFirst("\\?", "" + id));
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = c.prepareStatement(sqlQueryObject.createSQLQuery());
            stmt.setLong(1, id);
            rs = stmt.executeQuery();
            if (rs.next()) {
                MsgDiagnostico msg = new MsgDiagnostico();
                msg.setId(rs.getLong("id"));
                msg.addProperty("@@@@@-----@@@@-----IDDIAGNOSTICI-DB----@@@@@-----@@@@", "" + msg.getId());
                Timestamp gdo = rs.getTimestamp("gdo");
                msg.setGdo(gdo);
                IDSoggetto idSoggetto = new IDSoggetto();
                idSoggetto.setCodicePorta(rs.getString("pdd_codice"));
                idSoggetto.setNome(rs.getString("pdd_nome_soggetto"));
                idSoggetto.setTipo(rs.getString("pdd_tipo_soggetto"));
                msg.setIdSoggetto(idSoggetto);
                msg.setIdFunzione(rs.getString("idfunzione"));
                msg.setSeverita(rs.getInt("severita"));
                msg.setMessaggio(rs.getString("messaggio"));
                msg.setIdBusta(rs.getString("idmessaggio"));
                msg.setIdBustaRisposta(rs.getString("idmessaggio_risposta"));
                msg.setCodice(rs.getString("codice"));
                msg.setProtocollo(rs.getString("protocollo"));
                if (properties != null) {
                    for (int i = 0; i < properties.size(); ++i) {
                        String key = properties.get(i);
                        msg.addProperty(key, rs.getString(key));
                    }
                }
                MsgDiagnostico msgDiagnostico = msg;
                return msgDiagnostico;
            }
            throw new Exception("MsgDiagnostico con id[" + id + "] non trovato");
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MsgDiagnosticoCorrelazione getMsgDiagnosticoCorrelazione(Connection c, String tipoDatabase, Logger log, long id, Vector<String> properties) throws Exception {
        ResultSet rs;
        PreparedStatement stmt;
        MsgDiagnosticoCorrelazione msg;
        ISQLQueryObject sqlQueryObject;
        block22: {
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDatabase);
            sqlQueryObject.addFromTable("msgdiag_correlazione");
            sqlQueryObject.addWhereCondition("id=?");
            msg = null;
            log.debug("Eseguo query : " + sqlQueryObject.createSQLQuery().replaceFirst("\\?", "" + id));
            stmt = null;
            rs = null;
            try {
                stmt = c.prepareStatement(sqlQueryObject.createSQLQuery());
                stmt.setLong(1, id);
                rs = stmt.executeQuery();
                if (rs.next()) {
                    msg = new MsgDiagnosticoCorrelazione();
                    msg.setId(rs.getLong("id"));
                    msg.addProperty("@@@@@-----@@@@-----IDDIAGNOSTICI-DB----@@@@@-----@@@@", "" + msg.getId());
                    msg.setIdBusta(rs.getString("idmessaggio"));
                    IDSoggetto idSoggetto = new IDSoggetto();
                    idSoggetto.setCodicePorta(rs.getString("pdd_codice"));
                    idSoggetto.setNome(rs.getString("pdd_nome_soggetto"));
                    idSoggetto.setTipo(rs.getString("pdd_tipo_soggetto"));
                    msg.setIdSoggetto(idSoggetto);
                    Timestamp gdo = rs.getTimestamp("gdo");
                    msg.setGdo(gdo);
                    msg.setNomePorta(rs.getString("porta"));
                    int isDelegata = rs.getInt("delegata");
                    msg.setDelegata(isDelegata == 1);
                    InformazioniProtocollo info = new InformazioniProtocollo();
                    info.setFruitore(new IDSoggetto(rs.getString("tipo_fruitore"), rs.getString("fruitore")));
                    info.setErogatore(new IDSoggetto(rs.getString("tipo_erogatore"), rs.getString("erogatore")));
                    info.setTipoServizio(rs.getString("tipo_servizio"));
                    info.setServizio(rs.getString("servizio"));
                    info.setVersioneServizio(rs.getInt("versione_servizio"));
                    info.setAzione(rs.getString("azione"));
                    msg.setInformazioniProtocollo(info);
                    msg.setCorrelazioneApplicativa(rs.getString("id_correlazione_applicativa"));
                    msg.setCorrelazioneApplicativaRisposta(rs.getString("id_correlazione_risposta"));
                    msg.setProtocollo(rs.getString("protocollo"));
                    if (properties != null) {
                        for (int i = 0; i < properties.size(); ++i) {
                            String key = properties.get(i);
                            msg.addProperty(key, rs.getString(key));
                        }
                    }
                    break block22;
                }
                throw new Exception("MsgDiagnostico con id[" + id + "] non trovato");
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception idSoggetto) {}
            }
        }
        sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDatabase);
        sqlQueryObject.addSelectField("servizio_applicativo");
        sqlQueryObject.addFromTable("msgdiag_correlazione");
        sqlQueryObject.addFromTable("msgdiag_correlazione_sa");
        sqlQueryObject.setANDLogicOperator(true);
        sqlQueryObject.addWhereCondition("msgdiag_correlazione.id=?");
        sqlQueryObject.addWhereCondition("msgdiag_correlazione.id=msgdiag_correlazione_sa.id_correlazione");
        log.debug("Eseguo query : " + sqlQueryObject.createSQLQuery().replaceFirst("\\?", "" + id));
        stmt = null;
        rs = null;
        try {
            stmt = c.prepareStatement(sqlQueryObject.createSQLQuery());
            stmt.setLong(1, id);
            rs = stmt.executeQuery();
            ArrayList<String> list = new ArrayList<String>();
            while (rs.next()) {
                list.add(rs.getString("servizio_applicativo"));
            }
            msg.setServiziApplicativiList(list);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
        }
        return msg;
    }

    protected static boolean isDefined(String v) {
        return v != null && !"".equals(v);
    }

    protected static boolean isDefined(Boolean v) {
        return v != null;
    }

    protected static boolean isDefined(Integer v) {
        return v != null;
    }

    protected static boolean isDefined(InformazioniProtocollo v) {
        return v != null;
    }

    protected static boolean isDefined(List<?> v) {
        return v != null && v.size() > 0;
    }

    protected static boolean isDefined(Date v) {
        return v != null;
    }

    protected static boolean isDefined(IDSoggetto v) {
        return v != null;
    }
}

