/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.basic.diagnostica;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.basic.diagnostica.DriverMsgDiagnosticiUtilities;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.diagnostica.FiltroRicercaDiagnosticiConPaginazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.diagnostica.InformazioniProtocollo;
import it.link.pdd.tools.migrazione_govway.utils.sql.ISQLQueryObject;
import it.link.pdd.tools.migrazione_govway.utils.sql.SQLObjectFactory;
import it.link.pdd.tools.migrazione_govway.utils.sql.SQLQueryObjectException;
import java.util.Vector;
import org.slf4j.Logger;

public class DriverMsgDiagnosticiUnionUtilities {
    public static ISQLQueryObject createSQLQueryObjCorrelazione(FiltroRicercaDiagnosticiConPaginazione filter, boolean setLimit, Logger log, String tipoDatabase, Vector<String> properties) throws SQLQueryObjectException {
        InformazioniProtocollo infoBusta;
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDatabase);
        sqlQueryObject.addFromTable("msgdiag_correlazione");
        if (filter.getServizioApplicativo() != null && !"".equals(filter.getServizioApplicativo())) {
            sqlQueryObject.addFromTable("msgdiag_correlazione_sa");
        }
        sqlQueryObject.addSelectField("msgdiag_correlazione", "idmessaggio");
        sqlQueryObject.addSelectField("msgdiag_correlazione", "gdo");
        sqlQueryObject.addSelectField("msgdiag_correlazione", "porta");
        sqlQueryObject.addSelectField("msgdiag_correlazione", "delegata");
        sqlQueryObject.addSelectField("msgdiag_correlazione", "tipo_fruitore");
        sqlQueryObject.addSelectField("msgdiag_correlazione", "fruitore");
        sqlQueryObject.addSelectField("msgdiag_correlazione", "tipo_erogatore");
        sqlQueryObject.addSelectField("msgdiag_correlazione", "erogatore");
        sqlQueryObject.addSelectField("msgdiag_correlazione", "tipo_servizio");
        sqlQueryObject.addSelectField("msgdiag_correlazione", "servizio");
        sqlQueryObject.addSelectField("msgdiag_correlazione", "azione");
        sqlQueryObject.addSelectField("msgdiag_correlazione", "id");
        sqlQueryObject.addSelectField("msgdiag_correlazione", "id_correlazione_applicativa");
        sqlQueryObject.addSelectField("msgdiag_correlazione", "id_correlazione_risposta");
        if (properties != null) {
            for (int i = 0; i < properties.size(); ++i) {
                String key = properties.get(i);
                sqlQueryObject.addSelectField("msgdiag_correlazione", key);
            }
        }
        sqlQueryObject.addSelectAliasField("null", "pdd_codice");
        sqlQueryObject.addSelectAliasField("null", "pdd_tipo_soggetto");
        sqlQueryObject.addSelectAliasField("null", "pdd_nome_soggetto");
        sqlQueryObject.addSelectAliasField("null", "idfunzione");
        sqlQueryObject.addSelectAliasField("null", "severita");
        sqlQueryObject.addSelectAliasField("null", "idmessaggio_risposta");
        sqlQueryObject.addSelectAliasField("null", "messaggio");
        sqlQueryObject.addSelectAliasField("null", "codice");
        sqlQueryObject.setANDLogicOperator(true);
        if (filter.getDataInizio() != null) {
            sqlQueryObject.addWhereCondition("msgdiag_correlazione.gdo>=?");
        }
        if (filter.getDataFine() != null) {
            sqlQueryObject.addWhereCondition("msgdiag_correlazione.gdo<=?");
        }
        if (filter.getIdBustaRichiesta() != null && !"".equals(filter.getIdBustaRichiesta())) {
            sqlQueryObject.addWhereCondition("msgdiag_correlazione.idmessaggio=?");
        }
        if (filter.getNomePorta() != null && !"".equals(filter.getNomePorta())) {
            sqlQueryObject.addWhereCondition("msgdiag_correlazione.porta='" + filter.getNomePorta() + "'");
        }
        if (filter.isDelegata() != null) {
            sqlQueryObject.addWhereCondition("msgdiag_correlazione.delegata=" + (filter.isDelegata() != false ? 1 : 0));
        }
        if (DriverMsgDiagnosticiUtilities.isDefined(filter.getCorrelazioneApplicativa()) && DriverMsgDiagnosticiUtilities.isDefined(filter.getCorrelazioneApplicativaRisposta())) {
            sqlQueryObject.addWhereCondition(!filter.isCorrelazioneApplicativaOrMatch(), "msgdiag_correlazione.id_correlazione_applicativa='" + sqlQueryObject.escapeStringValue(filter.getCorrelazioneApplicativa()) + "'", "msgdiag_correlazione.id_correlazione_risposta='" + sqlQueryObject.escapeStringValue(filter.getCorrelazioneApplicativaRisposta()) + "'");
        } else if (DriverMsgDiagnosticiUtilities.isDefined(filter.getCorrelazioneApplicativa())) {
            sqlQueryObject.addWhereCondition("msgdiag_correlazione.id_correlazione_applicativa='" + sqlQueryObject.escapeStringValue(filter.getCorrelazioneApplicativa()) + "'");
        } else if (DriverMsgDiagnosticiUtilities.isDefined(filter.getCorrelazioneApplicativaRisposta())) {
            sqlQueryObject.addWhereCondition("msgdiag_correlazione.id_correlazione_risposta='" + sqlQueryObject.escapeStringValue(filter.getCorrelazioneApplicativaRisposta()) + "'");
        }
        if (filter.getServizioApplicativo() != null && !"".equals(filter.getServizioApplicativo())) {
            sqlQueryObject.addWhereCondition("msgdiag_correlazione.id=msgdiag_correlazione_sa.id_correlazione");
            sqlQueryObject.addWhereCondition("msgdiag_correlazione_sa.servizio_applicativo='" + filter.getServizioApplicativo() + "'");
        }
        if ((infoBusta = filter.getInformazioniProtocollo()) != null) {
            if (infoBusta.getFruitore() != null) {
                if (infoBusta.getFruitore().getTipo() != null && !"".equals(infoBusta.getFruitore().getTipo())) {
                    sqlQueryObject.addWhereCondition("msgdiag_correlazione.tipo_fruitore='" + infoBusta.getFruitore().getTipo() + "'");
                }
                if (infoBusta.getFruitore().getNome() != null && !"".equals(infoBusta.getFruitore().getNome())) {
                    sqlQueryObject.addWhereCondition("msgdiag_correlazione.fruitore='" + infoBusta.getFruitore().getNome() + "'");
                }
            }
            if (infoBusta.getErogatore() != null) {
                if (infoBusta.getErogatore().getTipo() != null && !"".equals(infoBusta.getErogatore().getTipo())) {
                    sqlQueryObject.addWhereCondition("msgdiag_correlazione.tipo_erogatore='" + infoBusta.getErogatore().getTipo() + "'");
                }
                if (infoBusta.getErogatore().getNome() != null && !"".equals(infoBusta.getErogatore().getNome())) {
                    sqlQueryObject.addWhereCondition("msgdiag_correlazione.erogatore='" + infoBusta.getErogatore().getNome() + "'");
                }
            }
            if (infoBusta.getServizio() != null) {
                if (infoBusta.getTipoServizio() != null && !"".equals(infoBusta.getTipoServizio())) {
                    sqlQueryObject.addWhereCondition("msgdiag_correlazione.tipo_servizio='" + infoBusta.getTipoServizio() + "'");
                }
                if (infoBusta.getServizio() != null && !"".equals(infoBusta.getServizio())) {
                    sqlQueryObject.addWhereCondition("msgdiag_correlazione.servizio='" + infoBusta.getServizio() + "'");
                }
            }
            if (infoBusta.getAzione() != null && !"".equals(infoBusta.getAzione())) {
                sqlQueryObject.addWhereCondition("msgdiag_correlazione.azione='" + infoBusta.getAzione() + "'");
            }
        }
        sqlQueryObject.addOrderBy("gdo");
        sqlQueryObject.setSortType(false);
        if (setLimit) {
            sqlQueryObject.setLimit(filter.getLimit());
            log.debug("Limit :" + filter.getLimit());
            long offset = filter.getOffsetMap() != null && filter.getOffsetMap().length > 2 ? filter.getOffsetMap()[0] : 0L;
            log.debug("Offset : " + offset);
            sqlQueryObject.setOffset((int)offset);
        }
        return sqlQueryObject;
    }

    public static ISQLQueryObject createSqlQueryObjDiagnostici(FiltroRicercaDiagnosticiConPaginazione filter, boolean setLimit, Logger log, String tipoDatabase, Vector<String> properties) throws SQLQueryObjectException {
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDatabase);
        sqlQueryObject.addSelectField("idmessaggio");
        sqlQueryObject.addSelectField("gdo");
        sqlQueryObject.addSelectAliasField("null", "porta");
        sqlQueryObject.addSelectAliasField("null", "delegata");
        sqlQueryObject.addSelectAliasField("null", "tipo_fruitore");
        sqlQueryObject.addSelectAliasField("null", "fruitore");
        sqlQueryObject.addSelectAliasField("null", "tipo_erogatore");
        sqlQueryObject.addSelectAliasField("null", "erogatore");
        sqlQueryObject.addSelectAliasField("null", "tipo_servizio");
        sqlQueryObject.addSelectAliasField("null", "servizio");
        sqlQueryObject.addSelectAliasField("null", "azione");
        sqlQueryObject.addSelectField("id");
        sqlQueryObject.addSelectAliasField("null", "id_correlazione_applicativa");
        sqlQueryObject.addSelectAliasField("null", "id_correlazione_risposta");
        if (properties != null) {
            for (int i = 0; i < properties.size(); ++i) {
                String key = properties.get(i);
                sqlQueryObject.addSelectAliasField("null", key);
            }
        }
        sqlQueryObject.addSelectField("pdd_codice");
        sqlQueryObject.addSelectField("pdd_tipo_soggetto");
        sqlQueryObject.addSelectField("pdd_nome_soggetto");
        sqlQueryObject.addSelectField("idfunzione");
        sqlQueryObject.addSelectField("severita");
        sqlQueryObject.addSelectField("idmessaggio_risposta");
        sqlQueryObject.addSelectField("messaggio");
        sqlQueryObject.addSelectField("codice");
        sqlQueryObject.addFromTable("msgdiagnostici");
        sqlQueryObject.setANDLogicOperator(true);
        if (filter.getDataInizio() != null) {
            sqlQueryObject.addWhereCondition("msgdiagnostici.gdo>=?");
        }
        if (filter.getDataFine() != null) {
            sqlQueryObject.addWhereCondition("msgdiagnostici.gdo<=?");
        }
        if (filter.getIdBustaRichiesta() != null && !"".equals(filter.getIdBustaRichiesta())) {
            sqlQueryObject.addWhereCondition("msgdiagnostici.idmessaggio=?");
        } else {
            sqlQueryObject.addWhereCondition("msgdiagnostici.idmessaggio is NULL");
        }
        sqlQueryObject.addOrderBy("gdo");
        sqlQueryObject.setSortType(false);
        if (setLimit) {
            sqlQueryObject.setLimit(filter.getLimit());
            log.debug("Limit:" + filter.getLimit());
            long offset = filter.getOffsetMap() != null && filter.getOffsetMap().length > 2 ? filter.getOffsetMap()[1] : 0L;
            log.debug("Offset : " + offset);
            sqlQueryObject.setOffset((int)offset);
        }
        return sqlQueryObject;
    }

    public static ISQLQueryObject createQueryObjDiagnosticiNotExist(FiltroRicercaDiagnosticiConPaginazione filter, boolean setLimit, Logger log, String tipoDatabase, Vector<String> properties) throws SQLQueryObjectException {
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDatabase);
        ISQLQueryObject innerObj = SQLObjectFactory.createSQLQueryObject(tipoDatabase);
        sqlQueryObject.addSelectField("idmessaggio");
        sqlQueryObject.addSelectField("gdo");
        sqlQueryObject.addSelectAliasField("null", "porta");
        sqlQueryObject.addSelectAliasField("null", "delegata");
        sqlQueryObject.addSelectAliasField("null", "tipo_fruitore");
        sqlQueryObject.addSelectAliasField("null", "fruitore");
        sqlQueryObject.addSelectAliasField("null", "tipo_erogatore");
        sqlQueryObject.addSelectAliasField("null", "erogatore");
        sqlQueryObject.addSelectAliasField("null", "tipo_servizio");
        sqlQueryObject.addSelectAliasField("null", "servizio");
        sqlQueryObject.addSelectAliasField("null", "azione");
        sqlQueryObject.addSelectField("id");
        sqlQueryObject.addSelectAliasField("null", "id_correlazione_applicativa");
        sqlQueryObject.addSelectAliasField("null", "id_correlazione_risposta");
        if (properties != null) {
            for (int i = 0; i < properties.size(); ++i) {
                String key = properties.get(i);
                sqlQueryObject.addSelectAliasField("null", key);
            }
        }
        sqlQueryObject.addSelectField("pdd_codice");
        sqlQueryObject.addSelectField("pdd_tipo_soggetto");
        sqlQueryObject.addSelectField("pdd_nome_soggetto");
        sqlQueryObject.addSelectField("idfunzione");
        sqlQueryObject.addSelectField("severita");
        sqlQueryObject.addSelectField("idmessaggio_risposta");
        sqlQueryObject.addSelectField("messaggio");
        sqlQueryObject.addSelectField("codice");
        sqlQueryObject.addFromTable("msgdiagnostici");
        sqlQueryObject.setANDLogicOperator(true);
        if (filter.getDataInizio() != null) {
            sqlQueryObject.addWhereCondition("msgdiagnostici.gdo>=?");
        }
        if (filter.getDataFine() != null) {
            sqlQueryObject.addWhereCondition("msgdiagnostici.gdo<=?");
        }
        if (filter.getIdBustaRichiesta() != null && !"".equals(filter.getIdBustaRichiesta())) {
            sqlQueryObject.addWhereCondition("msgdiagnostici.idmessaggio=?");
        }
        innerObj.addFromTable("msgdiag_correlazione");
        innerObj.addWhereCondition("msgdiag_correlazione.idmessaggio=msgdiagnostici.idmessaggio");
        sqlQueryObject.addWhereExistsCondition(true, innerObj);
        sqlQueryObject.addOrderBy("gdo");
        sqlQueryObject.setSortType(false);
        if (setLimit) {
            sqlQueryObject.setLimit(filter.getLimit());
            log.debug("Limit : " + filter.getLimit());
            long offset = filter.getOffsetMap() != null && filter.getOffsetMap().length > 2 ? filter.getOffsetMap()[2] : 0L;
            log.debug("Offset : " + offset);
            sqlQueryObject.setOffset((int)offset);
        }
        return sqlQueryObject;
    }

    public static String createUnionObj(FiltroRicercaDiagnosticiConPaginazione filter, Logger log, String tipoDatabase, Vector<String> properties) throws SQLQueryObjectException {
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDatabase);
        sqlQueryObject.addOrderBy("gdo");
        sqlQueryObject.setSortType(false);
        sqlQueryObject.setLimit(filter.getLimit());
        if (filter.isPartial()) {
            return sqlQueryObject.createSQLUnion(false, DriverMsgDiagnosticiUnionUtilities.createSQLQueryObjCorrelazione(filter, true, log, tipoDatabase, properties), DriverMsgDiagnosticiUnionUtilities.createSqlQueryObjDiagnostici(filter, true, log, tipoDatabase, properties));
        }
        return sqlQueryObject.createSQLUnion(false, DriverMsgDiagnosticiUnionUtilities.createSQLQueryObjCorrelazione(filter, true, log, tipoDatabase, properties), DriverMsgDiagnosticiUnionUtilities.createSqlQueryObjDiagnostici(filter, true, log, tipoDatabase, properties), DriverMsgDiagnosticiUnionUtilities.createQueryObjDiagnosticiNotExist(filter, true, log, tipoDatabase, properties));
    }
}

