/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.basic.diagnostica;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDServizio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.basic.diagnostica.DriverMsgDiagnosticiUnionUtilities;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.basic.diagnostica.DriverMsgDiagnosticiUtilities;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.IProtocolFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.diagnostica.DriverMsgDiagnosticiException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.diagnostica.DriverMsgDiagnosticiNotFoundException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.diagnostica.FiltroRicercaDiagnostici;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.diagnostica.FiltroRicercaDiagnosticiConPaginazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.diagnostica.IDriverMsgDiagnostici;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.diagnostica.InformazioniProtocollo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.diagnostica.MsgDiagnostico;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.diagnostica.MsgDiagnosticoCorrelazione;
import it.link.pdd.tools.migrazione_govway.utils.LoggerWrapperFactory;
import it.link.pdd.tools.migrazione_govway.utils.StringWrapper;
import it.link.pdd.tools.migrazione_govway.utils.TipiDatabase;
import it.link.pdd.tools.migrazione_govway.utils.resources.GestoreJNDI;
import it.link.pdd.tools.migrazione_govway.utils.sql.ISQLQueryObject;
import it.link.pdd.tools.migrazione_govway.utils.sql.SQLObjectFactory;
import it.link.pdd.tools.migrazione_govway.utils.sql.SQLQueryObjectException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.sql.DataSource;
import org.slf4j.Logger;

public class DriverMsgDiagnostici
implements IDriverMsgDiagnostici {
    DataSource datasource = null;
    String tipoDatabase = null;
    Connection con = null;
    boolean connectionOpenViaJDBCInCostructor = false;
    private Logger log = null;
    protected IProtocolFactory protocolFactory;
    public static final String IDDIAGNOSTICI = "@@@@@-----@@@@-----IDDIAGNOSTICI-DB----@@@@@-----@@@@";
    private Vector<String> propertiesMsgDiagnostici;
    private Vector<String> propertiesMsgDiagCorrelazione;

    public DriverMsgDiagnostici(IProtocolFactory factory) {
        this.log = factory.getLogger();
        this.protocolFactory = factory;
    }

    @Override
    public IProtocolFactory getProtocolFactory() {
        return this.protocolFactory;
    }

    public void setPropertiesMsgDiagnostici(Vector<String> properties) {
        this.propertiesMsgDiagnostici = properties;
    }

    public void setPropertiesMsgDiagCorrelazione(Vector<String> properties) {
        this.propertiesMsgDiagCorrelazione = properties;
    }

    public void init(String nomeDataSource, String tipoDatabase, Properties jndiProperties) throws DriverMsgDiagnosticiException {
        this.init(nomeDataSource, tipoDatabase, jndiProperties, null);
    }

    public void init(String nomeDataSource, String tipoDatabase, Properties jndiProperties, Logger log) throws DriverMsgDiagnosticiException {
        try {
            this.log = log == null ? LoggerWrapperFactory.getLogger("DRIVER_DB_LOGANALIZER") : log;
        }
        catch (Exception e) {
            throw new DriverMsgDiagnosticiException("Errore durante l'inizializzazione del logger...", e);
        }
        try {
            this.log.info("Inizializzo DriverLogAnalyzer...");
            GestoreJNDI gestoreJNDI = new GestoreJNDI(jndiProperties);
            this.datasource = (DataSource)gestoreJNDI.lookup(nomeDataSource);
            if (this.datasource == null) {
                throw new Exception("datasource is null");
            }
            this.log.info("Inizializzo DriverLogAnalyzer terminata.");
        }
        catch (Exception e) {
            this.log.error("Errore durante la ricerca del datasource...", (Throwable)e);
            throw new DriverMsgDiagnosticiException("Errore durante la ricerca del datasource...", e);
        }
        try {
            this.log.info("Inizializzo ISQLQueryObject...");
            if (!TipiDatabase.isAMember(tipoDatabase)) {
                throw new Exception("Tipo database non gestito");
            }
            this.tipoDatabase = tipoDatabase;
            this.log.info("Inizializzo ISQLQueryObject terminata.");
        }
        catch (Exception e) {
            this.log.error("Errore durante la ricerca del SQLQueryObject...", (Throwable)e);
            throw new DriverMsgDiagnosticiException("Errore durante la ricerca del SQLQueryObject...", e);
        }
    }

    public void init(DataSource dataSourceObject, String tipoDatabase) throws DriverMsgDiagnosticiException {
        this.init(dataSourceObject, tipoDatabase, null);
    }

    public void init(DataSource dataSourceObject, String tipoDatabase, Logger log) throws DriverMsgDiagnosticiException {
        try {
            this.log = log == null ? LoggerWrapperFactory.getLogger("DRIVER_DB_LOGANALIZER") : log;
        }
        catch (Exception e) {
            throw new DriverMsgDiagnosticiException("Errore durante l'inizializzazione del logger...", e);
        }
        try {
            this.datasource = dataSourceObject;
            if (this.datasource == null) {
                throw new Exception("datasource is null");
            }
        }
        catch (Exception e) {
            this.log.error("Errore durante l'assegnamento del datasource...", (Throwable)e);
            throw new DriverMsgDiagnosticiException("Errore durante l'assegnamento del datasource...", e);
        }
        try {
            this.log.info("Inizializzo ISQLQueryObject...");
            if (!TipiDatabase.isAMember(tipoDatabase)) {
                throw new Exception("Tipo database non gestito");
            }
            this.tipoDatabase = tipoDatabase;
            this.log.info("Inizializzo ISQLQueryObject terminata.");
        }
        catch (Exception e) {
            this.log.error("Errore durante la ricerca del SQLQueryObject...", (Throwable)e);
            throw new DriverMsgDiagnosticiException("Errore durante la ricerca del SQLQueryObject...", e);
        }
    }

    public void init(Connection connection, String tipoDatabase, Logger log) throws DriverMsgDiagnosticiException {
        try {
            this.log = log;
        }
        catch (Exception e) {
            throw new DriverMsgDiagnosticiException("Errore durante l'inizializzazione del logger...", e);
        }
        this.con = connection;
        try {
            this.log.info("Inizializzo ISQLQueryObject...");
            if (!TipiDatabase.isAMember(tipoDatabase)) {
                throw new Exception("Tipo database non gestito");
            }
            this.tipoDatabase = tipoDatabase;
            this.log.info("Inizializzo ISQLQueryObject terminata.");
        }
        catch (Exception e) {
            this.log.error("Errore durante la ricerca del SQLQueryObject...", (Throwable)e);
            throw new DriverMsgDiagnosticiException("Errore durante la ricerca del SQLQueryObject...", e);
        }
    }

    public void init(String urlJDBC, String driverJDBC, String username, String password, String tipoDatabase, Logger log) throws DriverMsgDiagnosticiException {
        try {
            this.log = log;
        }
        catch (Exception e) {
            throw new DriverMsgDiagnosticiException("Errore durante l'inizializzazione del logger...", e);
        }
        try {
            Class.forName(driverJDBC);
            this.con = username != null ? DriverManager.getConnection(urlJDBC, username, password) : DriverManager.getConnection(urlJDBC);
            this.connectionOpenViaJDBCInCostructor = true;
        }
        catch (Exception e) {
            this.log.error("Errore durante l'inizializzazione della connessione...", (Throwable)e);
            throw new DriverMsgDiagnosticiException("Errore durante l'inizializzazione della connessione...", e);
        }
        try {
            this.log.info("Inizializzo ISQLQueryObject...");
            if (!TipiDatabase.isAMember(tipoDatabase)) {
                throw new Exception("Tipo database non gestito");
            }
            this.tipoDatabase = tipoDatabase;
            this.log.info("Inizializzo ISQLQueryObject terminata.");
        }
        catch (Exception e) {
            this.log.error("Errore durante la ricerca del SQLQueryObject...", (Throwable)e);
            throw new DriverMsgDiagnosticiException("Errore durante la ricerca del SQLQueryObject...", e);
        }
    }

    @Override
    public int countMessaggiDiagnostici(FiltroRicercaDiagnostici filtro) throws DriverMsgDiagnosticiException {
        Statement stmt = null;
        ResultSet rs = null;
        Connection con = null;
        boolean closeConnection = true;
        ISQLQueryObject sqlObj = null;
        int countDiagnostici = 0;
        try {
            if (this.con != null) {
                con = this.con;
                closeConnection = false;
            } else {
                con = this.datasource.getConnection();
                if (con == null) {
                    throw new Exception("Connection non ottenuta dal datasource[" + this.datasource + "]");
                }
            }
            sqlObj = DriverMsgDiagnosticiUtilities.createSQLQueryObj_countMessaggiDiagnostici(filtro, this.tipoDatabase);
            StringWrapper sqlDebug = new StringWrapper(sqlObj.createSQLQuery());
            DriverMsgDiagnosticiUtilities.setValues_countMessaggiDiagnostici(filtro, sqlDebug, 1);
            this.log.debug("Query : " + sqlDebug);
            String sql = sqlObj.createSQLQuery();
            stmt = con.prepareStatement(sql);
            DriverMsgDiagnosticiUtilities.setValues_countMessaggiDiagnostici(filtro, stmt, 1);
            rs = stmt.executeQuery();
            if (rs.next()) {
                countDiagnostici = rs.getInt("countMsgDiagnostici");
            }
            rs.close();
            stmt.close();
            this.log.debug("Query found " + countDiagnostici + " rows");
            int n = countDiagnostici;
            return n;
        }
        catch (DriverMsgDiagnosticiException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DriverMsgDiagnosticiException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            if (closeConnection) {
                try {
                    con.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public List<MsgDiagnostico> getMessaggiDiagnostici(FiltroRicercaDiagnosticiConPaginazione filtro) throws DriverMsgDiagnosticiException, DriverMsgDiagnosticiNotFoundException {
        Statement stmt = null;
        ResultSet rs = null;
        Connection con = null;
        boolean closeConnection = true;
        ISQLQueryObject sqlObj = null;
        try {
            ArrayList<MsgDiagnostico> listaMSGDiagnostici = new ArrayList<MsgDiagnostico>();
            if (this.con != null) {
                con = this.con;
                closeConnection = false;
            } else {
                con = this.datasource.getConnection();
                if (con == null) {
                    throw new Exception("Connection non ottenuta dal datasource[" + this.datasource + "]");
                }
            }
            sqlObj = DriverMsgDiagnosticiUtilities.createSQLQueryObj_searchMessaggiDiagnostici(filtro, this.tipoDatabase);
            StringWrapper sqlDebug = new StringWrapper(sqlObj.createSQLQuery());
            DriverMsgDiagnosticiUtilities.setValues_searchMessaggiDiagnostici(filtro, sqlDebug, 1);
            this.log.debug("Query : " + sqlDebug);
            String sql = sqlObj.createSQLQuery();
            stmt = con.prepareStatement(sql);
            DriverMsgDiagnosticiUtilities.setValues_searchMessaggiDiagnostici(filtro, stmt, 1);
            rs = stmt.executeQuery();
            while (rs.next()) {
                long idMsgDiagnostico = rs.getLong("idMsgDiagnostico");
                MsgDiagnostico msgDiag = DriverMsgDiagnosticiUtilities.getMsgDiagnostico(con, this.tipoDatabase, this.log, idMsgDiagnostico, this.propertiesMsgDiagnostici);
                listaMSGDiagnostici.add(msgDiag);
            }
            rs.close();
            stmt.close();
            this.log.debug("Query found " + listaMSGDiagnostici.size() + " rows");
            if (listaMSGDiagnostici.size() > 0) {
                ArrayList<MsgDiagnostico> arrayList = listaMSGDiagnostici;
                return arrayList;
            }
            try {
                throw new DriverMsgDiagnosticiNotFoundException("Non sono stati trovati diagnostici che rispettano il filtro impostato");
            }
            catch (DriverMsgDiagnosticiNotFoundException e) {
                throw e;
            }
            catch (DriverMsgDiagnosticiException e) {
                throw e;
            }
            catch (Exception e) {
                throw new DriverMsgDiagnosticiException(e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            if (closeConnection) {
                try {
                    con.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public int deleteMessaggiDiagnostici(FiltroRicercaDiagnostici filter) throws DriverMsgDiagnosticiException {
        Statement stmt = null;
        int deleted = 0;
        Connection con = null;
        boolean closeConnection = true;
        ISQLQueryObject sqlObj = null;
        try {
            if (this.con != null) {
                con = this.con;
                closeConnection = false;
            } else {
                con = this.datasource.getConnection();
                if (con == null) {
                    throw new Exception("Connection non ottenuta dal datasource[" + this.datasource + "]");
                }
            }
            sqlObj = DriverMsgDiagnosticiUtilities.createSQLQueryObj_deleteMessaggiDiagnostici(filter, this.tipoDatabase);
            StringWrapper sqlDebug = new StringWrapper(sqlObj.createSQLDelete());
            DriverMsgDiagnosticiUtilities.setValues_deleteMessaggiDiagnostici(filter, sqlDebug, 1);
            this.log.debug("Query : " + sqlDebug);
            String sql = sqlObj.createSQLDelete();
            stmt = con.prepareStatement(sql);
            DriverMsgDiagnosticiUtilities.setValues_deleteMessaggiDiagnostici(filter, stmt, 1);
            deleted = stmt.executeUpdate();
            stmt.close();
            this.log.debug("Deleted " + deleted + " rows");
            int n = deleted;
            return n;
        }
        catch (DriverMsgDiagnosticiException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DriverMsgDiagnosticiException(e);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            if (closeConnection) {
                try {
                    con.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public int countInfoCorrelazioniMessaggiDiagnostici(FiltroRicercaDiagnostici filtro) throws DriverMsgDiagnosticiException {
        Statement stmt = null;
        ResultSet rs = null;
        Connection con = null;
        boolean closeConnection = true;
        ISQLQueryObject sqlObj = null;
        int countCorrelazioni = 0;
        try {
            if (this.con != null) {
                con = this.con;
                closeConnection = false;
            } else {
                con = this.datasource.getConnection();
                if (con == null) {
                    throw new Exception("Connection non ottenuta dal datasource[" + this.datasource + "]");
                }
            }
            sqlObj = DriverMsgDiagnosticiUtilities.createSQLQueryObj_countMsgDiagCorrelazione(filtro, this.tipoDatabase);
            StringWrapper sqlDebug = new StringWrapper(sqlObj.createSQLQuery());
            DriverMsgDiagnosticiUtilities.setValues_countMsgDiagCorrelazione(filtro, sqlDebug, 1);
            this.log.debug("Query : " + sqlDebug);
            String sql = sqlObj.createSQLQuery();
            stmt = con.prepareStatement(sql);
            DriverMsgDiagnosticiUtilities.setValues_countMsgDiagCorrelazione(filtro, stmt, 1);
            rs = stmt.executeQuery();
            if (rs.next()) {
                countCorrelazioni = rs.getInt("countCorrelazioniMsgDiagnostici");
            }
            rs.close();
            stmt.close();
            this.log.debug("Query found " + countCorrelazioni + " rows");
            int n = countCorrelazioni;
            return n;
        }
        catch (DriverMsgDiagnosticiException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DriverMsgDiagnosticiException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            if (closeConnection) {
                try {
                    con.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public List<MsgDiagnosticoCorrelazione> getInfoCorrelazioniMessaggiDiagnostici(FiltroRicercaDiagnosticiConPaginazione filtro) throws DriverMsgDiagnosticiException, DriverMsgDiagnosticiNotFoundException {
        Statement stmt = null;
        ResultSet rs = null;
        Connection con = null;
        boolean closeConnection = true;
        ISQLQueryObject sqlObj = null;
        try {
            ArrayList<MsgDiagnosticoCorrelazione> listaCorrelazioni = new ArrayList<MsgDiagnosticoCorrelazione>();
            if (this.con != null) {
                con = this.con;
                closeConnection = false;
            } else {
                con = this.datasource.getConnection();
                if (con == null) {
                    throw new Exception("Connection non ottenuta dal datasource[" + this.datasource + "]");
                }
            }
            sqlObj = DriverMsgDiagnosticiUtilities.createSQLQueryObj_searchMsgDiagCorrelazione(filtro, this.tipoDatabase);
            StringWrapper sqlDebug = new StringWrapper(sqlObj.createSQLQuery());
            DriverMsgDiagnosticiUtilities.setValues_searchMsgDiagCorrelazione(filtro, sqlDebug, 1);
            this.log.debug("Query : " + sqlDebug);
            String sql = sqlObj.createSQLQuery();
            stmt = con.prepareStatement(sql);
            DriverMsgDiagnosticiUtilities.setValues_searchMsgDiagCorrelazione(filtro, stmt, 1);
            rs = stmt.executeQuery();
            while (rs.next()) {
                long idMsgDiagnosticoCorrelazione = rs.getLong("idMsgDiagCorrelazione");
                MsgDiagnosticoCorrelazione msgDiagCorrelazione = DriverMsgDiagnosticiUtilities.getMsgDiagnosticoCorrelazione(con, this.tipoDatabase, this.log, idMsgDiagnosticoCorrelazione, this.propertiesMsgDiagCorrelazione);
                listaCorrelazioni.add(msgDiagCorrelazione);
            }
            rs.close();
            stmt.close();
            this.log.debug("Query found " + listaCorrelazioni.size() + " rows");
            if (listaCorrelazioni.size() > 0) {
                ArrayList<MsgDiagnosticoCorrelazione> arrayList = listaCorrelazioni;
                return arrayList;
            }
            try {
                throw new DriverMsgDiagnosticiNotFoundException("Non sono stati trovate correlazioni ai diagnostici che rispettano il filtro impostato");
            }
            catch (DriverMsgDiagnosticiNotFoundException e) {
                throw e;
            }
            catch (DriverMsgDiagnosticiException e) {
                throw e;
            }
            catch (Exception e) {
                throw new DriverMsgDiagnosticiException(e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            if (closeConnection) {
                try {
                    con.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public int deleteInfoCorrelazioniMessaggiDiagnostici(FiltroRicercaDiagnostici filter) throws DriverMsgDiagnosticiException {
        Statement stmt = null;
        int deleted = 0;
        Connection con = null;
        boolean closeConnection = true;
        ISQLQueryObject sqlObj = null;
        try {
            if (this.con != null) {
                con = this.con;
                closeConnection = false;
            } else {
                con = this.datasource.getConnection();
                if (con == null) {
                    throw new Exception("Connection non ottenuta dal datasource[" + this.datasource + "]");
                }
            }
            sqlObj = DriverMsgDiagnosticiUtilities.createSQLQueryObj_deleteMsgDiagCorrelazione(filter, this.tipoDatabase);
            StringWrapper sqlDebug = new StringWrapper(sqlObj.createSQLDelete());
            DriverMsgDiagnosticiUtilities.setValues_deleteMsgDiagCorrelazione(filter, sqlDebug, 1);
            this.log.debug("Query : " + sqlDebug);
            String sql = sqlObj.createSQLDelete();
            stmt = con.prepareStatement(sql);
            DriverMsgDiagnosticiUtilities.setValues_deleteMsgDiagCorrelazione(filter, stmt, 1);
            deleted = stmt.executeUpdate();
            stmt.close();
            this.log.debug("Deleted " + deleted + " rows");
            int n = deleted;
            return n;
        }
        catch (DriverMsgDiagnosticiException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DriverMsgDiagnosticiException(e);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            if (closeConnection) {
                try {
                    con.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public List<MsgDiagnosticoCorrelazione> getInfoEntryCorrelazione(FiltroRicercaDiagnosticiConPaginazione filter, boolean all) throws DriverMsgDiagnosticiException, SQLQueryObjectException {
        Statement stmt = null;
        ResultSet rs = null;
        Connection con = null;
        boolean closeConnection = true;
        try {
            if (this.con != null) {
                con = this.con;
                closeConnection = false;
            } else {
                con = this.datasource.getConnection();
                if (con == null) {
                    throw new Exception("Connection non ottenuta dal datasource[" + this.datasource + "]");
                }
            }
            String sqlQuery = "";
            if (all) {
                sqlQuery = DriverMsgDiagnosticiUnionUtilities.createUnionObj(filter, this.log, sqlQuery, this.propertiesMsgDiagCorrelazione);
            } else {
                ISQLQueryObject sqlQueryObject = DriverMsgDiagnosticiUnionUtilities.createSQLQueryObjCorrelazione(filter, false, this.log, sqlQuery, this.propertiesMsgDiagCorrelazione);
                sqlQueryObject.setLimit(filter.getLimit());
                sqlQueryObject.setOffset(filter.getOffset());
                sqlQuery = sqlQueryObject.createSQLQuery();
            }
            this.log.debug("eseguo query  :" + sqlQuery);
            stmt = con.prepareStatement(sqlQuery);
            int numRipetizioni = 1;
            if (all) {
                numRipetizioni = filter.isPartial() ? 2 : 3;
            }
            int count = 1;
            for (int j = 1; j <= numRipetizioni; ++j) {
                if (filter.getDataInizio() != null) {
                    stmt.setTimestamp(count, new Timestamp(filter.getDataInizio().getTime()));
                    ++count;
                }
                if (filter.getDataFine() != null) {
                    stmt.setTimestamp(count, new Timestamp(filter.getDataFine().getTime()));
                    ++count;
                }
                if (j == 2 || filter.getIdBustaRichiesta() == null || "".equals(filter.getIdBustaRichiesta())) continue;
                stmt.setString(count, filter.getIdBustaRichiesta());
                ++count;
            }
            ArrayList<MsgDiagnosticoCorrelazione> listaMSGCorrelazione = new ArrayList<MsgDiagnosticoCorrelazione>();
            long[] offsetMap = new long[]{0L, 0L, 0L};
            if (filter.getOffsetMap() != null) {
                offsetMap = filter.getOffsetMap();
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                String tipo_servizio;
                MsgDiagnosticoCorrelazione entry = new MsgDiagnosticoCorrelazione();
                entry.setId(rs.getLong("id"));
                entry.setIdBusta(rs.getString("idmessaggio"));
                entry.setProtocollo(rs.getString("protocollo"));
                Timestamp gdo = rs.getTimestamp("gdo");
                entry.setGdo(gdo);
                entry.setCorrelazioneApplicativa(rs.getString("id_correlazione_applicativa"));
                if (this.propertiesMsgDiagCorrelazione != null) {
                    for (int i = 0; i < this.propertiesMsgDiagCorrelazione.size(); ++i) {
                        String key = this.propertiesMsgDiagCorrelazione.get(i);
                        entry.addProperty(key, rs.getString(key));
                    }
                }
                if ((tipo_servizio = rs.getString("tipo_servizio")) != null) {
                    offsetMap[0] = offsetMap[0] + 1L;
                    entry.setNomePorta(rs.getString("porta"));
                    IDSoggetto fruitore = new IDSoggetto(rs.getString("tipo_fruitore"), rs.getString("fruitore"));
                    IDSoggetto erogatore = new IDSoggetto(rs.getString("tipo_erogatore"), rs.getString("erogatore"));
                    IDServizio servizio = new IDServizio(erogatore);
                    servizio.setServizio(rs.getString("servizio"));
                    servizio.setTipoServizio(rs.getString("tipo_servizio"));
                    InformazioniProtocollo infoBusta = new InformazioniProtocollo();
                    infoBusta.setAzione(rs.getString("azione"));
                    infoBusta.setErogatore(erogatore);
                    infoBusta.setFruitore(fruitore);
                    infoBusta.setServizio(servizio.getServizio());
                    infoBusta.setTipoServizio(servizio.getTipoServizio());
                    entry.setInformazioniProtocollo(infoBusta);
                    entry.setDelegata(rs.getInt("delegata") == 1);
                    entry.setServiziApplicativiList(this.getMSGDiagnosticoCorrelazioneSA(rs.getLong("id")));
                } else if (entry.getIdBusta() == null || "".equals(entry)) {
                    offsetMap[1] = offsetMap[1] + 1L;
                } else {
                    offsetMap[2] = offsetMap[2] + 1L;
                }
                listaMSGCorrelazione.add(entry);
            }
            rs.close();
            stmt.close();
            this.log.debug("offsetmap[correlati]: " + offsetMap[0]);
            this.log.debug("offsetmap[diagnostici]: " + offsetMap[1]);
            this.log.debug("offsetmap[notexist]: " + offsetMap[2]);
            filter.setOffsetMap(offsetMap);
            ArrayList<MsgDiagnosticoCorrelazione> arrayList = listaMSGCorrelazione;
            return arrayList;
        }
        catch (Exception e) {
            throw new DriverMsgDiagnosticiException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            if (closeConnection) {
                try {
                    con.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private List<String> getMSGDiagnosticoCorrelazioneSA(long idCorrelazione) throws DriverMsgDiagnosticiException, SQLQueryObjectException {
        Statement stmt = null;
        ResultSet rs = null;
        Connection con = null;
        boolean closeConnection = true;
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDatabase);
        sqlQueryObject.addFromTable("msgdiag_correlazione_sa");
        sqlQueryObject.addWhereCondition("id_correlazione='" + idCorrelazione + "'");
        try {
            ArrayList<String> listaNomeSA = new ArrayList<String>();
            if (this.con != null) {
                con = this.con;
                closeConnection = false;
            } else {
                con = this.datasource.getConnection();
                if (con == null) {
                    throw new Exception("Connection non ottenuta dal datasource[" + this.datasource + "]");
                }
            }
            stmt = con.prepareStatement(sqlQueryObject.createSQLQuery());
            rs = stmt.executeQuery();
            while (rs.next()) {
                listaNomeSA.add(rs.getString("servizio_applicativo"));
            }
            rs.close();
            stmt.close();
            ArrayList<String> arrayList = listaNomeSA;
            return arrayList;
        }
        catch (Exception e) {
            throw new DriverMsgDiagnosticiException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            if (closeConnection) {
                try {
                    con.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public long getTotUnionEntry(FiltroRicercaDiagnosticiConPaginazione filter) throws DriverMsgDiagnosticiException, SQLQueryObjectException {
        Statement stmt = null;
        ResultSet rs = null;
        Connection con = null;
        boolean closeConnection = true;
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDatabase);
        ISQLQueryObject sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject(this.tipoDatabase);
        ISQLQueryObject sqlQueryObject3 = SQLObjectFactory.createSQLQueryObject(this.tipoDatabase);
        ISQLQueryObject subquery = SQLObjectFactory.createSQLQueryObject(this.tipoDatabase);
        try {
            int j;
            InformazioniProtocollo infoBusta;
            if (this.con != null) {
                con = this.con;
                closeConnection = false;
            } else {
                con = this.datasource.getConnection();
                if (con == null) {
                    throw new Exception("Connection non ottenuta dal datasource[" + this.datasource + "]");
                }
            }
            long totale = 0L;
            int totMSG = 0;
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addFromTable("msgdiag_correlazione");
            sqlQueryObject.addSelectCountField("idmessaggio", "totale");
            if (filter.getDataInizio() != null) {
                sqlQueryObject.addWhereCondition("msgdiag_correlazione.gdo>=?");
            }
            if (filter.getDataFine() != null) {
                sqlQueryObject.addWhereCondition("msgdiag_correlazione.gdo<=?");
            }
            if (filter.getIdBustaRichiesta() != null && !"".equals(filter.getIdBustaRichiesta())) {
                sqlQueryObject.addWhereCondition("msgdiag_correlazione.idmessaggio=?");
            }
            if (filter.getNomePorta() != null && !"".equals(filter.getNomePorta())) {
                sqlQueryObject.addWhereCondition("msgdiag_correlazione.porta='" + filter.getNomePorta() + "'");
            }
            if (filter.isDelegata() != null) {
                sqlQueryObject.addWhereCondition("msgdiag_correlazione.delegata=" + (filter.isDelegata() != false ? 1 : 0));
            }
            if ((infoBusta = filter.getInformazioniProtocollo()) != null) {
                if (infoBusta.getFruitore() != null) {
                    if (infoBusta.getFruitore().getTipo() != null && !"".equals(infoBusta.getFruitore().getTipo())) {
                        sqlQueryObject.addWhereCondition("msgdiag_correlazione.tipo_fruitore='" + infoBusta.getFruitore().getTipo() + "'");
                    }
                    if (infoBusta.getFruitore().getNome() != null && !"".equals(infoBusta.getFruitore().getNome())) {
                        sqlQueryObject.addWhereCondition("msgdiag_correlazione.fruitore='" + infoBusta.getFruitore().getNome() + "'");
                    }
                }
                if (infoBusta.getErogatore() != null) {
                    if (infoBusta.getErogatore().getTipo() != null && !"".equals(infoBusta.getErogatore().getTipo())) {
                        sqlQueryObject.addWhereCondition("msgdiag_correlazione.tipo_erogatore='" + infoBusta.getErogatore().getTipo() + "'");
                    }
                    if (infoBusta.getErogatore().getNome() != null && !"".equals(infoBusta.getErogatore().getNome())) {
                        sqlQueryObject.addWhereCondition("msgdiag_correlazione.erogatore='" + infoBusta.getErogatore().getNome() + "'");
                    }
                }
                if (infoBusta.getServizio() != null) {
                    if (infoBusta.getTipoServizio() != null && !"".equals(infoBusta.getTipoServizio())) {
                        sqlQueryObject.addWhereCondition("msgdiag_correlazione.tipo_servizio='" + infoBusta.getTipoServizio() + "'");
                    }
                    if (infoBusta.getServizio() != null && !"".equals(infoBusta.getServizio())) {
                        sqlQueryObject.addWhereCondition("msgdiag_correlazione.servizio='" + infoBusta.getServizio() + "'");
                    }
                }
                if (infoBusta.getAzione() != null && !"".equals(infoBusta.getAzione())) {
                    sqlQueryObject.addWhereCondition("msgdiag_correlazione.azione='" + infoBusta.getAzione() + "'");
                }
            }
            this.log.debug("eseguo query:" + sqlQueryObject.createSQLQuery());
            stmt = con.prepareStatement(sqlQueryObject.createSQLQuery());
            int count = 1;
            for (j = 1; j < 2; ++j) {
                if (filter.getDataInizio() != null) {
                    stmt.setTimestamp(count, new Timestamp(filter.getDataInizio().getTime()));
                    ++count;
                }
                if (filter.getDataFine() != null) {
                    stmt.setTimestamp(count, new Timestamp(filter.getDataFine().getTime()));
                    ++count;
                }
                if (filter.getIdBustaRichiesta() == null || "".equals(filter.getIdBustaRichiesta())) continue;
                stmt.setString(count, filter.getIdBustaRichiesta());
                ++count;
            }
            totMSG = 0;
            rs = stmt.executeQuery();
            if (rs.next()) {
                totMSG = rs.getInt("totale");
            }
            rs.close();
            stmt.close();
            totale += (long)totMSG;
            this.log.debug("getTotUnionEntry (Count 1): [" + totMSG + "] entry matchano il filtro :" + filter.toString());
            sqlQueryObject2.setANDLogicOperator(true);
            sqlQueryObject2.addFromTable("msgdiagnostici");
            sqlQueryObject2.addSelectCountField("*", "totale");
            sqlQueryObject2.addWhereCondition("msgdiagnostici.idmessaggio is NULL");
            if (filter.getDataInizio() != null) {
                sqlQueryObject2.addWhereCondition("msgdiagnostici.gdo>=?");
            }
            if (filter.getDataFine() != null) {
                sqlQueryObject2.addWhereCondition("msgdiagnostici.gdo<=?");
            }
            if (filter.getIdBustaRichiesta() != null && !"".equals(filter.getIdBustaRichiesta())) {
                sqlQueryObject2.addWhereCondition("msgdiagnostici.idmessaggio=?");
            }
            if ((infoBusta = filter.getInformazioniProtocollo()) != null) {
                if (infoBusta.getFruitore() != null) {
                    if (infoBusta.getFruitore().getTipo() != null && !"".equals(infoBusta.getFruitore().getTipo())) {
                        sqlQueryObject2.addWhereCondition("msgdiag_correlazione.tipo_fruitore='" + infoBusta.getFruitore().getTipo() + "'");
                    }
                    if (infoBusta.getFruitore().getNome() != null && !"".equals(infoBusta.getFruitore().getNome())) {
                        sqlQueryObject2.addWhereCondition("msgdiag_correlazione.fruitore='" + infoBusta.getFruitore().getNome() + "'");
                    }
                }
                if (infoBusta.getErogatore() != null) {
                    if (infoBusta.getErogatore().getTipo() != null && !"".equals(infoBusta.getErogatore().getTipo())) {
                        sqlQueryObject2.addWhereCondition("msgdiag_correlazione.tipo_erogatore='" + infoBusta.getErogatore().getTipo() + "'");
                    }
                    if (infoBusta.getErogatore().getNome() != null && !"".equals(infoBusta.getErogatore().getNome())) {
                        sqlQueryObject2.addWhereCondition("msgdiag_correlazione.erogatore='" + infoBusta.getErogatore().getNome() + "'");
                    }
                }
                if (infoBusta.getServizio() != null) {
                    if (infoBusta.getTipoServizio() != null && !"".equals(infoBusta.getTipoServizio())) {
                        sqlQueryObject2.addWhereCondition("msgdiag_correlazione.tipo_servizio='" + infoBusta.getTipoServizio() + "'");
                    }
                    if (infoBusta.getServizio() != null && !"".equals(infoBusta.getServizio())) {
                        sqlQueryObject2.addWhereCondition("msgdiag_correlazione.servizio='" + infoBusta.getServizio() + "'");
                    }
                }
                if (infoBusta.getAzione() != null && !"".equals(infoBusta.getAzione())) {
                    sqlQueryObject2.addWhereCondition("msgdiagnostici.azione='" + infoBusta.getAzione() + "'");
                }
            }
            this.log.debug("eseguo query:" + sqlQueryObject2.createSQLQuery());
            stmt = con.prepareStatement(sqlQueryObject2.createSQLQuery());
            count = 1;
            for (j = 1; j < 2; ++j) {
                if (filter.getDataInizio() != null) {
                    stmt.setTimestamp(count, new Timestamp(filter.getDataInizio().getTime()));
                    ++count;
                }
                if (filter.getDataFine() != null) {
                    stmt.setTimestamp(count, new Timestamp(filter.getDataFine().getTime()));
                    ++count;
                }
                if (filter.getIdBustaRichiesta() == null || "".equals(filter.getIdBustaRichiesta())) continue;
                stmt.setString(count, filter.getIdBustaRichiesta());
                ++count;
            }
            totMSG = 0;
            rs = stmt.executeQuery();
            if (rs.next()) {
                totMSG = rs.getInt("totale");
            }
            rs.close();
            stmt.close();
            totale += (long)totMSG;
            this.log.debug("getTotUnionEntry (Count 2): [" + totMSG + "] entry matchano il filtro :" + filter.toString());
            if (!filter.isPartial()) {
                sqlQueryObject3.setANDLogicOperator(true);
                sqlQueryObject3.addFromTable("msgdiagnostici");
                sqlQueryObject3.addSelectCountField("idmessaggio", "totale");
                subquery.addFromTable("msgdiag_correlazione");
                subquery.addWhereCondition("msgdiag_correlazione.idmessaggio=msgdiagnostici.idmessaggio");
                if (filter.getNomePorta() != null && !"".equals(filter.getNomePorta())) {
                    subquery.addWhereCondition("msgdiag_correlazione.porta='" + filter.getNomePorta() + "'");
                }
                if (filter.isDelegata() != null) {
                    subquery.addWhereCondition("msgdiag_correlazione.delegata=" + (filter.isDelegata() != false ? 1 : 0));
                }
                sqlQueryObject3.addWhereExistsCondition(true, subquery);
                if (filter.getDataInizio() != null) {
                    sqlQueryObject3.addWhereCondition("msgdiagnostici.gdo>=?");
                }
                if (filter.getDataFine() != null) {
                    sqlQueryObject3.addWhereCondition("msgdiagnostici.gdo<=?");
                }
                if (filter.getIdBustaRichiesta() != null && !"".equals(filter.getIdBustaRichiesta())) {
                    sqlQueryObject3.addWhereCondition("msgdiagnostici.idmessaggio=?");
                }
                if ((infoBusta = filter.getInformazioniProtocollo()) != null) {
                    if (infoBusta.getFruitore() != null) {
                        if (infoBusta.getFruitore().getTipo() != null && !"".equals(infoBusta.getFruitore().getTipo())) {
                            sqlQueryObject3.addWhereCondition("msgdiag_correlazione.tipo_fruitore='" + infoBusta.getFruitore().getTipo() + "'");
                        }
                        if (infoBusta.getFruitore().getNome() != null && !"".equals(infoBusta.getFruitore().getNome())) {
                            sqlQueryObject3.addWhereCondition("msgdiag_correlazione.fruitore='" + infoBusta.getFruitore().getNome() + "'");
                        }
                    }
                    if (infoBusta.getErogatore() != null) {
                        if (infoBusta.getErogatore().getTipo() != null && !"".equals(infoBusta.getErogatore().getTipo())) {
                            sqlQueryObject3.addWhereCondition("msgdiag_correlazione.tipo_erogatore='" + infoBusta.getErogatore().getTipo() + "'");
                        }
                        if (infoBusta.getErogatore().getNome() != null && !"".equals(infoBusta.getErogatore().getNome())) {
                            sqlQueryObject3.addWhereCondition("msgdiag_correlazione.erogatore='" + infoBusta.getErogatore().getNome() + "'");
                        }
                    }
                    if (infoBusta.getServizio() != null) {
                        if (infoBusta.getTipoServizio() != null && !"".equals(infoBusta.getTipoServizio())) {
                            sqlQueryObject3.addWhereCondition("msgdiag_correlazione.tipo_servizio='" + infoBusta.getTipoServizio() + "'");
                        }
                        if (infoBusta.getServizio() != null && !"".equals(infoBusta.getServizio())) {
                            sqlQueryObject3.addWhereCondition("msgdiag_correlazione.servizio='" + infoBusta.getServizio() + "'");
                        }
                    }
                    if (infoBusta.getAzione() != null && !"".equals(infoBusta.getAzione())) {
                        sqlQueryObject3.addWhereCondition("msgdiagnostici.azione='" + infoBusta.getAzione() + "'");
                    }
                }
                this.log.debug("eseguo query:" + sqlQueryObject3.createSQLQuery());
                stmt = con.prepareStatement(sqlQueryObject3.createSQLQuery());
                count = 1;
                for (j = 1; j < 2; ++j) {
                    if (filter.getDataInizio() != null) {
                        stmt.setTimestamp(count, new Timestamp(filter.getDataInizio().getTime()));
                        ++count;
                    }
                    if (filter.getDataFine() != null) {
                        stmt.setTimestamp(count, new Timestamp(filter.getDataFine().getTime()));
                        ++count;
                    }
                    if (filter.getIdBustaRichiesta() == null || "".equals(filter.getIdBustaRichiesta())) continue;
                    stmt.setString(count, filter.getIdBustaRichiesta());
                    ++count;
                }
                totMSG = 0;
                rs = stmt.executeQuery();
                if (rs.next()) {
                    totMSG = rs.getInt("totale");
                }
                rs.close();
                stmt.close();
                totale += (long)totMSG;
                this.log.debug("getTotUnionEntry (Count 3): [" + totMSG + "] entry matchano il filtro :" + filter.toString());
            }
            this.log.debug("Totale Union Count : " + totale);
            long l = totale;
            return l;
        }
        catch (Exception e) {
            throw new DriverMsgDiagnosticiException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            if (closeConnection) {
                try {
                    con.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public void close() throws DriverMsgDiagnosticiException {
        try {
            if (this.connectionOpenViaJDBCInCostructor && this.con != null && !this.con.isClosed()) {
                this.con.close();
            }
        }
        catch (Exception e) {
            throw new DriverMsgDiagnosticiException(e.getMessage(), e);
        }
    }

    public Connection getConnection() {
        if (this.datasource == null) {
            return null;
        }
        Connection connectionDB = null;
        try {
            connectionDB = this.datasource.getConnection();
        }
        catch (Exception e) {
            return null;
        }
        return connectionDB;
    }

    public void releaseConnection(Connection connectionDB) {
        try {
            if (connectionDB != null) {
                connectionDB.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public String getTipoDatabase() {
        return this.tipoDatabase;
    }
}

