/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.basic.config;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.IProtocolFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.ProtocolException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.config.ITraduttore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.CodiceErroreCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.CodiceErroreIntegrazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.ContestoCodificaEccezione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.ErroreCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.ErroreIntegrazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.Inoltro;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.LivelloRilevanza;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.MessaggiFaultErroreCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.ProfiloDiCollaborazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.SubCodiceErrore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.TipoOraRegistrazione;
import it.link.pdd.tools.migrazione_govway.utils.date.DateManager;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;

public class BasicTraduttore
implements ITraduttore {
    protected Logger log = null;
    protected IProtocolFactory protocolFactory;

    public BasicTraduttore(IProtocolFactory factory) {
        this.log = factory.getLogger();
        this.protocolFactory = factory;
    }

    @Override
    public IProtocolFactory getProtocolFactory() {
        return this.protocolFactory;
    }

    public String getPrefissoEccezioni() {
        return "ECCEZIONE_PROTOCOLLO_";
    }

    @Override
    public String toString(CodiceErroreCooperazione cod) {
        return this.toString(cod, null);
    }

    @Override
    public String toString(CodiceErroreCooperazione cod, SubCodiceErrore subCode) {
        if (subCode == null || subCode.getSubCodice() == null) {
            return this.getPrefissoEccezioni() + cod.getCodice();
        }
        return this.getPrefissoEccezioni() + cod.getCodice() + "_" + subCode.getSubCodice();
    }

    @Override
    public CodiceErroreCooperazione toCodiceErroreCooperazione(String codiceCooperazione) {
        if (codiceCooperazione == null) {
            return CodiceErroreCooperazione.UNKNOWN;
        }
        String codiceNum = codiceCooperazione.replace(this.getPrefissoEccezioni(), "");
        try {
            if (codiceNum.contains("_")) {
                codiceNum = codiceNum.split("_")[0];
            }
            return CodiceErroreCooperazione.toCodiceErroreCooperazione(Integer.parseInt(codiceNum));
        }
        catch (Exception e) {
            return CodiceErroreCooperazione.UNKNOWN;
        }
    }

    @Override
    public String toString(MessaggiFaultErroreCooperazione msg) {
        return msg.toString();
    }

    @Override
    public String toString(ErroreCooperazione msg) {
        return msg.getDescrizioneRawValue();
    }

    @Override
    public String toString(CodiceErroreIntegrazione cod, String prefix, boolean isGenericCodeFor5XX) {
        Object codiceMappato = "" + cod.getCodice();
        if (!(!isGenericCodeFor5XX || cod.getCodice() < 500 || cod.equals(CodiceErroreIntegrazione.CODICE_516_CONNETTORE_UTILIZZO_CON_ERRORE) || cod.equals(CodiceErroreIntegrazione.CODICE_517_RISPOSTA_RICHIESTA_NON_RITORNATA) || cod.equals(CodiceErroreIntegrazione.CODICE_518_RISPOSTA_RICHIESTA_RITORNATA_COME_FAULT) || cod.equals(CodiceErroreIntegrazione.CODICE_559_RICEVUTA_RISPOSTA_CON_ERRORE_TRASPORTO) || cod.equals(CodiceErroreIntegrazione.CODICE_550_PD_SERVICE_NOT_ACTIVE) || cod.equals(CodiceErroreIntegrazione.CODICE_551_PA_SERVICE_NOT_ACTIVE) || cod.equals(CodiceErroreIntegrazione.CODICE_552_IM_SERVICE_NOT_ACTIVE))) {
            codiceMappato = "500";
        }
        return this._toStringCodiceErroreIntegrazione((String)codiceMappato, prefix, isGenericCodeFor5XX);
    }

    @Override
    public String toCodiceErroreIntegrazioneAsString(ErroreIntegrazione errore, String prefix, boolean isGenericCodeFor5XX) {
        if (errore.getCodiceCustom() != null) {
            return this._toStringCodiceErroreIntegrazione(errore.getCodiceCustom(), prefix, isGenericCodeFor5XX);
        }
        return this.toString(errore.getCodiceErrore(), prefix, isGenericCodeFor5XX);
    }

    private String _toStringCodiceErroreIntegrazione(String codiceMappato, String prefix, boolean isGenericCodeFor5XX) {
        codiceMappato = (prefix == null ? "OPENSPCOOP2_ORG_" : prefix) + (String)codiceMappato;
        return codiceMappato;
    }

    @Override
    public CodiceErroreIntegrazione toCodiceErroreIntegrazione(String codiceErroreIntegrazione, String prefix) {
        try {
            String intValue = codiceErroreIntegrazione.substring(prefix.length());
            return CodiceErroreIntegrazione.toCodiceErroreIntegrazione(Integer.parseInt(intValue));
        }
        catch (Exception e) {
            this.log.error("Conversione in CodiceErroreIntegrazione della stringa[" + codiceErroreIntegrazione + "] prefix[" + prefix + "] non riuscita: " + e.getMessage(), (Throwable)e);
            return CodiceErroreIntegrazione.UNKNOWN;
        }
    }

    @Override
    public String toString(ErroreIntegrazione msg) {
        return msg.getDescrizioneRawValue();
    }

    @Override
    public String getDate_protocolFormat() {
        return this.getDate_protocolFormat(null);
    }

    @Override
    public String getDate_protocolFormat(Date date) {
        if (date == null) {
            date = DateManager.getDate();
        }
        SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd_HH:mm:ss.SSS");
        return dateformat.format(date).replace('_', 'T');
    }

    @Override
    public String getIdentificativoPortaDefault(IDSoggetto soggetto) {
        return this.getIdentificativoPorta_Nome(soggetto) + "PdD";
    }

    protected String getIdentificativoPorta_Nome(IDSoggetto idSoggetto) {
        return idSoggetto.toString();
    }

    @Override
    public String getIdentificativoCodiceIPADefault(IDSoggetto soggetto, boolean createURI) throws ProtocolException {
        if (soggetto == null || "".equals(soggetto)) {
            throw new ProtocolException("Identificativo soggetto non fornito");
        }
        StringBuffer bf = new StringBuffer();
        if (createURI) {
            bf.append("uri:dn:");
        }
        bf.append("o=");
        bf.append(this.getIdentificativoCodiceIPA_Nome(soggetto));
        bf.append(",c=it");
        return bf.toString();
    }

    protected String getIdentificativoCodiceIPA_Nome(IDSoggetto idSoggetto) {
        return idSoggetto.toString();
    }

    @Override
    public String toString(Inoltro inoltro) {
        return inoltro.getEngineValue();
    }

    @Override
    public String toString(ProfiloDiCollaborazione profilo) {
        return profilo.getEngineValue();
    }

    @Override
    public String toString(TipoOraRegistrazione tipo) {
        return tipo.getEngineValue();
    }

    @Override
    public String toString(LivelloRilevanza rilevanza) {
        return rilevanza.getEngineValue();
    }

    @Override
    public LivelloRilevanza toLivelloRilevanza(String livelloRilevanza) {
        return LivelloRilevanza.toLivelloRilevanza(livelloRilevanza);
    }

    @Override
    public Inoltro toInoltro(String inoltro) {
        return Inoltro.toInoltro(inoltro);
    }

    @Override
    public TipoOraRegistrazione toTipoOraRegistrazione(String tipoOraRegistrazione) {
        return TipoOraRegistrazione.toTipoOraRegistrazione(tipoOraRegistrazione);
    }

    @Override
    public ProfiloDiCollaborazione toProfiloDiCollaborazione(String profiloDiCollaborazione) {
        return ProfiloDiCollaborazione.toProfiloDiCollaborazione(profiloDiCollaborazione);
    }

    @Override
    public String toString(ContestoCodificaEccezione contesto) {
        return contesto.getEngineValue();
    }

    @Override
    public ContestoCodificaEccezione toContestoCodificaEccezione(String contestoCodificaEccezione) {
        return ContestoCodificaEccezione.toContestoCodificaEccezione(contestoCodificaEccezione);
    }
}

