/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.basic.config;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.OpenSPCoop2Message;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.SOAPVersion;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.Busta;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.IProtocolFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.ProtocolException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.config.IProtocolManager;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.SOAPFaultIntegrationGenericInfoMode;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.TipoIntegrazione;
import it.link.pdd.tools.migrazione_govway.utils.io.notifier.NotifierInputStreamParams;
import it.link.pdd.tools.migrazione_govway.utils.resources.TransportRequestContext;
import it.link.pdd.tools.migrazione_govway.utils.resources.TransportResponseContext;
import java.util.Hashtable;
import java.util.Map;

public abstract class BasicManager
implements IProtocolManager {
    private IProtocolFactory protocolFactory = null;

    public BasicManager(IProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public IProtocolFactory getProtocolFactory() {
        return this.protocolFactory;
    }

    @Override
    public boolean isBustaServizio(Busta busta) {
        return false;
    }

    @Override
    public String getKeywordTipoMittenteSconosciuto() {
        return "Sconosciuto";
    }

    @Override
    public String getKeywordMittenteSconosciuto() {
        return "Sconosciuto";
    }

    @Override
    public long getIntervalloScadenzaBuste() {
        return 7200L;
    }

    @Override
    public boolean isGenerazioneElementiNonValidabiliRispettoXSD() {
        return false;
    }

    @Override
    public boolean isIgnoraEccezioniNonGravi() {
        return false;
    }

    @Override
    public boolean isGenerazioneListaEccezioniErroreProcessamento() {
        return false;
    }

    @Override
    public boolean isGenerazioneDetailsSOAPFaultProtocollo_EccezioneValidazione() {
        return false;
    }

    @Override
    public boolean isGenerazioneDetailsSOAPFaultProtocollo_EccezioneProcessamento() {
        return true;
    }

    @Override
    public boolean isGenerazioneDetailsSOAPFaultProtocolloConStackTrace() {
        return false;
    }

    @Override
    public boolean isGenerazioneDetailsSOAPFaultProtocolloConInformazioniGeneriche() {
        return true;
    }

    @Override
    public boolean isGenerazioneDetailsSOAPFaultIntegratione_erroreServer() {
        return true;
    }

    @Override
    public boolean isGenerazioneDetailsSOAPFaultIntegratione_erroreClient() {
        return false;
    }

    @Override
    public boolean isGenerazioneDetailsSOAPFaultIntegrationeConStackTrace() {
        return false;
    }

    @Override
    public SOAPFaultIntegrationGenericInfoMode getModalitaGenerazioneInformazioniGeneriche_DetailsSOAPFaultIntegrazione() {
        return SOAPFaultIntegrationGenericInfoMode.SERVIZIO_APPLICATIVO;
    }

    @Override
    public Boolean isAggiungiDetailErroreApplicativo_SoapFaultApplicativo() {
        return null;
    }

    @Override
    public Boolean isAggiungiDetailErroreApplicativo_SoapFaultPdD() {
        return null;
    }

    @Override
    public Map<String, String> buildIntegrationProperties(Busta busta, boolean isRichiesta, TipoIntegrazione tipoIntegrazione) throws ProtocolException {
        if (busta != null && busta.sizeProperties() > 0) {
            Hashtable<String, String> map = new Hashtable<String, String>();
            String[] names = busta.getPropertiesNames();
            for (int i = 0; i < names.length; ++i) {
                String nomeProprieta = names[i];
                String valoreProprieta = busta.getProperty(nomeProprieta);
                if (TipoIntegrazione.TRASPORTO.equals((Object)tipoIntegrazione)) {
                    map.put("X-" + busta.getProtocollo().toUpperCase() + "-" + nomeProprieta, valoreProprieta);
                    continue;
                }
                if (TipoIntegrazione.URL.equals((Object)tipoIntegrazione)) {
                    map.put(busta.getProtocollo().toUpperCase() + nomeProprieta, valoreProprieta);
                    continue;
                }
                map.put(nomeProprieta, valoreProprieta);
            }
            return map;
        }
        return null;
    }

    @Override
    public OpenSPCoop2Message updateOpenSPCoop2MessageRequest(SOAPVersion soapVersion, OpenSPCoop2Message msg, Busta busta) throws ProtocolException {
        return msg;
    }

    @Override
    public OpenSPCoop2Message updateOpenSPCoop2MessageResponse(SOAPVersion soapVersion, OpenSPCoop2Message msg, Busta busta, NotifierInputStreamParams notifierInputStreamParams, TransportRequestContext transportRequestContext, TransportResponseContext transportResponseContext) throws ProtocolException {
        return msg;
    }

    @Override
    public boolean isHttpEmptyResponseOneWay() {
        return true;
    }

    @Override
    public Integer getHttpReturnCodeEmptyResponseOneWay() {
        return 200;
    }

    @Override
    public boolean isHttpOneWay_PD_HTTPEmptyResponse() {
        return true;
    }

    @Override
    public boolean isBlockedTransaction_responseMessageWithTransportCodeError() {
        return false;
    }
}

