/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.basic.builder;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.eccezione.errore_applicativo.Eccezione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.eccezione.errore_applicativo.ErroreApplicativo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.OpenSPCoop2Message;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.XMLUtils;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.IProtocolFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.ProtocolException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.builder.EsitoTransazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.builder.IEsitoBuilder;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.builder.InformazioniErroriInfrastrutturali;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.builder.ProprietaErroreApplicativo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.config.ITraduttore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.EsitoTransazioneName;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.MessaggiFaultErroreCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.utils.EsitiProperties;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.utils.EsitoIdentificationModeContextProperty;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.utils.EsitoIdentificationModeSoapFault;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.utils.EsitoTransportContextIdentification;
import it.link.pdd.tools.migrazione_govway.utils.resources.TransportRequestContext;
import java.util.Hashtable;
import java.util.List;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPFault;
import org.slf4j.Logger;
import org.w3c.dom.Node;

public class EsitoBuilder
implements IEsitoBuilder {
    protected Logger log;
    protected IProtocolFactory factory;
    protected EsitiProperties esitiProperties;

    public EsitoBuilder(IProtocolFactory protocolFactory) throws ProtocolException {
        this.log = protocolFactory.getLogger();
        this.factory = protocolFactory;
        this.esitiProperties = EsitiProperties.getInstance(this.log);
    }

    @Override
    public IProtocolFactory getProtocolFactory() {
        return this.factory;
    }

    protected String getTipoContext(TransportRequestContext transportRequestContext) throws ProtocolException {
        String tipoContext = "standard";
        if (transportRequestContext != null) {
            String propertyName;
            String headerName;
            String value;
            List<EsitoTransportContextIdentification> list;
            if (transportRequestContext.getParametersTrasporto() != null && transportRequestContext.getParametersTrasporto().size() > 0 && (list = this.esitiProperties.getEsitoTransactionContextHeaderTrasportoDynamicIdentification()) != null && list.size() > 0) {
                for (EsitoTransportContextIdentification esitoTransportContextIdentification : list) {
                    if (!esitoTransportContextIdentification.match(transportRequestContext.getParametersTrasporto())) continue;
                    tipoContext = esitoTransportContextIdentification.getType();
                    break;
                }
            }
            if (transportRequestContext.getParametersFormBased() != null && transportRequestContext.getParametersFormBased().size() > 0 && (list = this.esitiProperties.getEsitoTransactionContextHeaderFormBasedDynamicIdentification()) != null && list.size() > 0) {
                for (EsitoTransportContextIdentification esitoTransportContextIdentification : list) {
                    if (!esitoTransportContextIdentification.match(transportRequestContext.getParametersFormBased())) continue;
                    tipoContext = esitoTransportContextIdentification.getType();
                    break;
                }
            }
            if (transportRequestContext.getParametersTrasporto() != null && transportRequestContext.getParametersTrasporto().size() > 0 && (value = transportRequestContext.getParameterTrasporto(headerName = this.esitiProperties.getEsitoTransactionContextHeaderTrasportoName())) != null) {
                if (!this.esitiProperties.getEsitiTransactionContextCode().contains(value)) {
                    this.log.error("Trovato nell'header http un header con nome [" + headerName + "] il cui valore [" + value + "] non rientra tra i tipi di contesto supportati");
                } else {
                    tipoContext = value;
                }
            }
            if (transportRequestContext.getParametersFormBased() != null && transportRequestContext.getParametersFormBased().size() > 0 && (value = transportRequestContext.getParameterFormBased(propertyName = this.esitiProperties.getEsitoTransactionContextFormBasedPropertyName())) != null) {
                if (!this.esitiProperties.getEsitiTransactionContextCode().contains(value)) {
                    this.log.error("Trovato nella url una propriet\u00e0 con nome [" + propertyName + "] il cui valore [" + value + "] non rientra tra i tipi di contesto supportati");
                } else {
                    tipoContext = value;
                }
            }
        }
        return tipoContext;
    }

    private EsitoTransazione getEsitoGenerale(InformazioniErroriInfrastrutturali informazioniErroriInfrastrutturali, String tipoContext) throws ProtocolException {
        if (informazioniErroriInfrastrutturali.isRicevutoSoapFaultServerPortaDelegata()) {
            return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.ERRORE_SERVER, tipoContext);
        }
        return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.ERRORE_GENERICO, tipoContext);
    }

    @Override
    public EsitoTransazione getEsito(TransportRequestContext transportRequestContext, EsitoTransazioneName name) {
        String tipoContext = null;
        try {
            tipoContext = this.getTipoContext(transportRequestContext);
            return this.esitiProperties.convertToEsitoTransazione(name, tipoContext);
        }
        catch (Exception e) {
            this.log.error("Errore durante la trasformazione in oggetto EsitoTransazione (utilizzo lo standard): " + e.getMessage(), (Throwable)e);
            Integer code = null;
            EsitoTransazioneName tmp = null;
            try {
                if (tipoContext == null) {
                    tipoContext = "standard";
                }
                code = this.esitiProperties.convertoToCode(name);
                tmp = name;
            }
            catch (Exception eInternal) {
                if (tipoContext != null) {
                    this.log.error("Errore durante la trasformazione interna per il codice: " + eInternal.getMessage(), (Throwable)eInternal);
                }
                return EsitoTransazione.ESITO_TRANSAZIONE_ERROR;
            }
            try {
                return new EsitoTransazione(tmp, code, tipoContext);
            }
            catch (Exception eInternal) {
                this.log.error("Errore durante la init EsitoTransazione", (Throwable)eInternal);
                return EsitoTransazione.ESITO_TRANSAZIONE_ERROR;
            }
        }
    }

    @Override
    public EsitoTransazione getEsito(TransportRequestContext transportRequestContext, OpenSPCoop2Message message, InformazioniErroriInfrastrutturali informazioniErroriInfrastrutturali, Hashtable<String, Object> context) throws ProtocolException {
        return this.getEsito(transportRequestContext, message, null, informazioniErroriInfrastrutturali, context);
    }

    @Override
    public EsitoTransazione getEsito(TransportRequestContext transportRequestContext, OpenSPCoop2Message message, ProprietaErroreApplicativo erroreApplicativo, InformazioniErroriInfrastrutturali informazioniErroriInfrastrutturali, Hashtable<String, Object> context) throws ProtocolException {
        try {
            List<Integer> customCodeForContextProperty;
            SOAPBody body = null;
            if (message != null && !message.isForcedEmptyResponse() && message.getForcedResponse() == null) {
                body = message.getSOAPBody();
            }
            if (informazioniErroriInfrastrutturali == null) {
                informazioniErroriInfrastrutturali = new InformazioniErroriInfrastrutturali();
            }
            ITraduttore trasl = this.factory.createTraduttore();
            String tipoContext = this.getTipoContext(transportRequestContext);
            boolean emissioneDiagnosticiError = context != null && context.containsKey("EMESSI_DIAGNOSTICI_ERRORE");
            EsitoTransazione returnEsitoOk = null;
            returnEsitoOk = emissioneDiagnosticiError ? this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.OK_PRESENZA_ANOMALIE, tipoContext) : this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.OK, tipoContext);
            if (context != null && (customCodeForContextProperty = this.esitiProperties.getEsitiCodeForContextPropertyIdentificationMode()) != null && customCodeForContextProperty.size() > 0) {
                for (Integer customCode : customCodeForContextProperty) {
                    List<EsitoIdentificationModeContextProperty> l = this.esitiProperties.getEsitoIdentificationModeContextPropertyList(customCode);
                    if (l == null || l.size() <= 0) continue;
                    for (EsitoIdentificationModeContextProperty esitoIdentificationModeContextProperty : l) {
                        try {
                            Object p = context.get(esitoIdentificationModeContextProperty.getName());
                            if (p == null || !(p instanceof String)) continue;
                            String pS = (String)p;
                            if (esitoIdentificationModeContextProperty.getValue() != null && !esitoIdentificationModeContextProperty.getValue().equals(pS)) continue;
                            EsitoTransazione esito = this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.CUSTOM, customCode, tipoContext);
                            List<Integer> esitiOk = this.esitiProperties.getEsitiCodeOk();
                            boolean found = false;
                            for (Integer intValue : esitiOk) {
                                if (intValue.intValue() != customCode.intValue()) continue;
                                found = true;
                            }
                            if (!found) {
                                return esito;
                            }
                            returnEsitoOk = esito;
                        }
                        catch (Throwable t) {
                            this.log.error("Errore durante la comprensione dell'esito: " + t.getMessage(), t);
                        }
                    }
                }
            }
            if (informazioniErroriInfrastrutturali.isContenutoRichiestaNonRiconosciuto()) {
                return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.CONTENUTO_RICHIESTA_NON_RICONOSCIUTO, tipoContext);
            }
            if (informazioniErroriInfrastrutturali.isContenutoRispostaNonRiconosciuto()) {
                return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.CONTENUTO_RISPOSTA_NON_RICONOSCIUTO, tipoContext);
            }
            if (informazioniErroriInfrastrutturali.isErroreUtilizzoConnettore()) {
                return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.ERRORE_INVOCAZIONE, tipoContext);
            }
            if (informazioniErroriInfrastrutturali.isErroreAutenticazione()) {
                return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.ERRORE_AUTENTICAZIONE, tipoContext);
            }
            if (informazioniErroriInfrastrutturali.isErroreAutorizzazione()) {
                return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.ERRORE_AUTORIZZAZIONE, tipoContext);
            }
            if (body == null) {
                return returnEsitoOk;
            }
            if (body.hasFault()) {
                boolean faultActorBackwardCompatibility;
                SOAPFault fault = body.getFault();
                String actor = fault.getFaultActor();
                String reason = fault.getFaultString();
                String codice = null;
                String namespaceCodice = null;
                if (fault.getFaultCodeAsQName() != null) {
                    codice = fault.getFaultCodeAsQName().getLocalPart();
                    namespaceCodice = fault.getFaultCodeAsQName().getNamespaceURI();
                } else {
                    codice = fault.getFaultCode();
                }
                Object backwardCompatibilityActorObject = message.getContextProperty("BACKWARD_COMPATIBILITY_ACTOR");
                String backwardCompatibilityActor = null;
                if (backwardCompatibilityActorObject != null) {
                    backwardCompatibilityActor = (String)backwardCompatibilityActorObject;
                }
                boolean faultActorOpenSPCoopV2 = erroreApplicativo != null && erroreApplicativo.getFaultActor() != null && erroreApplicativo.getFaultActor().equals(actor);
                boolean bl = faultActorBackwardCompatibility = backwardCompatibilityActor != null && backwardCompatibilityActor.equals(actor);
                if (faultActorOpenSPCoopV2 || faultActorBackwardCompatibility) {
                    boolean prefixBackwardCompatibility;
                    if (codice == null) {
                        return this.getEsitoGenerale(informazioniErroriInfrastrutturali, tipoContext);
                    }
                    String prefixFaultCode = erroreApplicativo.getFaultPrefixCode();
                    if (prefixFaultCode == null) {
                        prefixFaultCode = "OPENSPCOOP2_ORG_";
                    }
                    boolean prefixOpv2 = codice.startsWith(prefixFaultCode);
                    Object backwardCompatibilityPrefixObject = message.getContextProperty("BACKWARD_COMPATIBILITY_PREFIX_FAULT_CODE");
                    String backwardCompatibilityPrefix = null;
                    if (backwardCompatibilityPrefixObject != null) {
                        backwardCompatibilityPrefix = (String)backwardCompatibilityPrefixObject;
                    }
                    boolean bl2 = prefixBackwardCompatibility = backwardCompatibilityPrefix != null && codice.startsWith(backwardCompatibilityPrefix);
                    if (prefixOpv2 || prefixBackwardCompatibility) {
                        String value = null;
                        value = prefixOpv2 ? codice.substring(prefixFaultCode.length()) : codice.substring(backwardCompatibilityPrefix.length());
                        try {
                            int valueInt = Integer.parseInt(value);
                            if (valueInt >= 400 && valueInt <= 499) {
                                return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.ERRORE_PROCESSAMENTO_PDD_4XX, tipoContext);
                            }
                            if (valueInt >= 500 && valueInt <= 599) {
                                return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.ERRORE_PROCESSAMENTO_PDD_5XX, tipoContext);
                            }
                            return this.getEsitoGenerale(informazioniErroriInfrastrutturali, tipoContext);
                        }
                        catch (Throwable t) {
                            String error = "Errore calcolato da codice[" + codice + "] prefixOpv2[" + prefixOpv2 + "] prefixFaultCode[" + prefixFaultCode + "] prefixBackwardCompatibility[" + prefixBackwardCompatibility + "] prefixBackwardCompatibility[" + prefixBackwardCompatibility + "] value[" + value + "]";
                            if (this.log != null) {
                                this.log.error(error + ": " + t.getMessage(), t);
                            } else {
                                System.err.print(error);
                                t.printStackTrace(System.err);
                            }
                            return this.getEsitoGenerale(informazioniErroriInfrastrutturali, tipoContext);
                        }
                    }
                    return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.ERRORE_PROTOCOLLO, tipoContext);
                }
                if ("Client".equals(codice) && trasl.toString(MessaggiFaultErroreCooperazione.FAULT_STRING_VALIDAZIONE).equals(reason)) {
                    return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.ERRORE_PROTOCOLLO, tipoContext);
                }
                if ("Server".equals(codice) && trasl.toString(MessaggiFaultErroreCooperazione.FAULT_STRING_PROCESSAMENTO).equals(reason)) {
                    return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.ERRORE_PROTOCOLLO, tipoContext);
                }
                List<Integer> customCodeForSoapFault = this.esitiProperties.getEsitiCodeForSoapFaultIdentificationMode();
                if (customCodeForSoapFault != null && customCodeForSoapFault.size() > 0) {
                    for (Integer customCodeSF : customCodeForSoapFault) {
                        List<EsitoIdentificationModeSoapFault> l = this.esitiProperties.getEsitoIdentificationModeSoapFaultList(customCodeSF);
                        for (int i = 0; i < l.size(); ++i) {
                            EsitoIdentificationModeSoapFault e = l.get(i);
                            if (e.getFaultCode() != null && !e.getFaultCode().equals(codice) || e.getFaultNamespaceCode() != null && !e.getFaultNamespaceCode().equals(namespaceCodice) || e.getFaultReason() != null && (e.getFaultReasonContains() == null || e.getFaultReasonContains() == false ? !e.getFaultReason().equals(reason) : reason == null || !reason.contains(e.getFaultReason()))) continue;
                            if (e.getFaultActor() != null && !e.getFaultActor().equals(actor) || e.getFaultActorNotDefined() != null && e.getFaultActorNotDefined().booleanValue() && actor != null) continue;
                            return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.CUSTOM, customCodeSF, tipoContext);
                        }
                    }
                }
                if (informazioniErroriInfrastrutturali.isRicevutoSoapFaultServerPortaDelegata()) {
                    return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.ERRORE_SERVER, tipoContext);
                }
                return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.ERRORE_APPLICATIVO, tipoContext);
            }
            return this.getEsitoMessaggioApplicativo(erroreApplicativo, body, tipoContext, returnEsitoOk);
        }
        catch (Exception e) {
            throw new ProtocolException("Comprensione stato non riuscita: " + e.getMessage(), e);
        }
    }

    protected EsitoTransazione getEsitoMessaggioApplicativo(ProprietaErroreApplicativo erroreApplicativo, SOAPBody body, String tipoContext, EsitoTransazione returnEsitoOk) throws ProtocolException {
        Node childNode;
        if (erroreApplicativo != null && (childNode = body.getFirstChild()) != null && childNode.getNextSibling() == null && it.link.pdd.tools.migrazione_govway.openspcoop2_core.eccezione.errore_applicativo.utils.XMLUtils.isErroreApplicativo(childNode)) {
            try {
                byte[] xml = XMLUtils.getInstance().toByteArray(childNode, true);
                ErroreApplicativo erroreApplicativoObject = it.link.pdd.tools.migrazione_govway.openspcoop2_core.eccezione.errore_applicativo.utils.XMLUtils.getErroreApplicativo(this.log, xml);
                Eccezione ecc = erroreApplicativoObject.getEccezione();
                if ("EccezioneProtocollo".equals(ecc.getTipo())) {
                    return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.ERRORE_PROTOCOLLO, tipoContext);
                }
                String value = ecc.getCodice().getBase();
                String prefixFaultCode = erroreApplicativo.getFaultPrefixCode();
                if (prefixFaultCode == null) {
                    prefixFaultCode = "OPENSPCOOP2_ORG_";
                }
                if (value.startsWith(prefixFaultCode)) {
                    int valueInt = Integer.parseInt(value = value.substring(prefixFaultCode.length()));
                    if (valueInt >= 400 && valueInt <= 499) {
                        return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.ERRORE_PROCESSAMENTO_PDD_4XX, tipoContext);
                    }
                    if (valueInt >= 500 && valueInt <= 599) {
                        return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.ERRORE_PROCESSAMENTO_PDD_5XX, tipoContext);
                    }
                    return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.ERRORE_GENERICO, tipoContext);
                }
                return this.esitiProperties.convertToEsitoTransazione(EsitoTransazioneName.ERRORE_GENERICO, tipoContext);
            }
            catch (Exception e) {
                this.log.error("Errore durante la comprensione dell'esito: " + e.getMessage(), (Throwable)e);
            }
        }
        return returnEsitoOk;
    }
}

