/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.basic.builder;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.constants.TipoPdD;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.eccezione.details.DettaglioEccezione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.eccezione.errore_applicativo.CodiceEccezione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.eccezione.errore_applicativo.DatiCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.eccezione.errore_applicativo.Dominio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.eccezione.errore_applicativo.Eccezione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.eccezione.errore_applicativo.ErroreApplicativo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.eccezione.errore_applicativo.Servizio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.eccezione.errore_applicativo.Soggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.eccezione.errore_applicativo.SoggettoIdentificativo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.eccezione.errore_applicativo.utils.XMLUtils;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.eccezione.router_details.Dettaglio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.eccezione.router_details.DettaglioRouting;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.eccezione.router_details.DominioSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDServizio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.OpenSPCoop2Message;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.OpenSPCoop2MessageFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.SOAPFaultCode;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.SOAPVersion;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.SoapUtils;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.basic.Utilities;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.AbstractEccezioneBuilderParameter;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.EccezioneIntegrazioneBuilderParameters;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.EccezioneProtocolloBuilderParameters;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.IProtocolFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.ProtocolException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.builder.IErroreApplicativoBuilder;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.builder.ProprietaErroreApplicativo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.config.ITraduttore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.CodiceErroreCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.CodiceErroreIntegrazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.ErroreCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.ErroreIntegrazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.KeyValueObject;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.SubCodiceErrore;
import it.link.pdd.tools.migrazione_govway.utils.date.DateManager;
import java.math.BigInteger;
import java.util.Date;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPFault;
import org.slf4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ErroreApplicativoBuilder
implements IErroreApplicativoBuilder {
    protected Logger log;
    protected IProtocolFactory factory;
    protected ITraduttore traduttore;
    protected OpenSPCoop2MessageFactory msgFactory = null;
    protected it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.XMLUtils xmlUtils;

    public ErroreApplicativoBuilder(IProtocolFactory factory) throws ProtocolException {
        this.log = factory.getLogger();
        this.factory = factory;
        this.xmlUtils = it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.XMLUtils.getInstance();
        this.traduttore = factory.createTraduttore();
        this.msgFactory = OpenSPCoop2MessageFactory.getMessageFactory();
    }

    @Override
    public IProtocolFactory getProtocolFactory() {
        return this.factory;
    }

    @Override
    public String getNamespaceEccezioneProtocollo() {
        return "http://www.openspcoop2.org/core/errore_protocollo";
    }

    @Override
    public QName getQNameEccezioneProtocollo(String codice) {
        return new QName(this.getNamespaceEccezioneProtocollo(), codice, "eccProtocollo");
    }

    @Override
    public String getNamespaceEccezioneIntegrazione() {
        return "http://www.openspcoop2.org/core/errore_integrazione";
    }

    @Override
    public QName getQNameEccezioneIntegrazione(String codice) {
        return new QName(this.getNamespaceEccezioneIntegrazione(), codice, "eccIntegrazione");
    }

    @Override
    public boolean isErroreApplicativo(Node node) {
        if (node == null) {
            return false;
        }
        return this.isErroreApplicativo(node.getNamespaceURI(), node.getLocalName());
    }

    @Override
    public boolean isErroreApplicativo(String namespace, String localName) {
        return "errore-applicativo".equals(localName) && "http://www.openspcoop2.org/core/eccezione/errore_applicativo".equals(namespace);
    }

    @Override
    public OpenSPCoop2Message toMessage(EccezioneProtocolloBuilderParameters parameters) throws ProtocolException {
        return this.newMessaggioErroreApplicativo_engine(parameters, null);
    }

    @Override
    public OpenSPCoop2Message toMessage(EccezioneIntegrazioneBuilderParameters parameters) throws ProtocolException {
        return this.newMessaggioErroreApplicativo_engine(null, parameters);
    }

    @Override
    public SOAPElement toElement(EccezioneProtocolloBuilderParameters parameters) throws ProtocolException {
        return this.buildErroreApplicativoElement_engine(parameters, null);
    }

    @Override
    public SOAPElement toElement(EccezioneIntegrazioneBuilderParameters parameters) throws ProtocolException {
        return this.buildErroreApplicativoElement_engine(null, parameters);
    }

    @Override
    public String toString(EccezioneProtocolloBuilderParameters parameters) throws ProtocolException {
        return this.buildErroreApplicativoString_engine(parameters, null);
    }

    @Override
    public String toString(EccezioneIntegrazioneBuilderParameters parameters) throws ProtocolException {
        return this.buildErroreApplicativoString_engine(null, parameters);
    }

    @Override
    public byte[] toByteArray(EccezioneProtocolloBuilderParameters parameters) throws ProtocolException {
        return this.buildErroreApplicativoByteArray_engine(parameters, null);
    }

    @Override
    public byte[] toByteArray(EccezioneIntegrazioneBuilderParameters parameters) throws ProtocolException {
        return this.buildErroreApplicativoByteArray_engine(null, parameters);
    }

    @Override
    public AbstractEccezioneBuilderParameter readErroreApplicativo(String xml, String prefixCodiceErroreApplicativoIntegrazione) throws ProtocolException {
        return this.readErroreApplicativo(xml.getBytes(), prefixCodiceErroreApplicativoIntegrazione);
    }

    @Override
    public AbstractEccezioneBuilderParameter readErroreApplicativo(byte[] xml, String prefixCodiceErroreApplicativoIntegrazione) throws ProtocolException {
        try {
            String descrizione;
            Enum codice;
            if (!XMLUtils.isErroreApplicativo(xml)) {
                throw new ProtocolException("XML fornito non contiene un errore applicativo per il protocollo " + this.getProtocolFactory().getProtocol());
            }
            ErroreApplicativo erroreApplicativo = XMLUtils.getErroreApplicativo(this.log, xml);
            AbstractEccezioneBuilderParameter eccezione = null;
            if ("EccezioneProtocollo".equals(erroreApplicativo.getEccezione().getTipo())) {
                eccezione = new EccezioneProtocolloBuilderParameters();
                codice = CodiceErroreCooperazione.toCodiceErroreCooperazione(erroreApplicativo.getEccezione().getCodice().getTipo().intValue());
                descrizione = erroreApplicativo.getEccezione().getCodice().getBase();
                ErroreCooperazione erroreCooperazione = new ErroreCooperazione(descrizione, (CodiceErroreCooperazione)codice);
                it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.Eccezione eccezioneProtocollo = new it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.Eccezione(erroreCooperazione, true, erroreApplicativo.getDominio().getFunzione(), this.factory);
                if (erroreApplicativo.getEccezione().getCodice().getSottotipo() != null) {
                    SubCodiceErrore sub = new SubCodiceErrore();
                    sub.setSubCodice(erroreApplicativo.getEccezione().getCodice().getSottotipo().intValue());
                    eccezioneProtocollo.setSubCodiceEccezione(sub);
                }
                ((EccezioneProtocolloBuilderParameters)eccezione).setEccezioneProtocollo(eccezioneProtocollo);
            } else {
                eccezione = new EccezioneIntegrazioneBuilderParameters();
                codice = CodiceErroreIntegrazione.toCodiceErroreIntegrazione(erroreApplicativo.getEccezione().getCodice().getTipo().intValue());
                descrizione = erroreApplicativo.getEccezione().getCodice().getBase();
                ErroreIntegrazione erroreIntegrazione = new ErroreIntegrazione(descrizione, (CodiceErroreIntegrazione)codice, new KeyValueObject[0]);
                ((EccezioneIntegrazioneBuilderParameters)eccezione).setErroreIntegrazione(erroreIntegrazione);
            }
            eccezione.setDominioPorta(new IDSoggetto(erroreApplicativo.getDominio().getSoggetto().getTipo(), erroreApplicativo.getDominio().getSoggetto().getBase(), erroreApplicativo.getDominio().getIdentificativoPorta()));
            eccezione.setIdFunzione(erroreApplicativo.getDominio().getModulo());
            if ("PortaDelegata".equals(erroreApplicativo.getDominio().getFunzione())) {
                eccezione.setTipoPorta(TipoPdD.DELEGATA);
            } else if ("PortaApplicativa".equals(erroreApplicativo.getDominio().getFunzione())) {
                eccezione.setTipoPorta(TipoPdD.APPLICATIVA);
            } else if ("IntegrationManager".equals(erroreApplicativo.getDominio().getFunzione())) {
                eccezione.setTipoPorta(TipoPdD.INTEGRATION_MANAGER);
            } else if ("Router".equals(erroreApplicativo.getDominio().getFunzione())) {
                eccezione.setTipoPorta(TipoPdD.ROUTER);
            }
            eccezione.setOraRegistrazione(erroreApplicativo.getOraRegistrazione());
            if (erroreApplicativo.getDatiCooperazione() != null) {
                DatiCooperazione datiCooperazione = erroreApplicativo.getDatiCooperazione();
                if (datiCooperazione.getFruitore() != null) {
                    eccezione.setMittente(new IDSoggetto(datiCooperazione.getFruitore().getIdentificativo().getTipo(), datiCooperazione.getFruitore().getIdentificativo().getBase(), datiCooperazione.getFruitore().getIdentificativoPorta()));
                }
                IDServizio idServizio = null;
                if (datiCooperazione.getErogatore() != null) {
                    if (idServizio == null) {
                        idServizio = new IDServizio();
                    }
                    idServizio.setSoggettoErogatore(new IDSoggetto(datiCooperazione.getErogatore().getIdentificativo().getTipo(), datiCooperazione.getErogatore().getIdentificativo().getBase(), datiCooperazione.getErogatore().getIdentificativoPorta()));
                }
                if (datiCooperazione.getServizio() != null) {
                    idServizio.setTipoServizio(datiCooperazione.getServizio().getTipo());
                    idServizio.setServizio(datiCooperazione.getServizio().getBase());
                    if (datiCooperazione.getServizio().getVersione() != null) {
                        idServizio.setVersioneServizio(datiCooperazione.getServizio().getVersione().toString());
                    }
                }
                idServizio.setAzione(datiCooperazione.getAzione());
                if (idServizio != null) {
                    eccezione.setServizio(idServizio);
                }
                eccezione.setServizioApplicativo(datiCooperazione.getServizioApplicativo());
            }
            return eccezione;
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
    }

    @Override
    public AbstractEccezioneBuilderParameter readErroreApplicativo(Node xml, String prefixCodiceErroreApplicativoIntegrazione) throws ProtocolException {
        try {
            byte[] xmlBytes = this.xmlUtils.toByteArray(xml, true);
            return this.readErroreApplicativo(xmlBytes, prefixCodiceErroreApplicativoIntegrazione);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
    }

    @Override
    public void insertInSOAPFault(EccezioneProtocolloBuilderParameters parameters, OpenSPCoop2Message msg) throws ProtocolException {
        this.addErroreApplicativoIntoSOAPFaultDetail(this.buildErroreApplicativoElement_engine(parameters, null), msg);
    }

    @Override
    public void insertInSOAPFault(EccezioneIntegrazioneBuilderParameters parameters, OpenSPCoop2Message msg) throws ProtocolException {
        this.addErroreApplicativoIntoSOAPFaultDetail(this.buildErroreApplicativoElement_engine(null, parameters), msg);
    }

    @Override
    public void insertRoutingErrorInSOAPFault(IDSoggetto identitaRouter, String idFunzione, String msgErrore, OpenSPCoop2Message msg) throws ProtocolException {
        try {
            if (msg == null) {
                throw new ProtocolException("Messaggio non presente");
            }
            DettaglioRouting dettaglioRouting = new DettaglioRouting();
            it.link.pdd.tools.migrazione_govway.openspcoop2_core.eccezione.router_details.Dominio dominio = new it.link.pdd.tools.migrazione_govway.openspcoop2_core.eccezione.router_details.Dominio();
            DominioSoggetto dominioSoggetto = new DominioSoggetto();
            dominioSoggetto.setTipo(identitaRouter.getTipo());
            dominioSoggetto.setBase(identitaRouter.getNome());
            dominio.setSoggetto(dominioSoggetto);
            dominio.setIdentificativoPorta(identitaRouter.getCodicePorta());
            dominio.setModulo(idFunzione);
            dettaglioRouting.setDominio(dominio);
            dettaglioRouting.setOraRegistrazione(DateManager.getDate());
            Dettaglio dettaglio = new Dettaglio();
            dettaglio.setDescrizione(msgErrore);
            dettaglio.setEsito("ERRORE");
            dettaglioRouting.setDettaglio(dettaglio);
            byte[] xmlDettaglioRouting = it.link.pdd.tools.migrazione_govway.openspcoop2_core.eccezione.router_details.utils.XMLUtils.generateDettaglioRouting(dettaglioRouting);
            Element elementDettaglioRouting = this.xmlUtils.newElement(xmlDettaglioRouting);
            this.addPrefixToElement(elementDettaglioRouting, "op2RoutingDetail");
            SOAPFactory sf = SoapUtils.getSoapFactory(msg.getVersioneSoap());
            SOAPElement dettaglioRoutingElementSOAP = sf.createElement(elementDettaglioRouting);
            this.addErroreApplicativoIntoSOAPFaultDetail(dettaglioRoutingElementSOAP, msg);
        }
        catch (Exception e) {
            this.log.error("Errore durante la costruzione del messaggio di errore", (Throwable)e);
            throw new ProtocolException("Errore durante la costruzione del messaggio di errore", e);
        }
    }

    protected SOAPElement buildErroreApplicativoElement_engine(EccezioneProtocolloBuilderParameters eccezioneProtocollo, EccezioneIntegrazioneBuilderParameters eccezioneIntegrazione) throws ProtocolException {
        try {
            ErroreApplicativo erroreApplicativo = new ErroreApplicativo();
            IDSoggetto idDominio = null;
            String idModulo = null;
            TipoPdD tipoPdD = null;
            IDSoggetto fruitore = null;
            IDServizio servizio = null;
            String servizioApplicativo = null;
            String codiceEccezione = null;
            BigInteger codiceEccezioneOpenSPCoop = null;
            BigInteger subCodiceEccezioneOpenSPCoop = null;
            String descrizioneEccezione = null;
            String tipoEccezione = null;
            Date oraRegistrazione = null;
            if (eccezioneProtocollo != null) {
                idDominio = eccezioneProtocollo.getDominioPorta();
                idModulo = eccezioneProtocollo.getIdFunzione();
                tipoPdD = eccezioneProtocollo.getTipoPorta();
                fruitore = eccezioneProtocollo.getMittente();
                servizio = eccezioneProtocollo.getServizio();
                servizioApplicativo = eccezioneProtocollo.getServizioApplicativo();
                codiceEccezione = this.traduttore.toString(eccezioneProtocollo.getEccezioneProtocollo().getCodiceEccezione(), eccezioneProtocollo.getEccezioneProtocollo().getSubCodiceEccezione());
                codiceEccezioneOpenSPCoop = new BigInteger("" + eccezioneProtocollo.getEccezioneProtocollo().getCodiceEccezione().getCodice());
                if (eccezioneProtocollo.getEccezioneProtocollo().getSubCodiceEccezione() != null) {
                    subCodiceEccezioneOpenSPCoop = new BigInteger("" + eccezioneProtocollo.getEccezioneProtocollo().getSubCodiceEccezione().getSubCodice());
                }
                descrizioneEccezione = eccezioneProtocollo.getEccezioneProtocollo().getDescrizione(this.factory);
                tipoEccezione = "EccezioneProtocollo";
                oraRegistrazione = eccezioneProtocollo.getOraRegistrazione();
            } else {
                idDominio = eccezioneIntegrazione.getDominioPorta();
                idModulo = eccezioneIntegrazione.getIdFunzione();
                tipoPdD = eccezioneIntegrazione.getTipoPorta();
                fruitore = eccezioneIntegrazione.getMittente();
                servizio = eccezioneIntegrazione.getServizio();
                servizioApplicativo = eccezioneIntegrazione.getServizioApplicativo();
                codiceEccezione = this.traduttore.toCodiceErroreIntegrazioneAsString(eccezioneIntegrazione.getErroreIntegrazione(), eccezioneIntegrazione.getProprieta().getFaultPrefixCode(), eccezioneIntegrazione.getProprieta().isFaultAsGenericCode());
                codiceEccezioneOpenSPCoop = new BigInteger("" + eccezioneIntegrazione.getErroreIntegrazione().getCodiceErrore().getCodice());
                descrizioneEccezione = eccezioneIntegrazione.getProprieta().transformFaultMsg(eccezioneIntegrazione.getErroreIntegrazione(), this.factory);
                tipoEccezione = "EccezioneIntegrazione";
                oraRegistrazione = eccezioneIntegrazione.getOraRegistrazione();
            }
            String idFunzione = null;
            if (TipoPdD.DELEGATA.equals(tipoPdD)) {
                idFunzione = "PortaDelegata";
            } else if (TipoPdD.APPLICATIVA.equals(tipoPdD)) {
                idFunzione = "PortaApplicativa";
            } else if (TipoPdD.INTEGRATION_MANAGER.equals(tipoPdD)) {
                idFunzione = "IntegrationManager";
            } else if (TipoPdD.ROUTER.equals(tipoPdD)) {
                idFunzione = "Router";
            }
            Dominio dominio = new Dominio();
            it.link.pdd.tools.migrazione_govway.openspcoop2_core.eccezione.errore_applicativo.DominioSoggetto dominioSoggetto = new it.link.pdd.tools.migrazione_govway.openspcoop2_core.eccezione.errore_applicativo.DominioSoggetto();
            dominioSoggetto.setTipo(idDominio.getTipo());
            dominioSoggetto.setBase(idDominio.getNome());
            dominio.setSoggetto(dominioSoggetto);
            dominio.setIdentificativoPorta(idDominio.getCodicePorta());
            dominio.setFunzione(idFunzione);
            dominio.setModulo(idModulo);
            erroreApplicativo.setDominio(dominio);
            erroreApplicativo.setOraRegistrazione(oraRegistrazione);
            if (fruitore != null || servizio != null || servizioApplicativo != null) {
                DatiCooperazione datiCooperazione = new DatiCooperazione();
                if (fruitore != null) {
                    Soggetto fruitoreErroreApplicativo = new Soggetto();
                    SoggettoIdentificativo fruitoreIdentificativoErroreApplicativo = new SoggettoIdentificativo();
                    fruitoreIdentificativoErroreApplicativo.setTipo(fruitore.getTipo());
                    fruitoreIdentificativoErroreApplicativo.setBase(fruitore.getNome());
                    fruitoreErroreApplicativo.setIdentificativo(fruitoreIdentificativoErroreApplicativo);
                    fruitoreErroreApplicativo.setIdentificativoPorta(fruitore.getCodicePorta());
                    datiCooperazione.setFruitore(fruitoreErroreApplicativo);
                }
                if (servizio != null && servizio.getSoggettoErogatore() != null) {
                    IDSoggetto erogatore = servizio.getSoggettoErogatore();
                    Soggetto erogatoreErroreApplicativo = new Soggetto();
                    SoggettoIdentificativo erogatoreIdentificativoErroreApplicativo = new SoggettoIdentificativo();
                    erogatoreIdentificativoErroreApplicativo.setTipo(erogatore.getTipo());
                    erogatoreIdentificativoErroreApplicativo.setBase(erogatore.getNome());
                    erogatoreErroreApplicativo.setIdentificativo(erogatoreIdentificativoErroreApplicativo);
                    erogatoreErroreApplicativo.setIdentificativoPorta(erogatore.getCodicePorta());
                    datiCooperazione.setErogatore(erogatoreErroreApplicativo);
                }
                if (servizio != null && servizio.getTipoServizio() != null && servizio.getServizio() != null) {
                    Servizio servizioErroreApplicativo = new Servizio();
                    servizioErroreApplicativo.setBase(servizio.getServizio());
                    servizioErroreApplicativo.setTipo(servizio.getTipoServizio());
                    if (servizio.getVersioneServizio() != null) {
                        servizioErroreApplicativo.setVersione(new BigInteger(servizio.getVersioneServizio()));
                    }
                    datiCooperazione.setServizio(servizioErroreApplicativo);
                }
                if (servizio != null && servizio.getAzione() != null) {
                    datiCooperazione.setAzione(servizio.getAzione());
                }
                datiCooperazione.setServizioApplicativo(servizioApplicativo);
                erroreApplicativo.setDatiCooperazione(datiCooperazione);
            }
            Eccezione eccezione = new Eccezione();
            CodiceEccezione codice = new CodiceEccezione();
            codice.setBase(codiceEccezione);
            codice.setTipo(codiceEccezioneOpenSPCoop);
            codice.setSottotipo(subCodiceEccezioneOpenSPCoop);
            eccezione.setCodice(codice);
            eccezione.setDescrizione(descrizioneEccezione);
            eccezione.setTipo(tipoEccezione);
            erroreApplicativo.setEccezione(eccezione);
            byte[] xmlErroreApplicativo = XMLUtils.generateErroreApplicativo(erroreApplicativo);
            Element elementErroreApplicativo = this.xmlUtils.newElement(xmlErroreApplicativo);
            this.addPrefixToElement(elementErroreApplicativo, "op2ErrAppl");
            SOAPFactory sf = SoapUtils.getSoapFactory(SOAPVersion.SOAP11);
            SOAPElement erroreApplicativoElementSOAP = sf.createElement(elementErroreApplicativo);
            return erroreApplicativoElementSOAP;
        }
        catch (Exception e) {
            this.log.error("XMLBuilder.buildElement_Eccezione error: " + e.getMessage(), (Throwable)e);
            throw new ProtocolException("buildErroreApplicativoElement failed: " + e.getMessage(), e);
        }
    }

    private String buildErroreApplicativoString_engine(EccezioneProtocolloBuilderParameters eccezioneProtocollo, EccezioneIntegrazioneBuilderParameters eccezioneIntegrazione) throws ProtocolException {
        SOAPElement element = this.buildErroreApplicativoElement_engine(eccezioneProtocollo, eccezioneIntegrazione);
        if (element == null) {
            throw new ProtocolException("Element non generato");
        }
        try {
            String xml = this.xmlUtils.toString((Element)element, true);
            if (xml == null) {
                throw new Exception("Trasformazione in stringa non riuscita");
            }
            return xml;
        }
        catch (Exception e) {
            throw new ProtocolException("toString failed: " + e.getMessage());
        }
    }

    private byte[] buildErroreApplicativoByteArray_engine(EccezioneProtocolloBuilderParameters eccezioneProtocollo, EccezioneIntegrazioneBuilderParameters eccezioneIntegrazione) throws ProtocolException {
        SOAPElement element = this.buildErroreApplicativoElement_engine(eccezioneProtocollo, eccezioneIntegrazione);
        if (element == null) {
            throw new ProtocolException("Element non generato");
        }
        try {
            byte[] xml = this.xmlUtils.toByteArray((Element)element, true);
            if (xml == null) {
                throw new Exception("Trasformazione in byte[] non riuscita");
            }
            return xml;
        }
        catch (Exception e) {
            throw new ProtocolException("toString failed: " + e.getMessage());
        }
    }

    private OpenSPCoop2Message newMessaggioErroreApplicativo_engine(EccezioneProtocolloBuilderParameters eccezioneProtocollo, EccezioneIntegrazioneBuilderParameters eccezioneIntegrazione) throws ProtocolException {
        try {
            ProprietaErroreApplicativo proprieta = null;
            proprieta = eccezioneIntegrazione != null ? eccezioneIntegrazione.getProprieta() : eccezioneProtocollo.getProprieta();
            String codiceEccezione = null;
            String posizioneEccezione = null;
            if (eccezioneProtocollo != null) {
                String msgPortaDiDominioNonDisponibile = "Porta di Dominio del soggetto @NOMEPDD@ non disponibile".replace("@NOMEPDD@", eccezioneProtocollo.getSoggettoProduceEccezione().getTipo() + eccezioneProtocollo.getSoggettoProduceEccezione().getNome());
                if (eccezioneProtocollo.getEccezioneProtocollo().getDescrizione(this.factory).indexOf(msgPortaDiDominioNonDisponibile) == -1) {
                    eccezioneProtocollo.getEccezioneProtocollo().setDescrizione(eccezioneProtocollo.getSoggettoProduceEccezione().toString() + " ha rilevato le seguenti eccezioni:\n" + eccezioneProtocollo.getEccezioneProtocollo().getDescrizione(this.factory));
                }
                codiceEccezione = this.traduttore.toString(eccezioneProtocollo.getEccezioneProtocollo().getCodiceEccezione(), eccezioneProtocollo.getEccezioneProtocollo().getSubCodiceEccezione());
                posizioneEccezione = eccezioneProtocollo.getEccezioneProtocollo().getDescrizione(this.factory);
            } else {
                codiceEccezione = this.traduttore.toCodiceErroreIntegrazioneAsString(eccezioneIntegrazione.getErroreIntegrazione(), proprieta.getFaultPrefixCode(), proprieta.isFaultAsGenericCode());
                posizioneEccezione = proprieta.transformFaultMsg(eccezioneIntegrazione.getErroreIntegrazione(), this.factory);
            }
            SOAPElement rispostaApplicativaElement = this.buildErroreApplicativoElement_engine(eccezioneProtocollo, eccezioneIntegrazione);
            SOAPVersion soapVersion = null;
            soapVersion = eccezioneIntegrazione != null ? eccezioneIntegrazione.getVersioneSoap() : eccezioneProtocollo.getVersioneSoap();
            OpenSPCoop2Message responseSOAPMessageError = this.msgFactory.createMessage(soapVersion);
            SOAPBody soapBody = responseSOAPMessageError.getSOAPBody();
            SOAPFaultCode code = null;
            QName eccezioneName = null;
            if (eccezioneIntegrazione != null) {
                eccezioneName = this.getQNameEccezioneIntegrazione(codiceEccezione);
                code = eccezioneIntegrazione.getSoapFaultCode();
            } else {
                eccezioneName = this.getQNameEccezioneProtocollo(codiceEccezione);
                code = eccezioneProtocollo.getSoapFaultCode();
            }
            if (proprieta.isFaultAsXML()) {
                soapBody.appendChild(soapBody.getOwnerDocument().importNode((Node)rispostaApplicativaElement, true));
            } else {
                soapBody.addFault();
                SOAPFault fault = soapBody.getFault();
                responseSOAPMessageError.setFaultCode(fault, code, eccezioneName);
                fault.setFaultActor(proprieta.getFaultActor());
                if (proprieta.isInsertAsDetails()) {
                    fault.setFaultString(posizioneEccezione);
                    Detail d = fault.getDetail();
                    if (d == null) {
                        d = fault.addDetail();
                        d = fault.getDetail();
                    }
                    d.appendChild(d.getOwnerDocument().importNode((Node)rispostaApplicativaElement, true));
                } else {
                    fault.setFaultString(Utilities.toString(this.log, rispostaApplicativaElement));
                }
                DettaglioEccezione dettaglioEccezione = null;
                dettaglioEccezione = eccezioneIntegrazione != null ? eccezioneIntegrazione.getDettaglioEccezionePdD() : eccezioneProtocollo.getDettaglioEccezionePdD();
                if (dettaglioEccezione != null) {
                    Detail d = fault.getDetail();
                    if (d == null) {
                        d = fault.addDetail();
                        d = fault.getDetail();
                    }
                    byte[] dettaglioEccezioneBytes = it.link.pdd.tools.migrazione_govway.openspcoop2_core.eccezione.details.utils.XMLUtils.generateDettaglioEccezione(dettaglioEccezione);
                    d.appendChild(d.getOwnerDocument().importNode(this.xmlUtils.newDocument(dettaglioEccezioneBytes).getDocumentElement(), true));
                }
            }
            if (eccezioneProtocollo != null) {
                responseSOAPMessageError.setParseException(eccezioneProtocollo.getParseException());
            } else if (eccezioneIntegrazione != null) {
                responseSOAPMessageError.setParseException(eccezioneIntegrazione.getParseException());
            }
            return responseSOAPMessageError;
        }
        catch (Exception e) {
            this.log.error("Errore durante la costruzione del messaggio di errore applicativo", (Throwable)e);
            return this.msgFactory.createFaultMessage(SOAPVersion.SOAP11, "ErroreDiProcessamento");
        }
    }

    private void addErroreApplicativoIntoSOAPFaultDetail(SOAPElement erroreApplicativo, OpenSPCoop2Message msg) throws ProtocolException {
        try {
            if (msg == null) {
                throw new ProtocolException("Messaggio non presente");
            }
            SOAPBody soapBody = msg.getSOAPBody();
            if (soapBody == null) {
                throw new ProtocolException("SOAPBody non presente");
            }
            SOAPFault fault = null;
            if (!soapBody.hasFault()) {
                throw new ProtocolException("SOAPFault non presente");
            }
            fault = soapBody.getFault();
            if (fault == null) {
                throw new ProtocolException("SOAPFault is null");
            }
            Detail detail = fault.getDetail();
            if (detail == null) {
                detail = fault.addDetail();
                detail = fault.getDetail();
            }
            if (detail != null) {
                SOAPElement eccezioneDetailApplicativo = msg.cleanXSITypes(erroreApplicativo);
                detail.addChildElement(eccezioneDetailApplicativo);
            }
            msg.saveChanges();
        }
        catch (Exception e) {
            this.log.error("Errore durante la costruzione del messaggio di errore applicativo (InsertDetail)", (Throwable)e);
            throw new ProtocolException("Errore durante la costruzione del messaggio di errore (InsertDetail)", e);
        }
    }

    @Deprecated
    private void insertErroreApplicativoIntoSOAPFault_engine(SOAPElement erroreApplicativo, OpenSPCoop2Message msg) throws ProtocolException {
        try {
            if (msg == null) {
                throw new ProtocolException("Messaggio non presente");
            }
            SOAPBody soapBody = msg.getSOAPBody();
            if (soapBody == null) {
                throw new ProtocolException("SOAPBody non presente");
            }
            SOAPFault faultOriginale = null;
            if (!soapBody.hasFault()) {
                throw new ProtocolException("SOAPFault non presente");
            }
            faultOriginale = soapBody.getFault();
            if (faultOriginale == null) {
                throw new ProtocolException("SOAPFault is null");
            }
            SOAPElement eccezioneDetailApplicativo = msg.cleanXSITypes(erroreApplicativo);
            QName nameDetail = null;
            nameDetail = msg.getVersioneSoap() != null && SOAPVersion.SOAP12.equals((Object)msg.getVersioneSoap()) ? new QName("http://www.w3.org/2003/05/soap-envelope", "Detail") : new QName("detail");
            SOAPElement detailsFaultOriginale = null;
            Iterator itDetailsOriginali = faultOriginale.getChildElements(nameDetail);
            if (itDetailsOriginali != null && itDetailsOriginali.hasNext()) {
                detailsFaultOriginale = (SOAPElement)itDetailsOriginali.next();
            }
            String faultActor = faultOriginale.getFaultActor();
            Name faultCode = faultOriginale.getFaultCodeAsName();
            String faultCodeWithoutNamespace = null;
            if (faultCode == null || faultCode.getURI() == null || "".equals(faultCode.getURI())) {
                faultCodeWithoutNamespace = faultOriginale.getFaultCode();
            }
            Iterator faultSubCode = null;
            String faultNode = null;
            if (msg.getVersioneSoap() != null && SOAPVersion.SOAP12.equals((Object)msg.getVersioneSoap())) {
                faultSubCode = faultOriginale.getFaultSubcodes();
                faultNode = faultOriginale.getFaultNode();
            }
            String faultString = faultOriginale.getFaultString();
            msg.getSOAPBody().removeChild((Node)msg.getSOAPBody().getFault());
            SOAPFault faultPulito = msg.getSOAPBody().addFault();
            if (faultActor != null) {
                faultPulito.setFaultActor(faultActor);
            }
            if (faultCodeWithoutNamespace != null) {
                if (faultCodeWithoutNamespace.contains(":")) {
                    faultPulito.setFaultCode(faultCodeWithoutNamespace.replaceAll(":", "_"));
                } else {
                    faultPulito.setFaultCode(faultCodeWithoutNamespace);
                }
            } else if (faultCode != null) {
                faultPulito.setFaultCode(faultCode);
            }
            if (faultSubCode != null) {
                while (faultSubCode.hasNext()) {
                    QName faultSubCodeQname = (QName)faultSubCode.next();
                    faultPulito.appendFaultSubcode(faultSubCodeQname);
                }
            }
            if (faultNode != null) {
                faultPulito.setFaultNode(faultNode);
            }
            if (faultString != null) {
                faultPulito.setFaultString(faultString);
            }
            Detail detailFaultPulito = faultPulito.addDetail();
            detailFaultPulito = faultPulito.getDetail();
            if (detailsFaultOriginale != null) {
                Iterator it = detailsFaultOriginale.getChildElements();
                while (it.hasNext()) {
                    Object o = it.next();
                    if (!(o instanceof SOAPElement)) continue;
                    SOAPElement elem = (SOAPElement)o;
                    detailFaultPulito.addChildElement(elem);
                }
            }
            detailFaultPulito.addChildElement(eccezioneDetailApplicativo);
            msg.saveChanges();
        }
        catch (Exception e) {
            this.log.error("Errore durante la costruzione del messaggio di errore applicativo (InsertDetail)", (Throwable)e);
            throw new ProtocolException("Errore durante la costruzione del messaggio di errore (InsertDetail)", e);
        }
    }

    private void addPrefixToElement(Element elementErroreApplicativo, String prefix) {
    }
}

