/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.basic.builder;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.constants.TipoPdD;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDServizio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.OpenSPCoop2Message;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.OpenSPCoop2MessageFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.SOAPFaultCode;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.XMLUtils;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.Busta;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.Eccezione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.EccezioneProtocolloBuilderParameters;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.IProtocolFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.ProtocolException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.Riscontro;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.Trasmissione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.builder.IBustaBuilder;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.builder.IErroreApplicativoBuilder;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.builder.ProprietaManifestAttachments;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.config.ITraduttore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.ErroriCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.Inoltro;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.LivelloRilevanza;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.ProfiloDiCollaborazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.TipoOraRegistrazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.state.IState;
import it.link.pdd.tools.migrazione_govway.utils.date.DateManager;
import it.link.pdd.tools.migrazione_govway.utils.id.UniversallyUniqueIdentifierGenerator;
import it.link.pdd.tools.migrazione_govway.utils.xml.AbstractXMLUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPFault;
import org.slf4j.Logger;

public class BustaBuilder
implements IBustaBuilder {
    protected Logger log;
    protected IProtocolFactory protocolFactory;
    protected OpenSPCoop2MessageFactory msgFactory;
    protected AbstractXMLUtils xmlUtils;
    protected ITraduttore traduttore;
    protected IErroreApplicativoBuilder erroreApplicativoBuilder = null;
    private static final String dateformatPattern = "yyyyMMddHHmmssSSS";
    private static final UniversallyUniqueIdentifierGenerator uuidGenerator = new UniversallyUniqueIdentifierGenerator();

    public BustaBuilder(IProtocolFactory factory) throws ProtocolException {
        this.log = factory.getLogger();
        this.protocolFactory = factory;
        this.msgFactory = OpenSPCoop2MessageFactory.getMessageFactory();
        this.xmlUtils = XMLUtils.getInstance();
        this.traduttore = this.protocolFactory.createTraduttore();
        this.erroreApplicativoBuilder = this.protocolFactory.createErroreApplicativoBuilder();
    }

    @Override
    public IProtocolFactory getProtocolFactory() {
        return this.protocolFactory;
    }

    @Override
    public String newID(IState state, IDSoggetto idSoggetto, String idTransazione, Boolean isRichiesta) throws ProtocolException {
        return this.newID(state, idSoggetto, idTransazione, isRichiesta, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String newID(IState state, IDSoggetto idSoggetto, String idTransazione, Boolean isRichiesta, boolean generateIDasUUID) throws ProtocolException {
        if (generateIDasUUID) {
            try {
                UniversallyUniqueIdentifierGenerator universallyUniqueIdentifierGenerator = uuidGenerator;
                synchronized (universallyUniqueIdentifierGenerator) {
                    return uuidGenerator.newID().getAsString();
                }
            }
            catch (Exception e) {
                throw new ProtocolException(e.getMessage());
            }
        }
        String id = idTransazione;
        Date now = DateManager.getDate();
        SimpleDateFormat dateFormat = new SimpleDateFormat(dateformatPattern);
        if (isRichiesta.booleanValue()) {
            return dateFormat.format(now) + "-" + id;
        }
        return dateFormat.format(now) + "-" + id + "-response";
    }

    @Override
    public Date extractDateFromID(String id) throws ProtocolException {
        return this.extractDateFromID(id, true);
    }

    public Date extractDateFromID(String id, boolean generateIDasUUID) throws ProtocolException {
        if (id == null) {
            throw new ProtocolException("ID non fornito");
        }
        if (!generateIDasUUID) {
            if (!id.contains("-")) {
                throw new ProtocolException("ID fornito [" + id + "] non e' corretto (missing '-')");
            }
            String[] split = id.split("-");
            SimpleDateFormat dateFormat = new SimpleDateFormat(dateformatPattern);
            try {
                return dateFormat.parse(split[0].trim());
            }
            catch (Exception e) {
                throw new ProtocolException("ID fornito [" + id + "] non e' corretto: " + e.getMessage());
            }
        }
        return null;
    }

    @Override
    public SOAPElement toElement(Busta busta, boolean isRichiesta) throws ProtocolException {
        return null;
    }

    @Override
    public String toString(Busta busta, boolean isRichiesta) throws ProtocolException {
        return null;
    }

    @Override
    public byte[] toByteArray(Busta busta, boolean isRichiesta) throws ProtocolException {
        return null;
    }

    @Override
    public SOAPElement imbustamento(IState state, OpenSPCoop2Message msg, Busta busta, boolean isRichiesta, ProprietaManifestAttachments proprietaManifestAttachments) throws ProtocolException {
        if (busta.getProfiloDiCollaborazione() != null) {
            switch (busta.getProfiloDiCollaborazione()) {
                case ONEWAY: {
                    busta.setProfiloDiCollaborazione(ProfiloDiCollaborazione.ONEWAY, ProfiloDiCollaborazione.ONEWAY.getEngineValue());
                    break;
                }
                case SINCRONO: {
                    busta.setProfiloDiCollaborazione(ProfiloDiCollaborazione.SINCRONO, ProfiloDiCollaborazione.SINCRONO.getEngineValue());
                    break;
                }
                case ASINCRONO_ASIMMETRICO: {
                    busta.setProfiloDiCollaborazione(ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO, ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.getEngineValue());
                    break;
                }
                case ASINCRONO_SIMMETRICO: {
                    busta.setProfiloDiCollaborazione(ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO, ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.getEngineValue());
                    break;
                }
            }
        }
        if (busta.getTipoOraRegistrazione() != null) {
            switch (busta.getTipoOraRegistrazione()) {
                case LOCALE: {
                    busta.setTipoOraRegistrazione(TipoOraRegistrazione.LOCALE, "Locale");
                    break;
                }
                case SINCRONIZZATO: {
                    busta.setTipoOraRegistrazione(TipoOraRegistrazione.SINCRONIZZATO, "Sincronizzato");
                    break;
                }
            }
        }
        if (busta.getInoltro() != null) {
            switch (busta.getInoltro()) {
                case CON_DUPLICATI: {
                    busta.setInoltro(Inoltro.CON_DUPLICATI, "PIUDIUNAVOLTA");
                    break;
                }
                case SENZA_DUPLICATI: {
                    busta.setInoltro(Inoltro.SENZA_DUPLICATI, "ALPIUUNAVOLTA");
                    break;
                }
            }
        }
        for (Riscontro riscontro : busta.getListaRiscontri()) {
            if (riscontro.getTipoOraRegistrazione() == null) continue;
            if (riscontro.getTipoOraRegistrazione().equals(TipoOraRegistrazione.LOCALE)) {
                riscontro.setTipoOraRegistrazioneValue("Locale");
            }
            if (!riscontro.getTipoOraRegistrazione().equals(TipoOraRegistrazione.SINCRONIZZATO)) continue;
            riscontro.setTipoOraRegistrazioneValue("Sincronizzato");
        }
        for (Trasmissione trasmissione : busta.getListaTrasmissioni()) {
            if (trasmissione.getTempo() == null) continue;
            if (trasmissione.getTempo().equals(TipoOraRegistrazione.LOCALE)) {
                trasmissione.setTempoValue("Locale");
                continue;
            }
            trasmissione.setTempoValue("Sincronizzato");
        }
        return null;
    }

    @Override
    public SOAPElement addTrasmissione(OpenSPCoop2Message message, Trasmissione trasmissione) throws ProtocolException {
        return null;
    }

    @Override
    public SOAPElement sbustamento(IState state, OpenSPCoop2Message msg, Busta busta, boolean isRichiesta, ProprietaManifestAttachments proprietaManifestAttachments) throws ProtocolException {
        return null;
    }

    protected void enrichFault(OpenSPCoop2Message msg, Busta busta, boolean ignoraEccezioniNonGravi, boolean modifyFault, boolean generateErroreApplicativoIntoDetail) throws ProtocolException {
        SOAPFault f = null;
        try {
            if (!modifyFault && !generateErroreApplicativoIntoDetail) {
                return;
            }
            if (msg.getSOAPBody() != null) {
                if (!msg.getSOAPBody().hasFault()) {
                    return;
                }
                f = msg.getSOAPBody().getFault();
            }
            Eccezione ecc = null;
            if (busta.sizeListaEccezioni() == 1) {
                ecc = busta.getEccezione(0);
            } else {
                ecc = Eccezione.getEccezioneProcessamento(ErroriCooperazione.ERRORE_GENERICO_PROTOCOLLO_NON_CORRETTO.getErroreCooperazione(), this.protocolFactory);
                StringBuffer bfDescrizione = new StringBuffer();
                for (int k = 0; k < busta.sizeListaEccezioni(); ++k) {
                    Eccezione eccLista = busta.getEccezione(k);
                    if (eccLista.getRilevanza() != null && !LivelloRilevanza.isEccezioneLivelloGrave(eccLista.getRilevanza()) || eccLista.getDescrizione(this.protocolFactory) == null) continue;
                    bfDescrizione.append("[" + this.traduttore.toString(eccLista.getCodiceEccezione(), eccLista.getSubCodiceEccezione()) + "] " + eccLista.getDescrizione(this.protocolFactory) + "\n");
                }
                if (bfDescrizione.length() > 0) {
                    ecc.setDescrizione(bfDescrizione.toString());
                }
            }
            if (ecc == null) {
                return;
            }
            EccezioneProtocolloBuilderParameters params = new EccezioneProtocolloBuilderParameters();
            params.setEccezioneProtocollo(ecc);
            if (modifyFault) {
                String codiceEccezione = this.traduttore.toString(ecc.getCodiceEccezione(), ecc.getSubCodiceEccezione());
                QName eccezioneName = this.erroreApplicativoBuilder.getQNameEccezioneProtocollo(codiceEccezione);
                SOAPFaultCode code = params.getSoapFaultCode();
                msg.setFaultCode(f, code, eccezioneName);
                f.setFaultString(ecc.getDescrizione(this.protocolFactory));
                f.setFaultActor("OpenSPCoop2");
            }
            if (generateErroreApplicativoIntoDetail) {
                IDSoggetto soggettoProduceEccezione = new IDSoggetto(busta.getTipoMittente(), busta.getMittente(), busta.getIdentificativoPortaMittente());
                params.setSoggettoProduceEccezione(soggettoProduceEccezione);
                params.setDominioPorta(soggettoProduceEccezione);
                if (busta.getTipoDestinatario() != null && busta.getDestinatario() != null) {
                    IDSoggetto idSoggettoMittente = new IDSoggetto(busta.getTipoDestinatario(), busta.getDestinatario());
                    String idPortaMittente = busta.getIdentificativoPortaDestinatario();
                    if (idPortaMittente == null) {
                        idPortaMittente = this.traduttore.getIdentificativoPortaDefault(idSoggettoMittente);
                    }
                    idSoggettoMittente.setCodicePorta(idPortaMittente);
                    params.setMittente(idSoggettoMittente);
                }
                IDServizio idServizio = new IDServizio(soggettoProduceEccezione, busta.getTipoServizio(), busta.getServizio(), busta.getAzione());
                params.setServizio(idServizio);
                params.setVersioneSoap(msg.getVersioneSoap());
                params.setIdFunzione("PortaApplicativa");
                params.setServizioApplicativo(busta.getServizioApplicativoErogatore());
                params.setTipoPorta(TipoPdD.APPLICATIVA);
                this.erroreApplicativoBuilder.insertInSOAPFault(params, msg);
            }
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
    }
}

