/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.basic.archive;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.Configurazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.PortaApplicativa;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.PortaDelegata;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.ServizioApplicativo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.Soggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.constants.TipoAutorizzazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.driver.ExtendedInfoManager;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.utils.ConfigurazionePdDUtils;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.utils.serializer.JibxDeserializer;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDAccordo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDPortaApplicativaByNome;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDPortaDelegata;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.basic.archive.IdentificativoAccordo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.basic.archive.IdentificativoDocumento;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.information_missing.Openspcoop2;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.information_missing.utils.XSDValidator;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.ProtocolException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.Archive;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchiveAccordoCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchiveAccordoServizioComposto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchiveAccordoServizioParteComune;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchiveAccordoServizioParteSpecifica;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchiveFruitore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchiveIdCorrelazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchivePdd;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchivePortaApplicativa;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchivePortaDelegata;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchiveRuolo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchiveServizioApplicativo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchiveSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.IRegistryReader;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.MapPlaceholder;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.ArchiveVersion;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoServizioParteComune;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoServizioParteSpecifica;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Documento;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Fruitore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.IdSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.PortaDominio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Ruolo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.IDAccordoFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.utils.RegistroServiziUtils;
import it.link.pdd.tools.migrazione_govway.utils.Utilities;
import it.link.pdd.tools.migrazione_govway.utils.io.ZipUtilities;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.activation.FileDataSource;
import org.slf4j.Logger;

public class ZIPUtils {
    protected Logger log = null;
    protected it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.utils.serializer.JibxDeserializer jibxRegistryDeserializer = null;
    protected JibxDeserializer jibxConfigDeserializer = null;
    protected it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.information_missing.utils.serializer.JibxDeserializer jibxInformationMissingDeserializer = null;
    protected IRegistryReader registryReader;
    private static int counterFileNameWithCharNotPermitted = 0;
    public static final String ID_CORRELAZIONE_DEFAULT = "@PackageOpenSPCoop@";
    public static final String USE_VERSION_XML_BEAN = "USE_VERSION_XML_BEAN";

    public ZIPUtils(Logger log, IRegistryReader registryReader) {
        this.log = log;
        this.jibxRegistryDeserializer = new it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.utils.serializer.JibxDeserializer();
        this.jibxConfigDeserializer = new JibxDeserializer();
        this.jibxInformationMissingDeserializer = new it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.information_missing.utils.serializer.JibxDeserializer();
        this.registryReader = registryReader;
    }

    public String oldMethod_convertCharNonPermessiQualsiasiSistemaOperativo(String nome) {
        return this.oldMethod_convertCharNonPermessiQualsiasiSistemaOperativo(nome, true, null);
    }

    public String oldMethod_convertCharNonPermessiQualsiasiSistemaOperativo(String nome, boolean permitUnderscore) {
        return this.oldMethod_convertCharNonPermessiQualsiasiSistemaOperativo(nome, permitUnderscore, null);
    }

    public String oldMethod_convertCharNonPermessiQualsiasiSistemaOperativo(String nome, boolean permitUnderscore, List<Character> permit) {
        StringBuffer bf = new StringBuffer();
        for (int i = 0; i < nome.length(); ++i) {
            if (Character.isLetterOrDigit(nome.charAt(i))) {
                bf.append(nome.charAt(i));
                continue;
            }
            if (permit != null) {
                boolean found = false;
                for (char charPermit : permit) {
                    if (charPermit != nome.charAt(i)) continue;
                    found = true;
                    break;
                }
                if (found) {
                    bf.append(nome.charAt(i));
                    continue;
                }
            }
            if (!permitUnderscore) continue;
            bf.append("_");
        }
        return bf.toString();
    }

    public String convertNameToSistemaOperativoCompatible(String nome) {
        ArrayList<Character> permit = new ArrayList<Character>();
        Character cJolly = Character.valueOf('X');
        return this.convertNameToSistemaOperativoCompatible(nome, true, cJolly, permit, true);
    }

    private String convertNameToSistemaOperativoCompatible(String nome, boolean convertCharNotPermitted, Character charJollyCharNotPermitted, List<Character> permit, boolean addUniqueSuffixIfFoundCharNotPermitted) {
        StringBuffer bf = new StringBuffer();
        boolean charNotPermittedFound = false;
        for (int i = 0; i < nome.length(); ++i) {
            if (Character.isLetterOrDigit(nome.charAt(i))) {
                bf.append(nome.charAt(i));
                continue;
            }
            if (permit != null) {
                boolean found = false;
                for (char charPermit : permit) {
                    if (charPermit != nome.charAt(i)) continue;
                    found = true;
                    break;
                }
                if (found) {
                    bf.append(nome.charAt(i));
                    continue;
                }
            }
            if (convertCharNotPermitted) {
                bf.append(charJollyCharNotPermitted);
            }
            charNotPermittedFound = true;
        }
        if (charNotPermittedFound && addUniqueSuffixIfFoundCharNotPermitted) {
            bf.append("_");
            bf.append(ZIPUtils.getNextCounterFile());
        }
        return bf.toString();
    }

    private static synchronized int getNextCounterFile() {
        if (counterFileNameWithCharNotPermitted == Integer.MAX_VALUE) {
            counterFileNameWithCharNotPermitted = 0;
        }
        return ++counterFileNameWithCharNotPermitted;
    }

    public Archive getArchive(byte[] zip, MapPlaceholder placeholder, boolean validationDocuments) throws ProtocolException {
        File tmp = null;
        FileOutputStream fout = null;
        try {
            tmp = File.createTempFile("openspcoop", ".zip");
            fout = new FileOutputStream(tmp);
            fout.write(zip);
            fout.flush();
            fout.close();
            Archive archive = this.getArchive(tmp, placeholder, validationDocuments);
            return archive;
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
        finally {
            try {
                if (fout != null) {
                    fout.close();
                }
                if (tmp != null) {
                    tmp.delete();
                }
            }
            catch (Exception exception) {}
        }
    }

    public Archive getArchive(String fileName, MapPlaceholder placeholder, boolean validationDocuments) throws ProtocolException {
        return this.getArchive(new File(fileName), placeholder, validationDocuments);
    }

    public Archive getArchive(File zip, MapPlaceholder placeholder, boolean validationDocuments) throws ProtocolException {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(zip);
            Archive archive = this.getArchive(zipFile, placeholder, validationDocuments);
            return archive;
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
        finally {
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public Archive getArchive(InputStream m, MapPlaceholder placeholder, boolean validationDocuments) throws ProtocolException {
        ByteArrayOutputStream bout = null;
        try {
            bout = new ByteArrayOutputStream();
            byte[] read = new byte[1024];
            int letti = 0;
            while ((letti = m.read(read)) >= 0) {
                bout.write(read, 0, letti);
            }
            bout.flush();
            bout.close();
            m.close();
            Archive archive = this.getArchive(bout.toByteArray(), placeholder, validationDocuments);
            return archive;
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
        finally {
            try {
                if (bout != null) {
                    bout.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Archive getArchive(ZipFile zip, MapPlaceholder placeholder, boolean validationDocuments) throws ProtocolException {
        try {
            Archive archivio = new Archive();
            if (placeholder == null) {
                placeholder = new MapPlaceholder();
            }
            ArchiveIdCorrelazione idCorrelazione = new ArchiveIdCorrelazione(ID_CORRELAZIONE_DEFAULT);
            idCorrelazione.setDescrizione(zip.getName());
            ArchiveVersion archiveVersion = ArchiveVersion.V_UNDEFINED;
            String openspcoopVersion = null;
            ExtendedInfoManager extendedInfoManager = ExtendedInfoManager.getInstance();
            Hashtable<String, PortaDelegata> mapKeyForExtendedInfo_portaDelegata = new Hashtable<String, PortaDelegata>();
            boolean existsExtendsConfigForPortaDelegata = extendedInfoManager.newInstanceExtendedInfoPortaDelegata() != null;
            Hashtable<String, PortaApplicativa> mapKeyForExtendedInfo_portaApplicativa = new Hashtable<String, PortaApplicativa>();
            boolean existsExtendsConfigForPortaApplicativa = extendedInfoManager.newInstanceExtendedInfoPortaApplicativa() != null;
            Hashtable<String, IdentificativoAccordo> mapKeyAccordi = new Hashtable<String, IdentificativoAccordo>();
            Hashtable<String, IdentificativoDocumento> mapKeyDocumenti = new Hashtable<String, IdentificativoDocumento>();
            String rootDir = null;
            Iterator<ZipEntry> it = ZipUtilities.entries(zip, true);
            while (it.hasNext()) {
                ZipEntry zipEntry = it.next();
                String entryName = ZipUtilities.operativeSystemConversion(zipEntry.getName());
                if (rootDir == null) {
                    rootDir = ZipUtilities.getRootDir(entryName);
                }
                if (zipEntry.isDirectory()) continue;
                FileDataSource fds = new FileDataSource(entryName);
                String nome = fds.getName();
                String tipo = nome.substring(nome.lastIndexOf(".") + 1, nome.length());
                tipo = tipo.toUpperCase();
                InputStream inputStream = zip.getInputStream(zipEntry);
                byte[] content = Utilities.getAsByteArray(inputStream);
                ByteArrayInputStream bin = null;
                try {
                    byte[] xml;
                    if (entryName.equals(rootDir + "archive.info")) {
                        archiveVersion = ArchiveVersion.toArchiveVersion(content);
                        openspcoopVersion = ArchiveVersion.toProductVersion(content);
                        this.log.debug("Version [" + archiveVersion + "] product[" + openspcoopVersion + "]");
                        continue;
                    }
                    if (entryName.startsWith(rootDir + "configurazione" + File.separatorChar)) {
                        xml = placeholder.replace(content);
                        if (entryName.contains(File.separatorChar + "extended" + File.separatorChar)) {
                            this.readConfigurazioneExtended(archivio, bin, xml, entryName, validationDocuments, extendedInfoManager);
                            continue;
                        }
                        bin = new ByteArrayInputStream(xml);
                        this.readConfigurazione(archivio, bin, xml, entryName, validationDocuments);
                        continue;
                    }
                    if (entryName.startsWith(rootDir + "porteDominio" + File.separatorChar)) {
                        xml = placeholder.replace(content);
                        bin = new ByteArrayInputStream(xml);
                        this.readPortaDominio(archivio, bin, xml, entryName, validationDocuments, idCorrelazione);
                        continue;
                    }
                    if (entryName.startsWith(rootDir + "ruoli" + File.separatorChar)) {
                        xml = placeholder.replace(content);
                        bin = new ByteArrayInputStream(xml);
                        this.readRuolo(archivio, bin, xml, entryName, validationDocuments, idCorrelazione);
                        continue;
                    }
                    if (entryName.equals(rootDir + "informationMissing.xml")) {
                        xml = placeholder.replace(content);
                        bin = new ByteArrayInputStream(xml);
                        this.readInformationMissing(archivio, bin, xml, entryName, validationDocuments);
                        continue;
                    }
                    if (entryName.startsWith(rootDir + "soggetti" + File.separatorChar)) {
                        String key;
                        String key2;
                        String nomeFile;
                        xml = placeholder.replace(content);
                        bin = new ByteArrayInputStream(xml);
                        String name = entryName.substring((rootDir + "soggetti" + File.separatorChar).length());
                        if (!name.contains("" + File.separatorChar)) {
                            throw new ProtocolException("Elemento [" + entryName + "] errato. Dopo la directory [soggetti] deve essere presenta una ulteriore directory contenente la struttura <tipo>_<nome> che descrive il soggetto e ulteriori file e/o directory che definiscono gli elementi del soggetto");
                        }
                        String tipoNomeSoggetto = name.substring(0, name.indexOf(File.separatorChar));
                        if (tipoNomeSoggetto == null || "".equals(tipoNomeSoggetto) || !tipoNomeSoggetto.contains("_")) {
                            throw new ProtocolException("Elemento [" + entryName + "] errato. Dopo la directory [soggetti] deve essere presenta una ulteriore directory contenente la struttura <tipo>_<nome> che descrive il soggetto. Il nome utilizzato per la directory non e' conforme alla struttura attesa <tipo>_<nome>");
                        }
                        tipoNomeSoggetto = tipoNomeSoggetto.trim();
                        String tipoSoggetto = null;
                        String nomeSoggetto = null;
                        if (!tipoNomeSoggetto.equals("_")) {
                            if (tipoNomeSoggetto.startsWith("_")) {
                                nomeSoggetto = tipoNomeSoggetto.substring(1);
                            } else if (tipoNomeSoggetto.endsWith("_")) {
                                tipoSoggetto = tipoNomeSoggetto.substring(0, tipoNomeSoggetto.length() - 1);
                            } else {
                                tipoSoggetto = tipoNomeSoggetto.split("_")[0];
                                nomeSoggetto = tipoNomeSoggetto.split("_")[1];
                                if (tipoSoggetto == null || "".equals(tipoSoggetto)) {
                                    throw new ProtocolException("Elemento [" + entryName + "] errato. Dopo la directory [soggetti] deve essere presenta una ulteriore directory contenente la struttura <tipo>_<nome> che descrive il soggetto. Il nome utilizzato per la directory non e' conforme alla struttura attesa <tipo>_<nome>: tipo non identificato");
                                }
                                if (nomeSoggetto == null || "".equals(nomeSoggetto)) {
                                    throw new ProtocolException("Elemento [" + entryName + "] errato. Dopo la directory [soggetti] deve essere presenta una ulteriore directory contenente la struttura <tipo>_<nome> che descrive il soggetto. Il nome utilizzato per la directory non e' conforme alla struttura attesa <tipo>_<nome>: nome non identificato");
                                }
                            }
                        }
                        if ((nomeFile = name.substring(tipoNomeSoggetto.length() + 1, name.length())) == null) {
                            throw new ProtocolException("Elemento [" + entryName + "] errato. Dopo la directory [soggetti] deve essere presenta una ulteriore directory contenente la struttura <tipo>_<nome> che descrive il soggetto e ulteriori file e/o directory che definiscono gli elementi del soggetto: non sono stati trovati ulteriori file");
                        }
                        if (!nomeFile.contains("" + File.separatorChar)) {
                            this.readSoggetto(archivio, bin, xml, entryName, tipoSoggetto, nomeSoggetto, validationDocuments, idCorrelazione);
                            continue;
                        }
                        if (nomeFile.startsWith("serviziApplicativi" + File.separatorChar)) {
                            this.readServizioApplicativo(archivio, bin, xml, entryName, tipoSoggetto, nomeSoggetto, validationDocuments, idCorrelazione);
                            continue;
                        }
                        if (nomeFile.startsWith("porteDelegate" + File.separatorChar)) {
                            if (nomeFile.contains(File.separatorChar + "extended" + File.separatorChar)) {
                                key2 = this.getKeyPortaForExtendedInfo(tipoNomeSoggetto, nomeFile);
                                PortaDelegata pd = (PortaDelegata)mapKeyForExtendedInfo_portaDelegata.get(key2);
                                this.readPortaDelegataExtended(pd, bin, xml, entryName, validationDocuments, extendedInfoManager);
                                continue;
                            }
                            PortaDelegata pd = this.readPortaDelegata(archivio, bin, xml, entryName, tipoSoggetto, nomeSoggetto, validationDocuments, idCorrelazione);
                            if (!existsExtendsConfigForPortaDelegata) continue;
                            key = this.getKeyPortaForExtendedInfo(tipoNomeSoggetto, nomeFile);
                            mapKeyForExtendedInfo_portaDelegata.put(key, pd);
                            continue;
                        }
                        if (nomeFile.startsWith("porteApplicative" + File.separatorChar)) {
                            if (nomeFile.contains(File.separatorChar + "extended" + File.separatorChar)) {
                                key2 = this.getKeyPortaForExtendedInfo(tipoNomeSoggetto, nomeFile);
                                PortaApplicativa pa = (PortaApplicativa)mapKeyForExtendedInfo_portaApplicativa.get(key2);
                                this.readPortaApplicativaExtended(pa, bin, xml, entryName, validationDocuments, extendedInfoManager);
                                continue;
                            }
                            PortaApplicativa pa = this.readPortaApplicativa(archivio, bin, xml, entryName, tipoSoggetto, nomeSoggetto, validationDocuments, idCorrelazione);
                            if (!existsExtendsConfigForPortaApplicativa) continue;
                            key = this.getKeyPortaForExtendedInfo(tipoNomeSoggetto, nomeFile);
                            mapKeyForExtendedInfo_portaApplicativa.put(key, pa);
                            continue;
                        }
                        if (nomeFile.startsWith("accordiServizioParteComune" + File.separatorChar) || nomeFile.startsWith("accordiServizioComposto" + File.separatorChar) || nomeFile.startsWith("accordiServizioParteSpecifica" + File.separatorChar) || nomeFile.startsWith("accordiCooperazione" + File.separatorChar)) {
                            String nomeFileAccordo = null;
                            String directoryAccordo = null;
                            if (nomeFile.startsWith("accordiServizioParteComune" + File.separatorChar)) {
                                directoryAccordo = "accordiServizioParteComune";
                            } else if (nomeFile.startsWith("accordiServizioComposto" + File.separatorChar)) {
                                directoryAccordo = "accordiServizioComposto";
                            } else if (nomeFile.startsWith("accordiServizioParteSpecifica" + File.separatorChar)) {
                                directoryAccordo = "accordiServizioParteSpecifica";
                            } else if (nomeFile.startsWith("accordiCooperazione" + File.separatorChar)) {
                                directoryAccordo = "accordiCooperazione";
                            }
                            nomeFileAccordo = nomeFile.substring((directoryAccordo + File.separatorChar).length());
                            if (!nomeFileAccordo.contains("" + File.separatorChar)) {
                                throw new ProtocolException("Elemento [" + entryName + "] errato. Dopo la directory [" + directoryAccordo + "] deve essere presenta una ulteriore directory contenente la struttura <nome>[_<versione>] che descrive l'accordo e ulteriori file e/o directory che definiscono gli elementi dell'accordo");
                            }
                            String nomeVersioneAccordo = nomeFileAccordo.substring(0, nomeFileAccordo.indexOf(File.separatorChar));
                            if (nomeVersioneAccordo == null || "".equals(nomeVersioneAccordo) || "_".equals(nomeVersioneAccordo) || nomeVersioneAccordo.startsWith("_") || nomeVersioneAccordo.endsWith("_")) {
                                throw new ProtocolException("Elemento [" + entryName + "] errato. Dopo la directory [" + directoryAccordo + "] deve essere presenta una ulteriore directory contenente la struttura <nome>[_<versione>] che descrive l'accordo. Il nome utilizzato per la directory non e' conforme alla struttura attesa <nome>[_<versione>]");
                            }
                            String nomeFileSenzaAccordo = nomeFileAccordo.substring((nomeVersioneAccordo = nomeVersioneAccordo.trim()).length() + 1, nomeFileAccordo.length());
                            if (nomeFileSenzaAccordo == null) {
                                throw new ProtocolException("Elemento [" + entryName + "] errato. Dopo la directory [" + directoryAccordo + "] deve essere presenta una ulteriore directory contenente la struttura <nome>[_<versione> che descrive l'accordo e ulteriori file e/o directory che definiscono gli elementi dell'accordo: non sono stati trovati ulteriori file");
                            }
                            String versioneAccordo = null;
                            String nomeAccordo = null;
                            boolean findIdAccordo = false;
                            if (ArchiveVersion.V_UNDEFINED.equals((Object)archiveVersion)) {
                                if (nomeVersioneAccordo.contains("_")) {
                                    nomeAccordo = nomeVersioneAccordo.split("_")[0];
                                    versioneAccordo = nomeVersioneAccordo.split("_")[1];
                                    if (versioneAccordo == null || "".equals(versioneAccordo)) {
                                        throw new ProtocolException("Elemento [" + entryName + "] errato. Dopo la directory [" + directoryAccordo + "] deve essere presenta una ulteriore directory contenente la struttura <nome>[_<versione>] che descrive l'accordo. Il nome utilizzato per la directory non e' conforme alla struttura attesa <nome>[_<versione>]: versione non identificata");
                                    }
                                } else {
                                    nomeAccordo = nomeVersioneAccordo;
                                }
                                if (nomeAccordo == null || "".equals(nomeAccordo)) {
                                    throw new ProtocolException("Elemento [" + entryName + "] errato. Dopo la directory [" + directoryAccordo + "] deve essere presenta una ulteriore directory contenente la struttura <nome>[_<versione>] che descrive l'accordo. Il nome utilizzato per la directory non e' conforme alla struttura attesa <nome>[_<versione>]: nome non identificato");
                                }
                            } else {
                                IdentificativoAccordo idAccordo = null;
                                String keyAccordo = this.getKeyAccordo(tipoSoggetto, nomeSoggetto, nomeVersioneAccordo, nomeFile);
                                if (nomeFileSenzaAccordo.equals("accordo.id")) {
                                    String identificativo = new String(xml);
                                    if (identificativo.contains(" ")) {
                                        nomeAccordo = identificativo.split(" ")[0];
                                        versioneAccordo = identificativo.split(" ")[1];
                                        if (versioneAccordo == null || "".equals(versioneAccordo)) {
                                            throw new ProtocolException("Elemento [" + entryName + "] errato. Il Contenuto [" + identificativo + "] non \u00e8 corretto, deve essere presente una struttura '<nome> <versione>' che descrive l'identificativo dell'accordo: versione non identificata");
                                        }
                                    } else {
                                        nomeAccordo = identificativo;
                                    }
                                    if (nomeAccordo == null || "".equals(nomeAccordo)) {
                                        throw new ProtocolException("Elemento [" + entryName + "] errato. Il Contenuto [" + identificativo + "] non \u00e8 corretto, deve essere presenta una struttura '<nome>[ <versione>]' che descrive identificativo dell'accordo: nome non identificato");
                                    }
                                    idAccordo = new IdentificativoAccordo();
                                    idAccordo.nome = nomeAccordo;
                                    idAccordo.versione = versioneAccordo;
                                    mapKeyAccordi.put(keyAccordo, idAccordo);
                                    findIdAccordo = true;
                                } else {
                                    idAccordo = (IdentificativoAccordo)mapKeyAccordi.get(keyAccordo);
                                    if (idAccordo == null) {
                                        throw new ProtocolException("Elemento [" + entryName + "] errato. Non \u00e8 stato trovato precedentemente il file [accordo.id] contenente l'identificativo dell'accordo");
                                    }
                                    nomeAccordo = idAccordo.nome;
                                    versioneAccordo = idAccordo.versione;
                                }
                            }
                            if (findIdAccordo) continue;
                            if (nomeFile.startsWith("accordiServizioParteComune" + File.separatorChar)) {
                                this.readAccordoServizioParteComune(archivio, bin, xml, entryName, tipoSoggetto, nomeSoggetto, nomeFileSenzaAccordo, nomeAccordo, versioneAccordo, false, validationDocuments, idCorrelazione, archiveVersion, mapKeyDocumenti);
                                continue;
                            }
                            if (nomeFile.startsWith("accordiServizioComposto" + File.separatorChar)) {
                                this.readAccordoServizioParteComune(archivio, bin, xml, entryName, tipoSoggetto, nomeSoggetto, nomeFileSenzaAccordo, nomeAccordo, versioneAccordo, true, validationDocuments, idCorrelazione, archiveVersion, mapKeyDocumenti);
                                continue;
                            }
                            if (nomeFile.startsWith("accordiServizioParteSpecifica" + File.separatorChar)) {
                                this.readAccordoServizioParteSpecifica(archivio, bin, xml, entryName, tipoSoggetto, nomeSoggetto, nomeFileSenzaAccordo, nomeAccordo, versioneAccordo, validationDocuments, idCorrelazione, archiveVersion, mapKeyDocumenti);
                                continue;
                            }
                            if (!nomeFile.startsWith("accordiCooperazione" + File.separatorChar)) continue;
                            this.readAccordoCooperazione(archivio, bin, xml, entryName, tipoSoggetto, nomeSoggetto, nomeFileSenzaAccordo, nomeAccordo, versioneAccordo, validationDocuments, idCorrelazione, archiveVersion, mapKeyDocumenti);
                            continue;
                        }
                        throw new ProtocolException("Elemento [" + entryName + "] non atteso");
                    }
                    bin = new ByteArrayInputStream(content);
                    this.readExternalArchive(rootDir, archivio, bin, content, entryName, validationDocuments);
                }
                finally {
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (Exception exception) {}
                    try {
                        if (bin == null) continue;
                        bin.close();
                    }
                    catch (Exception exception) {}
                }
            }
            this.finalize(archivio, validationDocuments);
            return archivio;
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
    }

    private String getKeyAccordo(String tipoSoggetto, String nomeSoggetto, String nomeVersioneAccordo, String nomeFile) {
        StringBuffer bf = new StringBuffer();
        bf.append(tipoSoggetto == null ? "" : tipoSoggetto);
        bf.append("_");
        bf.append(nomeSoggetto == null ? "" : nomeSoggetto);
        bf.append("_");
        bf.append(nomeVersioneAccordo == null ? "" : nomeVersioneAccordo);
        bf.append("_");
        if (nomeFile.contains("accordiServizioParteComune" + File.separatorChar)) {
            bf.append("accordiServizioParteComune");
        } else if (nomeFile.contains("accordiServizioComposto" + File.separatorChar)) {
            bf.append("accordiServizioComposto");
        } else if (nomeFile.contains("accordiServizioParteSpecifica" + File.separatorChar)) {
            bf.append("accordiServizioParteSpecifica");
        } else if (nomeFile.contains("accordiCooperazione" + File.separatorChar)) {
            bf.append("accordiCooperazione");
        }
        return bf.toString();
    }

    private String getKeyDocumento(String tipoSoggetto, String nomeSoggetto, String nomeAccordo, String versioneAccordo, String nomeFile, String nomeDocumento) {
        StringBuffer bf = new StringBuffer();
        bf.append(this.getKeyAccordo(tipoSoggetto, nomeSoggetto, (nomeAccordo == null ? "" : nomeAccordo) + (versioneAccordo == null ? "" : versioneAccordo), nomeFile));
        bf.append("_");
        if (nomeFile.contains("allegati" + File.separatorChar)) {
            bf.append("allegati");
        } else if (nomeFile.contains("specificheSemiformali" + File.separatorChar)) {
            bf.append("specificheSemiformali");
        } else if (nomeFile.contains("specificheLivelliServizio" + File.separatorChar)) {
            bf.append("specificheLivelliServizio");
        } else if (nomeFile.contains("specificheSicurezza" + File.separatorChar)) {
            bf.append("specificheSicurezza");
        } else if (nomeFile.contains("specificheCoordinamento" + File.separatorChar)) {
            bf.append("specificheCoordinamento");
        }
        bf.append("_");
        bf.append(nomeDocumento);
        return bf.toString();
    }

    private String getKeyPortaForExtendedInfo(String tipoNomeSoggetto, String nomeFile) {
        String nomePortaSuFileSystem = nomeFile.substring(nomeFile.lastIndexOf(File.separatorChar));
        if (nomePortaSuFileSystem.endsWith(".xml")) {
            nomePortaSuFileSystem = nomePortaSuFileSystem.substring(0, nomePortaSuFileSystem.length() - 4);
        } else if (nomePortaSuFileSystem.endsWith(".bin") && (nomePortaSuFileSystem = nomeFile.substring(0, nomeFile.lastIndexOf(File.separatorChar))).contains("" + File.separatorChar)) {
            nomePortaSuFileSystem = nomePortaSuFileSystem.substring(nomePortaSuFileSystem.lastIndexOf(File.separatorChar));
        }
        String key = tipoNomeSoggetto + nomePortaSuFileSystem;
        return key;
    }

    public void finalize(Archive archivio, boolean validationDocuments) throws ProtocolException {
    }

    public void readExternalArchive(String rootDir, Archive archivio, InputStream bin, byte[] xml, String entryName, boolean validationDocuments) throws ProtocolException {
        throw new ProtocolException("Elemento [" + entryName + "] non atteso");
    }

    public void readConfigurazione(Archive archivio, InputStream bin, byte[] xml, String entryName, boolean validationDocuments) throws ProtocolException {
        try {
            if (validationDocuments) {
                it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.utils.XSDValidator.getXSDValidator(this.log).valida(bin);
            }
            Configurazione configurazione = this.jibxConfigDeserializer.readConfigurazione(xml);
            if (archivio.getConfigurazionePdD() != null) {
                throw new ProtocolException("Elemento [" + entryName + "] errato. Risulta esistere piu' di una configurazione della pdd");
            }
            archivio.setConfigurazionePdD(configurazione);
        }
        catch (Exception eDeserializer) {
            String xmlString = this.toStringXmlElementForErrorMessage(xml);
            throw new ProtocolException(xmlString + "Elemento [" + entryName + "] contiene una struttura xml (configurazione) non valida rispetto allo schema (ConfigurazionePdD): " + eDeserializer.getMessage(), eDeserializer);
        }
    }

    public void readConfigurazioneExtended(Archive archivio, InputStream bin, byte[] xml, String entryName, boolean validationDocuments, ExtendedInfoManager extendedInfoManager) throws ProtocolException {
        try {
            if (archivio.getConfigurazionePdD() == null) {
                archivio.setConfigurazionePdD(new Configurazione());
            }
            Object o = extendedInfoManager.newInstanceExtendedInfoConfigurazione().deserialize(this.log, archivio.getConfigurazionePdD(), xml);
            archivio.getConfigurazionePdD().addExtendedInfo(o);
        }
        catch (Exception eDeserializer) {
            String xmlString = this.toStringXmlElementForErrorMessage(xml);
            throw new ProtocolException(xmlString + "Elemento [" + entryName + "] contiene una struttura xml (configurazione-extended) non valida: " + eDeserializer.getMessage(), eDeserializer);
        }
    }

    public void readPortaDominio(Archive archivio, InputStream bin, byte[] xml, String entryName, boolean validationDocuments, ArchiveIdCorrelazione idCorrelazione) throws ProtocolException {
        try {
            if (validationDocuments) {
                it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.utils.XSDValidator.getXSDValidator(this.log).valida(bin);
            }
            PortaDominio pdd = this.jibxRegistryDeserializer.readPortaDominio(xml);
            String key = ArchivePdd.buildKey(pdd.getNome());
            if (archivio.getPdd().containsKey(key)) {
                throw new ProtocolException("Elemento [" + entryName + "] errato. Risulta esistere piu' di una pdd con key [" + key + "]");
            }
            archivio.getPdd().add(key, new ArchivePdd(pdd, idCorrelazione));
        }
        catch (Exception eDeserializer) {
            String xmlString = this.toStringXmlElementForErrorMessage(xml);
            throw new ProtocolException(xmlString + "Elemento [" + entryName + "] contiene una struttura xml (porta-dominio) non valida rispetto allo schema (RegistroServizi): " + eDeserializer.getMessage(), eDeserializer);
        }
    }

    public void readRuolo(Archive archivio, InputStream bin, byte[] xml, String entryName, boolean validationDocuments, ArchiveIdCorrelazione idCorrelazione) throws ProtocolException {
        try {
            if (validationDocuments) {
                it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.utils.XSDValidator.getXSDValidator(this.log).valida(bin);
            }
            Ruolo ruolo = this.jibxRegistryDeserializer.readRuolo(xml);
            String key = ArchiveRuolo.buildKey(ruolo.getNome());
            if (archivio.getRuoli().containsKey(key)) {
                throw new ProtocolException("Elemento [" + entryName + "] errato. Risulta esistere piu' di un ruolo con key [" + key + "]");
            }
            archivio.getRuoli().add(key, new ArchiveRuolo(ruolo, idCorrelazione));
        }
        catch (Exception eDeserializer) {
            String xmlString = this.toStringXmlElementForErrorMessage(xml);
            throw new ProtocolException(xmlString + "Elemento [" + entryName + "] contiene una struttura xml (ruolo) non valida rispetto allo schema (RegistroServizi): " + eDeserializer.getMessage(), eDeserializer);
        }
    }

    public void readInformationMissing(Archive archivio, InputStream bin, byte[] xml, String entryName, boolean validationDocuments) throws ProtocolException {
        try {
            Openspcoop2 informationMissingOp2 = null;
            if (archivio.getInformationMissing() != null) {
                informationMissingOp2 = archivio.getInformationMissing();
            }
            if (informationMissingOp2 != null) {
                throw new ProtocolException("Elemento [" + entryName + "] errato. Una definizione xml di informationMissing e' presente piu' di una volta");
            }
            if (validationDocuments) {
                XSDValidator.getXSDValidator(this.log).valida(bin);
            }
            informationMissingOp2 = this.jibxInformationMissingDeserializer.readOpenspcoop2(xml);
            archivio.setInformationMissing(informationMissingOp2);
        }
        catch (Exception eDeserializer) {
            String xmlString = this.toStringXmlElementForErrorMessage(xml);
            throw new ProtocolException(xmlString + "Elemento [" + entryName + "] contiene una struttura xml (informationMissing) non valida rispetto allo schema informationMissing.xsd: " + eDeserializer.getMessage(), eDeserializer);
        }
    }

    public void readSoggetto(Archive archivio, InputStream bin, byte[] xml, String entryName, String tipoSoggetto, String nomeSoggetto, boolean validationDocuments, ArchiveIdCorrelazione idCorrelazione) throws ProtocolException {
        boolean registro = false;
        String schema = null;
        if (RegistroServiziUtils.isRegistroServizi(xml, "soggetto")) {
            registro = true;
            schema = "RegistroServizi";
        } else if (ConfigurazionePdDUtils.isConfigurazionePdD(xml, "soggetto")) {
            registro = false;
            schema = "ConfigurazionePdD";
        } else {
            throw new ProtocolException("Elemento [" + entryName + "] errato. Attesa una definizione del soggetto che contenga informazioni di registro (namespace: http://www.openspcoop2.org/core/registry) o di configurazione (http://www.openspcoop2.org/core/config)");
        }
        try {
            if (tipoSoggetto == null || nomeSoggetto == null) {
                throw new ProtocolException("Elemento [" + entryName + "] errato. Non e' possibile fornire una definizione di soggetto all'interna di una directory che non definisce il tipo o il nome del soggetto");
            }
            it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Soggetto soggettoRegistroServizi = null;
            Soggetto soggettoConfigurazione = null;
            String key = ArchiveSoggetto.buildKey(tipoSoggetto, nomeSoggetto);
            if (archivio.getSoggetti().containsKey(key)) {
                ArchiveSoggetto archiveSoggetto = (ArchiveSoggetto)archivio.getSoggetti().remove(key);
                soggettoRegistroServizi = archiveSoggetto.getSoggettoRegistro();
                soggettoConfigurazione = archiveSoggetto.getSoggettoConfigurazione();
            }
            if (registro) {
                if (soggettoRegistroServizi != null) {
                    throw new ProtocolException("Elemento [" + entryName + "] errato. Una definizione xml del soggetto con tipologia (" + schema + ") e' presente piu' di una volta");
                }
                if (validationDocuments) {
                    it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.utils.XSDValidator.getXSDValidator(this.log).valida(bin);
                }
                if (!tipoSoggetto.equals((soggettoRegistroServizi = this.jibxRegistryDeserializer.readSoggetto(xml)).getTipo())) {
                    throw new ProtocolException("Elemento [" + entryName + "] errato. La definizione xml del soggetto (" + schema + ") contiene un tipo [" + soggettoRegistroServizi.getTipo() + "] differente da quello indicato [" + tipoSoggetto + "] nella directory che contiene la definizione");
                }
                if (!nomeSoggetto.equals(soggettoRegistroServizi.getNome())) {
                    throw new ProtocolException("Elemento [" + entryName + "] errato. La definizione xml del soggetto (" + schema + ") contiene un tipo [" + soggettoRegistroServizi.getNome() + "] differente da quello indicato [" + nomeSoggetto + "] nella directory che contiene la definizione");
                }
            } else if (!registro) {
                if (soggettoConfigurazione != null) {
                    throw new ProtocolException("Elemento [" + entryName + "] errato. Una definizione xml del soggetto con tipologia (" + schema + ") e' presente piu' di una volta");
                }
                if (validationDocuments) {
                    it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.utils.XSDValidator.getXSDValidator(this.log).valida(bin);
                }
                if (!tipoSoggetto.equals((soggettoConfigurazione = this.jibxConfigDeserializer.readSoggetto(xml)).getTipo())) {
                    throw new ProtocolException("Elemento [" + entryName + "] errato. La definizione xml del soggetto (" + schema + ") contiene un tipo [" + soggettoConfigurazione.getTipo() + "] differente da quello indicato [" + tipoSoggetto + "] nella directory che contiene la definizione");
                }
                if (!nomeSoggetto.equals(soggettoConfigurazione.getNome())) {
                    throw new ProtocolException("Elemento [" + entryName + "] errato. La definizione xml del soggetto (" + schema + ") contiene un tipo [" + soggettoConfigurazione.getNome() + "] differente da quello indicato [" + nomeSoggetto + "] nella directory che contiene la definizione");
                }
            } else {
                throw new ProtocolException("Elemento [" + entryName + "] errato. Attesa una definizione del soggetto che contenga informazioni di registro (namespace: http://www.openspcoop2.org/core/registry) o di configurazione (http://www.openspcoop2.org/core/config)");
            }
            if (soggettoConfigurazione != null && soggettoRegistroServizi != null) {
                archivio.getSoggetti().add(key, new ArchiveSoggetto(soggettoConfigurazione, soggettoRegistroServizi, idCorrelazione));
            } else if (soggettoConfigurazione != null) {
                archivio.getSoggetti().add(key, new ArchiveSoggetto(soggettoConfigurazione, idCorrelazione));
            } else {
                archivio.getSoggetti().add(key, new ArchiveSoggetto(soggettoRegistroServizi, idCorrelazione));
            }
        }
        catch (Exception eDeserializer) {
            String xmlString = this.toStringXmlElementForErrorMessage(xml);
            throw new ProtocolException(xmlString + "Elemento [" + entryName + "] contiene una struttura xml (soggetto) non valida rispetto allo schema (" + schema + "): " + eDeserializer.getMessage(), eDeserializer);
        }
    }

    public void readServizioApplicativo(Archive archivio, InputStream bin, byte[] xml, String entryName, String tipoSoggetto, String nomeSoggetto, boolean validationDocuments, ArchiveIdCorrelazione idCorrelazione) throws ProtocolException {
        try {
            if (validationDocuments) {
                it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.utils.XSDValidator.getXSDValidator(this.log).valida(bin);
            }
            ServizioApplicativo sa = this.jibxConfigDeserializer.readServizioApplicativo(xml);
            sa.setTipoSoggettoProprietario(tipoSoggetto);
            sa.setNomeSoggettoProprietario(nomeSoggetto);
            String tipoSoggettoKey = tipoSoggetto != null ? tipoSoggetto : "";
            String nomeSoggettoKey = nomeSoggetto != null ? nomeSoggetto : "";
            String key = ArchiveServizioApplicativo.buildKey(tipoSoggettoKey, nomeSoggettoKey, sa.getNome());
            if (archivio.getServiziApplicativi().containsKey(key)) {
                throw new ProtocolException("Elemento [" + entryName + "] errato. Risulta esistere piu' di un servizio applicativo con key [" + key + "]");
            }
            archivio.getServiziApplicativi().add(key, new ArchiveServizioApplicativo(sa, idCorrelazione, true));
        }
        catch (Exception eDeserializer) {
            String xmlString = this.toStringXmlElementForErrorMessage(xml);
            throw new ProtocolException(xmlString + "Elemento [" + entryName + "] contiene una struttura xml (servizio-applicativo) non valida rispetto allo schema (ConfigurazionePdD): " + eDeserializer.getMessage(), eDeserializer);
        }
    }

    public PortaDelegata readPortaDelegata(Archive archivio, InputStream bin, byte[] xml, String entryName, String tipoSoggetto, String nomeSoggetto, boolean validationDocuments, ArchiveIdCorrelazione idCorrelazione) throws ProtocolException {
        try {
            PortaDelegata pd;
            if (validationDocuments) {
                it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.utils.XSDValidator.getXSDValidator(this.log).valida(bin);
            }
            if ("openspcoop".equals((pd = this.jibxConfigDeserializer.readPortaDelegata(xml)).getAutorizzazione())) {
                pd.setAutorizzazione(TipoAutorizzazione.AUTHENTICATED.getValue());
            }
            pd.setTipoSoggettoProprietario(tipoSoggetto);
            pd.setNomeSoggettoProprietario(nomeSoggetto);
            String nome = pd.getNome();
            if (pd.getLocation() != null && !"".equals(pd.getLocation())) {
                nome = pd.getLocation();
            }
            String tipoSoggettoKey = tipoSoggetto != null ? tipoSoggetto : "";
            String nomeSoggettoKey = nomeSoggetto != null ? nomeSoggetto : "";
            String key = ArchivePortaDelegata.buildKey(tipoSoggettoKey, nomeSoggettoKey, nome);
            if (archivio.getPorteDelegate().containsKey(key)) {
                throw new ProtocolException("Elemento [" + entryName + "] errato. Risulta esistere piu' di una porta con key [" + key + "]");
            }
            archivio.getPorteDelegate().add(key, new ArchivePortaDelegata(pd, idCorrelazione, true));
            return pd;
        }
        catch (Exception eDeserializer) {
            String xmlString = this.toStringXmlElementForErrorMessage(xml);
            throw new ProtocolException(xmlString + "Elemento [" + entryName + "] contiene una struttura xml (porta-delegata) non valida rispetto allo schema (ConfigurazionePdD): " + eDeserializer.getMessage(), eDeserializer);
        }
    }

    public void readPortaDelegataExtended(PortaDelegata pd, InputStream bin, byte[] xml, String entryName, boolean validationDocuments, ExtendedInfoManager extendedInfoManager) throws ProtocolException {
        try {
            if (pd == null) {
                throw new Exception("Non \u00e8 possibile indicare una configurazione estesa senza indicare anche la definizione della porta delegata");
            }
            Object o = extendedInfoManager.newInstanceExtendedInfoPortaDelegata().deserialize(this.log, pd, xml);
            pd.addExtendedInfo(o);
        }
        catch (Exception eDeserializer) {
            String xmlString = this.toStringXmlElementForErrorMessage(xml);
            throw new ProtocolException(xmlString + "Elemento [" + entryName + "] contiene una struttura xml (porta-delegata-extended) non valida: " + eDeserializer.getMessage(), eDeserializer);
        }
    }

    public PortaApplicativa readPortaApplicativa(Archive archivio, InputStream bin, byte[] xml, String entryName, String tipoSoggetto, String nomeSoggetto, boolean validationDocuments, ArchiveIdCorrelazione idCorrelazione) throws ProtocolException {
        try {
            if (validationDocuments) {
                it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.utils.XSDValidator.getXSDValidator(this.log).valida(bin);
            }
            PortaApplicativa pa = this.jibxConfigDeserializer.readPortaApplicativa(xml);
            pa.setTipoSoggettoProprietario(tipoSoggetto);
            pa.setNomeSoggettoProprietario(nomeSoggetto);
            String tipoSoggettoKey = tipoSoggetto != null ? tipoSoggetto : "";
            String nomeSoggettoKey = nomeSoggetto != null ? nomeSoggetto : "";
            String key = ArchivePortaApplicativa.buildKey(tipoSoggettoKey, nomeSoggettoKey, pa.getNome());
            if (archivio.getPorteApplicative().containsKey(key)) {
                throw new ProtocolException("Elemento [" + entryName + "] errato. Risulta esistere piu' di una porta con key [" + key + "]");
            }
            archivio.getPorteApplicative().add(key, new ArchivePortaApplicativa(pa, idCorrelazione, true));
            return pa;
        }
        catch (Exception eDeserializer) {
            String xmlString = this.toStringXmlElementForErrorMessage(xml);
            throw new ProtocolException(xmlString + "Elemento [" + entryName + "] contiene una struttura xml (porta-applicativa) non valida rispetto allo schema (ConfigurazionePdD): " + eDeserializer.getMessage(), eDeserializer);
        }
    }

    public void readPortaApplicativaExtended(PortaApplicativa pa, InputStream bin, byte[] xml, String entryName, boolean validationDocuments, ExtendedInfoManager extendedInfoManager) throws ProtocolException {
        try {
            if (pa == null) {
                throw new Exception("Non \u00e8 possibile indicare una configurazione estesa senza indicare anche la definizione della porta applicativa");
            }
            Object o = extendedInfoManager.newInstanceExtendedInfoPortaApplicativa().deserialize(this.log, pa, xml);
            pa.addExtendedInfo(o);
        }
        catch (Exception eDeserializer) {
            String xmlString = this.toStringXmlElementForErrorMessage(xml);
            throw new ProtocolException(xmlString + "Elemento [" + entryName + "] contiene una struttura xml (porta-applicativa-extended) non valida: " + eDeserializer.getMessage(), eDeserializer);
        }
    }

    public void readAccordoServizioParteComune(Archive archivio, InputStream bin, byte[] xml, String entryName, String tipoSoggetto, String nomeSoggetto, String nomeFileSenzaAccordo, String nomeAccordo, String versioneAccordo, boolean servizioComposto, boolean validationDocuments, ArchiveIdCorrelazione idCorrelazione, ArchiveVersion archiveVersion, Hashtable<String, IdentificativoDocumento> mapKeyDocumenti) throws ProtocolException {
        String key = null;
        String tipoSoggettoKey = tipoSoggetto != null ? tipoSoggetto : "";
        String nomeSoggettoKey = nomeSoggetto != null ? nomeSoggetto : "";
        String versioneKey = versioneAccordo != null ? versioneAccordo : "";
        key = servizioComposto ? ArchiveAccordoServizioComposto.buildKey(tipoSoggettoKey, nomeSoggettoKey, nomeAccordo, versioneKey) : ArchiveAccordoServizioParteComune.buildKey(tipoSoggettoKey, nomeSoggettoKey, nomeAccordo, versioneKey);
        if (!nomeFileSenzaAccordo.contains("" + File.separatorChar)) {
            try {
                AccordoServizioParteComune aspc;
                if (validationDocuments) {
                    it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.utils.XSDValidator.getXSDValidator(this.log).valida(bin);
                }
                if ((aspc = this.jibxRegistryDeserializer.readAccordoServizioParteComune(xml)).getSoggettoReferente() == null) {
                    aspc.setSoggettoReferente(new IdSoggetto());
                }
                if (tipoSoggetto != null && aspc.getSoggettoReferente().getTipo() != null && !aspc.getSoggettoReferente().getTipo().equals(tipoSoggetto)) {
                    throw new ProtocolException("Elemento [" + entryName + "] errato. La definizione xml dell'accordo (RegistroServizi) contiene un soggetto referente con tipo [" + aspc.getSoggettoReferente().getTipo() + "] differente da quello indicato [" + tipoSoggetto + "] nella directory che contiene la definizione");
                }
                if (nomeSoggetto != null && aspc.getSoggettoReferente().getNome() != null && !aspc.getSoggettoReferente().getNome().equals(nomeSoggetto)) {
                    throw new ProtocolException("Elemento [" + entryName + "] errato. La definizione xml dell'accordo (RegistroServizi) contiene un soggetto referente con nome [" + aspc.getSoggettoReferente().getNome() + "] differente da quello indicato [" + nomeSoggetto + "] nella directory che contiene la definizione");
                }
                aspc.getSoggettoReferente().setTipo(tipoSoggetto);
                aspc.getSoggettoReferente().setNome(nomeSoggetto);
                if (ArchiveVersion.V_UNDEFINED.equals((Object)archiveVersion)) {
                    String convertName = this.oldMethod_convertCharNonPermessiQualsiasiSistemaOperativo(aspc.getNome(), false);
                    if (!convertName.equals(nomeAccordo)) {
                        throw new ProtocolException("Elemento [" + entryName + "] errato. La definizione xml dell'accordo (RegistroServizi) contiene un nome [" + aspc.getNome() + "] (fileSystemName:" + convertName + ") differente da quello indicato [" + nomeAccordo + "] nella directory che contiene la definizione");
                    }
                    if (!USE_VERSION_XML_BEAN.equals(versioneAccordo)) {
                        if (versioneAccordo != null && aspc.getVersione() != null && !"".equals(aspc.getVersione())) {
                            String convertVersion = this.oldMethod_convertCharNonPermessiQualsiasiSistemaOperativo(aspc.getVersione(), false);
                            if (aspc.getVersione() != null && !convertVersion.equals(versioneAccordo)) {
                                throw new ProtocolException("Elemento [" + entryName + "] errato. La definizione xml dell'accordo (RegistroServizi) contiene una versione [" + aspc.getVersione() + "] (fileSystemName:" + convertVersion + ") differente da quella indicato [" + versioneAccordo + "] nella directory che contiene la definizione");
                            }
                        }
                        aspc.setVersione(versioneAccordo);
                    }
                } else {
                    if (!aspc.getNome().equals(nomeAccordo)) {
                        throw new ProtocolException("Elemento [" + entryName + "] errato. La definizione xml dell'accordo (RegistroServizi) contiene un nome [" + aspc.getNome() + "] differente da quello indicato [" + nomeAccordo + "] nel file [accordo.id]");
                    }
                    if (!USE_VERSION_XML_BEAN.equals(versioneAccordo)) {
                        if (versioneAccordo != null && aspc.getVersione() != null && !"".equals(aspc.getVersione()) && !aspc.getVersione().equals(versioneAccordo)) {
                            throw new ProtocolException("Elemento [" + entryName + "] errato. La definizione xml dell'accordo (RegistroServizi) contiene una versione [" + aspc.getVersione() + "] differente da quella indicata [" + versioneAccordo + "] nel file [accordo.id]");
                        }
                        aspc.setVersione(versioneAccordo);
                    }
                }
                if (servizioComposto) {
                    if (aspc.getServizioComposto() == null) {
                        throw new ProtocolException("Elemento [" + entryName + "] errato. La definizione xml dell'accordo (RegistroServizi) non contiene le informazioni obbligatorie in un servizio composto");
                    }
                    if (archivio.getAccordiServizioComposto().containsKey(key)) {
                        throw new ProtocolException("Elemento [" + entryName + "] errato. Risulta esistere piu' di un accordo con key [" + key + "]");
                    }
                    archivio.getAccordiServizioComposto().add(key, new ArchiveAccordoServizioComposto(aspc, idCorrelazione, true));
                }
                if (aspc.getServizioComposto() != null) {
                    throw new ProtocolException("Elemento [" + entryName + "] errato. La definizione xml dell'accordo (RegistroServizi) contiene le informazioni per un servizio composto, ma l'accordo e' stato definito tra gli accordi di servizio parte comune");
                }
                if (archivio.getAccordiServizioParteComune().containsKey(key)) {
                    throw new ProtocolException("Elemento [" + entryName + "] errato. Risulta esistere piu' di un accordo con key [" + key + "]");
                }
                archivio.getAccordiServizioParteComune().add(key, new ArchiveAccordoServizioParteComune(aspc, idCorrelazione, true));
            }
            catch (Exception eDeserializer) {
                String xmlString = this.toStringXmlElementForErrorMessage(xml);
                throw new ProtocolException(xmlString + "Elemento [" + entryName + "] contiene una struttura xml (accordo-servizio-parte-comune) non valida rispetto allo schema (RegistroServizi): " + eDeserializer.getMessage(), eDeserializer);
            }
        } else {
            AccordoServizioParteComune as = null;
            if (servizioComposto) {
                if (!archivio.getAccordiServizioComposto().containsKey(key)) {
                    throw new ProtocolException("Elemento [" + entryName + "] non atteso. Non e' possibile fornire dei documenti di un accordo senza fornire la definizione xml dell'accordo");
                }
                as = ((ArchiveAccordoServizioComposto)archivio.getAccordiServizioComposto().get(key)).getAccordoServizioParteComune();
            } else {
                if (!archivio.getAccordiServizioParteComune().containsKey(key)) {
                    throw new ProtocolException("Elemento [" + entryName + "] non atteso. Non e' possibile fornire dei documenti di un accordo senza fornire la definizione xml dell'accordo");
                }
                as = ((ArchiveAccordoServizioParteComune)archivio.getAccordiServizioParteComune().get(key)).getAccordoServizioParteComune();
            }
            if (nomeFileSenzaAccordo.startsWith("wsdl" + File.separatorChar)) {
                if (nomeFileSenzaAccordo.equalsIgnoreCase("wsdl" + File.separatorChar + "InterfacciaDefinitoria.xsd")) {
                    as.setByteWsdlDefinitorio(xml);
                } else if (nomeFileSenzaAccordo.equalsIgnoreCase("wsdl" + File.separatorChar + "InterfacciaConcettuale.wsdl")) {
                    as.setByteWsdlConcettuale(xml);
                } else if (nomeFileSenzaAccordo.equalsIgnoreCase("wsdl" + File.separatorChar + "InterfacciaLogicaErogatore.wsdl")) {
                    as.setByteWsdlLogicoErogatore(xml);
                } else if (nomeFileSenzaAccordo.equalsIgnoreCase("wsdl" + File.separatorChar + "InterfacciaLogicaFruitore.wsdl")) {
                    as.setByteWsdlLogicoFruitore(xml);
                }
            } else if (nomeFileSenzaAccordo.startsWith("specificheConversazioni" + File.separatorChar)) {
                if (nomeFileSenzaAccordo.equalsIgnoreCase("wsdl" + File.separatorChar + "ConversazioneConcettuale.xml")) {
                    as.setByteSpecificaConversazioneConcettuale(xml);
                } else if (nomeFileSenzaAccordo.equalsIgnoreCase("wsdl" + File.separatorChar + "ConversazioneLogicaErogatore.xml")) {
                    as.setByteSpecificaConversazioneErogatore(xml);
                } else if (nomeFileSenzaAccordo.equalsIgnoreCase("wsdl" + File.separatorChar + "ConversazioneLogicaFruitore.xml")) {
                    as.setByteSpecificaConversazioneFruitore(xml);
                }
            } else if (nomeFileSenzaAccordo.startsWith("allegati" + File.separatorChar)) {
                this.processDocument(nomeFileSenzaAccordo, "allegati", archiveVersion, entryName, xml, tipoSoggetto, nomeSoggetto, nomeAccordo, versioneAccordo, mapKeyDocumenti, as.getAllegatoList());
            } else if (nomeFileSenzaAccordo.startsWith("specificheSemiformali" + File.separatorChar)) {
                this.processDocument(nomeFileSenzaAccordo, "specificheSemiformali", archiveVersion, entryName, xml, tipoSoggetto, nomeSoggetto, nomeAccordo, versioneAccordo, mapKeyDocumenti, as.getSpecificaSemiformaleList());
            } else if (nomeFileSenzaAccordo.startsWith("specificheCoordinamento" + File.separatorChar)) {
                if (!servizioComposto) {
                    throw new ProtocolException("Elemento [" + entryName + "] non atteso. Non e' possibile fornire dei documenti di specifica di coordinamento per un accordo non registrato come servizio composto");
                }
                this.processDocument(nomeFileSenzaAccordo, "specificheCoordinamento", archiveVersion, entryName, xml, tipoSoggetto, nomeSoggetto, nomeAccordo, versioneAccordo, mapKeyDocumenti, as.getServizioComposto().getSpecificaCoordinamentoList());
            }
        }
    }

    public void readAccordoServizioParteSpecifica(Archive archivio, InputStream bin, byte[] xml, String entryName, String tipoSoggetto, String nomeSoggetto, String nomeFileSenzaAccordo, String nomeAccordo, String versioneAccordo, boolean validationDocuments, ArchiveIdCorrelazione idCorrelazione, ArchiveVersion archiveVersion, Hashtable<String, IdentificativoDocumento> mapKeyDocumenti) throws ProtocolException {
        String tipoSoggettoKey = tipoSoggetto != null ? tipoSoggetto : "";
        String nomeSoggettoKey = nomeSoggetto != null ? nomeSoggetto : "";
        String versioneKey = versioneAccordo != null ? versioneAccordo : "";
        String key = ArchiveAccordoServizioParteSpecifica.buildKey(tipoSoggettoKey, nomeSoggettoKey, nomeAccordo, versioneKey);
        if (!nomeFileSenzaAccordo.contains("" + File.separatorChar)) {
            try {
                if (validationDocuments) {
                    it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.utils.XSDValidator.getXSDValidator(this.log).valida(bin);
                }
                AccordoServizioParteSpecifica asps = this.jibxRegistryDeserializer.readAccordoServizioParteSpecifica(xml);
                asps.getServizio().setTipoSoggettoErogatore(tipoSoggetto);
                asps.getServizio().setNomeSoggettoErogatore(nomeSoggetto);
                if (ArchiveVersion.V_UNDEFINED.equals((Object)archiveVersion)) {
                    String convertName = this.oldMethod_convertCharNonPermessiQualsiasiSistemaOperativo(asps.getNome(), false);
                    if (!convertName.equals(nomeAccordo)) {
                        throw new ProtocolException("Elemento [" + entryName + "] errato. La definizione xml dell'accordo (RegistroServizi) contiene un nome [" + asps.getNome() + "] (fileSystemName:" + convertName + ") differente da quello indicato [" + nomeAccordo + "] nella directory che contiene la definizione");
                    }
                    if (!USE_VERSION_XML_BEAN.equals(versioneAccordo)) {
                        if (versioneAccordo != null && asps.getVersione() != null && !"".equals(asps.getVersione())) {
                            String convertVersion = this.oldMethod_convertCharNonPermessiQualsiasiSistemaOperativo(asps.getVersione(), false);
                            if (asps.getVersione() != null && !convertVersion.equals(versioneAccordo)) {
                                throw new ProtocolException("Elemento [" + entryName + "] errato. La definizione xml dell'accordo (RegistroServizi) contiene una versione [" + asps.getVersione() + "] (fileSystemName:" + convertVersion + ") differente da quella indicato [" + versioneAccordo + "] nella directory che contiene la definizione");
                            }
                        }
                        asps.setVersione(versioneAccordo);
                    }
                } else {
                    if (!asps.getNome().equals(nomeAccordo)) {
                        throw new ProtocolException("Elemento [" + entryName + "] errato. La definizione xml dell'accordo (RegistroServizi) contiene un nome [" + asps.getNome() + "] differente da quello indicato [" + nomeAccordo + "] nel file [accordo.id]");
                    }
                    if (!USE_VERSION_XML_BEAN.equals(versioneAccordo)) {
                        if (versioneAccordo != null && asps.getVersione() != null && !"".equals(asps.getVersione()) && !asps.getVersione().equals(versioneAccordo)) {
                            throw new ProtocolException("Elemento [" + entryName + "] errato. La definizione xml dell'accordo (RegistroServizi) contiene una versione [" + asps.getVersione() + "] differente da quella indicata [" + versioneAccordo + "] nel file [accordo.id]");
                        }
                        asps.setVersione(versioneAccordo);
                    }
                }
                if (asps.sizeFruitoreList() > 0) {
                    throw new ProtocolException("Elemento [" + entryName + "] errato. La definizione xml dell'accordo (RegistroServizi) non deve contenere fruizioni (eventuali fruizioni devono essere configurate nella struttura apposita)");
                }
                if (archivio.getAccordiServizioParteSpecifica().containsKey(key)) {
                    throw new ProtocolException("Elemento [" + entryName + "] errato. Risulta esistere piu' di un accordo con key [" + key + "]");
                }
                archivio.getAccordiServizioParteSpecifica().add(key, new ArchiveAccordoServizioParteSpecifica(asps, idCorrelazione, true));
            }
            catch (Exception eDeserializer) {
                String xmlString = this.toStringXmlElementForErrorMessage(xml);
                throw new ProtocolException(xmlString + "Elemento [" + entryName + "] contiene una struttura xml (accordo-servizio-parte-specifica) non valida rispetto allo schema (RegistroServizi): " + eDeserializer.getMessage(), eDeserializer);
            }
        } else {
            ArchiveAccordoServizioParteSpecifica archiveASPS = null;
            AccordoServizioParteSpecifica as = null;
            if (!nomeFileSenzaAccordo.startsWith("fruitori" + File.separatorChar)) {
                if (!archivio.getAccordiServizioParteSpecifica().containsKey(key)) {
                    throw new ProtocolException("Elemento [" + entryName + "] non atteso. Non e' possibile fornire dei documenti di un accordo senza fornire la definizione xml dell'accordo");
                }
                archiveASPS = (ArchiveAccordoServizioParteSpecifica)archivio.getAccordiServizioParteSpecifica().get(key);
                as = archiveASPS.getAccordoServizioParteSpecifica();
            }
            if (nomeFileSenzaAccordo.startsWith("mapping" + File.separatorChar) && nomeFileSenzaAccordo.endsWith("mappingErogazionePA.id")) {
                this.readAccordoServizioParteSpecifica_PortaApplicativaAssociata(archiveASPS, bin, xml, entryName);
            } else if (nomeFileSenzaAccordo.startsWith("wsdl" + File.separatorChar)) {
                if (nomeFileSenzaAccordo.equalsIgnoreCase("wsdl" + File.separatorChar + "InterfacciaImplementativaErogatore.wsdl")) {
                    as.setByteWsdlImplementativoErogatore(xml);
                } else if (nomeFileSenzaAccordo.equalsIgnoreCase("wsdl" + File.separatorChar + "InterfacciaImplementativaFruitore.wsdl")) {
                    as.setByteWsdlImplementativoFruitore(xml);
                }
            } else if (nomeFileSenzaAccordo.startsWith("allegati" + File.separatorChar)) {
                this.processDocument(nomeFileSenzaAccordo, "allegati", archiveVersion, entryName, xml, tipoSoggetto, nomeSoggetto, nomeAccordo, versioneAccordo, mapKeyDocumenti, as.getAllegatoList());
            } else if (nomeFileSenzaAccordo.startsWith("specificheSemiformali" + File.separatorChar)) {
                this.processDocument(nomeFileSenzaAccordo, "specificheSemiformali", archiveVersion, entryName, xml, tipoSoggetto, nomeSoggetto, nomeAccordo, versioneAccordo, mapKeyDocumenti, as.getSpecificaSemiformaleList());
            } else if (nomeFileSenzaAccordo.startsWith("specificheLivelliServizio" + File.separatorChar)) {
                this.processDocument(nomeFileSenzaAccordo, "specificheLivelliServizio", archiveVersion, entryName, xml, tipoSoggetto, nomeSoggetto, nomeAccordo, versioneAccordo, mapKeyDocumenti, as.getSpecificaLivelloServizioList());
            } else if (nomeFileSenzaAccordo.startsWith("specificheSicurezza" + File.separatorChar)) {
                this.processDocument(nomeFileSenzaAccordo, "specificheSicurezza", archiveVersion, entryName, xml, tipoSoggetto, nomeSoggetto, nomeAccordo, versioneAccordo, mapKeyDocumenti, as.getSpecificaSicurezzaList());
            } else if (!nomeFileSenzaAccordo.startsWith("fruitori" + File.separatorChar) || !nomeFileSenzaAccordo.endsWith("serviziApplicativiAutorizzati.csv")) {
                if (nomeFileSenzaAccordo.startsWith("fruitori" + File.separatorChar) && nomeFileSenzaAccordo.endsWith("mappingFruizionePD.id")) {
                    this.readAccordoServizioParteSpecifica_Fruitore_PortaDelegataAssociata(archivio, bin, xml, entryName, nomeFileSenzaAccordo, tipoSoggetto, nomeSoggetto, nomeAccordo, versioneAccordo, validationDocuments, idCorrelazione);
                } else if (nomeFileSenzaAccordo.startsWith("fruitori" + File.separatorChar)) {
                    this.readAccordoServizioParteSpecifica_Fruitore(archivio, bin, xml, entryName, tipoSoggetto, nomeSoggetto, nomeAccordo, versioneAccordo, validationDocuments, idCorrelazione);
                }
            }
        }
    }

    public void readAccordoServizioParteSpecifica_PortaApplicativaAssociata(ArchiveAccordoServizioParteSpecifica archiveASPS, InputStream bin, byte[] xml, String entryName) throws ProtocolException {
        try {
            if (archiveASPS == null) {
                throw new ProtocolException("Elemento [" + entryName + "] non atteso. Non e' possibile fornire il mapping con la PA senza fornire la definizione xml dell'accordo di servizio parte specifica");
            }
            String csvLine = new String(xml);
            String[] line = csvLine.split(" ");
            if (line == null || line.length <= 0) {
                throw new Exception("csv non contiene valori");
            }
            if (line.length != 3) {
                throw new Exception("csv wrong format (size:" + line.length + ")");
            }
            IDPortaApplicativaByNome idPA = new IDPortaApplicativaByNome();
            idPA.setNome(line[0].trim());
            idPA.setSoggetto(new IDSoggetto(line[1].trim(), line[2].trim()));
            archiveASPS.setIdPortaApplicativaAssociata(idPA);
        }
        catch (Exception eDeserializer) {
            String xmlString = this.toStringXmlElementForErrorMessage(xml);
            throw new ProtocolException(xmlString + "Elemento [" + entryName + "] contiene una struttura csv (mapping asps-pa) non valida: " + eDeserializer.getMessage(), eDeserializer);
        }
    }

    public void readAccordoServizioParteSpecifica_Fruitore(Archive archivio, InputStream bin, byte[] xml, String entryName, String tipoSoggetto, String nomeSoggetto, String nomeAccordo, String versioneAccordo, boolean validationDocuments, ArchiveIdCorrelazione idCorrelazione) throws ProtocolException {
        String tipoSoggettoKey = tipoSoggetto != null ? tipoSoggetto : "";
        String nomeSoggettoKey = nomeSoggetto != null ? nomeSoggetto : "";
        String versioneKey = versioneAccordo != null ? versioneAccordo : "";
        try {
            if (validationDocuments) {
                it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.utils.XSDValidator.getXSDValidator(this.log).valida(bin);
            }
            if (USE_VERSION_XML_BEAN.equals(versioneAccordo)) {
                String keyAccordo = ArchiveAccordoServizioParteSpecifica.buildKey(tipoSoggettoKey, nomeSoggettoKey, nomeAccordo, versioneKey);
                versioneAccordo = versioneKey = ((ArchiveAccordoServizioParteSpecifica)archivio.getAccordiServizioParteSpecifica().get(keyAccordo)).getAccordoServizioParteSpecifica().getVersione();
            }
            Fruitore fruitore = this.jibxRegistryDeserializer.readFruitore(xml);
            String keyFruitore = ArchiveFruitore.buildKey(fruitore.getTipo(), fruitore.getNome(), tipoSoggettoKey, nomeSoggettoKey, nomeAccordo, versioneKey);
            if (archivio.getAccordiFruitori().containsKey(keyFruitore)) {
                throw new ProtocolException("Elemento [" + entryName + "] errato. Risulta esistere piu' di un fruitore con key [" + keyFruitore + "]");
            }
            IDAccordo idAccordo = IDAccordoFactory.getInstance().getIDAccordoFromValuesWithoutCheck(nomeAccordo, tipoSoggetto, nomeSoggetto, versioneAccordo);
            archivio.getAccordiFruitori().add(keyFruitore, new ArchiveFruitore(idAccordo, fruitore, idCorrelazione, true));
        }
        catch (Exception eDeserializer) {
            String xmlString = this.toStringXmlElementForErrorMessage(xml);
            throw new ProtocolException(xmlString + "Elemento [" + entryName + "] contiene una struttura xml (fruitore) non valida rispetto allo schema (RegistroServizi): " + eDeserializer.getMessage(), eDeserializer);
        }
    }

    public void readAccordoServizioParteSpecifica_Fruitore_PortaDelegataAssociata(Archive archivio, InputStream bin, byte[] xml, String entryName, String nomeFileSenzaAccordo, String tipoSoggetto, String nomeSoggetto, String nomeAccordo, String versioneAccordo, boolean validationDocuments, ArchiveIdCorrelazione idCorrelazione) throws ProtocolException {
        String prefixError = "Elemento [" + entryName + "] errato. Dopo la directory [fruitori] il file [mappingFruizionePD.id] deve essere contenuto in una directory definita tramite la struttura <tipo>_<nome> che descrive il soggetto fruitore.";
        String tipoNomeSoggettoFruitore = nomeFileSenzaAccordo.substring(("fruitori" + File.separatorChar).length(), nomeFileSenzaAccordo.length() - (File.separatorChar + "mappingFruizionePD.id").length());
        if (tipoNomeSoggettoFruitore == null || "".equals(tipoNomeSoggettoFruitore) || !tipoNomeSoggettoFruitore.contains("_")) {
            throw new ProtocolException(prefixError + " Il nome utilizzato per la directory non e' conforme alla struttura attesa <tipo>_<nome>");
        }
        tipoNomeSoggettoFruitore = tipoNomeSoggettoFruitore.trim();
        String tipoSoggettoFruitore = null;
        String nomeSoggettoFruitore = null;
        if (!tipoNomeSoggettoFruitore.equals("_")) {
            if (tipoNomeSoggettoFruitore.startsWith("_")) {
                nomeSoggettoFruitore = tipoNomeSoggettoFruitore.substring(1);
            } else if (tipoNomeSoggettoFruitore.endsWith("_")) {
                tipoSoggettoFruitore = tipoNomeSoggettoFruitore.substring(0, tipoNomeSoggettoFruitore.length() - 1);
            } else {
                tipoSoggettoFruitore = tipoNomeSoggettoFruitore.split("_")[0];
                nomeSoggettoFruitore = tipoNomeSoggettoFruitore.split("_")[1];
                if (tipoSoggettoFruitore == null || "".equals(tipoSoggettoFruitore)) {
                    throw new ProtocolException(prefixError + " Il nome utilizzato per la directory non e' conforme alla struttura attesa <tipo>_<nome>: tipo non identificato");
                }
                if (nomeSoggettoFruitore == null || "".equals(nomeSoggettoFruitore)) {
                    throw new ProtocolException(prefixError + " Il nome utilizzato per la directory non e' conforme alla struttura attesa <tipo>_<nome>: nome non identificato");
                }
            }
        }
        String tipoSoggettoFruitoreKey = tipoSoggettoFruitore != null ? tipoSoggettoFruitore : "";
        String nomeSoggettoFruitoreKey = nomeSoggettoFruitore != null ? nomeSoggettoFruitore : "";
        String tipoSoggettoKey = tipoSoggetto != null ? tipoSoggetto : "";
        String nomeSoggettoKey = nomeSoggetto != null ? nomeSoggetto : "";
        String versioneKey = versioneAccordo != null ? versioneAccordo : "";
        try {
            String csvLine = new String(xml);
            String[] line = csvLine.split(" ");
            if (line == null || line.length <= 0) {
                throw new Exception("csv non contiene valori");
            }
            if (line.length != 3) {
                throw new Exception("csv wrong format (size:" + line.length + ")");
            }
            String keyFruitore = ArchiveFruitore.buildKey(tipoSoggettoFruitoreKey, nomeSoggettoFruitoreKey, tipoSoggettoKey, nomeSoggettoKey, nomeAccordo, versioneKey);
            if (!archivio.getAccordiFruitori().containsKey(keyFruitore)) {
                throw new ProtocolException("Elemento [" + entryName + "] non atteso. Non e' possibile fornire un mapping con la porta delegata senza fornire la definizione xml della fruizione");
            }
            ArchiveFruitore archiveFruitore = (ArchiveFruitore)archivio.getAccordiFruitori().get(keyFruitore);
            IDPortaDelegata idPD = new IDPortaDelegata();
            idPD.setLocationPD(line[0].trim());
            idPD.setSoggettoFruitore(new IDSoggetto(line[1].trim(), line[2].trim()));
            archiveFruitore.setIdPortaDelegataAssociata(idPD);
        }
        catch (Exception eDeserializer) {
            String xmlString = this.toStringXmlElementForErrorMessage(xml);
            throw new ProtocolException(xmlString + "Elemento [" + entryName + "] contiene una struttura csv (mapping fruizione-pd) non valida: " + eDeserializer.getMessage(), eDeserializer);
        }
    }

    public void readAccordoCooperazione(Archive archivio, InputStream bin, byte[] xml, String entryName, String tipoSoggetto, String nomeSoggetto, String nomeFileSenzaAccordo, String nomeAccordo, String versioneAccordo, boolean validationDocuments, ArchiveIdCorrelazione idCorrelazione, ArchiveVersion archiveVersion, Hashtable<String, IdentificativoDocumento> mapKeyDocumenti) throws ProtocolException {
        String tipoSoggettoKey = tipoSoggetto != null ? tipoSoggetto : "";
        String nomeSoggettoKey = nomeSoggetto != null ? nomeSoggetto : "";
        String versioneKey = versioneAccordo != null ? versioneAccordo : "";
        String key = ArchiveAccordoCooperazione.buildKey(tipoSoggettoKey, nomeSoggettoKey, nomeAccordo, versioneKey);
        if (!nomeFileSenzaAccordo.contains("" + File.separatorChar)) {
            try {
                AccordoCooperazione ac;
                if (validationDocuments) {
                    it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.utils.XSDValidator.getXSDValidator(this.log).valida(bin);
                }
                if ((ac = this.jibxRegistryDeserializer.readAccordoCooperazione(xml)).getSoggettoReferente() == null) {
                    ac.setSoggettoReferente(new IdSoggetto());
                }
                if (tipoSoggetto != null && ac.getSoggettoReferente().getTipo() != null && !ac.getSoggettoReferente().getTipo().equals(tipoSoggetto)) {
                    throw new ProtocolException("Elemento [" + entryName + "] errato. La definizione xml dell'accordo (RegistroServizi) contiene un soggetto referente con tipo [" + ac.getSoggettoReferente().getTipo() + "] differente da quello indicato [" + tipoSoggetto + "] nella directory che contiene la definizione");
                }
                if (nomeSoggetto != null && ac.getSoggettoReferente().getNome() != null && !ac.getSoggettoReferente().getNome().equals(nomeSoggetto)) {
                    throw new ProtocolException("Elemento [" + entryName + "] errato. La definizione xml dell'accordo (RegistroServizi) contiene un soggetto referente con nome [" + ac.getSoggettoReferente().getNome() + "] differente da quello indicato [" + nomeSoggetto + "] nella directory che contiene la definizione");
                }
                ac.getSoggettoReferente().setTipo(tipoSoggetto);
                ac.getSoggettoReferente().setNome(nomeSoggetto);
                if (ArchiveVersion.V_UNDEFINED.equals((Object)archiveVersion)) {
                    String convertName = this.oldMethod_convertCharNonPermessiQualsiasiSistemaOperativo(ac.getNome(), false);
                    if (!convertName.equals(nomeAccordo)) {
                        throw new ProtocolException("Elemento [" + entryName + "] errato. La definizione xml dell'accordo (RegistroServizi) contiene un nome [" + ac.getNome() + "] (fileSystemName:" + convertName + ") differente da quello indicato [" + nomeAccordo + "] nella directory che contiene la definizione");
                    }
                    if (!USE_VERSION_XML_BEAN.equals(versioneAccordo)) {
                        if (versioneAccordo != null && ac.getVersione() != null && !"".equals(ac.getVersione())) {
                            String convertVersion = this.oldMethod_convertCharNonPermessiQualsiasiSistemaOperativo(ac.getVersione(), false);
                            if (ac.getVersione() != null && !convertVersion.equals(versioneAccordo)) {
                                throw new ProtocolException("Elemento [" + entryName + "] errato. La definizione xml dell'accordo (RegistroServizi) contiene una versione [" + ac.getVersione() + "] (fileSystemName:" + convertVersion + ") differente da quella indicato [" + versioneAccordo + "] nella directory che contiene la definizione");
                            }
                        }
                        ac.setVersione(versioneAccordo);
                    }
                } else {
                    if (!ac.getNome().equals(nomeAccordo)) {
                        throw new ProtocolException("Elemento [" + entryName + "] errato. La definizione xml dell'accordo (RegistroServizi) contiene un nome [" + ac.getNome() + "] differente da quello indicato [" + nomeAccordo + "] nel file [accordo.id]");
                    }
                    if (!USE_VERSION_XML_BEAN.equals(versioneAccordo)) {
                        if (versioneAccordo != null && ac.getVersione() != null && !"".equals(ac.getVersione()) && !ac.getVersione().equals(versioneAccordo)) {
                            throw new ProtocolException("Elemento [" + entryName + "] errato. La definizione xml dell'accordo (RegistroServizi) contiene una versione [" + ac.getVersione() + "] differente da quella indicata [" + versioneAccordo + "] nel file [accordo.id]");
                        }
                        ac.setVersione(versioneAccordo);
                    }
                }
                if (archivio.getAccordiCooperazione().containsKey(key)) {
                    throw new ProtocolException("Elemento [" + entryName + "] errato. Risulta esistere piu' di un accordo con key [" + key + "]");
                }
                archivio.getAccordiCooperazione().add(key, new ArchiveAccordoCooperazione(ac, idCorrelazione, true));
            }
            catch (Exception eDeserializer) {
                String xmlString = this.toStringXmlElementForErrorMessage(xml);
                throw new ProtocolException(xmlString + "Elemento [" + entryName + "] contiene una struttura xml (accordo-cooperazione) non valida rispetto allo schema (RegistroServizi): " + eDeserializer.getMessage(), eDeserializer);
            }
        } else {
            AccordoCooperazione ac = null;
            if (!archivio.getAccordiCooperazione().containsKey(key)) {
                throw new ProtocolException("Elemento [" + entryName + "] non atteso. Non e' possibile fornire dei documenti di un accordo senza fornire la definizione xml dell'accordo");
            }
            ac = ((ArchiveAccordoCooperazione)archivio.getAccordiCooperazione().get(key)).getAccordoCooperazione();
            if (nomeFileSenzaAccordo.startsWith("allegati" + File.separatorChar)) {
                this.processDocument(nomeFileSenzaAccordo, "allegati", archiveVersion, entryName, xml, tipoSoggetto, nomeSoggetto, nomeAccordo, versioneAccordo, mapKeyDocumenti, ac.getAllegatoList());
            } else if (nomeFileSenzaAccordo.startsWith("specificheSemiformali" + File.separatorChar)) {
                this.processDocument(nomeFileSenzaAccordo, "specificheSemiformali", archiveVersion, entryName, xml, tipoSoggetto, nomeSoggetto, nomeAccordo, versioneAccordo, mapKeyDocumenti, ac.getSpecificaSemiformaleList());
            }
        }
    }

    private void processDocument(String nomeFileSenzaAccordo, String tipoDir, ArchiveVersion archiveVersion, String entryName, byte[] xml, String tipoSoggetto, String nomeSoggetto, String nomeAccordo, String versioneAccordo, Hashtable<String, IdentificativoDocumento> mapKeyDocumenti, List<Documento> documenti) throws ProtocolException {
        String nomeDocumento = nomeFileSenzaAccordo.substring((tipoDir + File.separatorChar).length());
        if (ArchiveVersion.V_UNDEFINED.equals((Object)archiveVersion)) {
            this.getDocument(documenti, nomeDocumento, null, entryName, archiveVersion).setByteContenuto(xml);
        } else {
            String nomeDocumentoSenzaEstensione = nomeDocumento;
            if (!nomeDocumento.contains(".")) {
                throw new ProtocolException("Elemento [" + entryName + "] errato. Per i documenti \u00e8 attesa una estensione");
            }
            nomeDocumentoSenzaEstensione = nomeDocumento.substring(0, nomeDocumento.lastIndexOf("."));
            String keyDocumento = this.getKeyDocumento(tipoSoggetto, nomeSoggetto, nomeAccordo, versioneAccordo, entryName, nomeDocumentoSenzaEstensione);
            if (nomeFileSenzaAccordo.endsWith(".id")) {
                String tmp = new String(xml);
                IdentificativoDocumento identificativoDocumento = new IdentificativoDocumento();
                identificativoDocumento.tipo = tmp.split("###")[0];
                identificativoDocumento.nome = tmp.substring(identificativoDocumento.tipo.length() + "###".length());
                mapKeyDocumenti.put(keyDocumento, identificativoDocumento);
            } else if (nomeFileSenzaAccordo.endsWith(".raw")) {
                IdentificativoDocumento identificativoDocumento = mapKeyDocumenti.get(keyDocumento);
                if (identificativoDocumento == null) {
                    throw new ProtocolException("Elemento [" + entryName + "] errato. Non \u00e8 stato rilevato precedentemente il corrispettivo file contenente l'identificativo (con estensione '.id')");
                }
                this.getDocument(documenti, identificativoDocumento.nome, identificativoDocumento.tipo, entryName, archiveVersion).setByteContenuto(xml);
            } else {
                throw new ProtocolException("Elemento [" + entryName + "] non atteso.");
            }
        }
    }

    private Documento getDocument(List<Documento> documenti, String nome, String tipo, String entryName, ArchiveVersion archiveVersion) throws ProtocolException {
        ArrayList<Character> permitPoint = new ArrayList<Character>();
        permitPoint.add(Character.valueOf('.'));
        for (Documento documento : documenti) {
            String fileName = documento.getFile();
            if (ArchiveVersion.V_UNDEFINED.equals((Object)archiveVersion)) {
                fileName = this.oldMethod_convertCharNonPermessiQualsiasiSistemaOperativo(fileName, true, permitPoint);
            }
            if (!nome.equals(fileName)) continue;
            if (ArchiveVersion.V_UNDEFINED.equals((Object)archiveVersion)) {
                return documento;
            }
            if (!tipo.equals(documento.getTipo())) continue;
            return documento;
        }
        throw new ProtocolException("Elemento [" + entryName + "] non atteso. Non e' possibile fornire un documento di un accordo senza definirlo anche all'interno della definizione xml dell'accordo");
    }

    protected String toStringXmlElementForErrorMessage(byte[] xml) {
        return xml != null ? "Xml: [" + new String(xml) + "] \n" : "Xml Undefined. \n";
    }
}

