/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.basic.archive;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDAccordo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDAccordoCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDPortaApplicativaByNome;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDPortaDelegata;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDServizioApplicativo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.IProtocolFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.ProtocolException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchiveAccordoCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchiveAccordoServizioComposto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchiveAccordoServizioParteComune;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchiveAccordoServizioParteSpecifica;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchiveEsitoImport;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchiveEsitoImportDetail;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchiveEsitoImportDetailConfigurazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchiveFruitore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchiveIdCorrelazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchivePdd;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchivePortaApplicativa;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchivePortaDelegata;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchiveRuolo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchiveServizioApplicativo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchiveSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.IDAccordoCooperazioneFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.IDAccordoFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;

public class EsitoUtils {
    protected IProtocolFactory protocolFactory = null;
    protected IDAccordoCooperazioneFactory idAccordoCooperazioneFactory;
    protected IDAccordoFactory idAccordoFactory;

    public EsitoUtils(IProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
        this.idAccordoCooperazioneFactory = IDAccordoCooperazioneFactory.getInstance();
        this.idAccordoFactory = IDAccordoFactory.getInstance();
    }

    public String toString(ArchiveEsitoImport archive, boolean readIdCorrelazione, boolean importOperation) throws ProtocolException {
        String idCorrelazione;
        if (!readIdCorrelazione) {
            return this._toString(archive, importOperation);
        }
        Hashtable<String, ArchiveEsitoImport> map = new Hashtable<String, ArchiveEsitoImport>();
        Hashtable<String, ArchiveIdCorrelazione> mapIdCorrelazione = new Hashtable<String, ArchiveIdCorrelazione>();
        this.readIdCorrelazione(map, mapIdCorrelazione, archive);
        if (map.size() < 1) {
            return "";
        }
        if (map.size() == 1 && "@PackageOpenSPCoop@".equals(idCorrelazione = map.keys().nextElement())) {
            return this._toString(archive, importOperation);
        }
        StringBuffer bfEsito = new StringBuffer();
        ArchiveEsitoImport defaultArchiveEsitoImport = null;
        ArchiveIdCorrelazione defaultArchiveIdCorrelazione = null;
        Enumeration<String> correlazioni = map.keys();
        ArrayList<Object> idCorrelazioneOrdinato = new ArrayList<Object>();
        while (correlazioni.hasMoreElements()) {
            String idCorrelazione2 = correlazioni.nextElement();
            idCorrelazioneOrdinato.add(idCorrelazione2);
        }
        Collections.sort(idCorrelazioneOrdinato);
        for (String string : idCorrelazioneOrdinato) {
            ArchiveIdCorrelazione archiveIdCorrelazione = mapIdCorrelazione.get(string);
            ArchiveEsitoImport archiveCorrelazione = map.get(string);
            if ("@PackageOpenSPCoop@".equals(string)) {
                defaultArchiveEsitoImport = archiveCorrelazione;
                defaultArchiveIdCorrelazione = archiveIdCorrelazione;
                continue;
            }
            this.append(bfEsito, archiveIdCorrelazione, archiveCorrelazione, importOperation);
        }
        if (defaultArchiveEsitoImport != null) {
            ArchiveIdCorrelazione i = new ArchiveIdCorrelazione(defaultArchiveIdCorrelazione.getId());
            i.setDescrizione("       Altro      ");
            this.append(bfEsito, i, defaultArchiveEsitoImport, importOperation);
        }
        return bfEsito.toString();
    }

    private void append(StringBuffer bfEsito, ArchiveIdCorrelazione archiveIdCorrelazione, ArchiveEsitoImport archiveCorrelazione, boolean importOperation) {
        int i;
        String descrizione = archiveIdCorrelazione.getDescrizione();
        if (descrizione == null) {
            descrizione = archiveIdCorrelazione.getId();
        }
        for (i = 0; i < descrizione.length(); ++i) {
            bfEsito.append("=");
        }
        bfEsito.append("\n");
        bfEsito.append(descrizione);
        bfEsito.append("\n");
        for (i = 0; i < descrizione.length(); ++i) {
            bfEsito.append("=");
        }
        bfEsito.append("\n");
        bfEsito.append("\n");
        bfEsito.append(this._toString(archiveCorrelazione, importOperation));
        bfEsito.append("\n\n");
    }

    private String _toString(ArchiveEsitoImport archive, boolean importOperation) {
        ArchiveEsitoImportDetail archiveAccordoServizioParteSpecifica;
        IDAccordo idAccordo;
        String uriAccordo;
        int i;
        StringBuffer bfEsito = new StringBuffer();
        if (archive.getPdd().size() > 0) {
            bfEsito.append("PorteDominio (").append(archive.getPdd().size()).append(")\n");
        }
        for (i = 0; i < archive.getPdd().size(); ++i) {
            try {
                ArchiveEsitoImportDetail archivePdd = (ArchiveEsitoImportDetail)archive.getPdd().get(i);
                String nomePdd = ((ArchivePdd)archivePdd.getArchiveObject()).getNomePdd();
                bfEsito.append("\t- [").append(nomePdd).append("] ");
                this.serializeStato(archivePdd, bfEsito, importOperation);
            }
            catch (Throwable e) {
                bfEsito.append("\t- [").append(i + 1).append("] non importato: ").append(e.getMessage());
            }
            bfEsito.append("\n");
        }
        if (archive.getPdd().size() > 0) {
            bfEsito.append("\n");
        }
        if (archive.getRuoli().size() > 0) {
            bfEsito.append("Ruoli (").append(archive.getRuoli().size()).append(")\n");
        }
        for (i = 0; i < archive.getRuoli().size(); ++i) {
            try {
                ArchiveEsitoImportDetail archiveRuolo = (ArchiveEsitoImportDetail)archive.getRuoli().get(i);
                String nomeRuolo = ((ArchiveRuolo)archiveRuolo.getArchiveObject()).getIdRuolo().getNome();
                bfEsito.append("\t- [").append(nomeRuolo).append("] ");
                this.serializeStato(archiveRuolo, bfEsito, importOperation);
            }
            catch (Throwable e) {
                bfEsito.append("\t- [").append(i + 1).append("] non importato: ").append(e.getMessage());
            }
            bfEsito.append("\n");
        }
        if (archive.getRuoli().size() > 0) {
            bfEsito.append("\n");
        }
        if (archive.getSoggetti().size() > 0) {
            bfEsito.append("Soggetti (").append(archive.getSoggetti().size()).append(")\n");
        }
        for (i = 0; i < archive.getSoggetti().size(); ++i) {
            try {
                ArchiveEsitoImportDetail archiveSoggetto = (ArchiveEsitoImportDetail)archive.getSoggetti().get(i);
                IDSoggetto idSoggetto = ((ArchiveSoggetto)archiveSoggetto.getArchiveObject()).getIdSoggetto();
                bfEsito.append("\t- [").append(idSoggetto.toString()).append("] ");
                this.serializeStato(archiveSoggetto, bfEsito, importOperation);
            }
            catch (Exception e) {
                bfEsito.append("\t- [").append(i + 1).append("] non importato: ").append(e.getMessage());
            }
            bfEsito.append("\n");
        }
        if (archive.getSoggetti().size() > 0) {
            bfEsito.append("\n");
        }
        if (archive.getServiziApplicativi().size() > 0) {
            bfEsito.append("ServiziApplicativi (").append(archive.getServiziApplicativi().size()).append(")\n");
        }
        for (i = 0; i < archive.getServiziApplicativi().size(); ++i) {
            try {
                ArchiveEsitoImportDetail archiveServizioApplicativo = (ArchiveEsitoImportDetail)archive.getServiziApplicativi().get(i);
                IDServizioApplicativo idServizioApplicativo = ((ArchiveServizioApplicativo)archiveServizioApplicativo.getArchiveObject()).getIdServizioApplicativo();
                bfEsito.append("\t- [").append(idServizioApplicativo.getIdSoggettoProprietario().toString()).append("_").append(idServizioApplicativo.getNome()).append("] ");
                this.serializeStato(archiveServizioApplicativo, bfEsito, importOperation);
            }
            catch (Exception e) {
                bfEsito.append("\t- [").append(i + 1).append("] non importato: ").append(e.getMessage());
            }
            bfEsito.append("\n");
        }
        if (archive.getServiziApplicativi().size() > 0) {
            bfEsito.append("\n");
        }
        if (archive.getAccordiCooperazione().size() > 0) {
            bfEsito.append("Accordi di Cooperazione (").append(archive.getAccordiCooperazione().size()).append(")\n");
        }
        for (i = 0; i < archive.getAccordiCooperazione().size(); ++i) {
            try {
                ArchiveEsitoImportDetail archiveAccordoCooperazione = (ArchiveEsitoImportDetail)archive.getAccordiCooperazione().get(i);
                IDAccordoCooperazione idAccordoCooperazione = ((ArchiveAccordoCooperazione)archiveAccordoCooperazione.getArchiveObject()).getIdAccordoCooperazione();
                uriAccordo = this.idAccordoCooperazioneFactory.getUriFromIDAccordo(idAccordoCooperazione);
                bfEsito.append("\t- [").append(uriAccordo).append("] ");
                this.serializeStato(archiveAccordoCooperazione, bfEsito, importOperation);
            }
            catch (Exception e) {
                bfEsito.append("\t- [").append(i + 1).append("] non importato: ").append(e.getMessage());
            }
            bfEsito.append("\n");
        }
        if (archive.getAccordiCooperazione().size() > 0) {
            bfEsito.append("\n");
        }
        if (archive.getAccordiServizioParteComune().size() > 0) {
            bfEsito.append("Accordi di Servizio Parte Comune (").append(archive.getAccordiServizioParteComune().size()).append(")\n");
        }
        for (i = 0; i < archive.getAccordiServizioParteComune().size(); ++i) {
            try {
                ArchiveEsitoImportDetail archiveAccordoServizioParteComune = (ArchiveEsitoImportDetail)archive.getAccordiServizioParteComune().get(i);
                idAccordo = ((ArchiveAccordoServizioParteComune)archiveAccordoServizioParteComune.getArchiveObject()).getIdAccordoServizioParteComune();
                uriAccordo = this.idAccordoFactory.getUriFromIDAccordo(idAccordo);
                bfEsito.append("\t- [").append(uriAccordo).append("] ");
                this.serializeStato(archiveAccordoServizioParteComune, bfEsito, importOperation);
            }
            catch (Exception e) {
                bfEsito.append("\t- [").append(i + 1).append("] non importato: ").append(e.getMessage());
            }
            bfEsito.append("\n");
        }
        if (archive.getAccordiServizioParteComune().size() > 0) {
            bfEsito.append("\n");
        }
        if (archive.getAccordiServizioParteSpecifica().size() > 0) {
            bfEsito.append("Accordi di Servizio Parte Specifica (").append(archive.getAccordiServizioParteSpecifica().size()).append(")\n");
        }
        for (i = 0; i < archive.getAccordiServizioParteSpecifica().size(); ++i) {
            try {
                archiveAccordoServizioParteSpecifica = (ArchiveEsitoImportDetail)archive.getAccordiServizioParteSpecifica().get(i);
                idAccordo = ((ArchiveAccordoServizioParteSpecifica)archiveAccordoServizioParteSpecifica.getArchiveObject()).getIdAccordoServizioParteSpecifica();
                uriAccordo = this.idAccordoFactory.getUriFromIDAccordo(idAccordo);
                bfEsito.append("\t- [").append(uriAccordo).append("] ");
                this.serializeStato(archiveAccordoServizioParteSpecifica, bfEsito, importOperation);
            }
            catch (Exception e) {
                bfEsito.append("\t- [").append(i + 1).append("] non importato: ").append(e.getMessage());
            }
            bfEsito.append("\n");
        }
        if (archive.getAccordiServizioParteSpecifica().size() > 0) {
            bfEsito.append("\n");
        }
        if (archive.getAccordiServizioComposto().size() > 0) {
            bfEsito.append("Accordi di Servizio Composto (").append(archive.getAccordiServizioComposto().size()).append(")\n");
        }
        for (i = 0; i < archive.getAccordiServizioComposto().size(); ++i) {
            try {
                ArchiveEsitoImportDetail archiveAccordoServizioComposto = (ArchiveEsitoImportDetail)archive.getAccordiServizioComposto().get(i);
                idAccordo = ((ArchiveAccordoServizioComposto)archiveAccordoServizioComposto.getArchiveObject()).getIdAccordoServizioParteComune();
                uriAccordo = this.idAccordoFactory.getUriFromIDAccordo(idAccordo);
                bfEsito.append("\t- [").append(uriAccordo).append("] ");
                this.serializeStato(archiveAccordoServizioComposto, bfEsito, importOperation);
            }
            catch (Exception e) {
                bfEsito.append("\t- [").append(i + 1).append("] non importato: ").append(e.getMessage());
            }
            bfEsito.append("\n");
        }
        if (archive.getAccordiServizioComposto().size() > 0) {
            bfEsito.append("\n");
        }
        if (archive.getAccordiServizioParteSpecificaServiziComposti().size() > 0) {
            bfEsito.append("Accordi di Servizio Parte Specifica (").append(archive.getAccordiServizioParteSpecificaServiziComposti().size()).append(") [accordi di servizio composto]\n");
        }
        for (i = 0; i < archive.getAccordiServizioParteSpecificaServiziComposti().size(); ++i) {
            try {
                archiveAccordoServizioParteSpecifica = (ArchiveEsitoImportDetail)archive.getAccordiServizioParteSpecificaServiziComposti().get(i);
                idAccordo = ((ArchiveAccordoServizioParteSpecifica)archiveAccordoServizioParteSpecifica.getArchiveObject()).getIdAccordoServizioParteSpecifica();
                uriAccordo = this.idAccordoFactory.getUriFromIDAccordo(idAccordo);
                bfEsito.append("\t- [").append(uriAccordo).append("] ");
                this.serializeStato(archiveAccordoServizioParteSpecifica, bfEsito, importOperation);
            }
            catch (Exception e) {
                bfEsito.append("\t- [").append(i + 1).append("] non importato: ").append(e.getMessage());
            }
            bfEsito.append("\n");
        }
        if (archive.getAccordiServizioParteSpecificaServiziComposti().size() > 0) {
            bfEsito.append("\n");
        }
        if (archive.getAccordiFruitori().size() > 0) {
            bfEsito.append("Fruitori (").append(archive.getAccordiFruitori().size()).append(")\n");
        }
        for (i = 0; i < archive.getAccordiFruitori().size(); ++i) {
            try {
                ArchiveEsitoImportDetail archiveFruitore = (ArchiveEsitoImportDetail)archive.getAccordiFruitori().get(i);
                idAccordo = ((ArchiveFruitore)archiveFruitore.getArchiveObject()).getIdAccordoServizioParteSpecifica();
                uriAccordo = this.idAccordoFactory.getUriFromIDAccordo(idAccordo);
                IDSoggetto idFruitore = ((ArchiveFruitore)archiveFruitore.getArchiveObject()).getIdSoggettoFruitore();
                bfEsito.append("\t- [" + idFruitore + "] -> [").append(uriAccordo).append("] ");
                this.serializeStato(archiveFruitore, bfEsito, importOperation);
            }
            catch (Exception e) {
                bfEsito.append("\t- [").append(i + 1).append("] non importato: ").append(e.getMessage());
            }
            bfEsito.append("\n");
        }
        if (archive.getAccordiFruitori().size() > 0) {
            bfEsito.append("\n");
        }
        if (archive.getPorteDelegate().size() > 0) {
            bfEsito.append("PorteDelegate (").append(archive.getPorteDelegate().size()).append(")\n");
        }
        for (i = 0; i < archive.getPorteDelegate().size(); ++i) {
            try {
                ArchiveEsitoImportDetail archivePortaDelegata = (ArchiveEsitoImportDetail)archive.getPorteDelegate().get(i);
                IDPortaDelegata idPortaDelegata = ((ArchivePortaDelegata)archivePortaDelegata.getArchiveObject()).getIdPortaDelegata();
                IDSoggetto idProprietario = ((ArchivePortaDelegata)archivePortaDelegata.getArchiveObject()).getIdSoggettoProprietario();
                bfEsito.append("\t- [" + idProprietario + "][" + idPortaDelegata.getLocationPD() + "] ");
                this.serializeStato(archivePortaDelegata, bfEsito, importOperation);
            }
            catch (Exception e) {
                bfEsito.append("\t- [").append(i + 1).append("] non importato: ").append(e.getMessage());
            }
            bfEsito.append("\n");
        }
        if (archive.getPorteDelegate().size() > 0) {
            bfEsito.append("\n");
        }
        if (archive.getPorteApplicative().size() > 0) {
            bfEsito.append("PorteApplicative (").append(archive.getPorteApplicative().size()).append(")\n");
        }
        for (i = 0; i < archive.getPorteApplicative().size(); ++i) {
            try {
                ArchiveEsitoImportDetail archivePortaApplicativa = (ArchiveEsitoImportDetail)archive.getPorteApplicative().get(i);
                IDPortaApplicativaByNome idPortaApplicativa = ((ArchivePortaApplicativa)archivePortaApplicativa.getArchiveObject()).getIdPortaApplicativaByNome();
                bfEsito.append("\t- [" + idPortaApplicativa.getSoggetto() + "][" + idPortaApplicativa.getNome() + "] ");
                this.serializeStato(archivePortaApplicativa, bfEsito, importOperation);
            }
            catch (Exception e) {
                bfEsito.append("\t- [").append(i + 1).append("] non importato: ").append(e.getMessage());
            }
            bfEsito.append("\n");
        }
        if (archive.getPorteApplicative().size() > 0) {
            bfEsito.append("\n");
        }
        if (archive.getConfigurazionePdD() != null) {
            bfEsito.append("Configurazione\n");
            try {
                ArchiveEsitoImportDetailConfigurazione configurazione = archive.getConfigurazionePdD();
                bfEsito.append("\t- ");
                this.serializeStato(configurazione, bfEsito);
            }
            catch (Exception e) {
                bfEsito.append("\t- non importata: ").append(e.getMessage());
            }
            bfEsito.append("\n");
            bfEsito.append("\n");
        }
        return bfEsito.toString();
    }

    public void serializeStato(ArchiveEsitoImportDetail detail, StringBuffer bfEsito, boolean importOperation) {
        Object stateDetail = "";
        if (detail.getStateDetail() != null) {
            stateDetail = detail.getStateDetail();
        }
        switch (detail.getState()) {
            case UPDATE_NOT_PERMISSED: {
                bfEsito.append("non importato: gi\u00e0 presente (aggiornamento non abilitato)").append((String)stateDetail);
                break;
            }
            case ERROR: {
                if (detail.getStateDetail() != null) {
                    stateDetail = " [" + detail.getStateDetail() + "]";
                }
                if (importOperation) {
                    bfEsito.append("non importato" + (String)stateDetail + ": ").append(detail.getException().getMessage());
                    break;
                }
                bfEsito.append("non eliminato" + (String)stateDetail + ": ").append(detail.getException().getMessage());
                break;
            }
            case CREATED: {
                bfEsito.append("importato correttamente").append((String)stateDetail);
                break;
            }
            case UPDATED: {
                bfEsito.append("gi\u00e0 presente, aggiornato correttamente").append((String)stateDetail);
                break;
            }
            case DELETED_NOT_EXISTS: {
                bfEsito.append("non esistente").append((String)stateDetail);
                break;
            }
            case DELETED: {
                bfEsito.append("eliminato correttamente").append((String)stateDetail);
            }
        }
    }

    public void serializeStato(ArchiveEsitoImportDetailConfigurazione detail, StringBuffer bfEsito) {
        Object stateDetail = "";
        if (detail.getStateDetail() != null) {
            stateDetail = detail.getStateDetail();
        }
        switch (detail.getState()) {
            case UPDATE_NOT_PERMISSED: {
                break;
            }
            case ERROR: {
                if (detail.getStateDetail() != null) {
                    stateDetail = " [" + detail.getStateDetail() + "]";
                }
                bfEsito.append("non importata" + (String)stateDetail + ": ").append(detail.getException().getMessage());
                break;
            }
            case CREATED: {
                break;
            }
            case UPDATED: {
                bfEsito.append("aggiornata correttamente").append((String)stateDetail);
                break;
            }
            case DELETED_NOT_EXISTS: {
                break;
            }
            case DELETED: {
                bfEsito.append("eliminazione effettuata correttamente").append((String)stateDetail);
            }
        }
    }

    private ArchiveEsitoImport getArchiveEsitoImport(ArchiveIdCorrelazione idCorrelazioneParam, Hashtable<String, ArchiveEsitoImport> map, Hashtable<String, ArchiveIdCorrelazione> mapIdCorrelazione) {
        String idCorrelazione = idCorrelazioneParam.getId();
        if (idCorrelazione == null) {
            idCorrelazione = "@PackageOpenSPCoop@";
        }
        ArchiveEsitoImport tmp = null;
        if (map.containsKey(idCorrelazione)) {
            tmp = map.get(idCorrelazione);
        } else {
            tmp = new ArchiveEsitoImport();
            map.put(idCorrelazione, tmp);
            mapIdCorrelazione.put(idCorrelazione, idCorrelazioneParam);
        }
        return tmp;
    }

    public void readIdCorrelazione(Hashtable<String, ArchiveEsitoImport> map, Hashtable<String, ArchiveIdCorrelazione> mapIdCorrelazione, ArchiveEsitoImport archive) throws ProtocolException {
        ArchiveEsitoImportDetail archiveAccordoServizioParteSpecifica;
        ArchiveIdCorrelazione idCorrelazione;
        int i;
        for (i = 0; i < archive.getPdd().size(); ++i) {
            ArchiveEsitoImportDetail archivePdd = (ArchiveEsitoImportDetail)archive.getPdd().get(i);
            idCorrelazione = ((ArchivePdd)archivePdd.getArchiveObject()).getIdCorrelazione();
            this.getArchiveEsitoImport(idCorrelazione, map, mapIdCorrelazione).getPdd().add(archivePdd);
        }
        for (i = 0; i < archive.getRuoli().size(); ++i) {
            ArchiveEsitoImportDetail archiveRuolo = (ArchiveEsitoImportDetail)archive.getRuoli().get(i);
            idCorrelazione = ((ArchiveRuolo)archiveRuolo.getArchiveObject()).getIdCorrelazione();
            this.getArchiveEsitoImport(idCorrelazione, map, mapIdCorrelazione).getRuoli().add(archiveRuolo);
        }
        for (i = 0; i < archive.getSoggetti().size(); ++i) {
            ArchiveEsitoImportDetail archiveSoggetto = (ArchiveEsitoImportDetail)archive.getSoggetti().get(i);
            idCorrelazione = ((ArchiveSoggetto)archiveSoggetto.getArchiveObject()).getIdCorrelazione();
            this.getArchiveEsitoImport(idCorrelazione, map, mapIdCorrelazione).getSoggetti().add(archiveSoggetto);
        }
        for (i = 0; i < archive.getServiziApplicativi().size(); ++i) {
            ArchiveEsitoImportDetail archiveServizioApplicativo = (ArchiveEsitoImportDetail)archive.getServiziApplicativi().get(i);
            idCorrelazione = ((ArchiveServizioApplicativo)archiveServizioApplicativo.getArchiveObject()).getIdCorrelazione();
            this.getArchiveEsitoImport(idCorrelazione, map, mapIdCorrelazione).getServiziApplicativi().add(archiveServizioApplicativo);
        }
        for (i = 0; i < archive.getAccordiCooperazione().size(); ++i) {
            ArchiveEsitoImportDetail archiveAccordoCooperazione = (ArchiveEsitoImportDetail)archive.getAccordiCooperazione().get(i);
            idCorrelazione = ((ArchiveAccordoCooperazione)archiveAccordoCooperazione.getArchiveObject()).getIdCorrelazione();
            this.getArchiveEsitoImport(idCorrelazione, map, mapIdCorrelazione).getAccordiCooperazione().add(archiveAccordoCooperazione);
        }
        for (i = 0; i < archive.getAccordiServizioParteComune().size(); ++i) {
            ArchiveEsitoImportDetail archiveAccordoServizioParteComune = (ArchiveEsitoImportDetail)archive.getAccordiServizioParteComune().get(i);
            idCorrelazione = ((ArchiveAccordoServizioParteComune)archiveAccordoServizioParteComune.getArchiveObject()).getIdCorrelazione();
            this.getArchiveEsitoImport(idCorrelazione, map, mapIdCorrelazione).getAccordiServizioParteComune().add(archiveAccordoServizioParteComune);
        }
        for (i = 0; i < archive.getAccordiServizioParteSpecifica().size(); ++i) {
            archiveAccordoServizioParteSpecifica = (ArchiveEsitoImportDetail)archive.getAccordiServizioParteSpecifica().get(i);
            idCorrelazione = ((ArchiveAccordoServizioParteSpecifica)archiveAccordoServizioParteSpecifica.getArchiveObject()).getIdCorrelazione();
            this.getArchiveEsitoImport(idCorrelazione, map, mapIdCorrelazione).getAccordiServizioParteSpecifica().add(archiveAccordoServizioParteSpecifica);
        }
        for (i = 0; i < archive.getAccordiServizioComposto().size(); ++i) {
            ArchiveEsitoImportDetail archiveAccordoServizioComposto = (ArchiveEsitoImportDetail)archive.getAccordiServizioComposto().get(i);
            idCorrelazione = ((ArchiveAccordoServizioComposto)archiveAccordoServizioComposto.getArchiveObject()).getIdCorrelazione();
            this.getArchiveEsitoImport(idCorrelazione, map, mapIdCorrelazione).getAccordiServizioComposto().add(archiveAccordoServizioComposto);
        }
        for (i = 0; i < archive.getAccordiServizioParteSpecificaServiziComposti().size(); ++i) {
            archiveAccordoServizioParteSpecifica = (ArchiveEsitoImportDetail)archive.getAccordiServizioParteSpecificaServiziComposti().get(i);
            idCorrelazione = ((ArchiveAccordoServizioParteSpecifica)archiveAccordoServizioParteSpecifica.getArchiveObject()).getIdCorrelazione();
            this.getArchiveEsitoImport(idCorrelazione, map, mapIdCorrelazione).getAccordiServizioParteSpecificaServiziComposti().add(archiveAccordoServizioParteSpecifica);
        }
        for (i = 0; i < archive.getAccordiFruitori().size(); ++i) {
            ArchiveEsitoImportDetail archiveFruitore = (ArchiveEsitoImportDetail)archive.getAccordiFruitori().get(i);
            idCorrelazione = ((ArchiveFruitore)archiveFruitore.getArchiveObject()).getIdCorrelazione();
            this.getArchiveEsitoImport(idCorrelazione, map, mapIdCorrelazione).getAccordiFruitori().add(archiveFruitore);
        }
        for (i = 0; i < archive.getPorteDelegate().size(); ++i) {
            ArchiveEsitoImportDetail archivePortaDelegata = (ArchiveEsitoImportDetail)archive.getPorteDelegate().get(i);
            idCorrelazione = ((ArchivePortaDelegata)archivePortaDelegata.getArchiveObject()).getIdCorrelazione();
            this.getArchiveEsitoImport(idCorrelazione, map, mapIdCorrelazione).getPorteDelegate().add(archivePortaDelegata);
        }
        for (i = 0; i < archive.getPorteApplicative().size(); ++i) {
            ArchiveEsitoImportDetail archivePortaApplicativa = (ArchiveEsitoImportDetail)archive.getPorteApplicative().get(i);
            idCorrelazione = ((ArchivePortaApplicativa)archivePortaApplicativa.getArchiveObject()).getIdCorrelazione();
            this.getArchiveEsitoImport(idCorrelazione, map, mapIdCorrelazione).getPorteApplicative().add(archivePortaApplicativa);
        }
        if (archive.getConfigurazionePdD() != null) {
            ArchiveEsitoImportDetailConfigurazione configurazione = archive.getConfigurazionePdD();
            if (mapIdCorrelazione.size() > 1) {
                throw new ProtocolException("Configurazione permessa solo con una unica correlazione tra oggetti");
            }
            ArchiveIdCorrelazione idCorrelazione2 = null;
            if (mapIdCorrelazione.size() == 1) {
                idCorrelazione2 = mapIdCorrelazione.values().iterator().next();
            } else if (mapIdCorrelazione.size() == 0) {
                idCorrelazione2 = new ArchiveIdCorrelazione("@PackageOpenSPCoop@");
            }
            this.getArchiveEsitoImport(idCorrelazione2, map, mapIdCorrelazione).setConfigurazionePdD(configurazione);
        }
    }
}

