/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.basic.archive;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.XMLUtils;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.basic.Costanti;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.basic.archive.EsitoUtils;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.basic.archive.ZIPUtils;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.IProtocolFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.ProtocolException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.Archive;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchiveEsitoDelete;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchiveEsitoImport;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchiveMode;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchiveModeType;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ExportMode;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.IArchive;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.IRegistryReader;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ImportMode;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.MapPlaceholder;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.MappingModeTypesExtensions;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.ArchiveType;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoServizioParteComune;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Operation;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.PortType;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.CostantiRegistroServizi;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.IDAccordoCooperazioneFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.IDAccordoFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.wsdl.AccordoServizioWrapperUtilities;
import it.link.pdd.tools.migrazione_govway.utils.wsdl.DefinitionWrapper;
import it.link.pdd.tools.migrazione_govway.utils.wsdl.WSDLUtilities;
import it.link.pdd.tools.migrazione_govway.utils.xml.AbstractXMLUtils;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.w3c.dom.Document;

public class BasicArchive
implements IArchive {
    protected IProtocolFactory protocolFactory = null;
    protected IDAccordoCooperazioneFactory idAccordoCooperazioneFactory;
    protected IDAccordoFactory idAccordoFactory;
    protected EsitoUtils esitoUtils;

    public BasicArchive(IProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
        this.idAccordoCooperazioneFactory = IDAccordoCooperazioneFactory.getInstance();
        this.idAccordoFactory = IDAccordoFactory.getInstance();
        this.esitoUtils = new EsitoUtils(protocolFactory);
    }

    @Override
    public IProtocolFactory getProtocolFactory() {
        return this.protocolFactory;
    }

    @Override
    public MappingModeTypesExtensions getMappingTypesExtensions(ArchiveMode mode) throws ProtocolException {
        MappingModeTypesExtensions m = new MappingModeTypesExtensions();
        m.add("zip", Costanti.OPENSPCOOP_ARCHIVE_MODE_TYPE);
        return m;
    }

    @Override
    public void setProtocolInfo(AccordoServizioParteComune accordoServizioParteComune) throws ProtocolException {
        this._setProtocolInfo(accordoServizioParteComune, this.protocolFactory.getLogger());
    }

    public void setProtocolInfo(AccordoServizioParteComune accordoServizioParteComune, Logger log) throws ProtocolException {
        this._setProtocolInfo(accordoServizioParteComune, log);
    }

    private void _setProtocolInfo(AccordoServizioParteComune accordoServizioParteComune, Logger log) throws ProtocolException {
        if (accordoServizioParteComune.sizePortTypeList() > 0) {
            throw new ProtocolException("Protocol Info already exists");
        }
        byte[] wsdlConcettuale = accordoServizioParteComune.getByteWsdlConcettuale();
        if (wsdlConcettuale != null) {
            this._setProtocolInfo(wsdlConcettuale, accordoServizioParteComune, "Concettuale", log);
        } else {
            if (accordoServizioParteComune.getByteWsdlLogicoErogatore() != null) {
                this._setProtocolInfo(accordoServizioParteComune.getByteWsdlLogicoErogatore(), accordoServizioParteComune, "LogicoErogatore", log);
            }
            if (accordoServizioParteComune.getByteWsdlLogicoFruitore() != null) {
                this._setProtocolInfo(accordoServizioParteComune.getByteWsdlLogicoFruitore(), accordoServizioParteComune, "LogicoFruitore", log);
            }
        }
    }

    private void _setProtocolInfo(byte[] wsdlBytes, AccordoServizioParteComune accordoServizioParteComune, String tipo, Logger log) throws ProtocolException {
        try {
            XMLUtils xmlUtils = XMLUtils.getInstance();
            WSDLUtilities wsdlUtilities = new WSDLUtilities(xmlUtils);
            Document d = xmlUtils.newDocument(wsdlBytes);
            wsdlUtilities.removeTypes(d);
            DefinitionWrapper wsdl = new DefinitionWrapper(d, (AbstractXMLUtils)xmlUtils, false, false);
            Map<?, ?> porttypesWSDL = wsdl.getAllPortTypes();
            if (porttypesWSDL == null || porttypesWSDL.size() <= 0) {
                throw new ProtocolException("WSDL" + tipo + " corrotto: non contiene la definizione di nessun port-type");
            }
            if (porttypesWSDL != null && porttypesWSDL.size() > 0) {
                for (QName key : porttypesWSDL.keySet()) {
                    javax.wsdl.PortType ptWSDL = (javax.wsdl.PortType)porttypesWSDL.get(key);
                    String ptName = ptWSDL.getQName().getLocalPart();
                    boolean foundPortType = false;
                    PortType ptOpenSPCoop = null;
                    for (PortType ptCheck : accordoServizioParteComune.getPortTypeList()) {
                        if (!ptCheck.getNome().equals(ptName)) continue;
                        ptOpenSPCoop = ptCheck;
                        foundPortType = true;
                        break;
                    }
                    Map<?, ?> bindingsWSDL = wsdl.getAllBindings();
                    Binding bindingWSDL = null;
                    if (bindingsWSDL != null && bindingsWSDL.size() > 0) {
                        for (QName tmp : bindingsWSDL.keySet()) {
                            Binding tmpBinding;
                            if (tmp == null || (tmpBinding = wsdl.getBinding(tmp)) == null || tmpBinding.getPortType() == null || tmpBinding.getPortType().getQName() == null || !ptName.equals(tmpBinding.getPortType().getQName().getLocalPart())) continue;
                            bindingWSDL = tmpBinding;
                            break;
                        }
                    }
                    if (ptOpenSPCoop == null) {
                        ptOpenSPCoop = new PortType();
                        ptOpenSPCoop.setNome(ptName);
                        ptOpenSPCoop.setProfiloCollaborazione(CostantiRegistroServizi.SINCRONO);
                        ptOpenSPCoop.setProfiloPT("ridefinito");
                        ptOpenSPCoop.setFiltroDuplicati(CostantiRegistroServizi.ABILITATO);
                    }
                    if (bindingWSDL != null) {
                        AccordoServizioWrapperUtilities.setPortTypeSoapBindingStyle(bindingWSDL, log, ptOpenSPCoop);
                    }
                    for (int i = 0; i < ptWSDL.getOperations().size(); ++i) {
                        javax.wsdl.Operation opWSDL = (javax.wsdl.Operation)ptWSDL.getOperations().get(i);
                        String opNome = opWSDL.getName();
                        boolean foundOperation = false;
                        Operation opOpenSPCoop = null;
                        for (Operation opCheck : ptOpenSPCoop.getAzioneList()) {
                            if (!opCheck.getNome().equals(opNome)) continue;
                            foundOperation = true;
                            break;
                        }
                        if (foundOperation) continue;
                        opOpenSPCoop = new Operation();
                        opOpenSPCoop.setNome(opNome);
                        opOpenSPCoop.setProfAzione("ridefinito");
                        opOpenSPCoop.setFiltroDuplicati(CostantiRegistroServizi.ABILITATO);
                        AccordoServizioWrapperUtilities.addMessageInputOperation(opWSDL, log, opOpenSPCoop);
                        AccordoServizioWrapperUtilities.addMessageOutputOperation(opWSDL, log, opOpenSPCoop);
                        if (opOpenSPCoop.getMessageOutput() != null) {
                            opOpenSPCoop.setProfiloCollaborazione(CostantiRegistroServizi.SINCRONO);
                        } else {
                            opOpenSPCoop.setProfiloCollaborazione(CostantiRegistroServizi.ONEWAY);
                        }
                        if (bindingWSDL != null) {
                            List bindingsOperation = bindingWSDL.getBindingOperations();
                            for (int j = 0; j < bindingsOperation.size(); ++j) {
                                BindingOperation bindingOperationWSDL = (BindingOperation)bindingsOperation.get(j);
                                if (bindingOperationWSDL.getOperation() == null || !opNome.equals(bindingOperationWSDL.getOperation().getName())) continue;
                                AccordoServizioWrapperUtilities.setOperationSoapBindingInformation(bindingOperationWSDL, log, opOpenSPCoop, ptOpenSPCoop);
                                if (opOpenSPCoop.getMessageInput() != null) {
                                    AccordoServizioWrapperUtilities.setMessageInputSoapBindingInformation(bindingOperationWSDL, log, opOpenSPCoop, ptOpenSPCoop);
                                }
                                if (opOpenSPCoop.getMessageOutput() == null) continue;
                                AccordoServizioWrapperUtilities.setMessageOutputSoapBindingInformation(bindingOperationWSDL, log, opOpenSPCoop, ptOpenSPCoop);
                            }
                        }
                        ptOpenSPCoop.addAzione(opOpenSPCoop);
                    }
                    if (foundPortType) continue;
                    accordoServizioParteComune.addPortType(ptOpenSPCoop);
                }
            }
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
    }

    @Override
    public List<ImportMode> getImportModes() throws ProtocolException {
        ArrayList<ImportMode> list = new ArrayList<ImportMode>();
        list.add(Costanti.OPENSPCOOP_IMPORT_ARCHIVE_MODE);
        return list;
    }

    @Override
    public Archive importArchive(byte[] archive, ArchiveMode mode, ArchiveModeType type, IRegistryReader registryReader, boolean validationDocuments, MapPlaceholder placeholder) throws ProtocolException {
        ZIPUtils zipUtils = new ZIPUtils(this.protocolFactory.getLogger(), registryReader);
        return zipUtils.getArchive(archive, placeholder, validationDocuments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Archive importArchive(InputStream archive, ArchiveMode mode, ArchiveModeType type, IRegistryReader registryReader, boolean validationDocuments, MapPlaceholder placeholder) throws ProtocolException {
        try {
            ZIPUtils zipUtils = new ZIPUtils(this.protocolFactory.getLogger(), registryReader);
            Archive archive2 = zipUtils.getArchive(archive, placeholder, validationDocuments);
            return archive2;
        }
        finally {
            try {
                if (archive != null) {
                    archive.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public String toString(ArchiveEsitoImport esito, ArchiveMode archiveMode) throws ProtocolException {
        return this.esitoUtils.toString(esito, false, true);
    }

    @Override
    public String toString(ArchiveEsitoDelete esito, ArchiveMode archiveMode) throws ProtocolException {
        return this.esitoUtils.toString(esito, false, false);
    }

    @Override
    public List<ExportMode> getExportModes(ArchiveType archiveType) throws ProtocolException {
        ArrayList<ExportMode> list = new ArrayList<ExportMode>();
        return list;
    }

    @Override
    public byte[] exportArchive(Archive archive, ArchiveMode mode, IRegistryReader registroReader) throws ProtocolException {
        throw new ProtocolException("Not Implemented");
    }

    @Override
    public void exportArchive(Archive archive, OutputStream out, ArchiveMode mode, IRegistryReader registroReader) throws ProtocolException {
        throw new ProtocolException("Not Implemented");
    }
}

