/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.basic;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.OpenSPCoop2MessageFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.SOAPVersion;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.XMLUtils;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.ProtocolException;
import it.link.pdd.tools.migrazione_govway.utils.xml.AbstractXMLUtils;
import javax.xml.soap.SOAPElement;
import org.slf4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Utilities {
    private static OpenSPCoop2MessageFactory msgFactory = OpenSPCoop2MessageFactory.getMessageFactory();
    private static AbstractXMLUtils xmlUtils = XMLUtils.getInstance();

    public static String toString(Logger log, SOAPElement soapElement) throws ProtocolException {
        if (soapElement == null) {
            throw new ProtocolException("Conversione in element non riuscita");
        }
        try {
            String xml = msgFactory.createMessage(SOAPVersion.SOAP11).getAsString((Node)soapElement, true);
            if (xml == null && (xml = xmlUtils.toString((Element)soapElement, true)) == null) {
                throw new Exception("Conversione in stringa non riuscita");
            }
            return xml;
        }
        catch (ProtocolException pe) {
            throw pe;
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
    }

    public static byte[] toByteArray(Logger log, SOAPElement soapElement) throws ProtocolException {
        if (soapElement == null) {
            throw new ProtocolException("Conversione in element non riuscita");
        }
        try {
            byte[] xml = msgFactory.createMessage(SOAPVersion.SOAP11).getAsByte((Node)soapElement, true);
            if (xml == null && (xml = xmlUtils.toByteArray((Element)soapElement, true)) == null) {
                throw new Exception("Conversione in bytes non riuscita");
            }
            return xml;
        }
        catch (ProtocolException pe) {
            throw pe;
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
    }
}

