/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.mtom;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.DynamicNamespaceContextFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.OpenSPCoop2Message;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.OpenSPCoop2MessageException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.SOAPVersion;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.SoapUtils;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.XPathExpressionEngine;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.mtom.MtomXomPackageInfo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.mtom.MtomXomReference;
import it.link.pdd.tools.migrazione_govway.utils.Utilities;
import it.link.pdd.tools.migrazione_govway.utils.xml.DynamicNamespaceContext;
import it.link.pdd.tools.migrazione_govway.utils.xml.XPathNotFoundException;
import it.link.pdd.tools.migrazione_govway.utils.xml.XPathReturnType;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.mail.internet.ContentType;
import javax.xml.namespace.QName;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPPart;
import org.apache.soap.encoding.soapenc.Base64;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MTOMUtilities {
    public static SOAPVersion readSoapVersionFromMtomContentType(String contentType) throws OpenSPCoop2MessageException {
        try {
            return MTOMUtilities.readSoapVersionFromMtomContentType(new ContentType(contentType));
        }
        catch (OpenSPCoop2MessageException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OpenSPCoop2MessageException(e.getMessage(), e);
        }
    }

    public static SOAPVersion readSoapVersionFromMtomContentType(ContentType contentType) throws OpenSPCoop2MessageException {
        try {
            if (contentType == null) {
                throw new OpenSPCoop2MessageException("ContentType non fornito");
            }
            if (contentType.getBaseType() == null) {
                throw new OpenSPCoop2MessageException("ContentType.baseType non definito");
            }
            if (!"multipart/related".equals(contentType.getBaseType().toLowerCase())) {
                throw new OpenSPCoop2MessageException("ContentType.baseType [" + contentType.getBaseType() + "] differente da quello atteso per un messaggio MTOM/XOP [multipart/related]");
            }
            if (contentType.getParameterList() == null || contentType.getParameterList().size() <= 0) {
                throw new OpenSPCoop2MessageException("ContentType non conforme a quanto definito nella specifica MTOM/XOP (non sono presenti parametri)");
            }
            String type = contentType.getParameter("type");
            if (type == null) {
                throw new OpenSPCoop2MessageException("ContentType non conforme a quanto definito nella specifica MTOM/XOP (Parametro 'type' non presente)");
            }
            if (!"application/xop+xml".equals(type.toLowerCase())) {
                throw new OpenSPCoop2MessageException("ContentType.parameters.type [" + type + "] differente da quello atteso per un messaggio MTOM/XOP [application/xop+xml]");
            }
            String startInfo = contentType.getParameter("start-info");
            if (startInfo == null) {
                throw new OpenSPCoop2MessageException("ContentType non conforme a quanto definito nella specifica MTOM/XOP (Parametro 'start-info' non presente)");
            }
            ContentType ctStartInfo = new ContentType(startInfo);
            String startInfoBase = ctStartInfo.getBaseType();
            SOAPVersion v = null;
            if ("text/xml".equals(startInfoBase.toLowerCase())) {
                v = SOAPVersion.SOAP11;
            } else if ("application/soap+xml".equals(startInfoBase.toLowerCase())) {
                v = SOAPVersion.SOAP12;
            } else {
                throw new OpenSPCoop2MessageException("ContentType.parameters.start-info [" + startInfo + "] differente da quello atteso per un messaggio MTOM/XOP [text/xml o application/soap+xml]");
            }
            return v;
        }
        catch (OpenSPCoop2MessageException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OpenSPCoop2MessageException(e.getMessage(), e);
        }
    }

    public static List<MtomXomReference> unpackaging(OpenSPCoop2Message message, boolean fast, boolean body) throws OpenSPCoop2MessageException {
        try {
            ArrayList<MtomXomReference> list = new ArrayList<MtomXomReference>();
            Object element = null;
            element = body ? message.getSOAPBody() : message.getSOAPPart().getEnvelope();
            if (element == null) {
                return list;
            }
            boolean restoredXomReference = false;
            XPathExpressionEngine xpathEngine = new XPathExpressionEngine();
            DynamicNamespaceContext dnc = DynamicNamespaceContextFactory.getInstance().getNamespaceContext((Node)element);
            Object oNode = null;
            try {
                oNode = xpathEngine.getMatchPattern((Element)element, dnc, "//{http://www.w3.org/2004/08/xop/include}:Include", XPathReturnType.NODESET);
            }
            catch (XPathNotFoundException xPathNotFoundException) {
                // empty catch block
            }
            if (oNode == null) {
                return list;
            }
            if (!(oNode instanceof NodeList)) {
                throw new OpenSPCoop2MessageException("XpathEngine (expr://{http://www.w3.org/2004/08/xop/include}:Include) return wrong type (expected: " + NodeList.class.getName() + "): " + oNode.getClass().getName());
            }
            NodeList nodeList = (NodeList)oNode;
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node xomReference = nodeList.item(i);
                if (xomReference.getAttributes() == null || xomReference.getAttributes().getLength() <= 0) {
                    throw new OpenSPCoop2MessageException("Found XOM Reference without attributes ('href' attribute required)");
                }
                Node xomHref = xomReference.getAttributes().getNamedItem("href");
                if (xomHref == null) {
                    throw new OpenSPCoop2MessageException("Found XOM Reference without attribute 'href'");
                }
                String contentId = xomHref.getNodeValue();
                if (contentId == null) {
                    throw new OpenSPCoop2MessageException("Found XOM Reference with attribute 'href' without value?");
                }
                if (contentId.startsWith("cid:")) {
                    contentId = contentId.substring("cid:".length());
                }
                MimeHeaders mhs = new MimeHeaders();
                mhs.addHeader("Content-ID", contentId);
                Iterator<?> itAttachments = message.getAttachments(mhs);
                if (itAttachments == null || !itAttachments.hasNext()) {
                    throw new OpenSPCoop2MessageException("Found XOM Reference with attribute [href]=[" + contentId + "] but the message hasn't attachments");
                }
                AttachmentPart ap = null;
                while (itAttachments.hasNext()) {
                    if (ap != null) {
                        throw new OpenSPCoop2MessageException("Found XOM Reference with attribute [href]=[" + contentId + "] but exists more than one attachment with same id");
                    }
                    ap = (AttachmentPart)itAttachments.next();
                }
                if (ap == null) {
                    throw new OpenSPCoop2MessageException("Found XOM Reference with attribute [href]=[" + contentId + "] but not exists attachment with same id");
                }
                Node elementBase64Binary = xomReference.getParentNode();
                if (elementBase64Binary == null) {
                    throw new OpenSPCoop2MessageException("Found XOM Reference without parent node?");
                }
                QName qname = new QName(elementBase64Binary.getNamespaceURI(), elementBase64Binary.getLocalName());
                String base64Binary = null;
                if (fast) {
                    base64Binary = Base64.encode((byte[])"FAST".getBytes());
                } else {
                    base64Binary = Utilities.getAsByteArrayOuputStream(ap.getBase64Content()).toString();
                    message.removeAttachments(mhs);
                    restoredXomReference = true;
                }
                elementBase64Binary.removeChild(xomReference);
                elementBase64Binary.setTextContent(base64Binary);
                MtomXomReference reference = new MtomXomReference();
                reference.setNodeName(qname);
                reference.setXomReference(xomReference);
                reference.setNode(elementBase64Binary);
                reference.setContentId(contentId);
                list.add(reference);
            }
            if (restoredXomReference) {
                message.removeContentTypeParameter("type");
                message.removeContentTypeParameter("start-info");
                if (message.countAttachments() > 0) {
                    if (SOAPVersion.SOAP11.equals((Object)message.getVersioneSoap())) {
                        message.addContentTypeParameter("type", "text/xml");
                    } else if (SOAPVersion.SOAP12.equals((Object)message.getVersioneSoap())) {
                        message.addContentTypeParameter("type", "application/soap+xml");
                    }
                }
            }
            return list;
        }
        catch (OpenSPCoop2MessageException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OpenSPCoop2MessageException(e.getMessage(), e);
        }
    }

    public static List<MtomXomReference> packaging(OpenSPCoop2Message message, List<MtomXomPackageInfo> packageInfos, boolean body) throws OpenSPCoop2MessageException {
        try {
            ArrayList<MtomXomReference> list = new ArrayList<MtomXomReference>();
            Object element = null;
            SOAPPart documentSOAPPart = message.getSOAPPart();
            element = body ? message.getSOAPBody() : message.getSOAPPart().getEnvelope();
            if (element == null) {
                return list;
            }
            XPathExpressionEngine xpathEngine = new XPathExpressionEngine();
            DynamicNamespaceContext dnc = DynamicNamespaceContextFactory.getInstance().getNamespaceContext((Node)element);
            boolean addAttachment = false;
            if (packageInfos == null || packageInfos.size() <= 0) {
                return list;
            }
            for (MtomXomPackageInfo mtomXomPackageInfo : packageInfos) {
                String xpathExpressionName = mtomXomPackageInfo.getName();
                String xpathExpression = mtomXomPackageInfo.getXpathExpression();
                Object oNode = null;
                try {
                    oNode = xpathEngine.getMatchPattern((Element)element, dnc, xpathExpression, XPathReturnType.NODESET);
                }
                catch (XPathNotFoundException xPathNotFoundException) {
                    // empty catch block
                }
                if (oNode == null) {
                    if (!mtomXomPackageInfo.isRequired()) continue;
                    throw new OpenSPCoop2MessageException("XpathEngine (expr(" + xpathExpressionName + "):" + xpathExpression + ") not found reference");
                }
                if (!(oNode instanceof NodeList)) {
                    throw new OpenSPCoop2MessageException("XpathEngine (expr(" + xpathExpressionName + "):" + xpathExpression + ") return wrong type (expected: " + NodeList.class.getName() + "): " + oNode.getClass().getName());
                }
                NodeList nodeList = (NodeList)oNode;
                if (nodeList.getLength() <= 0) {
                    if (!mtomXomPackageInfo.isRequired()) continue;
                    throw new OpenSPCoop2MessageException("XpathEngine (expr(" + xpathExpressionName + "):" + xpathExpression + ") not found reference (node list is empty)");
                }
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    String base64Content;
                    NamedNodeMap attr;
                    Node elementBase64Binary = nodeList.item(i);
                    if (MTOMUtilities.getIfExistsXomReference((Element)elementBase64Binary) != null) continue;
                    QName qname = new QName(elementBase64Binary.getNamespaceURI(), elementBase64Binary.getLocalName());
                    Vector<Node> elementBase64BinaryChilds = SoapUtils.getNotEmptyChildNodes(elementBase64Binary, false);
                    if (elementBase64BinaryChilds != null && elementBase64BinaryChilds.size() > 0) {
                        throw new OpenSPCoop2MessageException("XpathEngine (expr(" + xpathExpressionName + "):" + xpathExpression + ") found element (" + qname + ") with childs, mtom optimize packaging is only valid for base64Binary xsd element");
                    }
                    String contentTypeXMIMEAttribute = null;
                    if (elementBase64Binary.hasAttributes() && (attr = elementBase64Binary.getAttributes()) != null) {
                        for (int j = 0; j < attr.getLength(); ++j) {
                            Node n = attr.item(j);
                            String localName = n.getNodeName();
                            if (localName.contains(":")) {
                                localName = localName.split(":")[1];
                            }
                            if ("http://www.w3.org/2000/xmlns/".equals(n.getNamespaceURI()) && "xmlns".equals(localName)) continue;
                            if ("http://www.w3.org/2005/05/xmlmime".equals(n.getNamespaceURI()) && "contentType".equals(localName)) {
                                contentTypeXMIMEAttribute = n.getNodeValue();
                                continue;
                            }
                            throw new OpenSPCoop2MessageException("XpathEngine (expr(" + xpathExpressionName + "):" + xpathExpression + ") found element (" + qname + ") with attribute ({" + n.getNamespaceURI() + "}" + localName + "), mtom optimize packaging is only valid for base64Binary xsd element (permit only {http://www.w3.org/2005/05/xmlmime}contentType)");
                        }
                    }
                    if ((base64Content = elementBase64Binary.getTextContent()) == null) {
                        throw new OpenSPCoop2MessageException("XpathEngine (expr(" + xpathExpressionName + "):" + xpathExpression + ") found element (" + qname + ") without base64 value (textContent), mtom optimize packaging is only valid for base64Binary xsd element");
                    }
                    String contentId = null;
                    try {
                        AttachmentPart ap = message.createAttachmentPart();
                        String contentType = mtomXomPackageInfo.getContentType();
                        if (contentType == null) {
                            contentType = contentTypeXMIMEAttribute != null ? contentTypeXMIMEAttribute : "application/octet-stream";
                        }
                        ap.setContentId(message.createContentID("http://www.openspcoop2.org/core/mtom"));
                        contentId = ap.getContentId();
                        if (contentId.startsWith("<")) {
                            contentId = contentId.substring(1);
                        }
                        if (contentId.endsWith(">")) {
                            contentId = contentId.substring(0, contentId.length() - 1);
                        }
                        ap.setBase64Content((InputStream)new ByteArrayInputStream(base64Content.getBytes()), contentType);
                        message.addAttachmentPart(ap);
                        addAttachment = true;
                    }
                    catch (Exception e) {
                        throw new OpenSPCoop2MessageException("XpathEngine (expr(" + xpathExpressionName + "):" + xpathExpression + ") found element (" + qname + ") with base64 value (textContent). Error occurs during mtom optimize packaging (decodeBase64/createAttach): " + e.getMessage(), e);
                    }
                    elementBase64Binary.setTextContent(null);
                    Element xomReference = documentSOAPPart.createElementNS("http://www.w3.org/2004/08/xop/include", "xop:Include");
                    xomReference.setAttribute("href", "cid:" + contentId);
                    elementBase64Binary.appendChild(xomReference);
                    MtomXomReference reference = new MtomXomReference();
                    reference.setNodeName(qname);
                    reference.setXomReference(xomReference);
                    reference.setNode(elementBase64Binary);
                    reference.setContentId(contentId);
                    list.add(reference);
                }
            }
            if (addAttachment) {
                message.addContentTypeParameter("type", "application/xop+xml");
                if (SOAPVersion.SOAP11.equals((Object)message.getVersioneSoap())) {
                    message.addContentTypeParameter("start-info", "text/xml");
                } else if (SOAPVersion.SOAP12.equals((Object)message.getVersioneSoap())) {
                    message.addContentTypeParameter("start-info", "application/soap+xml");
                }
            }
            return list;
        }
        catch (OpenSPCoop2MessageException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OpenSPCoop2MessageException(e.getMessage(), e);
        }
    }

    public static List<MtomXomReference> verify(OpenSPCoop2Message message, List<MtomXomPackageInfo> packageInfos, boolean body) throws OpenSPCoop2MessageException {
        try {
            ArrayList<MtomXomReference> list = new ArrayList<MtomXomReference>();
            Object element = null;
            element = body ? message.getSOAPBody() : message.getSOAPPart().getEnvelope();
            if (element == null) {
                return list;
            }
            XPathExpressionEngine xpathEngine = new XPathExpressionEngine();
            DynamicNamespaceContext dnc = DynamicNamespaceContextFactory.getInstance().getNamespaceContext((Node)element);
            if (packageInfos == null || packageInfos.size() <= 0) {
                return list;
            }
            for (MtomXomPackageInfo mtomXomPackageInfo : packageInfos) {
                String xpathExpressionName = mtomXomPackageInfo.getName();
                String xpathExpression = mtomXomPackageInfo.getXpathExpression();
                Object oNode = null;
                try {
                    oNode = xpathEngine.getMatchPattern((Element)element, dnc, xpathExpression, XPathReturnType.NODESET);
                }
                catch (XPathNotFoundException xPathNotFoundException) {
                    // empty catch block
                }
                if (oNode == null) {
                    if (!mtomXomPackageInfo.isRequired()) continue;
                    throw new OpenSPCoop2MessageException("XpathEngine (expr(" + xpathExpressionName + "):" + xpathExpression + ") not found reference");
                }
                if (!(oNode instanceof NodeList)) {
                    throw new OpenSPCoop2MessageException("XpathEngine (expr(" + xpathExpressionName + "):" + xpathExpression + ") return wrong type (expected: " + NodeList.class.getName() + "): " + oNode.getClass().getName());
                }
                NodeList nodeList = (NodeList)oNode;
                if (nodeList.getLength() <= 0) {
                    if (!mtomXomPackageInfo.isRequired()) continue;
                    throw new OpenSPCoop2MessageException("XpathEngine (expr(" + xpathExpressionName + "):" + xpathExpression + ") not found reference (node list is empty)");
                }
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Vector<Node> nodeListBase64;
                    NamedNodeMap attr;
                    Node elementBase64Binary = nodeList.item(i);
                    QName qname = new QName(elementBase64Binary.getNamespaceURI(), elementBase64Binary.getLocalName());
                    if (elementBase64Binary.hasAttributes() && (attr = elementBase64Binary.getAttributes()) != null) {
                        for (int j = 0; j < attr.getLength(); ++j) {
                            Node n = attr.item(j);
                            String localName = n.getNodeName();
                            if (localName.contains(":")) {
                                localName = localName.split(":")[1];
                            }
                            if ("http://www.w3.org/2000/xmlns/".equals(n.getNamespaceURI()) && "xmlns".equals(localName) || "http://www.w3.org/2005/05/xmlmime".equals(n.getNamespaceURI()) && "contentType".equals(localName)) continue;
                            throw new OpenSPCoop2MessageException("XpathEngine (expr(" + xpathExpressionName + "):" + xpathExpression + ") found element (" + qname + ") with attribute ({" + n.getNamespaceURI() + "}" + localName + "), mtom optimize packaging structure invalid");
                        }
                    }
                    if ((nodeListBase64 = SoapUtils.getNotEmptyChildNodes(elementBase64Binary, false)) == null || nodeListBase64.size() <= 0) {
                        throw new OpenSPCoop2MessageException("XpathEngine (expr(" + xpathExpressionName + "):" + xpathExpression + ") found element (" + qname + ") without childs, mtom optimize packaging require xop:Include element");
                    }
                    if (nodeListBase64.size() > 1) {
                        throw new OpenSPCoop2MessageException("XpathEngine (expr(" + xpathExpressionName + "):" + xpathExpression + ") found element (" + qname + ") with more than one child, mtom optimize packaging structure invalid");
                    }
                    Node xomReference = nodeListBase64.get(0);
                    if (xomReference.getAttributes() == null || xomReference.getAttributes().getLength() <= 0) {
                        throw new OpenSPCoop2MessageException("Found XOM Reference without attributes ('href' attribute required)");
                    }
                    Node xomHref = xomReference.getAttributes().getNamedItem("href");
                    if (xomHref == null) {
                        throw new OpenSPCoop2MessageException("Found XOM Reference without attribute 'href'");
                    }
                    String contentId = xomHref.getNodeValue();
                    if (contentId == null) {
                        throw new OpenSPCoop2MessageException("Found XOM Reference with attribute 'href' without value?");
                    }
                    if (contentId.startsWith("cid:")) {
                        contentId = contentId.substring("cid:".length());
                    }
                    MimeHeaders mhs = new MimeHeaders();
                    mhs.addHeader("Content-ID", contentId);
                    Iterator<?> itAttachments = message.getAttachments(mhs);
                    if (itAttachments == null || !itAttachments.hasNext()) {
                        throw new OpenSPCoop2MessageException("Found XOM Reference with attribute [href]=[" + contentId + "] but the message hasn't attachments");
                    }
                    AttachmentPart ap = null;
                    while (itAttachments.hasNext()) {
                        if (ap != null) {
                            throw new OpenSPCoop2MessageException("Found XOM Reference with attribute [href]=[" + contentId + "] but exists more than one attachment with same id");
                        }
                        ap = (AttachmentPart)itAttachments.next();
                    }
                    if (ap == null) {
                        throw new OpenSPCoop2MessageException("Found XOM Reference with attribute [href]=[" + contentId + "] but not exists attachment with same id");
                    }
                    String contentType = mtomXomPackageInfo.getContentType();
                    if (contentType == null) {
                        contentType = "application/octet-stream";
                    }
                    if (ap.getContentType() == null) {
                        throw new OpenSPCoop2MessageException("Found XOM Reference with attribute [href]=[" + contentId + "]. The attachment hasn't content-type");
                    }
                    String apCT = ap.getContentType();
                    ContentType ct = new ContentType(apCT);
                    String base = ct.getBaseType();
                    if (!contentType.equals(base)) {
                        throw new OpenSPCoop2MessageException("Found XOM Reference with attribute [href]=[" + contentId + "]. The attachment has wrong content-type (expected:" + contentType + "): " + apCT);
                    }
                    MtomXomReference reference = new MtomXomReference();
                    reference.setNodeName(qname);
                    reference.setXomReference(xomReference);
                    reference.setNode(elementBase64Binary);
                    reference.setContentId(contentId);
                    list.add(reference);
                }
            }
            return list;
        }
        catch (OpenSPCoop2MessageException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OpenSPCoop2MessageException(e.getMessage(), e);
        }
    }

    public static void restoreAfterFastUnpackaging(OpenSPCoop2Message message, List<MtomXomReference> references, boolean body) throws OpenSPCoop2MessageException {
        try {
            Object element = null;
            element = body ? message.getSOAPBody() : message.getSOAPPart().getEnvelope();
            if (element == null) {
                return;
            }
            if (references == null || references.size() <= 0) {
                return;
            }
            for (MtomXomReference mtomXomReference : references) {
                if (mtomXomReference.getNode() == null) {
                    throw new OpenSPCoop2MessageException("XomReference [" + mtomXomReference.getNodeName() + "] with undefined node");
                }
                if (mtomXomReference.getXomReference() == null) {
                    throw new OpenSPCoop2MessageException("XomReference [" + mtomXomReference.getNodeName() + "] with undefined xomRerefence");
                }
                mtomXomReference.getNode().setTextContent(null);
                mtomXomReference.getNode().appendChild(mtomXomReference.getXomReference());
            }
        }
        catch (OpenSPCoop2MessageException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OpenSPCoop2MessageException(e.getMessage(), e);
        }
    }

    public static Element getIfExistsXomReference(Element element) {
        try {
            Node n = SoapUtils.getFirstNotEmptyChildNode(element, false);
            if ("Include".equals(n.getLocalName()) && "http://www.w3.org/2004/08/xop/include".equals(n.getNamespaceURI())) {
                return (Element)n;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getCidXomReference(Element element) throws OpenSPCoop2MessageException {
        if (element.getAttributes() == null || element.getAttributes().getLength() <= 0) {
            throw new OpenSPCoop2MessageException("Found XOM Reference without attributes ('href' attribute required)");
        }
        Node xomHref = element.getAttributes().getNamedItem("href");
        if (xomHref == null) {
            throw new OpenSPCoop2MessageException("Found XOM Reference without attribute 'href'");
        }
        String contentId = xomHref.getNodeValue();
        if (contentId == null) {
            throw new OpenSPCoop2MessageException("Found XOM Reference with attribute 'href' without value?");
        }
        if (contentId.startsWith("cid:")) {
            contentId = contentId.substring("cid:".length());
        }
        return contentId;
    }

    public static AttachmentPart getAttachmentPart(OpenSPCoop2Message message, String cidReference) throws OpenSPCoop2MessageException {
        MimeHeaders mhs = new MimeHeaders();
        mhs.addHeader("Content-ID", cidReference);
        Iterator<?> itAttachments = message.getAttachments(mhs);
        if (itAttachments == null || !itAttachments.hasNext()) {
            throw new OpenSPCoop2MessageException("Found XOM Reference with attribute [href]=[" + cidReference + "] but the message hasn't attachments");
        }
        AttachmentPart ap = null;
        while (itAttachments.hasNext()) {
            if (ap != null) {
                throw new OpenSPCoop2MessageException("Found XOM Reference with attribute [href]=[" + cidReference + "] but exists more than one attachment with same id");
            }
            ap = (AttachmentPart)itAttachments.next();
        }
        if (ap == null) {
            throw new OpenSPCoop2MessageException("Found XOM Reference with attribute [href]=[" + cidReference + "] but not exists attachment with same id");
        }
        return ap;
    }
}

