/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.mtom;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.OpenSPCoop2Message;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.OpenSPCoop2MessageFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.OpenSPCoop2MessageParseResult;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.SOAPVersion;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.XMLUtils;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.mtom.MtomXomPackageInfo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.mtom.MtomXomReference;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.soap.AttachmentPart;
import org.apache.soap.encoding.soapenc.Base64;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Client {
    public static void main(String[] args) throws Exception {
        new Client(SOAPVersion.SOAP11, null, false);
    }

    public Client(SOAPVersion soapVersion, String messageFactory, boolean addAttachInMsgOriginale) throws Exception {
        if (messageFactory != null) {
            OpenSPCoop2MessageFactory.setMessageFactoryImpl(messageFactory);
        }
        Document d = XMLUtils.getInstance().newDocument("<prova xmlns=\"www.openspcoop.org\"><esempio>Esempio di Utilizzo</esempio></prova>".getBytes());
        Element contenuto1 = d.createElementNS("www.openspcoop.org", "contenuto1");
        contenuto1.setTextContent(Base64.encode((byte[])"<esempioXml xmlns=\"www.openspcoop.org/example1\">PROVA</esempioXml>".getBytes()));
        d.getFirstChild().appendChild(contenuto1);
        Element contenuto2 = d.createElementNS("www.openspcoop.org", "contenuto2");
        contenuto2.setTextContent(Base64.encode((byte[])"<esempioXml2 xmlns=\"www.openspcoop.org/example2\"><nodoInterno>PROVA</nodoInterno></esempioXml2>".getBytes()));
        d.getLastChild().appendChild(contenuto2);
        byte[] xmlOriginale = XMLUtils.getInstance().toByteArray(d, true);
        String soap11Prefix = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\">\n\t<soapenv:Body>\n";
        String soap11Suffix = "\n\t</soapenv:Body>\n</soapenv:Envelope>";
        String soap12Prefix = "<soapenv:Envelope xmlns:soapenv=\"http://www.w3.org/2003/05/soap-envelope\">\n\t<soapenv:Body>\n";
        String soap12Suffix = "\n\t</soapenv:Body>\n</soapenv:Envelope>";
        OpenSPCoop2MessageFactory.initMessageFactory();
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        if (SOAPVersion.SOAP11.equals((Object)soapVersion)) {
            bout.write(soap11Prefix.getBytes());
            bout.write(xmlOriginale);
            bout.write(soap11Suffix.getBytes());
        } else {
            bout.write(soap12Prefix.getBytes());
            bout.write(xmlOriginale);
            bout.write(soap12Suffix.getBytes());
        }
        OpenSPCoop2MessageParseResult pr = OpenSPCoop2MessageFactory.getMessageFactory().createMessage(soapVersion, bout.toByteArray());
        OpenSPCoop2Message msg = pr.getMessage_throwParseException();
        if (addAttachInMsgOriginale) {
            AttachmentPart ap = msg.createAttachmentPart();
            String contentType = "application/octet-stream";
            ap.setContentId(msg.createContentID("www.openspcoop2.org/example"));
            ap.setBase64Content((InputStream)new ByteArrayInputStream(Base64.encode((byte[])"PROVA".getBytes()).getBytes()), contentType);
            msg.addAttachmentPart(ap);
        }
        msg.updateContentType();
        System.out.println("SOAP [" + msg.getContentType() + "]");
        msg.writeTo(System.out, false);
        System.out.println("\n\n\n");
        ArrayList<MtomXomPackageInfo> packageInfos = new ArrayList<MtomXomPackageInfo>();
        MtomXomPackageInfo fileInfo = new MtomXomPackageInfo();
        fileInfo.setName("Contenuto1");
        fileInfo.setXpathExpression("//{www.openspcoop.org}contenuto1");
        packageInfos.add(fileInfo);
        MtomXomPackageInfo fileMetaInfo = new MtomXomPackageInfo();
        fileMetaInfo.setName("Contenuto2");
        fileMetaInfo.setXpathExpression("//{www.openspcoop.org}contenuto2");
        fileMetaInfo.setContentType("text/xml");
        fileMetaInfo.setRequired(true);
        packageInfos.add(fileMetaInfo);
        msg.mtomPackaging(packageInfos);
        msg.updateContentType();
        System.out.println("PACKAGING [" + msg.getContentType() + "]");
        msg.writeTo(System.out, false);
        System.out.println("\n\n\n");
        System.out.println("VERIFICA ...");
        msg.mtomVerify(packageInfos);
        System.out.println("VERIFICA OK");
        System.out.println("\n\n\n");
        List<MtomXomReference> mtomReferences = msg.mtomFastUnpackagingForXSDConformance();
        System.out.println("PRE-VERIFICA XSD");
        for (MtomXomReference mtomXomReference : mtomReferences) {
            System.out.println("\t- " + mtomXomReference.toString());
        }
        msg.writeTo(System.out, false);
        System.out.println("\n\n\n");
        msg.mtomRestoreAfterXSDConformance(mtomReferences);
        System.out.println("POST-VERIFICA XSD");
        msg.writeTo(System.out, false);
        System.out.println("\n\n\n");
        mtomReferences = msg.mtomUnpackaging();
        msg.updateContentType();
        System.out.println("UNPACKAGING [" + msg.getContentType() + "]");
        for (MtomXomReference mtomXomReference : mtomReferences) {
            System.out.println("\t- " + mtomXomReference.toString());
        }
        msg.writeTo(System.out, false);
        System.out.println("\n\n\n");
        msg.mtomPackaging(packageInfos);
        msg.updateContentType();
        System.out.println("PACKAGING [" + msg.getContentType() + "]");
        msg.writeTo(System.out, false);
        System.out.println("\n\n\n");
    }
}

