/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.message;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.AttachmentsUtils;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.OpenSPCoop2DataContentHandler;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.OpenSPCoop2DataContentHandlerInputStream;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.OpenSPCoop2Message;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.OpenSPCoop2MessageFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.OpenSPCoop2MessageParseResult;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.SOAPVersion;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.SoapUtilsBuildParameter;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.XMLUtils;
import it.link.pdd.tools.migrazione_govway.utils.UtilsException;
import it.link.pdd.tools.migrazione_govway.utils.io.notifier.NotifierInputStreamParams;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.namespace.QName;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.Detail;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPHeaderElement;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.soap.util.mime.ByteArrayDataSource;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class SoapUtils {
    public static SOAPFactory getSoapFactory(SOAPVersion versioneSoap) throws SOAPException {
        if (SOAPVersion.SOAP11.equals((Object)versioneSoap)) {
            return OpenSPCoop2MessageFactory.getMessageFactory().getSoapFactory11();
        }
        return OpenSPCoop2MessageFactory.getMessageFactory().getSoapFactory12();
    }

    public static MessageFactory getMessageFactory() throws SOAPException {
        return OpenSPCoop2MessageFactory.getMessageFactory().getSoapMessageFactory();
    }

    public static Vector<Node> getNotEmptyChildNodes(Node e) {
        return SoapUtils.getNotEmptyChildNodes(e, true);
    }

    public static Vector<Node> getNotEmptyChildNodes(Node e, boolean consideraTextNotEmptyAsNode) {
        return XMLUtils.getInstance().getNotEmptyChildNodes(e, consideraTextNotEmptyAsNode);
    }

    public static Node getFirstNotEmptyChildNode(Node e) {
        return SoapUtils.getFirstNotEmptyChildNode(e, true);
    }

    public static Node getFirstNotEmptyChildNode(Node e, boolean consideraTextNotEmptyAsNode) {
        return XMLUtils.getInstance().getFirstNotEmptyChildNode(e, consideraTextNotEmptyAsNode);
    }

    public static Vector<SOAPElement> getNotEmptyChildSOAPElement(SOAPElement e) {
        Vector<SOAPElement> vec = new Vector<SOAPElement>();
        Iterator soapElements = e.getChildElements();
        while (soapElements.hasNext()) {
            Object soapElement = soapElements.next();
            if (!(soapElement instanceof SOAPElement)) continue;
            vec.add((SOAPElement)soapElement);
        }
        return vec;
    }

    public static SOAPElement getNotEmptyFirstChildSOAPElement(SOAPElement e) {
        Iterator soapElements = e.getChildElements();
        while (soapElements.hasNext()) {
            Object soapElement = soapElements.next();
            if (!(soapElement instanceof SOAPElement)) continue;
            return (SOAPElement)soapElement;
        }
        return null;
    }

    public static String getSoapAction(OpenSPCoop2Message msg) throws UtilsException {
        String soapAction = null;
        try {
            MimeHeaders mhs = msg.getMimeHeaders();
            Iterator it = mhs.getAllHeaders();
            while (it.hasNext()) {
                MimeHeader mh = (MimeHeader)it.next();
                if (!"soapaction".equalsIgnoreCase(mh.getName())) continue;
                soapAction = mh.getValue();
            }
            if (soapAction == null) {
                if (msg.getProperty("SOAPAction") != null) {
                    soapAction = (String)msg.getProperty("SOAPAction");
                } else if (msg.getProperty("soapaction") != null) {
                    soapAction = (String)msg.getProperty("soapaction");
                } else if (msg.getProperty("soapAction") != null) {
                    soapAction = (String)msg.getProperty("soapAction");
                } else if (msg.getProperty("SoapAction") != null) {
                    soapAction = (String)msg.getProperty("SoapAction");
                } else if (msg.getProperty("SOAPACTION") != null) {
                    soapAction = (String)msg.getProperty("SOAPACTION");
                }
            }
            return soapAction;
        }
        catch (Exception e) {
            throw new UtilsException("Lettura SOAPAction non riuscita", e);
        }
    }

    public static String getSoapActor(SOAPHeaderElement headerElement, SOAPVersion version) {
        if (SOAPVersion.SOAP12.equals((Object)version)) {
            return headerElement.getRole();
        }
        return headerElement.getActor();
    }

    public static boolean matchLocalName(Node nodo, String nodeName, String prefix, String namespace) {
        if (nodo == null) {
            return false;
        }
        if (nodo.getNodeName() == null) {
            return false;
        }
        if (nodo.getNodeName().equals(prefix + nodeName)) {
            return true;
        }
        String namespaceNodo = nodo.getNamespaceURI();
        if (namespaceNodo != null && namespaceNodo.equals(namespace)) {
            Object xmlns = nodo.getPrefix();
            if (xmlns == null) {
                xmlns = "";
            } else if (!((String)xmlns).equals("")) {
                xmlns = (String)xmlns + ":";
            }
            if (nodo.getNodeName().equals((String)xmlns + nodeName)) {
                return true;
            }
        }
        return false;
    }

    public static Node getAttributeNode(Node node, String attributeName) {
        if (node == null) {
            return null;
        }
        NamedNodeMap map = node.getAttributes();
        if (map == null || map.getLength() == 0) {
            return null;
        }
        return map.getNamedItem(attributeName);
    }

    public static Node getQualifiedAttributeNode(Node node, String attributeName, String namespace) {
        if (node == null) {
            return null;
        }
        NamedNodeMap map = node.getAttributes();
        if (map == null || map.getLength() == 0) {
            return null;
        }
        return map.getNamedItemNS(namespace, attributeName);
    }

    public static String toString(SOAPFault fault) throws UtilsException {
        return SoapUtils.toString(fault, true);
    }

    public static String toString(SOAPFault fault, boolean printDetails) throws UtilsException {
        try {
            if (printDetails) {
                if (fault != null) {
                    return OpenSPCoop2MessageFactory.getMessageFactory().createMessage(SOAPVersion.SOAP11).getAsString((Node)fault, true);
                }
                return "SOAPFault non presente";
            }
            StringBuffer bf = new StringBuffer();
            if (fault != null) {
                bf.append("SOAPFault");
                if (fault.getFaultCode() != null && !"".equals(fault.getFaultCode())) {
                    bf.append(" faultCode[" + fault.getFaultCode() + "]");
                }
                if (fault.getFaultActor() != null && !"".equals(fault.getFaultActor())) {
                    bf.append(" faultActor[" + fault.getFaultActor() + "]");
                }
                if (fault.getFaultString() != null && !"".equals(fault.getFaultString())) {
                    bf.append(" faultString[" + fault.getFaultString() + "]");
                }
            } else {
                return "SOAPFault non presente";
            }
            return bf.toString();
        }
        catch (Exception e) {
            throw new UtilsException("toString SOAPFault: " + e.getMessage(), e);
        }
    }

    public static OpenSPCoop2Message build_Soap_Empty(SOAPVersion versioneSoap) {
        try {
            OpenSPCoop2MessageFactory mf = OpenSPCoop2MessageFactory.getMessageFactory();
            OpenSPCoop2Message msg = mf.createEmptySOAPMessage(versioneSoap);
            return msg;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static byte[] build_Soap_Fault(SOAPVersion versioneSoap, String aFault, String aActor, QName aCode, Element dettaglioEccezione, boolean generaDetails) throws UtilsException {
        ByteArrayOutputStream byteMessaggio = null;
        try {
            OpenSPCoop2MessageFactory mf = OpenSPCoop2MessageFactory.getMessageFactory();
            OpenSPCoop2Message msg = mf.createMessage(versioneSoap);
            SOAPEnvelope env = msg.getSOAPPart().getEnvelope();
            SOAPBody bdy = env.getBody();
            bdy.addFault();
            SOAPFault fault = bdy.getFault();
            if (aFault != null) {
                fault.setFaultString(aFault);
            } else {
                fault.setFaultString("");
            }
            if (aCode != null) {
                fault.setFaultCode(aCode);
            }
            if (aActor != null) {
                fault.setFaultActor(aActor);
            }
            if (generaDetails && dettaglioEccezione != null) {
                fault.addDetail();
                Detail d = fault.getDetail();
                d.appendChild(d.getOwnerDocument().importNode(dettaglioEccezione, true));
            }
            byteMessaggio = new ByteArrayOutputStream();
            msg.writeTo(byteMessaggio, true);
            byte[] risultato = byteMessaggio.toByteArray();
            byteMessaggio.close();
            return risultato;
        }
        catch (Exception e) {
            try {
                if (byteMessaggio != null) {
                    byteMessaggio.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new UtilsException("Creazione MsgSOAPFault non riuscito: " + e.getMessage(), e);
        }
    }

    public static boolean isTunnelOpenSPCoopSoap(SOAPBody body) {
        Vector<Node> bodyChildren = SoapUtils.getNotEmptyChildNodes((Node)body);
        return body != null && bodyChildren.size() > 0 && bodyChildren.get(0) != null && "SOAPTunnel".equals(bodyChildren.get(0).getLocalName()) && "http://www.openspcoop2.org/pdd/services/PDtoSOAP".equals(bodyChildren.get(0).getNamespaceURI()) && "OpenSPCoop2".equals(bodyChildren.get(0).getPrefix());
    }

    public static String getContentTypeTunnelOpenSPCoopSoap(SOAPBody body) throws UtilsException {
        if (body != null && body.hasChildNodes()) {
            return ((SOAPElement)body.getChildElements().next()).getValue();
        }
        throw new UtilsException("Body non presente");
    }

    public static void sbustamentoMessaggio(OpenSPCoop2Message msg, OutputStream streamParam) throws UtilsException {
        CountingOutputStream cout = null;
        try {
            cout = new CountingOutputStream(streamParam);
            if (msg.countAttachments() == 0) {
                SOAPBody bd = msg.getSOAPBody();
                if (bd.hasFault()) {
                    SOAPFault fault = bd.getFault();
                    cout.write(msg.getAsByte((Node)fault, true));
                } else {
                    Iterator it = bd.getChildElements();
                    while (it.hasNext()) {
                        Object bodyObject = it.next();
                        if (!(bodyObject instanceof SOAPElement)) continue;
                        SOAPElement bodyElement = (SOAPElement)bodyObject;
                        cout.write(msg.getAsByte((Node)bodyElement, true));
                    }
                }
            } else {
                SOAPBody body = msg.getSOAPBody();
                if (SoapUtils.isTunnelOpenSPCoopSoap(body)) {
                    AttachmentPart ap = (AttachmentPart)msg.getAttachments().next();
                    Object o = ap.getContent();
                    InputStream inputDH = null;
                    if (o instanceof OpenSPCoop2DataContentHandlerInputStream) {
                        inputDH = (OpenSPCoop2DataContentHandlerInputStream)o;
                    } else if (o instanceof InputStream) {
                        inputDH = (InputStream)OpenSPCoop2DataContentHandler.getContent((InputStream)o);
                    } else if (o instanceof byte[]) {
                        inputDH = (InputStream)OpenSPCoop2DataContentHandler.getContent(new ByteArrayInputStream((byte[])o));
                    } else {
                        throw new Exception("Tipo non gestito: " + o.getClass().getName());
                    }
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    byte[] readB = new byte[8192];
                    int readByte = 0;
                    while ((readByte = inputDH.read(readB)) != -1) {
                        bout.write(readB, 0, readByte);
                    }
                    inputDH.close();
                    bout.close();
                    cout.write(bout.toByteArray());
                } else {
                    ByteArrayOutputStream sbustamentoAttachments = new ByteArrayOutputStream();
                    msg.writeTo(sbustamentoAttachments, true);
                    String msgString = sbustamentoAttachments.toString();
                    byte[] msgByte = sbustamentoAttachments.toByteArray();
                    String soapEnvelopeStart = "<" + msg.getSOAPPart().getEnvelope().getPrefix() + ":" + msg.getSOAPPart().getEnvelope().getLocalName();
                    String xmlTagDecode = "<?xml";
                    String soapEnvelopeStop = "</" + msg.getSOAPPart().getEnvelope().getPrefix() + ":" + msg.getSOAPPart().getEnvelope().getLocalName() + ">";
                    if (msgString.indexOf(xmlTagDecode) != -1) {
                        cout.write(msgByte, 0, msgString.indexOf(xmlTagDecode));
                    } else {
                        cout.write(msgByte, 0, msgString.indexOf(soapEnvelopeStart));
                    }
                    SOAPBody bd = msg.getSOAPBody();
                    if (bd.hasFault()) {
                        SOAPFault fault = bd.getFault();
                        cout.write(msg.getAsByte((Node)fault, true));
                    } else {
                        cout.write(msg.getAsByte(msg.getFirstChildElement((SOAPElement)bd), true));
                    }
                    int indexOf = msgString.indexOf(soapEnvelopeStop) + soapEnvelopeStop.length();
                    cout.write(msgByte, indexOf, msgByte.length - indexOf);
                }
            }
            msg.updateIncomingMessageContentLength();
            cout.flush();
            msg.updateOutgoingMessageContentLength(cout.getByteCount());
        }
        catch (Exception e) {
            throw new UtilsException("Sbustamento msg_inputStream non riuscito: " + e.getMessage(), e);
        }
        finally {
            try {
                if (cout != null) {
                    cout.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static byte[] sbustamentoMessaggio(OpenSPCoop2Message msg) throws UtilsException {
        ByteArrayOutputStream bodySbustato = new ByteArrayOutputStream();
        try {
            SoapUtils.sbustamentoMessaggio(msg, bodySbustato);
            return bodySbustato.toByteArray();
        }
        catch (Exception e) {
            try {
                if (bodySbustato != null) {
                    bodySbustato.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new UtilsException("Sbustamento msg non riuscito: " + e.getMessage(), e);
        }
    }

    public static byte[] sbustamentoSOAPEnvelope(SOAPEnvelope env) throws UtilsException {
        ByteArrayOutputStream bout = null;
        try {
            SOAPBody bd = env.getBody();
            byte[] body = null;
            if (bd.hasFault()) {
                SOAPFault fault = bd.getFault();
                body = OpenSPCoop2MessageFactory.getMessageFactory().createMessage(SOAPVersion.SOAP11).getAsByte((Node)fault, true);
            } else {
                bout = new ByteArrayOutputStream();
                Iterator it = bd.getChildElements();
                while (it.hasNext()) {
                    Object bodyElementObj = it.next();
                    if (!(bodyElementObj instanceof SOAPElement)) continue;
                    SOAPElement bodyElement = (SOAPElement)bodyElementObj;
                    bout.write(OpenSPCoop2MessageFactory.getMessageFactory().createMessage(SOAPVersion.SOAP11).getAsByte((Node)bodyElement, true));
                }
                bout.flush();
                bout.close();
                body = bout.toByteArray();
                bout = null;
            }
            byte[] byArray = body;
            return byArray;
        }
        catch (Exception e) {
            throw new UtilsException("Sbustamento SoapEnvelope non riuscito: " + e.getMessage(), e);
        }
        finally {
            try {
                if (bout != null) {
                    bout.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static OpenSPCoop2Message imbustamentoMessaggioConAttachment(SOAPVersion versioneSoap, InputStream inputBody, String tipoAttachment, boolean buildAsDataHandler, String contentTypeMessaggioOriginale, String ns) throws UtilsException {
        try {
            ByteArrayOutputStream byteBuffer = new ByteArrayOutputStream();
            byte[] readB = new byte[65536];
            int readByte = 0;
            while ((readByte = inputBody.read(readB)) != -1) {
                byteBuffer.write(readB, 0, readByte);
            }
            inputBody.close();
            if (byteBuffer.size() == 0) {
                throw new UtilsException("Contenuto da imbustare non presente");
            }
            return SoapUtils.imbustamentoMessaggioConAttachment(versioneSoap, byteBuffer.toByteArray(), tipoAttachment, buildAsDataHandler, contentTypeMessaggioOriginale, ns);
        }
        catch (Exception e) {
            throw new UtilsException("Imbustamento msgConAttachment_inputStream non riuscito: " + e.getMessage(), e);
        }
    }

    public static OpenSPCoop2Message imbustamentoMessaggioConAttachment(SOAPVersion versioneSoap, byte[] inputBody, String tipoAttachment, boolean buildAsDataHandler, String contentTypeMessaggioOriginale, String ns) throws UtilsException {
        OpenSPCoop2Message msg = null;
        try {
            OpenSPCoop2MessageFactory mf = OpenSPCoop2MessageFactory.getMessageFactory();
            msg = mf.createMessage(versioneSoap);
            return SoapUtils.imbustamentoMessaggioConAttachment(msg, inputBody, tipoAttachment, buildAsDataHandler, contentTypeMessaggioOriginale, ns);
        }
        catch (Exception e) {
            throw new UtilsException("Imbustamento msgConAttachment_inputStream non riuscito: " + e.getMessage(), e);
        }
    }

    public static OpenSPCoop2Message imbustamentoMessaggioConAttachment(OpenSPCoop2Message msg, byte[] inputBody, String tipoAttachment, boolean buildAsDataHandler, String contentTypeMessaggioOriginale, String ns) throws UtilsException {
        try {
            if (inputBody == null || inputBody.length <= 0) {
                throw new UtilsException("Contenuto da imbustare non presente");
            }
            SOAPBody soapBody = msg.getSOAPBody();
            QName name = null;
            name = "application/openspcoop2".equals(tipoAttachment) ? new QName("http://www.openspcoop2.org/pdd/services/PDtoSOAP", "SOAPTunnel", "OpenSPCoop2") : new QName("http://www.openspcoop2.org/pdd/services/PDtoSOAP", "Attachments", "OpenSPCoop2");
            SOAPElement bodyElement = soapBody.addChildElement(name);
            if ("application/openspcoop2".equals(tipoAttachment)) {
                if (contentTypeMessaggioOriginale == null) {
                    throw new Exception("ContentType messaggio per cui applicare il tunnel non definito?");
                }
                bodyElement.setValue(contentTypeMessaggioOriginale);
            }
            AttachmentPart ap = msg.createAttachmentPart();
            if (buildAsDataHandler) {
                ap.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(inputBody, tipoAttachment)));
                SoapUtils.saveAttachmentOpenSPCoop(ap);
            } else {
                ap.setRawContentBytes(inputBody, 0, inputBody.length, tipoAttachment);
            }
            ap.setContentId(msg.createContentID(ns));
            msg.addAttachmentPart(ap);
            return msg;
        }
        catch (Exception e) {
            throw new UtilsException("Imbustamento msgConAttachment_inputStream non riuscito: " + e.getMessage(), e);
        }
    }

    private static void saveAttachmentOpenSPCoop(AttachmentPart ap) throws SOAPException, IOException {
        DataHandler dh = ap.getDataHandler();
        InputStream inputDH = dh.getInputStream();
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] readB = new byte[8192];
        int readByte = 0;
        while ((readByte = inputDH.read(readB)) != -1) {
            bout.write(readB, 0, readByte);
        }
        inputDH.close();
        bout.flush();
        bout.close();
        ap.setDataHandler(new DataHandler((Object)bout.toByteArray(), ap.getContentType()));
    }

    public static OpenSPCoop2Message imbustamentoMessaggioConAttachment(SOAPVersion versioneSoap, byte[] body, String ns) throws UtilsException {
        OpenSPCoop2Message risposta = null;
        try {
            risposta = SoapUtils.imbustamentoMessaggioConAttachment(versioneSoap, body, "text/plain", false, null, ns);
            return risposta;
        }
        catch (Exception e) {
            throw new UtilsException("Imbustamento msgConAttachment non riuscito: " + e.getMessage(), e);
        }
    }

    public static OpenSPCoop2MessageParseResult imbustamentoMessaggio(NotifierInputStreamParams notifierInputStreamParams, byte[] body, boolean eraserXMLTag, boolean fileCacheEnable, String attachmentRepoDir, String fileThreshold) throws UtilsException {
        return SoapUtils.build(new SoapUtilsBuildParameter(body, true, eraserXMLTag, fileCacheEnable, attachmentRepoDir, fileThreshold), notifierInputStreamParams);
    }

    public static OpenSPCoop2MessageParseResult build(SoapUtilsBuildParameter param, NotifierInputStreamParams notifierInputStreamParams) throws UtilsException {
        try {
            byte[] byteMsg = param.getByteMsg();
            boolean isBodyStream = param.isBodyStream();
            if (byteMsg == null || byteMsg.length == 0) {
                throw new Exception("Nessun contenuto su cui costruire il messaggio");
            }
            int offset = 0;
            Object contentType = "text/xml";
            if (AttachmentsUtils.messageWithAttachment(byteMsg)) {
                String IDfirst = AttachmentsUtils.firstContentID(byteMsg);
                String boundary = AttachmentsUtils.findBoundary(byteMsg);
                if (boundary == null) {
                    throw new Exception("Errore avvenuto durante la lettura del boundary associato al multipart message.");
                }
                contentType = IDfirst == null ? "multipart/related; type=\"text/xml\"; \tboundary=\"" + boundary.substring(2, boundary.length()) + "\" " : "multipart/related; type=\"text/xml\"; start=\"" + IDfirst + "\"; \tboundary=\"" + boundary.substring(2, boundary.length()) + "\" ";
                if (isBodyStream) {
                    int puliziaSpaziBianchi_e_XML;
                    String msg = new String(byteMsg);
                    int firstBound = msg.indexOf(boundary);
                    int secondBound = msg.indexOf(boundary, firstBound + boundary.length());
                    if (firstBound == -1 || secondBound == -1) {
                        throw new Exception("multipart/related non correttamente formato (bound not found)");
                    }
                    String bodyOriginal = msg.substring(firstBound + boundary.length(), secondBound);
                    int indexCarriage = bodyOriginal.indexOf("\r\n\r\n");
                    if (indexCarriage == -1) {
                        throw new Exception("multipart/related non correttamente formato (\\r\\n\\r\\n not found)");
                    }
                    String contenutoBody = bodyOriginal.substring(indexCarriage + "\r\n\r\n".length());
                    for (puliziaSpaziBianchi_e_XML = 0; puliziaSpaziBianchi_e_XML < contenutoBody.length() && contenutoBody.charAt(puliziaSpaziBianchi_e_XML) == ' '; ++puliziaSpaziBianchi_e_XML) {
                    }
                    String bodyPulito = contenutoBody.substring(puliziaSpaziBianchi_e_XML);
                    if (bodyPulito.startsWith("<?xml")) {
                        if (param.isEraserXMLTag()) {
                            for (puliziaSpaziBianchi_e_XML = 0; puliziaSpaziBianchi_e_XML < contenutoBody.length() && contenutoBody.charAt(puliziaSpaziBianchi_e_XML) != '>'; ++puliziaSpaziBianchi_e_XML) {
                            }
                            bodyPulito = bodyPulito.substring(puliziaSpaziBianchi_e_XML + 1);
                        } else {
                            throw new Exception("Tag <?xml non permesso con la funzionalita di imbustamento SOAP");
                        }
                    }
                    String contenutoBodyImbustato = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><soapenv:Body>" + bodyPulito + "</soapenv:Body></soapenv:Envelope>\r\n";
                    String bodyOriginalImbustato = bodyOriginal.replace(contenutoBody, contenutoBodyImbustato);
                    msg = msg.replace(bodyOriginal, bodyOriginalImbustato);
                    byteMsg = msg.getBytes();
                    isBodyStream = false;
                }
            } else if (isBodyStream) {
                int i;
                for (i = 0; i < byteMsg.length && (char)byteMsg[i] == ' '; ++i) {
                }
                offset = SoapUtils.readOffsetXmlInstruction(byteMsg, i, param, offset, false);
            }
            ByteArrayInputStream messageInput = new ByteArrayInputStream(byteMsg, offset, byteMsg.length);
            OpenSPCoop2MessageFactory mf = OpenSPCoop2MessageFactory.getMessageFactory();
            OpenSPCoop2MessageParseResult pr = mf.createMessage(messageInput, notifierInputStreamParams, isBodyStream, (String)contentType, null, param.isFileCacheEnable(), param.getAttachmentRepoDir(), param.getFileThreshold());
            OpenSPCoop2Message message = pr.getMessage();
            if (message != null) {
                String[] hdrs;
                if (param.isCheckEmptyBody() && (message.getSOAPBody() == null || !message.getSOAPBody().hasChildNodes())) {
                    throw new Exception("Costruzione di un msg soap non riuscita: soap body senza contenuto");
                }
                String soapAction = null;
                if (message.getMimeHeaders() != null && (hdrs = message.getMimeHeaders().getHeader("SOAPAction")) != null && hdrs.length > 0) {
                    soapAction = hdrs[0];
                }
                if (soapAction == null) {
                    soapAction = "\"OpenSPCoop\"";
                    message.setProperty("SOAPAction", soapAction);
                    if (message.getMimeHeaders() != null) {
                        message.getMimeHeaders().addHeader("SOAPAction", soapAction);
                    }
                }
            }
            return pr;
        }
        catch (Exception e) {
            throw new UtilsException("Build msg non riuscito: " + e.getMessage(), e);
        }
    }

    private static int readOffsetXmlInstruction(byte[] byteMsg, int startFrom, SoapUtilsBuildParameter param, int offsetParam, boolean cleanEmptyChar) throws Exception {
        int i;
        int offset = offsetParam;
        if (cleanEmptyChar) {
            for (i = startFrom; i < byteMsg.length && (char)byteMsg[i] != '<'; ++i) {
            }
        }
        Object xml = "";
        if (byteMsg.length > i + 5) {
            xml = "" + (char)byteMsg[i] + (char)byteMsg[i + 1] + (char)byteMsg[i + 2] + (char)byteMsg[i + 3] + (char)byteMsg[i + 4];
            if (((String)xml).equals("<?xml")) {
                if (param.isEraserXMLTag()) {
                    while (i < byteMsg.length && (char)byteMsg[i] != '>') {
                        ++i;
                    }
                } else {
                    throw new Exception("Tag <?xml non permesso con la funzionalita di imbustamento SOAP");
                }
                offset = i + 1;
                return SoapUtils.readOffsetXmlInstruction(byteMsg, i + 1, param, offset, true);
            }
            return offset;
        }
        return offset;
    }

    public static void saveMessage(String path, OpenSPCoop2Message msg) throws UtilsException {
        FileOutputStream fos = null;
        try {
            File fileMsg = new File(path);
            if (fileMsg.exists()) {
                throw new UtilsException("L'identificativo del Messaggio risulta gia' registrato: " + path);
            }
            fos = new FileOutputStream(path);
            msg.writeTo(fos, true);
            fos.close();
        }
        catch (Exception e) {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new UtilsException("Utilities.saveMessage error " + e.getMessage(), e);
        }
    }
}

