/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.message;

import com.sun.xml.messaging.saaj.packaging.mime.internet.ContentType;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.AttachmentsUtils;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.OpenSPCoop2Message;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.OpenSPCoop2MessageFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.SOAPFaultCode;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.SOAPVersion;
import it.link.pdd.tools.migrazione_govway.utils.Utilities;
import it.link.pdd.tools.migrazione_govway.utils.resources.FileSystemUtilities;
import it.link.pdd.tools.migrazione_govway.utils.resources.MimeTypes;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPFault;
import org.slf4j.Logger;

public class ServletTestService
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    protected Logger log = null;
    protected File repositoryResponseFiles = null;
    protected List<String> whitePropertiesList = null;
    protected boolean genericError = false;

    public ServletTestService(Logger log, File repositoryResponseFiles, List<String> whitePropertiesList, boolean genericError) {
        this.log = log;
        this.repositoryResponseFiles = repositoryResponseFiles;
        this.whitePropertiesList = whitePropertiesList;
        this.genericError = genericError;
    }

    public ServletTestService(Logger log, File repositoryResponseFiles, boolean genericError) {
        this(log, repositoryResponseFiles, null, genericError);
    }

    public ServletTestService(Logger log, File repositoryResponseFiles) {
        this(log, repositoryResponseFiles, null, false);
    }

    public ServletTestService(Logger log) {
        this(log, null, null, false);
    }

    private static String getParameter_checkWhiteList(HttpServletRequest request, List<String> whitePropertiesList, String parameter) {
        String value = request.getParameter(parameter);
        if (value != null) {
            value = value.trim();
        }
        if (whitePropertiesList != null && !whitePropertiesList.contains(parameter)) {
            return null;
        }
        return value;
    }

    public static void checkHttpServletRequestParameter(HttpServletRequest request) throws ServletException {
        ServletTestService.checkHttpServletRequestParameter(request, null);
    }

    private static void checkHttpServletRequestParameter(HttpServletRequest request, List<String> whitePropertiesList) throws ServletException {
        String checkEqualsHttpMethod = ServletTestService.getParameter_checkWhiteList(request, whitePropertiesList, "checkEqualsHttpMethod");
        if (checkEqualsHttpMethod != null && !(checkEqualsHttpMethod = checkEqualsHttpMethod.trim()).equals(request.getMethod())) {
            throw new ServletException("Ricevuta una richiesta con metodo http [" + request.getMethod() + "] differente da quella attesa [" + checkEqualsHttpMethod + "]");
        }
        String checkEqualsHttpHeader = ServletTestService.getParameter_checkWhiteList(request, whitePropertiesList, "checkEqualsHttpHeader");
        if (checkEqualsHttpHeader != null) {
            if (!(checkEqualsHttpHeader = checkEqualsHttpHeader.trim()).contains(":")) {
                throw new ServletException("Ricevuta una richiesta di verifica header non conforme (pattern nome:valore)");
            }
            String[] split = checkEqualsHttpHeader.split(":");
            if (split == null) {
                throw new ServletException("Ricevuta una richiesta di verifica header non conforme (pattern nome:valore) (split null)");
            }
            if (split.length != 2) {
                throw new ServletException("Ricevuta una richiesta di verifica header non conforme (pattern nome:valore) (split:" + split.length + ")");
            }
            String key = split[0];
            String valore = split[1];
            String v = request.getHeader(key);
            if (v == null) {
                v = request.getHeader(key.toLowerCase());
            }
            if (v == null) {
                v = request.getHeader(key.toUpperCase());
            }
            if (v == null) {
                throw new ServletException("Ricevuta una richiesta di verifica header (" + key + ":" + valore + "). Header [" + key + "] non presente");
            }
            if (!v.equals(valore)) {
                throw new ServletException("Ricevuta una richiesta di verifica header (" + key + ":" + valore + "). Valore [" + v + "] differente da quello atteso");
            }
        }
    }

    public void doEngine(HttpServletRequest req, HttpServletResponse res, boolean oneway, Properties headerRisposta) throws ServletException, IOException {
        try {
            String sleep;
            String saveMessageDir;
            String tunnelSoapMimeType;
            ServletTestService.checkHttpServletRequestParameter(req, this.whitePropertiesList);
            boolean chunked = false;
            String chunkedValue = null;
            if (req.getHeader("Transfer-Encoding") != null) {
                chunkedValue = req.getHeader("Transfer-Encoding");
            } else if (req.getHeader("transfer-encoding") != null) {
                chunkedValue = req.getHeader("Transfer-Encoding");
            }
            if (chunkedValue != null && "chunked".equals(chunkedValue = chunkedValue.trim())) {
                chunked = true;
            }
            String fault = ServletTestService.getParameter_checkWhiteList(req, this.whitePropertiesList, "fault");
            String faultActor = "OpenSPCoopTrace";
            String faultSoapVersion = null;
            String faultNamespaceCode = "http://www.openspcoop2.org/example";
            String faultCode = "Server.OpenSPCoopExampleFault";
            String faultMessage = "Fault ritornato dalla servlet di trace, esempio di OpenSPCoop";
            if (fault != null && fault.equalsIgnoreCase("true")) {
                if (ServletTestService.getParameter_checkWhiteList(req, this.whitePropertiesList, "faultActor") != null) {
                    faultActor = ServletTestService.getParameter_checkWhiteList(req, this.whitePropertiesList, "faultActor");
                }
                if (ServletTestService.getParameter_checkWhiteList(req, this.whitePropertiesList, "faultSoapVersion") != null) {
                    faultSoapVersion = ServletTestService.getParameter_checkWhiteList(req, this.whitePropertiesList, "faultSoapVersion");
                }
                if (ServletTestService.getParameter_checkWhiteList(req, this.whitePropertiesList, "faultCode") != null) {
                    faultCode = ServletTestService.getParameter_checkWhiteList(req, this.whitePropertiesList, "faultCode");
                }
                if (ServletTestService.getParameter_checkWhiteList(req, this.whitePropertiesList, "faultNamespaceCode") != null) {
                    faultNamespaceCode = ServletTestService.getParameter_checkWhiteList(req, this.whitePropertiesList, "faultNamespaceCode");
                }
                if (ServletTestService.getParameter_checkWhiteList(req, this.whitePropertiesList, "faultMessage") != null) {
                    faultMessage = ServletTestService.getParameter_checkWhiteList(req, this.whitePropertiesList, "faultMessage");
                }
            }
            String tunnelSoap = ServletTestService.getParameter_checkWhiteList(req, this.whitePropertiesList, "OpenSPCoop2TunnelSOAP");
            boolean tunnel = false;
            if (tunnelSoap != null && "true".equals(tunnelSoap = tunnelSoap.trim())) {
                tunnel = true;
            }
            if ((tunnelSoapMimeType = ServletTestService.getParameter_checkWhiteList(req, this.whitePropertiesList, "OpenSPCoop2TunnelSOAPMimeType")) != null) {
                tunnelSoapMimeType = tunnelSoapMimeType.trim();
            }
            int returnCode = 200;
            String returnCodeString = ServletTestService.getParameter_checkWhiteList(req, this.whitePropertiesList, "returnCode");
            if (returnCodeString != null) {
                try {
                    returnCode = Integer.parseInt(returnCodeString.trim());
                }
                catch (Exception e) {
                    if (this.log != null) {
                        this.log.warn("ERRORE TestService (param returnCode): " + e.toString());
                    }
                    System.out.println("ERRORE TestService (param returnCode): " + e.toString());
                }
            }
            String replace = ServletTestService.getParameter_checkWhiteList(req, this.whitePropertiesList, "replace");
            Hashtable<String, String> replaceMap = new Hashtable<String, String>();
            if (replace != null) {
                if (replace.contains(",")) {
                    String[] list = replace.split(",");
                    for (int i = 0; i < list.length; ++i) {
                        String[] tmp;
                        if (list[i].contains(":")) {
                            tmp = list[i].split(":");
                            if (tmp == null || tmp.length != 2) {
                                throw new Exception("Opzione replace con valore errato [" + list[i] + "] (caso1 iter" + i + "), formato atteso: old:new[,old:new,....,old:new]");
                            }
                        } else {
                            throw new Exception("Opzione replace con valore errato [" + list[i] + "] (caso2 iter" + i + "), formato atteso: old:new[,old:new,....,old:new]");
                        }
                        replaceMap.put(tmp[0], tmp[1]);
                    }
                } else if (replace.contains(":")) {
                    String[] tmp = replace.split(":");
                    if (tmp == null || tmp.length != 2) {
                        throw new Exception("Opzione replace con valore errato [" + replace + "] (caso1), formato atteso: old:new[,old:new,....,old:new]");
                    }
                    replaceMap.put(tmp[0], tmp[1]);
                } else {
                    throw new Exception("Opzione replace con valore errato [" + replace + "] (caso2), formato atteso: old:new[,old:new,....,old:new]");
                }
            }
            String logMessageTmp = ServletTestService.getParameter_checkWhiteList(req, this.whitePropertiesList, "logMessage");
            boolean logMessage = false;
            if (logMessageTmp != null) {
                logMessageTmp = logMessageTmp.trim();
                if ("true".equals(logMessage)) {
                    logMessage = true;
                }
            }
            if ((saveMessageDir = ServletTestService.getParameter_checkWhiteList(req, this.whitePropertiesList, "saveMessageDir")) != null) {
                saveMessageDir = saveMessageDir.trim();
            }
            byte[] contenuto = null;
            if (logMessage || saveMessageDir != null) {
                int read;
                ServletInputStream sin = req.getInputStream();
                ByteArrayOutputStream outStr = new ByteArrayOutputStream();
                while ((read = sin.read()) != -1) {
                    outStr.write(read);
                }
                contenuto = outStr.toByteArray();
            }
            String contentTypeRichiesta = req.getContentType();
            StringBuffer sb = new StringBuffer();
            sb.append("--------  Messaggio ricevuto il : " + new Date().toString() + " [ct:" + contentTypeRichiesta + "] -------------\n\n");
            if (logMessage) {
                sb.append(new String(contenuto));
            }
            if (saveMessageDir != null) {
                File dir = new File(saveMessageDir);
                if (!dir.exists()) {
                    throw new Exception("Directory [" + dir.getAbsolutePath() + "] doesn't exists");
                }
                if (!dir.canWrite()) {
                    throw new Exception("Directory [" + dir.getAbsolutePath() + "] without write permission");
                }
                if (!dir.canRead()) {
                    throw new Exception("Directory [" + dir.getAbsolutePath() + "] without read permission");
                }
                String ext = "bin";
                try {
                    String ct = new String(contentTypeRichiesta);
                    if (ct.contains(";")) {
                        ct = ct.split(";")[0];
                    }
                    ext = MimeTypes.getInstance().getExtension(ct);
                }
                catch (Exception e) {
                    this.log.warn("Riconoscimento ext file tramite contentType[" + contentTypeRichiesta + "] non riuscito: " + e.getMessage(), (Throwable)e);
                }
                File f = File.createTempFile("Message", "." + ext, dir);
                FileSystemUtilities.writeFile(f, contenuto);
                if (logMessage) {
                    sb.append("\n\n");
                }
                sb.append("saved in: " + f.getAbsolutePath());
            }
            if (sb.length() > 0) {
                sb.append("\n\n");
                this.log.info(sb.toString());
            }
            if ((sleep = ServletTestService.getParameter_checkWhiteList(req, this.whitePropertiesList, "sleep")) != null) {
                int millisecond = Integer.parseInt(sleep);
                if (millisecond > 1000) {
                    int count = millisecond / 1000;
                    int resto = millisecond % 1000;
                    this.log.info("sleep " + millisecond + "ms ...");
                    for (int i = 0; i < count; ++i) {
                        Utilities.sleep(1000L);
                    }
                    Utilities.sleep(resto);
                    this.log.info("sleep " + millisecond + "ms terminated");
                } else {
                    this.log.info("sleep " + millisecond + "ms ...");
                    Utilities.sleep(millisecond);
                    this.log.info("sleep " + millisecond + "ms terminated");
                }
            }
            String min = ServletTestService.getParameter_checkWhiteList(req, this.whitePropertiesList, "sleepMin");
            String max = ServletTestService.getParameter_checkWhiteList(req, this.whitePropertiesList, "sleepMax");
            if (max != null) {
                Random r;
                int sleepInteger;
                int maxSleep = Integer.parseInt(max);
                int minSleep = 0;
                if (min != null) {
                    minSleep = Integer.parseInt(min);
                }
                if ((sleepInteger = minSleep + (r = new Random()).nextInt(maxSleep - minSleep)) > 1000) {
                    int count = sleepInteger / 1000;
                    int resto = sleepInteger % 1000;
                    this.log.info("sleep " + sleepInteger + "ms ...");
                    for (int i = 0; i < count; ++i) {
                        Utilities.sleep(1000L);
                    }
                    Utilities.sleep(resto);
                    this.log.info("sleep " + sleepInteger + "ms terminated");
                } else {
                    this.log.info("sleep " + sleepInteger + "ms ...");
                    Utilities.sleep(sleepInteger);
                    this.log.info("sleep " + sleepInteger + "ms terminated");
                }
            }
            if (fault != null && fault.equalsIgnoreCase("true")) {
                SOAPVersion soapVersion = SOAPVersion.SOAP11;
                if (faultSoapVersion != null && "12".equals(faultSoapVersion)) {
                    soapVersion = SOAPVersion.SOAP12;
                }
                OpenSPCoop2MessageFactory factory = OpenSPCoop2MessageFactory.getMessageFactory();
                OpenSPCoop2Message msg = factory.createFaultMessage(soapVersion, faultMessage);
                QName qName = new QName(faultNamespaceCode, faultCode);
                SOAPBody bdy = msg.getSOAPBody();
                SOAPFault f = bdy.getFault();
                msg.setFaultCode(f, SOAPFaultCode.Receiver, qName);
                f.setFaultActor(faultActor);
                msg.saveChanges();
                res.setContentType(msg.getContentType());
                res.setStatus(returnCode);
                ServletOutputStream sout = res.getOutputStream();
                msg.writeTo((OutputStream)sout, true);
            } else {
                if (oneway) {
                    res.setStatus(returnCode);
                    return;
                }
                if (tunnel) {
                    res.setHeader("X-OpenSPCoop2-TunnelSOAP", "true");
                    if (tunnelSoapMimeType != null) {
                        res.setHeader("X-OpenSPCoop2-TunnelSOAP-MimeType", tunnelSoapMimeType);
                    }
                }
                Object contentTypeRisposta = contentTypeRichiesta;
                String fileDestinazione = ServletTestService.getParameter_checkWhiteList(req, this.whitePropertiesList, "destFile");
                String fileResponse = ServletTestService.getParameter_checkWhiteList(req, this.whitePropertiesList, "response");
                if (fileResponse == null) {
                    fileResponse = ServletTestService.getParameter_checkWhiteList(req, this.whitePropertiesList, "op");
                }
                ByteArrayOutputStream boutStaticFile = null;
                if (fileDestinazione != null || fileResponse != null) {
                    String path = null;
                    if (fileDestinazione != null) {
                        path = fileDestinazione = fileDestinazione.trim();
                    } else {
                        path = fileResponse = fileResponse.trim();
                        if (this.repositoryResponseFiles == null) {
                            throw new Exception("Property 'response' non utilizzabile se non viene definito un repository dei files");
                        }
                        File f = new File(this.repositoryResponseFiles, fileResponse);
                        path = f.getAbsolutePath();
                    }
                    FileInputStream fin = new FileInputStream(path);
                    boutStaticFile = new ByteArrayOutputStream();
                    FileSystemUtilities.copy(fin, boutStaticFile);
                    boutStaticFile.flush();
                    boutStaticFile.close();
                    fin.close();
                    String fileDestinazioneContentType = ServletTestService.getParameter_checkWhiteList(req, this.whitePropertiesList, "destFileContentType");
                    if (fileDestinazioneContentType != null) {
                        fileDestinazioneContentType = fileDestinazioneContentType.trim();
                        contentTypeRisposta = fileDestinazioneContentType;
                    } else {
                        if (contentTypeRichiesta != null && !contentTypeRichiesta.contains("multipart/related")) {
                            ContentType cType = new ContentType(contentTypeRichiesta);
                            contentTypeRisposta = cType.getBaseType();
                        } else {
                            contentTypeRisposta = "text/xml";
                        }
                        byte[] a = boutStaticFile.toByteArray();
                        if (AttachmentsUtils.messageWithAttachment(a)) {
                            String IDfirst = AttachmentsUtils.firstContentID(a);
                            String boundary = AttachmentsUtils.findBoundary(a);
                            if (boundary == null) {
                                throw new Exception("Errore avvenuto durante la lettura del boundary associato al multipart message.");
                            }
                            contentTypeRisposta = IDfirst == null ? "multipart/related; type=\"" + (String)contentTypeRisposta + "\"; \tboundary=\"" + boundary.substring(2, boundary.length()) + "\" " : "multipart/related; type=\"" + (String)contentTypeRisposta + "\"; start=\"" + IDfirst + "\"; \tboundary=\"" + boundary.substring(2, boundary.length()) + "\" ";
                        }
                    }
                }
                if (chunked) {
                    res.setHeader("Transfer-Encoding", "chunked");
                } else if (boutStaticFile != null) {
                    res.setContentLength(boutStaticFile.size());
                } else if (contenuto != null) {
                    res.setContentLength(contenuto.length);
                }
                if (headerRisposta != null) {
                    Enumeration<Object> en = headerRisposta.keys();
                    while (en.hasMoreElements()) {
                        String key = (String)en.nextElement();
                        String value = headerRisposta.getProperty(key);
                        if (value == null) continue;
                        res.setHeader(key, value);
                    }
                }
                res.setContentType((String)contentTypeRisposta);
                res.setStatus(returnCode);
                if (boutStaticFile != null) {
                    res.getOutputStream().write(boutStaticFile.toByteArray());
                } else if (contenuto != null) {
                    if (replaceMap != null && replaceMap.size() > 0) {
                        res.getOutputStream().write(this.replace(contenuto, replaceMap));
                    } else {
                        res.getOutputStream().write(contenuto);
                    }
                } else if (replaceMap != null && replaceMap.size() > 0) {
                    byte[] contenutoRequest = Utilities.getAsByteArray((InputStream)req.getInputStream());
                    res.getOutputStream().write(this.replace(contenutoRequest, replaceMap));
                } else {
                    FileSystemUtilities.copy((InputStream)req.getInputStream(), (OutputStream)res.getOutputStream());
                }
                res.getOutputStream().flush();
                res.getOutputStream().close();
            }
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.error("TestService: " + e.getMessage(), e);
            } else {
                System.out.println("ERRORE TestService: " + e.toString());
                e.printStackTrace(System.out);
            }
            if (this.genericError) {
                res.setStatus(500);
                res.getOutputStream().flush();
                res.getOutputStream().close();
            }
            throw new ServletException(e.getMessage(), e);
        }
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doGet(req, res);
    }

    private byte[] replace(byte[] contenuto, Map<String, String> map) {
        String s = new String(contenuto);
        for (String oldValue : map.keySet()) {
            String newValue = map.get(oldValue);
            s = s.replaceAll(oldValue, newValue);
        }
        return s.getBytes();
    }
}

