/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.message;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.mtom.MTOMUtilities;
import java.util.ArrayList;
import javax.mail.internet.ContentType;
import javax.xml.soap.SOAPException;
import org.slf4j.Logger;

public enum SOAPVersion {
    SOAP11,
    SOAP12;

    public static final String SOAP11_MANDATORY_HEADER_HTTP_SOAP_ACTION = "SOAPAction";
    public static final String SOAP12_OPTIONAL_CONTENT_TYPE_PARAMETER_SOAP_ACTION = "action";
    public static final String MEDIA_TYPE_MULTIPART_RELATED = "multipart/related";

    public String getSoapEnvelopeNS() {
        if (this.equals((Object)SOAP11)) {
            return "http://schemas.xmlsoap.org/soap/envelope/";
        }
        return "http://www.w3.org/2003/05/soap-envelope";
    }

    public String getSoapVersionAsString() {
        if (this.equals((Object)SOAP11)) {
            return "SOAP 1.1";
        }
        return "SOAP 1.2";
    }

    public String[] getContentTypes() {
        if (this.equals((Object)SOAP11)) {
            return new String[]{"text/xml", MEDIA_TYPE_MULTIPART_RELATED};
        }
        return new String[]{"application/soap+xml", MEDIA_TYPE_MULTIPART_RELATED};
    }

    public static String[] getKnownContentTypes() {
        return SOAPVersion.getKnownContentTypes(true, true);
    }

    public static String[] getKnownContentTypes(boolean soap11, boolean soap12) {
        ArrayList<String> lista = new ArrayList<String>();
        if (soap11) {
            String[] soap11Array;
            for (String ct : soap11Array = SOAP11.getContentTypes()) {
                if (lista.contains(ct)) continue;
                lista.add(ct);
            }
        }
        if (soap12) {
            String[] soap12Array;
            for (String ct : soap12Array = SOAP12.getContentTypes()) {
                if (lista.contains(ct)) continue;
                lista.add(ct);
            }
        }
        return lista.toArray(new String[1]);
    }

    public static String getKnownContentTypesAsString() {
        return SOAPVersion.getKnownContentTypesAsString(true, true);
    }

    public static String getKnownContentTypesAsString(boolean soap11, boolean soap12) {
        StringBuffer bf = new StringBuffer();
        for (String ct : SOAPVersion.getKnownContentTypes(soap11, soap12)) {
            if (bf.length() > 0) {
                bf.append(", ");
            }
            bf.append(ct);
        }
        return bf.toString();
    }

    public String getContentTypesAsString() {
        StringBuffer bf = new StringBuffer();
        for (String ct : this.getContentTypes()) {
            if (bf.length() > 0) {
                bf.append(", ");
            }
            bf.append(ct);
        }
        return bf.toString();
    }

    public String getContentTypeForMessageWithoutAttachments() {
        if (this.equals((Object)SOAP11)) {
            return "text/xml";
        }
        return "application/soap+xml";
    }

    public static boolean isMtom(Logger log, String cType) {
        try {
            ContentType contentType = new ContentType(cType);
            String baseType = contentType.getBaseType().toLowerCase();
            String soapContentType = null;
            if (baseType == null) {
                soapContentType = null;
            }
            boolean mtom = false;
            if (baseType.equals(MEDIA_TYPE_MULTIPART_RELATED)) {
                String typeParam = contentType.getParameter("type");
                if (typeParam == null) {
                    throw new SOAPException("Missing 'type' parameter in multipart/related");
                }
                soapContentType = typeParam.toLowerCase();
                if ("application/xop+xml".equals(soapContentType)) {
                    mtom = true;
                }
            }
            return mtom;
        }
        catch (Exception e) {
            if (log != null) {
                log.error("Unable to retrive SOAP Version: " + e.getMessage(), (Throwable)e);
            } else {
                e.printStackTrace(System.out);
            }
            return false;
        }
    }

    public static boolean isMultipart(Logger log, String cType) {
        try {
            ContentType contentType = new ContentType(cType);
            String baseType = contentType.getBaseType().toLowerCase();
            return baseType != null && baseType.equals(MEDIA_TYPE_MULTIPART_RELATED);
        }
        catch (Exception e) {
            if (log != null) {
                log.error("Unable to retrive SOAP Version: " + e.getMessage(), (Throwable)e);
            } else {
                e.printStackTrace(System.out);
            }
            return false;
        }
    }

    public static SOAPVersion getVersioneSoap(Logger log, String cType, boolean logError) {
        try {
            ContentType contentType = new ContentType(cType);
            String baseType = contentType.getBaseType().toLowerCase();
            String soapContentType = null;
            if (baseType == null) {
                soapContentType = null;
            }
            boolean mtom = false;
            if (baseType.equals(MEDIA_TYPE_MULTIPART_RELATED)) {
                String typeParam = contentType.getParameter("type");
                if (typeParam == null) {
                    throw new SOAPException("Missing 'type' parameter in multipart/related");
                }
                soapContentType = typeParam.toLowerCase();
                if ("application/xop+xml".equals(soapContentType)) {
                    mtom = true;
                }
            } else {
                soapContentType = baseType;
            }
            if (SOAP11.getContentTypeForMessageWithoutAttachments().equals(soapContentType)) {
                return SOAP11;
            }
            if (SOAP12.getContentTypeForMessageWithoutAttachments().equals(soapContentType)) {
                return SOAP12;
            }
            if (mtom) {
                return MTOMUtilities.readSoapVersionFromMtomContentType(contentType);
            }
            throw new SOAPException("[" + soapContentType + "] non supportato");
        }
        catch (Exception e) {
            if (logError) {
                if (log != null) {
                    log.error("Unable to retrive SOAP Version: " + e.getMessage(), (Throwable)e);
                } else {
                    e.printStackTrace(System.out);
                }
            }
            return null;
        }
    }
}

