/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.message;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.MessageUtils;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.OpenSPCoop2Message;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.OpenSPCoop2MessageFactory_impl;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.OpenSPCoop2MessageParseResult;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.SOAPVersion;
import it.link.pdd.tools.migrazione_govway.utils.LoggerWrapperFactory;
import it.link.pdd.tools.migrazione_govway.utils.io.notifier.NotifierInputStream;
import it.link.pdd.tools.migrazione_govway.utils.io.notifier.NotifierInputStreamParams;
import it.link.pdd.tools.migrazione_govway.utils.resources.Loader;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.SequenceInputStream;
import java.util.Vector;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPMessage;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class OpenSPCoop2MessageFactory {
    private static Logger logger = LoggerWrapperFactory.getLogger(OpenSPCoop2MessageFactory.class);
    public static String messageFactoryImpl = OpenSPCoop2MessageFactory_impl.class.getName();
    protected static OpenSPCoop2MessageFactory openspcoopMessageFactory = null;
    protected static SOAPFactory soapFactory11 = null;
    protected static SOAPFactory soapFactory12 = null;
    protected static MessageFactory soapMessageFactory = null;

    public abstract String getDocumentBuilderFactoryClass();

    public static void setMessageFactoryImpl(String messageFactoryImpl) {
        if (messageFactoryImpl != null) {
            OpenSPCoop2MessageFactory.messageFactoryImpl = messageFactoryImpl;
        }
    }

    public static OpenSPCoop2MessageFactory getMessageFactory() {
        if (openspcoopMessageFactory == null) {
            try {
                OpenSPCoop2MessageFactory.initMessageFactory();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return openspcoopMessageFactory;
    }

    public static void initMessageFactory() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        OpenSPCoop2MessageFactory.initMessageFactory(false);
    }

    public static void initMessageFactory(boolean force) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        if (openspcoopMessageFactory == null || force) {
            openspcoopMessageFactory = (OpenSPCoop2MessageFactory)Loader.getInstance().newInstance(messageFactoryImpl);
        }
    }

    public SOAPFactory getSoapFactory11() {
        if (soapFactory11 == null) {
            this.initSoapFactory();
        }
        return soapFactory11;
    }

    public SOAPFactory getSoapFactory12() {
        if (soapFactory12 == null) {
            this.initSoapFactory();
        }
        return soapFactory12;
    }

    protected abstract void initSoapFactory();

    public MessageFactory getSoapMessageFactory() throws SOAPException {
        if (soapMessageFactory == null) {
            this.initSoapMessageFactory();
        }
        return soapMessageFactory;
    }

    protected abstract void initSoapMessageFactory() throws SOAPException;

    protected final String getContentType(MimeHeaders headers) {
        String[] values = headers.getHeader("Content-Type");
        if (values == null) {
            return null;
        }
        return values[0];
    }

    public abstract SOAPConnectionFactory getSOAPConnectionFactory() throws SOAPException;

    protected abstract OpenSPCoop2Message _createMessage(SOAPVersion var1);

    protected abstract OpenSPCoop2Message _createMessage(SOAPVersion var1, SOAPMessage var2);

    protected abstract OpenSPCoop2Message _createMessage(MimeHeaders var1, InputStream var2, boolean var3, String var4, String var5, long var6) throws SOAPException, IOException;

    public abstract Element convertoForXPathSearch(Element var1);

    public abstract void normalizeDocument(Document var1);

    private OpenSPCoop2MessageParseResult _internalCreateMessage(MimeHeaders mhs, InputStream is, NotifierInputStreamParams notifierInputStreamParams, boolean fileCacheEnable, String attachmentRepoDir, String fileThreshold, long overhead) {
        OpenSPCoop2MessageParseResult result = new OpenSPCoop2MessageParseResult();
        try {
            InputStream nis = null;
            if (is == null) {
                throw new Exception("Original InputStream undefined");
            }
            if (notifierInputStreamParams != null) {
                String[] headerContentType = null;
                if (mhs != null) {
                    headerContentType = mhs.getHeader("Content-Type");
                }
                String contentType = null;
                contentType = headerContentType != null && headerContentType.length > 0 ? headerContentType[0] : "text/xml";
                nis = new NotifierInputStream(is, contentType, notifierInputStreamParams);
            } else {
                nis = is;
            }
            OpenSPCoop2Message op2Msg = this._createMessage(mhs, nis, fileCacheEnable, attachmentRepoDir, fileThreshold, overhead);
            if (op2Msg == null) {
                throw new Exception("Create message failed");
            }
            if (notifierInputStreamParams != null) {
                op2Msg.setNotifierInputStream((NotifierInputStream)nis);
            }
            result.setMessage(op2Msg);
        }
        catch (Throwable t) {
            result.setParseException(MessageUtils.buildParseException(t));
        }
        return result;
    }

    public OpenSPCoop2MessageParseResult createMessage(MimeHeaders mhs, InputStream is, NotifierInputStreamParams notifierInputStreamParams, boolean fileCacheEnable, String attachmentRepoDir, String fileThreshold, long overhead) {
        return this._internalCreateMessage(mhs, is, notifierInputStreamParams, fileCacheEnable, attachmentRepoDir, fileThreshold, overhead);
    }

    public OpenSPCoop2MessageParseResult createMessage(HttpServletRequest req, NotifierInputStreamParams notifierInputStreamParams, boolean fileCacheEnable, String attachmentRepoDir, String fileThreshold) {
        return this.createMessage(req, notifierInputStreamParams, fileCacheEnable, attachmentRepoDir, fileThreshold, 0L);
    }

    public OpenSPCoop2MessageParseResult createMessage(HttpServletRequest req, NotifierInputStreamParams notifierInputStreamParams, boolean fileCacheEnable, String attachmentRepoDir, String fileThreshold, long overhead) {
        MimeHeaders mhs = null;
        ServletInputStream is = null;
        try {
            mhs = new MimeHeaders();
            mhs.addHeader("Content-Type", req.getContentType());
            mhs.addHeader("SOAPAction", req.getHeader("SOAPAction"));
            is = req.getInputStream();
            if (is == null) {
                throw new Exception("Original InputStream undefined");
            }
        }
        catch (Throwable t) {
            OpenSPCoop2MessageParseResult result = new OpenSPCoop2MessageParseResult();
            result.setParseException(MessageUtils.buildParseException(t));
            return result;
        }
        return this._internalCreateMessage(mhs, (InputStream)is, notifierInputStreamParams, fileCacheEnable, attachmentRepoDir, fileThreshold, overhead);
    }

    public OpenSPCoop2MessageParseResult createMessage(InputStream messageInput, NotifierInputStreamParams notifierInputStreamParams, boolean isBodyStream, String contentTypeParam, String contentLocation, boolean fileCacheEnable, String attachmentRepoDir, String fileThreshold) {
        try {
            OpenSPCoop2MessageParseResult result;
            long diff = 0L;
            if (messageInput == null) {
                throw new Exception("Original InputStream undefined");
            }
            SOAPVersion soapVersion = SOAPVersion.getVersioneSoap(logger, contentTypeParam, true);
            if (isBodyStream) {
                Vector<InputStream> streams = new Vector<InputStream>();
                byte[] start = null;
                byte[] end = null;
                if (SOAPVersion.SOAP12.equals((Object)soapVersion)) {
                    start = "<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://www.w3.org/2003/05/soap-envelope\"><SOAP-ENV:Body>".getBytes();
                    end = "</SOAP-ENV:Body></SOAP-ENV:Envelope>".getBytes();
                } else {
                    start = "<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"><SOAP-ENV:Body>".getBytes();
                    end = "</SOAP-ENV:Body></SOAP-ENV:Envelope>".getBytes();
                }
                diff += (long)(start.length + end.length);
                streams.add(new ByteArrayInputStream(start));
                streams.add(messageInput);
                streams.add(new ByteArrayInputStream(end));
                messageInput = new SequenceInputStream(streams.elements());
            }
            MimeHeaders mhs = new MimeHeaders();
            mhs.addHeader("Content-Type", contentTypeParam);
            if (contentLocation != null) {
                mhs.addHeader("Content-Location", contentLocation);
            }
            if ((result = this._internalCreateMessage(mhs, messageInput, notifierInputStreamParams, fileCacheEnable, attachmentRepoDir, fileThreshold, diff)).getMessage() != null) {
                try {
                    result.getMessage().getSOAPPart().getEnvelope();
                }
                catch (Throwable soapException) {
                    result.setMessage(null);
                    result.setParseException(MessageUtils.buildParseException(soapException));
                }
            }
            return result;
        }
        catch (Throwable t) {
            OpenSPCoop2MessageParseResult result = new OpenSPCoop2MessageParseResult();
            result.setParseException(MessageUtils.buildParseException(t));
            return result;
        }
    }

    public OpenSPCoop2MessageParseResult createMessage(SOAPVersion versioneSoap, byte[] xml) {
        return this.createMessage(versioneSoap, xml, null);
    }

    public OpenSPCoop2MessageParseResult createMessage(SOAPVersion versioneSoap, byte[] xml, NotifierInputStreamParams notifierInputStreamParams) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(xml);
            MimeHeaders mhs = new MimeHeaders();
            if (versioneSoap.equals((Object)SOAPVersion.SOAP12)) {
                mhs.addHeader("Content-Type", "application/soap+xml");
            } else {
                mhs.addHeader("Content-Type", "text/xml");
            }
            return this._internalCreateMessage(mhs, bais, notifierInputStreamParams, false, null, null, 0L);
        }
        catch (Throwable t) {
            OpenSPCoop2MessageParseResult result = new OpenSPCoop2MessageParseResult();
            result.setParseException(MessageUtils.buildParseException(t));
            return result;
        }
    }

    public OpenSPCoop2MessageParseResult createMessage(SOAPVersion versioneSoap, String xml) {
        return this.createMessage(versioneSoap, xml, null);
    }

    public OpenSPCoop2MessageParseResult createMessage(SOAPVersion versioneSoap, String xml, NotifierInputStreamParams notifierInputStreamParams) {
        return this.createMessage(versioneSoap, xml.getBytes(), notifierInputStreamParams);
    }

    public OpenSPCoop2Message createMessage(SOAPVersion versioneSoap) {
        return this._createMessage(versioneSoap);
    }

    public OpenSPCoop2Message createMessage(SOAPVersion versioneSoap, SOAPMessage msg) {
        return this._createMessage(versioneSoap, msg);
    }

    public OpenSPCoop2Message createEmptySOAPMessage(SOAPVersion versioneSoap) {
        return this.createEmptySOAPMessage(versioneSoap, null);
    }

    public OpenSPCoop2Message createEmptySOAPMessage(SOAPVersion versioneSoap, NotifierInputStreamParams notifierInputStreamParams) {
        try {
            byte[] xml = null;
            MimeHeaders mhs = new MimeHeaders();
            if (versioneSoap.equals((Object)SOAPVersion.SOAP12)) {
                xml = "<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://www.w3.org/2003/05/soap-envelope\"><SOAP-ENV:Body/></SOAP-ENV:Envelope>".getBytes();
                mhs.addHeader("Content-Type", "application/soap+xml");
            } else {
                xml = "<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"><SOAP-ENV:Body/></SOAP-ENV:Envelope>".getBytes();
                mhs.addHeader("Content-Type", "text/xml");
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(xml);
            OpenSPCoop2MessageParseResult result = this._internalCreateMessage(mhs, bais, notifierInputStreamParams, false, null, null, xml.length);
            if (result.getParseException() != null) {
                throw result.getParseException().getSourceException();
            }
            return result.getMessage();
        }
        catch (Throwable e) {
            System.err.println("Exception non gestibile durante la creazione di un messaggio vuoto. " + e);
            e.printStackTrace(System.err);
            return null;
        }
    }

    public OpenSPCoop2Message createFaultMessage(SOAPVersion versioneSoap, Throwable t) {
        return this.createFaultMessage(versioneSoap, t, null);
    }

    public OpenSPCoop2Message createFaultMessage(SOAPVersion versioneSoap, Throwable t, NotifierInputStreamParams notifierInputStreamParams) {
        return this.createFaultMessage(versioneSoap, t.getMessage(), notifierInputStreamParams);
    }

    public OpenSPCoop2Message createFaultMessage(SOAPVersion versioneSoap, String errore) {
        return this.createFaultMessage(versioneSoap, errore, null);
    }

    public OpenSPCoop2Message createFaultMessage(SOAPVersion versioneSoap, String errore, NotifierInputStreamParams notifierInputStreamParams) {
        try {
            String xml = null;
            MimeHeaders mhs = new MimeHeaders();
            if (versioneSoap.equals((Object)SOAPVersion.SOAP12)) {
                xml = "<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://www.w3.org/2003/05/soap-envelope\"><SOAP-ENV:Header/><SOAP-ENV:Body><SOAP-ENV:Fault><SOAP-ENV:Code><SOAP-ENV:Value>SOAP-ENV:Server</SOAP-ENV:Value></SOAP-ENV:Code><SOAP-ENV:Reason><SOAP-ENV:Text xml:lang=\"en-US\">" + errore + "</SOAP-ENV:Text></SOAP-ENV:Reason><SOAP-ENV:Role>OpenSPCoop2</SOAP-ENV:Role></SOAP-ENV:Fault></SOAP-ENV:Body></SOAP-ENV:Envelope>";
                mhs.addHeader("Content-Type", "application/soap+xml");
            } else {
                xml = "<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"><SOAP-ENV:Header/><SOAP-ENV:Body><SOAP-ENV:Fault><faultcode>SOAP-ENV:Server</faultcode><faultstring>" + errore + "</faultstring><faultactor>OpenSPCoop2</faultactor></SOAP-ENV:Fault></SOAP-ENV:Body></SOAP-ENV:Envelope>";
                mhs.addHeader("Content-Type", "text/xml");
            }
            byte[] xmlByte = xml.getBytes();
            ByteArrayInputStream bais = new ByteArrayInputStream(xmlByte);
            OpenSPCoop2MessageParseResult result = this._internalCreateMessage(mhs, bais, notifierInputStreamParams, false, null, null, xmlByte.length);
            if (result.getParseException() != null) {
                throw result.getParseException().getSourceException();
            }
            return result.getMessage();
        }
        catch (Throwable e) {
            System.err.println("Exception non gestibile durante la creazione di un SOAPFault. " + e);
            e.printStackTrace(System.err);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String convertStreamToString(InputStream is) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                sb.append(line + "\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return sb.toString();
    }
}

