/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.message;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.OpenSPCoop2DataContentHandlerInputStream;
import it.link.pdd.tools.migrazione_govway.utils.resources.Loader;
import java.awt.datatransfer.DataFlavor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.ActivationDataFlavor;
import javax.activation.DataContentHandler;
import javax.activation.DataSource;
import org.apache.soap.encoding.soapenc.Base64;

public class OpenSPCoop2DataContentHandler
implements DataContentHandler {
    public static final String OPENSPCOOP2_SIGNATURE = "===SIGNATURE=OPENSPCOOP2===";

    public static Object getContent(InputStream inputstream) throws IOException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            byte[] bRead = new byte[8094];
            int byteLetti = 0;
            while ((byteLetti = inputstream.read(bRead)) != -1) {
                bout.write(bRead, 0, byteLetti);
            }
            bout.flush();
            bout.close();
            if (bout.size() <= OPENSPCOOP2_SIGNATURE.length()) {
                throw new Exception("OpenSPCoop2DataContentHandler Signature non presente (length is too small)");
            }
            boolean giaCodificato = true;
            String attach = bout.toString();
            for (int i = 0; i < OPENSPCOOP2_SIGNATURE.length(); ++i) {
                if (attach.charAt(i) == OPENSPCOOP2_SIGNATURE.charAt(i)) continue;
                giaCodificato = false;
                break;
            }
            if (!giaCodificato) {
                throw new Exception("OpenSPCoop2DataContentHandler Signature non presente");
            }
            attach = attach.substring(OPENSPCOOP2_SIGNATURE.length(), attach.length());
            OpenSPCoop2DataContentHandlerInputStream bin = new OpenSPCoop2DataContentHandlerInputStream(Base64.decode((String)attach));
            return bin;
        }
        catch (Exception e) {
            throw new IOException("@@@ OpenSPCoop2DataContentHandler.getContent() error: " + e.getMessage());
        }
    }

    public Object getContent(DataSource datasource) throws IOException {
        try {
            InputStream inputstream = datasource.getInputStream();
            return OpenSPCoop2DataContentHandler.getContent(inputstream);
        }
        catch (Exception e) {
            throw new IOException("@@@ OpenSPCoop2DataContentHandler.getContent() error: " + e.getMessage());
        }
    }

    public Object getTransferData(DataFlavor dataflavor, DataSource datasource) throws IOException {
        return null;
    }

    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] adataflavor = new DataFlavor[1];
        try {
            adataflavor[0] = new ActivationDataFlavor(Loader.getInstance().forName("it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.OpenSPCoop2DataContentHandler"), "application/openspcoop2", "OpenSPCoop2AttachmentsTunnel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return adataflavor;
    }

    public void writeTo(Object obj, String s, OutputStream outputstream) throws IOException {
        try {
            byte[] content = null;
            if (obj instanceof InputStream) {
                InputStream inputstream = (InputStream)obj;
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                byte[] bRead = new byte[8094];
                int byteLetti = 0;
                while ((byteLetti = inputstream.read(bRead)) != -1) {
                    bout.write(bRead, 0, byteLetti);
                }
                bout.flush();
                bout.close();
                content = bout.toByteArray();
            } else {
                content = (byte[])obj;
            }
            boolean giaCodificato = true;
            if (content.length >= OPENSPCOOP2_SIGNATURE.length() + 1) {
                for (int i = 0; i < OPENSPCOOP2_SIGNATURE.length(); ++i) {
                    if ((char)content[i] == OPENSPCOOP2_SIGNATURE.charAt(i)) continue;
                    giaCodificato = false;
                    break;
                }
            }
            if (giaCodificato) {
                outputstream.write(content);
            } else {
                String encoded = OPENSPCOOP2_SIGNATURE + Base64.encode((byte[])content);
                outputstream.write(encoded.getBytes());
            }
        }
        catch (Exception exception) {
            throw new IOException("@@@ OpenSPCoop2DataContentHandler.writeTo: Unable to run the Binary decoding on a stream " + exception.getMessage());
        }
    }
}

