/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.message;

import com.ctc.wstx.exc.WstxException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.MailcapActivationReader;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.OpenSPCoop2Message;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.ParseException;
import it.link.pdd.tools.migrazione_govway.utils.Utilities;
import it.link.pdd.tools.migrazione_govway.utils.xml.PrettyPrintXMLUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.net.SocketException;
import java.util.Iterator;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.Text;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MessageUtils {
    public static void equalsSoapElements(SOAPElement element1, SOAPElement element2, boolean checkTextComment) throws TransformerException, IOException {
        try {
            MessageUtils.equalsSoapElements(element1, element2, new Vector<String>(), checkTextComment);
        }
        catch (Exception e) {
            String soapReq = PrettyPrintXMLUtils.prettyPrintWithTrAX((Element)element1);
            String soapRes = PrettyPrintXMLUtils.prettyPrintWithTrAX((Element)element2);
            throw new IOException("Element1 [" + soapReq + "] risulta differente da Element2 [" + soapRes + "] (motivo:" + e.getMessage() + ")", e);
        }
    }

    private static String getQualifiedName(QName attr) {
        if (attr.getNamespaceURI() != null) {
            return "{" + attr.getNamespaceURI() + " }" + attr.getLocalPart();
        }
        return attr.getLocalPart();
    }

    private static void equalsSoapElements(SOAPElement el1, SOAPElement el2, Vector<String> namespacePrefixEl1, boolean checkTextComment) throws IOException {
        if (!el1.getNodeName().equals(el2.getNodeName())) {
            throw new IOException("Node1 possiede un nome [" + el1.getNodeName() + "] differente dal nome del Node2 [" + el2.getNodeName() + "]");
        }
        Iterator it = el1.getAllAttributesAsQNames();
        Iterator it2 = el2.getAllAttributesAsQNames();
        Vector<String> vet = new Vector<String>();
        Vector<String> vet2 = new Vector<String>();
        while (it.hasNext()) {
            if (!it2.hasNext()) {
                throw new IOException("Node1 [" + el1.getNodeName() + "] possiede degli attributi, mentre nel node2 [" + el2.getNodeName() + "] non ve ne sono");
            }
            QName attr1 = (QName)it.next();
            vet.add(MessageUtils.getQualifiedName(attr1));
            QName attr2 = (QName)it2.next();
            vet2.add(MessageUtils.getQualifiedName(attr2));
        }
        if (it2.hasNext()) {
            throw new IOException("Node2 [" + el2.getNodeName() + "] possiede piu' attributi del Node1 [" + el1.getNodeName() + "]");
        }
        if (!vet.containsAll(vet2)) {
            StringBuffer bfNode1 = new StringBuffer();
            for (int i = 0; i < vet.size(); ++i) {
                if (i > 0) {
                    bfNode1.append(",");
                }
                bfNode1.append((String)vet.get(i));
            }
            StringBuffer bfNode2 = new StringBuffer();
            for (int i = 0; i < vet2.size(); ++i) {
                if (i > 0) {
                    bfNode2.append(",");
                }
                bfNode2.append((String)vet2.get(i));
            }
            throw new IOException("Node1 [" + el1.getNodeName() + "] e Node2 [" + el2.getNodeName() + "] non hanno gli stessi attributi. Attributi(" + vet.size() + ") di Node1: " + bfNode1 + " . Attributi(" + vet2.size() + ") di Node2: " + bfNode2);
        }
        for (int i = 0; i < vet.size(); ++i) {
            String value = (String)vet.get(i);
            if (el1.getAttribute(value).equals(el2.getAttribute(value))) continue;
            throw new IOException("L'attributo [" + value + "] di Node1 [" + el1.getNodeName() + "] possiede un valore (" + el1.getAttribute(value) + ") differente dal valore presente nello stesso attributo nel Node2 [" + el2.getNodeName() + "] (valore:" + el2.getAttribute(value) + ")");
        }
        String str1 = el1.getNamespaceURI();
        String str2 = el2.getNamespaceURI();
        boolean namespaceIdentico = false;
        if (str1 != null && str2 != null) {
            namespaceIdentico = str1.equals(str2);
        } else if (str1 == null && str2 == null) {
            namespaceIdentico = true;
        }
        if (!namespaceIdentico) {
            throw new IOException("Node1 [" + el1.getNodeName() + "] possiede un namespace [" + str1 + "] differente dal namespace del Node2 [" + el2.getNodeName() + "] (namespace:" + str2 + ")");
        }
        Iterator nameSp1 = el1.getNamespacePrefixes();
        Iterator nameSp2 = el2.getNamespacePrefixes();
        Vector<CallSite> nameSpVet1 = new Vector<CallSite>();
        Vector<CallSite> nameSpVet2 = new Vector<CallSite>();
        while (nameSp1.hasNext() && nameSp2.hasNext()) {
            String urlPrefix2;
            String urlPrefix1;
            String prefix1 = (String)nameSp1.next();
            try {
                urlPrefix1 = el1.getNamespaceURI(prefix1);
            }
            catch (Exception e) {
                urlPrefix1 = el1.getNamespaceURI();
            }
            nameSpVet1.add((CallSite)((Object)(prefix1 + "=" + urlPrefix1)));
            if (!namespacePrefixEl1.contains(prefix1 + "=" + urlPrefix1)) {
                namespacePrefixEl1.add(prefix1 + "=" + urlPrefix1);
            }
            String prefix2 = (String)nameSp2.next();
            try {
                urlPrefix2 = el2.getNamespaceURI(prefix2);
            }
            catch (Exception e) {
                urlPrefix2 = el2.getNamespaceURI();
            }
            nameSpVet2.add((CallSite)((Object)(prefix2 + "=" + urlPrefix2)));
        }
        for (int i = 0; i < nameSpVet1.size(); ++i) {
            String n1 = (String)nameSpVet1.get(i);
            boolean trovato = false;
            for (int j = 0; j < nameSpVet2.size(); ++j) {
                String n2 = (String)nameSpVet2.get(j);
                if (!n1.equals(n2)) continue;
                trovato = true;
                break;
            }
            if (trovato || namespacePrefixEl1.contains(n1)) continue;
            throw new IOException("Node1 [" + el1.getNodeName() + "] non contiene il prefix: " + n1);
        }
        if (nameSpVet1.size() != nameSpVet2.size()) {
            StringBuffer bfNode1 = new StringBuffer();
            for (int i = 0; i < nameSpVet1.size(); ++i) {
                if (i > 0) {
                    bfNode1.append(",");
                }
                bfNode1.append((String)nameSpVet1.get(i));
            }
            StringBuffer bfNode2 = new StringBuffer();
            for (int i = 0; i < nameSpVet2.size(); ++i) {
                if (i > 0) {
                    bfNode2.append(",");
                }
                bfNode2.append((String)nameSpVet2.get(i));
            }
            throw new IOException("Node1 [" + el1.getNodeName() + "] e Node2 [" + el2.getNodeName() + "] non hanno gli stessi prefix. Attributi(" + nameSpVet1.size() + ") di Node1: " + bfNode1 + " . Attributi(" + nameSpVet2.size() + ") di Node2: " + bfNode2);
        }
        Iterator child = el1.getChildElements();
        Iterator child2 = el2.getChildElements();
        while (child.hasNext()) {
            if (checkTextComment && !child2.hasNext()) {
                throw new IOException("Node2 [" + el2.getNodeName() + "] non ha child element, mentre il Node1 [" + el1.getNodeName() + "] ne possiede");
            }
            Object obj = null;
            if (child.hasNext()) {
                obj = child.next();
            }
            Object obj2 = null;
            if (child2.hasNext()) {
                obj2 = child2.next();
            }
            if (!checkTextComment) {
                while (obj != null && obj instanceof Text) {
                    if (child.hasNext()) {
                        obj = child.next();
                        continue;
                    }
                    obj = null;
                }
                while (obj2 != null && obj2 instanceof Text) {
                    if (child2.hasNext()) {
                        obj2 = child2.next();
                        continue;
                    }
                    obj2 = null;
                }
                if (obj == null) {
                    if (obj2 == null) break;
                    throw new IOException("Node2 [" + el2.getNodeName() + "] possiede ulteriori child element (" + ((SOAPElement)obj2).getNodeName() + ") non presenti nel Node1 [" + el1.getNodeName() + "]");
                }
                if (obj2 == null) {
                    throw new IOException("Node1 [" + el1.getNodeName() + "] possiede ulteriori child element (" + ((SOAPElement)obj).getNodeName() + ") non presenti nel Node2 [" + el2.getNodeName() + "]");
                }
            }
            if (obj instanceof Text) {
                Text text = obj;
                if (!(obj2 instanceof Text)) {
                    throw new IOException("Node2 [" + el2.getNodeName() + "] non possiede l'element Text presente nel Node1 [" + el1.getNodeName() + "] (valore: " + text.toString() + ")");
                }
                Text text2 = obj2;
                boolean value = text.toString().equals(text2.toString());
                if (value) continue;
                throw new IOException("Node2 [" + el2.getNodeName() + "] possiede un element Text con valore (" + text2.toString() + ") differente da quello presente nel Node1 [" + el1.getNodeName() + "] (valore:" + text.toString() + ")");
            }
            if (obj2 instanceof Text) {
                throw new IOException("Node2 [" + el2.getNodeName() + "] possiede un element Text (" + ((Text)obj2).toString() + ") non presente nel Node1 [" + el1.getNodeName() + "]");
            }
            Vector namespacePrefixEl1Parent = (Vector)namespacePrefixEl1.clone();
            MessageUtils.equalsSoapElements(obj, obj2, namespacePrefixEl1Parent, checkTextComment);
        }
    }

    public static String dumpMessage(OpenSPCoop2Message msg, boolean dumpAllAttachments) throws SOAPException, IOException {
        StringBuffer out = new StringBuffer();
        out.append("------ SOAPEnvelope ------\n");
        out.append(msg.getAsString((Node)msg.getSOAPPart().getEnvelope(), false));
        Iterator<?> it = msg.getAttachments();
        while (it.hasNext()) {
            AttachmentPart ap = (AttachmentPart)it.next();
            if (ap.getContentId() != null) {
                out.append("\n------ Attachment id[" + ap.getContentId() + "]------");
            } else if (ap.getContentLocation() != null) {
                out.append("\n------ Attachment location[" + ap.getContentLocation() + "]------");
            }
            out.append("\nId[" + ap.getContentId() + "] location[" + ap.getContentLocation() + "] type[" + ap.getContentType() + "]: ");
            if (dumpAllAttachments) {
                out.append(MessageUtils.dumpAttachment(msg, ap));
                continue;
            }
            Object o = ap.getDataHandler().getContent();
            if ("application/openspcoop2".equals(ap.getContentType())) {
                MessageUtils.rebuildAttachmentAsByteArray(msg, ap);
            }
            if (o instanceof String) {
                out.append((String)o);
                continue;
            }
            out.append("Contenuto attachments non \u00e8 visualizzabile, tipo: " + o.getClass().getName());
        }
        return out.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String dumpAttachment(OpenSPCoop2Message msg, AttachmentPart ap) throws SOAPException, IOException {
        Object o = MessageUtils._dumpAttachment(msg, ap);
        if (o == null) {
            throw new SOAPException("Dump error (return null reference)");
        }
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof ByteArrayOutputStream) {
            ByteArrayOutputStream bout = null;
            try {
                bout = (ByteArrayOutputStream)o;
                String string = bout.toString();
                return string;
            }
            finally {
                try {
                    if (bout != null) {
                        bout.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        throw new SOAPException("Dump error (return type " + o.getClass().getName() + " unknown)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] dumpAttachmentAsByteArray(OpenSPCoop2Message msg, AttachmentPart ap) throws SOAPException, IOException {
        Object o = MessageUtils._dumpAttachment(msg, ap);
        if (o == null) {
            throw new SOAPException("Dump error (return null reference)");
        }
        if (o instanceof String) {
            return ((String)o).getBytes();
        }
        if (o instanceof ByteArrayOutputStream) {
            ByteArrayOutputStream bout = null;
            try {
                bout = (ByteArrayOutputStream)o;
                byte[] byArray = bout.toByteArray();
                return byArray;
            }
            finally {
                try {
                    if (bout != null) {
                        bout.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        throw new SOAPException("Dump error (return type " + o.getClass().getName() + " unknown)");
    }

    private static Object _dumpAttachment(OpenSPCoop2Message msg, AttachmentPart ap) throws SOAPException, IOException {
        ByteArrayOutputStream bout = null;
        Object o = ap.getDataHandler().getContent();
        String s = null;
        if (o != null) {
            if (o instanceof byte[]) {
                byte[] b = (byte[])o;
                bout = new ByteArrayOutputStream();
                bout.write(b);
                bout.flush();
                bout.close();
            } else if (o instanceof InputStream) {
                InputStream is = (InputStream)o;
                bout = new ByteArrayOutputStream();
                byte[] readB = new byte[8192];
                int readByte = 0;
                while ((readByte = is.read(readB)) != -1) {
                    bout.write(readB, 0, readByte);
                }
                is.close();
                bout.flush();
                bout.close();
            } else if (o instanceof String) {
                s = (String)o;
                bout = new ByteArrayOutputStream();
                bout.write(s.getBytes());
                bout.flush();
                bout.close();
            } else {
                DataHandler dh = ap.getDataHandler();
                InputStream inputDH = dh.getInputStream();
                bout = new ByteArrayOutputStream();
                byte[] readB = new byte[8192];
                int readByte = 0;
                while ((readByte = inputDH.read(readB)) != -1) {
                    bout.write(readB, 0, readByte);
                }
                inputDH.close();
                bout.flush();
                bout.close();
            }
        } else {
            DataHandler dh = ap.getDataHandler();
            InputStream inputDH = dh.getInputStream();
            bout = new ByteArrayOutputStream();
            byte[] readB = new byte[8192];
            int readByte = 0;
            while ((readByte = inputDH.read(readB)) != -1) {
                bout.write(readB, 0, readByte);
            }
            inputDH.close();
            bout.flush();
            bout.close();
        }
        if ("application/openspcoop2".equals(ap.getContentType())) {
            MessageUtils.rebuildAttachmentAsByteArray(msg, ap);
        } else if (MailcapActivationReader.existsDataContentHandler(ap.getContentType())) {
            if (ap.getContentType() != null && ap.getContentType().startsWith("text/plain")) {
                if (s != null) {
                    msg.updateAttachmentPart(ap, s, ap.getContentType());
                } else {
                    msg.updateAttachmentPart(ap, bout.toString(), ap.getContentType());
                }
            } else {
                msg.updateAttachmentPart(ap, bout.toByteArray(), ap.getContentType());
            }
        }
        if (s != null) {
            return s;
        }
        return bout;
    }

    private static void rebuildAttachmentAsByteArray(OpenSPCoop2Message msg, AttachmentPart ap) throws SOAPException, IOException {
        DataHandler dh = ap.getDataHandler();
        InputStream inputDH = dh.getInputStream();
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] readB = new byte[8192];
        int readByte = 0;
        while ((readByte = inputDH.read(readB)) != -1) {
            bout.write(readB, 0, readByte);
        }
        inputDH.close();
        bout.flush();
        bout.close();
        msg.updateAttachmentPart(ap, bout.toByteArray(), ap.getContentType());
    }

    public static ParseException buildParseException(Throwable e) {
        ParseException pe = new ParseException();
        pe.setSourceException(e);
        if (e == null) {
            pe.setParseException(new Exception("Occurs Parsing Error"));
            pe.setSourceException(new Exception("Occurs Parsing Error"));
            return pe;
        }
        Throwable tmp = MessageUtils.getParseException(e);
        if (tmp != null) {
            pe.setParseException(tmp);
            return pe;
        }
        pe.setParseException(MessageUtils.getInnerNotEmptyMessageException(e));
        return pe;
    }

    public static Throwable getParseException(Throwable e) {
        if (e instanceof SocketException) {
            return null;
        }
        if (Utilities.existsInnerException(e, SocketException.class)) {
            return null;
        }
        boolean found = false;
        Throwable tmp = null;
        if (tmp == null) {
            if (Utilities.isExceptionInstanceOf("org.apache.axiom.om.OMException", e)) {
                tmp = e;
            } else if (Utilities.existsInnerException(e, "org.apache.axiom.om.OMException")) {
                tmp = Utilities.getInnerException(e, "org.apache.axiom.om.OMException");
            }
            if (tmp != null && (tmp.getMessage() == null || "".equals(tmp.getMessage()) || "null".equalsIgnoreCase(tmp.getMessage()))) {
                tmp = null;
                found = true;
            }
        }
        if (tmp == null) {
            if (e instanceof WstxException) {
                tmp = e;
            } else if (Utilities.existsInnerException(e, WstxException.class)) {
                tmp = Utilities.getInnerException(e, WstxException.class);
            }
            if (tmp != null && (tmp.getMessage() == null || "".equals(tmp.getMessage()) || "null".equalsIgnoreCase(tmp.getMessage()))) {
                tmp = null;
                found = true;
            }
        }
        if (tmp == null) {
            if (Utilities.isExceptionInstanceOf("com.ctc.wstx.exc.WstxIOException", e)) {
                tmp = e;
            } else if (Utilities.existsInnerException(e, "com.ctc.wstx.exc.WstxIOException")) {
                tmp = Utilities.getInnerException(e, "com.ctc.wstx.exc.WstxIOException");
            }
            if (tmp != null && (tmp.getMessage() == null || "".equals(tmp.getMessage()) || "null".equalsIgnoreCase(tmp.getMessage()))) {
                tmp = null;
                found = true;
            }
        }
        if (tmp == null) {
            if (Utilities.isExceptionInstanceOf("com.ctc.wstx.exc.WstxParsingException", e)) {
                tmp = e;
            } else if (Utilities.existsInnerException(e, "com.ctc.wstx.exc.WstxParsingException")) {
                tmp = Utilities.getInnerException(e, "com.ctc.wstx.exc.WstxParsingException");
            }
            if (tmp != null && (tmp.getMessage() == null || "".equals(tmp.getMessage()) || "null".equalsIgnoreCase(tmp.getMessage()))) {
                tmp = null;
                found = true;
            }
        }
        if (tmp == null) {
            if (Utilities.isExceptionInstanceOf("com.ctc.wstx.exc.WstxUnexpectedCharException", e)) {
                tmp = e;
            } else if (Utilities.existsInnerException(e, "com.ctc.wstx.exc.WstxUnexpectedCharException")) {
                tmp = Utilities.getInnerException(e, "com.ctc.wstx.exc.WstxUnexpectedCharException");
            }
            if (tmp != null && (tmp.getMessage() == null || "".equals(tmp.getMessage()) || "null".equalsIgnoreCase(tmp.getMessage()))) {
                tmp = null;
                found = true;
            }
        }
        if (tmp == null) {
            if (Utilities.isExceptionInstanceOf("org.xml.sax.SAXParseException", e)) {
                tmp = e;
            } else if (Utilities.existsInnerException(e, "org.xml.sax.SAXParseException")) {
                tmp = Utilities.getInnerException(e, "org.xml.sax.SAXParseException");
            }
            if (tmp != null && (tmp.getMessage() == null || "".equals(tmp.getMessage()) || "null".equalsIgnoreCase(tmp.getMessage()))) {
                tmp = null;
                found = true;
            }
        }
        if (tmp == null) {
            if (Utilities.isExceptionInstanceOf("javax.xml.stream.XMLStreamException", e)) {
                tmp = e;
            } else if (Utilities.existsInnerException(e, "javax.xml.stream.XMLStreamException")) {
                tmp = Utilities.getInnerException(e, "javax.xml.stream.XMLStreamException");
            }
            if (tmp != null && (tmp.getMessage() == null || "".equals(tmp.getMessage()) || "null".equalsIgnoreCase(tmp.getMessage()))) {
                tmp = null;
                found = true;
            }
        }
        if (tmp != null) {
            return tmp;
        }
        if (found) {
            return MessageUtils.getInnerNotEmptyMessageException(e);
        }
        return null;
    }

    public static boolean isEmpytMessageException(Throwable e) {
        return e.getMessage() == null || "".equals(e.getMessage()) || "null".equalsIgnoreCase(e.getMessage()) || "com.ctc.wstx.exc.WstxIOException: null".equalsIgnoreCase(e.getMessage());
    }

    public static Throwable getInnerNotEmptyMessageException(Throwable e) {
        if (!MessageUtils.isEmpytMessageException(e)) {
            return e;
        }
        if (e.getCause() != null) {
            return MessageUtils.getInnerNotEmptyMessageException(e.getCause());
        }
        return e;
    }
}

