/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.message;

import java.util.Map;
import javax.mail.internet.ContentType;
import javax.mail.internet.ParameterList;

public class ContentTypeUtilities {
    public static String buildContentType(Map<String, String> parameters, String contentType) throws RuntimeException {
        try {
            ContentType cType = new ContentType(contentType);
            if (parameters.size() > 0) {
                for (String parameterName : parameters.keySet()) {
                    String parameterValue = parameters.get(parameterName);
                    if (cType.getParameterList() == null) {
                        cType.setParameterList(new ParameterList());
                    }
                    cType.getParameterList().remove(parameterName);
                    cType.getParameterList().set(parameterName, parameterValue);
                }
            }
            String ct = cType.toString();
            ct = ContentTypeUtilities.normalizeToRfc7230(ct);
            ct = ct.trim();
            return ct;
        }
        catch (Exception e) {
            throw new RuntimeException("Error during buildContentType: " + e.getMessage(), e);
        }
    }

    public static String normalizeToRfc7230(String ct) {
        if (ct.contains("\r\n")) {
            while (ct.contains("\r\n")) {
                ct = ct.replace("\r\n", " ");
            }
        }
        if (ct.contains("\r")) {
            while (ct.contains("\r")) {
                ct = ct.replace("\r", " ");
            }
        }
        if (ct.contains("\n")) {
            while (ct.contains("\n")) {
                ct = ct.replace("\n", " ");
            }
        }
        if (ct.contains("\t")) {
            while (ct.contains("\t")) {
                ct = ct.replace("\t", " ");
            }
        }
        return ct.trim();
    }
}

