/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.eccezione.router_details.utils;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.eccezione.router_details.DettaglioRouting;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.eccezione.router_details.Dominio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.eccezione.router_details.utils.XMLUtilsException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.OpenSPCoop2Message;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.ValidatoreXSD;
import it.link.pdd.tools.migrazione_govway.utils.xml.JiBXUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPFault;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLUtils {
    static ValidatoreXSD validatoreXSD = null;

    public static synchronized ValidatoreXSD getValidatoreXSD(Logger log) throws Exception {
        if (validatoreXSD == null) {
            validatoreXSD = new ValidatoreXSD(log, XMLUtils.class.getResourceAsStream("/openspcoopRouterDetail.xsd"));
        }
        return validatoreXSD;
    }

    public static boolean validate(DettaglioRouting dettaglioRouting, StringBuffer motivoErroreValidazione) {
        int size = motivoErroreValidazione.length();
        if (dettaglioRouting.getDominio() == null) {
            motivoErroreValidazione.append("Dominio non definito\n");
        } else {
            XMLUtils.validate(dettaglioRouting.getDominio(), motivoErroreValidazione);
        }
        if (dettaglioRouting.getOraRegistrazione() == null) {
            motivoErroreValidazione.append("OraRegistrazione non definita\n");
        }
        if (dettaglioRouting.getDettaglio() == null) {
            motivoErroreValidazione.append("Dettaglio non definita\n");
        } else {
            if (dettaglioRouting.getDettaglio().getDescrizione() == null) {
                motivoErroreValidazione.append("Dettaglio.descrizione non definita\n");
            }
            if (dettaglioRouting.getDettaglio().getEsito() == null) {
                motivoErroreValidazione.append("Dettaglio.esito non definita\n");
            }
        }
        return motivoErroreValidazione.length() == size;
    }

    private static void validate(Dominio dominio, StringBuffer motivoErroreValidazione) {
        if (dominio.getIdentificativoPorta() == null) {
            motivoErroreValidazione.append("Dominio.identificativoPorta non definito\n");
        }
        if (dominio.getModulo() == null) {
            motivoErroreValidazione.append("Dominio.modulo non definito\n");
        }
        if (dominio.getSoggetto() == null) {
            motivoErroreValidazione.append("Dominio.soggetto non definita\n");
        } else {
            if (dominio.getSoggetto().getTipo() == null) {
                motivoErroreValidazione.append("Dominio.soggetto.tipo non definita\n");
            }
            if (dominio.getSoggetto().getBase() == null) {
                motivoErroreValidazione.append("Dominio.soggetto.nome non definita\n");
            }
        }
    }

    public static DettaglioRouting getDettaglioRouting(Logger log, byte[] m) throws XMLUtilsException {
        ByteArrayInputStream bin = null;
        try {
            bin = new ByteArrayInputStream(m);
            DettaglioRouting dettaglioRouting = XMLUtils.getDettaglioRouting(log, bin);
            return dettaglioRouting;
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
        finally {
            try {
                if (bin != null) {
                    bin.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static DettaglioRouting getDettaglioRouting(Logger log, File m) throws XMLUtilsException {
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(m);
            DettaglioRouting dettaglioRouting = XMLUtils.getDettaglioRouting(log, fin);
            return dettaglioRouting;
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
        finally {
            try {
                if (fin != null) {
                    fin.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static DettaglioRouting getDettaglioRouting(Logger log, String m) throws XMLUtilsException {
        return XMLUtils.getDettaglioRouting(log, m.getBytes());
    }

    public static DettaglioRouting getDettaglioRouting(Logger log, InputStream m) throws XMLUtilsException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            byte[] reads = new byte[1024];
            int letti = 0;
            while ((letti = m.read(reads)) != -1) {
                bout.write(reads, 0, letti);
            }
            bout.flush();
            bout.close();
            byte[] xml = bout.toByteArray();
            ByteArrayInputStream binValidazione = new ByteArrayInputStream(xml);
            ValidatoreXSD validatoreXSD = XMLUtils.getValidatoreXSD(log);
            validatoreXSD.valida(binValidazione);
            ByteArrayInputStream binTrasformazione = new ByteArrayInputStream(xml);
            return (DettaglioRouting)JiBXUtils.xmlToObj(binTrasformazione, DettaglioRouting.class);
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static void generateDettaglioRouting(DettaglioRouting eccezione, File out) throws XMLUtilsException {
        try {
            StringBuffer risultatoValidazione = new StringBuffer();
            if (!XMLUtils.validate(eccezione, risultatoValidazione)) {
                throw new Exception(risultatoValidazione.toString());
            }
            JiBXUtils.objToXml(out.getName(), XMLUtils.generateDettaglioRouting_engine(eccezione));
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static void generateDettaglioRouting(DettaglioRouting eccezione, String fileName) throws XMLUtilsException {
        try {
            StringBuffer risultatoValidazione = new StringBuffer();
            if (!XMLUtils.validate(eccezione, risultatoValidazione)) {
                throw new Exception(risultatoValidazione.toString());
            }
            JiBXUtils.objToXml(fileName, XMLUtils.generateDettaglioRouting_engine(eccezione));
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static byte[] generateDettaglioRouting(DettaglioRouting eccezione) throws XMLUtilsException {
        try {
            StringBuffer risultatoValidazione = new StringBuffer();
            if (!XMLUtils.validate(eccezione, risultatoValidazione)) {
                throw new Exception(risultatoValidazione.toString());
            }
            return XMLUtils.generateDettaglioRouting_engine(eccezione);
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static void generateDettaglioRouting(DettaglioRouting eccezione, OutputStream out) throws XMLUtilsException {
        try {
            StringBuffer risultatoValidazione = new StringBuffer();
            if (!XMLUtils.validate(eccezione, risultatoValidazione)) {
                throw new Exception(risultatoValidazione.toString());
            }
            out.write(XMLUtils.generateDettaglioRouting_engine(eccezione));
            out.flush();
            out.close();
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    private static byte[] generateDettaglioRouting_engine(DettaglioRouting eccezione) throws XMLUtilsException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            JiBXUtils.objToXml(bout, DettaglioRouting.class, (Object)eccezione);
            byte[] dichiarazione = bout.toByteArray();
            return dichiarazione;
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static DettaglioRouting getDettaglioRouting(Logger log, OpenSPCoop2Message msg) throws XMLUtilsException {
        try {
            if (msg == null) {
                throw new XMLUtilsException("Messaggio non presente");
            }
            SOAPBody soapBody = msg.getSOAPBody();
            if (soapBody == null) {
                throw new XMLUtilsException("SOAPBody non presente");
            }
            SOAPFault faultOriginale = null;
            if (!soapBody.hasFault()) {
                return null;
            }
            faultOriginale = soapBody.getFault();
            if (faultOriginale == null) {
                throw new XMLUtilsException("SOAPFault is null");
            }
            QName nameDetail = new QName("detail");
            Iterator itSF = faultOriginale.getChildElements(nameDetail);
            SOAPElement detailsFaultOriginale = null;
            if (itSF.hasNext()) {
                detailsFaultOriginale = (SOAPElement)itSF.next();
            }
            msg.saveChanges();
            if (detailsFaultOriginale != null) {
                Iterator iter = detailsFaultOriginale.getChildElements();
                while (iter.hasNext()) {
                    Object o = iter.next();
                    if (!(o instanceof SOAPElement)) continue;
                    SOAPElement elem = (SOAPElement)o;
                    try {
                        if (!XMLUtils.isDettaglioRouting((Element)elem)) continue;
                        it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.XMLUtils xmlUtils = it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.XMLUtils.getInstance();
                        byte[] xml = xmlUtils.toByteArray((Element)elem);
                        DettaglioRouting de = XMLUtils.getDettaglioRouting(log, xml);
                        return de;
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.out);
                    }
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static boolean isDettaglioRouting(byte[] doc) {
        try {
            it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.XMLUtils xmlUtils = it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.XMLUtils.getInstance();
            Document docXML = xmlUtils.newDocument(doc);
            Element elemXML = docXML.getDocumentElement();
            return XMLUtils.isDettaglioRouting_engine(elemXML);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isDettaglioRouting(Document docXML) {
        try {
            Element elemXML = docXML.getDocumentElement();
            return XMLUtils.isDettaglioRouting_engine(elemXML);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isDettaglioRouting(Element elemXML) {
        return XMLUtils.isDettaglioRouting_engine(elemXML);
    }

    public static boolean isDettaglioRouting(Node nodeXml) {
        return XMLUtils.isDettaglioRouting_engine(nodeXml);
    }

    private static boolean isDettaglioRouting_engine(Node nodeXml) {
        try {
            return "dettaglio-routing".equals(nodeXml.getLocalName()) && "http://www.openspcoop2.org/core/eccezione/router_details".equals(nodeXml.getNamespaceURI());
        }
        catch (Exception e) {
            return false;
        }
    }
}

