/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.eccezione.details.utils;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.eccezione.details.Dettaglio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.eccezione.details.DettaglioEccezione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.eccezione.details.Dominio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.eccezione.details.Eccezione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.eccezione.details.utils.XMLUtilsException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.OpenSPCoop2Message;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.ValidatoreXSD;
import it.link.pdd.tools.migrazione_govway.utils.xml.JiBXUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPFault;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLUtils {
    static ValidatoreXSD validatoreXSD = null;

    public static synchronized ValidatoreXSD getValidatoreXSD(Logger log) throws Exception {
        if (validatoreXSD == null) {
            validatoreXSD = new ValidatoreXSD(log, XMLUtils.class.getResourceAsStream("/openspcoopDetail.xsd"));
        }
        return validatoreXSD;
    }

    public static boolean validate(DettaglioEccezione eccezione, StringBuffer motivoErroreValidazione) {
        int i;
        int size = motivoErroreValidazione.length();
        if (eccezione.getDominio() == null) {
            motivoErroreValidazione.append("Dominio non definito\n");
        } else {
            XMLUtils.validate(eccezione.getDominio(), motivoErroreValidazione);
        }
        if (eccezione.getOraRegistrazione() == null) {
            motivoErroreValidazione.append("OraRegistrazione non definita\n");
        }
        if (eccezione.getEccezioni() == null) {
            motivoErroreValidazione.append("Nessuna eccezione definita\n");
        } else if (eccezione.getEccezioni().sizeEccezioneList() <= 0) {
            motivoErroreValidazione.append("Nessuna eccezione definita\n");
        } else {
            for (i = 0; i < eccezione.getEccezioni().sizeEccezioneList(); ++i) {
                Eccezione ecc = eccezione.getEccezioni().getEccezione(i);
                if (ecc.getCodice() == null) {
                    motivoErroreValidazione.append("Eccezione.codice non definito\n");
                }
                if (ecc.getDescrizione() == null) {
                    motivoErroreValidazione.append("Eccezione.codice non definito\n");
                }
                if (ecc.getTipo() != null) continue;
                motivoErroreValidazione.append("Eccezione.tipo non definito\n");
            }
        }
        if (eccezione.getDettagli() != null && eccezione.getDettagli().sizeDettaglioList() > 0) {
            for (i = 0; i < eccezione.getDettagli().sizeDettaglioList(); ++i) {
                Dettaglio detail = eccezione.getDettagli().getDettaglio(i);
                if (detail == null) {
                    motivoErroreValidazione.append("Detail presente e non definito??\n");
                    continue;
                }
                if (detail.getTipo() == null) {
                    motivoErroreValidazione.append("Detail[" + i + "].tipo non definito\n");
                }
                if (detail.getBase() != null) continue;
                motivoErroreValidazione.append("Detail[" + i + "].tipo non definito\n");
            }
        }
        return motivoErroreValidazione.length() == size;
    }

    private static void validate(Dominio dominio, StringBuffer motivoErroreValidazione) {
        if (dominio.getIdentificativoPorta() == null) {
            motivoErroreValidazione.append("Dominio.identificativoPorta non definito\n");
        }
        if (dominio.getFunzione() == null) {
            motivoErroreValidazione.append("Dominio.funzione non definito\n");
        }
        if (dominio.getModulo() == null) {
            motivoErroreValidazione.append("Dominio.modulo non definito\n");
        }
        if (dominio.getSoggetto() == null) {
            motivoErroreValidazione.append("Dominio.soggetto non definita\n");
        } else {
            if (dominio.getSoggetto().getTipo() == null) {
                motivoErroreValidazione.append("Dominio.soggetto.tipo non definita\n");
            }
            if (dominio.getSoggetto().getBase() == null) {
                motivoErroreValidazione.append("Dominio.soggetto.nome non definita\n");
            }
        }
    }

    public static DettaglioEccezione getDettaglioEccezione(Logger log, byte[] m) throws XMLUtilsException {
        ByteArrayInputStream bin = null;
        try {
            bin = new ByteArrayInputStream(m);
            DettaglioEccezione dettaglioEccezione = XMLUtils.getDettaglioEccezione(log, bin);
            return dettaglioEccezione;
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
        finally {
            try {
                if (bin != null) {
                    bin.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static DettaglioEccezione getDettaglioEccezione(Logger log, File m) throws XMLUtilsException {
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(m);
            DettaglioEccezione dettaglioEccezione = XMLUtils.getDettaglioEccezione(log, fin);
            return dettaglioEccezione;
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
        finally {
            try {
                if (fin != null) {
                    fin.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static DettaglioEccezione getDettaglioEccezione(Logger log, String m) throws XMLUtilsException {
        return XMLUtils.getDettaglioEccezione(log, m.getBytes());
    }

    public static DettaglioEccezione getDettaglioEccezione(Logger log, InputStream m) throws XMLUtilsException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            byte[] reads = new byte[1024];
            int letti = 0;
            while ((letti = m.read(reads)) != -1) {
                bout.write(reads, 0, letti);
            }
            bout.flush();
            bout.close();
            byte[] xml = bout.toByteArray();
            ByteArrayInputStream binValidazione = new ByteArrayInputStream(xml);
            ValidatoreXSD validatoreXSD = XMLUtils.getValidatoreXSD(log);
            validatoreXSD.valida(binValidazione);
            ByteArrayInputStream binTrasformazione = new ByteArrayInputStream(xml);
            return (DettaglioEccezione)JiBXUtils.xmlToObj(binTrasformazione, DettaglioEccezione.class);
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static void generateDettaglioEccezione(DettaglioEccezione eccezione, File out) throws XMLUtilsException {
        try {
            StringBuffer risultatoValidazione = new StringBuffer();
            if (!XMLUtils.validate(eccezione, risultatoValidazione)) {
                throw new Exception(risultatoValidazione.toString());
            }
            JiBXUtils.objToXml(out.getName(), XMLUtils.generateDettaglioEccezione_engine(eccezione));
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static void generateDettaglioEccezione(DettaglioEccezione eccezione, String fileName) throws XMLUtilsException {
        try {
            StringBuffer risultatoValidazione = new StringBuffer();
            if (!XMLUtils.validate(eccezione, risultatoValidazione)) {
                throw new Exception(risultatoValidazione.toString());
            }
            JiBXUtils.objToXml(fileName, XMLUtils.generateDettaglioEccezione_engine(eccezione));
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static byte[] generateDettaglioEccezione(DettaglioEccezione eccezione) throws XMLUtilsException {
        try {
            StringBuffer risultatoValidazione = new StringBuffer();
            if (!XMLUtils.validate(eccezione, risultatoValidazione)) {
                throw new Exception(risultatoValidazione.toString());
            }
            return XMLUtils.generateDettaglioEccezione_engine(eccezione);
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static void generateDettaglioEccezione(DettaglioEccezione eccezione, OutputStream out) throws XMLUtilsException {
        try {
            StringBuffer risultatoValidazione = new StringBuffer();
            if (!XMLUtils.validate(eccezione, risultatoValidazione)) {
                throw new Exception(risultatoValidazione.toString());
            }
            out.write(XMLUtils.generateDettaglioEccezione_engine(eccezione));
            out.flush();
            out.close();
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    private static byte[] generateDettaglioEccezione_engine(DettaglioEccezione eccezione) throws XMLUtilsException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            JiBXUtils.objToXml(bout, DettaglioEccezione.class, (Object)eccezione);
            byte[] dichiarazione = bout.toByteArray();
            return dichiarazione;
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static DettaglioEccezione getDettaglioEccezione(Logger log, OpenSPCoop2Message msg) throws XMLUtilsException {
        try {
            if (msg == null) {
                throw new XMLUtilsException("Messaggio non presente");
            }
            SOAPBody soapBody = msg.getSOAPBody();
            if (soapBody == null) {
                throw new XMLUtilsException("SOAPBody non presente");
            }
            SOAPFault faultOriginale = null;
            if (!soapBody.hasFault()) {
                return null;
            }
            faultOriginale = soapBody.getFault();
            if (faultOriginale == null) {
                throw new XMLUtilsException("SOAPFault is null");
            }
            QName nameDetail = new QName("detail");
            Iterator itSF = faultOriginale.getChildElements(nameDetail);
            SOAPElement detailsFaultOriginale = null;
            if (itSF.hasNext()) {
                detailsFaultOriginale = (SOAPElement)itSF.next();
            }
            msg.saveChanges();
            if (detailsFaultOriginale != null) {
                Iterator iter = detailsFaultOriginale.getChildElements();
                while (iter.hasNext()) {
                    Object o = iter.next();
                    if (!(o instanceof SOAPElement)) continue;
                    SOAPElement elem = (SOAPElement)o;
                    try {
                        if (!XMLUtils.isDettaglioEccezione((Element)elem)) continue;
                        it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.XMLUtils xmlUtils = it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.XMLUtils.getInstance();
                        byte[] xml = xmlUtils.toByteArray((Element)elem);
                        DettaglioEccezione de = XMLUtils.getDettaglioEccezione(log, xml);
                        return de;
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.out);
                    }
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static boolean isDettaglioEccezione(byte[] doc) {
        try {
            it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.XMLUtils xmlUtils = it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.XMLUtils.getInstance();
            Document docXML = xmlUtils.newDocument(doc);
            Element elemXML = docXML.getDocumentElement();
            return XMLUtils.isDettaglioEccezione_engine(elemXML);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isDettaglioEccezione(Document docXML) {
        try {
            Element elemXML = docXML.getDocumentElement();
            return XMLUtils.isDettaglioEccezione_engine(elemXML);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isDettaglioEccezione(Element elemXML) {
        return XMLUtils.isDettaglioEccezione_engine(elemXML);
    }

    public static boolean isDettaglioEccezione(Node nodeXml) {
        return XMLUtils.isDettaglioEccezione_engine(nodeXml);
    }

    private static boolean isDettaglioEccezione_engine(Node nodeXml) {
        try {
            return "dettaglio-eccezione".equals(nodeXml.getLocalName()) && "http://www.openspcoop2.org/core/eccezione/details".equals(nodeXml.getNamespaceURI());
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String toString(DettaglioEccezione de) {
        StringBuffer bf = new StringBuffer();
        if (de != null) {
            int k;
            if (de.getOraRegistrazione() != null) {
                SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd_HH:mm:ss.SSS");
                bf.append("(" + dateformat.format(de.getOraRegistrazione()) + ")");
            }
            if (de.getDominio() != null) {
                bf.append(" ");
                boolean writeSoggetto = false;
                if (de.getDominio().getIdentificativoPorta() != null) {
                    bf.append(de.getDominio().getIdentificativoPorta());
                    writeSoggetto = true;
                    if (de.getDominio().getSoggetto() != null) {
                        bf.append(".");
                    }
                }
                if (de.getDominio().getSoggetto() != null) {
                    bf.append(de.getDominio().getSoggetto().getTipo() + "/" + de.getDominio().getSoggetto().getBase());
                    writeSoggetto = true;
                }
                if ((de.getDominio().getFunzione() != null || de.getDominio().getModulo() != null) && writeSoggetto) {
                    bf.append(" ");
                }
                if (de.getDominio().getFunzione() != null) {
                    bf.append(de.getDominio().getFunzione());
                    if (de.getDominio().getModulo() != null) {
                        bf.append(".");
                    }
                }
                if (de.getDominio().getModulo() != null) {
                    bf.append(de.getDominio().getModulo());
                }
            }
            if (bf.length() > 0) {
                bf.append(" ");
            }
            int sizeEccezioni = 0;
            if (de.getEccezioni() != null) {
                sizeEccezioni = de.getEccezioni().sizeEccezioneList();
            }
            int sizeDettagli = 0;
            if (de.getDettagli() != null) {
                sizeDettagli = de.getDettagli().sizeDettaglioList();
            }
            bf.append("ha rilevato " + sizeEccezioni + " eccezione/i (dettagli:" + sizeDettagli + ")");
            for (k = 0; k < sizeEccezioni; ++k) {
                bf.append("\n- Eccezione (" + de.getEccezioni().getEccezione(k).getTipo() + ") [" + de.getEccezioni().getEccezione(k).getCodice() + "] " + de.getEccezioni().getEccezione(k).getDescrizione());
            }
            if (sizeDettagli > 0) {
                for (k = 0; k < sizeDettagli; ++k) {
                    bf.append("\n- Dettaglio [" + de.getDettagli().getDettaglio(k).getTipo() + "] " + de.getDettagli().getDettaglio(k).getBase());
                }
            }
        }
        return bf.toString();
    }
}

