/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.diagnostica.utils;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.diagnostica.DominioDiagnostico;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.diagnostica.MessaggioDiagnostico;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.diagnostica.Protocollo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.diagnostica.utils.XMLUtilsException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.ValidatoreXSD;
import it.link.pdd.tools.migrazione_govway.utils.xml.JiBXUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLUtils {
    static ValidatoreXSD validatoreXSD = null;

    public static synchronized ValidatoreXSD getValidatoreXSD(Logger log) throws Exception {
        if (validatoreXSD == null) {
            validatoreXSD = new ValidatoreXSD(log, XMLUtils.class.getResourceAsStream("/openspcoopDiagnostica.xsd"));
        }
        return validatoreXSD;
    }

    public static boolean validate(MessaggioDiagnostico messaggioDiagnostico, StringBuffer motivoErroreValidazione) {
        int size = motivoErroreValidazione.length();
        if (messaggioDiagnostico.getDominio() == null) {
            motivoErroreValidazione.append("Dominio non definito\n");
        } else {
            XMLUtils.validate(messaggioDiagnostico.getDominio(), motivoErroreValidazione);
        }
        if (messaggioDiagnostico.getOraRegistrazione() == null) {
            motivoErroreValidazione.append("OraRegistrazione non definita\n");
        }
        if (messaggioDiagnostico.getCodice() == null) {
            motivoErroreValidazione.append("Codice non definito\n");
        }
        if (messaggioDiagnostico.getMessaggio() == null) {
            motivoErroreValidazione.append("Messaggio non definito\n");
        }
        if (messaggioDiagnostico.getSeverita() == null) {
            motivoErroreValidazione.append("Severita non definito\n");
        }
        if (messaggioDiagnostico.getProtocollo() != null) {
            XMLUtils.validate(messaggioDiagnostico.getProtocollo(), motivoErroreValidazione);
        }
        return motivoErroreValidazione.length() == size;
    }

    private static void validate(DominioDiagnostico dominio, StringBuffer motivoErroreValidazione) {
        if (dominio.getIdentificativoPorta() == null) {
            motivoErroreValidazione.append("Dominio.identificativoPorta non definito\n");
        }
        if (dominio.getModulo() == null) {
            motivoErroreValidazione.append("Dominio.modulo non definito\n");
        }
        if (dominio.getSoggetto() == null) {
            motivoErroreValidazione.append("Dominio.soggetto non definita\n");
        } else {
            if (dominio.getSoggetto().getTipo() == null) {
                motivoErroreValidazione.append("Dominio.soggetto.tipo non definita\n");
            }
            if (dominio.getSoggetto().getBase() == null) {
                motivoErroreValidazione.append("Dominio.soggetto.nome non definita\n");
            }
        }
    }

    private static void validate(Protocollo protocollo, StringBuffer motivoErroreValidazione) {
        if (protocollo.getIdentificativo() == null) {
            motivoErroreValidazione.append("Protocollo.identificativo non definito\n");
        }
    }

    public static MessaggioDiagnostico getMessaggioDiagnostico(Logger log, byte[] m) throws XMLUtilsException {
        ByteArrayInputStream bin = null;
        try {
            bin = new ByteArrayInputStream(m);
            MessaggioDiagnostico messaggioDiagnostico = XMLUtils.getMessaggioDiagnostico(log, bin);
            return messaggioDiagnostico;
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
        finally {
            try {
                if (bin != null) {
                    bin.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static MessaggioDiagnostico getMessaggioDiagnostico(Logger log, File m) throws XMLUtilsException {
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(m);
            MessaggioDiagnostico messaggioDiagnostico = XMLUtils.getMessaggioDiagnostico(log, fin);
            return messaggioDiagnostico;
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
        finally {
            try {
                if (fin != null) {
                    fin.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static MessaggioDiagnostico getMessaggioDiagnostico(Logger log, String m) throws XMLUtilsException {
        return XMLUtils.getMessaggioDiagnostico(log, m.getBytes());
    }

    public static MessaggioDiagnostico getMessaggioDiagnostico(Logger log, InputStream m) throws XMLUtilsException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            byte[] reads = new byte[1024];
            int letti = 0;
            while ((letti = m.read(reads)) != -1) {
                bout.write(reads, 0, letti);
            }
            bout.flush();
            bout.close();
            byte[] xml = bout.toByteArray();
            ByteArrayInputStream binValidazione = new ByteArrayInputStream(xml);
            ValidatoreXSD validatoreXSD = XMLUtils.getValidatoreXSD(log);
            validatoreXSD.valida(binValidazione);
            ByteArrayInputStream binTrasformazione = new ByteArrayInputStream(xml);
            return (MessaggioDiagnostico)JiBXUtils.xmlToObj(binTrasformazione, MessaggioDiagnostico.class);
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static void generateMessaggioDiagnostico(MessaggioDiagnostico messaggioDiagnostico, File out) throws XMLUtilsException {
        try {
            StringBuffer risultatoValidazione = new StringBuffer();
            if (!XMLUtils.validate(messaggioDiagnostico, risultatoValidazione)) {
                throw new Exception(risultatoValidazione.toString());
            }
            JiBXUtils.objToXml(out.getName(), XMLUtils.generateMessaggioDiagnostico_engine(messaggioDiagnostico));
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static void generateMessaggioDiagnostico(MessaggioDiagnostico messaggioDiagnostico, String fileName) throws XMLUtilsException {
        try {
            StringBuffer risultatoValidazione = new StringBuffer();
            if (!XMLUtils.validate(messaggioDiagnostico, risultatoValidazione)) {
                throw new Exception(risultatoValidazione.toString());
            }
            JiBXUtils.objToXml(fileName, XMLUtils.generateMessaggioDiagnostico_engine(messaggioDiagnostico));
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static byte[] generateMessaggioDiagnostico(MessaggioDiagnostico messaggioDiagnostico) throws XMLUtilsException {
        try {
            StringBuffer risultatoValidazione = new StringBuffer();
            if (!XMLUtils.validate(messaggioDiagnostico, risultatoValidazione)) {
                throw new Exception(risultatoValidazione.toString());
            }
            return XMLUtils.generateMessaggioDiagnostico_engine(messaggioDiagnostico);
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static void generateMessaggioDiagnostico(MessaggioDiagnostico messaggioDiagnostico, OutputStream out) throws XMLUtilsException {
        try {
            StringBuffer risultatoValidazione = new StringBuffer();
            if (!XMLUtils.validate(messaggioDiagnostico, risultatoValidazione)) {
                throw new Exception(risultatoValidazione.toString());
            }
            out.write(XMLUtils.generateMessaggioDiagnostico_engine(messaggioDiagnostico));
            out.flush();
            out.close();
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    private static byte[] generateMessaggioDiagnostico_engine(MessaggioDiagnostico messaggioDiagnostico) throws XMLUtilsException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            JiBXUtils.objToXml(bout, MessaggioDiagnostico.class, (Object)messaggioDiagnostico);
            byte[] dichiarazione = bout.toByteArray();
            return dichiarazione;
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static boolean isMessaggioDiagnostico(byte[] doc) {
        try {
            it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.XMLUtils xmlUtils = it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.XMLUtils.getInstance();
            Document docXML = xmlUtils.newDocument(doc);
            Element elemXML = docXML.getDocumentElement();
            return XMLUtils.isMessaggioDiagnostico_engine(elemXML);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isMessaggioDiagnostico(Document docXML) {
        try {
            Element elemXML = docXML.getDocumentElement();
            return XMLUtils.isMessaggioDiagnostico_engine(elemXML);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isMessaggioDiagnostico(Element elemXML) {
        return XMLUtils.isMessaggioDiagnostico_engine(elemXML);
    }

    public static boolean isMessaggioDiagnostico(Node nodeXml) {
        return XMLUtils.isMessaggioDiagnostico_engine(nodeXml);
    }

    private static boolean isMessaggioDiagnostico_engine(Node nodeXml) {
        try {
            return "messaggio-diagnostico".equals(nodeXml.getLocalName()) && "http://www.openspcoop2.org/core/diagnostica".equals(nodeXml.getNamespaceURI());
        }
        catch (Exception e) {
            return false;
        }
    }
}

