/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.driver.utils;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.AccessoConfigurazionePdD;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.Connettore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.Credenziali;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.InvocazionePorta;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.InvocazionePortaGestioneErrore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.InvocazioneServizio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.Openspcoop2;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.PortaApplicativa;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.PortaDelegata;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.Property;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.RispostaAsincrona;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.ServizioApplicativo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.Soggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.constants.CostantiConfigurazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.constants.CredenzialeTipo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.constants.InvocazioneServizioTipoAutenticazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.driver.DriverConfigurazioneException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.driver.IDriverConfigurazioneCRUD;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.driver.IDriverConfigurazioneGet;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.driver.db.DriverConfigurazioneDB;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.driver.xml.DriverConfigurazioneXML;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.constants.TipiConnettore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDPortaApplicativa;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDPortaDelegata;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDServizio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.ValidatoreXSD;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.XMLUtils;
import it.link.pdd.tools.migrazione_govway.utils.LoggerWrapperFactory;
import it.link.pdd.tools.migrazione_govway.utils.Utilities;
import it.link.pdd.tools.migrazione_govway.utils.resources.Loader;
import it.link.pdd.tools.migrazione_govway.utils.xml.AbstractXMLUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.sql.Connection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;
import org.slf4j.Logger;
import org.w3c.dom.Document;

public class XMLDataConverter {
    private IDriverConfigurazioneCRUD gestoreCRUD = null;
    private Openspcoop2 sorgenteConfigurazione;
    private Logger log = null;
    private Logger logDriver = null;
    private String superUser = null;
    private boolean gestioneConfigurazione;
    private String tipoBEDestinazione;
    private AbstractXMLUtils xmlUtils = null;

    public XMLDataConverter(String sorgente, AccessoConfigurazionePdD destinazione, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser, String protocolloDefault) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup(sorgente, destinazione, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser, protocolloDefault, null, null);
    }

    public XMLDataConverter(String sorgente, AccessoConfigurazionePdD destinazione, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser, String protocolloDefault, Logger log) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup(sorgente, destinazione, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser, protocolloDefault, log, null);
    }

    public XMLDataConverter(String sorgente, AccessoConfigurazionePdD destinazione, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser, String protocolloDefault, Logger log, Logger logDriver) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup(sorgente, destinazione, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser, protocolloDefault, log, logDriver);
    }

    public XMLDataConverter(byte[] sorgente, AccessoConfigurazionePdD destinazione, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser, String protocolloDefault) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup(sorgente, destinazione, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser, protocolloDefault, null, null);
    }

    public XMLDataConverter(byte[] sorgente, AccessoConfigurazionePdD destinazione, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser, String protocolloDefault, Logger log) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup(sorgente, destinazione, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser, protocolloDefault, log, null);
    }

    public XMLDataConverter(byte[] sorgente, AccessoConfigurazionePdD destinazione, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser, String protocolloDefault, Logger log, Logger logDriver) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup(sorgente, destinazione, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser, protocolloDefault, log, logDriver);
    }

    public XMLDataConverter(InputStream sorgente, AccessoConfigurazionePdD destinazione, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser, String protocolloDefault) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup(sorgente, destinazione, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser, protocolloDefault, null, null);
    }

    public XMLDataConverter(InputStream sorgente, AccessoConfigurazionePdD destinazione, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser, String protocolloDefault, Logger log) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup(sorgente, destinazione, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser, protocolloDefault, log, null);
    }

    public XMLDataConverter(InputStream sorgente, AccessoConfigurazionePdD destinazione, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser, String protocolloDefault, Logger log, Logger logDriver) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup(sorgente, destinazione, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser, protocolloDefault, log, logDriver);
    }

    public XMLDataConverter(File sorgente, AccessoConfigurazionePdD destinazione, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser, String protocolloDefault) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup(sorgente, destinazione, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser, protocolloDefault, null, null);
    }

    public XMLDataConverter(File sorgente, AccessoConfigurazionePdD destinazione, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser, String protocolloDefault, Logger log) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup(sorgente, destinazione, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser, protocolloDefault, log, null);
    }

    public XMLDataConverter(File sorgente, AccessoConfigurazionePdD destinazione, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser, String protocolloDefault, Logger log, Logger logDriver) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup(sorgente, destinazione, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser, protocolloDefault, log, logDriver);
    }

    private void XMLDataConverterSetup(Object sorgente, AccessoConfigurazionePdD destinazione, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser, String protocolloDefault, Logger log, Logger logDriver) throws DriverConfigurazioneException {
        this.log = log == null ? LoggerWrapperFactory.getLogger(XMLDataConverter.class) : log;
        this.logDriver = logDriver;
        this.gestioneConfigurazione = configurazione;
        if (destinazione == null) {
            throw new DriverConfigurazioneException("GestoreCRUD non definito");
        }
        this.tipoBEDestinazione = destinazione.getTipo();
        this.superUser = superUser;
        try {
            if (sorgente instanceof String) {
                this.createSorgente((String)sorgente);
            } else if (sorgente instanceof byte[]) {
                this.createSorgente((byte[])sorgente);
            } else if (sorgente instanceof InputStream) {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                InputStream is = (InputStream)sorgente;
                int letti = 0;
                byte[] reads = new byte[65536];
                while ((letti = is.read(reads)) != -1) {
                    bout.write(reads, 0, letti);
                }
                bout.flush();
                bout.close();
                this.createSorgente(bout.toByteArray());
            } else if (sorgente instanceof File) {
                this.createSorgente(((File)sorgente).getAbsolutePath());
            }
        }
        catch (DriverConfigurazioneException d) {
            throw d;
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("Creazione sorgente [" + sorgente.getClass().getName() + "] non riuscita: " + e.getMessage(), e);
        }
        try {
            if (CostantiConfigurazione.REGISTRO_DB.equals(destinazione.getTipo())) {
                if (destinazione.getLocation() == null) {
                    throw new Exception("Location (DataSource) non definita");
                }
                if (destinazione.getContext() == null) {
                    throw new Exception("Contesto di localizzazione del datasource non definito in GenericProperties");
                }
                if (destinazione.getTipoDatabase() == null) {
                    throw new Exception("TipoDatabase (DataSource) non definita");
                }
                this.gestoreCRUD = new DriverConfigurazioneDB(destinazione.getLocation(), destinazione.getContext(), this.logDriver, destinazione.getTipoDatabase(), tabellaSoggettiCondivisaPddRegserv);
                if (!((DriverConfigurazioneDB)this.gestoreCRUD).create) {
                    throw new Exception("Configurazione DB non inizializzato");
                }
            } else {
                throw new Exception("Tipo di configurazione CRUD non gestita: " + destinazione.getTipo());
            }
            this.log.info("Inizializzato Configurazione DB");
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("Errore durante l'istanziazione del driver di CRUD: " + e.getMessage(), e);
        }
        this.xmlUtils = XMLUtils.getInstance();
        this.initializeProtocolManager(protocolloDefault);
    }

    public XMLDataConverter(String sorgente, Connection connection, String tipoDatabase, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser, String protocolloDefault) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup(sorgente, connection, tipoDatabase, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser, protocolloDefault, null, null);
    }

    public XMLDataConverter(String sorgente, Connection connection, String tipoDatabase, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser, String protocolloDefault, Logger log) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup(sorgente, connection, tipoDatabase, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser, protocolloDefault, log, null);
    }

    public XMLDataConverter(String sorgente, Connection connection, String tipoDatabase, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser, String protocolloDefault, Logger log, Logger logDriver) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup(sorgente, connection, tipoDatabase, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser, protocolloDefault, log, logDriver);
    }

    public XMLDataConverter(byte[] sorgente, Connection connection, String tipoDatabase, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser, String protocolloDefault) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup(sorgente, connection, tipoDatabase, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser, protocolloDefault, null, null);
    }

    public XMLDataConverter(byte[] sorgente, Connection connection, String tipoDatabase, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser, String protocolloDefault, Logger log) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup(sorgente, connection, tipoDatabase, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser, protocolloDefault, log, null);
    }

    public XMLDataConverter(byte[] sorgente, Connection connection, String tipoDatabase, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser, String protocolloDefault, Logger log, Logger logDriver) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup(sorgente, connection, tipoDatabase, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser, protocolloDefault, log, logDriver);
    }

    public XMLDataConverter(InputStream sorgente, Connection connection, String tipoDatabase, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser, String protocolloDefault) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup(sorgente, connection, tipoDatabase, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser, protocolloDefault, null, null);
    }

    public XMLDataConverter(InputStream sorgente, Connection connection, String tipoDatabase, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser, String protocolloDefault, Logger log) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup(sorgente, connection, tipoDatabase, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser, protocolloDefault, log, null);
    }

    public XMLDataConverter(InputStream sorgente, Connection connection, String tipoDatabase, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser, String protocolloDefault, Logger log, Logger logDriver) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup(sorgente, connection, tipoDatabase, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser, protocolloDefault, log, logDriver);
    }

    public XMLDataConverter(File sorgente, Connection connection, String tipoDatabase, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser, String protocolloDefault) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup(sorgente, connection, tipoDatabase, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser, protocolloDefault, null, null);
    }

    public XMLDataConverter(File sorgente, Connection connection, String tipoDatabase, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser, String protocolloDefault, Logger log) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup(sorgente, connection, tipoDatabase, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser, protocolloDefault, log, null);
    }

    public XMLDataConverter(File sorgente, Connection connection, String tipoDatabase, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser, String protocolloDefault, Logger log, Logger logDriver) throws DriverConfigurazioneException {
        this.XMLDataConverterSetup(sorgente, connection, tipoDatabase, configurazione, tabellaSoggettiCondivisaPddRegserv, superUser, protocolloDefault, log, logDriver);
    }

    private void XMLDataConverterSetup(Object sorgente, Connection connection, String tipoDatabase, boolean configurazione, boolean tabellaSoggettiCondivisaPddRegserv, String superUser, String protocolloDefault, Logger log, Logger logDriver) throws DriverConfigurazioneException {
        this.log = log == null ? LoggerWrapperFactory.getLogger(XMLDataConverter.class) : log;
        this.logDriver = logDriver;
        this.gestioneConfigurazione = configurazione;
        this.tipoBEDestinazione = CostantiConfigurazione.REGISTRO_DB.toString();
        this.superUser = superUser;
        try {
            if (sorgente instanceof String) {
                this.createSorgente((String)sorgente);
            } else if (sorgente instanceof byte[]) {
                this.createSorgente((byte[])sorgente);
            } else if (sorgente instanceof InputStream) {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                InputStream is = (InputStream)sorgente;
                int letti = 0;
                byte[] reads = new byte[65536];
                while ((letti = is.read(reads)) != -1) {
                    bout.write(reads, 0, letti);
                }
                bout.flush();
                bout.close();
                this.createSorgente(bout.toByteArray());
            } else if (sorgente instanceof File) {
                this.createSorgente(((File)sorgente).getAbsolutePath());
            }
        }
        catch (DriverConfigurazioneException d) {
            throw d;
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("Creazione sorgente [" + sorgente.getClass().getName() + "] non riuscita: " + e.getMessage(), e);
        }
        try {
            this.gestoreCRUD = new DriverConfigurazioneDB(connection, this.logDriver, tipoDatabase, tabellaSoggettiCondivisaPddRegserv);
            if (!((DriverConfigurazioneDB)this.gestoreCRUD).create) {
                throw new Exception("Configurazione DB non inizializzato");
            }
            this.log.info("Inizializzato Configurazione DB");
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("Errore durante l'istanziazione del driver di CRUD: " + e.getMessage(), e);
        }
        this.xmlUtils = XMLUtils.getInstance();
        this.initializeProtocolManager(protocolloDefault);
    }

    private void initializeProtocolManager(String protocolloDefault) throws DriverConfigurazioneException {
        try {
            Class<?> cProtocolFactoryManager = Class.forName("it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.engine.ProtocolFactoryManager");
            Object protocolFactoryManager = null;
            try {
                protocolFactoryManager = cProtocolFactoryManager.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (protocolFactoryManager == null) {
                Class<?> cConfigurazionePdD = Class.forName("it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.ConfigurazionePdD");
                Object configurazionePdD = cConfigurazionePdD.getConstructor(new Class[0]).newInstance(new Object[0]);
                Object confDir = null;
                cConfigurazionePdD.getMethod("setConfigurationDir", String.class).invoke(configurazionePdD, confDir);
                cConfigurazionePdD.getMethod("setAttesaAttivaJDBC", Long.TYPE).invoke(configurazionePdD, 60);
                cConfigurazionePdD.getMethod("setCheckIntervalJDBC", Integer.TYPE).invoke(configurazionePdD, 100);
                cConfigurazionePdD.getMethod("setLoader", Loader.class).invoke(configurazionePdD, new Loader());
                cConfigurazionePdD.getMethod("setLog", Logger.class).invoke(configurazionePdD, this.log);
                cProtocolFactoryManager.getMethod("initialize", Logger.class, cConfigurazionePdD, String.class).invoke(null, this.log, configurazionePdD, protocolloDefault);
            }
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("Errore durante l'istanziazione del driver di CRUD: " + e.getMessage(), e);
        }
    }

    private void createSorgente(String sorgente) throws DriverConfigurazioneException {
        if (sorgente == null) {
            throw new DriverConfigurazioneException("Sorgente non definita");
        }
        ValidatoreXSD validatoreRegistro = null;
        try {
            validatoreRegistro = new ValidatoreXSD(this.log, DriverConfigurazioneXML.class.getResourceAsStream("/config.xsd"));
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("Riscontrato errore durante l'inizializzazione dello schema della Configurazione XML di OpenSPCoop: " + e.getMessage());
        }
        FileInputStream fXML = null;
        try {
            if (sorgente.startsWith("http://") || sorgente.startsWith("file://")) {
                validatoreRegistro.valida(sorgente);
            } else {
                fXML = new FileInputStream(sorgente);
                validatoreRegistro.valida(fXML);
            }
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("Riscontrato errore durante la validazione XSD del Configurazione XML di OpenSPCoop: " + e.getMessage());
        }
        finally {
            if (fXML != null) {
                try {
                    fXML.close();
                }
                catch (Exception exception) {}
            }
        }
        try {
            IBindingFactory bfact = BindingDirectory.getFactory(Openspcoop2.class);
            IUnmarshallingContext uctx = bfact.createUnmarshallingContext();
            InputStream iStream = null;
            HttpURLConnection httpConn = null;
            if (sorgente.startsWith("http://") || sorgente.startsWith("file://")) {
                try {
                    URL url = new URL(sorgente);
                    URLConnection connection = url.openConnection();
                    httpConn = (HttpURLConnection)connection;
                    httpConn.setRequestMethod("GET");
                    httpConn.setDoOutput(true);
                    httpConn.setDoInput(true);
                    iStream = httpConn.getInputStream();
                }
                catch (Exception e) {
                    try {
                        if (iStream != null) {
                            iStream.close();
                        }
                        if (httpConn != null) {
                            httpConn.disconnect();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw new DriverConfigurazioneException("Riscontrato errore durante la creazione dell'inputStream del Configurazione (HTTP) : \n\n" + e.getMessage());
                }
            }
            try {
                iStream = new FileInputStream(sorgente);
            }
            catch (FileNotFoundException e) {
                throw new DriverConfigurazioneException("Riscontrato errore durante la creazione dell'inputStream del Configurazione (FILE) : \n\n" + e.getMessage());
            }
            try {
                this.sorgenteConfigurazione = (Openspcoop2)uctx.unmarshalDocument(this.readBytes(iStream), null);
            }
            catch (JiBXException e) {
                try {
                    if (iStream != null) {
                        iStream.close();
                    }
                    if (httpConn != null) {
                        httpConn.disconnect();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new DriverConfigurazioneException("Riscontrato errore durante l'unmarshall del file di configurazione: " + e.getMessage());
            }
            try {
                if (iStream != null) {
                    iStream.close();
                }
                if (httpConn != null) {
                    httpConn.disconnect();
                }
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("Riscontrato errore durante la chiusura dell'Input Stream: " + e.getMessage());
            }
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("Riscontrato errore durante l'istanziazione del registro: " + e.getMessage(), e);
        }
    }

    private InputStream readBytes(InputStream is) throws Exception {
        this.xmlUtils = XMLUtils.getInstance();
        byte[] b = new byte[]{};
        try {
            Document d = this.xmlUtils.newDocument(is);
            String xml = this.xmlUtils.toString(d, true);
            xml = Utilities.eraserXmlAttribute(xml, "xml:base=");
            b = xml.getBytes();
            return new ByteArrayInputStream(b);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    private void createSorgente(byte[] sorgente) throws DriverConfigurazioneException {
        if (sorgente == null) {
            throw new DriverConfigurazioneException("Sorgente non definita");
        }
        ValidatoreXSD validatoreRegistro = null;
        try {
            validatoreRegistro = new ValidatoreXSD(this.log, DriverConfigurazioneXML.class.getResourceAsStream("/config.xsd"));
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("Riscontrato errore durante l'inizializzazione dello schema della Configurazione XML di OpenSPCoop: " + e.getMessage());
        }
        try {
            validatoreRegistro.valida(new ByteArrayInputStream(sorgente));
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("Riscontrato errore durante la validazione XSD del Configurazione XML di OpenSPCoop: " + e.getMessage());
        }
        try {
            IBindingFactory bfact = BindingDirectory.getFactory(Openspcoop2.class);
            IUnmarshallingContext uctx = bfact.createUnmarshallingContext();
            InputStreamReader iStream = null;
            try {
                iStream = new InputStreamReader(new ByteArrayInputStream(sorgente));
            }
            catch (Exception e) {
                try {
                    if (iStream != null) {
                        iStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw new DriverConfigurazioneException("Riscontrato errore durante la creazione dell'inputStreamReader della Configurazione : \n\n" + e.getMessage());
            }
            try {
                this.sorgenteConfigurazione = (Openspcoop2)uctx.unmarshalDocument((Reader)iStream, null);
            }
            catch (JiBXException e) {
                try {
                    if (iStream != null) {
                        iStream.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new DriverConfigurazioneException("Riscontrato errore durante l'unmarshall del file di configurazione: " + e.getMessage());
            }
            try {
                if (iStream != null) {
                    iStream.close();
                }
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("Riscontrato errore durante la chiusura dell'Input Stream: " + e.getMessage());
            }
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("Riscontrato errore durante l'istanziazione del registro: " + e.getMessage(), e);
        }
    }

    public void convertXML(boolean reset, boolean aggiornamentoSoggetti) throws DriverConfigurazioneException {
        IDSoggetto idSoggetto;
        Soggetto soggetto;
        int i;
        if (reset) {
            try {
                this.log.info("Configurazione, reset in corso (Reset configurazione:" + this.gestioneConfigurazione + ")...");
                this.gestoreCRUD.reset(this.gestioneConfigurazione);
                this.log.info("Configurazione, reset effettuato.");
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new DriverConfigurazioneException("Reset del Configurazione non riuscita: " + e.getMessage(), e);
            }
        }
        try {
            for (i = 0; i < this.sorgenteConfigurazione.sizeSoggettoList(); ++i) {
                soggetto = this.sorgenteConfigurazione.getSoggetto(i);
                soggetto.setSuperUser(this.superUser);
                IDSoggetto idSoggetto2 = new IDSoggetto(soggetto.getTipo(), soggetto.getNome());
                if (!reset && this.gestoreCRUD.existsSoggetto(idSoggetto2)) {
                    if (!aggiornamentoSoggetti) continue;
                    this.log.info("Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " aggiornamento in corso...");
                    this.gestoreCRUD.updateSoggetto(soggetto);
                    this.log.info("Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " aggiornato.");
                    continue;
                }
                this.log.info("Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " creazione in corso...");
                this.gestoreCRUD.createSoggetto(soggetto);
                this.log.info("Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " creato.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DriverConfigurazioneException("Errore durante la conversione XML dei soggetti: " + e.getMessage(), e);
        }
        try {
            for (i = 0; i < this.sorgenteConfigurazione.sizeSoggettoList(); ++i) {
                soggetto = this.sorgenteConfigurazione.getSoggetto(i);
                for (int j = 0; j < soggetto.sizeServizioApplicativoList(); ++j) {
                    ServizioApplicativo servizioApplicativo = soggetto.getServizioApplicativo(j);
                    this.addServizioApplicativo(servizioApplicativo, soggetto, null, reset);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DriverConfigurazioneException("Errore durante la conversione XML dei servizi applicativi: " + e.getMessage(), e);
        }
        try {
            for (i = 0; i < this.sorgenteConfigurazione.sizeSoggettoList(); ++i) {
                soggetto = this.sorgenteConfigurazione.getSoggetto(i);
                for (int j = 0; j < soggetto.sizePortaDelegataList(); ++j) {
                    PortaDelegata pd = soggetto.getPortaDelegata(j);
                    Object nomePD = pd.getNome();
                    if (pd.getLocation() != null) {
                        nomePD = pd.getLocation();
                    }
                    nomePD = soggetto.getTipo() + soggetto.getNome() + "_" + (String)nomePD;
                    for (int k = 0; k < pd.sizeServizioApplicativoList(); ++k) {
                        ServizioApplicativo saPD = pd.getServizioApplicativo(k);
                        if (saPD.getInvocazionePorta() == null && saPD.getInvocazioneServizio() == null && saPD.getRispostaAsincrona() == null) continue;
                        saPD.setNome((String)nomePD + "_" + saPD.getNome());
                        this.addServizioApplicativo(saPD, soggetto, "Definizione Interna alla PortaDelegata", reset);
                    }
                    pd.setTipoSoggettoProprietario(soggetto.getTipo());
                    pd.setNomeSoggettoProprietario(soggetto.getNome());
                    XMLDataConverter.impostaInformazioniConfigurazione_PortaDelegata(pd);
                    idSoggetto = new IDSoggetto(soggetto.getTipo(), soggetto.getNome());
                    IDPortaDelegata idPD = new IDPortaDelegata();
                    idPD.setSoggettoFruitore(idSoggetto);
                    idPD.setLocationPD(pd.getNome());
                    if (pd.getLocation() != null) {
                        idPD.setLocationPD(pd.getLocation());
                    }
                    if (!reset && this.gestoreCRUD.existsPortaDelegata(idPD)) {
                        this.log.info("Porta delegata [" + pd.getNome() + "] del Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " aggiornamento in corso...");
                        this.gestoreCRUD.updatePortaDelegata(pd);
                        this.log.info("Porta delegata [" + pd.getNome() + "] del Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " aggiornato.");
                        continue;
                    }
                    this.log.info("Porta delegata [" + pd.getNome() + "] del Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " creazione in corso...");
                    this.gestoreCRUD.createPortaDelegata(pd);
                    this.log.info("Porta delegata [" + pd.getNome() + "] del Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " creato.");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DriverConfigurazioneException("Errore durante la conversione XML delle porte delegate: " + e.getMessage(), e);
        }
        try {
            for (i = 0; i < this.sorgenteConfigurazione.sizeSoggettoList(); ++i) {
                soggetto = this.sorgenteConfigurazione.getSoggetto(i);
                for (int j = 0; j < soggetto.sizePortaApplicativaList(); ++j) {
                    PortaApplicativa pa = soggetto.getPortaApplicativa(j);
                    Object nomePA = pa.getNome();
                    nomePA = soggetto.getTipo() + soggetto.getNome() + "_" + (String)nomePA;
                    for (int k = 0; k < pa.sizeServizioApplicativoList(); ++k) {
                        ServizioApplicativo saPA = pa.getServizioApplicativo(k);
                        if (saPA.getInvocazionePorta() == null && saPA.getInvocazioneServizio() == null && saPA.getRispostaAsincrona() == null) continue;
                        saPA.setNome((String)nomePA + "_" + saPA.getNome());
                        this.addServizioApplicativo(saPA, soggetto, "Definizione Interna alla PortaApplicativa", reset);
                    }
                    pa.setTipoSoggettoProprietario(soggetto.getTipo());
                    pa.setNomeSoggettoProprietario(soggetto.getNome());
                    XMLDataConverter.impostaInformazioniConfigurazione_PortaApplicativa(pa);
                    idSoggetto = new IDSoggetto(soggetto.getTipo(), soggetto.getNome());
                    if (!reset && this.gestoreCRUD.existsPortaApplicativa(pa.getNome(), idSoggetto)) {
                        this.log.info("Porta applicativa [" + pa.getNome() + "] del Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " aggiornamento in corso...");
                        this.gestoreCRUD.updatePortaApplicativa(pa);
                        this.log.info("Porta applicativa [" + pa.getNome() + "] del Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " aggiornato.");
                        continue;
                    }
                    this.log.info("Porta applicativa [" + pa.getNome() + "] del Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " creazione in corso...");
                    this.gestoreCRUD.createPortaApplicativa(pa);
                    this.log.info("Porta applicativa [" + pa.getNome() + "] del Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " creato.");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DriverConfigurazioneException("Errore durante la conversione XML delle porte applicative: " + e.getMessage(), e);
        }
        if (this.gestioneConfigurazione) {
            try {
                this.log.info("Routing Table, creazione/aggiornamento in corso...");
                if (this.sorgenteConfigurazione.getConfigurazione() != null && this.sorgenteConfigurazione.getConfigurazione().getRoutingTable() != null) {
                    if (reset) {
                        this.gestoreCRUD.createRoutingTable(this.sorgenteConfigurazione.getConfigurazione().getRoutingTable());
                        this.log.info("Routing Table, creazione effettuata.");
                    } else {
                        this.gestoreCRUD.updateRoutingTable(this.sorgenteConfigurazione.getConfigurazione().getRoutingTable());
                        this.log.info("Routing Table, aggiornamento effettuato.");
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new DriverConfigurazioneException("Errore durante la conversione XML della routing table: " + e.getMessage(), e);
            }
            try {
                this.log.info("Accesso registro, creazione in corso...");
                if (this.sorgenteConfigurazione.getConfigurazione() != null && this.sorgenteConfigurazione.getConfigurazione().getAccessoRegistro() != null) {
                    if (reset) {
                        this.gestoreCRUD.createAccessoRegistro(this.sorgenteConfigurazione.getConfigurazione().getAccessoRegistro());
                        this.log.info("Accesso registro, creazione effettuata.");
                    } else {
                        this.gestoreCRUD.updateAccessoRegistro(this.sorgenteConfigurazione.getConfigurazione().getAccessoRegistro());
                        this.log.info("Accesso registro, aggiornamento effettuato.");
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new DriverConfigurazioneException("Errore durante la conversione XML dei dati di accesso al registro: " + e.getMessage(), e);
            }
            try {
                this.log.info("GestioneErrore, creazione in corso...");
                if (this.sorgenteConfigurazione.getConfigurazione() != null && this.sorgenteConfigurazione.getConfigurazione().getGestioneErrore() != null && this.sorgenteConfigurazione.getConfigurazione().getGestioneErrore().getComponenteCooperazione() != null) {
                    if (reset) {
                        this.gestoreCRUD.createGestioneErroreComponenteCooperazione(this.sorgenteConfigurazione.getConfigurazione().getGestioneErrore().getComponenteCooperazione());
                        this.log.info("GestioneErrore, creazione effettuata.");
                    } else {
                        this.gestoreCRUD.updateGestioneErroreComponenteCooperazione(this.sorgenteConfigurazione.getConfigurazione().getGestioneErrore().getComponenteCooperazione());
                        this.log.info("GestioneErrore, aggiornamento effettuato.");
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new DriverConfigurazioneException("Errore durante la conversione XML dei dati di gestione dell'errore del connettore per il componente di cooperazione: " + e.getMessage(), e);
            }
            try {
                this.log.info("GestioneErrore, creazione in corso...");
                if (this.sorgenteConfigurazione.getConfigurazione() != null && this.sorgenteConfigurazione.getConfigurazione().getGestioneErrore() != null && this.sorgenteConfigurazione.getConfigurazione().getGestioneErrore().getComponenteIntegrazione() != null) {
                    if (reset) {
                        this.gestoreCRUD.createGestioneErroreComponenteIntegrazione(this.sorgenteConfigurazione.getConfigurazione().getGestioneErrore().getComponenteIntegrazione());
                        this.log.info("GestioneErrore, creazione effettuata.");
                    } else {
                        this.gestoreCRUD.updateGestioneErroreComponenteIntegrazione(this.sorgenteConfigurazione.getConfigurazione().getGestioneErrore().getComponenteIntegrazione());
                        this.log.info("GestioneErrore, aggiornamento effettuato.");
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new DriverConfigurazioneException("Errore durante la conversione XML dei dati di gestione dell'errore del connettore per il componente di integrazione: " + e.getMessage(), e);
            }
            try {
                this.log.info("Configurazione, creazione in corso...");
                if (this.sorgenteConfigurazione.getConfigurazione() != null) {
                    if (reset) {
                        this.gestoreCRUD.createConfigurazione(this.sorgenteConfigurazione.getConfigurazione());
                        this.log.info("Configurazione, creazione effettuata.");
                    } else {
                        this.gestoreCRUD.updateConfigurazione(this.sorgenteConfigurazione.getConfigurazione());
                        this.log.info("Configurazione, aggiornamento effettuato.");
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new DriverConfigurazioneException("Errore durante la conversione XML della Configurazione: " + e.getMessage(), e);
            }
        }
    }

    public void delete(boolean deleteSoggetti) throws DriverConfigurazioneException {
        IDSoggetto idSoggetto;
        int j;
        Soggetto soggetto;
        int i;
        try {
            for (i = 0; i < this.sorgenteConfigurazione.sizeSoggettoList(); ++i) {
                soggetto = this.sorgenteConfigurazione.getSoggetto(i);
                for (j = 0; j < soggetto.sizePortaDelegataList(); ++j) {
                    PortaDelegata pd = soggetto.getPortaDelegata(j);
                    idSoggetto = new IDSoggetto(soggetto.getTipo(), soggetto.getNome());
                    IDPortaDelegata idPD = new IDPortaDelegata();
                    idPD.setSoggettoFruitore(idSoggetto);
                    idPD.setLocationPD(pd.getNome());
                    if (pd.getLocation() != null) {
                        idPD.setLocationPD(pd.getLocation());
                    }
                    this.log.info("Porta delegata [" + pd.getNome() + "] del Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " eliminazione in corso...");
                    if (this.gestoreCRUD.existsPortaDelegata(idPD)) {
                        this.gestoreCRUD.deletePortaDelegata(((IDriverConfigurazioneGet)((Object)this.gestoreCRUD)).getPortaDelegata(idPD));
                    }
                    this.log.info("Porta delegata [" + pd.getNome() + "] del Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " eliminata.");
                    Object nomePD = pd.getNome();
                    if (pd.getLocation() != null) {
                        nomePD = pd.getLocation();
                    }
                    nomePD = soggetto.getTipo() + soggetto.getNome() + "_" + (String)nomePD;
                    for (int k = 0; k < pd.sizeServizioApplicativoList(); ++k) {
                        ServizioApplicativo saPD = pd.getServizioApplicativo(k);
                        if (saPD.getInvocazionePorta() == null && saPD.getInvocazioneServizio() == null && saPD.getRispostaAsincrona() == null) continue;
                        saPD.setNome((String)nomePD + "_" + saPD.getNome());
                        this.log.info("Servizio Applicativo [" + saPD.getNome() + "] [Definizione Interna alla PortaDelegata] del Soggetto " + idSoggetto.getTipo() + "/" + idSoggetto.getNome() + " eliminazione in corso...");
                        if (this.gestoreCRUD.existsServizioApplicativo(idSoggetto, saPD.getNome())) {
                            this.gestoreCRUD.deleteServizioApplicativo(((IDriverConfigurazioneGet)((Object)this.gestoreCRUD)).getServizioApplicativo(idSoggetto, saPD.getNome()));
                        }
                        this.log.info("Servizio Applicativo [" + saPD.getNome() + "] [Definizione Interna alla PortaDelegata] del Soggetto " + idSoggetto.getTipo() + "/" + idSoggetto.getNome() + " eliminato.");
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DriverConfigurazioneException("Errore durante l'eliminazione delle porte delegate: " + e.getMessage(), e);
        }
        try {
            for (i = 0; i < this.sorgenteConfigurazione.sizeSoggettoList(); ++i) {
                soggetto = this.sorgenteConfigurazione.getSoggetto(i);
                for (j = 0; j < soggetto.sizePortaApplicativaList(); ++j) {
                    PortaApplicativa pa = soggetto.getPortaApplicativa(j);
                    idSoggetto = new IDSoggetto(soggetto.getTipo(), soggetto.getNome());
                    IDPortaApplicativa idPA = new IDPortaApplicativa();
                    String azione = null;
                    if (pa.getAzione() != null) {
                        azione = pa.getAzione().getNome();
                    }
                    idPA.setIDServizio(new IDServizio(idSoggetto, pa.getServizio().getTipo(), pa.getServizio().getNome(), azione));
                    this.log.info("Porta applicativa [" + pa.getNome() + "] del Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " eliminazione in corso...");
                    if (this.gestoreCRUD.existsPortaApplicativa(idPA, true)) {
                        this.gestoreCRUD.deletePortaApplicativa(((IDriverConfigurazioneGet)((Object)this.gestoreCRUD)).getPortaApplicativa(idPA));
                    }
                    this.log.info("Porta applicativa [" + pa.getNome() + "] del Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " eliminata.");
                    Object nomePA = pa.getNome();
                    nomePA = soggetto.getTipo() + soggetto.getNome() + "_" + (String)nomePA;
                    for (int k = 0; k < pa.sizeServizioApplicativoList(); ++k) {
                        ServizioApplicativo saPA = pa.getServizioApplicativo(k);
                        if (saPA.getInvocazionePorta() == null && saPA.getInvocazioneServizio() == null && saPA.getRispostaAsincrona() == null) continue;
                        saPA.setNome((String)nomePA + "_" + saPA.getNome());
                        this.log.info("Servizio Applicativo [" + saPA.getNome() + "] [Definizione Interna alla PortaApplicativa] del Soggetto " + idSoggetto.getTipo() + "/" + idSoggetto.getNome() + " eliminazione in corso...");
                        if (this.gestoreCRUD.existsServizioApplicativo(idSoggetto, saPA.getNome())) {
                            this.gestoreCRUD.deleteServizioApplicativo(((IDriverConfigurazioneGet)((Object)this.gestoreCRUD)).getServizioApplicativo(idSoggetto, saPA.getNome()));
                        }
                        this.log.info("Servizio Applicativo [" + saPA.getNome() + "] [Definizione Interna alla PortaApplicativa] del Soggetto " + idSoggetto.getTipo() + "/" + idSoggetto.getNome() + " eliminato.");
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DriverConfigurazioneException("Errore durante l'eliminazione delle porte applicative: " + e.getMessage(), e);
        }
        try {
            for (i = 0; i < this.sorgenteConfigurazione.sizeSoggettoList(); ++i) {
                soggetto = this.sorgenteConfigurazione.getSoggetto(i);
                for (j = 0; j < soggetto.sizeServizioApplicativoList(); ++j) {
                    ServizioApplicativo servizioApplicativo = soggetto.getServizioApplicativo(j);
                    idSoggetto = new IDSoggetto(soggetto.getTipo(), soggetto.getNome());
                    this.log.info("Servizio Applicativo [" + servizioApplicativo.getNome() + "] del Soggetto " + idSoggetto.getTipo() + "/" + idSoggetto.getNome() + " eliminazione in corso...");
                    if (this.gestoreCRUD.existsServizioApplicativo(idSoggetto, servizioApplicativo.getNome())) {
                        this.gestoreCRUD.deleteServizioApplicativo(((IDriverConfigurazioneGet)((Object)this.gestoreCRUD)).getServizioApplicativo(idSoggetto, servizioApplicativo.getNome()));
                    }
                    this.log.info("Servizio Applicativo [" + servizioApplicativo.getNome() + "] del Soggetto " + idSoggetto.getTipo() + "/" + idSoggetto.getNome() + " eliminato.");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DriverConfigurazioneException("Errore durante l'eliminazione dei servizi applicativi: " + e.getMessage(), e);
        }
        if (deleteSoggetti) {
            try {
                for (i = 0; i < this.sorgenteConfigurazione.sizeSoggettoList(); ++i) {
                    soggetto = this.sorgenteConfigurazione.getSoggetto(i);
                    IDSoggetto idSoggetto2 = new IDSoggetto(soggetto.getTipo(), soggetto.getNome());
                    this.log.info("Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " eliminazione in corso...");
                    if (this.gestoreCRUD.existsSoggetto(idSoggetto2)) {
                        this.gestoreCRUD.deleteSoggetto(((IDriverConfigurazioneGet)((Object)this.gestoreCRUD)).getSoggetto(idSoggetto2));
                    }
                    this.log.info("Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " eliminato.");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new DriverConfigurazioneException("Errore durante l'eliminazione dei soggetti: " + e.getMessage(), e);
            }
        }
    }

    private static void gestioneDefaultConnettoreHTTP(Connettore connettore) {
        if (connettore.getProperties() != null) {
            Property cp;
            if (!connettore.getProperties().containsKey("trustStoreType")) {
                cp = new Property();
                cp.setNome("trustStoreType");
                cp.setValore("jks");
                connettore.addProperty(cp);
            }
            if (!connettore.getProperties().containsKey("trustManagementAlgorithm")) {
                cp = new Property();
                cp.setNome("trustManagementAlgorithm");
                cp.setValore(TrustManagerFactory.getDefaultAlgorithm());
                connettore.addProperty(cp);
            }
            if (connettore.getProperties().containsKey("keyStoreLocation")) {
                if (!connettore.getProperties().containsKey("keyStoreType")) {
                    cp = new Property();
                    cp.setNome("keyStoreType");
                    cp.setValore("jks");
                    connettore.addProperty(cp);
                }
                if (!connettore.getProperties().containsKey("keyManagementAlgorithm")) {
                    cp = new Property();
                    cp.setNome("keyManagementAlgorithm");
                    cp.setValore(KeyManagerFactory.getDefaultAlgorithm());
                    connettore.addProperty(cp);
                }
            }
        }
    }

    public static void impostaInformazioniConfigurazione_PortaDelegata(PortaDelegata pd) {
        if (pd.getMessageSecurity() != null && (pd.getMessageSecurity().getRequestFlow() != null && pd.getMessageSecurity().getRequestFlow().sizeParameterList() > 0 || pd.getMessageSecurity().getResponseFlow() != null && pd.getMessageSecurity().getResponseFlow().sizeParameterList() > 0)) {
            pd.setStatoMessageSecurity(CostantiConfigurazione.ABILITATO.toString());
        }
    }

    public static void impostaInformazioniConfigurazione_PortaApplicativa(PortaApplicativa pa) {
        if (pa.getMessageSecurity() != null && (pa.getMessageSecurity().getRequestFlow() != null && pa.getMessageSecurity().getRequestFlow().sizeParameterList() > 0 || pa.getMessageSecurity().getResponseFlow() != null && pa.getMessageSecurity().getResponseFlow().sizeParameterList() > 0)) {
            pa.setStatoMessageSecurity(CostantiConfigurazione.ABILITATO.toString());
        }
    }

    public static void impostaInformazioniConfigurazione_ServizioApplicativo(ServizioApplicativo servizioApplicativo, Soggetto soggettoProprietario, String posizione, Logger log, String tipoBEDestinazione) {
        Credenziali credenziali;
        if (servizioApplicativo.getInvocazionePorta() == null) {
            InvocazionePorta saInv = new InvocazionePorta();
            Credenziali credenziali2 = new Credenziali();
            credenziali2.setTipo(CredenzialeTipo.toEnumConstant("none"));
            saInv.addCredenziali(credenziali2);
            InvocazionePortaGestioneErrore ge = new InvocazionePortaGestioneErrore();
            ge.setFault(CostantiConfigurazione.ERRORE_APPLICATIVO_SOAP);
            saInv.setGestioneErrore(ge);
            servizioApplicativo.setInvocazionePorta(saInv);
        } else {
            if (servizioApplicativo.getInvocazionePorta().getGestioneErrore() == null) {
                InvocazionePortaGestioneErrore ge = new InvocazionePortaGestioneErrore();
                ge.setFault(CostantiConfigurazione.ERRORE_APPLICATIVO_SOAP);
                servizioApplicativo.getInvocazionePorta().setGestioneErrore(ge);
            } else if (servizioApplicativo.getInvocazionePorta().getGestioneErrore().getFault() == null) {
                servizioApplicativo.getInvocazionePorta().getGestioneErrore().setFault(CostantiConfigurazione.ERRORE_APPLICATIVO_SOAP);
            }
            if (servizioApplicativo.getInvocazionePorta().sizeCredenzialiList() == 0) {
                credenziali = new Credenziali();
                credenziali.setTipo(CredenzialeTipo.toEnumConstant("none"));
                servizioApplicativo.getInvocazionePorta().addCredenziali(credenziali);
            }
        }
        if (servizioApplicativo.getInvocazioneServizio() != null && servizioApplicativo.getInvocazioneServizio().getConnettore() != null) {
            if (servizioApplicativo.getInvocazioneServizio().getConnettore().getTipo() == null) {
                for (int con = 0; con < soggettoProprietario.sizeConnettoreList(); ++con) {
                    if (!soggettoProprietario.getConnettore(con).getNome().equals(servizioApplicativo.getInvocazioneServizio().getConnettore().getNome())) continue;
                    servizioApplicativo.getInvocazioneServizio().setConnettore(soggettoProprietario.getConnettore(con));
                    break;
                }
                log.info("Servizio Applicativo [" + servizioApplicativo.getNome() + "]" + posizione + " del Soggetto " + soggettoProprietario.getTipo() + "/" + soggettoProprietario.getNome() + " connettore inv servizio di tipo, dopo ricerca [" + servizioApplicativo.getInvocazioneServizio().getConnettore().getTipo() + "]");
            } else {
                log.info("Servizio Applicativo [" + servizioApplicativo.getNome() + "]" + posizione + " del Soggetto " + soggettoProprietario.getTipo() + "/" + soggettoProprietario.getNome() + " connettore inv servizio di tipo [" + servizioApplicativo.getInvocazioneServizio().getConnettore().getTipo() + "]");
            }
            if ("db".equals(tipoBEDestinazione)) {
                servizioApplicativo.getInvocazioneServizio().getConnettore().setNome(null);
                String tipoConnettore = servizioApplicativo.getInvocazioneServizio().getConnettore().getTipo();
                if (!(TipiConnettore.JMS.getNome().equals(tipoConnettore) || TipiConnettore.HTTP.getNome().equals(tipoConnettore) || TipiConnettore.DISABILITATO.getNome().equals(tipoConnettore) || TipiConnettore.NULL.getNome().equals(tipoConnettore) || TipiConnettore.NULLECHO.getNome().equals(tipoConnettore))) {
                    servizioApplicativo.getInvocazioneServizio().getConnettore().setCustom(true);
                }
                if (TipiConnettore.HTTPS.getNome().equals(tipoConnettore)) {
                    XMLDataConverter.gestioneDefaultConnettoreHTTP(servizioApplicativo.getInvocazioneServizio().getConnettore());
                }
            }
        } else if (servizioApplicativo.getInvocazioneServizio() == null) {
            credenziali = new Credenziali();
            credenziali.setTipo(CredenzialeTipo.toEnumConstant("none"));
            InvocazioneServizio invServizio = new InvocazioneServizio();
            invServizio.setAutenticazione(InvocazioneServizioTipoAutenticazione.toEnumConstant("none"));
            invServizio.setGetMessage(CostantiConfigurazione.DISABILITATO);
            servizioApplicativo.setInvocazioneServizio(invServizio);
        }
        if (servizioApplicativo.getInvocazioneServizio() != null && servizioApplicativo.getInvocazioneServizio().getGetMessage() == null) {
            servizioApplicativo.getInvocazioneServizio().setGetMessage(CostantiConfigurazione.DISABILITATO);
        }
        if (servizioApplicativo.getRispostaAsincrona() != null && servizioApplicativo.getRispostaAsincrona().getConnettore() != null) {
            if (servizioApplicativo.getRispostaAsincrona().getConnettore().getTipo() == null) {
                for (int con = 0; con < soggettoProprietario.sizeConnettoreList(); ++con) {
                    if (!soggettoProprietario.getConnettore(con).getNome().equals(servizioApplicativo.getRispostaAsincrona().getConnettore().getNome())) continue;
                    servizioApplicativo.getRispostaAsincrona().setConnettore(soggettoProprietario.getConnettore(con));
                    break;
                }
                log.info("Servizio Applicativo [" + servizioApplicativo.getNome() + "]" + posizione + " del Soggetto " + soggettoProprietario.getTipo() + "/" + soggettoProprietario.getNome() + " connettore risposta asincrona di tipo, dopo ricerca [" + servizioApplicativo.getRispostaAsincrona().getConnettore().getTipo() + "]");
            } else {
                log.info("Servizio Applicativo [" + servizioApplicativo.getNome() + "]" + posizione + " del Soggetto " + soggettoProprietario.getTipo() + "/" + soggettoProprietario.getNome() + " connettore risposta asincrona di tipo [" + servizioApplicativo.getRispostaAsincrona().getConnettore().getTipo() + "]");
            }
            if ("db".equals(tipoBEDestinazione)) {
                servizioApplicativo.getRispostaAsincrona().getConnettore().setNome(null);
                String tipoConnettore = servizioApplicativo.getRispostaAsincrona().getConnettore().getTipo();
                if (!(TipiConnettore.JMS.getNome().equals(tipoConnettore) || TipiConnettore.HTTP.getNome().equals(tipoConnettore) || TipiConnettore.DISABILITATO.getNome().equals(tipoConnettore) || TipiConnettore.NULL.getNome().equals(tipoConnettore) || TipiConnettore.NULLECHO.getNome().equals(tipoConnettore))) {
                    servizioApplicativo.getRispostaAsincrona().getConnettore().setCustom(true);
                }
                if (TipiConnettore.HTTPS.getNome().equals(tipoConnettore)) {
                    XMLDataConverter.gestioneDefaultConnettoreHTTP(servizioApplicativo.getRispostaAsincrona().getConnettore());
                }
            }
        } else if (servizioApplicativo.getRispostaAsincrona() == null) {
            Credenziali credenziali3 = new Credenziali();
            credenziali3.setTipo(CredenzialeTipo.toEnumConstant("none"));
            RispostaAsincrona rispostaAsinc = new RispostaAsincrona();
            rispostaAsinc.setAutenticazione(InvocazioneServizioTipoAutenticazione.toEnumConstant("none"));
            rispostaAsinc.setGetMessage(CostantiConfigurazione.DISABILITATO);
            servizioApplicativo.setRispostaAsincrona(rispostaAsinc);
        }
        if (servizioApplicativo.getRispostaAsincrona() != null && servizioApplicativo.getRispostaAsincrona().getGetMessage() == null) {
            servizioApplicativo.getRispostaAsincrona().setGetMessage(CostantiConfigurazione.DISABILITATO);
        }
        if (CostantiConfigurazione.REGISTRO_DB.equals(tipoBEDestinazione)) {
            if (servizioApplicativo.getInvocazioneServizio() != null && servizioApplicativo.getInvocazioneServizio().getConnettore() != null) {
                servizioApplicativo.getInvocazioneServizio().getConnettore().setNome(null);
                String tipoConnettore = servizioApplicativo.getInvocazioneServizio().getConnettore().getTipo();
                if (!(TipiConnettore.JMS.getNome().equals(tipoConnettore) || TipiConnettore.HTTP.getNome().equals(tipoConnettore) || TipiConnettore.DISABILITATO.getNome().equals(tipoConnettore) || TipiConnettore.NULL.getNome().equals(tipoConnettore) || TipiConnettore.NULLECHO.getNome().equals(tipoConnettore))) {
                    servizioApplicativo.getInvocazioneServizio().getConnettore().setCustom(true);
                }
                if (TipiConnettore.HTTPS.getNome().equals(tipoConnettore)) {
                    XMLDataConverter.gestioneDefaultConnettoreHTTP(servizioApplicativo.getInvocazioneServizio().getConnettore());
                }
            }
            if (servizioApplicativo.getRispostaAsincrona() != null && servizioApplicativo.getRispostaAsincrona().getConnettore() != null) {
                servizioApplicativo.getRispostaAsincrona().getConnettore().setNome(null);
                String tipoConnettore = servizioApplicativo.getRispostaAsincrona().getConnettore().getTipo();
                if (!(TipiConnettore.JMS.getNome().equals(tipoConnettore) || TipiConnettore.HTTP.getNome().equals(tipoConnettore) || TipiConnettore.DISABILITATO.getNome().equals(tipoConnettore) || TipiConnettore.NULL.getNome().equals(tipoConnettore) || TipiConnettore.NULLECHO.getNome().equals(tipoConnettore))) {
                    servizioApplicativo.getRispostaAsincrona().getConnettore().setCustom(true);
                }
                if (TipiConnettore.HTTPS.getNome().equals(tipoConnettore)) {
                    XMLDataConverter.gestioneDefaultConnettoreHTTP(servizioApplicativo.getRispostaAsincrona().getConnettore());
                }
            }
        }
    }

    public static void impostaInformazioniConfigurazione_ServizioApplicativo_update(ServizioApplicativo servizioApplicativo, ServizioApplicativo old) {
        servizioApplicativo.setId(old.getId());
        if (servizioApplicativo.getInvocazioneServizio() != null) {
            if (servizioApplicativo.getInvocazioneServizio().getConnettore() == null) {
                if (old.getInvocazioneServizio() != null) {
                    servizioApplicativo.getInvocazioneServizio().setConnettore(old.getInvocazioneServizio().getConnettore());
                }
            } else if (old.getInvocazioneServizio() != null && old.getInvocazioneServizio().getConnettore() != null) {
                servizioApplicativo.getInvocazioneServizio().getConnettore().setId(old.getInvocazioneServizio().getConnettore().getId());
                servizioApplicativo.getInvocazioneServizio().getConnettore().setNome(old.getInvocazioneServizio().getConnettore().getNome());
            }
        }
        if (servizioApplicativo.getRispostaAsincrona() != null) {
            if (servizioApplicativo.getRispostaAsincrona().getConnettore() == null) {
                if (old.getRispostaAsincrona() != null) {
                    servizioApplicativo.getRispostaAsincrona().setConnettore(old.getRispostaAsincrona().getConnettore());
                }
            } else if (old.getRispostaAsincrona() != null && old.getRispostaAsincrona().getConnettore() != null) {
                servizioApplicativo.getRispostaAsincrona().getConnettore().setId(old.getRispostaAsincrona().getConnettore().getId());
                servizioApplicativo.getRispostaAsincrona().getConnettore().setNome(old.getRispostaAsincrona().getConnettore().getNome());
            }
        }
    }

    private void addServizioApplicativo(ServizioApplicativo servizioApplicativo, Soggetto soggettoProprietario, String posizione, boolean reset) throws Exception {
        servizioApplicativo.setTipoSoggettoProprietario(soggettoProprietario.getTipo());
        servizioApplicativo.setNomeSoggettoProprietario(soggettoProprietario.getNome());
        Object pos = "";
        if (posizione != null) {
            pos = "[" + posizione + "]";
        }
        XMLDataConverter.impostaInformazioniConfigurazione_ServizioApplicativo(servizioApplicativo, soggettoProprietario, (String)pos, this.log, this.tipoBEDestinazione);
        IDSoggetto idSoggetto = new IDSoggetto(soggettoProprietario.getTipo(), soggettoProprietario.getNome());
        if (!reset && this.gestoreCRUD.existsServizioApplicativo(idSoggetto, servizioApplicativo.getNome())) {
            this.log.info("Servizio Applicativo [" + servizioApplicativo.getNome() + "]" + (String)pos + " del Soggetto " + soggettoProprietario.getTipo() + "/" + soggettoProprietario.getNome() + " aggiornamento in corso...");
            IDPortaDelegata idPD = new IDPortaDelegata();
            idPD.setSoggettoFruitore(new IDSoggetto(soggettoProprietario.getTipo(), soggettoProprietario.getNome()));
            ServizioApplicativo old = ((IDriverConfigurazioneGet)((Object)this.gestoreCRUD)).getServizioApplicativo(idPD, servizioApplicativo.getNome());
            XMLDataConverter.impostaInformazioniConfigurazione_ServizioApplicativo_update(servizioApplicativo, old);
            this.gestoreCRUD.updateServizioApplicativo(servizioApplicativo);
            this.log.info("Servizio Applicativo [" + servizioApplicativo.getNome() + "]" + (String)pos + " del Soggetto " + soggettoProprietario.getTipo() + "/" + soggettoProprietario.getNome() + " aggiornato.");
        } else {
            this.log.info("Servizio Applicativo [" + servizioApplicativo.getNome() + "]" + (String)pos + " del Soggetto " + soggettoProprietario.getTipo() + "/" + soggettoProprietario.getNome() + " creazione in corso...");
            this.gestoreCRUD.createServizioApplicativo(servizioApplicativo);
            this.log.info("Servizio Applicativo [" + servizioApplicativo.getNome() + "]" + (String)pos + " del Soggetto " + soggettoProprietario.getTipo() + "/" + soggettoProprietario.getNome() + " creato.");
        }
    }
}

