/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.driver.utils;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.Openspcoop2;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.driver.ValidazioneSemantica;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.driver.db.DriverConfigurazioneDB;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.driver.xml.DriverConfigurazioneXML;
import it.link.pdd.tools.migrazione_govway.utils.LoggerWrapperFactory;
import it.link.pdd.tools.migrazione_govway.utils.Utilities;
import it.link.pdd.tools.migrazione_govway.utils.resources.Loader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Properties;
import org.apache.logging.log4j.Level;
import org.slf4j.Logger;

public class TestValidazioneSemantica {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) throws Exception {
        if (args.length < 4) {
            String errorMsg = "ERROR, Usage:  java TestValidazioneSemantica commonProperties tipoConfigurazione proprietaConfigurazione validazioneConfigurazione";
            System.err.println(errorMsg);
            throw new Exception(errorMsg);
        }
        try {
            if (args.length == 5) {
                LoggerWrapperFactory.setLogConfiguration(args[4]);
            } else {
                URL url = TestValidazioneSemantica.class.getResource("/validator.log4j2.properties");
                if (url != null) {
                    LoggerWrapperFactory.setLogConfiguration(url);
                } else {
                    File logFile = File.createTempFile("testValidazioneSemanticaConfigurazione_", ".log");
                    System.out.println("LogMessages write in " + logFile.getAbsolutePath());
                    LoggerWrapperFactory.setDefaultLogConfiguration(Level.ALL, false, null, logFile, "%p <%d{dd-MM-yyyy HH:mm:ss}> %C.%M(%L): %m %n %n");
                }
            }
        }
        catch (Exception e) {
            String errorMsg = "Errore durante il caricamento del file di log: " + e.getMessage();
            System.err.println(errorMsg);
            System.out.println("Args.length: " + args.length);
            for (int i = 0; i < args.length; ++i) {
                System.out.println("Arg[" + i + "]=[" + args[i] + "]");
            }
            throw new Exception(errorMsg, e);
        }
        Logger log = LoggerWrapperFactory.getLogger("validatoreDatiConfigurazione");
        Properties commonProperties = new Properties();
        try {
            commonProperties.load(new FileInputStream(args[0]));
        }
        catch (IOException e) {
            String errorMsg = "Errore durante il caricamento del file di properties [" + args[0] + "] : " + e.getMessage();
            log.error(errorMsg, (Throwable)e);
            throw new Exception(errorMsg, e);
        }
        Properties reader = new Properties();
        try {
            reader.load(new FileInputStream(args[2]));
        }
        catch (IOException e) {
            String errorMsg = "Errore durante il caricamento del file di properties [" + args[2] + "] : " + e.getMessage();
            log.error(errorMsg, (Throwable)e);
            throw new Exception(errorMsg, e);
        }
        Openspcoop2 configurazione = null;
        Connection connectionDB = null;
        String tipoConfigurazione = args[1];
        boolean validaSezioneConfigurazione = Boolean.parseBoolean(args[2]);
        if ("xml".equals(tipoConfigurazione)) {
            String path = reader.getProperty("openspcoop2.configurazione.xml");
            if (path == null) {
                throw new Exception("Non e' stato definito il path dove localizzare la configurazione xml");
            }
            path = path.trim();
            DriverConfigurazioneXML driver = new DriverConfigurazioneXML(path, log);
            if (!driver.create) {
                throw new Exception("ConfigurazionePdD XML non inizializzata");
            }
            log.info("Inizializzata Configurazione PdD XML");
            configurazione = driver.getImmagineCompletaConfigurazionePdD();
        } else {
            if (!"db".equals(tipoConfigurazione)) throw new Exception("Tipo di configurazione [" + tipoConfigurazione + "] non gestita");
            String tipoDatabase = reader.getProperty("openspcoop2.configurazione.db.tipo");
            if (tipoDatabase == null) {
                throw new Exception("Non e' stato definito il tipo di database");
            }
            tipoDatabase = tipoDatabase.trim();
            String dataSource = reader.getProperty("openspcoop2.configurazione.db.dataSource");
            if (dataSource != null) {
                dataSource = dataSource.trim();
                Properties context = Utilities.readProperties("openspcoop2.configurazione.db.context.", reader);
                DriverConfigurazioneDB driver = new DriverConfigurazioneDB(dataSource, context, log, tipoDatabase);
                if (!driver.create) {
                    throw new Exception("Configurazione DB non inizializzata");
                }
                log.info("Inizializzata Configurazione DB");
                configurazione = driver.getImmagineCompletaConfigurazionePdD();
            } else {
                String connection = reader.getProperty("openspcoop2.configurazione.db.url");
                if (connection == null) {
                    throw new Exception("Non e' stata definita una destinazione ne attraverso un datasource, ne attraverso una connessione diretta");
                }
                connection = connection.trim();
                String driverJDBC = reader.getProperty("openspcoop2.configurazione.db.driver");
                if (driverJDBC == null) {
                    throw new Exception("Connessione diretta: non e' stato definito il Driver");
                }
                driverJDBC = driverJDBC.trim();
                String username = reader.getProperty("openspcoop2.configurazione.db.user");
                String password = reader.getProperty("openspcoop2.configurazione.db.password");
                if (username != null) {
                    username = username.trim();
                }
                if (password != null) {
                    password = password.trim();
                }
                Loader.getInstance().newInstance(driverJDBC);
                try {
                    connectionDB = username != null ? DriverManager.getConnection(connection, username, password) : DriverManager.getConnection(connection);
                    DriverConfigurazioneDB driver = new DriverConfigurazioneDB(connectionDB, log, tipoDatabase);
                    if (!driver.create) {
                        throw new Exception("Configurazione DB non inizializzata");
                    }
                    log.info("Inizializzata Configurazione DB");
                    configurazione = driver.getImmagineCompletaConfigurazionePdD();
                }
                finally {
                    try {
                        if (connectionDB != null) {
                            connectionDB.close();
                        }
                    }
                    catch (Exception driver) {}
                }
            }
        }
        try {
            String tipiConnettori = commonProperties.getProperty("openspcoop2.tipiConnettori");
            if (tipiConnettori == null) {
                throw new Exception("Non sono stati definiti i tipi di connettori supportati");
            }
            tipiConnettori = tipiConnettori.trim();
            String[] tipoConnettoriArray = tipiConnettori.split(",");
            for (int i = 0; i < tipoConnettoriArray.length; ++i) {
                tipoConnettoriArray[i] = tipoConnettoriArray[i].trim();
            }
            String tipiSoggetti = commonProperties.getProperty("openspcoop2.tipiSoggetti");
            if (tipiSoggetti == null) {
                throw new Exception("Non sono stati definiti i tipi di soggetti supportati");
            }
            tipiSoggetti = tipiSoggetti.trim();
            String[] tipoSoggettiArray = tipiSoggetti.split(",");
            for (int i = 0; i < tipoSoggettiArray.length; ++i) {
                tipoSoggettiArray[i] = tipoSoggettiArray[i].trim();
            }
            String tipiServizi = commonProperties.getProperty("openspcoop2.tipiServizi");
            if (tipiServizi == null) {
                throw new Exception("Non sono stati definiti i tipi di Servizi supportati");
            }
            tipiServizi = tipiServizi.trim();
            String[] tipoServiziArray = tipiServizi.split(",");
            for (int i = 0; i < tipoServiziArray.length; ++i) {
                tipoServiziArray[i] = tipoServiziArray[i].trim();
            }
            String tipiDiagnosticiAppender = commonProperties.getProperty("openspcoop2.diagnostici.appender");
            if (tipiDiagnosticiAppender == null) {
                throw new Exception("Non sono stati definiti i tipi di appender supportati (diagnostici)");
            }
            tipiDiagnosticiAppender = tipiServizi.trim();
            String[] tipiDiagnosticiAppenderArray = tipiDiagnosticiAppender.split(",");
            for (int i = 0; i < tipiDiagnosticiAppenderArray.length; ++i) {
                tipiDiagnosticiAppenderArray[i] = tipiDiagnosticiAppenderArray[i].trim();
            }
            String tipiTracceAppender = commonProperties.getProperty("openspcoop2.tracce.appender");
            if (tipiTracceAppender == null) {
                throw new Exception("Non sono stati definiti i tipi di appender supportati (tracce)");
            }
            tipiTracceAppender = tipiServizi.trim();
            String[] tipiTracceAppenderArray = tipiTracceAppender.split(",");
            for (int i = 0; i < tipiTracceAppenderArray.length; ++i) {
                tipiTracceAppenderArray[i] = tipiTracceAppenderArray[i].trim();
            }
            String tipiAutenticazionePortaDelegata = commonProperties.getProperty("openspcoop2.autenticazione.pd");
            if (tipiAutenticazionePortaDelegata == null) {
                throw new Exception("Non sono stati definiti i tipi di autenticazione per la porta delegata supportati");
            }
            tipiAutenticazionePortaDelegata = tipiAutenticazionePortaDelegata.trim();
            String[] tipiAutenticazionePortaDelegataArray = tipiAutenticazionePortaDelegata.split(",");
            for (int i = 0; i < tipiAutenticazionePortaDelegataArray.length; ++i) {
                tipiAutenticazionePortaDelegataArray[i] = tipiAutenticazionePortaDelegataArray[i].trim();
            }
            String tipiAutenticazionePortaApplicativa = commonProperties.getProperty("openspcoop2.autenticazione.pa");
            if (tipiAutenticazionePortaApplicativa == null) {
                throw new Exception("Non sono stati definiti i tipi di autenticazione per la porta applicativa supportati");
            }
            tipiAutenticazionePortaApplicativa = tipiAutenticazionePortaApplicativa.trim();
            String[] tipiAutenticazionePortaApplicativaArray = tipiAutenticazionePortaApplicativa.split(",");
            for (int i = 0; i < tipiAutenticazionePortaApplicativaArray.length; ++i) {
                tipiAutenticazionePortaApplicativaArray[i] = tipiAutenticazionePortaApplicativaArray[i].trim();
            }
            String tipiAutorizzazionePortaDelegata = commonProperties.getProperty("openspcoop2.autorizzazione.pd");
            if (tipiAutorizzazionePortaDelegata == null) {
                throw new Exception("Non sono stati definiti i tipi di autorizzazione per la porta delegata supportati");
            }
            tipiAutorizzazionePortaDelegata = tipiAutorizzazionePortaDelegata.trim();
            String[] tipiAutorizzazionePortaDelegataArray = tipiAutorizzazionePortaDelegata.split(",");
            for (int i = 0; i < tipiAutorizzazionePortaDelegataArray.length; ++i) {
                tipiAutorizzazionePortaDelegataArray[i] = tipiAutorizzazionePortaDelegataArray[i].trim();
            }
            String tipiAutorizzazionePortaApplicativa = commonProperties.getProperty("openspcoop2.autorizzazione.pa");
            if (tipiAutorizzazionePortaApplicativa == null) {
                throw new Exception("Non sono stati definiti i tipi di autorizzazione per la porta applicativa supportati");
            }
            tipiAutorizzazionePortaApplicativa = tipiAutorizzazionePortaApplicativa.trim();
            String[] tipiAutorizzazionePortaApplicativaArray = tipiAutorizzazionePortaApplicativa.split(",");
            for (int i = 0; i < tipiAutorizzazionePortaApplicativaArray.length; ++i) {
                tipiAutorizzazionePortaApplicativaArray[i] = tipiAutorizzazionePortaApplicativaArray[i].trim();
            }
            String tipiAutorizzazioneContenutiPortaDelegata = commonProperties.getProperty("openspcoop2.autorizzazioneContenuto.pd");
            if (tipiAutorizzazioneContenutiPortaDelegata == null) {
                throw new Exception("Non sono stati definiti i tipi di autorizzazione contenuti per la porta delegata supportati");
            }
            tipiAutorizzazioneContenutiPortaDelegata = tipiAutorizzazioneContenutiPortaDelegata.trim();
            String[] tipiAutorizzazioneContenutiPortaDelegataArray = tipiAutorizzazioneContenutiPortaDelegata.split(",");
            for (int i = 0; i < tipiAutorizzazioneContenutiPortaDelegataArray.length; ++i) {
                tipiAutorizzazioneContenutiPortaDelegataArray[i] = tipiAutorizzazioneContenutiPortaDelegataArray[i].trim();
            }
            String tipiAutorizzazioneContenutiPortaApplicativa = commonProperties.getProperty("openspcoop2.autorizzazioneContenuto.pa");
            if (tipiAutorizzazioneContenutiPortaApplicativa == null) {
                throw new Exception("Non sono stati definiti i tipi di autorizzazione contenuti per la porta applicativa supportati");
            }
            tipiAutorizzazioneContenutiPortaApplicativa = tipiAutorizzazioneContenutiPortaApplicativa.trim();
            String[] tipiAutorizzazioneContenutiPortaApplicativaArray = tipiAutorizzazioneContenutiPortaApplicativa.split(",");
            for (int i = 0; i < tipiAutorizzazioneContenutiPortaApplicativaArray.length; ++i) {
                tipiAutorizzazioneContenutiPortaApplicativaArray[i] = tipiAutorizzazioneContenutiPortaApplicativaArray[i].trim();
            }
            String tipiIntegrazionePD = commonProperties.getProperty("openspcoop2.integrazione.pd");
            if (tipiIntegrazionePD == null) {
                throw new Exception("Non sono stati definiti i tipi di Integrazione supportati (PD)");
            }
            tipiIntegrazionePD = tipiIntegrazionePD.trim();
            String[] tipiIntegrazionePDArray = tipiIntegrazionePD.split(",");
            for (int i = 0; i < tipiIntegrazionePDArray.length; ++i) {
                tipiIntegrazionePDArray[i] = tipiIntegrazionePDArray[i].trim();
            }
            String tipiIntegrazionePA = commonProperties.getProperty("openspcoop2.integrazione.pa");
            if (tipiIntegrazionePA == null) {
                throw new Exception("Non sono stati definiti i tipi di Integrazione supportati (PA)");
            }
            tipiIntegrazionePA = tipiIntegrazionePA.trim();
            String[] tipiIntegrazionePAArray = tipiIntegrazionePA.split(",");
            for (int i = 0; i < tipiIntegrazionePAArray.length; ++i) {
                tipiIntegrazionePAArray[i] = tipiIntegrazionePAArray[i].trim();
            }
            ValidazioneSemantica validatore = new ValidazioneSemantica(configurazione, tipoConnettoriArray, tipoSoggettiArray, tipoServiziArray, tipiDiagnosticiAppenderArray, tipiTracceAppenderArray, tipiAutenticazionePortaDelegataArray, tipiAutenticazionePortaApplicativaArray, tipiAutorizzazionePortaDelegataArray, tipiAutorizzazionePortaApplicativaArray, tipiAutorizzazioneContenutiPortaDelegataArray, tipiAutorizzazioneContenutiPortaApplicativaArray, tipiIntegrazionePDArray, tipiIntegrazionePAArray, validaSezioneConfigurazione, log);
            validatore.validazioneSemantica(true);
            return;
        }
        catch (Exception e) {
            log.error("Errore: " + e.getMessage());
            throw e;
        }
    }
}

