/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.driver.db;

import it.link.pdd.tools.migrazione_govway.generic_project.dao.jdbc.utils.JDBCObject;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.commons.CoreException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.commons.DBUtils;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.commons.ErrorsHandlerCostant;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.commons.IDriverWS;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.commons.IExtendedInfo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.commons.IMonitoraggioRisorsa;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.commons.ISearch;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.AccessoConfigurazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.AccessoDatiAutenticazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.AccessoDatiAutorizzazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.AccessoRegistro;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.AccessoRegistroRegistro;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.Attachments;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.AutorizzazioneRuoli;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.Cache;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.Configurazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.ConfigurazioneGestioneErrore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.Connettore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.CorrelazioneApplicativa;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.CorrelazioneApplicativaElemento;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.CorrelazioneApplicativaRisposta;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.CorrelazioneApplicativaRispostaElemento;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.Credenziali;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.GestioneErrore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.IndirizzoRisposta;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.InoltroBusteNonRiscontrate;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.IntegrationManager;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.InvocazioneCredenziali;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.InvocazionePorta;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.InvocazionePortaGestioneErrore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.InvocazioneServizio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.MessageSecurity;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.MessageSecurityFlow;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.MessageSecurityFlowParameter;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.MessaggiDiagnostici;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.MtomProcessor;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.MtomProcessorFlow;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.MtomProcessorFlowParameter;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.Openspcoop2;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.OpenspcoopAppender;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.OpenspcoopSorgenteDati;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.PortaApplicativa;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.PortaApplicativaAzione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.PortaApplicativaServizio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.PortaApplicativaSoggettoVirtuale;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.PortaDelegata;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.PortaDelegataAzione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.PortaDelegataServizio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.PortaDelegataSoggettoErogatore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.Property;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.ProprietaProtocollo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.RispostaAsincrona;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.Risposte;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.Route;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.RouteGateway;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.RouteRegistro;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.RoutingTable;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.RoutingTableDefault;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.RoutingTableDestinazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.Ruolo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.ServizioApplicativo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.ServizioApplicativoRuoli;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.Soggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.StatoServiziPdd;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.StatoServiziPddIntegrationManager;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.StatoServiziPddPortaApplicativa;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.StatoServiziPddPortaDelegata;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.SystemProperties;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.TipoFiltroAbilitazioneServizi;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.Tracciamento;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.ValidazioneBuste;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.ValidazioneContenutiApplicativi;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.constants.CostantiConfigurazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.constants.CredenzialeTipo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.constants.InvocazioneServizioTipoAutenticazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.constants.PortaDelegataAzioneIdentificazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.constants.PortaDelegataServizioIdentificazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.constants.PortaDelegataSoggettoErogatoreIdentificazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.constants.RegistroTipo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.constants.RicercaTipologiaErogazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.constants.RicercaTipologiaFruizione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.constants.RuoloTipoMatch;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.constants.StatoFunzionalita;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.constants.TipoAutenticazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.constants.TipologiaErogazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.constants.TipologiaFruizione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.driver.BeanUtilities;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.driver.ConnettorePropertiesUtilities;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.driver.DriverConfigurazioneException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.driver.DriverConfigurazioneNotFound;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.driver.ExtendedInfoManager;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.driver.FiltroRicercaPorteApplicative;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.driver.FiltroRicercaPorteDelegate;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.driver.FiltroRicercaServiziApplicativi;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.driver.FiltroRicercaSoggetti;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.driver.IDriverConfigurazioneCRUD;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.driver.IDriverConfigurazioneGet;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.driver.IDriverConfigurazioneSearch;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.driver.TipologiaServizioApplicativo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.driver.db.DriverConfigurazioneDB_LIB;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.constants.Costanti;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.constants.TipiConnettore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDPortaApplicativa;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDPortaApplicativaByNome;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDPortaDelegata;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDServizio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDServizioApplicativo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDSoggetto;
import it.link.pdd.tools.migrazione_govway.utils.LoggerWrapperFactory;
import it.link.pdd.tools.migrazione_govway.utils.Utilities;
import it.link.pdd.tools.migrazione_govway.utils.UtilsAlreadyExistsException;
import it.link.pdd.tools.migrazione_govway.utils.datasource.DataSourceFactory;
import it.link.pdd.tools.migrazione_govway.utils.resources.GestoreJNDI;
import it.link.pdd.tools.migrazione_govway.utils.sql.ISQLQueryObject;
import it.link.pdd.tools.migrazione_govway.utils.sql.SQLObjectFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.sql.DataSource;
import org.slf4j.Logger;

public class DriverConfigurazioneDB
extends BeanUtilities
implements IDriverConfigurazioneGet,
IDriverConfigurazioneCRUD,
IDriverConfigurazioneSearch,
IDriverWS,
IMonitoraggioRisorsa {
    public boolean create = false;
    public DataSource datasource = null;
    private Connection globalConnection = null;
    private boolean atomica = true;
    protected Logger log = null;
    private String tipoDB = null;
    String tabellaSoggetti = "soggetti";

    public String getTipoDB() {
        return this.tipoDB;
    }

    public DriverConfigurazioneDB() {
    }

    public DriverConfigurazioneDB(String nomeDataSource, Properties context, String tipoDB) {
        this(nomeDataSource, context, null, tipoDB);
    }

    public DriverConfigurazioneDB(String nomeDataSource, Properties context, Logger alog, String tipoDB) {
        this(nomeDataSource, context, alog, tipoDB, false);
    }

    public DriverConfigurazioneDB(String nomeDataSource, Properties context, Logger alog, String tipoDB, boolean tabellaSoggettiPDD) {
        this.initDriverConfigurazioneDB(nomeDataSource, context, alog, tipoDB, tabellaSoggettiPDD, false, false);
    }

    public DriverConfigurazioneDB(String nomeDataSource, Properties context, Logger alog, String tipoDB, boolean tabellaSoggettiPDD, boolean useOp2UtilsDatasource, boolean bindJMX) {
        this.initDriverConfigurazioneDB(nomeDataSource, context, alog, tipoDB, tabellaSoggettiPDD, useOp2UtilsDatasource, bindJMX);
    }

    /*
     * Unable to fully structure code
     */
    public void initDriverConfigurazioneDB(String nomeDataSource, Properties context, Logger alog, String tipoDB, boolean tabellaSoggettiPDD, boolean useOp2UtilsDatasource, boolean bindJMX) {
        try {
            if (alog == null) {
                this.log = LoggerWrapperFactory.getLogger("DRIVER_DB_CONFIGURAZIONE");
            } else {
                this.log = alog;
                DriverConfigurazioneDB_LIB.initStaticLogger(this.log);
            }
            if (useOp2UtilsDatasource) {
                dsParams = Costanti.getDataSourceParamsPdD(bindJMX, tipoDB);
                try {
                    this.datasource = DataSourceFactory.newInstance(nomeDataSource, context, dsParams);
                }
                catch (UtilsAlreadyExistsException exists) {
                    this.datasource = DataSourceFactory.getInstance(nomeDataSource);
                    if (this.datasource != null) ** GOTO lbl18
                    throw new Exception("Lookup datasource non riuscita (" + exists.getMessage() + ")", exists);
                }
            } else {
                gestoreJNDI = new GestoreJNDI(context);
                this.datasource = (DataSource)gestoreJNDI.lookup(nomeDataSource);
            }
lbl18:
            // 3 sources

            if (this.datasource != null) {
                this.create = true;
            }
        }
        catch (Exception ne) {
            this.create = false;
            this.log.error("Impossibile recuperare il context: " + ne.getMessage(), (Throwable)ne);
        }
        if (tipoDB == null) {
            this.log.error("Il tipoDatabase non puo essere null.");
            this.create = false;
        }
        this.atomica = true;
        this.tipoDB = tipoDB;
        this.tabellaSoggetti = tabellaSoggettiPDD != false ? "soggetti_pdd" : "soggetti";
        DriverConfigurazioneDB_LIB.setTipoDB(tipoDB);
        DriverConfigurazioneDB_LIB.setTabellaSoggetti(this.tabellaSoggetti);
    }

    public DriverConfigurazioneDB(Connection connection, String tipoDB) throws DriverConfigurazioneException {
        this(connection, null, tipoDB);
    }

    public DriverConfigurazioneDB(Connection connection, Logger alog, String tipoDB) throws DriverConfigurazioneException {
        this(connection, alog, tipoDB, false);
    }

    public DriverConfigurazioneDB(Connection connection, Logger alog, String tipoDB, boolean tabellaSoggettiPDD) throws DriverConfigurazioneException {
        if (alog == null) {
            this.log = LoggerWrapperFactory.getLogger("DRIVER_DB_CONFIGURAZIONE");
        } else {
            this.log = alog;
            DriverConfigurazioneDB_LIB.initStaticLogger(this.log);
        }
        if (connection == null) {
            this.create = false;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::DriverConfigurazioneDB(Connection con, Properties context) La connection non puo essere null.");
        }
        if (tipoDB == null) {
            this.create = false;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::DriverConfigurazioneDB(Connection ) Il tipoDatabase non puo essere null.");
        }
        this.globalConnection = connection;
        this.create = true;
        this.atomica = false;
        this.tipoDB = tipoDB;
        this.tabellaSoggetti = tabellaSoggettiPDD ? "soggetti_pdd" : "soggetti";
        DriverConfigurazioneDB_LIB.setTipoDB(tipoDB);
        DriverConfigurazioneDB_LIB.setTabellaSoggetti(this.tabellaSoggetti);
    }

    public Connection getConnection(String methodName) throws DriverConfigurazioneException {
        Connection con = null;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource(methodName);
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getConnection] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        return con;
    }

    public void releaseConnection(Connection con) {
        if (this.atomica) {
            try {
                con.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private Connection getConnectionFromDatasource(String methodName) throws Exception {
        if (this.datasource instanceof it.link.pdd.tools.migrazione_govway.utils.datasource.DataSource) {
            return ((it.link.pdd.tools.migrazione_govway.utils.datasource.DataSource)this.datasource).getWrappedConnection(null, "DriverConfigurazione." + methodName);
        }
        return this.datasource.getConnection();
    }

    public List<List<Object>> readCustom(ISQLQueryObject sqlQueryObject, List<Class<?>> returnTypes, List<JDBCObject> paramTypes) throws DriverConfigurazioneException {
        Connection con = null;
        try {
            this.log.debug("operazione atomica = " + this.atomica);
            con = this.atomica ? this.getConnectionFromDatasource("readCustom") : this.globalConnection;
            List<List<Object>> list = DBUtils.readCustom(this.log, con, this.tipoDB, sqlQueryObject, returnTypes, paramTypes);
            return list;
        }
        catch (Exception se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::readCustom]: " + se.getMessage(), se);
        }
        finally {
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public IDSoggetto getIdSoggetto(long idSoggetto) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.getIdSoggetto(idSoggetto, null);
    }

    public IDSoggetto getIdSoggetto(long idSoggetto, Connection conParam) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (idSoggetto <= 0L) {
            return null;
        }
        IDSoggetto idSoggettoObject = null;
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        if (conParam != null) {
            con = conParam;
        } else if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("getIdSoggetto(longId)");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("DriverConfigurazioneDB::getIdSoggetto] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione atomica = " + this.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable(this.tabellaSoggetti);
            sqlQueryObject.addSelectField("tipo_soggetto");
            sqlQueryObject.addSelectField("nome_soggetto");
            sqlQueryObject.addWhereCondition("id = ?");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idSoggetto);
            this.log.debug("eseguo query : " + DriverConfigurazioneDB_LIB.formatSQLString(sqlQuery, idSoggetto));
            rs = stm.executeQuery();
            if (!rs.next()) {
                throw new DriverConfigurazioneNotFound("Nessun risultato trovat eseguendo: " + DriverConfigurazioneDB_LIB.formatSQLString(sqlQuery, idSoggetto));
            }
            idSoggettoObject = new IDSoggetto();
            idSoggettoObject.setNome(rs.getString("nome_soggetto"));
            idSoggettoObject.setTipo(rs.getString("tipo_soggetto"));
            IDSoggetto iDSoggetto = idSoggettoObject;
            return iDSoggetto;
        }
        catch (SQLException se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getIdSoggetto] SqlException: " + se.getMessage(), se);
        }
        catch (DriverConfigurazioneNotFound se) {
            throw se;
        }
        catch (Exception se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getIdSoggetto] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (conParam == null && this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public Soggetto getSoggetto(IDSoggetto aSoggetto) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (aSoggetto == null || aSoggetto.getNome() == null || aSoggetto.getTipo() == null) {
            throw new DriverConfigurazioneException("[getSoggetto] Parametri Non Validi");
        }
        Soggetto Soggetto2 = null;
        Connection con = null;
        String nomeSogg = aSoggetto.getNome();
        String tipoSogg = aSoggetto.getTipo();
        long idSoggetto = -1L;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("getSoggetto(idSoggetto)");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getSoggetto] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            idSoggetto = DBUtils.getIdSoggetto(nomeSogg, tipoSogg, con, this.tipoDB, this.tabellaSoggetti);
            if (idSoggetto == -1L) {
                throw new DriverConfigurazioneNotFound("Soggetto [" + aSoggetto.toString() + "] non esistente");
            }
        }
        catch (DriverConfigurazioneNotFound se) {
            throw se;
        }
        catch (CoreException se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getSoggetto] DriverException: " + se.getMessage(), se);
        }
        catch (Exception se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getSoggetto] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
        Soggetto2 = this.getSoggetto(idSoggetto);
        if (Soggetto2 == null) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getSoggetto] Soggetto non Esistente.");
        }
        return Soggetto2;
    }

    @Override
    public void createSoggetto(Soggetto soggetto) throws DriverConfigurazioneException {
        if (soggetto == null) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::createSoggetto] Parametro non valido.");
        }
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("createSoggetto");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::createSoggetto] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            this.log.debug("CRUDSoggetto type = 1");
            DriverConfigurazioneDB_LIB.CRUDSoggetto(1, soggetto, con);
        }
        catch (DriverConfigurazioneException qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::createSoggetto] Errore durante la creazione del soggetto : " + qe.getMessage(), qe);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::createSoggetto] Errore durante la creazione del soggetto : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void updateSoggetto(Soggetto soggetto) throws DriverConfigurazioneException {
        if (soggetto == null) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::updateSoggetto] Parametro non valido.");
        }
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("updateSoggetto");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::updateSoggetto] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            this.log.debug("CRUDSoggetto type = 2");
            DriverConfigurazioneDB_LIB.CRUDSoggetto(2, soggetto, con);
        }
        catch (DriverConfigurazioneException qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::updateSoggetto] Errore durante la creazione del soggetto : " + qe.getMessage(), qe);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::updateSoggetto] Errore durante la creazione del soggetto : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void deleteSoggetto(Soggetto soggetto) throws DriverConfigurazioneException {
        if (soggetto == null) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::deleteSoggetto] Parametro non valido.");
        }
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("deleteSoggetto");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::deleteSoggetto] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            this.log.debug("CRUDSoggetto type = 3");
            DriverConfigurazioneDB_LIB.CRUDSoggetto(3, soggetto, con);
        }
        catch (DriverConfigurazioneException qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::deleteSoggetto] Errore durante la creazione del soggetto : " + qe.getMessage(), qe);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::deleteSoggetto] Errore durante la creazione del soggetto : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public IDSoggetto getSoggetto(String location) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (location == null) {
            throw new DriverConfigurazioneException("[getSoggetto] Parametro Non Valido");
        }
        Soggetto Soggetto2 = null;
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        String sqlQuery = "";
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("getSoggetto(location)");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getSoggetto] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            IDSoggetto idSoggetto;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("porte_delegate");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("location = ?");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setString(1, location);
            this.log.debug("eseguo query : " + DBUtils.formatSQLString(sqlQuery, location));
            rs = stm.executeQuery();
            if (rs.next()) {
                Soggetto2 = new Soggetto();
                long idSoggProprietario = rs.getLong("id_soggetto");
                Soggetto2 = this.getSoggetto(idSoggProprietario, con);
            } else {
                rs.close();
                stm.close();
                boolean trovato = false;
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("porte_delegate");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("nome_porta = ?");
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm = con.prepareStatement(sqlQuery);
                stm.setString(1, location);
                rs = stm.executeQuery();
                while (rs.next() && !trovato) {
                    if (rs.getString("location") != null && !"".equals(rs.getString("location"))) continue;
                    trovato = true;
                    long idSoggProprietario = rs.getLong("id_soggetto");
                    if (idSoggProprietario <= 0L) continue;
                    Soggetto2 = this.getSoggetto(idSoggProprietario, con);
                    trovato = true;
                }
            }
            if (Soggetto2 == null) {
                throw new DriverConfigurazioneNotFound("[DriverConfigurazioneDB::getSoggetto] Soggetto associato alla porta delegata [" + location + "] non esistente.");
            }
            IDSoggetto iDSoggetto = idSoggetto = new IDSoggetto(Soggetto2.getTipo(), Soggetto2.getNome(), Soggetto2.getIdentificativoPorta());
            return iDSoggetto;
        }
        catch (SQLException se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getSoggetto] SqlException: " + se.getMessage(), se);
        }
        catch (DriverConfigurazioneException se) {
            throw se;
        }
        catch (DriverConfigurazioneNotFound se) {
            throw se;
        }
        catch (Exception se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getSoggetto] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void createConnettore(Connettore connettore) throws DriverConfigurazioneException {
        if (connettore == null) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::createConnettore] Parametro non valido.");
        }
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("createConnettore");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::createConnettore] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            this.log.debug("CRUDConnettore type = 1");
            DriverConfigurazioneDB_LIB.CRUDConnettore(1, connettore, con);
        }
        catch (DriverConfigurazioneException qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::createConnettore] Errore durante la creazione del connettore : " + qe.getMessage(), qe);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::createConnettore] Errore durante la creazione del connettore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void updateConnettore(Connettore connettore) throws DriverConfigurazioneException {
        if (connettore == null) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::updateConnettore] Parametro non valido.");
        }
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("updateConnettore");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::updateConnettore] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            this.log.debug("CRUDConnettore type = 2");
            DriverConfigurazioneDB_LIB.CRUDConnettore(2, connettore, con);
        }
        catch (DriverConfigurazioneException qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::updateConnettore] Errore durante l'aggiornamento del connettore : " + qe.getMessage(), qe);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::updateConnettore] Errore durante l'aggiornamento del connettore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void deleteConnettore(Connettore connettore) throws DriverConfigurazioneException {
        if (connettore == null) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::deleteConnettore] Parametro non valido.");
        }
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("deleteConnettore");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::deleteConnettore] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            this.log.debug("CRUDConnettore type = 3");
            DriverConfigurazioneDB_LIB.CRUDConnettore(3, connettore, con);
        }
        catch (DriverConfigurazioneException qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::deleteConnettore] Errore durante la rimozione del connettore : " + qe.getMessage(), qe);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::deleteConnettore] Errore durante la rimozione del connettore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public Soggetto getRouter() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        long idRouter;
        Soggetto Soggetto2;
        block23: {
            Soggetto2 = null;
            Connection con = null;
            Statement stm = null;
            ResultSet rs = null;
            String sqlQuery = "";
            if (this.atomica) {
                try {
                    con = this.getConnectionFromDatasource("getRouter");
                }
                catch (Exception e) {
                    throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getRouter] Exception accedendo al datasource :" + e.getMessage(), e);
                }
            } else {
                con = this.globalConnection;
            }
            this.log.debug("operazione this.atomica = " + this.atomica);
            idRouter = -1L;
            try {
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable(this.tabellaSoggetti);
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("is_router = ?");
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm = con.prepareStatement(sqlQuery);
                stm.setInt(1, 1);
                this.log.debug("eseguo query : " + DBUtils.formatSQLString(sqlQuery, CostantiConfigurazione.ABILITATO));
                rs = stm.executeQuery();
                if (rs.next()) {
                    idRouter = rs.getLong("id");
                    break block23;
                }
                throw new DriverConfigurazioneNotFound("[DriverConfigurazioneDB::getRouter] Non esiste un Soggetto Router.");
            }
            catch (SQLException se) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getRouter] SqlException: " + se.getMessage(), se);
            }
            catch (DriverConfigurazioneNotFound se) {
                throw se;
            }
            catch (Exception se) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getRouter] Exception: " + se.getMessage(), se);
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (this.atomica) {
                        this.log.debug("rilascio connessioni al db...");
                        con.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        Soggetto2 = this.getSoggetto(idRouter);
        Soggetto2.setRouter(true);
        return Soggetto2;
    }

    public List<IDSoggetto> getSoggettiWithSuperuser(String user) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        ArrayList<IDSoggetto> idSoggetti = null;
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        String sqlQuery = "";
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("getSoggettiWithSuperuser");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getSoggettiWithSuperuser] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            Vector<IDSoggetto> idTrovati = new Vector<IDSoggetto>();
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable(this.tabellaSoggetti);
            sqlQueryObject.addSelectField("tipo_soggetto");
            sqlQueryObject.addSelectField("nome_soggetto");
            sqlQueryObject.addWhereCondition("superuser = ?");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setString(1, user);
            this.log.debug("eseguo query : " + DBUtils.formatSQLString(sqlQuery, CostantiConfigurazione.ABILITATO));
            rs = stm.executeQuery();
            while (rs.next()) {
                IDSoggetto id = new IDSoggetto();
                id.setTipo(rs.getString("tipo_soggetto"));
                id.setNome(rs.getString("nome_soggetto"));
                idTrovati.add(id);
            }
            if (idTrovati.size() > 0) {
                idSoggetti = new ArrayList<IDSoggetto>();
                idSoggetti.addAll(idTrovati);
            }
        }
        catch (SQLException se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getSoggettiWithSuperuser] SqlException: " + se.getMessage(), se);
        }
        catch (Exception se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getSoggettiWithSuperuser] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
        return idSoggetti;
    }

    @Override
    public HashSet<String> getSoggettiVirtuali() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        HashSet<String> soggettiVirtuali = new HashSet<String>();
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        String sqlQuery = "";
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("getSoggettiVirtuali");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("porte_applicative");
            sqlQueryObject.setSelectDistinct(true);
            sqlQueryObject.addSelectField("tipo_soggetto_virtuale");
            sqlQueryObject.addSelectField("nome_soggetto_virtuale");
            sqlQueryObject.addWhereCondition("tipo_soggetto_virtuale IS NOT NULL");
            sqlQueryObject.addWhereCondition("nome_soggetto_virtuale IS NOT NULL");
            sqlQueryObject.addWhereCondition("tipo_soggetto_virtuale<>'\"\"'");
            sqlQueryObject.addWhereCondition("nome_soggetto_virtuale<>'\"\"'");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQuery = sqlQueryObject.createSQLQuery();
            this.log.debug("eseguo query : " + DBUtils.formatSQLString(sqlQuery, new Object[0]));
            stm = con.prepareStatement(sqlQuery);
            rs = stm.executeQuery();
            while (rs.next()) {
                String soggettoVirtuale = rs.getString("tipo_soggetto_virtuale") + rs.getString("nome_soggetto_virtuale");
                this.log.info("aggiunto Soggetto " + soggettoVirtuale + " alla lista dei Soggetti Virtuali");
                soggettiVirtuali.add(soggettoVirtuale);
            }
            rs.close();
            stm.close();
            if (soggettiVirtuali.size() == 0) {
                throw new DriverConfigurazioneNotFound("[getSoggettiVirtuali] Soggetti virtuali non esistenti");
            }
            this.log.info("aggiunti " + soggettiVirtuali.size() + " soggetti alla lista dei Soggetti Virtuali");
            HashSet<String> hashSet = soggettiVirtuali;
            return hashSet;
        }
        catch (SQLException se) {
            throw new DriverConfigurazioneException("SqlException: " + se.getMessage(), se);
        }
        catch (DriverConfigurazioneNotFound se) {
            throw se;
        }
        catch (Exception se) {
            throw new DriverConfigurazioneException("Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public PortaDelegata getPortaDelegata(IDPortaDelegata idPD) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (idPD == null) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getPortaDelegata] Parametro idPD Non Valido");
        }
        IDSoggetto aSoggetto = idPD.getSoggettoFruitore();
        String location = idPD.getLocationPD();
        if (location == null || aSoggetto == null) {
            Object a1 = "";
            Object a2 = "";
            a1 = location == null ? " [Location is null]" : " [" + location + "]";
            a2 = aSoggetto == null ? " [soggetto is null]" : " [soggetto tipo(" + aSoggetto.getTipo() + ") nome(" + aSoggetto.getNome() + ")]";
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getPortaDelegata] Parametri non Validi" + (String)a1 + (String)a2);
        }
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        PortaDelegata pd = null;
        long idPortaDelegata = 0L;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("getPortaDelegata(idPortaDelegata)");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getPortaDelegata] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        boolean trovato = false;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable(this.tabellaSoggetti);
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("nome_soggetto=?");
            sqlQueryObject.addWhereCondition("tipo_soggetto=?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            String nomeSoggFruit = aSoggetto.getNome();
            String tipoSoggFruit = aSoggetto.getTipo();
            long idSoggettoFruitore = 0L;
            if (nomeSoggFruit == null || nomeSoggFruit.trim().equals("") || tipoSoggFruit == null || tipoSoggFruit.trim().equals("")) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getPortaDelegata] nome o tipo Soggetto fruitore non settati correttamente");
            }
            stm = con.prepareStatement(sqlQuery, 1004, 1007);
            stm.setString(1, nomeSoggFruit);
            stm.setString(2, tipoSoggFruit);
            this.log.debug("eseguo query : " + DBUtils.formatSQLString(sqlQuery, nomeSoggFruit, tipoSoggFruit));
            rs = stm.executeQuery();
            if (!rs.next()) {
                throw new DriverConfigurazioneNotFound("[DriverConfigurazioneDB::getPortaDelegata] Non ho trovato nessuno soggetto fruitore [" + nomeSoggFruit + "," + tipoSoggFruit + "] non esistente");
            }
            idSoggettoFruitore = rs.getLong("id");
            rs.close();
            stm.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("porte_delegate");
            sqlQueryObject.addFromTable(this.tabellaSoggetti);
            sqlQueryObject.addSelectAliasField("porte_delegate.id", "idPD");
            sqlQueryObject.addWhereCondition("porte_delegate.id_soggetto = " + this.tabellaSoggetti + ".id");
            sqlQueryObject.addWhereCondition("porte_delegate.id_soggetto = ?");
            sqlQueryObject.addWhereCondition("porte_delegate.location = ?");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery, 1004, 1007);
            stm.setLong(1, idSoggettoFruitore);
            stm.setString(2, location);
            rs = stm.executeQuery();
            if (rs.next()) {
                idPortaDelegata = rs.getLong("idPD");
                trovato = true;
                rs.close();
                stm.close();
            } else {
                rs.close();
                stm.close();
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("porte_delegate");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("nome_porta=?");
                sqlQueryObject.addWhereCondition("id_soggetto = ?");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm = con.prepareStatement(sqlQuery, 1004, 1007);
                stm.setString(1, location);
                stm.setLong(2, idSoggettoFruitore);
                rs = stm.executeQuery();
                while (rs.next() && !trovato) {
                    idPortaDelegata = rs.getLong("id");
                    trovato = true;
                }
                rs.close();
                stm.close();
            }
        }
        catch (SQLException se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getPortaDelegata] SqlException: " + se.getMessage(), se);
        }
        catch (DriverConfigurazioneNotFound de) {
            throw de;
        }
        catch (Exception se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getPortaDelegata] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
        if (!trovato) {
            throw new DriverConfigurazioneNotFound("Nessuna PortaDelegata trovata.");
        }
        pd = this.getPortaDelegata(idPortaDelegata);
        return pd;
    }

    @Override
    public void createPortaDelegata(PortaDelegata aPD) throws DriverConfigurazioneException {
        if (aPD == null) {
            throw new DriverConfigurazioneException("Porta Delegata non valida");
        }
        if (aPD.getNome() == null || aPD.getNome().equals("")) {
            throw new DriverConfigurazioneException("Nome Porta Delegata non valido");
        }
        if (aPD.getNomeSoggettoProprietario() == null || aPD.getNomeSoggettoProprietario().equals("")) {
            throw new DriverConfigurazioneException("Nome Soggetto Proprietario Porta Delegata non valido");
        }
        if (aPD.getTipoSoggettoProprietario() == null || aPD.getTipoSoggettoProprietario().equals("")) {
            throw new DriverConfigurazioneException("Tipo Soggetto Proprietario Porta Delegata non valido");
        }
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("createPortaDelegata");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::createPortaDelegata] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            this.log.debug("CRUDPortaDelegata type = 1");
            DriverConfigurazioneDB_LIB.CRUDPortaDelegata(1, aPD, con);
            this.log.debug("Creazione PortaDelegata [" + aPD.getId() + "] completato.");
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::createPortaDelegata] Errore durante la creazione della PortaDelegata : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void updatePortaDelegata(PortaDelegata aPD) throws DriverConfigurazioneException {
        if (aPD == null) {
            throw new DriverConfigurazioneException("Porta Delegata non valida");
        }
        if (aPD.getNome() == null || aPD.getNome().equals("")) {
            throw new DriverConfigurazioneException("Nome Porta Delegata non valido");
        }
        if (aPD.getNomeSoggettoProprietario() == null || aPD.getNomeSoggettoProprietario().equals("")) {
            throw new DriverConfigurazioneException("Nome Soggetto Proprietario Porta Delegata non valido");
        }
        if (aPD.getTipoSoggettoProprietario() == null || aPD.getTipoSoggettoProprietario().equals("")) {
            throw new DriverConfigurazioneException("Tipo Soggetto Proprietario Porta Delegata non valido");
        }
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("updatePortaDelegata");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::updatePortaDelegata] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            this.log.debug("CRUDPortaDelegata type = 2");
            DriverConfigurazioneDB_LIB.CRUDPortaDelegata(2, aPD, con);
            this.log.debug("Aggiornamento PortaDelegata [" + aPD.getId() + "] completato.");
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::updatePortaDelegata] Errore durante l'aggiornamento della PortaDelegata : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void deletePortaDelegata(PortaDelegata aPD) throws DriverConfigurazioneException {
        if (aPD == null) {
            throw new DriverConfigurazioneException("Porta Delegata non valida");
        }
        if (aPD.getNome() == null || aPD.getNome().equals("")) {
            throw new DriverConfigurazioneException("Nome Porta Delegata non valido");
        }
        if (aPD.getNomeSoggettoProprietario() == null || aPD.getNomeSoggettoProprietario().equals("")) {
            throw new DriverConfigurazioneException("Nome Soggetto Proprietario Porta Delegata non valido");
        }
        if (aPD.getTipoSoggettoProprietario() == null || aPD.getTipoSoggettoProprietario().equals("")) {
            throw new DriverConfigurazioneException("Tipo Soggetto Proprietario Porta Delegata non valido");
        }
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("deletePortaDelegata");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::deletePortaDelegata] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            this.log.debug("CRUDPortaDelegata type = 3");
            long id = DriverConfigurazioneDB_LIB.CRUDPortaDelegata(3, aPD, con);
            this.log.debug("Cancellazione PortaDelegata [" + id + "] completato.");
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::deletePortaDelegata] Errore durante la cancellazione della PortaDelegata : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<String> portaDelegataRuoliList(long idPD, ISearch ricerca) throws DriverConfigurazioneException {
        String nomeMetodo = "portaDelegataRuoliList";
        int idLista = 25;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        boolean error = false;
        Statement stmt = null;
        ResultSet risultato = null;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource(nomeMetodo);
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        ArrayList<String> listIdRuoli = null;
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("porte_delegate");
                sqlQueryObject.addFromTable("pd_ruoli");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("porte_delegate.id=?");
                sqlQueryObject.addWhereCondition("porte_delegate.id=pd_ruoli.id_porta");
                sqlQueryObject.addWhereLikeCondition("pd_ruoli.ruolo", search, true, true);
                sqlQueryObject.setSelectDistinct(true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("porte_delegate");
                sqlQueryObject.addFromTable("pd_ruoli");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("porte_delegate.id=?");
                sqlQueryObject.addWhereCondition("porte_delegate.id=pd_ruoli.id_porta");
                sqlQueryObject.setSelectDistinct(true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPD);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("porte_delegate");
                sqlQueryObject.addFromTable("pd_ruoli");
                sqlQueryObject.addSelectField("pd_ruoli.ruolo");
                sqlQueryObject.addWhereCondition("porte_delegate.id=?");
                sqlQueryObject.addWhereCondition("porte_delegate.id=pd_ruoli.id_porta");
                sqlQueryObject.addWhereLikeCondition("pd_ruoli.ruolo", search, true, true);
                sqlQueryObject.setSelectDistinct(true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("pd_ruoli.ruolo");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("porte_delegate");
                sqlQueryObject.addFromTable("pd_ruoli");
                sqlQueryObject.addSelectField("pd_ruoli.ruolo");
                sqlQueryObject.addWhereCondition("porte_delegate.id=?");
                sqlQueryObject.addWhereCondition("porte_delegate.id=pd_ruoli.id_porta");
                sqlQueryObject.setSelectDistinct(true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("pd_ruoli.ruolo");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPD);
            risultato = stmt.executeQuery();
            listIdRuoli = new ArrayList<String>();
            while (risultato.next()) {
                listIdRuoli.add(risultato.getString(1));
            }
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
        return listIdRuoli;
    }

    @Override
    public PortaApplicativa getPortaApplicativa(IDPortaApplicativa idPA) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.getPortaApplicativa(idPA, false, null);
    }

    @Override
    public PortaApplicativa getPortaApplicativa(IDPortaApplicativa idPA, boolean ricercaPuntuale) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.getPortaApplicativa(idPA, ricercaPuntuale, null);
    }

    @Override
    public PortaApplicativa getPortaApplicativaVirtuale(IDPortaApplicativa idPA, IDSoggetto soggettoVirtuale) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.getPortaApplicativa(idPA, false, soggettoVirtuale);
    }

    @Override
    public PortaApplicativa getPortaApplicativaVirtuale(IDPortaApplicativa idPA, IDSoggetto soggettoVirtuale, boolean ricercaPuntuale) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.getPortaApplicativa(idPA, ricercaPuntuale, soggettoVirtuale);
    }

    private PortaApplicativa getPortaApplicativa(IDPortaApplicativa idPA, boolean ricercaPuntuale, IDSoggetto soggettoVirtuale) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (idPA == null || idPA.getIDServizio() == null) {
            throw new DriverConfigurazioneException("[getPortaApplicativa] Parametro idPA Non Validi");
        }
        IDSoggetto soggettoErogatore = idPA.getIDServizio().getSoggettoErogatore();
        IDServizio service = idPA.getIDServizio();
        if (soggettoErogatore == null || service == null) {
            throw new DriverConfigurazioneException("[getPortaApplicativa] Parametri Non Validi");
        }
        String servizio = service.getServizio();
        String tipoServizio = service.getTipoServizio();
        String azione = service.getAzione();
        if (servizio == null || tipoServizio == null) {
            throw new DriverConfigurazioneException("[getPortaApplicativa] Parametri (Servizio) Non Validi");
        }
        if (soggettoVirtuale != null && (soggettoVirtuale.getTipo() == null || soggettoVirtuale.getNome() == null)) {
            throw new DriverConfigurazioneException("[getPortaApplicativa] Parametri (Soggetto Virtuale) non validi");
        }
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        String sqlQuery = null;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("getPortaApplicativa(idPortaApplicativa)");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getPortaApplicativa] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        long idPortaApplicativa = -1L;
        boolean trovato = false;
        try {
            long idSoggErog = 0L;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable(this.tabellaSoggetti);
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("nome_soggetto=?");
            sqlQueryObject.addWhereCondition("tipo_soggetto=?");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery, 1004, 1007);
            stm.setString(1, soggettoErogatore.getNome());
            stm.setString(2, soggettoErogatore.getTipo());
            rs = stm.executeQuery();
            this.log.debug("eseguo query soggetto" + DBUtils.formatSQLString(sqlQuery, soggettoErogatore.getNome(), soggettoErogatore.getTipo()));
            if (!rs.next()) {
                throw new DriverConfigurazioneNotFound("[DriverConfigurazioneDB::getPortaApplicativa] Nessuno soggetto trovato [" + soggettoErogatore.getNome() + "," + soggettoErogatore.getTipo() + "].");
            }
            idSoggErog = rs.getLong("id");
            rs.close();
            stm.close();
            long idSoggVirtuale = 0L;
            if (soggettoVirtuale != null) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable(this.tabellaSoggetti);
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("nome_soggetto=?");
                sqlQueryObject.addWhereCondition("tipo_soggetto=?");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm = con.prepareStatement(sqlQuery, 1004, 1007);
                stm.setString(1, soggettoVirtuale.getNome());
                stm.setString(2, soggettoVirtuale.getTipo());
                rs = stm.executeQuery();
                this.log.debug("eseguo query soggetto virtuale" + DBUtils.formatSQLString(sqlQuery, soggettoVirtuale.getNome(), soggettoVirtuale.getTipo()));
                if (rs.next()) {
                    idSoggVirtuale = rs.getLong("id");
                }
                rs.close();
                stm.close();
            }
            this.log.debug("eseguo soggetto:" + idSoggErog);
            if (azione == null || azione.trim().equals("")) {
                this.log.debug("ricerca PA con azione == null, soggettoVirtuale=" + soggettoVirtuale);
                if (soggettoVirtuale == null) {
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                    sqlQueryObject.addFromTable("porte_applicative");
                    sqlQueryObject.addSelectField("*");
                    sqlQueryObject.addWhereCondition("id_soggetto = ?");
                    sqlQueryObject.addWhereCondition("tipo_servizio = ?");
                    sqlQueryObject.addWhereCondition("servizio = ?");
                    sqlQueryObject.addWhereCondition(false, "azione IS NULL", "azione = ?", "azione = ?");
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQuery = sqlQueryObject.createSQLQuery();
                } else {
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                    sqlQueryObject.addFromTable("porte_applicative");
                    sqlQueryObject.addSelectField("*");
                    sqlQueryObject.addWhereCondition("id_soggetto = ?");
                    sqlQueryObject.addWhereCondition(false, "id_soggetto_virtuale = ?", "tipo_soggetto_virtuale = ? AND nome_soggetto_virtuale = ?");
                    sqlQueryObject.addWhereCondition("tipo_servizio = ?");
                    sqlQueryObject.addWhereCondition("servizio = ?");
                    sqlQueryObject.addWhereCondition(false, "azione IS NULL", "azione = ?", "azione = ?");
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQuery = sqlQueryObject.createSQLQuery();
                }
                stm = con.prepareStatement(sqlQuery, 1004, 1007);
                if (soggettoVirtuale == null) {
                    stm.setLong(1, idSoggErog);
                    stm.setString(2, tipoServizio);
                    stm.setString(3, servizio);
                    stm.setString(4, "");
                    stm.setString(5, "-");
                    this.log.debug("eseguo query " + DBUtils.formatSQLString(sqlQuery, idSoggErog, tipoServizio, servizio, "", "-"));
                } else {
                    stm.setLong(1, idSoggErog);
                    stm.setLong(2, idSoggVirtuale);
                    stm.setString(3, soggettoVirtuale.getTipo());
                    stm.setString(4, soggettoVirtuale.getNome());
                    stm.setString(5, tipoServizio);
                    stm.setString(6, servizio);
                    stm.setString(7, "");
                    stm.setString(8, "-");
                    this.log.debug("eseguo query " + DBUtils.formatSQLString(sqlQuery, idSoggErog, soggettoErogatore.getTipo(), soggettoErogatore.getNome(), tipoServizio, servizio, "", "-"));
                }
            } else {
                this.log.debug("ricerca PA con azione != null, soggettoVirtuale=" + soggettoVirtuale);
                if (soggettoVirtuale == null) {
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                    sqlQueryObject.addFromTable("porte_applicative");
                    sqlQueryObject.addSelectField("*");
                    sqlQueryObject.addWhereCondition("id_soggetto=?");
                    sqlQueryObject.addWhereCondition("tipo_servizio=?");
                    sqlQueryObject.addWhereCondition("servizio=?");
                    sqlQueryObject.addWhereCondition("azione=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQuery = sqlQueryObject.createSQLQuery();
                } else {
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                    sqlQueryObject.addFromTable("porte_applicative");
                    sqlQueryObject.addSelectField("*");
                    sqlQueryObject.addWhereCondition("id_soggetto = ?");
                    sqlQueryObject.addWhereCondition(false, "id_soggetto_virtuale = ?", "tipo_soggetto_virtuale = ? AND nome_soggetto_virtuale = ?");
                    sqlQueryObject.addWhereCondition("tipo_servizio = ?");
                    sqlQueryObject.addWhereCondition("servizio = ?");
                    sqlQueryObject.addWhereCondition("azione = ?");
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQuery = sqlQueryObject.createSQLQuery();
                }
                stm = con.prepareStatement(sqlQuery, 1004, 1007);
                if (soggettoVirtuale == null) {
                    stm.setLong(1, idSoggErog);
                    stm.setString(2, tipoServizio);
                    stm.setString(3, servizio);
                    stm.setString(4, azione);
                    this.log.debug("eseguo query " + DBUtils.formatSQLString(sqlQuery, idSoggErog, tipoServizio, servizio, azione));
                } else {
                    stm.setLong(1, idSoggErog);
                    stm.setLong(2, idSoggVirtuale);
                    stm.setString(3, soggettoVirtuale.getTipo());
                    stm.setString(4, soggettoVirtuale.getNome());
                    stm.setString(5, tipoServizio);
                    stm.setString(6, servizio);
                    stm.setString(7, azione);
                    this.log.debug("eseguo query " + DBUtils.formatSQLString(sqlQuery, idSoggErog, tipoServizio, servizio, azione));
                }
            }
            rs = stm.executeQuery();
            trovato = rs.next();
            this.log.debug("ricerca puntuale=" + ricercaPuntuale);
            if (!ricercaPuntuale && !trovato && azione != null) {
                this.log.debug("ricerca PA con azione != null ma con solo il servizio, soggettoVirtuale=" + soggettoVirtuale);
                rs.close();
                stm.close();
                if (soggettoVirtuale == null) {
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                    sqlQueryObject.addFromTable("porte_applicative");
                    sqlQueryObject.addSelectField("*");
                    sqlQueryObject.addWhereCondition("id_soggetto = ?");
                    sqlQueryObject.addWhereCondition("tipo_servizio = ?");
                    sqlQueryObject.addWhereCondition("servizio = ?");
                    sqlQueryObject.addWhereCondition(false, "azione IS NULL", "azione = ?", "azione = ?");
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQuery = sqlQueryObject.createSQLQuery();
                } else {
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                    sqlQueryObject.addFromTable("porte_applicative");
                    sqlQueryObject.addSelectField("*");
                    sqlQueryObject.addWhereCondition("id_soggetto = ?");
                    sqlQueryObject.addWhereCondition(false, "id_soggetto_virtuale = ?", "tipo_soggetto_virtuale = ? AND nome_soggetto_virtuale = ?");
                    sqlQueryObject.addWhereCondition("tipo_servizio = ?");
                    sqlQueryObject.addWhereCondition("servizio = ?");
                    sqlQueryObject.addWhereCondition(false, "azione IS NULL", "azione = ?", "azione = ?");
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQuery = sqlQueryObject.createSQLQuery();
                }
                stm = con.prepareStatement(sqlQuery, 1004, 1007);
                if (soggettoVirtuale == null) {
                    stm.setLong(1, idSoggErog);
                    stm.setString(2, tipoServizio);
                    stm.setString(3, servizio);
                    stm.setString(4, "");
                    stm.setString(5, "-");
                } else {
                    stm.setLong(1, idSoggErog);
                    stm.setLong(2, idSoggVirtuale);
                    stm.setString(3, soggettoVirtuale.getTipo());
                    stm.setString(4, soggettoVirtuale.getNome());
                    stm.setString(5, tipoServizio);
                    stm.setString(6, servizio);
                    stm.setString(7, "");
                    stm.setString(8, "-");
                }
                this.log.debug("eseguo query " + DBUtils.formatSQLString(sqlQuery, idSoggErog, tipoServizio, servizio));
                rs = stm.executeQuery();
                trovato = rs.next();
            }
            if (trovato) {
                rs.first();
                idPortaApplicativa = rs.getLong("id");
            }
        }
        catch (SQLException se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getPortaApplicativa] SqlException: " + se.getMessage(), se);
        }
        catch (DriverConfigurazioneNotFound e) {
            throw new DriverConfigurazioneNotFound(e);
        }
        catch (Exception se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getPortaApplicativa] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
        PortaApplicativa pa = null;
        if (!trovato) {
            throw new DriverConfigurazioneNotFound("Porta Applicativa non esistente");
        }
        pa = this.getPortaApplicativa(idPortaApplicativa);
        return pa;
    }

    @Override
    public void createPortaApplicativa(PortaApplicativa aPA) throws DriverConfigurazioneException {
        if (aPA == null) {
            throw new DriverConfigurazioneException("Porta Applicativa non valida");
        }
        if (aPA.getNome() == null || aPA.getNome().equals("")) {
            throw new DriverConfigurazioneException("Nome Porta Applicativa non valido");
        }
        if (aPA.getNomeSoggettoProprietario() == null || aPA.getNomeSoggettoProprietario().equals("")) {
            throw new DriverConfigurazioneException("Nome Soggetto Proprietario Porta Applicativa non valido");
        }
        if (aPA.getTipoSoggettoProprietario() == null || aPA.getTipoSoggettoProprietario().equals("")) {
            throw new DriverConfigurazioneException("Tipo Soggetto Proprietario Porta Applicativa non valido");
        }
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("createPortaApplicativa");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::createPortaApplicativa] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            this.log.debug("CRUDPortaApplicativa type = 1");
            DriverConfigurazioneDB_LIB.CRUDPortaApplicativa(1, aPA, con);
            this.log.debug("Creazione PortaApplicativa [" + aPA.getId() + "] completato.");
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::createPortaApplicativa] Errore durante la creazione della PortaApplicativa : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void updatePortaApplicativa(PortaApplicativa aPA) throws DriverConfigurazioneException {
        if (aPA == null) {
            throw new DriverConfigurazioneException("Porta Applicativa non valida");
        }
        if (aPA.getNome() == null || aPA.getNome().equals("")) {
            throw new DriverConfigurazioneException("Nome Porta Applicativa non valido");
        }
        if (aPA.getNomeSoggettoProprietario() == null || aPA.getNomeSoggettoProprietario().equals("")) {
            throw new DriverConfigurazioneException("Nome Soggetto Proprietario Porta Applicativa non valido");
        }
        if (aPA.getTipoSoggettoProprietario() == null || aPA.getTipoSoggettoProprietario().equals("")) {
            throw new DriverConfigurazioneException("Tipo Soggetto Proprietario Porta Applicativa non valido");
        }
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("updatePortaApplicativa");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::updatePortaApplicativa] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            this.log.debug("CRUDPortaApplicativa type = 2");
            long id = DriverConfigurazioneDB_LIB.CRUDPortaApplicativa(2, aPA, con);
            this.log.debug("Aggiornamento PortaApplicativa [" + id + "] completato.");
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::updatePortaApplicativa] Errore durante l'update della PortaApplicativa : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void deletePortaApplicativa(PortaApplicativa aPA) throws DriverConfigurazioneException {
        if (aPA == null) {
            throw new DriverConfigurazioneException("Porta Applicativa non valida");
        }
        if (aPA.getNome() == null || aPA.getNome().equals("")) {
            throw new DriverConfigurazioneException("Nome Porta Applicativa non valido");
        }
        if (aPA.getNomeSoggettoProprietario() == null || aPA.getNomeSoggettoProprietario().equals("")) {
            throw new DriverConfigurazioneException("Nome Soggetto Proprietario Porta Applicativa non valido");
        }
        if (aPA.getTipoSoggettoProprietario() == null || aPA.getTipoSoggettoProprietario().equals("")) {
            throw new DriverConfigurazioneException("Tipo Soggetto Proprietario Porta Applicativa non valido");
        }
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("deletePortaApplicativa");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::deletePortaApplicativa] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            this.log.debug("CRUDPortaApplicativa type = 3");
            long id = DriverConfigurazioneDB_LIB.CRUDPortaApplicativa(3, aPA, con);
            this.log.debug("Cancellazione PortaApplicativa [" + id + "] completato.");
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::deletePortaApplicativa] Errore durante la cancellazione della PortaApplicativa : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public Hashtable<IDSoggetto, PortaApplicativa> getPorteApplicative_SoggettiVirtuali(IDPortaApplicativa idPA) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        this.log.debug("metodo getPorteApplicative_SoggettiVirtuali in esecuzione...");
        if (idPA == null) {
            throw new DriverConfigurazioneException("[getPortaApplicativa_SoggettiVirtuali] Parametro idPA Non Valido");
        }
        if (idPA.getIDServizio() == null) {
            throw new DriverConfigurazioneException("[getPortaApplicativa_SoggettiVirtuali] Parametro idServizio Non Valido");
        }
        if (idPA.getIDServizio().getSoggettoErogatore() == null) {
            throw new DriverConfigurazioneException("[getPortaApplicativa_SoggettiVirtuali] Parametro Soggetto Erogatore Non Valido");
        }
        Hashtable<IDSoggetto, PortaApplicativa> paConSoggetti = new Hashtable<IDSoggetto, PortaApplicativa>();
        IDSoggetto soggettoVirtuale = idPA.getIDServizio().getSoggettoErogatore();
        String servizio = idPA.getIDServizio().getServizio();
        String tipoServizio = idPA.getIDServizio().getTipoServizio();
        String azione = idPA.getIDServizio().getAzione();
        if (servizio == null || tipoServizio == null) {
            throw new DriverConfigurazioneException("[getPortaApplicativa_SoggettiVirtuali] Parametri (Servizio) Non Validi");
        }
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        String sqlQuery = null;
        ResultSet rs1 = null;
        Statement stm1 = null;
        ResultSet rs2 = null;
        Statement stm2 = null;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("getPorteApplicative_SoggettiVirtuali");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getPorteApplicative_SoggettiVirtuali] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            String nomeSoggVirt = soggettoVirtuale.getNome();
            String tipoSoggVirt = soggettoVirtuale.getTipo();
            if (nomeSoggVirt == null || nomeSoggVirt.equals("") || tipoSoggVirt == null || tipoSoggVirt.equals("")) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getPorteApplicative_SoggettiVirtuali] Parametri SoggettoVirtuale non corretti.");
            }
            ArrayList<Long> soggettiList = new ArrayList<Long>();
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable(this.tabellaSoggetti);
            sqlQueryObject.addSelectField("id");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            rs = stm.executeQuery();
            while (rs.next()) {
                soggettiList.add(rs.getLong(1));
            }
            rs.close();
            stm.close();
            for (Long idSoggetto : soggettiList) {
                if (azione == null || azione.trim().equals("")) {
                    this.log.debug("azione == null");
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                    sqlQueryObject.addFromTable(this.tabellaSoggetti);
                    sqlQueryObject.addFromTable("porte_applicative");
                    sqlQueryObject.addSelectAliasField("porte_applicative.descrizione", "descrizionePA");
                    sqlQueryObject.addSelectAliasField("porte_applicative.id", "id_porta_applicativa");
                    sqlQueryObject.addSelectAliasField(this.tabellaSoggetti + ".id", "id_proprietario");
                    sqlQueryObject.addWhereCondition(this.tabellaSoggetti + ".id = porte_applicative.id_soggetto");
                    sqlQueryObject.addWhereCondition("porte_applicative.nome_soggetto_virtuale = ?");
                    sqlQueryObject.addWhereCondition("porte_applicative.tipo_soggetto_virtuale = ?");
                    sqlQueryObject.addWhereCondition("porte_applicative.tipo_servizio = ?");
                    sqlQueryObject.addWhereCondition("porte_applicative.servizio = ?");
                    sqlQueryObject.addWhereCondition(false, "porte_applicative.azione IS NULL", "porte_applicative.azione = ?", "porte_applicative.azione = ?");
                    sqlQueryObject.addWhereCondition(this.tabellaSoggetti + ".id = ?");
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQuery = sqlQueryObject.createSQLQuery();
                    stm = con.prepareStatement(sqlQuery, 1004, 1007);
                    stm.setString(1, nomeSoggVirt);
                    stm.setString(2, tipoSoggVirt);
                    stm.setString(3, tipoServizio);
                    stm.setString(4, servizio);
                    stm.setString(5, "");
                    stm.setString(6, "-");
                    stm.setLong(7, idSoggetto);
                    this.log.debug("eseguo query " + DBUtils.formatSQLString(sqlQuery, nomeSoggVirt, tipoSoggVirt, tipoServizio, servizio));
                } else {
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                    sqlQueryObject.addFromTable(this.tabellaSoggetti);
                    sqlQueryObject.addFromTable("porte_applicative");
                    sqlQueryObject.addSelectAliasField("porte_applicative.descrizione", "descrizionePA");
                    sqlQueryObject.addSelectAliasField("porte_applicative.id", "id_porta_applicativa");
                    sqlQueryObject.addSelectAliasField(this.tabellaSoggetti + ".id", "id_proprietario");
                    sqlQueryObject.addWhereCondition(this.tabellaSoggetti + ".id = porte_applicative.id_soggetto");
                    sqlQueryObject.addWhereCondition("porte_applicative.nome_soggetto_virtuale = ?");
                    sqlQueryObject.addWhereCondition("porte_applicative.tipo_soggetto_virtuale = ?");
                    sqlQueryObject.addWhereCondition("porte_applicative.tipo_servizio = ?");
                    sqlQueryObject.addWhereCondition("porte_applicative.servizio = ?");
                    sqlQueryObject.addWhereCondition("porte_applicative.azione = ?");
                    sqlQueryObject.addWhereCondition(this.tabellaSoggetti + ".id = ?");
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQuery = sqlQueryObject.createSQLQuery();
                    stm = con.prepareStatement(sqlQuery, 1004, 1007);
                    stm.setString(1, nomeSoggVirt);
                    stm.setString(2, tipoSoggVirt);
                    stm.setString(3, tipoServizio);
                    stm.setString(4, servizio);
                    stm.setString(5, azione);
                    stm.setLong(6, idSoggetto);
                    this.log.debug("eseguo query " + DBUtils.formatSQLString(sqlQuery, nomeSoggVirt, tipoSoggVirt, tipoServizio, servizio, azione));
                }
                rs = stm.executeQuery();
                boolean trovato = rs.next();
                if (!trovato && azione != null) {
                    this.log.debug("Cerco PA generica (Azione non definita)");
                    rs.close();
                    stm.close();
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                    sqlQueryObject.addFromTable(this.tabellaSoggetti);
                    sqlQueryObject.addFromTable("porte_applicative");
                    sqlQueryObject.addSelectAliasField("porte_applicative.descrizione", "descrizionePA");
                    sqlQueryObject.addSelectAliasField("porte_applicative.id", "id_porta_applicativa");
                    sqlQueryObject.addSelectAliasField(this.tabellaSoggetti + ".id", "id_proprietario");
                    sqlQueryObject.addWhereCondition(this.tabellaSoggetti + ".id = porte_applicative.id_soggetto");
                    sqlQueryObject.addWhereCondition("porte_applicative.nome_soggetto_virtuale = ?");
                    sqlQueryObject.addWhereCondition("porte_applicative.tipo_soggetto_virtuale = ?");
                    sqlQueryObject.addWhereCondition("porte_applicative.tipo_servizio = ?");
                    sqlQueryObject.addWhereCondition("porte_applicative.servizio = ?");
                    sqlQueryObject.addWhereCondition(false, "porte_applicative.azione IS NULL", "porte_applicative.azione = ?", "porte_applicative.azione = ?");
                    sqlQueryObject.addWhereCondition(this.tabellaSoggetti + ".id = ?");
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQuery = sqlQueryObject.createSQLQuery();
                    this.log.debug("eseguo query " + DBUtils.formatSQLString(sqlQuery, nomeSoggVirt, tipoSoggVirt, tipoServizio, servizio));
                    this.log.debug("QUERY RAW: " + sqlQuery);
                    stm = con.prepareStatement(sqlQuery, 1004, 1007);
                    stm.setString(1, nomeSoggVirt);
                    stm.setString(2, tipoSoggVirt);
                    stm.setString(3, tipoServizio);
                    stm.setString(4, servizio);
                    stm.setString(5, "");
                    stm.setString(6, "-");
                    stm.setLong(7, idSoggetto);
                    rs = stm.executeQuery();
                    trovato = rs.next();
                }
                this.log.debug("Ripristino rs");
                rs.beforeFirst();
                this.log.debug("Itero rs...");
                while (trovato && rs.next()) {
                    this.log.debug("PortaApplicativa, raccolta dati");
                    long idPortaApplicativa = rs.getLong("id_porta_applicativa");
                    this.log.debug("PortaApplicativa, raccolta dati id[" + idPortaApplicativa + "] in corso...");
                    PortaApplicativa pa = this.getPortaApplicativa(idPortaApplicativa, con);
                    this.log.debug("PortaApplicativa, raccolta dati id[" + idPortaApplicativa + "] effettuata.");
                    long idSoggettoProprietario = rs.getLong("id_proprietario");
                    this.log.debug("PortaApplicativa, raccolta dati soggetto id[" + idSoggettoProprietario + "] in corso...");
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                    sqlQueryObject.addFromTable(this.tabellaSoggetti);
                    sqlQueryObject.addSelectField("*");
                    sqlQueryObject.addWhereCondition("id = ?");
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQuery = sqlQueryObject.createSQLQuery();
                    stm1 = con.prepareStatement(sqlQuery);
                    stm1.setLong(1, idSoggettoProprietario);
                    rs1 = stm1.executeQuery();
                    IDSoggetto soggettoProprietario = null;
                    if (!rs1.next()) {
                        throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getPorteApplicative_SoggettiVirtuali] Impossibile trovare le informazioni del soggetto proprietario della PA.");
                    }
                    soggettoProprietario = new IDSoggetto(rs1.getString("tipo_soggetto"), rs1.getString("nome_soggetto"));
                    rs1.close();
                    stm1.close();
                    this.log.debug("PortaApplicativa, raccolta dati soggetto id[" + idSoggettoProprietario + "] completata.");
                    paConSoggetti.put(soggettoProprietario, pa);
                }
                rs.close();
                stm.close();
            }
            if (paConSoggetti.size() == 0) {
                throw new DriverConfigurazioneNotFound("[getPortaApplicativa_SoggettiVirtuali] Porte applicative di soggetti virtuali non esistenti.");
            }
            Hashtable<IDSoggetto, PortaApplicativa> hashtable = paConSoggetti;
            return hashtable;
        }
        catch (SQLException se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getPorteApplicative_SoggettiVirtuali] SqlException: " + se.getMessage(), se);
        }
        catch (DriverConfigurazioneNotFound de) {
            throw de;
        }
        catch (Exception se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getPorteApplicative_SoggettiVirtuali] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (rs2 != null) {
                    rs2.close();
                }
                if (stm2 != null) {
                    stm2.close();
                }
                if (rs1 != null) {
                    rs1.close();
                }
                if (stm1 != null) {
                    stm1.close();
                }
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<String> portaApplicativaRuoliList(long idPA, ISearch ricerca) throws DriverConfigurazioneException {
        String nomeMetodo = "portaApplicativaRuoliList";
        int idLista = 14;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        boolean error = false;
        Statement stmt = null;
        ResultSet risultato = null;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource(nomeMetodo);
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        ArrayList<String> listIdRuoli = null;
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("porte_applicative");
                sqlQueryObject.addFromTable("pa_ruoli");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("porte_applicative.id=?");
                sqlQueryObject.addWhereCondition("porte_applicative.id=pa_ruoli.id_porta");
                sqlQueryObject.addWhereLikeCondition("pa_ruoli.ruolo", search, true, true);
                sqlQueryObject.setSelectDistinct(true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("porte_applicative");
                sqlQueryObject.addFromTable("pa_ruoli");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("porte_applicative.id=?");
                sqlQueryObject.addWhereCondition("porte_applicative.id=pa_ruoli.id_porta");
                sqlQueryObject.setSelectDistinct(true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPA);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("porte_applicative");
                sqlQueryObject.addFromTable("pa_ruoli");
                sqlQueryObject.addSelectField("pa_ruoli.ruolo");
                sqlQueryObject.addWhereCondition("porte_applicative.id=?");
                sqlQueryObject.addWhereCondition("porte_applicative.id=pa_ruoli.id_porta");
                sqlQueryObject.addWhereLikeCondition("pa_ruoli.ruolo", search, true, true);
                sqlQueryObject.setSelectDistinct(true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("pa_ruoli.ruolo");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("porte_applicative");
                sqlQueryObject.addFromTable("pa_ruoli");
                sqlQueryObject.addSelectField("pa_ruoli.ruolo");
                sqlQueryObject.addWhereCondition("porte_applicative.id=?");
                sqlQueryObject.addWhereCondition("porte_applicative.id=pa_ruoli.id_porta");
                sqlQueryObject.setSelectDistinct(true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("pa_ruoli.ruolo");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPA);
            risultato = stmt.executeQuery();
            listIdRuoli = new ArrayList<String>();
            while (risultato.next()) {
                listIdRuoli.add(risultato.getString(1));
            }
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
        return listIdRuoli;
    }

    @Override
    public ServizioApplicativo getServizioApplicativo(IDPortaDelegata idPD, String servizioApplicativo) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.getServizioApplicativo(1, idPD, null, servizioApplicativo, null, null, null, 0L);
    }

    @Override
    public ServizioApplicativo getServizioApplicativo(IDPortaApplicativa idPA, String servizioApplicativo) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.getServizioApplicativo(4, null, idPA, servizioApplicativo, null, null, null, 0L);
    }

    @Override
    public ServizioApplicativo getServizioApplicativoAutenticatoBasic(IDPortaDelegata idPD, String aUser, String aPassword) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.getServizioApplicativo(2, idPD, null, null, aUser, aPassword, null, 0L);
    }

    @Override
    public ServizioApplicativo getServizioApplicativoAutenticatoBasic(String aUser, String aPassword) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.getServizioApplicativo(22, null, null, null, aUser, aPassword, null, 0L);
    }

    @Override
    public ServizioApplicativo getServizioApplicativoAutenticatoSsl(IDPortaDelegata idPD, String aSubject) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.getServizioApplicativo(3, idPD, null, null, null, null, aSubject, 0L);
    }

    @Override
    public ServizioApplicativo getServizioApplicativoAutenticatoSsl(String aSubject) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.getServizioApplicativo(33, null, null, null, null, null, aSubject, 0L);
    }

    @Override
    public ServizioApplicativo getServizioApplicativoAutenticatoPrincipal(IDPortaDelegata idPD, String principal) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.getServizioApplicativo(6, idPD, null, null, principal, null, null, 0L);
    }

    @Override
    public ServizioApplicativo getServizioApplicativoAutenticatoPrincipal(String principal) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.getServizioApplicativo(66, null, null, null, principal, null, null, 0L);
    }

    @Override
    public ServizioApplicativo getServizioApplicativo(IDServizioApplicativo idServizioApplicativo) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        IDPortaDelegata idPD = new IDPortaDelegata();
        idPD.setSoggettoFruitore(idServizioApplicativo.getIdSoggettoProprietario());
        return this.getServizioApplicativo(1, idPD, null, idServizioApplicativo.getNome(), null, null, null, 0L);
    }

    @Override
    public ServizioApplicativo getServizioApplicativo(IDSoggetto idSoggetto, String nomeServizioApplicativo) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        IDServizioApplicativo idServizioApplicativo = new IDServizioApplicativo();
        idServizioApplicativo.setIdSoggettoProprietario(idSoggetto);
        idServizioApplicativo.setNome(nomeServizioApplicativo);
        return this.getServizioApplicativo(idServizioApplicativo);
    }

    private ServizioApplicativo getServizioApplicativo(int type, IDPortaDelegata idPD, IDPortaApplicativa idPA, String servizioApplicativo, String aUser, String aPassord, String aSubject, long idServizioApplicativo) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        String nome_sa = null;
        String sqlQuery = null;
        ServizioApplicativo sa = null;
        long idSoggettoFruitore = -1L;
        IDSoggetto idSF = null;
        switch (type) {
            case 1: {
                if (idPD == null) {
                    throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getServizioApplicativo] Parametro idPD non valido.");
                }
                IDSoggetto idSO = idPD.getSoggettoFruitore();
                if (idSO == null) {
                    throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getServizioApplicativo] Soggetto Fruitore non Impostato.");
                }
                if (idSO.getNome() == null || "".equals(idSO.getNome())) {
                    throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getServizioApplicativo] Nome Soggetto Fruitore non Impostato.");
                }
                if (idSO.getTipo() == null || "".equals(idSO.getTipo())) {
                    throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getServizioApplicativo] Nome Soggetto Fruitore non Impostato.");
                }
                nome_sa = servizioApplicativo;
                break;
            }
            case 2: 
            case 22: {
                if (type == 2) {
                    if (idPD == null) {
                        throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getServizioApplicativo] Parametro idPD non valido.");
                    }
                    if (idPD.getSoggettoFruitore() == null) {
                        throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getServizioApplicativo] Parametro idPD.getSoggettoFruitore() non valido.");
                    }
                    idSF = idPD.getSoggettoFruitore();
                    if (idSF.getNome() == null || idSF.getTipo() == null) {
                        throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getServizioApplicativo] Parametro idPD.getSoggettoFruitore(valori) non valido.");
                    }
                }
                if (aUser == null || aUser.trim().equals("") || aPassord == null || aPassord.trim().equals("")) {
                    throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getServizioApplicativo] Parametri di autenticazione user[" + aUser + "] password[" + aPassord + "] non validi.");
                }
                nome_sa = servizioApplicativo;
                break;
            }
            case 3: 
            case 33: {
                if (type == 3) {
                    if (idPD == null) {
                        throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getServizioApplicativo] Parametro idPD non valido.");
                    }
                    if (idPD.getSoggettoFruitore() == null) {
                        throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getServizioApplicativo] Parametro idPD.getSoggettoFruitore() non valido.");
                    }
                    idSF = idPD.getSoggettoFruitore();
                    if (idSF.getNome() == null || idSF.getTipo() == null) {
                        throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getServizioApplicativo] Parametro idPD.getSoggettoFruitore(valori) non valido.");
                    }
                }
                if (aSubject == null || aSubject.trim().equals("")) {
                    throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getServizioApplicativo] Parametri di autenticazione subject[" + aSubject + "] non validi.");
                }
                nome_sa = servizioApplicativo;
                break;
            }
            case 4: {
                if (idPA == null) {
                    throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getServizioApplicativo] Parametro idPA non valido.");
                }
                IDServizio idSE = idPA.getIDServizio();
                if (idSE == null) {
                    throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getServizioApplicativo] IDServizio non impostato.");
                }
                IDSoggetto idSO = idSE.getSoggettoErogatore();
                if (idSO == null) {
                    throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getServizioApplicativo] Soggetto Erogatore non Impostato.");
                }
                if (idSO.getNome() == null || "".equals(idSO.getNome())) {
                    throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getServizioApplicativo] Nome Soggetto Erogatore non Impostato.");
                }
                if (idSO.getTipo() == null || "".equals(idSO.getTipo())) {
                    throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getServizioApplicativo] Nome Soggetto Erogatore non Impostato.");
                }
                nome_sa = servizioApplicativo;
                break;
            }
            case 5: {
                if (idServizioApplicativo > 0L) break;
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getServizioApplicativo] L'id del Servizio applicativo deve essere > 0.");
            }
            case 6: 
            case 66: {
                if (type == 6) {
                    if (idPD == null) {
                        throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getServizioApplicativo] Parametro idPD non valido.");
                    }
                    if (idPD.getSoggettoFruitore() == null) {
                        throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getServizioApplicativo] Parametro idPD.getSoggettoFruitore() non valido.");
                    }
                    idSF = idPD.getSoggettoFruitore();
                    if (idSF.getNome() == null || idSF.getTipo() == null) {
                        throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getServizioApplicativo] Parametro idPD.getSoggettoFruitore(valori) non valido.");
                    }
                }
                if (aUser == null || aUser.trim().equals("")) {
                    throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getServizioApplicativo] Parametri di autenticazione user-principal[" + aUser + "] non valido.");
                }
                nome_sa = servizioApplicativo;
                break;
            }
            default: {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getServizioApplicativo] Parametri non validi.");
            }
        }
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("getServizioApplicativo");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getSoggetto] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            switch (type) {
                case 1: {
                    String tipoSog = idPD.getSoggettoFruitore().getTipo();
                    String nomeSog = idPD.getSoggettoFruitore().getNome();
                    long idSog = DBUtils.getIdSoggetto(nomeSog, tipoSog, con, this.tipoDB, this.tabellaSoggetti);
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                    sqlQueryObject.addFromTable("servizi_applicativi");
                    sqlQueryObject.addSelectField("*");
                    sqlQueryObject.addWhereCondition("nome = ?");
                    sqlQueryObject.addWhereCondition("id_soggetto = ?");
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQuery = sqlQueryObject.createSQLQuery();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setString(1, nome_sa);
                    stm.setLong(2, idSog);
                    this.log.debug("eseguo query: " + DBUtils.formatSQLString(sqlQuery, nome_sa));
                    break;
                }
                case 2: 
                case 22: {
                    if (type == 2) {
                        idSoggettoFruitore = DBUtils.getIdSoggetto(idSF.getNome(), idSF.getTipo(), con, this.tipoDB, this.tabellaSoggetti);
                    }
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                    sqlQueryObject.addFromTable("servizi_applicativi");
                    sqlQueryObject.addSelectField("*");
                    sqlQueryObject.addWhereCondition("tipoauth = ?");
                    sqlQueryObject.addWhereCondition("utente = ?");
                    sqlQueryObject.addWhereCondition("password = ?");
                    if (type == 2) {
                        sqlQueryObject.addWhereCondition("id_soggetto = ?");
                    }
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQuery = sqlQueryObject.createSQLQuery();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setString(1, CostantiConfigurazione.CREDENZIALE_BASIC.toString());
                    stm.setString(2, aUser);
                    stm.setString(3, aPassord);
                    if (type == 2) {
                        stm.setLong(4, idSoggettoFruitore);
                    }
                    this.log.debug("eseguo query :" + DBUtils.formatSQLString(sqlQuery, CostantiConfigurazione.CREDENZIALE_BASIC.toString(), aUser, aPassord));
                    break;
                }
                case 3: 
                case 33: {
                    if (type == 3) {
                        idSoggettoFruitore = DBUtils.getIdSoggetto(idSF.getNome(), idSF.getTipo(), con, this.tipoDB, this.tabellaSoggetti);
                    }
                    Hashtable<String, String> hashSubject = Utilities.getSubjectIntoHashtable(aSubject);
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                    sqlQueryObject.addFromTable("servizi_applicativi");
                    sqlQueryObject.addSelectField("*");
                    sqlQueryObject.addWhereCondition("tipoauth = ?");
                    Enumeration<String> keys = hashSubject.keys();
                    while (keys.hasMoreElements()) {
                        String key = keys.nextElement();
                        String value = hashSubject.get(key);
                        sqlQueryObject.addWhereLikeCondition("subject", "/" + Utilities.formatKeySubject(key) + "=" + Utilities.formatValueSubject(value) + "/", true, true, false);
                    }
                    if (type == 3) {
                        sqlQueryObject.addWhereCondition("id_soggetto = ?");
                    }
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQuery = sqlQueryObject.createSQLQuery();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setString(1, CostantiConfigurazione.CREDENZIALE_SSL.toString());
                    if (type == 3) {
                        stm.setLong(2, idSoggettoFruitore);
                    }
                    if (type == 3) {
                        this.log.debug("eseguo query: " + DBUtils.formatSQLString(sqlQuery, CostantiConfigurazione.CREDENZIALE_SSL.toString(), idSoggettoFruitore));
                    } else {
                        this.log.debug("eseguo query: " + DBUtils.formatSQLString(sqlQuery, CostantiConfigurazione.CREDENZIALE_SSL.toString()));
                    }
                    rs = stm.executeQuery();
                    long idSA = -1L;
                    while (rs.next()) {
                        String subjectPotenziale = rs.getString("subject");
                        if (!Utilities.sslVerify(subjectPotenziale, aSubject, this.log)) continue;
                        idSA = rs.getLong("id");
                        break;
                    }
                    rs.close();
                    stm.close();
                    if (idSA <= 0L) {
                        throw new DriverConfigurazioneNotFound("Nessun Servizio Applicativo trovato.");
                    }
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                    sqlQueryObject.addFromTable("servizi_applicativi");
                    sqlQueryObject.addSelectField("*");
                    sqlQueryObject.addWhereCondition("id = ?");
                    stm = con.prepareStatement(sqlQueryObject.toString());
                    stm.setLong(1, idSA);
                    this.log.debug("eseguo query: " + DBUtils.formatSQLString(sqlQuery, idSA));
                    break;
                }
                case 4: {
                    String tipoSog = idPA.getIDServizio().getSoggettoErogatore().getTipo();
                    String nomeSog = idPA.getIDServizio().getSoggettoErogatore().getNome();
                    long idSog = DBUtils.getIdSoggetto(nomeSog, tipoSog, con, this.tipoDB, this.tabellaSoggetti);
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                    sqlQueryObject.addFromTable("servizi_applicativi");
                    sqlQueryObject.addSelectField("*");
                    sqlQueryObject.addWhereCondition("nome = ?");
                    sqlQueryObject.addWhereCondition("id_soggetto = ?");
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQuery = sqlQueryObject.createSQLQuery();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setString(1, nome_sa);
                    stm.setLong(2, idSog);
                    this.log.debug("eseguo query: " + DBUtils.formatSQLString(sqlQuery, nome_sa));
                    break;
                }
                case 5: {
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                    sqlQueryObject.addFromTable("servizi_applicativi");
                    sqlQueryObject.addSelectField("*");
                    sqlQueryObject.addWhereCondition("id = ?");
                    sqlQuery = sqlQueryObject.createSQLQuery();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idServizioApplicativo);
                    this.log.debug("eseguo query: " + DBUtils.formatSQLString(sqlQuery, idServizioApplicativo));
                    break;
                }
                case 6: 
                case 66: {
                    if (type == 6) {
                        idSoggettoFruitore = DBUtils.getIdSoggetto(idSF.getNome(), idSF.getTipo(), con, this.tipoDB, this.tabellaSoggetti);
                    }
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                    sqlQueryObject.addFromTable("servizi_applicativi");
                    sqlQueryObject.addSelectField("*");
                    sqlQueryObject.addWhereCondition("tipoauth = ?");
                    sqlQueryObject.addWhereCondition("utente = ?");
                    if (type == 6) {
                        sqlQueryObject.addWhereCondition("id_soggetto = ?");
                    }
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQuery = sqlQueryObject.createSQLQuery();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setString(1, CostantiConfigurazione.CREDENZIALE_PRINCIPAL.toString());
                    stm.setString(2, aUser);
                    if (type == 6) {
                        stm.setLong(3, idSoggettoFruitore);
                    }
                    this.log.debug("eseguo query :" + DBUtils.formatSQLString(sqlQuery, CostantiConfigurazione.CREDENZIALE_PRINCIPAL.toString(), aUser));
                }
            }
            rs = stm.executeQuery();
            if (rs.next()) {
                sa = new ServizioApplicativo();
                sa.setId(rs.getLong("id"));
                sa.setNome(rs.getString("nome"));
                sa.setIdSoggetto(rs.getLong("id_soggetto"));
                sa.setTipoSoggettoProprietario(this.getSoggetto(sa.getIdSoggetto(), con).getTipo());
                sa.setNomeSoggettoProprietario(this.getSoggetto(sa.getIdSoggetto(), con).getNome());
                sa.setDescrizione(rs.getString("descrizione"));
                String tipoFruizione = rs.getString("tipologia_fruizione") != null && !"".equals(rs.getString("tipologia_fruizione")) ? rs.getString("tipologia_fruizione") : TipologiaFruizione.DISABILITATO.toString();
                String tipoErogazione = rs.getString("tipologia_erogazione") != null && !"".equals(rs.getString("tipologia_erogazione")) ? rs.getString("tipologia_erogazione") : TipologiaErogazione.DISABILITATO.toString();
                sa.setTipologiaFruizione(TipologiaFruizione.valueOf(tipoFruizione.toUpperCase()).toString());
                sa.setTipologiaErogazione(TipologiaErogazione.valueOf(tipoErogazione.toUpperCase()).toString());
                InvocazionePorta invPorta = null;
                String tipoAuth = rs.getString("tipoauth");
                String fault = rs.getString("fault");
                String faultActor = rs.getString("fault_actor");
                String prefixFault = rs.getString("prefix_fault_code");
                String genericFault = rs.getString("generic_fault_code");
                if (tipoAuth != null && !tipoAuth.equals("") || fault != null && !fault.equals("") || faultActor != null && !faultActor.equals("") || genericFault != null && !genericFault.equals("") || prefixFault != null && !prefixFault.equals("")) {
                    invPorta = new InvocazionePorta();
                    Credenziali credenziali = new Credenziali();
                    credenziali.setPassword(rs.getString("password"));
                    credenziali.setSubject(rs.getString("subject"));
                    credenziali.setTipo(DriverConfigurazioneDB_LIB.getEnumCredenzialeTipo(tipoAuth));
                    credenziali.setUser(rs.getString("utente"));
                    if (tipoAuth != null && !tipoAuth.equals("")) {
                        invPorta.addCredenziali(credenziali);
                    }
                    InvocazionePortaGestioneErrore gestioneErrore = new InvocazionePortaGestioneErrore();
                    gestioneErrore.setFault(DriverConfigurazioneDB_LIB.getEnumFaultIntegrazioneTipo(fault));
                    gestioneErrore.setFaultActor(faultActor);
                    gestioneErrore.setGenericFaultCode(DriverConfigurazioneDB_LIB.getEnumStatoFunzionalita(genericFault));
                    gestioneErrore.setPrefixFaultCode(prefixFault);
                    invPorta.setGestioneErrore(fault != null || faultActor != null || genericFault != null || prefixFault != null ? gestioneErrore : null);
                    invPorta.setInvioPerRiferimento(DriverConfigurazioneDB_LIB.getEnumStatoFunzionalita(rs.getString("invio_x_rif")));
                    int sbustamentoInfoProtocollo = rs.getInt("sbustamento_protocol_info");
                    if (1 == sbustamentoInfoProtocollo) {
                        invPorta.setSbustamentoInformazioniProtocollo(CostantiConfigurazione.ABILITATO);
                    } else if (0 == sbustamentoInfoProtocollo) {
                        invPorta.setSbustamentoInformazioniProtocollo(CostantiConfigurazione.DISABILITATO);
                    } else {
                        invPorta.setSbustamentoInformazioniProtocollo(CostantiConfigurazione.ABILITATO);
                    }
                }
                Long idConnettore = rs.getLong("id_connettore_risp");
                String getMsgRisp = rs.getString("getmsgrisp");
                RispostaAsincrona rispAsinc = null;
                if (idConnettore > 0L || getMsgRisp != null && !getMsgRisp.equals("")) {
                    rispAsinc = new RispostaAsincrona();
                    rispAsinc.setAutenticazione(DriverConfigurazioneDB_LIB.getEnumInvocazioneServizioTipoAutenticazione(rs.getString("tipoauthrisp")));
                    rispAsinc.setInvioPerRiferimento(DriverConfigurazioneDB_LIB.getEnumStatoFunzionalita(rs.getString("invio_x_rif_risp")));
                    rispAsinc.setRispostaPerRiferimento(DriverConfigurazioneDB_LIB.getEnumStatoFunzionalita(rs.getString("risposta_x_rif_risp")));
                    if (rispAsinc.getAutenticazione() != null && InvocazioneServizioTipoAutenticazione.BASIC.equals(rispAsinc.getAutenticazione())) {
                        InvocazioneCredenziali credenzialiRispA = new InvocazioneCredenziali();
                        credenzialiRispA.setPassword(rs.getString("passwordrisp"));
                        credenzialiRispA.setUser(rs.getString("utenterisp"));
                        rispAsinc.setCredenziali(credenzialiRispA);
                    }
                    Connettore connettore = DriverConfigurazioneDB_LIB.getConnettore(idConnettore, con);
                    rispAsinc.setConnettore(connettore);
                    rispAsinc.setGetMessage(DriverConfigurazioneDB_LIB.getEnumStatoFunzionalita(getMsgRisp));
                    int sbustamentoInfoProtocollo = rs.getInt("sbustamento_protocol_info_risp");
                    if (1 == sbustamentoInfoProtocollo) {
                        rispAsinc.setSbustamentoInformazioniProtocollo(CostantiConfigurazione.ABILITATO);
                    } else if (0 == sbustamentoInfoProtocollo) {
                        rispAsinc.setSbustamentoInformazioniProtocollo(CostantiConfigurazione.DISABILITATO);
                    } else {
                        rispAsinc.setSbustamentoInformazioniProtocollo(CostantiConfigurazione.ABILITATO);
                    }
                    if (rs.getInt("sbustamentorisp") == 1) {
                        rispAsinc.setSbustamentoSoap(CostantiConfigurazione.ABILITATO);
                    } else {
                        rispAsinc.setSbustamentoSoap(CostantiConfigurazione.DISABILITATO);
                    }
                    Long idGestioneErroreRispostaAsincrona = rs.getLong("id_gestione_errore_risp");
                    GestioneErrore gestioneErroreRispostaAsincrona = null;
                    if (idGestioneErroreRispostaAsincrona > 0L) {
                        gestioneErroreRispostaAsincrona = DriverConfigurazioneDB_LIB.getGestioneErrore(idGestioneErroreRispostaAsincrona, con);
                        rispAsinc.setGestioneErrore(gestioneErroreRispostaAsincrona);
                    }
                }
                idConnettore = rs.getLong("id_connettore_inv");
                String getMsgInv = rs.getString("getmsginv");
                InvocazioneServizio invServizio = null;
                if (idConnettore > 0L || getMsgInv != null && !getMsgInv.equals("")) {
                    invServizio = new InvocazioneServizio();
                    Connettore connserv = DriverConfigurazioneDB_LIB.getConnettore(idConnettore, con);
                    invServizio.setConnettore(connserv);
                    invServizio.setGetMessage(DriverConfigurazioneDB_LIB.getEnumStatoFunzionalita(getMsgInv));
                    int sbustamentoInfoProtocollo = rs.getInt("sbustamento_protocol_info_inv");
                    if (1 == sbustamentoInfoProtocollo) {
                        invServizio.setSbustamentoInformazioniProtocollo(CostantiConfigurazione.ABILITATO);
                    } else if (0 == sbustamentoInfoProtocollo) {
                        invServizio.setSbustamentoInformazioniProtocollo(CostantiConfigurazione.DISABILITATO);
                    } else {
                        invServizio.setSbustamentoInformazioniProtocollo(CostantiConfigurazione.ABILITATO);
                    }
                    if (rs.getInt("sbustamentoinv") == 1) {
                        invServizio.setSbustamentoSoap(CostantiConfigurazione.ABILITATO);
                    } else {
                        invServizio.setSbustamentoSoap(CostantiConfigurazione.DISABILITATO);
                    }
                    invServizio.setAutenticazione(DriverConfigurazioneDB_LIB.getEnumInvocazioneServizioTipoAutenticazione(rs.getString("tipoauthinv")));
                    invServizio.setInvioPerRiferimento(DriverConfigurazioneDB_LIB.getEnumStatoFunzionalita(rs.getString("invio_x_rif_inv")));
                    invServizio.setRispostaPerRiferimento(DriverConfigurazioneDB_LIB.getEnumStatoFunzionalita(rs.getString("risposta_x_rif_inv")));
                    if (invServizio.getAutenticazione() != null && InvocazioneServizioTipoAutenticazione.BASIC.equals(invServizio.getAutenticazione())) {
                        InvocazioneCredenziali credInvServ = new InvocazioneCredenziali();
                        credInvServ.setPassword(rs.getString("passwordinv"));
                        credInvServ.setUser(rs.getString("utenteinv"));
                        invServizio.setCredenziali(credInvServ);
                    }
                    Long idGestioneErroreInvocazioneServizio = rs.getLong("id_gestione_errore_inv");
                    GestioneErrore gestioneErroreInvocazioneServizio = null;
                    if (idGestioneErroreInvocazioneServizio > 0L) {
                        gestioneErroreInvocazioneServizio = DriverConfigurazioneDB_LIB.getGestioneErrore(idGestioneErroreInvocazioneServizio, con);
                        invServizio.setGestioneErrore(gestioneErroreInvocazioneServizio);
                    }
                }
                sa.setInvocazionePorta(invPorta);
                sa.setRispostaAsincrona(rispAsinc);
                sa.setInvocazioneServizio(invServizio);
                if (sa.getTipologiaErogazione() == null) {
                    sa.setTipologiaErogazione(TipologiaErogazione.DISABILITATO.getValue());
                }
                if (sa.getTipologiaFruizione() == null) {
                    sa.setTipologiaFruizione(TipologiaFruizione.DISABILITATO.getValue());
                }
                if (TipologiaErogazione.DISABILITATO.equals(sa.getTipologiaErogazione()) && TipologiaFruizione.DISABILITATO.equals(sa.getTipologiaFruizione())) {
                    if (sa.getInvocazionePorta() != null && sa.getInvocazionePorta().sizeCredenzialiList() > 0) {
                        sa.setTipologiaFruizione(TipologiaFruizione.NORMALE.getValue());
                    }
                    if (sa.getInvocazioneServizio() != null) {
                        if (StatoFunzionalita.ABILITATO.equals(sa.getInvocazioneServizio().getGetMessage())) {
                            sa.setTipologiaErogazione(TipologiaErogazione.MESSAGE_BOX.getValue());
                        } else if (sa.getInvocazioneServizio().getConnettore() != null && !TipiConnettore.DISABILITATO.getNome().equals(sa.getInvocazioneServizio().getConnettore().getTipo())) {
                            sa.setTipologiaErogazione(TipologiaErogazione.TRASPARENTE.getValue());
                        }
                    }
                }
                rs.close();
                stm.close();
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("sa_ruoli");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("id_servizio_applicativo=?");
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm = con.prepareStatement(sqlQuery);
                stm.setLong(1, sa.getId());
                rs = stm.executeQuery();
                while (rs.next()) {
                    if (sa.getInvocazionePorta() == null) {
                        sa.setInvocazionePorta(new InvocazionePorta());
                    }
                    if (sa.getInvocazionePorta().getRuoli() == null) {
                        sa.getInvocazionePorta().setRuoli(new ServizioApplicativoRuoli());
                    }
                    Ruolo ruolo = new Ruolo();
                    ruolo.setNome(rs.getString("ruolo"));
                    sa.getInvocazionePorta().getRuoli().addRuolo(ruolo);
                }
                rs.close();
                stm.close();
                ServizioApplicativo servizioApplicativo2 = sa;
                return servizioApplicativo2;
            }
            try {
                throw new DriverConfigurazioneNotFound("Nessun Servizio Applicativo trovato.");
            }
            catch (SQLException e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getServizioApplicativo] SQLException :" + e.getMessage(), e);
            }
            catch (DriverConfigurazioneNotFound e) {
                throw new DriverConfigurazioneNotFound(e);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getServizioApplicativo] Exception :" + e.getMessage(), e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void createServizioApplicativo(ServizioApplicativo aSA) throws DriverConfigurazioneException {
        if (aSA == null) {
            throw new DriverConfigurazioneException("Servizio Applicativo non valido");
        }
        if (aSA.getNome() == null || aSA.getNome().equals("")) {
            throw new DriverConfigurazioneException("Nome Servizio Applicativo non valido");
        }
        if (aSA.getNomeSoggettoProprietario() == null || aSA.getNomeSoggettoProprietario().equals("")) {
            throw new DriverConfigurazioneException("Nome Soggetto Proprietario Servizio Applicativo non valido");
        }
        if (aSA.getTipoSoggettoProprietario() == null || aSA.getTipoSoggettoProprietario().equals("")) {
            throw new DriverConfigurazioneException("Tipo Soggetto Proprietario Servizio Applicativo non valido");
        }
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("createServizioApplicativo");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::createServizioApplicativo] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            this.log.debug("CRUDServizioApplicativo type = 1");
            DriverConfigurazioneDB_LIB.CRUDServizioApplicativo(1, aSA, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::createServizioApplicativo] Errore durante la creazione del servizioApplicativo : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void updateServizioApplicativo(ServizioApplicativo aSA) throws DriverConfigurazioneException {
        if (aSA == null) {
            throw new DriverConfigurazioneException("Servizio Applicativo non valida");
        }
        if (aSA.getNome() == null || aSA.getNome().equals("")) {
            throw new DriverConfigurazioneException("Nome Servizio Applicativo non valido");
        }
        if (aSA.getNomeSoggettoProprietario() == null || aSA.getNomeSoggettoProprietario().equals("")) {
            throw new DriverConfigurazioneException("Nome Soggetto Proprietario Servizio Applicativo non valido");
        }
        if (aSA.getTipoSoggettoProprietario() == null || aSA.getTipoSoggettoProprietario().equals("")) {
            throw new DriverConfigurazioneException("Tipo Soggetto Proprietario Servizio Applicativo non valido");
        }
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("updateServizioApplicativo");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::updateServizioApplicativo] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            this.log.debug("CRUDServizioApplicativo type = 2");
            DriverConfigurazioneDB_LIB.CRUDServizioApplicativo(2, aSA, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("Errore durante l'aggiornamento del servizioApplicativo : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void deleteServizioApplicativo(ServizioApplicativo aSA) throws DriverConfigurazioneException {
        if (aSA == null) {
            throw new DriverConfigurazioneException("Servizio Applicativo non valida");
        }
        if (aSA.getNome() == null || aSA.getNome().equals("")) {
            throw new DriverConfigurazioneException("Nome Servizio Applicativo non valido");
        }
        if (aSA.getNomeSoggettoProprietario() == null || aSA.getNomeSoggettoProprietario().equals("")) {
            throw new DriverConfigurazioneException("Nome Soggetto Proprietario Servizio Applicativo non valido");
        }
        if (aSA.getTipoSoggettoProprietario() == null || aSA.getTipoSoggettoProprietario().equals("")) {
            throw new DriverConfigurazioneException("Tipo Soggetto Proprietario Servizio Applicativo non valido");
        }
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("deleteServizioApplicativo");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::deleteServizioApplicativo] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            this.log.debug("CRUDServizioApplicativo type = 3");
            DriverConfigurazioneDB_LIB.CRUDServizioApplicativo(3, aSA, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::deleteServizioApplicativo] Errore durante la delete del servizioApplicativo : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public RoutingTable getRoutingTable() throws DriverConfigurazioneException {
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        Statement stmSearch = null;
        ResultSet rsSearch = null;
        String sqlQuery = "";
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("getRoutingTable");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getRoutingTable] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            boolean routingEnabled = false;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("configurazione");
            sqlQueryObject.addSelectField("*");
            sqlQuery = sqlQueryObject.createSQLQuery();
            this.log.debug("eseguo query per routing enabled : " + DBUtils.formatSQLString(sqlQuery, new Object[0]));
            stm = con.prepareStatement(sqlQuery);
            rs = stm.executeQuery();
            if (rs.next()) {
                this.log.debug("ConfigurazionePresente");
                this.log.debug("Risultato query per routing enabled [" + rs.getString("routing_enabled") + "]");
                routingEnabled = CostantiConfigurazione.ABILITATO.equals(DriverConfigurazioneDB_LIB.getEnumStatoFunzionalita(rs.getString("routing_enabled")));
            }
            rs.close();
            stm.close();
            this.log.debug("RoutingEnabled: " + routingEnabled);
            RoutingTable rt = new RoutingTable();
            rt.setAbilitata(routingEnabled);
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("routing");
            sqlQueryObject.addSelectField("*");
            sqlQuery = sqlQueryObject.createSQLQuery();
            this.log.debug("eseguo query per routing table : " + DBUtils.formatSQLString(sqlQuery, new Object[0]));
            stm = con.prepareStatement(sqlQuery);
            rs = stm.executeQuery();
            String tipo = null;
            String nome = null;
            String tipoRotta = null;
            String tiposoggrotta = null;
            String nomesoggrotta = null;
            long id_registrorotta = 0L;
            boolean is_default = false;
            long idR = 0L;
            RoutingTableDefault rtdefault = null;
            Route route = null;
            RouteGateway routeGateway = null;
            RouteRegistro routeRegistro = null;
            RoutingTableDestinazione rtd = null;
            int nroute = 0;
            this.log.debug("Check esistenza rotte....");
            while (rs.next()) {
                this.log.debug("Nuova rotta....[" + rs.getInt("is_default") + "]");
                ++nroute;
                route = new Route();
                idR = rs.getLong("id");
                tipo = rs.getString("tipo");
                nome = rs.getString("nome");
                tipoRotta = rs.getString("tiporotta");
                nomesoggrotta = rs.getString("nomesoggrotta");
                tiposoggrotta = rs.getString("tiposoggrotta");
                id_registrorotta = rs.getLong("registrorotta");
                is_default = rs.getInt("is_default") == 1;
                if (tipoRotta.equalsIgnoreCase("registro")) {
                    routeRegistro = new RouteRegistro();
                    if (id_registrorotta != 0L) {
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                        sqlQueryObject.addFromTable("registri");
                        sqlQueryObject.addSelectField("*");
                        sqlQueryObject.addWhereCondition("id = ?");
                        sqlQuery = sqlQueryObject.createSQLQuery();
                        stmSearch = con.prepareStatement(sqlQuery);
                        stmSearch.setLong(1, id_registrorotta);
                        this.log.debug("eseguo query : " + DBUtils.formatSQLString(sqlQuery, id_registrorotta));
                        rsSearch = stmSearch.executeQuery();
                        if (rsSearch.next()) {
                            routeRegistro.setNome(rsSearch.getString("nome"));
                        }
                        rsSearch.close();
                        stmSearch.close();
                    }
                    route.setRegistro(routeRegistro);
                } else if (tipoRotta.equalsIgnoreCase("gateway")) {
                    routeGateway = new RouteGateway();
                    routeGateway.setNome(nomesoggrotta);
                    routeGateway.setTipo(tiposoggrotta);
                    route.setGateway(routeGateway);
                }
                route.setId(idR);
                if (is_default) {
                    if (rtdefault == null) {
                        rtdefault = new RoutingTableDefault();
                        rt.setDefault(rtdefault);
                    }
                    rt.getDefault().addRoute(route);
                    continue;
                }
                rtd = new RoutingTableDestinazione();
                rtd.setNome(nome);
                rtd.setTipo(tipo);
                rtd.addRoute(route);
                rt.addDestinazione(rtd);
            }
            this.log.debug("Ci sono " + nroute + " rotte configurate.");
            rs.close();
            stm.close();
            RoutingTable routingTable = rt;
            return routingTable;
        }
        catch (SQLException se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getRoutingTable] SqlException: " + se.getMessage(), se);
        }
        catch (Exception se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getRoutingTable] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (rsSearch != null) {
                    rsSearch.close();
                }
                if (stmSearch != null) {
                    stmSearch.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void createRoutingTable(RoutingTable routingTable) throws DriverConfigurazioneException {
        if (routingTable == null || routingTable.getDefault() == null || routingTable.getDefault().sizeRouteList() == 0) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::createRoutingTable] Parametri non validi.");
        }
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("createRoutingTable");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::createRoutingTable] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            this.log.debug("CRUDRoutingTable type = 1");
            DriverConfigurazioneDB_LIB.CRUDRoutingTable(1, routingTable, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::createRoutingTable] Errore durante la creazione della RoutingTable : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void updateRoutingTable(RoutingTable routingTable) throws DriverConfigurazioneException {
        if (routingTable == null || routingTable.getDefault() == null || routingTable.getDefault().sizeRouteList() == 0) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::updateRoutingTable] Parametri non validi.");
        }
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("updateRoutingTable");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::createRoutingTable] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            this.log.debug("CRUDRoutingTable type = 2");
            DriverConfigurazioneDB_LIB.CRUDRoutingTable(2, routingTable, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::updateRoutingTable] Errore durante la update della RoutingTable : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void deleteRoutingTable(RoutingTable routingTable) throws DriverConfigurazioneException {
        if (routingTable == null) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::deleteRoutingTable] Parametri non validi.");
        }
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("deleteRoutingTable");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::deleteRoutingTable] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            this.log.debug("CRUDRoutingTable type = 3");
            DriverConfigurazioneDB_LIB.CRUDRoutingTable(3, routingTable, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::deleteRoutingTable] Errore durante la delete della RoutingTable : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<RoutingTableDestinazione> routingList(ISearch ricerca) throws DriverConfigurazioneException {
        String nomeMetodo = "routingList";
        int idLista = 49;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        boolean error = false;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<RoutingTableDestinazione> lista = new ArrayList<RoutingTableDestinazione>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("routingList");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("routing");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("is_default = 0");
                sqlQueryObject.addWhereCondition(false, sqlQueryObject.getWhereLikeCondition("tipo", search, true, true), sqlQueryObject.getWhereLikeCondition("nome", search, true, true));
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("routing");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("is_default = 0");
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("routing");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("tipo");
                sqlQueryObject.addSelectField("tiporotta");
                sqlQueryObject.addSelectField("is_default");
                sqlQueryObject.addWhereCondition("is_default = 0");
                sqlQueryObject.addWhereCondition(false, sqlQueryObject.getWhereLikeCondition("tipo", search, true, true), sqlQueryObject.getWhereLikeCondition("nome", search, true, true));
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("tipo");
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("routing");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("tipo");
                sqlQueryObject.addSelectField("tiporotta");
                sqlQueryObject.addSelectField("is_default");
                sqlQueryObject.addWhereCondition("is_default = 0");
                sqlQueryObject.addOrderBy("tipo");
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                RoutingTableDestinazione rtd = new RoutingTableDestinazione();
                rtd.setId(risultato.getLong("id"));
                rtd.setNome(risultato.getString("nome"));
                rtd.setTipo(risultato.getString("tipo"));
                Route tmpR = new Route();
                if ("gateway".equals(risultato.getString("tiporotta"))) {
                    RouteGateway rg = new RouteGateway();
                    tmpR.setGateway(rg);
                } else {
                    RouteRegistro rr = new RouteRegistro();
                    tmpR.setRegistro(rr);
                }
                rtd.addRoute(tmpR);
                lista.add(rtd);
            }
            ArrayList<RoutingTableDestinazione> arrayList = lista;
            return arrayList;
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public AccessoRegistro getAccessoRegistro() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        String sqlQuery = "";
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("getAccessoRegistro");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getAccessoRegistro] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            AccessoRegistro car = new AccessoRegistro();
            Cache cache = null;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("registri");
            sqlQueryObject.addSelectField("*");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            rs = stm.executeQuery();
            AccessoRegistroRegistro itemcar = null;
            while (rs.next()) {
                itemcar = new AccessoRegistroRegistro();
                RegistroTipo tipoReg = CostantiConfigurazione.REGISTRO_XML;
                String tmpTipo = rs.getString("tipo");
                if (tmpTipo.equals("uddi")) {
                    tipoReg = CostantiConfigurazione.REGISTRO_UDDI;
                } else if (tmpTipo.equals("web")) {
                    tipoReg = CostantiConfigurazione.REGISTRO_WEB;
                } else if (tmpTipo.equals("db")) {
                    tipoReg = CostantiConfigurazione.REGISTRO_DB;
                } else if (tmpTipo.equals("ws")) {
                    tipoReg = CostantiConfigurazione.REGISTRO_WS;
                }
                itemcar.setTipo(tipoReg);
                itemcar.setNome(rs.getString("nome"));
                itemcar.setLocation(rs.getString("location"));
                String tmpUser = rs.getString("utente");
                String tmpPw = rs.getString("password");
                if (tmpUser != null && tmpPw != null && !tmpUser.equals("") && !tmpPw.equals("")) {
                    itemcar.setUser(tmpUser);
                    itemcar.setPassword(tmpPw);
                }
                car.addRegistro(itemcar);
            }
            rs.close();
            stm.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("configurazione");
            sqlQueryObject.addSelectField("*");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            this.log.debug("eseguo query : " + sqlQuery);
            rs = stm.executeQuery();
            if (rs.next()) {
                String tmpCache = rs.getString("statocache");
                if (CostantiConfigurazione.ABILITATO.equals(tmpCache)) {
                    String tmpAlg;
                    cache = new Cache();
                    String tmpDim = rs.getString("dimensionecache");
                    if (tmpDim != null && !tmpDim.equals("")) {
                        cache.setDimensione(tmpDim);
                    }
                    if ((tmpAlg = rs.getString("algoritmocache")).equalsIgnoreCase("LRU")) {
                        cache.setAlgoritmo(CostantiConfigurazione.CACHE_LRU);
                    } else {
                        cache.setAlgoritmo(CostantiConfigurazione.CACHE_MRU);
                    }
                    String tmpIdle = rs.getString("idlecache");
                    String tmpLife = rs.getString("lifecache");
                    if (tmpIdle != null && !tmpIdle.equals("")) {
                        cache.setItemIdleTime(tmpIdle);
                    }
                    if (tmpLife != null && !tmpLife.equals("")) {
                        cache.setItemLifeSecond(tmpLife);
                    }
                    car.setCache(cache);
                }
                rs.close();
                stm.close();
            }
            AccessoRegistro accessoRegistro = car;
            return accessoRegistro;
        }
        catch (SQLException se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getAccessoRegistro] SqlException: " + se.getMessage(), se);
        }
        catch (Exception se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getAccessoRegistro] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void createAccessoRegistro(AccessoRegistroRegistro registro) throws DriverConfigurazioneException {
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("createAccessoRegistro");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::createAccessoRegistro] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            this.log.debug("CRUDAccessoRegistro type = 1");
            DriverConfigurazioneDB_LIB.CRUDAccessoRegistro(1, registro, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::createAccessoRegistro] Errore durante la createAccessoRegistro : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void updateAccessoRegistro(AccessoRegistroRegistro registro) throws DriverConfigurazioneException {
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("updateAccessoRegistro");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::updateAccessoRegistro] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            this.log.debug("CRUDAccessoRegistro type = 2");
            DriverConfigurazioneDB_LIB.CRUDAccessoRegistro(2, registro, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::updateAccessoRegistro] Errore durante la updateAccessoRegistro : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void deleteAccessoRegistro(AccessoRegistroRegistro registro) throws DriverConfigurazioneException {
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("deleteAccessoRegistro");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::deleteAccessoRegistro] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            this.log.debug("CRUDAccessoRegistro type = 3");
            DriverConfigurazioneDB_LIB.CRUDAccessoRegistro(3, registro, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::deleteAccessoRegistro] Errore durante la deleteAccessoRegistro : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public AccessoConfigurazione getAccessoConfigurazione() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        String sqlQuery = "";
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("getAccessoConfigurazione");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getAccessoConfigurazione] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            AccessoConfigurazione accessoConfigurazione = new AccessoConfigurazione();
            Cache cache = null;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("configurazione");
            sqlQueryObject.addSelectField("*");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            this.log.debug("eseguo query : " + sqlQuery);
            rs = stm.executeQuery();
            if (rs.next()) {
                String tmpCache = rs.getString("config_statocache");
                if (CostantiConfigurazione.ABILITATO.equals(tmpCache)) {
                    String tmpAlg;
                    cache = new Cache();
                    String tmpDim = rs.getString("config_dimensionecache");
                    if (tmpDim != null && !tmpDim.equals("")) {
                        cache.setDimensione(tmpDim);
                    }
                    if ((tmpAlg = rs.getString("config_algoritmocache")).equalsIgnoreCase("LRU")) {
                        cache.setAlgoritmo(CostantiConfigurazione.CACHE_LRU);
                    } else {
                        cache.setAlgoritmo(CostantiConfigurazione.CACHE_MRU);
                    }
                    String tmpIdle = rs.getString("config_idlecache");
                    String tmpLife = rs.getString("config_lifecache");
                    if (tmpIdle != null && !tmpIdle.equals("")) {
                        cache.setItemIdleTime(tmpIdle);
                    }
                    if (tmpLife != null && !tmpLife.equals("")) {
                        cache.setItemLifeSecond(tmpLife);
                    }
                    accessoConfigurazione.setCache(cache);
                }
                rs.close();
                stm.close();
            }
            AccessoConfigurazione accessoConfigurazione2 = accessoConfigurazione;
            return accessoConfigurazione2;
        }
        catch (SQLException se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getAccessoConfigurazione] SqlException: " + se.getMessage(), se);
        }
        catch (Exception se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getAccessoConfigurazione] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void createAccessoConfigurazione(AccessoConfigurazione accessoConfigurazione) throws DriverConfigurazioneException {
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("createAccessoConfigurazione");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::createAccessoConfigurazione] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            this.log.debug("CRUDAccessoConfigurazione type = 1");
            DriverConfigurazioneDB_LIB.CRUDAccessoConfigurazione(1, accessoConfigurazione, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::createAccessoConfigurazione] Errore durante la createAccessoConfigurazione : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void updateAccessoConfigurazione(AccessoConfigurazione accessoConfigurazione) throws DriverConfigurazioneException {
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("updateAccessoConfigurazione");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::updateAccessoConfigurazione] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            this.log.debug("CRUDAccessoConfigurazione type = 2");
            DriverConfigurazioneDB_LIB.CRUDAccessoConfigurazione(2, accessoConfigurazione, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::updateAccessoConfigurazione] Errore durante la updateAccessoConfigurazione : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void deleteAccessoConfigurazione(AccessoConfigurazione accessoConfigurazione) throws DriverConfigurazioneException {
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("deleteAccessoConfigurazione");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::deleteAccessoConfigurazione] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            this.log.debug("CRUDAccessoConfigurazione type = 3");
            DriverConfigurazioneDB_LIB.CRUDAccessoConfigurazione(3, accessoConfigurazione, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::deleteAccessoConfigurazione] Errore durante la deleteAccessoConfigurazione : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public AccessoDatiAutorizzazione getAccessoDatiAutorizzazione() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        String sqlQuery = "";
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("getAccessoDatiAutorizzazione");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getAccessoDatiAutorizzazione] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            AccessoDatiAutorizzazione accessoDatiAutorizzazione = new AccessoDatiAutorizzazione();
            Cache cache = null;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("configurazione");
            sqlQueryObject.addSelectField("*");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            this.log.debug("eseguo query : " + sqlQuery);
            rs = stm.executeQuery();
            if (rs.next()) {
                String tmpCache = rs.getString("auth_statocache");
                if (CostantiConfigurazione.ABILITATO.equals(tmpCache)) {
                    String tmpAlg;
                    cache = new Cache();
                    String tmpDim = rs.getString("auth_dimensionecache");
                    if (tmpDim != null && !tmpDim.equals("")) {
                        cache.setDimensione(tmpDim);
                    }
                    if ((tmpAlg = rs.getString("auth_algoritmocache")).equalsIgnoreCase("LRU")) {
                        cache.setAlgoritmo(CostantiConfigurazione.CACHE_LRU);
                    } else {
                        cache.setAlgoritmo(CostantiConfigurazione.CACHE_MRU);
                    }
                    String tmpIdle = rs.getString("auth_idlecache");
                    String tmpLife = rs.getString("auth_lifecache");
                    if (tmpIdle != null && !tmpIdle.equals("")) {
                        cache.setItemIdleTime(tmpIdle);
                    }
                    if (tmpLife != null && !tmpLife.equals("")) {
                        cache.setItemLifeSecond(tmpLife);
                    }
                    accessoDatiAutorizzazione.setCache(cache);
                }
                rs.close();
                stm.close();
            }
            AccessoDatiAutorizzazione accessoDatiAutorizzazione2 = accessoDatiAutorizzazione;
            return accessoDatiAutorizzazione2;
        }
        catch (SQLException se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getAccessoDatiAutorizzazione] SqlException: " + se.getMessage(), se);
        }
        catch (Exception se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getAccessoDatiAutorizzazione] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public AccessoDatiAutenticazione getAccessoDatiAutenticazione() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        String sqlQuery = "";
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("getAccessoDatiAutenticazione");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getAccessoDatiAutenticazione] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            AccessoDatiAutenticazione accessoDatiAutenticazione = new AccessoDatiAutenticazione();
            Cache cache = null;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("configurazione");
            sqlQueryObject.addSelectField("*");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            this.log.debug("eseguo query : " + sqlQuery);
            rs = stm.executeQuery();
            if (rs.next()) {
                String tmpCache = rs.getString("authn_statocache");
                if (CostantiConfigurazione.ABILITATO.equals(tmpCache)) {
                    String tmpAlg;
                    cache = new Cache();
                    String tmpDim = rs.getString("authn_dimensionecache");
                    if (tmpDim != null && !tmpDim.equals("")) {
                        cache.setDimensione(tmpDim);
                    }
                    if ((tmpAlg = rs.getString("authn_algoritmocache")).equalsIgnoreCase("LRU")) {
                        cache.setAlgoritmo(CostantiConfigurazione.CACHE_LRU);
                    } else {
                        cache.setAlgoritmo(CostantiConfigurazione.CACHE_MRU);
                    }
                    String tmpIdle = rs.getString("authn_idlecache");
                    String tmpLife = rs.getString("authn_lifecache");
                    if (tmpIdle != null && !tmpIdle.equals("")) {
                        cache.setItemIdleTime(tmpIdle);
                    }
                    if (tmpLife != null && !tmpLife.equals("")) {
                        cache.setItemLifeSecond(tmpLife);
                    }
                    accessoDatiAutenticazione.setCache(cache);
                }
                rs.close();
                stm.close();
            }
            AccessoDatiAutenticazione accessoDatiAutenticazione2 = accessoDatiAutenticazione;
            return accessoDatiAutenticazione2;
        }
        catch (SQLException se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getAccessoDatiAutenticazione] SqlException: " + se.getMessage(), se);
        }
        catch (Exception se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getAccessoDatiAutenticazione] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void createAccessoDatiAutorizzazione(AccessoDatiAutorizzazione accessoDatiAutorizzazione) throws DriverConfigurazioneException {
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("createAccessoDatiAutorizzazione");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::createAccessoDatiAutorizzazione] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            this.log.debug("CRUDAccessoDatiAutorizzazione type = 1");
            DriverConfigurazioneDB_LIB.CRUDAccessoDatiAutorizzazione(1, accessoDatiAutorizzazione, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::createAccessoDatiAutorizzazione] Errore durante la createAccessoDatiAutorizzazione : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void updateAccessoDatiAutorizzazione(AccessoDatiAutorizzazione accessoDatiAutorizzazione) throws DriverConfigurazioneException {
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("updateAccessoDatiAutorizzazione");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::updateAccessoDatiAutorizzazione] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            this.log.debug("CRUDAccessoDatiAutorizzazione type = 2");
            DriverConfigurazioneDB_LIB.CRUDAccessoDatiAutorizzazione(2, accessoDatiAutorizzazione, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::updateAccessoDatiAutorizzazione] Errore durante la updateAccessoDatiAutorizzazione : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void deleteAccessoDatiAutorizzazione(AccessoDatiAutorizzazione accessoDatiAutorizzazione) throws DriverConfigurazioneException {
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("deleteAccessoDatiAutorizzazione");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::deleteAccessoDatiAutorizzazione] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            this.log.debug("CRUDAccessoDatiAutorizzazione type = 3");
            DriverConfigurazioneDB_LIB.CRUDAccessoDatiAutorizzazione(3, accessoDatiAutorizzazione, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::deleteAccessoDatiAutorizzazione] Errore durante la deleteAccessoDatiAutorizzazione : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public GestioneErrore getGestioneErroreComponenteCooperazione() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.getGestioneErrore(true);
    }

    @Override
    public GestioneErrore getGestioneErroreComponenteIntegrazione() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.getGestioneErrore(false);
    }

    private GestioneErrore getGestioneErrore(boolean cooperazione) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        String sqlQuery = "";
        String tipoOperazione = "GestioneErrore per componente di Cooperazione";
        if (!cooperazione) {
            tipoOperazione = "GestioneErrore per componente di Integrazione";
        }
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("getGestioneErrore(" + cooperazione + ")");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[" + tipoOperazione + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            Long idGestioneErrore;
            GestioneErrore gestioneErrore = null;
            String nomeColonna = "id_ge_cooperazione";
            if (!cooperazione) {
                nomeColonna = "id_ge_integrazione";
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("configurazione");
            sqlQueryObject.addSelectField(nomeColonna);
            sqlQuery = sqlQueryObject.createSQLQuery();
            this.log.debug("eseguo query: " + DBUtils.formatSQLString(sqlQuery, new Object[0]));
            stm = con.prepareStatement(sqlQuery);
            rs = stm.executeQuery();
            if (rs.next() && (idGestioneErrore = Long.valueOf(rs.getLong(nomeColonna))) > 0L) {
                gestioneErrore = DriverConfigurazioneDB_LIB.getGestioneErrore(idGestioneErrore, con);
            }
            rs.close();
            stm.close();
            if (gestioneErrore == null) {
                throw new DriverConfigurazioneNotFound(tipoOperazione + " non presente.");
            }
            GestioneErrore gestioneErrore2 = gestioneErrore;
            return gestioneErrore2;
        }
        catch (SQLException se) {
            throw new DriverConfigurazioneException(tipoOperazione + " SqlException: " + se.getMessage(), se);
        }
        catch (DriverConfigurazioneNotFound e) {
            throw new DriverConfigurazioneNotFound(e);
        }
        catch (Exception se) {
            throw new DriverConfigurazioneException(tipoOperazione + " Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public StatoServiziPdd getStatoServiziPdD() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        Statement stmFiltri = null;
        ResultSet rsFiltri = null;
        String sqlQuery = "";
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("getStatoServiziPdD");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[getServiziAttiviPdD] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            StatoServiziPdd servizi = null;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("servizi_pdd");
            sqlQuery = sqlQueryObject.createSQLQuery();
            ISQLQueryObject sqlQueryObjectFiltri = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObjectFiltri.addFromTable("servizi_pdd_filtri");
            sqlQueryObjectFiltri.addWhereCondition("id_servizio_pdd=?");
            String sqlQueryFiltro = sqlQueryObjectFiltri.createSQLQuery();
            this.log.debug("eseguo query: " + DBUtils.formatSQLString(sqlQuery, new Object[0]));
            stm = con.prepareStatement(sqlQuery);
            rs = stm.executeQuery();
            while (rs.next()) {
                if (servizi == null) {
                    servizi = new StatoServiziPdd();
                }
                long id = rs.getLong("id");
                String tipo = rs.getString("componente");
                int servizio = rs.getInt("stato");
                StatoFunzionalita stato = null;
                stato = servizio == 0 ? CostantiConfigurazione.DISABILITATO : (servizio == 1 ? CostantiConfigurazione.ABILITATO : CostantiConfigurazione.ABILITATO);
                if ("pd".equals(tipo)) {
                    StatoServiziPddPortaDelegata sPD = new StatoServiziPddPortaDelegata();
                    sPD.setStato(stato);
                    this.log.debug("eseguo query filtro: " + DBUtils.formatSQLString(sqlQueryFiltro, id));
                    stmFiltri = con.prepareStatement(sqlQueryFiltro);
                    stmFiltri.setLong(1, id);
                    rsFiltri = stmFiltri.executeQuery();
                    this.riempiFiltriServiziPdD(rsFiltri, sPD.getFiltroAbilitazioneList(), sPD.getFiltroDisabilitazioneList());
                    rsFiltri.close();
                    stmFiltri.close();
                    servizi.setPortaDelegata(sPD);
                    continue;
                }
                if ("pa".equals(tipo)) {
                    StatoServiziPddPortaApplicativa sPA = new StatoServiziPddPortaApplicativa();
                    sPA.setStato(stato);
                    this.log.debug("eseguo query filtro: " + DBUtils.formatSQLString(sqlQueryFiltro, id));
                    stmFiltri = con.prepareStatement(sqlQueryFiltro);
                    stmFiltri.setLong(1, id);
                    rsFiltri = stmFiltri.executeQuery();
                    this.riempiFiltriServiziPdD(rsFiltri, sPA.getFiltroAbilitazioneList(), sPA.getFiltroDisabilitazioneList());
                    rsFiltri.close();
                    stmFiltri.close();
                    servizi.setPortaApplicativa(sPA);
                    continue;
                }
                if (!"im".equals(tipo)) continue;
                StatoServiziPddIntegrationManager sIM = new StatoServiziPddIntegrationManager();
                sIM.setStato(stato);
                servizi.setIntegrationManager(sIM);
            }
            if (servizi == null) {
                throw new DriverConfigurazioneNotFound("Configurazione servizi attivi sulla PdD non presente");
            }
            rs.close();
            stm.close();
            StatoServiziPdd statoServiziPdd = servizi;
            return statoServiziPdd;
        }
        catch (SQLException se) {
            throw new DriverConfigurazioneException("[getServiziAttiviPdD]  SqlException: " + se.getMessage(), se);
        }
        catch (DriverConfigurazioneNotFound e) {
            throw new DriverConfigurazioneNotFound(e);
        }
        catch (Exception se) {
            throw new DriverConfigurazioneException("[getServiziAttiviPdD]  Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (rsFiltri != null) {
                    rsFiltri.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stmFiltri != null) {
                    stmFiltri.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private void riempiFiltriServiziPdD(ResultSet rsFiltri, List<TipoFiltroAbilitazioneServizi> listaAbilitazioni, List<TipoFiltroAbilitazioneServizi> listaDisabilitazioni) throws SQLException {
        while (rsFiltri.next()) {
            String tipo = rsFiltri.getString("tipo_filtro");
            TipoFiltroAbilitazioneServizi tipoFiltro = new TipoFiltroAbilitazioneServizi();
            String tipoSoggettoFruitore = rsFiltri.getString("tipo_soggetto_fruitore");
            tipoFiltro.setTipoSoggettoFruitore(tipoSoggettoFruitore);
            String soggettoFruitore = rsFiltri.getString("soggetto_fruitore");
            tipoFiltro.setSoggettoFruitore(soggettoFruitore);
            String identificativoPortaFruitore = rsFiltri.getString("identificativo_porta_fruitore");
            tipoFiltro.setIdentificativoPortaFruitore(identificativoPortaFruitore);
            String tipoSoggettoErogatore = rsFiltri.getString("tipo_soggetto_erogatore");
            tipoFiltro.setTipoSoggettoErogatore(tipoSoggettoErogatore);
            String soggettoErogatore = rsFiltri.getString("soggetto_erogatore");
            tipoFiltro.setSoggettoErogatore(soggettoErogatore);
            String identificativoPortaErogatore = rsFiltri.getString("identificativo_porta_erogatore");
            tipoFiltro.setIdentificativoPortaErogatore(identificativoPortaErogatore);
            String tipoServizio = rsFiltri.getString("tipo_servizio");
            tipoFiltro.setTipoServizio(tipoServizio);
            String servizio = rsFiltri.getString("servizio");
            tipoFiltro.setServizio(servizio);
            String azione = rsFiltri.getString("azione");
            tipoFiltro.setAzione(azione);
            if ("abilitazione".equals(tipo)) {
                listaAbilitazioni.add(tipoFiltro);
                continue;
            }
            listaDisabilitazioni.add(tipoFiltro);
        }
    }

    @Override
    public void createStatoServiziPdD(StatoServiziPdd servizi) throws DriverConfigurazioneException {
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("createStatoServiziPdD");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::createServiziAttiviPdD] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            this.log.debug("createServiziAttiviPdD type = 1");
            DriverConfigurazioneDB_LIB.CRUDServiziPdD(1, servizi, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::createServiziAttiviPdD] Errore durante la createServiziAttiviPdD : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void updateStatoServiziPdD(StatoServiziPdd servizi) throws DriverConfigurazioneException {
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("updateStatoServiziPdD");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::updateServiziAttiviPdD] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            this.log.debug("createServiziAttiviPdD type = 2");
            DriverConfigurazioneDB_LIB.CRUDServiziPdD(2, servizi, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::updateServiziAttiviPdD] Errore durante la updateServiziAttiviPdD : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void deleteStatoServiziPdD(StatoServiziPdd servizi) throws DriverConfigurazioneException {
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("deleteStatoServiziPdD");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::deleteServiziAttiviPdD] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            this.log.debug("createServiziAttiviPdD type = 3");
            DriverConfigurazioneDB_LIB.CRUDServiziPdD(3, servizi, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::deleteServiziAttiviPdD] Errore durante la deleteServiziAttiviPdD : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<Property> systemPropertyList(ISearch ricerca) throws DriverConfigurazioneException {
        String nomeMetodo = "systemPropertyList";
        int idLista = 50;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        boolean error = false;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<Property> lista = new ArrayList<Property>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("systemPropertyList");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("pdd_sys_props");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("pdd_sys_props");
                sqlQueryObject.addSelectCountField("*", "cont");
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("pdd_sys_props");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("valore");
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("pdd_sys_props");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("valore");
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                Property sp = new Property();
                sp.setId(risultato.getLong("id"));
                sp.setNome(risultato.getString("nome"));
                sp.setValore(risultato.getString("valore"));
                lista.add(sp);
            }
            ArrayList<Property> arrayList = lista;
            return arrayList;
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public SystemProperties getSystemPropertiesPdD() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        String sqlQuery = "";
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("getSystemPropertiesPdD");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[getSystemPropertiesPdD] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            SystemProperties systemProperties = null;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("pdd_sys_props");
            sqlQuery = sqlQueryObject.createSQLQuery();
            this.log.debug("eseguo query: " + DBUtils.formatSQLString(sqlQuery, new Object[0]));
            stm = con.prepareStatement(sqlQuery);
            rs = stm.executeQuery();
            while (rs.next()) {
                if (systemProperties == null) {
                    systemProperties = new SystemProperties();
                }
                long id = rs.getLong("id");
                String nome = rs.getString("nome");
                String valore = rs.getString("valore");
                Property sp = new Property();
                sp.setNome(nome);
                sp.setValore(valore);
                sp.setId(id);
                systemProperties.addSystemProperty(sp);
            }
            if (systemProperties == null) {
                throw new DriverConfigurazioneNotFound("System Properties non presenti");
            }
            rs.close();
            stm.close();
            SystemProperties systemProperties2 = systemProperties;
            return systemProperties2;
        }
        catch (SQLException se) {
            throw new DriverConfigurazioneException("[getSystemPropertiesPdD]  SqlException: " + se.getMessage(), se);
        }
        catch (DriverConfigurazioneNotFound e) {
            throw new DriverConfigurazioneNotFound(e);
        }
        catch (Exception se) {
            throw new DriverConfigurazioneException("[getSystemPropertiesPdD]  Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void createSystemPropertiesPdD(SystemProperties systemProperties) throws DriverConfigurazioneException {
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("createSystemPropertiesPdD");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::createServiziAttiviPdD] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            this.log.debug("createSystemPropertiesPdD type = 1");
            DriverConfigurazioneDB_LIB.CRUDSystemPropertiesPdD(1, systemProperties, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::createSystemPropertiesPdD] Errore durante la createSystemPropertiesPdD : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void updateSystemPropertiesPdD(SystemProperties systemProperties) throws DriverConfigurazioneException {
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("updateSystemPropertiesPdD");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::updateSystemPropertiesPdD] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            this.log.debug("updateSystemPropertiesPdD type = 2");
            DriverConfigurazioneDB_LIB.CRUDSystemPropertiesPdD(2, systemProperties, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::updateSystemPropertiesPdD] Errore durante la updateSystemPropertiesPdD : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void deleteSystemPropertiesPdD(SystemProperties systemProperties) throws DriverConfigurazioneException {
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("deleteSystemPropertiesPdD");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::deleteSystemPropertiesPdD] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            this.log.debug("deleteSystemPropertiesPdD type = 3");
            DriverConfigurazioneDB_LIB.CRUDSystemPropertiesPdD(3, systemProperties, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::deleteSystemPropertiesPdD] Errore durante la deleteSystemPropertiesPdD : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public Configurazione getConfigurazioneGenerale() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        GestioneErrore ge2;
        Configurazione config;
        block65: {
            Connection con = null;
            Statement stm = null;
            ResultSet rs = null;
            Statement stm1 = null;
            ResultSet rs1 = null;
            Statement stm2 = null;
            ResultSet rs2 = null;
            String sqlQuery = "";
            if (this.atomica) {
                try {
                    con = this.getConnectionFromDatasource("getConfigurazioneGenerale");
                }
                catch (Exception e) {
                    throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getConfigurazioneGenerale] Exception accedendo al datasource :" + e.getMessage(), e);
                }
            } else {
                con = this.globalConnection;
            }
            this.log.debug("operazione this.atomica = " + this.atomica);
            config = new Configurazione();
            try {
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("configurazione");
                sqlQueryObject.addSelectField("*");
                sqlQuery = sqlQueryObject.createSQLQuery();
                this.log.debug("eseguo query: " + DBUtils.formatSQLString(sqlQuery, new Object[0]));
                stm = con.prepareStatement(sqlQuery);
                rs = stm.executeQuery();
                if (rs.next()) {
                    List<Object> list;
                    Attachments attachments = new Attachments();
                    attachments.setGestioneManifest(DriverConfigurazioneDB_LIB.getEnumStatoFunzionalita(rs.getString("gestione_manifest")));
                    config.setAttachments(attachments);
                    IndirizzoRisposta indirizzoRisposta = new IndirizzoRisposta();
                    indirizzoRisposta.setUtilizzo(DriverConfigurazioneDB_LIB.getEnumStatoFunzionalita(rs.getString("indirizzo_telematico")));
                    config.setIndirizzoRisposta(indirizzoRisposta);
                    String cadenza_inoltro = rs.getString("cadenza_inoltro");
                    InoltroBusteNonRiscontrate inoltroBusteNonRiscontrate = new InoltroBusteNonRiscontrate();
                    inoltroBusteNonRiscontrate.setCadenza(cadenza_inoltro);
                    config.setInoltroBusteNonRiscontrate(inoltroBusteNonRiscontrate);
                    String autenticazione = rs.getString("auth_integration_manager");
                    IntegrationManager integrationManager = new IntegrationManager();
                    integrationManager.setAutenticazione(autenticazione);
                    config.setIntegrationManager(integrationManager);
                    boolean routingEnabled = false;
                    if (CostantiConfigurazione.ABILITATO.equals(DriverConfigurazioneDB_LIB.getEnumStatoFunzionalita(rs.getString("routing_enabled")))) {
                        routingEnabled = true;
                    }
                    RoutingTable rt = new RoutingTable();
                    rt.setAbilitata(routingEnabled);
                    config.setRoutingTable(rt);
                    String validazioneContenuti_stato = rs.getString("validazione_contenuti_stato");
                    String validazioneContenuti_tipo = rs.getString("validazione_contenuti_tipo");
                    String validazioneContenuti_acceptMtomMessage = rs.getString("validazione_contenuti_mtom");
                    if (validazioneContenuti_stato != null && !validazioneContenuti_stato.equals("") || validazioneContenuti_tipo != null && !validazioneContenuti_tipo.equals("") || validazioneContenuti_acceptMtomMessage != null && !validazioneContenuti_acceptMtomMessage.equals("")) {
                        ValidazioneContenutiApplicativi val = new ValidazioneContenutiApplicativi();
                        if (validazioneContenuti_stato != null && !validazioneContenuti_stato.equals("")) {
                            val.setStato(DriverConfigurazioneDB_LIB.getEnumStatoFunzionalitaConWarning(validazioneContenuti_stato));
                        }
                        if (validazioneContenuti_tipo != null && !validazioneContenuti_tipo.equals("")) {
                            val.setTipo(DriverConfigurazioneDB_LIB.getEnumValidazioneContenutiApplicativiTipo(validazioneContenuti_tipo));
                        }
                        if (validazioneContenuti_acceptMtomMessage != null && !validazioneContenuti_acceptMtomMessage.equals("")) {
                            val.setAcceptMtomMessage(DriverConfigurazioneDB_LIB.getEnumStatoFunzionalita(validazioneContenuti_acceptMtomMessage));
                        }
                        config.setValidazioneContenutiApplicativi(val);
                    }
                    String msg_diag_severita = rs.getString("msg_diag_severita");
                    String msg_diag_severita_log4j = rs.getString("msg_diag_severita_log4j");
                    MessaggiDiagnostici messaggiDiagnostici = new MessaggiDiagnostici();
                    messaggiDiagnostici.setSeveritaLog4j(DriverConfigurazioneDB_LIB.getEnumSeverita(msg_diag_severita_log4j));
                    messaggiDiagnostici.setSeverita(DriverConfigurazioneDB_LIB.getEnumSeverita(msg_diag_severita));
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                    sqlQueryObject.addFromTable("msgdiag_appender");
                    sqlQueryObject.addSelectField("*");
                    sqlQuery = sqlQueryObject.createSQLQuery();
                    stm1 = con.prepareStatement(sqlQuery);
                    rs1 = stm1.executeQuery();
                    while (rs1.next()) {
                        OpenspcoopAppender appender = new OpenspcoopAppender();
                        appender.setTipo(rs1.getString("tipo"));
                        long idAppender = rs1.getLong("id");
                        appender.setId(idAppender);
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                        sqlQueryObject.addFromTable("msgdiag_appender_prop");
                        sqlQueryObject.addSelectField("*");
                        sqlQueryObject.addWhereCondition("id_appender = ?");
                        sqlQuery = sqlQueryObject.createSQLQuery();
                        stm2 = con.prepareStatement(sqlQuery);
                        stm2.setLong(1, idAppender);
                        rs2 = stm2.executeQuery();
                        Property appender_prop = null;
                        while (rs2.next()) {
                            appender_prop = new Property();
                            appender_prop.setId(rs2.getLong("id"));
                            appender_prop.setNome(rs2.getString("nome"));
                            appender_prop.setValore(rs2.getString("valore"));
                            appender.addProperty(appender_prop);
                        }
                        rs2.close();
                        stm2.close();
                        messaggiDiagnostici.addOpenspcoopAppender(appender);
                    }
                    rs1.close();
                    stm1.close();
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                    sqlQueryObject.addFromTable("msgdiag_ds");
                    sqlQueryObject.addSelectField("*");
                    sqlQuery = sqlQueryObject.createSQLQuery();
                    stm1 = con.prepareStatement(sqlQuery);
                    rs1 = stm1.executeQuery();
                    while (rs1.next()) {
                        OpenspcoopSorgenteDati openspcoopDS = new OpenspcoopSorgenteDati();
                        openspcoopDS.setNome(rs1.getString("nome"));
                        openspcoopDS.setNomeJndi(rs1.getString("nome_jndi"));
                        openspcoopDS.setTipoDatabase(rs1.getString("tipo_database"));
                        long idDS = rs1.getLong("id");
                        openspcoopDS.setId(idDS);
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                        sqlQueryObject.addFromTable("msgdiag_ds_prop");
                        sqlQueryObject.addSelectField("*");
                        sqlQueryObject.addWhereCondition("id_prop = ?");
                        sqlQuery = sqlQueryObject.createSQLQuery();
                        stm2 = con.prepareStatement(sqlQuery);
                        stm2.setLong(1, idDS);
                        rs2 = stm2.executeQuery();
                        Property ds_prop = null;
                        while (rs2.next()) {
                            ds_prop = new Property();
                            ds_prop.setId(rs2.getLong("id"));
                            ds_prop.setNome(rs2.getString("nome"));
                            ds_prop.setValore(rs2.getString("valore"));
                            openspcoopDS.addProperty(ds_prop);
                        }
                        rs2.close();
                        stm2.close();
                        messaggiDiagnostici.addOpenspcoopSorgenteDati(openspcoopDS);
                    }
                    rs1.close();
                    stm1.close();
                    config.setMessaggiDiagnostici(messaggiDiagnostici);
                    String tracc_buste = rs.getString("tracciamento_buste");
                    String tracc_dump_applicativo = rs.getString("tracciamento_dump");
                    String tracc_dump_pd = rs.getString("tracciamento_dump_bin_pd");
                    String tracc_dump_pa = rs.getString("tracciamento_dump_bin_pa");
                    Tracciamento tracciamento = new Tracciamento();
                    tracciamento.setBuste(DriverConfigurazioneDB_LIB.getEnumStatoFunzionalita(tracc_buste));
                    tracciamento.setDump(DriverConfigurazioneDB_LIB.getEnumStatoFunzionalita(tracc_dump_applicativo));
                    tracciamento.setDumpBinarioPortaDelegata(DriverConfigurazioneDB_LIB.getEnumStatoFunzionalita(tracc_dump_pd));
                    if (tracciamento.getDumpBinarioPortaDelegata() == null) {
                        tracciamento.setDumpBinarioPortaDelegata(StatoFunzionalita.DISABILITATO);
                    }
                    tracciamento.setDumpBinarioPortaApplicativa(DriverConfigurazioneDB_LIB.getEnumStatoFunzionalita(tracc_dump_pa));
                    if (tracciamento.getDumpBinarioPortaApplicativa() == null) {
                        tracciamento.setDumpBinarioPortaApplicativa(StatoFunzionalita.DISABILITATO);
                    }
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                    sqlQueryObject.addFromTable("tracce_appender");
                    sqlQueryObject.addSelectField("*");
                    sqlQuery = sqlQueryObject.createSQLQuery();
                    stm1 = con.prepareStatement(sqlQuery);
                    rs1 = stm1.executeQuery();
                    while (rs1.next()) {
                        OpenspcoopAppender trac_appender = new OpenspcoopAppender();
                        trac_appender.setTipo(rs1.getString("tipo"));
                        long idAppenderTrac = rs1.getLong("id");
                        trac_appender.setId(idAppenderTrac);
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                        sqlQueryObject.addFromTable("tracce_appender_prop");
                        sqlQueryObject.addSelectField("*");
                        sqlQueryObject.addWhereCondition("id_appender = ?");
                        sqlQuery = sqlQueryObject.createSQLQuery();
                        stm2 = con.prepareStatement(sqlQuery);
                        stm2.setLong(1, idAppenderTrac);
                        rs2 = stm2.executeQuery();
                        Property trac_appender_prop = null;
                        while (rs2.next()) {
                            trac_appender_prop = new Property();
                            trac_appender_prop.setId(rs2.getLong("id"));
                            trac_appender_prop.setNome(rs2.getString("nome"));
                            trac_appender_prop.setValore(rs2.getString("valore"));
                            trac_appender.addProperty(trac_appender_prop);
                        }
                        rs2.close();
                        stm2.close();
                        tracciamento.addOpenspcoopAppender(trac_appender);
                    }
                    rs1.close();
                    stm1.close();
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                    sqlQueryObject.addFromTable("tracce_ds");
                    sqlQueryObject.addSelectField("*");
                    sqlQuery = sqlQueryObject.createSQLQuery();
                    stm1 = con.prepareStatement(sqlQuery);
                    rs1 = stm1.executeQuery();
                    while (rs1.next()) {
                        OpenspcoopSorgenteDati trac_ds = new OpenspcoopSorgenteDati();
                        trac_ds.setNome(rs1.getString("nome"));
                        trac_ds.setNomeJndi(rs1.getString("nome_jndi"));
                        trac_ds.setTipoDatabase(rs1.getString("tipo_database"));
                        long idDsTrac = rs1.getLong("id");
                        trac_ds.setId(idDsTrac);
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                        sqlQueryObject.addFromTable("tracce_ds_prop");
                        sqlQueryObject.addSelectField("*");
                        sqlQueryObject.addWhereCondition("id_prop = ?");
                        sqlQuery = sqlQueryObject.createSQLQuery();
                        stm2 = con.prepareStatement(sqlQuery);
                        stm2.setLong(1, idDsTrac);
                        rs2 = stm2.executeQuery();
                        Property trac_ds_prop = null;
                        while (rs2.next()) {
                            trac_ds_prop = new Property();
                            trac_ds_prop.setId(rs2.getLong("id"));
                            trac_ds_prop.setNome(rs2.getString("nome"));
                            trac_ds_prop.setValore(rs2.getString("valore"));
                            trac_ds.addProperty(trac_ds_prop);
                        }
                        rs2.close();
                        stm2.close();
                        tracciamento.addOpenspcoopSorgenteDati(trac_ds);
                    }
                    rs1.close();
                    stm1.close();
                    config.setTracciamento(tracciamento);
                    Risposte risposte = new Risposte();
                    risposte.setConnessione(DriverConfigurazioneDB_LIB.getEnumTipoConnessioneRisposte(rs.getString("mod_risposta")));
                    config.setRisposte(risposte);
                    String val_controllo = rs.getString("validazione_controllo");
                    String val_stato = rs.getString("validazione_stato");
                    String val_manifest = rs.getString("validazione_manifest");
                    String val_profilo = rs.getString("validazione_profilo");
                    ValidazioneBuste validazioneBuste = new ValidazioneBuste();
                    validazioneBuste.setControllo(DriverConfigurazioneDB_LIB.getEnumValidazioneBusteTipoControllo(val_controllo));
                    validazioneBuste.setManifestAttachments(DriverConfigurazioneDB_LIB.getEnumStatoFunzionalita(val_manifest));
                    validazioneBuste.setProfiloCollaborazione(DriverConfigurazioneDB_LIB.getEnumStatoFunzionalita(val_profilo));
                    validazioneBuste.setStato(DriverConfigurazioneDB_LIB.getEnumStatoFunzionalitaConWarning(val_stato));
                    config.setValidazioneBuste(validazioneBuste);
                    ExtendedInfoManager extInfoManager = ExtendedInfoManager.getInstance();
                    IExtendedInfo extInfoConfigurazioneDriver = extInfoManager.newInstanceExtendedInfoConfigurazione();
                    if (extInfoConfigurazioneDriver != null && (list = extInfoConfigurazioneDriver.getAllExtendedInfo(con, this.log, config)) != null && list.size() > 0) {
                        config.setExtendedInfoList(list);
                    }
                    break block65;
                }
                throw new DriverConfigurazioneNotFound("[DriverConfigurazioneDB::getConfigurazioneGenerale] Configurazione non presente.");
            }
            catch (DriverConfigurazioneNotFound e) {
                throw e;
            }
            catch (Exception se) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getConfigurazioneGenerale] Exception: " + se.getMessage(), se);
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stm != null) {
                        stm.close();
                    }
                    if (rs1 != null) {
                        rs1.close();
                    }
                    if (stm1 != null) {
                        stm1.close();
                    }
                    if (rs2 != null) {
                        rs2.close();
                    }
                    if (stm2 != null) {
                        stm2.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (this.atomica) {
                        this.log.debug("rilascio connessioni al db...");
                        con.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        ConfigurazioneGestioneErrore cge = null;
        try {
            ge2 = this.getGestioneErroreComponenteIntegrazione();
            if (ge2 != null) {
                if (cge == null) {
                    cge = new ConfigurazioneGestioneErrore();
                }
                cge.setComponenteIntegrazione(ge2);
            }
        }
        catch (Exception ge2) {
            // empty catch block
        }
        try {
            ge2 = this.getGestioneErroreComponenteCooperazione();
            if (ge2 != null) {
                if (cge == null) {
                    cge = new ConfigurazioneGestioneErrore();
                }
                cge.setComponenteCooperazione(ge2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (cge != null) {
            config.setGestioneErrore(cge);
        }
        try {
            config.setAccessoRegistro(this.getAccessoRegistro());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            config.setAccessoConfigurazione(this.getAccessoConfigurazione());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            config.setAccessoDatiAutorizzazione(this.getAccessoDatiAutorizzazione());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            config.setAccessoDatiAutenticazione(this.getAccessoDatiAutenticazione());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            config.setRoutingTable(this.getRoutingTable());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            config.setStatoServiziPdd(this.getStatoServiziPdD());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            config.setSystemProperties(this.getSystemPropertiesPdD());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return config;
    }

    public Object getConfigurazioneExtended(Configurazione config, String idExtendedConfiguration) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        Connection con = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getConfigurazioneExtended] SQLException accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            this.log.debug("getConfigurazioneExtended(" + idExtendedConfiguration + ")");
            ExtendedInfoManager extInfoManager = ExtendedInfoManager.getInstance();
            IExtendedInfo extInfoConfigurazioneDriver = extInfoManager.newInstanceExtendedInfoConfigurazione();
            if (extInfoConfigurazioneDriver != null) {
                Object o = extInfoConfigurazioneDriver.getExtendedInfo(con, this.log, config, idExtendedConfiguration);
                if (o == null) {
                    throw new DriverConfigurazioneNotFound("Oggetto non esistente");
                }
                Object object = o;
                return object;
            }
            try {
                throw new DriverConfigurazioneException("Driver non inizializzato");
            }
            catch (DriverConfigurazioneNotFound dNot) {
                throw dNot;
            }
            catch (Exception qe) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getConfigurazioneExtended] Errore: " + qe.getMessage(), qe);
            }
        }
        finally {
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void createConfigurazione(Configurazione configurazione) throws DriverConfigurazioneException {
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("createConfigurazione");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::createConfigurazioneGenerale] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            this.log.debug("CRUDConfigurazioneGenerale type = 1");
            DriverConfigurazioneDB_LIB.CRUDConfigurazioneGenerale(1, configurazione, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::createConfigurazioneGenerale] Errore durante la create ConfigurazioneGenerale : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void updateConfigurazione(Configurazione configurazione) throws DriverConfigurazioneException {
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("updateConfigurazione");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::updateConfigurazioneGenerale] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            this.log.debug("CRUDConfigurazioneGenerale type = 2");
            DriverConfigurazioneDB_LIB.CRUDConfigurazioneGenerale(2, configurazione, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::updateConfigurazioneGenerale] Errore durante la update ConfigurazioneGenerale : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void deleteConfigurazione(Configurazione configurazione) throws DriverConfigurazioneException {
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("deleteConfigurazione");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::deleteConfigurazioneGenerale] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            this.log.debug("CRUDConfigurazioneGenerale type = 3");
            DriverConfigurazioneDB_LIB.CRUDConfigurazioneGenerale(3, configurazione, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::deleteConfigurazioneGenerale] Errore durante la delete ConfigurazioneGenerale : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void createAccessoRegistro(AccessoRegistro registro) throws DriverConfigurazioneException {
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("createAccessoRegistro");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::createAccessoRegistro] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            this.log.debug("CRUDAccessoRegistro type = 1");
            DriverConfigurazioneDB_LIB.CRUDAccessoRegistro(1, registro, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::createAccessoRegistro] Errore durante la updateAccessoRegistro : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void updateAccessoRegistro(AccessoRegistro registro) throws DriverConfigurazioneException {
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("updateAccessoRegistro");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::updateAccessoRegistro] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            this.log.debug("CRUDAccessoRegistro type = 2");
            DriverConfigurazioneDB_LIB.CRUDAccessoRegistro(2, registro, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::updateAccessoRegistro] Errore durante la updateAccessoRegistro : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void deleteAccessoRegistro(AccessoRegistro registro) throws DriverConfigurazioneException {
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("deleteAccessoRegistro");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::deleteAccessoRegistro] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            this.log.debug("CRUDAccessoRegistro type = 3");
            DriverConfigurazioneDB_LIB.CRUDAccessoRegistro(3, registro, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::deleteAccessoRegistro] Errore durante la updateAccessoRegistro : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void createGestioneErroreComponenteCooperazione(GestioneErrore gestione) throws DriverConfigurazioneException {
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("createGestioneErroreComponenteCooperazione");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::createGestioneErroreComponenteCooperazione] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        Statement pstmt = null;
        try {
            this.log.debug("CRUDGestioneErrore type = 1");
            DriverConfigurazioneDB_LIB.CRUDGestioneErroreComponenteCooperazione(1, gestione, con);
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addUpdateTable("configurazione");
            sqlQueryObject.addUpdateField("id_ge_cooperazione", "?");
            String updateQuery = sqlQueryObject.createSQLUpdate();
            pstmt = con.prepareStatement(updateQuery);
            pstmt.setLong(1, gestione.getId());
            pstmt.execute();
            pstmt.close();
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::createGestioneErroreComponenteCooperazione] Errore: " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void updateGestioneErroreComponenteCooperazione(GestioneErrore gestione) throws DriverConfigurazioneException {
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("updateGestioneErroreComponenteCooperazione");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::updateGestioneErroreComponenteCooperazione] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            this.log.debug("CRUDGestioneErrore type = 2");
            DriverConfigurazioneDB_LIB.CRUDGestioneErroreComponenteCooperazione(2, gestione, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::updateGestioneErroreComponenteCooperazione] Errore: " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void deleteGestioneErroreComponenteCooperazione(GestioneErrore gestione) throws DriverConfigurazioneException {
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("deleteGestioneErroreComponenteCooperazione");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::deleteGestioneErroreComponenteCooperazione] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            this.log.debug("CRUDGestioneErrore type = 3");
            DriverConfigurazioneDB_LIB.CRUDGestioneErroreComponenteCooperazione(3, gestione, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::deleteGestioneErroreComponenteCooperazione] Errore: " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void createGestioneErroreComponenteIntegrazione(GestioneErrore gestione) throws DriverConfigurazioneException {
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("createGestioneErroreComponenteIntegrazione");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::createGestioneErroreComponenteIntegrazione] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        Statement pstmt = null;
        try {
            this.log.debug("CRUDGestioneErrore type = 1");
            DriverConfigurazioneDB_LIB.CRUDGestioneErroreComponenteIntegrazione(1, gestione, con);
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addUpdateTable("configurazione");
            sqlQueryObject.addUpdateField("id_ge_integrazione", "?");
            String updateQuery = sqlQueryObject.createSQLUpdate();
            pstmt = con.prepareStatement(updateQuery);
            pstmt.setLong(1, gestione.getId());
            pstmt.execute();
            pstmt.close();
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::createGestioneErroreComponenteIntegrazione] Errore: " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void updateGestioneErroreComponenteIntegrazione(GestioneErrore gestione) throws DriverConfigurazioneException {
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("updateGestioneErroreComponenteIntegrazione");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::updateGestioneErroreComponenteIntegrazione] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            this.log.debug("CRUDGestioneErrore type = 2");
            DriverConfigurazioneDB_LIB.CRUDGestioneErroreComponenteIntegrazione(2, gestione, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::updateGestioneErroreComponenteIntegrazione] Errore: " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void deleteGestioneErroreComponenteIntegrazione(GestioneErrore gestione) throws DriverConfigurazioneException {
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("deleteGestioneErroreComponenteIntegrazione");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::deleteGestioneErroreComponenteIntegrazione] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            this.log.debug("CRUDGestioneErrore type = 3");
            DriverConfigurazioneDB_LIB.CRUDGestioneErroreComponenteIntegrazione(3, gestione, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::deleteGestioneErroreComponenteIntegrazione] Errore: " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public List<PortaApplicativa> porteAppList(int idSoggetto, ISearch ricerca) throws DriverConfigurazioneException {
        int idLista = 5;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        boolean error = false;
        Statement stm = null;
        ResultSet rs = null;
        ArrayList<PortaApplicativa> lista = new ArrayList<PortaApplicativa>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("porteAppList");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::porteAppList] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("porte_applicative");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_soggetto = ?");
                sqlQueryObject.addWhereLikeCondition("nome_porta", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("porte_applicative");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_soggetto = ?");
                queryString = sqlQueryObject.createSQLQuery();
            }
            stm = con.prepareStatement(queryString);
            stm.setInt(1, idSoggetto);
            rs = stm.executeQuery();
            if (rs.next()) {
                ricerca.setNumEntries(idLista, rs.getInt(1));
            }
            rs.close();
            stm.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("porte_applicative");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("nome_porta");
                sqlQueryObject.addSelectField("descrizione");
                sqlQueryObject.addSelectField("ws_security");
                sqlQueryObject.addSelectField("id_soggetto");
                sqlQueryObject.addWhereCondition("id_soggetto = ?");
                sqlQueryObject.addWhereLikeCondition("nome_porta", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome_porta");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("porte_applicative");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("nome_porta");
                sqlQueryObject.addSelectField("descrizione");
                sqlQueryObject.addSelectField("ws_security");
                sqlQueryObject.addSelectField("id_soggetto");
                sqlQueryObject.addWhereCondition("id_soggetto = ?");
                sqlQueryObject.addOrderBy("nome_porta");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stm = con.prepareStatement(queryString);
            stm.setLong(1, idSoggetto);
            rs = stm.executeQuery();
            PortaApplicativa pa = null;
            while (rs.next()) {
                pa = this.getPortaApplicativa(rs.getLong("id"), con);
                lista.add(pa);
            }
            ArrayList<PortaApplicativa> arrayList = lista;
            return arrayList;
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::porteAppList] Errore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<PortaApplicativa> porteAppList(String superuser, ISearch ricerca) throws DriverConfigurazioneException {
        int idLista = 4;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        boolean error = false;
        Statement stm = null;
        ResultSet rs = null;
        ArrayList<PortaApplicativa> lista = new ArrayList<PortaApplicativa>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("porteAppList");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::porteAppList] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("porte_applicative");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_soggetto = soggetti.id");
                if (superuser != null && !"".equals(superuser)) {
                    sqlQueryObject.addWhereCondition("soggetti.superuser = ?");
                }
                sqlQueryObject.addWhereLikeCondition("nome_porta", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("porte_applicative");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_soggetto = soggetti.id");
                if (superuser != null && !"".equals(superuser)) {
                    sqlQueryObject.addWhereCondition("soggetti.superuser = ?");
                }
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stm = con.prepareStatement(queryString);
            if (superuser != null && !"".equals(superuser)) {
                stm.setString(1, superuser);
            }
            if ((rs = stm.executeQuery()).next()) {
                ricerca.setNumEntries(idLista, rs.getInt(1));
            }
            rs.close();
            stm.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("porte_applicative");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectField("porte_applicative.id");
                sqlQueryObject.addSelectField("nome_porta");
                sqlQueryObject.addWhereCondition("id_soggetto = soggetti.id");
                if (superuser != null && !"".equals(superuser)) {
                    sqlQueryObject.addWhereCondition("soggetti.superuser = ?");
                }
                sqlQueryObject.addWhereLikeCondition("nome_porta", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome_porta");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("porte_applicative");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectField("porte_applicative.id");
                sqlQueryObject.addSelectField("nome_porta");
                sqlQueryObject.addWhereCondition("id_soggetto = soggetti.id");
                if (superuser != null && !"".equals(superuser)) {
                    sqlQueryObject.addWhereCondition("soggetti.superuser = ?");
                }
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome_porta");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stm = con.prepareStatement(queryString);
            if (superuser != null && !"".equals(superuser)) {
                stm.setString(1, superuser);
            }
            rs = stm.executeQuery();
            PortaApplicativa pa = null;
            while (rs.next()) {
                pa = this.getPortaApplicativa(rs.getLong("id"), con);
                lista.add(pa);
            }
            ArrayList<PortaApplicativa> arrayList = lista;
            return arrayList;
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::porteAppList] Errore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public List<ProprietaProtocollo> porteAppPropList(int idPortaApplicativa, ISearch ricerca) throws DriverConfigurazioneException {
        int idLista = 6;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        boolean error = false;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<ProprietaProtocollo> lista = new ArrayList<ProprietaProtocollo>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("porteAppPropList");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::porteAppPropList] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("pa_properties");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("pa_properties");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setInt(1, idPortaApplicativa);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("pa_properties");
                sqlQueryObject.addSelectField("id_porta");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("valore");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("pa_properties");
                sqlQueryObject.addSelectField("id_porta");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("valore");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortaApplicativa);
            risultato = stmt.executeQuery();
            ProprietaProtocollo prop = null;
            while (risultato.next()) {
                prop = new ProprietaProtocollo();
                prop.setId(risultato.getLong("id_porta"));
                prop.setNome(risultato.getString("nome"));
                prop.setValore(risultato.getString("valore"));
                lista.add(prop);
            }
            ArrayList<ProprietaProtocollo> arrayList = lista;
            return arrayList;
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::porteAppPropList] Errore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public List<ServizioApplicativo> porteAppServizioApplicativoList(int idPortaApplicativa, ISearch ricerca) throws DriverConfigurazioneException {
        String nomeMetodo = "porteAppServizioApplicativoList";
        int idLista = 7;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        boolean error = false;
        Statement stmt = null;
        Statement stmt1 = null;
        ResultSet risultato = null;
        ArrayList<ServizioApplicativo> lista = new ArrayList<ServizioApplicativo>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("porteAppServizioApplicativoList");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("porte_applicative_sa");
                sqlQueryObject.addFromTable("servizi_applicativi");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addWhereCondition("porte_applicative_sa.id_servizio_applicativo=servizi_applicativi.id");
                sqlQueryObject.addWhereLikeCondition("servizi_applicativi.nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("porte_applicative_sa");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setInt(1, idPortaApplicativa);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("porte_applicative_sa");
                sqlQueryObject.addFromTable("servizi_applicativi");
                sqlQueryObject.addSelectField("id_servizio_applicativo");
                sqlQueryObject.addSelectField("id_porta");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addWhereCondition("porte_applicative_sa.id_servizio_applicativo=servizi_applicativi.id");
                sqlQueryObject.addWhereLikeCondition("servizi_applicativi.nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("id_servizio_applicativo");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("porte_applicative_sa");
                sqlQueryObject.addSelectField("id_servizio_applicativo");
                sqlQueryObject.addSelectField("id_porta");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addOrderBy("id_servizio_applicativo");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortaApplicativa);
            risultato = stmt.executeQuery();
            ServizioApplicativo sa = null;
            long idServizioApplicativo = 0L;
            while (risultato.next()) {
                idServizioApplicativo = risultato.getLong("id_servizio_applicativo");
                sa = new ServizioApplicativo();
                ISQLQueryObject sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject2.addFromTable("servizi_applicativi");
                sqlQueryObject2.addSelectField("*");
                sqlQueryObject2.addWhereCondition("id = ?");
                queryString = sqlQueryObject2.createSQLQuery();
                stmt1 = con.prepareStatement(queryString);
                stmt1.setLong(1, idServizioApplicativo);
                ResultSet rs1 = stmt1.executeQuery();
                if (!rs1.next()) {
                    throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore recuperando i dati del Servizio Applicativo.");
                }
                sa.setId(idServizioApplicativo);
                sa.setNome(rs1.getString("nome"));
                sa.setDescrizione(rs1.getString("descrizione"));
                sa.setIdSoggetto(rs1.getLong("id_soggetto"));
                rs1.close();
                stmt1.close();
                lista.add(sa);
            }
            risultato.close();
            stmt.close();
            ArrayList<ServizioApplicativo> arrayList = lista;
            return arrayList;
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (stmt1 != null) {
                    stmt1.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public List<MessageSecurityFlowParameter> porteAppMessageSecurityRequestList(int idPortaApplicativa, ISearch ricerca) throws DriverConfigurazioneException {
        String nomeMetodo = "porteAppMessageSecurityRequestList";
        int idLista = 8;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        boolean error = false;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<MessageSecurityFlowParameter> lista = new ArrayList<MessageSecurityFlowParameter>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("porteAppMessageSecurityRequestList");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("pa_ws_request");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("pa_ws_request");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setInt(1, idPortaApplicativa);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("pa_ws_request");
                sqlQueryObject.addSelectField("id_porta");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("valore");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("pa_ws_request");
                sqlQueryObject.addSelectField("id_porta");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("valore");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortaApplicativa);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                MessageSecurityFlowParameter wsreq = new MessageSecurityFlowParameter();
                wsreq.setId(risultato.getLong("id_porta"));
                wsreq.setNome(risultato.getString("nome"));
                wsreq.setValore(risultato.getString("valore"));
                lista.add(wsreq);
            }
            ArrayList<MessageSecurityFlowParameter> arrayList = lista;
            return arrayList;
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public List<MessageSecurityFlowParameter> porteAppMessageSecurityResponseList(int idPortaApplicativa, ISearch ricerca) throws DriverConfigurazioneException {
        String nomeMetodo = "porteAppMessageSecurityResponseList";
        int idLista = 9;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        boolean error = false;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<MessageSecurityFlowParameter> lista = new ArrayList<MessageSecurityFlowParameter>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("porteAppMessageSecurityResponseList");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("pa_ws_response");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("pa_ws_response");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortaApplicativa);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("pa_ws_response");
                sqlQueryObject.addSelectField("id_porta");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("valore");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("pa_ws_response");
                sqlQueryObject.addSelectField("id_porta");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("valore");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortaApplicativa);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                MessageSecurityFlowParameter wsresp = new MessageSecurityFlowParameter();
                wsresp.setId(risultato.getLong("id_porta"));
                wsresp.setNome(risultato.getString("nome"));
                wsresp.setValore(risultato.getString("valore"));
                lista.add(wsresp);
            }
            ArrayList<MessageSecurityFlowParameter> arrayList = lista;
            return arrayList;
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public List<PortaDelegata> porteDelegateList(int idSoggetto, ISearch ricerca) throws DriverConfigurazioneException {
        String nomeMetodo = "porteDelegateList";
        int idLista = 17;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        boolean error = false;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<PortaDelegata> lista = new ArrayList<PortaDelegata>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("porteDelegateList");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("porte_delegate");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_soggetto = ?");
                sqlQueryObject.addWhereLikeCondition("nome_porta", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("porte_delegate");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_soggetto = ?");
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setInt(1, idSoggetto);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("porte_delegate");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("nome_porta");
                sqlQueryObject.addSelectField("descrizione");
                sqlQueryObject.addSelectField("autenticazione");
                sqlQueryObject.addSelectField("autorizzazione");
                sqlQueryObject.addSelectField("ws_security");
                sqlQueryObject.addSelectField("id_soggetto");
                sqlQueryObject.addWhereCondition("id_soggetto = ?");
                sqlQueryObject.addWhereLikeCondition("nome_porta", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome_porta");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("porte_delegate");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("nome_porta");
                sqlQueryObject.addSelectField("descrizione");
                sqlQueryObject.addSelectField("autenticazione");
                sqlQueryObject.addSelectField("autorizzazione");
                sqlQueryObject.addSelectField("ws_security");
                sqlQueryObject.addSelectField("id_soggetto");
                sqlQueryObject.addWhereCondition("id_soggetto = ?");
                sqlQueryObject.addOrderBy("nome_porta");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idSoggetto);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                PortaDelegata pd = this.getPortaDelegata(risultato.getLong("id"), con);
                lista.add(pd);
            }
            ArrayList<PortaDelegata> arrayList = lista;
            return arrayList;
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<PortaDelegata> porteDelegateList(String superuser, ISearch ricerca) throws DriverConfigurazioneException {
        String nomeMetodo = "porteDelegateList";
        int idLista = 16;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        boolean error = false;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<PortaDelegata> lista = new ArrayList<PortaDelegata>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("porteDelegateList");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("porte_delegate");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_soggetto = soggetti.id");
                if (superuser != null && !"".equals(superuser)) {
                    sqlQueryObject.addWhereCondition("soggetti.superuser = ?");
                }
                sqlQueryObject.addWhereLikeCondition("nome_porta", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("porte_delegate");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_soggetto = soggetti.id");
                if (superuser != null && !"".equals(superuser)) {
                    sqlQueryObject.addWhereCondition("soggetti.superuser = ?");
                }
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            if (superuser != null && !"".equals(superuser)) {
                stmt.setString(1, superuser);
            }
            if ((risultato = stmt.executeQuery()).next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("porte_delegate");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectField("porte_delegate.id");
                sqlQueryObject.addSelectField("nome_porta");
                sqlQueryObject.addWhereCondition("id_soggetto = soggetti.id");
                if (superuser != null && !"".equals(superuser)) {
                    sqlQueryObject.addWhereCondition("soggetti.superuser = ?");
                }
                sqlQueryObject.addWhereLikeCondition("nome_porta", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome_porta");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("porte_delegate");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectField("porte_delegate.id");
                sqlQueryObject.addSelectField("nome_porta");
                sqlQueryObject.addWhereCondition("id_soggetto = soggetti.id");
                if (superuser != null && !"".equals(superuser)) {
                    sqlQueryObject.addWhereCondition("soggetti.superuser = ?");
                }
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome_porta");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            if (superuser != null && !"".equals(superuser)) {
                stmt.setString(1, superuser);
            }
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                PortaDelegata pd = this.getPortaDelegata(risultato.getLong("id"), con);
                lista.add(pd);
            }
            ArrayList<PortaDelegata> arrayList = lista;
            return arrayList;
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<PortaDelegata> porteDelegateWithLocationList(String location) throws DriverConfigurazioneException {
        String nomeMetodo = "porteDelegateWithLocationList";
        Connection con = null;
        boolean error = false;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<PortaDelegata> lista = new ArrayList<PortaDelegata>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("porteDelegateWithLocationList");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("porte_delegate");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("location = ?");
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setString(1, location);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                PortaDelegata pd = this.getPortaDelegata(risultato.getLong("id"), con);
                lista.add(pd);
            }
            ArrayList<PortaDelegata> arrayList = lista;
            return arrayList;
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<PortaDelegata> porteDelegateWithSoggettoErogatoreList(long idSoggettoErogatore) throws DriverConfigurazioneException {
        String nomeMetodo = "porteDelegateWithSoggettoErogatoreList";
        Connection con = null;
        boolean error = false;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<PortaDelegata> lista = new ArrayList<PortaDelegata>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("porteDelegateWithSoggettoErogatoreList");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("porte_delegate");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_soggetto_erogatore = ?");
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idSoggettoErogatore);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                PortaDelegata pd = this.getPortaDelegata(risultato.getLong("id"), con);
                lista.add(pd);
            }
            ArrayList<PortaDelegata> arrayList = lista;
            return arrayList;
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<PortaDelegata> porteDelegateWithTipoNomeErogatoreList(String tipoSoggettoErogatore, String nomeSoggettoErogatore) throws DriverConfigurazioneException {
        String nomeMetodo = "porteDelegateWithTipoNomeErogatoreList";
        Connection con = null;
        boolean error = false;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<PortaDelegata> lista = new ArrayList<PortaDelegata>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("porteDelegateWithTipoNomeErogatoreList");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("porte_delegate");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("tipo_soggetto_erogatore = ?");
            sqlQueryObject.addWhereCondition("nome_soggetto_erogatore = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setString(1, tipoSoggettoErogatore);
            stmt.setString(2, nomeSoggettoErogatore);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                PortaDelegata pd = this.getPortaDelegata(risultato.getLong("id"), con);
                lista.add(pd);
            }
            ArrayList<PortaDelegata> arrayList = lista;
            return arrayList;
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<PortaApplicativa> porteAppWithTipoNomeServizio(long idSoggettoErogatore, String tipoServizio, String nomeServizio) throws DriverConfigurazioneException {
        String nomeMetodo = "porteAppWithTipoNomeServizio";
        Connection con = null;
        boolean error = false;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<PortaApplicativa> lista = new ArrayList<PortaApplicativa>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("porteAppWithTipoNomeServizio");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("porte_applicative");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("tipo_servizio = ?");
            sqlQueryObject.addWhereCondition("servizio = ?");
            sqlQueryObject.addWhereCondition("id_soggetto = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setString(1, tipoServizio);
            stmt.setString(2, nomeServizio);
            stmt.setLong(3, idSoggettoErogatore);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                PortaApplicativa pa = this.getPortaApplicativa(risultato.getLong("id"), con);
                lista.add(pa);
            }
            ArrayList<PortaApplicativa> arrayList = lista;
            return arrayList;
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<PortaApplicativa> porteAppWithIdServizio(long idServizio) throws DriverConfigurazioneException {
        String nomeMetodo = "porteAppWithIdServizio";
        Connection con = null;
        boolean error = false;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<PortaApplicativa> lista = new ArrayList<PortaApplicativa>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("porteAppWithIdServizio");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("porte_applicative");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_servizio = ?");
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idServizio);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                PortaApplicativa pa = this.getPortaApplicativa(risultato.getLong("id"), con);
                lista.add(pa);
            }
            ArrayList<PortaApplicativa> arrayList = lista;
            return arrayList;
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public List<ServizioApplicativo> porteDelegateServizioApplicativoList(int idPortaDelegata, ISearch ricerca) throws DriverConfigurazioneException {
        String nomeMetodo = "porteDelegateServizioApplicativoList";
        int idLista = 18;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        boolean error = false;
        Statement stmt = null;
        Statement stmt1 = null;
        ResultSet risultato = null;
        ResultSet rs1 = null;
        ArrayList<ServizioApplicativo> lista = new ArrayList<ServizioApplicativo>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("porteDelegateServizioApplicativoList");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("porte_delegate_sa");
                sqlQueryObject.addFromTable("servizi_applicativi");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addWhereCondition("porte_delegate_sa.id_servizio_applicativo=servizi_applicativi.id");
                sqlQueryObject.addWhereLikeCondition("servizi_applicativi.nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("porte_delegate_sa");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortaDelegata);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("porte_delegate_sa");
                sqlQueryObject.addFromTable("servizi_applicativi");
                sqlQueryObject.addSelectField("porte_delegate_sa", "id_servizio_applicativo");
                sqlQueryObject.addSelectField("porte_delegate_sa", "id_porta");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addWhereCondition("porte_delegate_sa.id_servizio_applicativo=servizi_applicativi.id");
                sqlQueryObject.addWhereLikeCondition("servizi_applicativi.nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("id_servizio_applicativo");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("porte_delegate_sa");
                sqlQueryObject.addSelectField("id_servizio_applicativo");
                sqlQueryObject.addSelectField("id_porta");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addOrderBy("id_servizio_applicativo");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortaDelegata);
            risultato = stmt.executeQuery();
            ServizioApplicativo sa = null;
            long idServizioApplicativo = 0L;
            while (risultato.next()) {
                idServizioApplicativo = risultato.getLong("id_servizio_applicativo");
                sa = new ServizioApplicativo();
                ISQLQueryObject sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject2.addFromTable("servizi_applicativi");
                sqlQueryObject2.addSelectField("*");
                sqlQueryObject2.addWhereCondition("id = ?");
                queryString = sqlQueryObject2.createSQLQuery();
                stmt1 = con.prepareStatement(queryString);
                stmt1.setLong(1, idServizioApplicativo);
                rs1 = stmt1.executeQuery();
                if (!rs1.next()) {
                    throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore recuperando i dati del Servizio Applicativo.");
                }
                sa.setId(idServizioApplicativo);
                sa.setNome(rs1.getString("nome"));
                sa.setDescrizione(rs1.getString("descrizione"));
                sa.setIdSoggetto(rs1.getLong("id_soggetto"));
                rs1.close();
                stmt1.close();
                lista.add(sa);
            }
            ArrayList<ServizioApplicativo> arrayList = lista;
            return arrayList;
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (rs1 != null) {
                    rs1.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (stmt1 != null) {
                    stmt1.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public List<MessageSecurityFlowParameter> porteDelegateMessageSecurityRequestList(int idPortaDelegata, ISearch ricerca) throws DriverConfigurazioneException {
        String nomeMetodo = "porteDelegateMessageSecurityRequestList";
        int idLista = 19;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        boolean error = false;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<MessageSecurityFlowParameter> lista = new ArrayList<MessageSecurityFlowParameter>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("porteDelegateMessageSecurityRequestList");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("pd_ws_request");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("pd_ws_request");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setInt(1, idPortaDelegata);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("pd_ws_request");
                sqlQueryObject.addSelectField("id_porta");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("valore");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("pd_ws_request");
                sqlQueryObject.addSelectField("id_porta");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("valore");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortaDelegata);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                MessageSecurityFlowParameter wsreq = new MessageSecurityFlowParameter();
                wsreq.setId(risultato.getLong("id_porta"));
                wsreq.setNome(risultato.getString("nome"));
                wsreq.setValore(risultato.getString("valore"));
                lista.add(wsreq);
            }
            ArrayList<MessageSecurityFlowParameter> arrayList = lista;
            return arrayList;
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public List<MessageSecurityFlowParameter> porteDelegateMessageSecurityResponseList(int idPortaDelegata, ISearch ricerca) throws DriverConfigurazioneException {
        String nomeMetodo = "porteDelegateMessageSecurityResponseList";
        int idLista = 20;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        boolean error = false;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<MessageSecurityFlowParameter> lista = new ArrayList<MessageSecurityFlowParameter>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("porteDelegateMessageSecurityResponseList");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("pd_ws_response");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("pd_ws_response");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortaDelegata);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("pd_ws_response");
                sqlQueryObject.addSelectField("id_porta");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("valore");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("pd_ws_response");
                sqlQueryObject.addSelectField("id_porta");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("valore");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortaDelegata);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                MessageSecurityFlowParameter wsresp = new MessageSecurityFlowParameter();
                wsresp.setId(risultato.getLong("id_porta"));
                wsresp.setNome(risultato.getString("nome"));
                wsresp.setValore(risultato.getString("valore"));
                lista.add(wsresp);
            }
            ArrayList<MessageSecurityFlowParameter> arrayList = lista;
            return arrayList;
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<CorrelazioneApplicativaElemento> porteDelegateCorrelazioneApplicativaList(int idPortaDelegata, ISearch ricerca) throws DriverConfigurazioneException {
        String nomeMetodo = "porteDelegateCorrelazioneApplicativaList";
        int idLista = 21;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        boolean error = false;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<CorrelazioneApplicativaElemento> lista = new ArrayList<CorrelazioneApplicativaElemento>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("porteDelegateCorrelazioneApplicativaList");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("pd_correlazione");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addWhereLikeCondition("nome_elemento", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("pd_correlazione");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortaDelegata);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("pd_correlazione");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("nome_elemento");
                sqlQueryObject.addSelectField("mode_correlazione");
                sqlQueryObject.addSelectField("id_porta");
                sqlQueryObject.addSelectField("identificazione_fallita");
                sqlQueryObject.addSelectField("riuso_id");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addWhereLikeCondition("nome_elemento", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("id");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("pd_correlazione");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("nome_elemento");
                sqlQueryObject.addSelectField("mode_correlazione");
                sqlQueryObject.addSelectField("id_porta");
                sqlQueryObject.addSelectField("identificazione_fallita");
                sqlQueryObject.addSelectField("riuso_id");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addOrderBy("id");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortaDelegata);
            risultato = stmt.executeQuery();
            CorrelazioneApplicativaElemento cae = null;
            while (risultato.next()) {
                cae = new CorrelazioneApplicativaElemento();
                cae.setId(risultato.getLong("id"));
                cae.setNome(risultato.getString("nome_elemento"));
                cae.setIdentificazione(DriverConfigurazioneDB_LIB.getEnumCorrelazioneApplicativaRichiestaIdentificazione(risultato.getString("mode_correlazione")));
                cae.setIdentificazioneFallita(DriverConfigurazioneDB_LIB.getEnumCorrelazioneApplicativaGestioneIdentificazioneFallita(risultato.getString("identificazione_fallita")));
                cae.setRiusoIdentificativo(DriverConfigurazioneDB_LIB.getEnumStatoFunzionalita(risultato.getString("riuso_id")));
                lista.add(cae);
            }
            ArrayList<CorrelazioneApplicativaElemento> arrayList = lista;
            return arrayList;
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<CorrelazioneApplicativaRispostaElemento> porteDelegateCorrelazioneApplicativaRispostaList(int idPortaDelegata, ISearch ricerca) throws DriverConfigurazioneException {
        String nomeMetodo = "porteDelegateCorrelazioneApplicativaRispostaList";
        int idLista = 22;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        boolean error = false;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<CorrelazioneApplicativaRispostaElemento> lista = new ArrayList<CorrelazioneApplicativaRispostaElemento>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("porteDelegateCorrelazioneApplicativaRispostaList");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("pd_correlazione_risposta");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addWhereLikeCondition("nome_elemento", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("pd_correlazione_risposta");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortaDelegata);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("pd_correlazione_risposta");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("nome_elemento");
                sqlQueryObject.addSelectField("mode_correlazione");
                sqlQueryObject.addSelectField("id_porta");
                sqlQueryObject.addSelectField("identificazione_fallita");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addWhereLikeCondition("nome_elemento", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("id");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("pd_correlazione_risposta");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("nome_elemento");
                sqlQueryObject.addSelectField("mode_correlazione");
                sqlQueryObject.addSelectField("id_porta");
                sqlQueryObject.addSelectField("identificazione_fallita");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addOrderBy("id");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortaDelegata);
            risultato = stmt.executeQuery();
            CorrelazioneApplicativaRispostaElemento cae = null;
            while (risultato.next()) {
                cae = new CorrelazioneApplicativaRispostaElemento();
                cae.setId(risultato.getLong("id"));
                cae.setNome(risultato.getString("nome_elemento"));
                cae.setIdentificazione(DriverConfigurazioneDB_LIB.getEnumCorrelazioneApplicativaRispostaIdentificazione(risultato.getString("mode_correlazione")));
                cae.setIdentificazioneFallita(DriverConfigurazioneDB_LIB.getEnumCorrelazioneApplicativaGestioneIdentificazioneFallita(risultato.getString("identificazione_fallita")));
                lista.add(cae);
            }
            ArrayList<CorrelazioneApplicativaRispostaElemento> arrayList = lista;
            return arrayList;
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<CorrelazioneApplicativaElemento> porteApplicativeCorrelazioneApplicativaList(int idPortaApplicativa, ISearch ricerca) throws DriverConfigurazioneException {
        String nomeMetodo = "porteApplicativeCorrelazioneApplicativaList";
        int idLista = 10;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        boolean error = false;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<CorrelazioneApplicativaElemento> lista = new ArrayList<CorrelazioneApplicativaElemento>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("porteApplicativeCorrelazioneApplicativaList");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("pa_correlazione");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addWhereLikeCondition("nome_elemento", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("pa_correlazione");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortaApplicativa);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("pa_correlazione");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("nome_elemento");
                sqlQueryObject.addSelectField("mode_correlazione");
                sqlQueryObject.addSelectField("id_porta");
                sqlQueryObject.addSelectField("identificazione_fallita");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addWhereLikeCondition("nome_elemento", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("id");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("pa_correlazione");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("nome_elemento");
                sqlQueryObject.addSelectField("mode_correlazione");
                sqlQueryObject.addSelectField("id_porta");
                sqlQueryObject.addSelectField("identificazione_fallita");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addOrderBy("id");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortaApplicativa);
            risultato = stmt.executeQuery();
            CorrelazioneApplicativaElemento cae = null;
            while (risultato.next()) {
                cae = new CorrelazioneApplicativaElemento();
                cae.setId(risultato.getLong("id"));
                cae.setNome(risultato.getString("nome_elemento"));
                cae.setIdentificazione(DriverConfigurazioneDB_LIB.getEnumCorrelazioneApplicativaRichiestaIdentificazione(risultato.getString("mode_correlazione")));
                cae.setIdentificazioneFallita(DriverConfigurazioneDB_LIB.getEnumCorrelazioneApplicativaGestioneIdentificazioneFallita(risultato.getString("identificazione_fallita")));
                lista.add(cae);
            }
            ArrayList<CorrelazioneApplicativaElemento> arrayList = lista;
            return arrayList;
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<CorrelazioneApplicativaRispostaElemento> porteApplicativeCorrelazioneApplicativaRispostaList(int idPortaApplicativa, ISearch ricerca) throws DriverConfigurazioneException {
        String nomeMetodo = "porteApplicativeCorrelazioneApplicativaRispostaList";
        int idLista = 11;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        boolean error = false;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<CorrelazioneApplicativaRispostaElemento> lista = new ArrayList<CorrelazioneApplicativaRispostaElemento>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("porteApplicativeCorrelazioneApplicativaRispostaList");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("pa_correlazione_risposta");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addWhereLikeCondition("nome_elemento", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("pa_correlazione_risposta");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortaApplicativa);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("pa_correlazione_risposta");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("nome_elemento");
                sqlQueryObject.addSelectField("mode_correlazione");
                sqlQueryObject.addSelectField("id_porta");
                sqlQueryObject.addSelectField("identificazione_fallita");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addWhereLikeCondition("nome_elemento", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("id");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("pa_correlazione_risposta");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("nome_elemento");
                sqlQueryObject.addSelectField("mode_correlazione");
                sqlQueryObject.addSelectField("id_porta");
                sqlQueryObject.addSelectField("identificazione_fallita");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addOrderBy("id");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortaApplicativa);
            risultato = stmt.executeQuery();
            CorrelazioneApplicativaRispostaElemento cae = null;
            while (risultato.next()) {
                cae = new CorrelazioneApplicativaRispostaElemento();
                cae.setId(risultato.getLong("id"));
                cae.setNome(risultato.getString("nome_elemento"));
                cae.setIdentificazione(DriverConfigurazioneDB_LIB.getEnumCorrelazioneApplicativaRispostaIdentificazione(risultato.getString("mode_correlazione")));
                cae.setIdentificazioneFallita(DriverConfigurazioneDB_LIB.getEnumCorrelazioneApplicativaGestioneIdentificazioneFallita(risultato.getString("identificazione_fallita")));
                lista.add(cae);
            }
            ArrayList<CorrelazioneApplicativaRispostaElemento> arrayList = lista;
            return arrayList;
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public List<PortaApplicativa> getPorteApplicative(String nomePA, String tipoSoggettoProprietario, String nomeSoggettoProprietario) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (nomePA == null) {
            throw new DriverConfigurazioneException("[getPorteApplicative] Parametro nomePA Non Valido");
        }
        ArrayList<PortaApplicativa> lista = new ArrayList<PortaApplicativa>();
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        String nomeMetodo = "getPorteApplicative";
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("getPorteApplicative");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            boolean tipoSoggettoDefined = tipoSoggettoProprietario != null && !"".equals(tipoSoggettoProprietario);
            boolean nomeSoggettoDefined = nomeSoggettoProprietario != null && !"".equals(nomeSoggettoProprietario);
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("porte_applicative", "pa");
            if (tipoSoggettoDefined || nomeSoggettoDefined) {
                sqlQueryObject.addFromTable(this.tabellaSoggetti, "s");
            }
            sqlQueryObject.addSelectAliasField("pa", "id", "idPortaApplicativa");
            if (tipoSoggettoDefined || nomeSoggettoDefined) {
                sqlQueryObject.addWhereCondition("pa.id_soggetto = s.id");
            }
            sqlQueryObject.addWhereCondition("pa.nome_porta = ?");
            if (tipoSoggettoDefined) {
                sqlQueryObject.addWhereCondition("s.tipo_soggetto = ?");
            }
            if (nomeSoggettoDefined) {
                sqlQueryObject.addWhereCondition("s.nome_soggetto = ?");
            }
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            this.log.debug("Query [" + queryString + "] NOMEPA[" + nomePA + "] TIPOSOG[" + tipoSoggettoProprietario + "] NOMESOG[" + nomeSoggettoProprietario + "]");
            stmt = con.prepareStatement(queryString);
            int index = 1;
            stmt.setString(index++, nomePA);
            if (tipoSoggettoDefined) {
                stmt.setString(index++, tipoSoggettoProprietario);
            }
            if (nomeSoggettoDefined) {
                stmt.setString(index++, nomeSoggettoProprietario);
            }
            risultato = stmt.executeQuery();
            ArrayList<Long> listaId = new ArrayList<Long>();
            while (risultato.next()) {
                listaId.add(risultato.getLong("idPortaApplicativa"));
            }
            risultato.close();
            stmt.close();
            for (int i = 0; i < listaId.size(); ++i) {
                lista.add(this.getPortaApplicativa((Long)listaId.get(i), con));
            }
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
        if (lista.size() == 0) {
            throw new DriverConfigurazioneNotFound("[getPorteApplicative] Porte applicative non esistenti.");
        }
        return lista;
    }

    private List<ServizioApplicativo> servizioApplicativoList(ISearch ricerca, Long idProprietario) throws DriverConfigurazioneException {
        String nomeMetodo = "servizioApplicativoList";
        int idLista = 27;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        boolean error = false;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<ServizioApplicativo> lista = new ArrayList<ServizioApplicativo>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("servizioApplicativoList");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("servizi_applicativi");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                if (idProprietario != null) {
                    sqlQueryObject.addWhereCondition("servizi_applicativi.id_soggetto=?");
                }
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("servizi_applicativi");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addSelectCountField("*", "cont");
                if (idProprietario != null) {
                    sqlQueryObject.addWhereCondition("servizi_applicativi.id_soggetto=?");
                }
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            if (idProprietario != null) {
                stmt.setLong(1, idProprietario);
            }
            if ((risultato = stmt.executeQuery()).next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("servizi_applicativi");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                if (idProprietario != null) {
                    sqlQueryObject.addWhereCondition("servizi_applicativi.id_soggetto=?");
                }
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("servizi_applicativi");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("nome");
                if (idProprietario != null) {
                    sqlQueryObject.addWhereCondition("servizi_applicativi.id_soggetto=?");
                }
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            if (idProprietario != null) {
                stmt.setLong(1, idProprietario);
            }
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                ServizioApplicativo sa = this.getServizioApplicativo(risultato.getLong("id"));
                lista.add(sa);
            }
            ArrayList<ServizioApplicativo> arrayList = lista;
            return arrayList;
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public List<ServizioApplicativo> servizioApplicativoList(ISearch ricerca) throws DriverConfigurazioneException {
        return this.servizioApplicativoList(ricerca, null);
    }

    public List<ServizioApplicativo> servizioApplicativoList(IDSoggetto idSO, ISearch ricerca) throws DriverConfigurazioneException {
        String nomeMetodo = "servizioApplicativoList";
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("servizioApplicativoList(idSoggetto)");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            List<ServizioApplicativo> e = this.servizioApplicativoList(ricerca, DBUtils.getIdSoggetto(idSO.getNome(), idSO.getTipo(), con, this.tipoDB));
            return e;
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<ServizioApplicativo> servizioApplicativoWithCredenzialiBasicList(String utente, String password) throws DriverConfigurazioneException {
        String nomeMetodo = "servizioApplicativoWithCredenzialiBasicList";
        Connection con = null;
        boolean error = false;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<ServizioApplicativo> lista = new ArrayList<ServizioApplicativo>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource(nomeMetodo);
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("servizi_applicativi");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addSelectField("nome");
            sqlQueryObject.addSelectField("id_soggetto");
            sqlQueryObject.addWhereCondition("tipoauth = ?");
            sqlQueryObject.addWhereCondition("utente = ?");
            sqlQueryObject.addWhereCondition("password = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setString(1, CredenzialeTipo.BASIC.getValue());
            stmt.setString(2, utente);
            stmt.setString(3, password);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                ServizioApplicativo sa = this.getServizioApplicativo(risultato.getLong("id"));
                lista.add(sa);
            }
            ArrayList<ServizioApplicativo> arrayList = lista;
            return arrayList;
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<ServizioApplicativo> servizioApplicativoWithCredenzialiSslList(String subject) throws DriverConfigurazioneException {
        String nomeMetodo = "servizioApplicativoWithCredenzialiSslList";
        Connection con = null;
        boolean error = false;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<ServizioApplicativo> lista = new ArrayList<ServizioApplicativo>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource(nomeMetodo);
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            Hashtable<String, String> hashSubject = Utilities.getSubjectIntoHashtable(subject);
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("servizi_applicativi");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addSelectField("nome");
            sqlQueryObject.addSelectField("subject");
            sqlQueryObject.addSelectField("id_soggetto");
            sqlQueryObject.addWhereCondition("tipoauth = ?");
            Enumeration<String> keys = hashSubject.keys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                String value = hashSubject.get(key);
                sqlQueryObject.addWhereLikeCondition("subject", "/" + Utilities.formatKeySubject(key) + "=" + Utilities.formatValueSubject(value) + "/", true, false);
            }
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setString(1, CredenzialeTipo.SSL.getValue());
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                String subjectPotenziale = risultato.getString("subject");
                if (!Utilities.sslVerify(subjectPotenziale, subject, this.log)) continue;
                ServizioApplicativo sa = this.getServizioApplicativo(risultato.getLong("id"));
                lista.add(sa);
            }
            ArrayList<ServizioApplicativo> arrayList = lista;
            return arrayList;
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<ServizioApplicativo> servizioApplicativoWithCredenzialiPrincipalList(String principal) throws DriverConfigurazioneException {
        String nomeMetodo = "servizioApplicativoWithCredenzialiPrincipalList";
        Connection con = null;
        boolean error = false;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<ServizioApplicativo> lista = new ArrayList<ServizioApplicativo>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource(nomeMetodo);
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("servizi_applicativi");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addSelectField("nome");
            sqlQueryObject.addSelectField("id_soggetto");
            sqlQueryObject.addWhereCondition("tipoauth = ?");
            sqlQueryObject.addWhereCondition("utente = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setString(1, CredenzialeTipo.PRINCIPAL.getValue());
            stmt.setString(2, principal);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                ServizioApplicativo sa = this.getServizioApplicativo(risultato.getLong("id"));
                lista.add(sa);
            }
            ArrayList<ServizioApplicativo> arrayList = lista;
            return arrayList;
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<AccessoRegistroRegistro> registriList(ISearch ricerca) throws DriverConfigurazioneException {
        String nomeMetodo = "registriList";
        int idLista = 48;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        boolean error = false;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<AccessoRegistroRegistro> lista = new ArrayList<AccessoRegistroRegistro>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("registriList");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("registri");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("registri");
                sqlQueryObject.addSelectCountField("*", "cont");
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("registri");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("tipo");
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("registri");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("tipo");
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                AccessoRegistroRegistro arr = new AccessoRegistroRegistro();
                arr.setId(risultato.getLong("id"));
                arr.setNome(risultato.getString("nome"));
                arr.setTipo(RegistroTipo.toEnumConstant(risultato.getString("tipo")));
                lista.add(arr);
            }
            ArrayList<AccessoRegistroRegistro> arrayList = lista;
            return arrayList;
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public List<Soggetto> soggettiList(String superuser, ISearch ricerca) throws DriverConfigurazioneException {
        String nomeMetodo = "soggettiList";
        int idLista = 2;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        boolean error = false;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<Soggetto> lista = new ArrayList<Soggetto>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("soggettiList");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable(this.tabellaSoggetti);
                sqlQueryObject.addSelectCountField("*", "cont");
                if (superuser != null && !superuser.equals("")) {
                    sqlQueryObject.addWhereCondition("superuser = ?");
                }
                sqlQueryObject.addWhereLikeCondition("nome_soggetto", search, true, true);
                if (superuser != null && !superuser.equals("")) {
                    sqlQueryObject.setANDLogicOperator(true);
                }
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable(this.tabellaSoggetti);
                sqlQueryObject.addSelectCountField("*", "cont");
                if (superuser != null && !superuser.equals("")) {
                    sqlQueryObject.addWhereCondition("superuser = ?");
                }
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            if (superuser != null && !superuser.equals("")) {
                stmt.setString(1, superuser);
            }
            if ((risultato = stmt.executeQuery()).next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable(this.tabellaSoggetti);
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("nome_soggetto");
                sqlQueryObject.addSelectField("tipo_soggetto");
                sqlQueryObject.addSelectField("descrizione");
                sqlQueryObject.addSelectField("identificativo_porta");
                sqlQueryObject.addSelectField("is_router");
                if (superuser != null && !superuser.equals("")) {
                    sqlQueryObject.addWhereCondition("superuser = ?");
                }
                sqlQueryObject.addWhereLikeCondition("nome_soggetto", search, true, true);
                if (superuser != null && !superuser.equals("")) {
                    sqlQueryObject.setANDLogicOperator(true);
                }
                sqlQueryObject.addOrderBy("tipo_soggetto");
                sqlQueryObject.addOrderBy("nome_soggetto");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable(this.tabellaSoggetti);
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("nome_soggetto");
                sqlQueryObject.addSelectField("tipo_soggetto");
                sqlQueryObject.addSelectField("descrizione");
                sqlQueryObject.addSelectField("identificativo_porta");
                sqlQueryObject.addSelectField("is_router");
                if (superuser != null && !superuser.equals("")) {
                    sqlQueryObject.addWhereCondition("superuser = ?");
                }
                sqlQueryObject.addOrderBy("tipo_soggetto");
                sqlQueryObject.addOrderBy("nome_soggetto");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            if (superuser != null && !superuser.equals("")) {
                stmt.setString(1, superuser);
            }
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                Soggetto sog = new Soggetto();
                sog.setId(risultato.getLong("id"));
                sog.setNome(risultato.getString("nome_soggetto"));
                sog.setTipo(risultato.getString("tipo_soggetto"));
                sog.setDescrizione(risultato.getString("descrizione"));
                sog.setIdentificativoPorta(risultato.getString("identificativo_porta"));
                sog.setRouter(risultato.getInt("is_router") == 1);
                lista.add(sog);
            }
            ArrayList<Soggetto> arrayList = lista;
            return arrayList;
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<Soggetto> soggettiWithServiziList(ISearch ricerca) throws DriverConfigurazioneException {
        return this.soggettiWithServiziList(null, ricerca);
    }

    public List<Soggetto> soggettiWithServiziList(String superuser, ISearch ricerca) throws DriverConfigurazioneException {
        String nomeMetodo = "soggettiWithServiziList";
        int idLista = 2;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        Connection con = null;
        boolean error = false;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<Soggetto> lista = new ArrayList<Soggetto>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("soggettiWithServiziList");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable(this.tabellaSoggetti);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addSelectCountField(this.tabellaSoggetti + ".id", "cont", true);
            sqlQueryObject.addWhereCondition(this.tabellaSoggetti + ".id = servizi.id_soggetto");
            if (superuser != null && !"".equals(superuser)) {
                sqlQueryObject.addWhereCondition(this.tabellaSoggetti + ".superuser=?");
            }
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            if (superuser != null && !"".equals(superuser)) {
                stmt.setString(1, superuser);
            }
            if ((risultato = stmt.executeQuery()).next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable(this.tabellaSoggetti);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.setSelectDistinct(true);
            sqlQueryObject.addSelectField(this.tabellaSoggetti + ".id");
            sqlQueryObject.addSelectField(this.tabellaSoggetti + ".tipo_soggetto");
            sqlQueryObject.addSelectField(this.tabellaSoggetti + ".nome_soggetto");
            sqlQueryObject.addWhereCondition(this.tabellaSoggetti + ".id = servizi.id_soggetto");
            if (superuser != null && !"".equals(superuser)) {
                sqlQueryObject.addWhereCondition(this.tabellaSoggetti + ".superuser=?");
            }
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addOrderBy(this.tabellaSoggetti + ".tipo_soggetto");
            sqlQueryObject.addOrderBy(this.tabellaSoggetti + ".nome_soggetto");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            if (superuser != null && !"".equals(superuser)) {
                stmt.setString(1, superuser);
            }
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                Soggetto sog = new Soggetto();
                sog.setId(risultato.getLong("id"));
                sog.setNome(risultato.getString("nome_soggetto"));
                sog.setTipo(risultato.getString("tipo_soggetto"));
                lista.add(sog);
            }
            ArrayList<Soggetto> arrayList = lista;
            return arrayList;
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public String[] soggettiServizioApplicativoList(long idSoggetto) throws DriverConfigurazioneException {
        String nomeMetodo = "soggettiServizioApplicativoList";
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        boolean error = false;
        String[] silList = null;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("soggettiServizioApplicativoList");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("servizi_applicativi");
            sqlQueryObject.addSelectCountField("*", "cont");
            sqlQueryObject.addWhereCondition("id_soggetto = ?");
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idSoggetto);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                silList = new String[risultato.getInt(1)];
            }
            risultato.close();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("servizi_applicativi");
            sqlQueryObject.addSelectField("nome");
            sqlQueryObject.addSelectField("id_soggetto");
            sqlQueryObject.addWhereCondition("id_soggetto = ?");
            sqlQueryObject.addOrderBy("nome");
            sqlQueryObject.setSortType(true);
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idSoggetto);
            risultato = stmt.executeQuery();
            int i = 0;
            while (risultato.next()) {
                silList[i] = risultato.getString("nome");
                ++i;
            }
            String[] stringArray = silList;
            return stringArray;
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<ServizioApplicativo> soggettiServizioApplicativoList(IDSoggetto idSoggetto, String superuser, CredenzialeTipo credenziale) throws DriverConfigurazioneException {
        String nomeMetodo = "soggettiServizioApplicativoList";
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        boolean error = false;
        ArrayList<ServizioApplicativo> silList = new ArrayList<ServizioApplicativo>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource(nomeMetodo);
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("servizi_applicativi");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("servizi_applicativi.id");
            sqlQueryObject.addSelectField("nome");
            sqlQueryObject.addSelectField("id_soggetto");
            sqlQueryObject.addWhereCondition("id_soggetto = soggetti.id");
            sqlQueryObject.addWhereCondition("soggetti.tipo_soggetto = ?");
            sqlQueryObject.addWhereCondition("soggetti.nome_soggetto = ?");
            if (superuser != null && !"".equals(superuser)) {
                sqlQueryObject.addWhereCondition("soggetti.superuser = ?");
            }
            if (credenziale != null) {
                sqlQueryObject.addWhereCondition("servizi_applicativi.tipoauth = ?");
            }
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addOrderBy("nome");
            sqlQueryObject.setSortType(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            int index = 1;
            stmt.setString(index++, idSoggetto.getTipo());
            stmt.setString(index++, idSoggetto.getNome());
            if (superuser != null && !"".equals(superuser)) {
                stmt.setString(index++, superuser);
            }
            if (credenziale != null) {
                stmt.setString(index++, credenziale.getValue());
            }
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                ServizioApplicativo sa = this.getServizioApplicativo(risultato.getLong("id"));
                silList.add(sa);
            }
            ArrayList<ServizioApplicativo> arrayList = silList;
            return arrayList;
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<ServizioApplicativo> soggettiServizioApplicativoList(String superuser, ISearch ricerca) throws DriverConfigurazioneException {
        String nomeMetodo = "soggettiServizioApplicativoList";
        int idLista = 27;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        boolean error = false;
        ArrayList<ArrayList<ServizioApplicativo>> silList = new ArrayList<ArrayList<ServizioApplicativo>>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource(nomeMetodo);
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            ArrayList<ServizioApplicativo> sa;
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("servizi_applicativi");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_soggetto = soggetti.id");
                if (superuser != null && !"".equals(superuser)) {
                    sqlQueryObject.addWhereCondition("soggetti.superuser = ?");
                }
                sqlQueryObject.addWhereLikeCondition("servizi_applicativi.nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("servizi_applicativi");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_soggetto = soggetti.id");
                if (superuser != null && !"".equals(superuser)) {
                    sqlQueryObject.addWhereCondition("soggetti.superuser = ?");
                }
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            if (superuser != null && !superuser.equals("")) {
                stmt.setString(1, superuser);
            }
            if ((risultato = stmt.executeQuery()).next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("servizi_applicativi");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectField("servizi_applicativi.id");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("id_soggetto");
                sqlQueryObject.addWhereCondition("id_soggetto = soggetti.id");
                if (superuser != null && !"".equals(superuser)) {
                    sqlQueryObject.addWhereCondition("soggetti.superuser = ?");
                }
                sqlQueryObject.addWhereLikeCondition("servizi_applicativi.nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("servizi_applicativi");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectField("servizi_applicativi.id");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("id_soggetto");
                sqlQueryObject.addWhereCondition("id_soggetto = soggetti.id");
                if (superuser != null && !"".equals(superuser)) {
                    sqlQueryObject.addWhereCondition("soggetti.superuser = ?");
                }
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            if (superuser != null && !"".equals(superuser)) {
                stmt.setString(1, superuser);
            }
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                sa = this.getServizioApplicativo(risultato.getLong("id"));
                silList.add(sa);
            }
            sa = silList;
            return sa;
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<ServizioApplicativo> soggettiServizioApplicativoList(Long idSoggetto, ISearch ricerca) throws DriverConfigurazioneException {
        String nomeMetodo = "soggettiServizioApplicativoList";
        int idLista = 28;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        boolean error = false;
        ArrayList<ArrayList<ServizioApplicativo>> silList = new ArrayList<ArrayList<ServizioApplicativo>>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource(nomeMetodo);
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            ArrayList<ServizioApplicativo> sa;
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("servizi_applicativi");
                sqlQueryObject.addSelectCountField("*", "cont");
                if (idSoggetto != null) {
                    sqlQueryObject.addWhereCondition("id_soggetto = ?");
                }
                sqlQueryObject.addWhereLikeCondition("servizi_applicativi.nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("servizi_applicativi");
                sqlQueryObject.addSelectCountField("*", "cont");
                if (idSoggetto != null) {
                    sqlQueryObject.addWhereCondition("id_soggetto = ?");
                }
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            if (idSoggetto != null) {
                stmt.setLong(1, idSoggetto);
            }
            if ((risultato = stmt.executeQuery()).next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("servizi_applicativi");
                sqlQueryObject.addSelectField("servizi_applicativi.id");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("id_soggetto");
                if (idSoggetto != null) {
                    sqlQueryObject.addWhereCondition("id_soggetto = ?");
                }
                sqlQueryObject.addWhereLikeCondition("servizi_applicativi.nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("servizi_applicativi");
                sqlQueryObject.addSelectField("servizi_applicativi.id");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("id_soggetto");
                if (idSoggetto != null) {
                    sqlQueryObject.addWhereCondition("id_soggetto = ?");
                }
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            if (idSoggetto != null) {
                stmt.setLong(1, idSoggetto);
            }
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                sa = this.getServizioApplicativo(risultato.getLong("id"));
                silList.add(sa);
            }
            sa = silList;
            return sa;
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public HashSet<IDServizio> getServizi_SoggettiVirtuali() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        HashSet<IDServizio> servizi = new HashSet<IDServizio>();
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        String sqlQuery = "";
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("getServizi_SoggettiVirtuali");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("porte_applicative");
            sqlQueryObject.setSelectDistinct(true);
            sqlQueryObject.addSelectField("tipo_soggetto_virtuale");
            sqlQueryObject.addSelectField("nome_soggetto_virtuale");
            sqlQueryObject.addSelectField("tipo_servizio");
            sqlQueryObject.addSelectField("servizio");
            sqlQueryObject.setANDLogicOperator(false);
            sqlQueryObject.addWhereCondition("id_soggetto_virtuale<>-1");
            sqlQueryObject.addWhereCondition(true, "tipo_soggetto_virtuale is not null", "nome_soggetto_virtuale is not null");
            sqlQueryObject.setANDLogicOperator(false);
            sqlQuery = sqlQueryObject.createSQLQuery();
            this.log.debug("eseguo query : " + DBUtils.formatSQLString(sqlQuery, new Object[0]));
            stm = con.prepareStatement(sqlQuery);
            rs = stm.executeQuery();
            while (rs.next()) {
                IDServizio servizio = new IDServizio();
                servizio.setSoggettoErogatore(new IDSoggetto(rs.getString("tipo_soggetto_virtuale"), rs.getString("nome_soggetto_virtuale")));
                servizio.setServizio(rs.getString("servizio"));
                servizio.setTipoServizio(rs.getString("tipo_servizio"));
                servizi.add(servizio);
                this.log.info("aggiunto Servizio " + servizio.toString() + " alla lista dei servizi erogati da Soggetti Virtuali");
            }
            if (servizi.size() == 0) {
                throw new DriverConfigurazioneNotFound("[getServizi_SoggettiVirtuali] Servizi erogati da Soggetti virtuali non esistenti");
            }
            this.log.info("aggiunti " + servizi.size() + " servizi alla lista dei servizi erogati da Soggetti Virtuali");
            HashSet<IDServizio> hashSet = servizi;
            return hashSet;
        }
        catch (SQLException se) {
            throw new DriverConfigurazioneException("SqlException: " + se.getMessage(), se);
        }
        catch (DriverConfigurazioneNotFound se) {
            throw se;
        }
        catch (Exception se) {
            throw new DriverConfigurazioneException("Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public Soggetto getSoggetto(long idSoggetto) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.getSoggetto(idSoggetto, null);
    }

    public Soggetto getSoggetto(long idSoggetto, Connection conParam) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (idSoggetto <= 0L) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getSoggetto] L'id del soggetto deve essere > 0.");
        }
        Soggetto Soggetto2 = null;
        Connection con = null;
        Statement stm = null;
        Statement stm1 = null;
        ResultSet rs = null;
        ResultSet rs1 = null;
        String sqlQuery = "";
        if (conParam != null) {
            con = conParam;
        } else if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("getSoggetto(longId)");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getSoggetto] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            boolean isrouter;
            String tmp;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable(this.tabellaSoggetti);
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id=?");
            sqlQuery = sqlQueryObject.createSQLQuery();
            this.log.debug("operazione this.atomica = " + this.atomica);
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idSoggetto);
            this.log.debug("eseguo query : " + DBUtils.formatSQLString(sqlQuery, idSoggetto));
            rs = stm.executeQuery();
            if (rs.next()) {
                Soggetto2 = new Soggetto();
                Soggetto2.setId(rs.getLong("id"));
                Soggetto2.setNome(rs.getString("nome_soggetto"));
                Soggetto2.setTipo(rs.getString("tipo_soggetto"));
                Soggetto2.setSuperUser(rs.getString("superuser"));
                tmp = rs.getString("descrizione");
                Soggetto2.setDescrizione(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("identificativo_porta");
                Soggetto2.setIdentificativoPorta(tmp == null || tmp.equals("") ? null : tmp);
                int router = rs.getInt("is_router");
                isrouter = false;
                if (router == 1) {
                    isrouter = true;
                }
            } else {
                throw new DriverConfigurazioneNotFound("[DriverConfigurazioneDB::getSoggetto] Soggetto non Esistente.");
            }
            Soggetto2.setRouter(isrouter);
            tmp = rs.getString("pd_url_prefix_rewriter");
            Soggetto2.setPdUrlPrefixRewriter(tmp == null || tmp.equals("") ? null : tmp);
            tmp = rs.getString("pa_url_prefix_rewriter");
            Soggetto2.setPaUrlPrefixRewriter(tmp == null || tmp.equals("") ? null : tmp);
            Soggetto soggetto = Soggetto2;
            return soggetto;
        }
        catch (SQLException se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getSoggetto] SqlException: " + se.getMessage(), se);
        }
        catch (DriverConfigurazioneNotFound e) {
            throw new DriverConfigurazioneNotFound(e);
        }
        catch (Exception se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getSoggetto] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (rs1 != null) {
                    rs1.close();
                }
                if (stm1 != null) {
                    stm1.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (conParam == null && this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public PortaApplicativa getPortaApplicativa(long id) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.getPortaApplicativa(id, null);
    }

    public PortaApplicativa getPortaApplicativa(long id, Connection conParam) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (id <= 0L) {
            throw new DriverConfigurazioneException("[getPortaApplicativa] L'id della Porta Applicativa deve essere > 0.");
        }
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        Statement stm1 = null;
        ResultSet rs1 = null;
        String sqlQuery = null;
        if (conParam != null) {
            con = conParam;
        } else if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("getPortaApplicativa(longId)");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getPortaApplicativa] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            long idPortaApplicativa = id;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("porte_applicative");
            sqlQueryObject.addFromTable(this.tabellaSoggetti);
            sqlQueryObject.addSelectField("nome_porta");
            sqlQueryObject.addSelectField("tipo_soggetto");
            sqlQueryObject.addSelectField("nome_soggetto");
            sqlQueryObject.addSelectField("nome_soggetto_virtuale");
            sqlQueryObject.addSelectField("tipo_soggetto_virtuale");
            sqlQueryObject.addSelectField("servizio");
            sqlQueryObject.addSelectField("tipo_servizio");
            sqlQueryObject.addSelectField("ricevuta_asincrona_asim");
            sqlQueryObject.addSelectField("ricevuta_asincrona_sim");
            sqlQueryObject.addSelectField("integrazione");
            sqlQueryObject.addSelectField("scadenza_correlazione_appl");
            sqlQueryObject.addSelectField("allega_body");
            sqlQueryObject.addSelectField("scarta_body");
            sqlQueryObject.addSelectField("gestione_manifest");
            sqlQueryObject.addSelectField("azione");
            sqlQueryObject.addSelectField("validazione_contenuti_stato");
            sqlQueryObject.addSelectField("validazione_contenuti_tipo");
            sqlQueryObject.addSelectField("validazione_contenuti_mtom");
            sqlQueryObject.addSelectField("mtom_request_mode");
            sqlQueryObject.addSelectField("mtom_response_mode");
            sqlQueryObject.addSelectField("ws_security");
            sqlQueryObject.addSelectField("ws_security_mtom_req");
            sqlQueryObject.addSelectField("ws_security_mtom_res");
            sqlQueryObject.addSelectAliasField("porte_applicative.id", "idPA");
            sqlQueryObject.addSelectAliasField(this.tabellaSoggetti + ".id", "idSoggetto");
            sqlQueryObject.addSelectAliasField("porte_applicative.descrizione", "descrizionePorta");
            sqlQueryObject.addSelectField("stateless");
            sqlQueryObject.addSelectField("behaviour");
            sqlQueryObject.addSelectField("autenticazione");
            sqlQueryObject.addSelectField("autenticazione_opzionale");
            sqlQueryObject.addSelectField("autorizzazione");
            sqlQueryObject.addSelectField("autorizzazione_contenuto");
            sqlQueryObject.addSelectField("ruoli_match");
            sqlQueryObject.addSelectField("stato");
            sqlQueryObject.addSelectField("id_accordo");
            sqlQueryObject.addSelectField("id_port_type");
            sqlQueryObject.addWhereCondition("porte_applicative.id_soggetto = " + this.tabellaSoggetti + ".id");
            sqlQueryObject.addWhereCondition("porte_applicative.id = ?");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idPortaApplicativa);
            rs = stm.executeQuery();
            if (rs.next()) {
                List<Object> listExtInfo;
                String ruoliMatch;
                PortaApplicativa pa = new PortaApplicativa();
                pa.setId(rs.getLong("idPA"));
                pa.setIdSoggetto(rs.getLong("idSoggetto"));
                pa.setDescrizione(rs.getString("descrizionePorta"));
                pa.setNome(rs.getString("nome_porta"));
                pa.setTipoSoggettoProprietario(rs.getString("tipo_soggetto"));
                pa.setNomeSoggettoProprietario(rs.getString("nome_soggetto"));
                pa.setIdAccordo(rs.getLong("id_accordo"));
                pa.setIdPortType(rs.getLong("id_port_type"));
                PortaApplicativaSoggettoVirtuale paSoggVirt = null;
                String nomeSoggVirt = rs.getString("nome_soggetto_virtuale");
                String tipoSoggVirt = rs.getString("tipo_soggetto_virtuale");
                if (nomeSoggVirt != null && !nomeSoggVirt.equals("") && tipoSoggVirt != null && !tipoSoggVirt.equals("")) {
                    long idSoggVirt = -1L;
                    try {
                        idSoggVirt = DBUtils.getIdSoggetto(nomeSoggVirt, tipoSoggVirt, con, this.tipoDB, this.tabellaSoggetti);
                    }
                    catch (Exception e) {
                        this.log.error(e.getMessage(), (Throwable)e);
                    }
                    paSoggVirt = new PortaApplicativaSoggettoVirtuale();
                    paSoggVirt.setId(idSoggVirt);
                    paSoggVirt.setNome(nomeSoggVirt);
                    paSoggVirt.setTipo(tipoSoggVirt);
                }
                pa.setSoggettoVirtuale(paSoggVirt);
                PortaApplicativaServizio paServizio = null;
                String nomeServizio = rs.getString("servizio");
                String tipoServizioPA = rs.getString("tipo_servizio");
                String nomeProprietarioServizio = null;
                String tipoProprietarioServizio = null;
                if (nomeSoggVirt != null && !nomeSoggVirt.equals("") && tipoSoggVirt != null && !tipoSoggVirt.equals("")) {
                    nomeProprietarioServizio = nomeSoggVirt;
                    tipoProprietarioServizio = tipoSoggVirt;
                } else {
                    nomeProprietarioServizio = pa.getNomeSoggettoProprietario();
                    tipoProprietarioServizio = pa.getTipoSoggettoProprietario();
                }
                long idServizioPA = -1L;
                try {
                    idServizioPA = DBUtils.getIdServizio(nomeServizio, tipoServizioPA, nomeProprietarioServizio, tipoProprietarioServizio, con, this.tipoDB, this.tabellaSoggetti);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (idServizioPA > 0L || nomeServizio != null && !nomeServizio.equals("") && tipoServizioPA != null && !tipoServizioPA.equals("")) {
                    paServizio = new PortaApplicativaServizio();
                    paServizio.setNome(nomeServizio);
                    paServizio.setTipo(tipoServizioPA);
                    paServizio.setId(idServizioPA);
                }
                pa.setServizio(paServizio);
                pa.setRicevutaAsincronaAsimmetrica(DriverConfigurazioneDB_LIB.getEnumStatoFunzionalita(rs.getString("ricevuta_asincrona_asim")));
                pa.setRicevutaAsincronaSimmetrica(DriverConfigurazioneDB_LIB.getEnumStatoFunzionalita(rs.getString("ricevuta_asincrona_sim")));
                pa.setIntegrazione(rs.getString("integrazione"));
                String scadenzaCorrelazione = rs.getString("scadenza_correlazione_appl");
                CorrelazioneApplicativa corr = null;
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("pa_correlazione");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("id_porta=?");
                sqlQueryObject.addOrderBy("id");
                sqlQueryObject.setSortType(true);
                String queryCorrApp = sqlQueryObject.createSQLQuery();
                PreparedStatement stmCorrApp = con.prepareStatement(queryCorrApp);
                stmCorrApp.setLong(1, idPortaApplicativa);
                ResultSet rsCorrApp = stmCorrApp.executeQuery();
                while (rsCorrApp.next()) {
                    if (corr == null) {
                        corr = new CorrelazioneApplicativa();
                    }
                    CorrelazioneApplicativaElemento cae = new CorrelazioneApplicativaElemento();
                    cae.setId(rsCorrApp.getLong("id"));
                    cae.setNome(rsCorrApp.getString("nome_elemento"));
                    String modeCA = rsCorrApp.getString("mode_correlazione");
                    cae.setIdentificazione(DriverConfigurazioneDB_LIB.getEnumCorrelazioneApplicativaRichiestaIdentificazione(modeCA));
                    if (modeCA.equals("urlBased") || modeCA.equals("contentBased")) {
                        cae.setPattern(rsCorrApp.getString("pattern"));
                    }
                    cae.setIdentificazioneFallita(DriverConfigurazioneDB_LIB.getEnumCorrelazioneApplicativaGestioneIdentificazioneFallita(rsCorrApp.getString("identificazione_fallita")));
                    corr.addElemento(cae);
                }
                rsCorrApp.close();
                stmCorrApp.close();
                if (corr != null && scadenzaCorrelazione != null && !scadenzaCorrelazione.equals("")) {
                    corr.setScadenza(scadenzaCorrelazione);
                }
                pa.setCorrelazioneApplicativa(corr);
                CorrelazioneApplicativaRisposta corrApplRisposta = null;
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("pa_correlazione_risposta");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("id_porta=?");
                sqlQueryObject.addOrderBy("id");
                sqlQueryObject.setSortType(true);
                queryCorrApp = sqlQueryObject.createSQLQuery();
                stmCorrApp = con.prepareStatement(queryCorrApp);
                stmCorrApp.setLong(1, idPortaApplicativa);
                rsCorrApp = stmCorrApp.executeQuery();
                while (rsCorrApp.next()) {
                    if (corrApplRisposta == null) {
                        corrApplRisposta = new CorrelazioneApplicativaRisposta();
                    }
                    CorrelazioneApplicativaRispostaElemento cae = new CorrelazioneApplicativaRispostaElemento();
                    cae.setId(rsCorrApp.getLong("id"));
                    cae.setNome(rsCorrApp.getString("nome_elemento"));
                    String modeCA = rsCorrApp.getString("mode_correlazione");
                    cae.setIdentificazione(DriverConfigurazioneDB_LIB.getEnumCorrelazioneApplicativaRispostaIdentificazione(modeCA));
                    if (modeCA.equals("urlBased") || modeCA.equals("contentBased")) {
                        cae.setPattern(rsCorrApp.getString("pattern"));
                    }
                    cae.setIdentificazioneFallita(DriverConfigurazioneDB_LIB.getEnumCorrelazioneApplicativaGestioneIdentificazioneFallita(rsCorrApp.getString("identificazione_fallita")));
                    corrApplRisposta.addElemento(cae);
                }
                rsCorrApp.close();
                stmCorrApp.close();
                pa.setCorrelazioneApplicativaRisposta(corrApplRisposta);
                pa.setAllegaBody(DriverConfigurazioneDB_LIB.getEnumStatoFunzionalita(rs.getString("allega_body")));
                pa.setScartaBody(DriverConfigurazioneDB_LIB.getEnumStatoFunzionalita(rs.getString("scarta_body")));
                pa.setGestioneManifest(DriverConfigurazioneDB_LIB.getEnumStatoFunzionalita(rs.getString("gestione_manifest")));
                pa.setStateless(DriverConfigurazioneDB_LIB.getEnumStatoFunzionalita(rs.getString("stateless")));
                pa.setBehaviour(rs.getString("behaviour"));
                pa.setAutenticazione(rs.getString("autenticazione"));
                pa.setAutenticazioneOpzionale(DriverConfigurazioneDB_LIB.getEnumStatoFunzionalita(rs.getString("autenticazione_opzionale")));
                pa.setAutorizzazione(rs.getString("autorizzazione"));
                pa.setAutorizzazioneContenuto(rs.getString("autorizzazione_contenuto"));
                String azione = rs.getString("azione");
                if (azione != null && !"-".equals(azione) && !"".equals(azione)) {
                    PortaApplicativaAzione paAzione = new PortaApplicativaAzione();
                    paAzione.setNome(azione);
                    pa.setAzione(paAzione);
                }
                if (rs.getString("stato") != null) {
                    pa.setStato(DriverConfigurazioneDB_LIB.getEnumStatoFunzionalita(rs.getString("stato")));
                }
                MtomProcessor mtomProcessor = null;
                String mtom_request = rs.getString("mtom_request_mode");
                String mtom_response = rs.getString("mtom_response_mode");
                if (mtom_request != null && !mtom_request.equals("") || mtom_response != null && !mtom_response.equals("")) {
                    mtomProcessor = new MtomProcessor();
                    if (mtom_request != null && !mtom_request.equals("")) {
                        mtomProcessor.setRequestFlow(new MtomProcessorFlow());
                        mtomProcessor.getRequestFlow().setMode(DriverConfigurazioneDB_LIB.getEnumMTOMProcessorType(mtom_request));
                    }
                    if (mtom_response != null && !mtom_response.equals("")) {
                        mtomProcessor.setResponseFlow(new MtomProcessorFlow());
                        mtomProcessor.getResponseFlow().setMode(DriverConfigurazioneDB_LIB.getEnumMTOMProcessorType(mtom_response));
                    }
                }
                String validazioneContenuti_stato = rs.getString("validazione_contenuti_stato");
                String validazioneContenuti_tipo = rs.getString("validazione_contenuti_tipo");
                String validazioneContenuti_mtom = rs.getString("validazione_contenuti_mtom");
                if (validazioneContenuti_stato != null && !validazioneContenuti_stato.equals("") || validazioneContenuti_tipo != null && !validazioneContenuti_tipo.equals("")) {
                    ValidazioneContenutiApplicativi val = new ValidazioneContenutiApplicativi();
                    if (validazioneContenuti_stato != null && !validazioneContenuti_stato.equals("")) {
                        val.setStato(DriverConfigurazioneDB_LIB.getEnumStatoFunzionalitaConWarning(validazioneContenuti_stato));
                    }
                    if (validazioneContenuti_tipo != null && !validazioneContenuti_tipo.equals("")) {
                        val.setTipo(DriverConfigurazioneDB_LIB.getEnumValidazioneContenutiApplicativiTipo(validazioneContenuti_tipo));
                    }
                    if (validazioneContenuti_mtom != null && !validazioneContenuti_mtom.equals("")) {
                        val.setAcceptMtomMessage(DriverConfigurazioneDB_LIB.getEnumStatoFunzionalita(validazioneContenuti_mtom));
                    }
                    pa.setValidazioneContenutiApplicativi(val);
                }
                String ws_security = rs.getString("ws_security");
                String ws_security_mtom_req = rs.getString("ws_security_mtom_req");
                String ws_security_mtom_res = rs.getString("ws_security_mtom_res");
                MessageSecurity messageSecurity = null;
                if (ws_security_mtom_req != null && !ws_security_mtom_req.equals("") || ws_security_mtom_res != null && !ws_security_mtom_res.equals("")) {
                    messageSecurity = new MessageSecurity();
                    if (ws_security_mtom_req != null && !ws_security_mtom_req.equals("")) {
                        messageSecurity.setRequestFlow(new MessageSecurityFlow());
                        messageSecurity.getRequestFlow().setApplyToMtom(DriverConfigurazioneDB_LIB.getEnumStatoFunzionalita(ws_security_mtom_req));
                    }
                    if (ws_security_mtom_res != null && !ws_security_mtom_res.equals("")) {
                        messageSecurity.setResponseFlow(new MessageSecurityFlow());
                        messageSecurity.getResponseFlow().setApplyToMtom(DriverConfigurazioneDB_LIB.getEnumStatoFunzionalita(ws_security_mtom_res));
                    }
                }
                if ((ruoliMatch = rs.getString("ruoli_match")) != null && !"".equals(ruoliMatch)) {
                    if (pa.getRuoli() == null) {
                        pa.setRuoli(new AutorizzazioneRuoli());
                    }
                    pa.getRuoli().setMatch(RuoloTipoMatch.toEnumConstant(ruoliMatch));
                }
                rs.close();
                stm.close();
                if (CostantiConfigurazione.ABILITATO.toString().equalsIgnoreCase(ws_security)) {
                    pa.setStatoMessageSecurity(CostantiConfigurazione.ABILITATO.toString());
                } else {
                    pa.setStatoMessageSecurity(CostantiConfigurazione.DISABILITATO.toString());
                }
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("pa_ws_request");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("id_porta=?");
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm1 = con.prepareStatement(sqlQuery);
                stm1.setLong(1, idPortaApplicativa);
                this.log.debug("eseguo query : " + DBUtils.formatSQLString(sqlQuery, idPortaApplicativa));
                rs1 = stm1.executeQuery();
                while (rs1.next()) {
                    MessageSecurityFlowParameter secRfp = new MessageSecurityFlowParameter();
                    secRfp.setNome(rs1.getString("nome"));
                    secRfp.setValore(rs1.getString("valore"));
                    if (messageSecurity == null) {
                        messageSecurity = new MessageSecurity();
                    }
                    if (messageSecurity.getRequestFlow() == null) {
                        messageSecurity.setRequestFlow(new MessageSecurityFlow());
                    }
                    messageSecurity.getRequestFlow().addParameter(secRfp);
                }
                rs1.close();
                stm1.close();
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("pa_ws_response");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("id_porta=?");
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm1 = con.prepareStatement(sqlQuery);
                stm1.setLong(1, idPortaApplicativa);
                this.log.debug("eseguo query : " + DBUtils.formatSQLString(sqlQuery, idPortaApplicativa));
                rs1 = stm1.executeQuery();
                while (rs1.next()) {
                    MessageSecurityFlowParameter secResfp = new MessageSecurityFlowParameter();
                    secResfp.setNome(rs1.getString("nome"));
                    secResfp.setValore(rs1.getString("valore"));
                    if (messageSecurity == null) {
                        messageSecurity = new MessageSecurity();
                    }
                    if (messageSecurity.getResponseFlow() == null) {
                        messageSecurity.setResponseFlow(new MessageSecurityFlow());
                    }
                    messageSecurity.getResponseFlow().addParameter(secResfp);
                }
                rs1.close();
                stm1.close();
                pa.setMessageSecurity(messageSecurity);
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("pa_mtom_request");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("id_porta=?");
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm1 = con.prepareStatement(sqlQuery);
                stm1.setLong(1, idPortaApplicativa);
                this.log.debug("eseguo query : " + DBUtils.formatSQLString(sqlQuery, idPortaApplicativa));
                rs1 = stm1.executeQuery();
                while (rs1.next()) {
                    MtomProcessorFlowParameter rfp = new MtomProcessorFlowParameter();
                    rfp.setNome(rs1.getString("nome"));
                    rfp.setPattern(rs1.getString("pattern"));
                    rfp.setContentType(rs1.getString("content_type"));
                    int required = rs1.getInt("required");
                    boolean isrequired = false;
                    if (required == 1) {
                        isrequired = true;
                    }
                    rfp.setRequired(isrequired);
                    if (mtomProcessor.getRequestFlow() == null) {
                        mtomProcessor.setRequestFlow(new MtomProcessorFlow());
                    }
                    mtomProcessor.getRequestFlow().addParameter(rfp);
                }
                rs1.close();
                stm1.close();
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("pa_mtom_response");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("id_porta=?");
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm1 = con.prepareStatement(sqlQuery);
                stm1.setLong(1, idPortaApplicativa);
                this.log.debug("eseguo query : " + DBUtils.formatSQLString(sqlQuery, idPortaApplicativa));
                rs1 = stm1.executeQuery();
                while (rs1.next()) {
                    MtomProcessorFlowParameter rsfp = new MtomProcessorFlowParameter();
                    rsfp.setNome(rs1.getString("nome"));
                    rsfp.setPattern(rs1.getString("pattern"));
                    rsfp.setContentType(rs1.getString("content_type"));
                    int required = rs1.getInt("required");
                    boolean isrequired = false;
                    if (required == 1) {
                        isrequired = true;
                    }
                    rsfp.setRequired(isrequired);
                    if (mtomProcessor.getResponseFlow() == null) {
                        mtomProcessor.setResponseFlow(new MtomProcessorFlow());
                    }
                    mtomProcessor.getResponseFlow().addParameter(rsfp);
                }
                rs1.close();
                stm1.close();
                pa.setMtomProcessor(mtomProcessor);
                long idSA = 0L;
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("porte_applicative_sa");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("id_porta=?");
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm = con.prepareStatement(sqlQuery);
                stm.setLong(1, idPortaApplicativa);
                rs = stm.executeQuery();
                while (rs.next()) {
                    idSA = rs.getLong("id_servizio_applicativo");
                    if (idSA == 0L) continue;
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                    sqlQueryObject.addFromTable("servizi_applicativi");
                    sqlQueryObject.addSelectField("nome");
                    sqlQueryObject.addWhereCondition("id=?");
                    sqlQuery = sqlQueryObject.createSQLQuery();
                    stm1 = con.prepareStatement(sqlQuery);
                    stm1.setLong(1, idSA);
                    this.log.debug("eseguo query : " + DBUtils.formatSQLString(sqlQuery, idSA));
                    rs1 = stm1.executeQuery();
                    ServizioApplicativo servizioApplicativo = null;
                    if (rs1.next()) {
                        servizioApplicativo = new ServizioApplicativo();
                        servizioApplicativo.setId(idSA);
                        servizioApplicativo.setNome(rs1.getString("nome"));
                        pa.addServizioApplicativo(servizioApplicativo);
                    }
                    rs1.close();
                    stm1.close();
                }
                rs.close();
                stm.close();
                ProprietaProtocollo prop = null;
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("pa_properties");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("id_porta=?");
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm = con.prepareStatement(sqlQuery);
                stm.setLong(1, idPortaApplicativa);
                rs = stm.executeQuery();
                while (rs.next()) {
                    prop = new ProprietaProtocollo();
                    prop.setId(idPortaApplicativa);
                    prop.setNome(rs.getString("nome"));
                    prop.setValore(rs.getString("valore"));
                    pa.addProprietaProtocollo(prop);
                }
                rs.close();
                stm.close();
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("pa_ruoli");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("id_porta=?");
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm = con.prepareStatement(sqlQuery);
                stm.setLong(1, idPortaApplicativa);
                rs = stm.executeQuery();
                while (rs.next()) {
                    if (pa.getRuoli() == null) {
                        pa.setRuoli(new AutorizzazioneRuoli());
                    }
                    Ruolo ruolo = new Ruolo();
                    ruolo.setNome(rs.getString("ruolo"));
                    pa.getRuoli().addRuolo(ruolo);
                }
                rs.close();
                stm.close();
                this.log.debug("ExtendedInfo ... ");
                ExtendedInfoManager extInfoManager = ExtendedInfoManager.getInstance();
                IExtendedInfo extInfoConfigurazioneDriver = extInfoManager.newInstanceExtendedInfoPortaApplicativa();
                if (extInfoConfigurazioneDriver != null && (listExtInfo = extInfoConfigurazioneDriver.getAllExtendedInfo(con, this.log, pa)) != null && listExtInfo.size() > 0) {
                    for (Object object : listExtInfo) {
                        pa.addExtendedInfo(object);
                    }
                }
                PortaApplicativa portaApplicativa = pa;
                return portaApplicativa;
            }
            try {
                throw new DriverConfigurazioneNotFound("Porta Applicativa non esistente");
            }
            catch (SQLException se) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getPortaApplicativa] SqlException: " + se.getMessage(), se);
            }
            catch (DriverConfigurazioneNotFound e) {
                throw new DriverConfigurazioneNotFound(e);
            }
            catch (Exception se) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getPortaApplicativa] Exception: " + se.getMessage(), se);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
                if (rs1 != null) {
                    rs1.close();
                }
                if (stm1 != null) {
                    stm1.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (conParam == null && this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public PortaDelegata getPortaDelegata(long id) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.getPortaDelegata(id, null);
    }

    public PortaDelegata getPortaDelegata(long id, Connection conParam) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (id <= 0L) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getPortaDelegata] L'id della Porta Delegata deve essere > 0.");
        }
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        Statement stm1 = null;
        ResultSet rs1 = null;
        PortaDelegata pd = null;
        long idPortaDelegata = id;
        if (conParam != null) {
            con = conParam;
        } else if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("getPortaDelegata(longId)");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getPortaDelegata] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("porte_delegate");
            sqlQueryObject.addFromTable(this.tabellaSoggetti);
            sqlQueryObject.addSelectField("tipo_soggetto");
            sqlQueryObject.addSelectField("nome_soggetto");
            sqlQueryObject.addSelectField("autenticazione");
            sqlQueryObject.addSelectField("autenticazione_opzionale");
            sqlQueryObject.addSelectField("autorizzazione");
            sqlQueryObject.addSelectField("autorizzazione_contenuto");
            sqlQueryObject.addSelectField("id_soggetto");
            sqlQueryObject.addSelectField("location");
            sqlQueryObject.addSelectField("nome_porta");
            sqlQueryObject.addSelectField("id_soggetto_erogatore");
            sqlQueryObject.addSelectField("mode_soggetto_erogatore");
            sqlQueryObject.addSelectField("nome_soggetto_erogatore");
            sqlQueryObject.addSelectField("tipo_soggetto_erogatore");
            sqlQueryObject.addSelectField("pattern_soggetto_erogatore");
            sqlQueryObject.addSelectField("id_servizio");
            sqlQueryObject.addSelectField("tipo_servizio");
            sqlQueryObject.addSelectField("nome_servizio");
            sqlQueryObject.addSelectField("mode_servizio");
            sqlQueryObject.addSelectField("pattern_servizio");
            sqlQueryObject.addSelectField("mode_azione");
            sqlQueryObject.addSelectField("id_azione");
            sqlQueryObject.addSelectField("nome_azione");
            sqlQueryObject.addSelectField("pattern_azione");
            sqlQueryObject.addSelectField("force_wsdl_based_azione");
            sqlQueryObject.addSelectField("ricevuta_asincrona_asim");
            sqlQueryObject.addSelectField("ricevuta_asincrona_sim");
            sqlQueryObject.addSelectField("integrazione");
            sqlQueryObject.addSelectField("scadenza_correlazione_appl");
            sqlQueryObject.addSelectField("validazione_contenuti_stato");
            sqlQueryObject.addSelectField("validazione_contenuti_tipo");
            sqlQueryObject.addSelectField("validazione_contenuti_mtom");
            sqlQueryObject.addSelectField("mtom_request_mode");
            sqlQueryObject.addSelectField("mtom_response_mode");
            sqlQueryObject.addSelectField("ws_security");
            sqlQueryObject.addSelectField("ws_security_mtom_req");
            sqlQueryObject.addSelectField("ws_security_mtom_res");
            sqlQueryObject.addSelectField("allega_body");
            sqlQueryObject.addSelectField("scarta_body");
            sqlQueryObject.addSelectField("gestione_manifest");
            sqlQueryObject.addSelectAliasField("porte_delegate.descrizione", "descrizionePD");
            sqlQueryObject.addSelectField("stateless");
            sqlQueryObject.addSelectField("local_forward");
            sqlQueryObject.addSelectField("ruoli_match");
            sqlQueryObject.addSelectField("stato");
            sqlQueryObject.addSelectField("id_accordo");
            sqlQueryObject.addSelectField("id_port_type");
            sqlQueryObject.addWhereCondition("porte_delegate.id_soggetto = " + this.tabellaSoggetti + ".id");
            sqlQueryObject.addWhereCondition("porte_delegate.id = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idPortaDelegata);
            rs = stm.executeQuery();
            if (rs.next()) {
                List<Object> listExtInfo;
                String ruoliMatch;
                pd = new PortaDelegata();
                pd.setTipoSoggettoProprietario(rs.getString("tipo_soggetto"));
                pd.setNomeSoggettoProprietario(rs.getString("nome_soggetto"));
                pd.setId(idPortaDelegata);
                pd.setAutenticazione(rs.getString("autenticazione"));
                pd.setAutenticazioneOpzionale(DriverConfigurazioneDB_LIB.getEnumStatoFunzionalita(rs.getString("autenticazione_opzionale")));
                pd.setAutorizzazione(rs.getString("autorizzazione"));
                pd.setAutorizzazioneContenuto(rs.getString("autorizzazione_contenuto"));
                pd.setDescrizione(rs.getString("descrizionePD"));
                pd.setIdSoggetto(rs.getLong("id_soggetto"));
                pd.setLocation(rs.getString("location"));
                pd.setNome(rs.getString("nome_porta"));
                pd.setIdAccordo(rs.getLong("id_accordo"));
                pd.setIdPortType(rs.getLong("id_port_type"));
                String modeSoggErogatore = rs.getString("mode_soggetto_erogatore");
                String nomeSoggettoErogatore = rs.getString("nome_soggetto_erogatore");
                String tipoSoggettoErogatore = rs.getString("tipo_soggetto_erogatore");
                long idSoggettoErogatoreDB = rs.getLong("id_soggetto_erogatore");
                long idSoggErogatore = -1L;
                if (idSoggettoErogatoreDB == -2L || idSoggettoErogatoreDB > 0L) {
                    idSoggErogatore = idSoggettoErogatoreDB;
                } else {
                    try {
                        idSoggErogatore = DBUtils.getIdSoggetto(nomeSoggettoErogatore, tipoSoggettoErogatore, con, this.tipoDB, this.tabellaSoggetti);
                    }
                    catch (CoreException e) {
                        this.log.debug(e.getMessage(), (Throwable)e);
                    }
                }
                PortaDelegataSoggettoErogatore SoggettoErogatore = null;
                if (idSoggErogatore <= 0L && (modeSoggErogatore == null || modeSoggErogatore.equals(""))) {
                    throw new DriverConfigurazioneException("Soggetto Erogatore della Porta Delegata [" + pd.getNome() + "] non presente.");
                }
                SoggettoErogatore = new PortaDelegataSoggettoErogatore();
                SoggettoErogatore.setId(idSoggErogatore);
                SoggettoErogatore.setIdentificazione(PortaDelegataSoggettoErogatoreIdentificazione.toEnumConstant(modeSoggErogatore));
                SoggettoErogatore.setNome(nomeSoggettoErogatore);
                SoggettoErogatore.setTipo(tipoSoggettoErogatore);
                SoggettoErogatore.setPattern(rs.getString("pattern_soggetto_erogatore"));
                pd.setSoggettoErogatore(SoggettoErogatore);
                String tipoServizio = rs.getString("tipo_servizio");
                String nomeServizio = rs.getString("nome_servizio");
                String mode_servizio = rs.getString("mode_servizio");
                long idServizioDB = rs.getLong("id_servizio");
                long idServizio = -1L;
                if (idServizioDB == -2L || idServizioDB > 0L) {
                    idServizio = idServizioDB;
                } else {
                    try {
                        idServizio = DBUtils.getIdServizio(nomeServizio, tipoServizio, nomeSoggettoErogatore, tipoSoggettoErogatore, con, this.tipoDB, this.tabellaSoggetti);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                PortaDelegataServizio pdServizio = null;
                if (idServizio > 0L || mode_servizio != null && !mode_servizio.equals("")) {
                    pdServizio = new PortaDelegataServizio();
                    pdServizio.setId(idServizio);
                    pdServizio.setNome(nomeServizio);
                    pdServizio.setTipo(tipoServizio);
                    pdServizio.setIdentificazione(PortaDelegataServizioIdentificazione.toEnumConstant(mode_servizio));
                    pdServizio.setPattern(rs.getString("pattern_servizio"));
                }
                pd.setServizio(pdServizio);
                PortaDelegataAzione pdAzione = null;
                String modeAzione = rs.getString("mode_azione");
                long idAzione = rs.getLong("id_azione");
                if (idAzione > 0L || modeAzione != null && !"".equals(modeAzione)) {
                    pdAzione = new PortaDelegataAzione();
                    pdAzione.setId(rs.getLong("id_azione"));
                    pdAzione.setNome(rs.getString("nome_azione"));
                    pdAzione.setIdentificazione(PortaDelegataAzioneIdentificazione.toEnumConstant(modeAzione));
                    pdAzione.setPattern(rs.getString("pattern_azione"));
                    pdAzione.setForceWsdlBased(DriverConfigurazioneDB_LIB.getEnumStatoFunzionalita(rs.getString("force_wsdl_based_azione")));
                }
                pd.setAzione(pdAzione);
                pd.setRicevutaAsincronaAsimmetrica(DriverConfigurazioneDB_LIB.getEnumStatoFunzionalita(rs.getString("ricevuta_asincrona_asim")));
                pd.setRicevutaAsincronaSimmetrica(DriverConfigurazioneDB_LIB.getEnumStatoFunzionalita(rs.getString("ricevuta_asincrona_sim")));
                pd.setIntegrazione(rs.getString("integrazione"));
                String scadenzaCorrelazione = rs.getString("scadenza_correlazione_appl");
                CorrelazioneApplicativa corr = null;
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("pd_correlazione");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("id_porta=?");
                sqlQueryObject.addOrderBy("id");
                sqlQueryObject.setSortType(true);
                String queryCorrApp = sqlQueryObject.createSQLQuery();
                PreparedStatement stmCorrApp = con.prepareStatement(queryCorrApp);
                stmCorrApp.setLong(1, idPortaDelegata);
                ResultSet rsCorrApp = stmCorrApp.executeQuery();
                while (rsCorrApp.next()) {
                    if (corr == null) {
                        corr = new CorrelazioneApplicativa();
                    }
                    CorrelazioneApplicativaElemento cae = new CorrelazioneApplicativaElemento();
                    cae.setId(rsCorrApp.getLong("id"));
                    cae.setNome(rsCorrApp.getString("nome_elemento"));
                    String modeCA = rsCorrApp.getString("mode_correlazione");
                    cae.setIdentificazione(DriverConfigurazioneDB_LIB.getEnumCorrelazioneApplicativaRichiestaIdentificazione(modeCA));
                    if (modeCA.equals("urlBased") || modeCA.equals("contentBased")) {
                        cae.setPattern(rsCorrApp.getString("pattern"));
                    }
                    cae.setIdentificazioneFallita(DriverConfigurazioneDB_LIB.getEnumCorrelazioneApplicativaGestioneIdentificazioneFallita(rsCorrApp.getString("identificazione_fallita")));
                    cae.setRiusoIdentificativo(DriverConfigurazioneDB_LIB.getEnumStatoFunzionalita(rsCorrApp.getString("riuso_id")));
                    corr.addElemento(cae);
                }
                rsCorrApp.close();
                stmCorrApp.close();
                if (corr != null && scadenzaCorrelazione != null && !scadenzaCorrelazione.equals("")) {
                    corr.setScadenza(scadenzaCorrelazione);
                }
                pd.setCorrelazioneApplicativa(corr);
                CorrelazioneApplicativaRisposta corrApplRisposta = null;
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("pd_correlazione_risposta");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("id_porta=?");
                sqlQueryObject.addOrderBy("id");
                sqlQueryObject.setSortType(true);
                queryCorrApp = sqlQueryObject.createSQLQuery();
                stmCorrApp = con.prepareStatement(queryCorrApp);
                stmCorrApp.setLong(1, idPortaDelegata);
                rsCorrApp = stmCorrApp.executeQuery();
                while (rsCorrApp.next()) {
                    if (corrApplRisposta == null) {
                        corrApplRisposta = new CorrelazioneApplicativaRisposta();
                    }
                    CorrelazioneApplicativaRispostaElemento cae = new CorrelazioneApplicativaRispostaElemento();
                    cae.setId(rsCorrApp.getLong("id"));
                    cae.setNome(rsCorrApp.getString("nome_elemento"));
                    String modeCA = rsCorrApp.getString("mode_correlazione");
                    cae.setIdentificazione(DriverConfigurazioneDB_LIB.getEnumCorrelazioneApplicativaRispostaIdentificazione(modeCA));
                    if (modeCA.equals("urlBased") || modeCA.equals("contentBased")) {
                        cae.setPattern(rsCorrApp.getString("pattern"));
                    }
                    cae.setIdentificazioneFallita(DriverConfigurazioneDB_LIB.getEnumCorrelazioneApplicativaGestioneIdentificazioneFallita(rsCorrApp.getString("identificazione_fallita")));
                    corrApplRisposta.addElemento(cae);
                }
                rsCorrApp.close();
                stmCorrApp.close();
                pd.setCorrelazioneApplicativaRisposta(corrApplRisposta);
                MtomProcessor mtomProcessor = null;
                String mtom_request = rs.getString("mtom_request_mode");
                String mtom_response = rs.getString("mtom_response_mode");
                if (mtom_request != null && !mtom_request.equals("") || mtom_response != null && !mtom_response.equals("")) {
                    mtomProcessor = new MtomProcessor();
                    if (mtom_request != null && !mtom_request.equals("")) {
                        mtomProcessor.setRequestFlow(new MtomProcessorFlow());
                        mtomProcessor.getRequestFlow().setMode(DriverConfigurazioneDB_LIB.getEnumMTOMProcessorType(mtom_request));
                    }
                    if (mtom_response != null && !mtom_response.equals("")) {
                        mtomProcessor.setResponseFlow(new MtomProcessorFlow());
                        mtomProcessor.getResponseFlow().setMode(DriverConfigurazioneDB_LIB.getEnumMTOMProcessorType(mtom_response));
                    }
                }
                String validazioneContenuti_stato = rs.getString("validazione_contenuti_stato");
                String validazioneContenuti_tipo = rs.getString("validazione_contenuti_tipo");
                String validazioneContenuti_mtom = rs.getString("validazione_contenuti_mtom");
                if (validazioneContenuti_stato != null && !validazioneContenuti_stato.equals("") || validazioneContenuti_tipo != null && !validazioneContenuti_tipo.equals("")) {
                    ValidazioneContenutiApplicativi val = new ValidazioneContenutiApplicativi();
                    if (validazioneContenuti_stato != null && !validazioneContenuti_stato.equals("")) {
                        val.setStato(DriverConfigurazioneDB_LIB.getEnumStatoFunzionalitaConWarning(validazioneContenuti_stato));
                    }
                    if (validazioneContenuti_tipo != null && !validazioneContenuti_tipo.equals("")) {
                        val.setTipo(DriverConfigurazioneDB_LIB.getEnumValidazioneContenutiApplicativiTipo(validazioneContenuti_tipo));
                    }
                    if (validazioneContenuti_mtom != null && !validazioneContenuti_mtom.equals("")) {
                        val.setAcceptMtomMessage(DriverConfigurazioneDB_LIB.getEnumStatoFunzionalita(validazioneContenuti_mtom));
                    }
                    pd.setValidazioneContenutiApplicativi(val);
                }
                pd.setAllegaBody(DriverConfigurazioneDB_LIB.getEnumStatoFunzionalita(rs.getString("allega_body")));
                pd.setScartaBody(DriverConfigurazioneDB_LIB.getEnumStatoFunzionalita(rs.getString("scarta_body")));
                pd.setGestioneManifest(DriverConfigurazioneDB_LIB.getEnumStatoFunzionalita(rs.getString("gestione_manifest")));
                pd.setStateless(DriverConfigurazioneDB_LIB.getEnumStatoFunzionalita(rs.getString("stateless")));
                pd.setLocalForward(DriverConfigurazioneDB_LIB.getEnumStatoFunzionalita(rs.getString("local_forward")));
                if (rs.getString("stato") != null) {
                    pd.setStato(DriverConfigurazioneDB_LIB.getEnumStatoFunzionalita(rs.getString("stato")));
                }
                String ws_security = rs.getString("ws_security");
                String ws_security_mtom_req = rs.getString("ws_security_mtom_req");
                String ws_security_mtom_res = rs.getString("ws_security_mtom_res");
                MessageSecurity messageSecurity = null;
                if (ws_security_mtom_req != null && !ws_security_mtom_req.equals("") || ws_security_mtom_res != null && !ws_security_mtom_res.equals("")) {
                    messageSecurity = new MessageSecurity();
                    if (ws_security_mtom_req != null && !ws_security_mtom_req.equals("")) {
                        messageSecurity.setRequestFlow(new MessageSecurityFlow());
                        messageSecurity.getRequestFlow().setApplyToMtom(DriverConfigurazioneDB_LIB.getEnumStatoFunzionalita(ws_security_mtom_req));
                    }
                    if (ws_security_mtom_res != null && !ws_security_mtom_res.equals("")) {
                        messageSecurity.setResponseFlow(new MessageSecurityFlow());
                        messageSecurity.getResponseFlow().setApplyToMtom(DriverConfigurazioneDB_LIB.getEnumStatoFunzionalita(ws_security_mtom_res));
                    }
                }
                if ((ruoliMatch = rs.getString("ruoli_match")) != null && !"".equals(ruoliMatch)) {
                    if (pd.getRuoli() == null) {
                        pd.setRuoli(new AutorizzazioneRuoli());
                    }
                    pd.getRuoli().setMatch(RuoloTipoMatch.toEnumConstant(ruoliMatch));
                }
                rs.close();
                stm.close();
                if (CostantiConfigurazione.ABILITATO.toString().equalsIgnoreCase(ws_security)) {
                    pd.setStatoMessageSecurity(CostantiConfigurazione.ABILITATO.toString());
                } else {
                    pd.setStatoMessageSecurity(CostantiConfigurazione.DISABILITATO.toString());
                }
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("pd_ws_request");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("id_porta=?");
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm = con.prepareStatement(sqlQuery);
                stm.setLong(1, idPortaDelegata);
                this.log.debug("eseguo query : " + DBUtils.formatSQLString(sqlQuery, idPortaDelegata));
                rs = stm.executeQuery();
                while (rs.next()) {
                    MessageSecurityFlowParameter secRfp = new MessageSecurityFlowParameter();
                    secRfp.setNome(rs.getString("nome"));
                    secRfp.setValore(rs.getString("valore"));
                    if (messageSecurity == null) {
                        messageSecurity = new MessageSecurity();
                    }
                    if (messageSecurity.getRequestFlow() == null) {
                        messageSecurity.setRequestFlow(new MessageSecurityFlow());
                    }
                    messageSecurity.getRequestFlow().addParameter(secRfp);
                }
                rs.close();
                stm.close();
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("pd_ws_response");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("id_porta=?");
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm = con.prepareStatement(sqlQuery);
                stm.setLong(1, idPortaDelegata);
                this.log.debug("eseguo query : " + DBUtils.formatSQLString(sqlQuery, idPortaDelegata));
                rs = stm.executeQuery();
                while (rs.next()) {
                    MessageSecurityFlowParameter secResfp = new MessageSecurityFlowParameter();
                    secResfp.setNome(rs.getString("nome"));
                    secResfp.setValore(rs.getString("valore"));
                    if (messageSecurity == null) {
                        messageSecurity = new MessageSecurity();
                    }
                    if (messageSecurity.getResponseFlow() == null) {
                        messageSecurity.setResponseFlow(new MessageSecurityFlow());
                    }
                    messageSecurity.getResponseFlow().addParameter(secResfp);
                }
                rs.close();
                stm.close();
                pd.setMessageSecurity(messageSecurity);
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("pd_mtom_request");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("id_porta=?");
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm1 = con.prepareStatement(sqlQuery);
                stm1.setLong(1, idPortaDelegata);
                this.log.debug("eseguo query : " + DBUtils.formatSQLString(sqlQuery, idPortaDelegata));
                rs1 = stm1.executeQuery();
                while (rs1.next()) {
                    MtomProcessorFlowParameter rfp = new MtomProcessorFlowParameter();
                    rfp.setNome(rs1.getString("nome"));
                    rfp.setPattern(rs1.getString("pattern"));
                    rfp.setContentType(rs1.getString("content_type"));
                    int required = rs1.getInt("required");
                    boolean isrequired = false;
                    if (required == 1) {
                        isrequired = true;
                    }
                    rfp.setRequired(isrequired);
                    if (mtomProcessor.getRequestFlow() == null) {
                        mtomProcessor.setRequestFlow(new MtomProcessorFlow());
                    }
                    mtomProcessor.getRequestFlow().addParameter(rfp);
                }
                rs1.close();
                stm1.close();
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("pd_mtom_response");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("id_porta=?");
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm1 = con.prepareStatement(sqlQuery);
                stm1.setLong(1, idPortaDelegata);
                this.log.debug("eseguo query : " + DBUtils.formatSQLString(sqlQuery, idPortaDelegata));
                rs1 = stm1.executeQuery();
                while (rs1.next()) {
                    MtomProcessorFlowParameter rsfp = new MtomProcessorFlowParameter();
                    rsfp.setNome(rs1.getString("nome"));
                    rsfp.setPattern(rs1.getString("pattern"));
                    rsfp.setContentType(rs1.getString("content_type"));
                    int required = rs1.getInt("required");
                    boolean isrequired = false;
                    if (required == 1) {
                        isrequired = true;
                    }
                    rsfp.setRequired(isrequired);
                    if (mtomProcessor.getResponseFlow() == null) {
                        mtomProcessor.setResponseFlow(new MtomProcessorFlow());
                    }
                    mtomProcessor.getResponseFlow().addParameter(rsfp);
                }
                rs1.close();
                stm1.close();
                pd.setMtomProcessor(mtomProcessor);
                long idSA = 0L;
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("porte_delegate_sa");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("id_porta=?");
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm = con.prepareStatement(sqlQuery);
                stm.setLong(1, idPortaDelegata);
                rs = stm.executeQuery();
                while (rs.next()) {
                    idSA = rs.getLong("id_servizio_applicativo");
                    if (idSA == 0L) continue;
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                    sqlQueryObject.addFromTable("servizi_applicativi");
                    sqlQueryObject.addSelectField("nome");
                    sqlQueryObject.addWhereCondition("id=?");
                    sqlQuery = sqlQueryObject.createSQLQuery();
                    stm1 = con.prepareStatement(sqlQuery);
                    stm1.setLong(1, idSA);
                    this.log.debug("eseguo query : " + DBUtils.formatSQLString(sqlQuery, idSA));
                    rs1 = stm1.executeQuery();
                    ServizioApplicativo servizioApplicativo = null;
                    if (rs1.next()) {
                        servizioApplicativo = new ServizioApplicativo();
                        servizioApplicativo.setId(idSA);
                        servizioApplicativo.setNome(rs1.getString("nome"));
                        pd.addServizioApplicativo(servizioApplicativo);
                    }
                    rs1.close();
                    stm1.close();
                }
                rs.close();
                stm.close();
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("pd_ruoli");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("id_porta=?");
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm = con.prepareStatement(sqlQuery);
                stm.setLong(1, idPortaDelegata);
                rs = stm.executeQuery();
                while (rs.next()) {
                    if (pd.getRuoli() == null) {
                        pd.setRuoli(new AutorizzazioneRuoli());
                    }
                    Ruolo ruolo = new Ruolo();
                    ruolo.setNome(rs.getString("ruolo"));
                    pd.getRuoli().addRuolo(ruolo);
                }
                rs.close();
                stm.close();
                this.log.debug("ExtendedInfo ...");
                ExtendedInfoManager extInfoManager = ExtendedInfoManager.getInstance();
                IExtendedInfo extInfoConfigurazioneDriver = extInfoManager.newInstanceExtendedInfoPortaDelegata();
                if (extInfoConfigurazioneDriver != null && (listExtInfo = extInfoConfigurazioneDriver.getAllExtendedInfo(con, this.log, pd)) != null && listExtInfo.size() > 0) {
                    for (Object object : listExtInfo) {
                        pd.addExtendedInfo(object);
                    }
                }
            } else {
                throw new DriverConfigurazioneNotFound("[DriverConfigurazioneDB::getPortaDelegata] Nessuna PortaDelegata trovata.");
            }
            PortaDelegata portaDelegata = pd;
            return portaDelegata;
        }
        catch (SQLException se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getPortaDelegata] SqlException: " + se.getMessage(), se);
        }
        catch (DriverConfigurazioneNotFound de) {
            throw de;
        }
        catch (Exception se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getPortaDelegata] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
                if (rs1 != null) {
                    rs1.close();
                }
                if (stm1 != null) {
                    stm1.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (conParam == null && this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public ServizioApplicativo getServizioApplicativo(long idServizioApplicativo) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.getServizioApplicativo(5, null, null, null, null, null, null, idServizioApplicativo);
    }

    public List<String> servizioApplicativoRuoliList(long idSA, ISearch ricerca) throws DriverConfigurazioneException {
        String nomeMetodo = "servizioApplicativoRuoliList";
        int idLista = 29;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        boolean error = false;
        Statement stmt = null;
        ResultSet risultato = null;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource(nomeMetodo);
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        ArrayList<String> listIdRuoli = null;
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("servizi_applicativi");
                sqlQueryObject.addFromTable("sa_ruoli");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("servizi_applicativi.id=?");
                sqlQueryObject.addWhereCondition("servizi_applicativi.id=sa_ruoli.id_servizio_applicativo");
                sqlQueryObject.addWhereLikeCondition("sa_ruoli.ruolo", search, true, true);
                sqlQueryObject.setSelectDistinct(true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("servizi_applicativi");
                sqlQueryObject.addFromTable("sa_ruoli");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("servizi_applicativi.id=?");
                sqlQueryObject.addWhereCondition("servizi_applicativi.id=sa_ruoli.id_servizio_applicativo");
                sqlQueryObject.setSelectDistinct(true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idSA);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("servizi_applicativi");
                sqlQueryObject.addFromTable("sa_ruoli");
                sqlQueryObject.addSelectField("sa_ruoli.ruolo");
                sqlQueryObject.addWhereCondition("servizi_applicativi.id=?");
                sqlQueryObject.addWhereCondition("servizi_applicativi.id=sa_ruoli.id_servizio_applicativo");
                sqlQueryObject.addWhereLikeCondition("sa_ruoli.ruolo", search, true, true);
                sqlQueryObject.setSelectDistinct(true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("sa_ruoli.ruolo");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("servizi_applicativi");
                sqlQueryObject.addFromTable("sa_ruoli");
                sqlQueryObject.addSelectField("sa_ruoli.ruolo");
                sqlQueryObject.addWhereCondition("servizi_applicativi.id=?");
                sqlQueryObject.addWhereCondition("servizi_applicativi.id=sa_ruoli.id_servizio_applicativo");
                sqlQueryObject.setSelectDistinct(true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("sa_ruoli.ruolo");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idSA);
            risultato = stmt.executeQuery();
            listIdRuoli = new ArrayList<String>();
            while (risultato.next()) {
                listIdRuoli.add(risultato.getString(1));
            }
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
        return listIdRuoli;
    }

    @Override
    public void reset() throws DriverConfigurazioneException {
        this.reset(true);
    }

    @Override
    public void reset(boolean resetConfigurazione) throws DriverConfigurazioneException {
        Connection con = null;
        boolean error = false;
        Statement stmt = null;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("reset");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::reset] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("pa_ruoli");
            String updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("porte_applicative_sa");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("pa_properties");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("pa_ws_request");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("pa_ws_response");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("pa_correlazione");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("pa_correlazione_risposta");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("porte_applicative");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("pd_ruoli");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("porte_delegate_sa");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("pd_ws_request");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("pd_ws_response");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("pd_correlazione");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("pd_correlazione_risposta");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("porte_delegate");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("sa_ruoli");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("servizi_applicativi");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable(this.tabellaSoggetti);
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("connettori_custom");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("connettori");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("gestione_errore_soap");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("gestione_errore_trasporto");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("gestione_errore");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            if (resetConfigurazione) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addDeleteTable("registri");
                updateString = sqlQueryObject.createSQLDelete();
                stmt = con.prepareStatement(updateString);
                stmt.executeUpdate();
                stmt.close();
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addDeleteTable("routing");
                sqlQueryObject.addWhereCondition(true, true, "tiporotta='registro'", "registrorotta=0", "is_default=1");
                updateString = sqlQueryObject.createSQLDelete();
                stmt = con.prepareStatement(updateString);
                stmt.executeUpdate();
                stmt.close();
            }
        }
        catch (SQLException qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::updateSoggetto] Errore durante la reset : " + qe.getMessage(), qe);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::updateSoggetto] Errore durante la reset : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void resetCtrlstat() throws DriverConfigurazioneException {
        Connection con = null;
        boolean error = false;
        Statement stmt = null;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("resetCtrlstat");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::resetCtrlstat] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("mapping_erogazione_pa");
            String updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("mapping_fruizione_pd");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("servizi_fruitori");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("servizi");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
        }
        catch (SQLException qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::resetCtrlstat] Errore durante la reset : " + qe.getMessage(), qe);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::resetCtrlstat] Errore durante la reset : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public boolean existsPortaApplicativaVirtuale(IDPortaApplicativa idPA, IDSoggetto soggettoVirtuale) throws DriverConfigurazioneException {
        try {
            return this.getPortaApplicativaVirtuale(idPA, soggettoVirtuale) != null;
        }
        catch (DriverConfigurazioneNotFound e) {
            return false;
        }
    }

    @Override
    public boolean existsPortaApplicativaVirtuale(IDPortaApplicativa idPA, IDSoggetto soggettoVirtuale, boolean ricercaPuntuale) throws DriverConfigurazioneException {
        try {
            return this.getPortaApplicativaVirtuale(idPA, soggettoVirtuale, ricercaPuntuale) != null;
        }
        catch (DriverConfigurazioneNotFound e) {
            return false;
        }
    }

    @Override
    public boolean existsPortaApplicativa(IDPortaApplicativa idPA, boolean ricercaPuntuale) throws DriverConfigurazioneException {
        try {
            return this.getPortaApplicativa(idPA, ricercaPuntuale) != null;
        }
        catch (DriverConfigurazioneNotFound e) {
            return false;
        }
    }

    @Override
    public boolean existsPortaApplicativa(IDPortaApplicativa idPA) throws DriverConfigurazioneException {
        try {
            return this.getPortaApplicativa(idPA) != null;
        }
        catch (DriverConfigurazioneNotFound e) {
            return false;
        }
    }

    public boolean existsPortaApplicativaServizioApplicativo(Long idServizioApplicativo) throws DriverConfigurazioneException {
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        String sqlQuery = "";
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("existsPortaApplicativaServizioApplicativo");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::existsPortaApplicativaServizioApplicativo] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        try {
            boolean esiste = false;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("porte_applicative_sa");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_servizio_applicativo=?");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idServizioApplicativo);
            this.log.debug("eseguo query : " + DBUtils.formatSQLString(sqlQuery, idServizioApplicativo));
            rs = stm.executeQuery();
            if (rs.next()) {
                esiste = true;
            }
            rs.close();
            stm.close();
            boolean bl = esiste;
            return bl;
        }
        catch (Exception qe) {
            throw new DriverConfigurazioneException(qe);
        }
        finally {
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public boolean existsPortaApplicativaSoggetto(Long idSoggetto) throws DriverConfigurazioneException {
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        String sqlQuery = "";
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("existsPortaApplicativaSoggetto");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::existsPortaApplicativaSoggetto] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        try {
            boolean esiste = false;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("porte_applicative");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_soggetto=?");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idSoggetto);
            this.log.debug("eseguo query : " + DBUtils.formatSQLString(sqlQuery, idSoggetto));
            rs = stm.executeQuery();
            if (rs.next()) {
                esiste = true;
            }
            rs.close();
            stm.close();
            boolean bl = esiste;
            return bl;
        }
        catch (Exception qe) {
            throw new DriverConfigurazioneException(qe);
        }
        finally {
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<PortaApplicativa> getPorteApplicativeWithServizio(Long idServizio, String tiposervizio, String nomeservizio, Long idSoggetto, String tiposoggetto, String nomesoggetto) throws DriverConfigurazioneException {
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        String sqlQuery = "";
        ArrayList<PortaApplicativa> lista = new ArrayList<PortaApplicativa>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("getPorteApplicativeWithServizio");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getPorteApplicativeWithServizio] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("porte_applicative");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition(false, "id_servizio = ?", "tipo_servizio = ? AND servizio = ?");
            sqlQueryObject.addWhereCondition(false, "id_soggetto = ?", "id_soggetto_virtuale = ?", "tipo_soggetto_virtuale = ? AND nome_soggetto_virtuale = ?");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idServizio);
            stm.setString(2, tiposervizio);
            stm.setString(3, nomeservizio);
            stm.setLong(4, idSoggetto);
            stm.setLong(5, idSoggetto);
            stm.setString(6, tiposoggetto);
            stm.setString(7, nomesoggetto);
            this.log.debug("eseguo query : " + DBUtils.formatSQLString(sqlQuery, idServizio, tiposervizio, nomeservizio, idSoggetto, idSoggetto, tiposoggetto, nomesoggetto));
            rs = stm.executeQuery();
            while (rs.next()) {
                PortaApplicativa pa = new PortaApplicativa();
                pa.setNome(rs.getString("nome_porta"));
                lista.add(pa);
            }
            rs.close();
            stm.close();
            ArrayList<PortaApplicativa> arrayList = lista;
            return arrayList;
        }
        catch (Exception qe) {
            throw new DriverConfigurazioneException(qe);
        }
        finally {
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public PortaApplicativa getPortaApplicativaWithSoggettoAndServizio(String nome, Long idSoggetto, Long idServizio, String tipoServizio, String nomeServizio) throws DriverConfigurazioneException {
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        String sqlQuery = "";
        PortaApplicativa pa = new PortaApplicativa();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("getPortaApplicativaWithSoggettoAndServizio");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getPorteApplicativeWithSoggettoAndServizio] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("porte_applicative");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("nome_porta = ?");
            sqlQueryObject.addWhereCondition(false, "id_soggetto = ? AND tipo_servizio = ? AND servizio=? AND id_soggetto_virtuale <= ?", "id_soggetto = ? AND id_servizio = ? AND id_soggetto_virtuale <= ?", "id_soggetto_virtuale = ? AND tipo_servizio = ? AND servizio=?", "id_soggetto_virtuale = ? AND id_servizio = ?");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setString(1, nome);
            stm.setLong(2, idSoggetto);
            stm.setString(3, tipoServizio);
            stm.setString(4, nomeServizio);
            stm.setLong(5, 0L);
            stm.setLong(6, idSoggetto);
            stm.setLong(7, idServizio);
            stm.setLong(8, 0L);
            stm.setLong(9, idSoggetto);
            stm.setString(10, tipoServizio);
            stm.setString(11, nomeServizio);
            stm.setLong(12, idSoggetto);
            stm.setLong(13, idServizio);
            this.log.debug("eseguo query : " + DBUtils.formatSQLString(sqlQuery, idSoggetto, idServizio, -1, idSoggetto, idServizio));
            rs = stm.executeQuery();
            if (!rs.next()) {
                throw new Exception("PA non trovata [" + DBUtils.formatSQLString(sqlQuery, idSoggetto, idServizio, -1, idSoggetto, idServizio) + "]");
            }
            Soggetto sogg = this.getSoggetto(rs.getLong("id_soggetto"));
            pa.setId(rs.getLong("id"));
            pa.setNome(rs.getString("nome_porta"));
            pa.setIdSoggetto(rs.getLong("id_soggetto"));
            pa.setNomeSoggettoProprietario(sogg.getNome());
            pa.setTipoSoggettoProprietario(sogg.getTipo());
            rs.close();
            stm.close();
            PortaApplicativa portaApplicativa = pa;
            return portaApplicativa;
        }
        catch (Exception qe) {
            throw new DriverConfigurazioneException(qe);
        }
        finally {
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public Vector<IDPortaApplicativaByNome> getPortaApplicativaAzione(String nome) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        String sqlQuery = "";
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("getPortaApplicativaAzione");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::existsPortaApplicativaAzione] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        Vector<IDPortaApplicativaByNome> id = new Vector<IDPortaApplicativaByNome>();
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("porte_applicative");
            sqlQueryObject.addFromTable(this.tabellaSoggetti);
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addWhereCondition("azione=?");
            sqlQueryObject.addWhereCondition("porte_applicative.id_soggetto=" + this.tabellaSoggetti + ".id");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setString(1, nome);
            this.log.debug("eseguo query : " + DBUtils.formatSQLString(sqlQuery, nome));
            rs = stm.executeQuery();
            while (rs.next()) {
                IDPortaApplicativaByNome idPA = new IDPortaApplicativaByNome();
                idPA.setSoggetto(new IDSoggetto(rs.getString("tipo_soggetto"), rs.getString("nome_soggetto")));
                idPA.setNome(rs.getString("nome_porta"));
                id.add(idPA);
            }
            rs.close();
            stm.close();
        }
        catch (Exception qe) {
            throw new DriverConfigurazioneException(qe);
        }
        finally {
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
        if (id.size() > 0) {
            return id;
        }
        throw new DriverConfigurazioneNotFound("Porte Applicative che possiedono l'azione [" + nome + "] non esistenti");
    }

    public boolean existsPortaApplicativaAzione(String nome) throws DriverConfigurazioneException {
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        String sqlQuery = "";
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("existsPortaApplicativaAzione");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::existsPortaApplicativaAzione] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        try {
            boolean esiste = false;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("porte_applicative");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("azione=?");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setString(1, nome);
            this.log.debug("eseguo query : " + DBUtils.formatSQLString(sqlQuery, nome));
            rs = stm.executeQuery();
            if (rs.next()) {
                esiste = true;
            }
            rs.close();
            stm.close();
            boolean bl = esiste;
            return bl;
        }
        catch (Exception qe) {
            throw new DriverConfigurazioneException(qe);
        }
        finally {
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public boolean existsPortaDelegata(IDPortaDelegata idPD) throws DriverConfigurazioneException {
        try {
            return this.getPortaDelegata(idPD) != null;
        }
        catch (DriverConfigurazioneNotFound e) {
            return false;
        }
    }

    public boolean existsPortaDelegataServizioApplicativo(Long idServizioApplicativo) throws DriverConfigurazioneException {
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        String sqlQuery = "";
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("existsPortaDelegataServizioApplicativo");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::existsPortaDelegataServizioApplicativo] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        try {
            boolean esiste = false;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("porte_delegate_sa");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_servizio_applicativo=?");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idServizioApplicativo);
            this.log.debug("eseguo query : " + DBUtils.formatSQLString(sqlQuery, idServizioApplicativo));
            rs = stm.executeQuery();
            if (rs.next()) {
                esiste = true;
            }
            rs.close();
            stm.close();
            boolean bl = esiste;
            return bl;
        }
        catch (Exception qe) {
            throw new DriverConfigurazioneException(qe);
        }
        finally {
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public boolean existsPortaDelegataSoggetto(Long idSoggetto) throws DriverConfigurazioneException {
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        String sqlQuery = "";
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("existsPortaDelegataSoggetto");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::existsPortaDelegataSoggetto] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        try {
            boolean esiste = false;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("porte_delegate");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_soggetto=?");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idSoggetto);
            this.log.debug("eseguo query : " + DBUtils.formatSQLString(sqlQuery, idSoggetto));
            rs = stm.executeQuery();
            if (rs.next()) {
                esiste = true;
            }
            rs.close();
            stm.close();
            boolean bl = esiste;
            return bl;
        }
        catch (Exception qe) {
            throw new DriverConfigurazioneException(qe);
        }
        finally {
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<PortaDelegata> getPorteDelegateWithServizio(Long idServizio, String tiposervizio, String nomeservizio, Long idSoggetto, String tiposoggetto, String nomesoggetto) throws DriverConfigurazioneException {
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        String sqlQuery = "";
        ArrayList<PortaDelegata> lista = new ArrayList<PortaDelegata>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("getPorteDelegateWithServizio");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getPorteDelegateWithServizio] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("porte_delegate");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition(false, "id_servizio = ?", "tipo_servizio = ? AND nome_servizio = ?");
            sqlQueryObject.addWhereCondition(false, "id_soggetto_erogatore = ?", "tipo_soggetto_erogatore = ? AND nome_soggetto_erogatore = ?");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idServizio);
            stm.setString(2, tiposervizio);
            stm.setString(3, nomeservizio);
            stm.setLong(4, idSoggetto);
            stm.setString(5, tiposoggetto);
            stm.setString(6, nomesoggetto);
            this.log.debug("eseguo query : " + DBUtils.formatSQLString(sqlQuery, idServizio, tiposervizio, nomeservizio, idSoggetto, tiposoggetto, nomesoggetto));
            rs = stm.executeQuery();
            while (rs.next()) {
                lista.add(this.getPortaDelegata(rs.getLong("id")));
            }
            rs.close();
            stm.close();
            ArrayList<PortaDelegata> arrayList = lista;
            return arrayList;
        }
        catch (Exception qe) {
            throw new DriverConfigurazioneException(qe);
        }
        finally {
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<PortaDelegata> getPorteDelegateWithServizio(Long idServizio) throws DriverConfigurazioneException {
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        String sqlQuery = "";
        ArrayList<PortaDelegata> lista = new ArrayList<PortaDelegata>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("getPorteDelegateWithServizio");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getPorteDelegateWithServizio] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("porte_delegate");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_servizio = ?");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idServizio);
            this.log.debug("eseguo query : " + DBUtils.formatSQLString(sqlQuery, idServizio));
            rs = stm.executeQuery();
            while (rs.next()) {
                PortaDelegata pde = this.getPortaDelegata(rs.getLong("id"));
                lista.add(pde);
            }
            rs.close();
            stm.close();
            ArrayList<PortaDelegata> arrayList = lista;
            return arrayList;
        }
        catch (Exception qe) {
            throw new DriverConfigurazioneException(qe);
        }
        finally {
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<ServizioApplicativo> getServiziApplicativiWithIdErogatore(Long idErogatore) throws DriverConfigurazioneException {
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        String sqlQuery = "";
        ArrayList<ServizioApplicativo> lista = new ArrayList<ServizioApplicativo>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("getServiziApplicativiWithIdErogatore");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getServiziApplicativiWithIdErogatore] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("servizi_applicativi");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_soggetto = ?");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idErogatore);
            this.log.debug("eseguo query : " + DBUtils.formatSQLString(sqlQuery, idErogatore));
            rs = stm.executeQuery();
            while (rs.next()) {
                ServizioApplicativo sa = this.getServizioApplicativo(rs.getLong("id"));
                lista.add(sa);
            }
            rs.close();
            stm.close();
            ArrayList<ServizioApplicativo> arrayList = lista;
            return arrayList;
        }
        catch (Exception qe) {
            throw new DriverConfigurazioneException(qe);
        }
        finally {
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public Vector<IDPortaDelegata> getPortaDelegataAzione(String nome) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        String sqlQuery = "";
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("getPortaDelegataAzione");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::existsPortaApplicativaAzione] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        Vector<IDPortaDelegata> id = new Vector<IDPortaDelegata>();
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("porte_delegate");
            sqlQueryObject.addFromTable(this.tabellaSoggetti);
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addWhereCondition("nome_azione=?");
            sqlQueryObject.addWhereCondition("porte_delegate.id_soggetto=" + this.tabellaSoggetti + ".id");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setString(1, nome);
            this.log.debug("eseguo query : " + DBUtils.formatSQLString(sqlQuery, nome));
            rs = stm.executeQuery();
            while (rs.next()) {
                IDPortaDelegata idPD = new IDPortaDelegata();
                idPD.setLocationPD(rs.getString("nome_porta"));
                idPD.setSoggettoFruitore(new IDSoggetto(rs.getString("tipo_soggetto"), rs.getString("nome_soggetto")));
                id.add(idPD);
            }
            rs.close();
            stm.close();
        }
        catch (Exception qe) {
            throw new DriverConfigurazioneException(qe);
        }
        finally {
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
        if (id.size() > 0) {
            return id;
        }
        throw new DriverConfigurazioneNotFound("Porte Delegate che possiedono l'azione [" + nome + "] non esistenti");
    }

    public boolean existsPortaDelegataAzione(String nome) throws DriverConfigurazioneException {
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        String sqlQuery = "";
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("existsPortaDelegataAzione");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::existsPortaDelegataAzione] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        try {
            boolean esiste = false;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("porte_delegate");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("nome_azione=?");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setString(1, nome);
            this.log.debug("eseguo query : " + DBUtils.formatSQLString(sqlQuery, nome));
            rs = stm.executeQuery();
            if (rs.next()) {
                esiste = true;
            }
            rs.close();
            stm.close();
            boolean bl = esiste;
            return bl;
        }
        catch (Exception qe) {
            throw new DriverConfigurazioneException(qe);
        }
        finally {
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public boolean existsServizioApplicativo(IDSoggetto idSoggetto, String nomeServizioApplicativo) throws DriverConfigurazioneException {
        IDServizioApplicativo idServizioApplicativo = new IDServizioApplicativo();
        idServizioApplicativo.setIdSoggettoProprietario(idSoggetto);
        idServizioApplicativo.setNome(nomeServizioApplicativo);
        return this.existsServizioApplicativo(idServizioApplicativo);
    }

    @Override
    public boolean existsServizioApplicativo(IDServizioApplicativo idServizioApplicativo) throws DriverConfigurazioneException {
        IDSoggetto idSoggetto = idServizioApplicativo.getIdSoggettoProprietario();
        if (idSoggetto == null) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::existsServizioApplicativo] Soggetto Fruitore non Impostato.");
        }
        if (idServizioApplicativo.getNome() == null || "".equals(idServizioApplicativo.getNome())) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::existsServizioApplicativo] Nome Servizio Applicativo non Impostato.");
        }
        if (idSoggetto.getNome() == null || "".equals(idSoggetto.getNome())) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::existsServizioApplicativo] Nome Soggetto Fruitore non Impostato.");
        }
        if (idSoggetto.getTipo() == null || "".equals(idSoggetto.getTipo())) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::existsServizioApplicativo] Nome Soggetto Fruitore non Impostato.");
        }
        Connection con = null;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("existsServizioApplicativo");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::createAccessoRegistro] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        try {
            boolean e = DriverConfigurazioneDB_LIB.getIdServizioApplicativo(idServizioApplicativo.getNome(), idSoggetto.getTipo(), idSoggetto.getNome(), con, this.tipoDB, this.tabellaSoggetti) > 0L;
            return e;
        }
        catch (Exception qe) {
            throw new DriverConfigurazioneException(qe);
        }
        finally {
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public long getIdServizioApplicativo(IDSoggetto idSoggetto, String nomeServizioApplicativo) throws DriverConfigurazioneException {
        if (idSoggetto == null) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getServizioApplicativo] Soggetto Fruitore non Impostato.");
        }
        if (nomeServizioApplicativo == null || "".equals(nomeServizioApplicativo)) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getServizioApplicativo] Nome Servizio Applicativo non Impostato.");
        }
        if (idSoggetto.getNome() == null || "".equals(idSoggetto.getNome())) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getServizioApplicativo] Nome Soggetto Fruitore non Impostato.");
        }
        if (idSoggetto.getTipo() == null || "".equals(idSoggetto.getTipo())) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getServizioApplicativo] Nome Soggetto Fruitore non Impostato.");
        }
        Connection con = null;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("getIdServizioApplicativo");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getServizioApplicativo] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        try {
            long e = DriverConfigurazioneDB_LIB.getIdServizioApplicativo(nomeServizioApplicativo, idSoggetto.getTipo(), idSoggetto.getNome(), con, this.tipoDB, this.tabellaSoggetti);
            return e;
        }
        catch (Exception qe) {
            throw new DriverConfigurazioneException(qe);
        }
        finally {
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public boolean existsServizioApplicativoSoggetto(Long idSoggetto) throws DriverConfigurazioneException {
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        String sqlQuery = "";
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("existsServizioApplicativoSoggetto");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::existsServizioApplicativoSoggetto] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        try {
            boolean esiste = false;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("servizi_applicativi");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_soggetto=?");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idSoggetto);
            this.log.debug("eseguo query : " + DBUtils.formatSQLString(sqlQuery, idSoggetto));
            rs = stm.executeQuery();
            if (rs.next()) {
                esiste = true;
            }
            rs.close();
            stm.close();
            boolean bl = esiste;
            return bl;
        }
        catch (Exception qe) {
            throw new DriverConfigurazioneException(qe);
        }
        finally {
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public boolean existsSoggetto(IDSoggetto idSoggetto) throws DriverConfigurazioneException {
        if (idSoggetto == null) {
            throw new DriverConfigurazioneException("[existsSoggetto::existsSoggetto] Soggetto non Impostato.");
        }
        if (idSoggetto.getNome() == null || "".equals(idSoggetto.getNome())) {
            throw new DriverConfigurazioneException("[existsSoggetto::existsServizioApplicativo] Nome Soggetto non Impostato.");
        }
        if (idSoggetto.getTipo() == null || "".equals(idSoggetto.getTipo())) {
            throw new DriverConfigurazioneException("[existsSoggetto::existsServizioApplicativo] Nome Soggetto non Impostato.");
        }
        Connection con = null;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("existsSoggetto");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::existsSoggetto] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        try {
            boolean e = DBUtils.getIdSoggetto(idSoggetto.getNome(), idSoggetto.getTipo(), con, this.tipoDB, this.tabellaSoggetti) > 0L;
            return e;
        }
        catch (Exception qe) {
            throw new DriverConfigurazioneException(qe);
        }
        finally {
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public boolean isServizioApplicativoInUso(ServizioApplicativo sa, Map<ErrorsHandlerCostant, String> whereIsInUso) throws DriverConfigurazioneException {
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("isServizioApplicativoInUso");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::isServizioApplicativoInUso] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        try {
            ArrayList<String> nomiPorteApplicative = new ArrayList<String>();
            boolean isInUso = false;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("porte_applicative_sa");
            sqlQueryObject.addFromTable("porte_applicative");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("porte_applicative_sa.id_servizio_applicativo = ?");
            sqlQueryObject.addWhereCondition("porte_applicative_sa.id_porta = porte_applicative.id");
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, sa.getId());
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                isInUso = true;
                nomiPorteApplicative.add(risultato.getString("nome_porta"));
            }
            risultato.close();
            stmt.close();
            if (isInUso) {
                if (whereIsInUso == null) {
                    whereIsInUso = new HashMap<ErrorsHandlerCostant, String>();
                }
                whereIsInUso.put(ErrorsHandlerCostant.IN_USO_IN_PORTE_APPLICATIVE, nomiPorteApplicative.toString());
            }
            boolean bl = isInUso;
            return bl;
        }
        catch (Exception qe) {
            throw new DriverConfigurazioneException(qe);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public boolean isInUso(ServizioApplicativo sa, Map<ErrorsHandlerCostant, ArrayList<?>> whereIsInUso) throws DriverConfigurazioneException {
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("isInUso(servizioApplicativo)");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::isServizioApplicativoInUso] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        try {
            ArrayList<IDPortaApplicativa> idsPA = new ArrayList<IDPortaApplicativa>();
            ArrayList<IDPortaDelegata> idsPD = new ArrayList<IDPortaDelegata>();
            boolean isInUso = false;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("porte_applicative_sa");
            sqlQueryObject.addFromTable("porte_applicative");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("porte_applicative_sa.id_servizio_applicativo = ?");
            sqlQueryObject.addWhereCondition("porte_applicative_sa.id_porta = porte_applicative.id");
            sqlQueryObject.addWhereCondition("porte_applicative.id_soggetto = soggetti.id");
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, sa.getId());
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                isInUso = true;
                IDPortaApplicativa idPA = new IDPortaApplicativa();
                IDServizio idSE = new IDServizio();
                idSE.setAzione(risultato.getString("azione"));
                idSE.setServizio(risultato.getString("servizio"));
                idSE.setTipoServizio(risultato.getString("tipo_servizio"));
                idSE.setSoggettoErogatore(risultato.getString("tipo_soggetto"), risultato.getString("nome_soggetto"));
                idPA.setIDServizio(idSE);
                idsPA.add(idPA);
            }
            risultato.close();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("porte_delegate_sa");
            sqlQueryObject.addFromTable("porte_delegate");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("porte_delegate_sa.id_servizio_applicativo = ?");
            sqlQueryObject.addWhereCondition("porte_delegate_sa.id_porta = porte_delegate.id");
            sqlQueryObject.addWhereCondition("porte_delegate.id_soggetto = soggetti.id");
            sqlQueryObject.setANDLogicOperator(true);
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, sa.getId());
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                isInUso = true;
                IDPortaDelegata idPD = new IDPortaDelegata();
                idPD.setSoggettoFruitore(new IDSoggetto(risultato.getString("tipo_soggetto"), risultato.getString("nome_soggetto")));
                String location = risultato.getString("location");
                if (location == null || "".equals(location)) {
                    location = risultato.getString("nome_porta");
                }
                idPD.setLocationPD(location);
                idsPD.add(idPD);
            }
            risultato.close();
            stmt.close();
            if (isInUso) {
                if (whereIsInUso == null) {
                    whereIsInUso = new HashMap();
                }
                if (idsPA.size() > 0) {
                    whereIsInUso.put(ErrorsHandlerCostant.IN_USO_IN_PORTE_APPLICATIVE, idsPA);
                }
                if (idsPD.size() > 0) {
                    whereIsInUso.put(ErrorsHandlerCostant.IN_USO_IN_PORTE_DELEGATE, idsPD);
                }
            }
            boolean bl = isInUso;
            return bl;
        }
        catch (Exception qe) {
            throw new DriverConfigurazioneException(qe);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void isAlive() throws CoreException {
        if (!this.create) {
            throw new CoreException("Driver non inizializzato");
        }
        if (this.atomica) {
            Connection con = null;
            Statement stmtTest = null;
            try {
                con = this.getConnectionFromDatasource("isAlive");
                if (con == null) {
                    throw new Exception("Connessione is null");
                }
                stmtTest = con.createStatement();
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("db_info");
                sqlQueryObject.addSelectField("*");
                String sqlQuery = sqlQueryObject.createSQLQuery();
                stmtTest.execute(sqlQuery);
            }
            catch (Exception e) {
                throw new CoreException("Connessione alla configurazione non disponibile: " + e.getMessage(), e);
            }
            finally {
                try {
                    if (stmtTest != null) {
                        stmtTest.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (con != null) {
                        con.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        Statement stmtTest = null;
        try {
            if (this.globalConnection == null) {
                throw new Exception("Connessione is null");
            }
            stmtTest = this.globalConnection.createStatement();
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("db_info");
            sqlQueryObject.addSelectField("*");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stmtTest.execute(sqlQuery);
        }
        catch (Exception e) {
            throw new CoreException("Connessione alla configurazione registro non disponibile: " + e.getMessage(), e);
        }
        finally {
            try {
                if (stmtTest != null) {
                    stmtTest.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public PortaApplicativa getPortaApplicativa(IDPortaApplicativaByNome idPA) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (idPA == null) {
            throw new DriverConfigurazioneException("Identificativo non fornito");
        }
        return this.getPortaApplicativa(idPA.getNome(), idPA.getSoggetto());
    }

    @Override
    public PortaApplicativa getPortaApplicativa(String nomePorta, IDSoggetto soggettoProprietario) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (nomePorta == null || "".equals(nomePorta.trim())) {
            throw new DriverConfigurazioneException("Nome PA non valido");
        }
        Connection con = null;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("getPortaApplicativa");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::existsSoggetto] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        long idPorta = -1L;
        try {
            if (!this.existsPortaApplicativa(nomePorta, soggettoProprietario)) {
                throw new DriverConfigurazioneNotFound("Porta Applicativa [" + nomePorta + "] del soggetto [" + soggettoProprietario.toString() + "] non trovata.");
            }
            idPorta = DriverConfigurazioneDB_LIB.getIdPortaApplicativa(nomePorta, soggettoProprietario.getTipo(), soggettoProprietario.getNome(), con, this.tipoDB, this.tabellaSoggetti);
        }
        catch (CoreException e) {
            throw new DriverConfigurazioneException(e.getMessage(), e);
        }
        catch (DriverConfigurazioneNotFound e) {
            throw e;
        }
        catch (DriverConfigurazioneException e) {
            throw e;
        }
        finally {
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
        return this.getPortaApplicativa(idPorta);
    }

    @Override
    public boolean existsPortaApplicativa(IDPortaApplicativaByNome idPA) throws DriverConfigurazioneException {
        if (idPA == null) {
            throw new DriverConfigurazioneException("Identificativo non fornito");
        }
        return this.existsPortaApplicativa(idPA.getNome(), idPA.getSoggetto());
    }

    @Override
    public boolean existsPortaApplicativa(String nomePorta, IDSoggetto soggettoProprietario) throws DriverConfigurazioneException {
        if (nomePorta == null || "".equals(nomePorta.trim())) {
            throw new DriverConfigurazioneException("Nome PA non valido");
        }
        if (!this.existsSoggetto(soggettoProprietario)) {
            return false;
        }
        Connection con = null;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("existsPortaApplicativa");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::existsSoggetto] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        try {
            boolean e = DBUtils.getIdPortaApplicativa(nomePorta, soggettoProprietario.getTipo(), soggettoProprietario.getNome(), con, this.tipoDB, this.tabellaSoggetti) > 0L;
            return e;
        }
        catch (Exception qe) {
            throw new DriverConfigurazioneException(qe);
        }
        finally {
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<PortaApplicativa> serviziPorteAppList(String tipoServizio, String nomeServizio, long idServizio, long idSoggettoErogatore, ISearch ricerca) throws DriverConfigurazioneException {
        String nomeMetodo = "serviziPorteAppList";
        int idLista = 46;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<PortaApplicativa> lista = new ArrayList<PortaApplicativa>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource(nomeMetodo);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("porte_applicative");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition(false, "id_soggetto = ? AND tipo_servizio = ? AND servizio=? AND id_soggetto_virtuale <= ?", "id_soggetto = ? AND id_servizio = ? AND id_soggetto_virtuale <= ?", "id_soggetto_virtuale = ? AND tipo_servizio = ? AND servizio=?", "id_soggetto_virtuale = ? AND id_servizio = ?");
                sqlQueryObject.addWhereLikeCondition("nome_porta", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("porte_applicative");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition(false, "id_soggetto = ? AND tipo_servizio = ? AND servizio=? AND id_soggetto_virtuale <= ?", "id_soggetto = ? AND id_servizio = ? AND id_soggetto_virtuale <= ?", "id_soggetto_virtuale = ? AND tipo_servizio = ? AND servizio=?", "id_soggetto_virtuale = ? AND id_servizio = ?");
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idSoggettoErogatore);
            stmt.setString(2, tipoServizio);
            stmt.setString(3, nomeServizio);
            stmt.setLong(4, 0L);
            stmt.setLong(5, idSoggettoErogatore);
            stmt.setLong(6, idServizio);
            stmt.setLong(7, 0L);
            stmt.setLong(8, idSoggettoErogatore);
            stmt.setString(9, tipoServizio);
            stmt.setString(10, nomeServizio);
            stmt.setLong(11, idSoggettoErogatore);
            stmt.setLong(12, idServizio);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("porte_applicative");
                sqlQueryObject.addSelectField("id_soggetto");
                sqlQueryObject.addSelectField("id_servizio");
                sqlQueryObject.addSelectField("id_soggetto_virtuale");
                sqlQueryObject.addSelectField("nome_porta");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addWhereCondition(false, "id_soggetto = ? AND tipo_servizio = ? AND servizio=? AND id_soggetto_virtuale <= ?", "id_soggetto = ? AND id_servizio = ? AND id_soggetto_virtuale <= ?", "id_soggetto_virtuale = ? AND tipo_servizio = ? AND servizio=?", "id_soggetto_virtuale = ? AND id_servizio = ?");
                sqlQueryObject.addWhereLikeCondition("nome_porta", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome_porta");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("porte_applicative");
                sqlQueryObject.addSelectField("id_soggetto");
                sqlQueryObject.addSelectField("id_servizio");
                sqlQueryObject.addSelectField("id_soggetto_virtuale");
                sqlQueryObject.addSelectField("nome_porta");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addWhereCondition(false, "id_soggetto = ? AND tipo_servizio = ? AND servizio=? AND id_soggetto_virtuale <= ?", "id_soggetto = ? AND id_servizio = ? AND id_soggetto_virtuale <= ?", "id_soggetto_virtuale = ? AND tipo_servizio = ? AND servizio=?", "id_soggetto_virtuale = ? AND id_servizio = ?");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome_porta");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idSoggettoErogatore);
            stmt.setString(2, tipoServizio);
            stmt.setString(3, nomeServizio);
            stmt.setLong(4, 0L);
            stmt.setLong(5, idSoggettoErogatore);
            stmt.setLong(6, idServizio);
            stmt.setLong(7, 0L);
            stmt.setLong(8, idSoggettoErogatore);
            stmt.setString(9, tipoServizio);
            stmt.setString(10, nomeServizio);
            stmt.setLong(11, idSoggettoErogatore);
            stmt.setLong(12, idServizio);
            risultato = stmt.executeQuery();
            PortaApplicativa pa = null;
            while (risultato.next()) {
                pa = this.getPortaApplicativa(risultato.getLong("id"));
                lista.add(pa);
            }
            ArrayList<PortaApplicativa> arrayList = lista;
            return arrayList;
        }
        catch (Exception se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<PortaDelegata> serviziFruitoriPorteDelegateList(long idSoggetto, String tipoServizio, String nomeServizio, Long idServizio, String tipoSoggettoErogatore, String nomeSoggettoErogatore, Long idSoggettoErogatore, ISearch ricerca) throws DriverConfigurazioneException {
        String nomeMetodo = "serviziFruitoriPorteDelegateList";
        int idLista = 44;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<PortaDelegata> lista = new ArrayList<PortaDelegata>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource(nomeMetodo);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            ISQLQueryObject sqlQueryObject;
            String queryString;
            ISQLQueryObject sqlQueryObject2;
            if (!search.equals("")) {
                sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject2.addFromTable("porte_delegate");
                sqlQueryObject2.addSelectCountField("*", "cont");
                sqlQueryObject2.addWhereCondition("id_soggetto = ?");
                if (idSoggettoErogatore != null && idSoggettoErogatore > 0L) {
                    sqlQueryObject2.addWhereCondition(false, "id_soggetto_erogatore=?", "tipo_soggetto_erogatore=? AND nome_soggetto_erogatore=?");
                } else {
                    sqlQueryObject2.addWhereCondition("tipo_soggetto_erogatore=?");
                    sqlQueryObject2.addWhereCondition("nome_soggetto_erogatore=?");
                }
                if (idServizio != null && idServizio > 0L) {
                    sqlQueryObject2.addWhereCondition(false, "id_servizio=?", "tipo_servizio=? AND nome_servizio=?");
                } else {
                    sqlQueryObject2.addWhereCondition("tipo_servizio=?");
                    sqlQueryObject2.addWhereCondition("nome_servizio=?");
                }
                sqlQueryObject2.addWhereLikeCondition("nome_porta", search, true, true);
                sqlQueryObject2.setANDLogicOperator(true);
                queryString = sqlQueryObject2.createSQLQuery();
            } else {
                sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject2.addFromTable("porte_delegate");
                sqlQueryObject2.addSelectCountField("*", "cont");
                sqlQueryObject2.addWhereCondition("id_soggetto = ?");
                if (idSoggettoErogatore != null && idSoggettoErogatore > 0L) {
                    sqlQueryObject2.addWhereCondition(false, "id_soggetto_erogatore=?", "tipo_soggetto_erogatore=? AND nome_soggetto_erogatore=?");
                } else {
                    sqlQueryObject2.addWhereCondition("tipo_soggetto_erogatore=?");
                    sqlQueryObject2.addWhereCondition("nome_soggetto_erogatore=?");
                }
                if (idServizio != null && idServizio > 0L) {
                    sqlQueryObject2.addWhereCondition(false, "id_servizio=?", "tipo_servizio=? AND nome_servizio=?");
                } else {
                    sqlQueryObject2.addWhereCondition("tipo_servizio=?");
                    sqlQueryObject2.addWhereCondition("nome_servizio=?");
                }
                sqlQueryObject2.setANDLogicOperator(true);
                queryString = sqlQueryObject2.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            int index = 1;
            stmt.setLong(index++, idSoggetto);
            if (idSoggettoErogatore != null && idSoggettoErogatore > 0L) {
                stmt.setLong(index++, idSoggettoErogatore);
            }
            stmt.setString(index++, tipoSoggettoErogatore);
            stmt.setString(index++, nomeSoggettoErogatore);
            if (idServizio != null && idServizio > 0L) {
                stmt.setLong(index++, idServizio);
            }
            stmt.setString(index++, tipoServizio);
            stmt.setString(index++, nomeServizio);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("porte_delegate");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("nome_porta");
                sqlQueryObject.addWhereCondition("id_soggetto = ?");
                if (idSoggettoErogatore != null && idSoggettoErogatore > 0L) {
                    sqlQueryObject.addWhereCondition(false, "id_soggetto_erogatore=?", "tipo_soggetto_erogatore=? AND nome_soggetto_erogatore=?");
                } else {
                    sqlQueryObject.addWhereCondition("tipo_soggetto_erogatore=?");
                    sqlQueryObject.addWhereCondition("nome_soggetto_erogatore=?");
                }
                if (idServizio != null && idServizio > 0L) {
                    sqlQueryObject.addWhereCondition(false, "id_servizio=?", "tipo_servizio=? AND nome_servizio=?");
                } else {
                    sqlQueryObject.addWhereCondition("tipo_servizio=?");
                    sqlQueryObject.addWhereCondition("nome_servizio=?");
                }
                sqlQueryObject.addWhereLikeCondition("nome_porta", search, true, true);
                sqlQueryObject.setSelectDistinct(true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome_porta");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("porte_delegate");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("nome_porta");
                sqlQueryObject.addWhereCondition("id_soggetto = ?");
                if (idSoggettoErogatore != null && idSoggettoErogatore > 0L) {
                    sqlQueryObject.addWhereCondition(false, "id_soggetto_erogatore=?", "tipo_soggetto_erogatore=? AND nome_soggetto_erogatore=?");
                } else {
                    sqlQueryObject.addWhereCondition("tipo_soggetto_erogatore=?");
                    sqlQueryObject.addWhereCondition("nome_soggetto_erogatore=?");
                }
                if (idServizio != null && idServizio > 0L) {
                    sqlQueryObject.addWhereCondition(false, "id_servizio=?", "tipo_servizio=? AND nome_servizio=?");
                } else {
                    sqlQueryObject.addWhereCondition("tipo_servizio=?");
                    sqlQueryObject.addWhereCondition("nome_servizio=?");
                }
                sqlQueryObject.setSelectDistinct(true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome_porta");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            index = 1;
            stmt.setLong(index++, idSoggetto);
            if (idSoggettoErogatore != null && idSoggettoErogatore > 0L) {
                stmt.setLong(index++, idSoggettoErogatore);
            }
            stmt.setString(index++, tipoSoggettoErogatore);
            stmt.setString(index++, nomeSoggettoErogatore);
            if (idServizio != null && idServizio > 0L) {
                stmt.setLong(index++, idServizio);
            }
            stmt.setString(index++, tipoServizio);
            stmt.setString(index++, nomeServizio);
            risultato = stmt.executeQuery();
            PortaDelegata pd = null;
            while (risultato.next()) {
                pd = this.getPortaDelegata(risultato.getLong("id"));
                lista.add(pd);
            }
            ArrayList<PortaDelegata> arrayList = lista;
            return arrayList;
        }
        catch (Exception se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<String> connettoriList() throws DriverConfigurazioneException {
        String nomeMetodo = "connettoriList";
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        boolean error = false;
        ArrayList<String> lista = new ArrayList<String>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource(nomeMetodo);
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("connettori_properties");
            sqlQueryObject.addSelectField("nome_connettore");
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                lista.add(risultato.getString("nome_connettore"));
            }
            ArrayList<String> arrayList = lista;
            return arrayList;
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<PortaApplicativa> getPorteApplicativaByIdProprietario(long idProprietario) throws DriverConfigurazioneException {
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        String sqlQuery = "";
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("getPorteApplicativaByIdProprietario");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getPorteApplicativaByIdProprietario] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        ArrayList<PortaApplicativa> lista = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("porte_applicative");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_soggetto=?");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idProprietario);
            rs = stm.executeQuery();
            lista = new ArrayList<PortaApplicativa>();
            while (rs.next()) {
                long id = rs.getLong("id");
                PortaApplicativa pd = this.getPortaApplicativa(id);
                lista.add(pd);
            }
            rs.close();
            stm.close();
            ArrayList<PortaApplicativa> arrayList = lista;
            return arrayList;
        }
        catch (Exception qe) {
            throw new DriverConfigurazioneException(qe);
        }
        finally {
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<PortaApplicativa> getPorteApplicative(IDServizio idSE) throws DriverConfigurazioneException {
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        String sqlQuery = "";
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("getPorteApplicative(idServizio)");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getPorteApplicative] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        ArrayList<PortaApplicativa> lista = null;
        try {
            IDSoggetto erogatore = idSE.getSoggettoErogatore();
            String tipoServizio = idSE.getTipoServizio();
            String nomeServizio = idSE.getServizio();
            long idSoggetto = DBUtils.getIdSoggetto(erogatore.getNome(), erogatore.getTipo(), con, this.tipoDB);
            long idServizio = DBUtils.getIdServizio(nomeServizio, tipoServizio, erogatore.getNome(), erogatore.getTipo(), con, this.tipoDB);
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("porte_applicative");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_soggetto=?");
            sqlQueryObject.addWhereCondition(false, "id_servizio=?", "tipo_servizio=? AND servizio=?");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idSoggetto);
            stm.setLong(2, idServizio);
            stm.setString(3, tipoServizio);
            stm.setString(4, nomeServizio);
            rs = stm.executeQuery();
            lista = new ArrayList<PortaApplicativa>();
            while (rs.next()) {
                long id = rs.getLong("id");
                PortaApplicativa pd = this.getPortaApplicativa(id);
                lista.add(pd);
            }
            rs.close();
            stm.close();
            ArrayList<PortaApplicativa> arrayList = lista;
            return arrayList;
        }
        catch (Exception qe) {
            throw new DriverConfigurazioneException(qe);
        }
        finally {
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<PortaDelegata> getPorteDelegateByFruitore(IDSoggetto fruitore, ISearch filters) throws DriverConfigurazioneException {
        return this.getPorteDelegate(null, fruitore, filters);
    }

    public List<PortaDelegata> getPorteDelegate(IDServizio idSE, IDSoggetto fruitore, ISearch filters) throws DriverConfigurazioneException {
        String search;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        String queryString = "";
        int idLista = 16;
        int limit = filters.getPageSize(idLista);
        int offset = filters.getIndexIniziale(idLista);
        String string = search = "undefined".equals(filters.getSearchString(idLista)) ? "" : filters.getSearchString(idLista);
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("getPorteDelegate(idServizio,fruitore)");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getPorteDelegate] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        ArrayList<PortaDelegata> lista = null;
        try {
            IDSoggetto erogatore = null;
            String nomeErogatore = null;
            String tipoErogatore = null;
            String tipoServizio = null;
            String nomeServizio = null;
            if (idSE != null) {
                erogatore = idSE.getSoggettoErogatore();
                nomeErogatore = erogatore.getNome();
                tipoErogatore = erogatore.getTipo();
                tipoServizio = idSE.getTipoServizio();
                nomeServizio = idSE.getServizio();
            }
            long idSoggettoFruitore = DBUtils.getIdSoggetto(fruitore.getNome(), fruitore.getTipo(), con, this.tipoDB);
            long idSoggettoErogatore = -1L;
            long idServizio = -1L;
            if (idSE != null) {
                idSoggettoErogatore = DBUtils.getIdSoggetto(erogatore.getNome(), erogatore.getTipo(), con, this.tipoDB);
                idServizio = DBUtils.getIdServizio(nomeServizio, tipoServizio, erogatore.getNome(), erogatore.getTipo(), con, this.tipoDB);
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("porte_delegate");
            sqlQueryObject.addSelectCountField("*", "cont");
            sqlQueryObject.setANDLogicOperator(true);
            if (!search.equals("")) {
                sqlQueryObject.addWhereLikeCondition("nome_porta", search, true, true);
            }
            if ((risultato = (stmt = con.prepareStatement(queryString = sqlQueryObject.createSQLQuery())).executeQuery()).next()) {
                filters.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("porte_delegate");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addSelectField("nome_porta");
            sqlQueryObject.addWhereCondition("id_soggetto=?");
            sqlQueryObject.setANDLogicOperator(true);
            if (idSE != null) {
                sqlQueryObject.addWhereCondition(false, "id_servizio=?", "tipo_servizio=? AND nome_servizio=?");
                sqlQueryObject.addWhereCondition(false, "id_soggetto_erogatore=?", "nome_soggetto_erogatore=? AND tipo_soggetto_erogatore=?");
            }
            if (!search.equals("")) {
                sqlQueryObject.addWhereLikeCondition("nome_porta", search, true, true);
            }
            sqlQueryObject.addOrderBy("nome_porta");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idSoggettoFruitore);
            if (idSE != null) {
                stmt.setLong(2, idServizio);
                stmt.setString(3, tipoServizio);
                stmt.setString(4, nomeServizio);
                stmt.setLong(5, idSoggettoErogatore);
                stmt.setString(6, nomeErogatore);
                stmt.setString(7, tipoErogatore);
            }
            risultato = stmt.executeQuery();
            lista = new ArrayList<PortaDelegata>();
            while (risultato.next()) {
                long id = risultato.getLong("id");
                PortaDelegata pd = this.getPortaDelegata(id);
                lista.add(pd);
            }
            risultato.close();
            stmt.close();
            ArrayList<PortaDelegata> arrayList = lista;
            return arrayList;
        }
        catch (Exception qe) {
            throw new DriverConfigurazioneException(qe);
        }
        finally {
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public boolean existsPortaDelegata(String nomePorta, IDSoggetto soggettoProprietario) throws DriverConfigurazioneException {
        if (nomePorta == null || "".equals(nomePorta.trim())) {
            throw new DriverConfigurazioneException("Nome PD non valido");
        }
        if (!this.existsSoggetto(soggettoProprietario)) {
            return false;
        }
        Connection con = null;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("existsPortaDelegata");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::existsPortaDelegata] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        try {
            boolean e = DriverConfigurazioneDB_LIB.getIdPortaDelegata(nomePorta, soggettoProprietario.getTipo(), soggettoProprietario.getNome(), con, this.tipoDB, this.tabellaSoggetti) > 0L;
            return e;
        }
        catch (Exception qe) {
            throw new DriverConfigurazioneException(qe);
        }
        finally {
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public PortaDelegata getPortaDelegata(String nomePorta, IDSoggetto soggettoProprietario) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (nomePorta == null || "".equals(nomePorta.trim())) {
            throw new DriverConfigurazioneException("Nome PD non valido");
        }
        if (!this.existsSoggetto(soggettoProprietario)) {
            throw new DriverConfigurazioneNotFound("Il soggetto indicato come proprietario della Porta Delegata non esiste");
        }
        Connection con = null;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("getPortaDelegata");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::existsPortaDelegata] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        try {
            long idPD = DriverConfigurazioneDB_LIB.getIdPortaDelegata(nomePorta, soggettoProprietario.getTipo(), soggettoProprietario.getNome(), con, this.tipoDB, this.tabellaSoggetti);
            PortaDelegata portaDelegata = this.getPortaDelegata(idPD, con);
            return portaDelegata;
        }
        catch (Exception qe) {
            throw new DriverConfigurazioneException(qe);
        }
        finally {
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public int countTipologieServiziApplicativi(ISearch filters) throws DriverConfigurazioneException {
        return this.serviziApplicativiList_engineCount(null, null, false, null, false, filters, false, null, null);
    }

    public int countTipologieServiziApplicativi(IDSoggetto proprietario, ISearch filters) throws DriverConfigurazioneException {
        return this.serviziApplicativiList_engineCount(proprietario, null, false, null, false, filters, false, null, null);
    }

    public int countTipologieFruizioneServiziApplicativi(ISearch filters) throws DriverConfigurazioneException {
        return this.serviziApplicativiList_engineCount(null, null, false, null, true, filters, false, null, null);
    }

    public int countTipologieFruizioneServiziApplicativi(ISearch filters, boolean checkAssociazionePorta) throws DriverConfigurazioneException {
        return this.serviziApplicativiList_engineCount(null, null, false, null, true, filters, checkAssociazionePorta, null, null);
    }

    public int countTipologieFruizioneServiziApplicativi(ISearch filters, boolean checkAssociazionePorta, Boolean isBound) throws DriverConfigurazioneException {
        return this.serviziApplicativiList_engineCount(null, null, false, null, true, filters, checkAssociazionePorta, isBound, null);
    }

    public int countTipologieFruizioneServiziApplicativi(RicercaTipologiaFruizione fruizione, ISearch filters) throws DriverConfigurazioneException {
        return this.serviziApplicativiList_engineCount(null, null, false, fruizione, true, filters, false, null, null);
    }

    public int countTipologieFruizioneServiziApplicativi(RicercaTipologiaFruizione fruizione, ISearch filters, boolean checkAssociazionePorta) throws DriverConfigurazioneException {
        return this.serviziApplicativiList_engineCount(null, null, false, fruizione, true, filters, checkAssociazionePorta, null, null);
    }

    public int countTipologieFruizioneServiziApplicativi(RicercaTipologiaFruizione fruizione, ISearch filters, boolean checkAssociazionePorta, Boolean isBound) throws DriverConfigurazioneException {
        return this.serviziApplicativiList_engineCount(null, null, false, fruizione, true, filters, checkAssociazionePorta, isBound, null);
    }

    public int countTipologieFruizioneServiziApplicativi(IDSoggetto proprietario, ISearch filters) throws DriverConfigurazioneException {
        return this.serviziApplicativiList_engineCount(proprietario, null, false, null, true, filters, false, null, null);
    }

    public int countTipologieFruizioneServiziApplicativi(IDSoggetto proprietario, ISearch filters, boolean checkAssociazionePorta) throws DriverConfigurazioneException {
        return this.serviziApplicativiList_engineCount(proprietario, null, false, null, true, filters, checkAssociazionePorta, null, null);
    }

    public int countTipologieFruizioneServiziApplicativi(IDSoggetto proprietario, ISearch filters, boolean checkAssociazionePorta, Boolean isBound) throws DriverConfigurazioneException {
        return this.serviziApplicativiList_engineCount(proprietario, null, false, null, true, filters, checkAssociazionePorta, isBound, null);
    }

    public int countTipologieFruizioneServiziApplicativi(IDSoggetto proprietario, RicercaTipologiaFruizione fruizione, ISearch filters) throws DriverConfigurazioneException {
        return this.serviziApplicativiList_engineCount(proprietario, null, false, fruizione, true, filters, false, null, null);
    }

    public int countTipologieFruizioneServiziApplicativi(IDSoggetto proprietario, RicercaTipologiaFruizione fruizione, ISearch filters, boolean checkAssociazionePorta) throws DriverConfigurazioneException {
        return this.serviziApplicativiList_engineCount(proprietario, null, false, fruizione, true, filters, checkAssociazionePorta, null, null);
    }

    public int countTipologieFruizioneServiziApplicativi(IDSoggetto proprietario, RicercaTipologiaFruizione fruizione, ISearch filters, boolean checkAssociazionePorta, Boolean isBound) throws DriverConfigurazioneException {
        return this.serviziApplicativiList_engineCount(proprietario, null, false, fruizione, true, filters, checkAssociazionePorta, isBound, null);
    }

    public int countTipologieErogazioneServiziApplicativi(ISearch filters) throws DriverConfigurazioneException {
        return this.serviziApplicativiList_engineCount(null, null, true, null, false, filters, false, null, null);
    }

    public int countTipologieErogazioneServiziApplicativi(ISearch filters, boolean checkAssociazionePorta) throws DriverConfigurazioneException {
        return this.serviziApplicativiList_engineCount(null, null, true, null, false, filters, checkAssociazionePorta, null, null);
    }

    public int countTipologieErogazioneServiziApplicativi(ISearch filters, boolean checkAssociazionePorta, Boolean isBound) throws DriverConfigurazioneException {
        return this.serviziApplicativiList_engineCount(null, null, true, null, false, filters, checkAssociazionePorta, null, isBound);
    }

    public int countTipologieErogazioneServiziApplicativi(RicercaTipologiaErogazione erogazione, ISearch filters) throws DriverConfigurazioneException {
        return this.serviziApplicativiList_engineCount(null, erogazione, true, null, false, filters, false, null, null);
    }

    public int countTipologieErogazioneServiziApplicativi(RicercaTipologiaErogazione erogazione, ISearch filters, boolean checkAssociazionePorta) throws DriverConfigurazioneException {
        return this.serviziApplicativiList_engineCount(null, erogazione, true, null, false, filters, checkAssociazionePorta, null, null);
    }

    public int countTipologieErogazioneServiziApplicativi(RicercaTipologiaErogazione erogazione, ISearch filters, boolean checkAssociazionePorta, Boolean isBound) throws DriverConfigurazioneException {
        return this.serviziApplicativiList_engineCount(null, erogazione, true, null, false, filters, checkAssociazionePorta, null, isBound);
    }

    public int countTipologieErogazioneServiziApplicativi(IDSoggetto proprietario, RicercaTipologiaErogazione erogazione, ISearch filters) throws DriverConfigurazioneException {
        return this.serviziApplicativiList_engineCount(proprietario, erogazione, true, null, false, filters, false, null, null);
    }

    public int countTipologieErogazioneServiziApplicativi(IDSoggetto proprietario, RicercaTipologiaErogazione erogazione, ISearch filters, boolean checkAssociazionePorta) throws DriverConfigurazioneException {
        return this.serviziApplicativiList_engineCount(proprietario, erogazione, true, null, false, filters, checkAssociazionePorta, null, null);
    }

    public int countTipologieErogazioneServiziApplicativi(IDSoggetto proprietario, RicercaTipologiaErogazione erogazione, ISearch filters, boolean checkAssociazionePorta, Boolean isBound) throws DriverConfigurazioneException {
        return this.serviziApplicativiList_engineCount(proprietario, erogazione, true, null, false, filters, checkAssociazionePorta, null, isBound);
    }

    public int countTipologieErogazioneServiziApplicativi(IDSoggetto proprietario, ISearch filters) throws DriverConfigurazioneException {
        return this.serviziApplicativiList_engineCount(proprietario, null, true, null, false, filters, false, null, null);
    }

    public int countTipologieErogazioneServiziApplicativi(IDSoggetto proprietario, ISearch filters, boolean checkAssociazionePorta) throws DriverConfigurazioneException {
        return this.serviziApplicativiList_engineCount(proprietario, null, true, null, false, filters, checkAssociazionePorta, null, null);
    }

    public int countTipologieErogazioneServiziApplicativi(IDSoggetto proprietario, ISearch filters, boolean checkAssociazionePorta, Boolean isBound) throws DriverConfigurazioneException {
        return this.serviziApplicativiList_engineCount(proprietario, null, true, null, false, filters, checkAssociazionePorta, null, isBound);
    }

    private int serviziApplicativiList_engineCount(IDSoggetto proprietario, RicercaTipologiaErogazione erogazione, boolean searchSoloErogazione, RicercaTipologiaFruizione fruizione, boolean serchSoloFruizione, ISearch filters, boolean checkAssociazionePorta, Boolean fruizioneIsBound, Boolean erogazioneIsBound) throws DriverConfigurazioneException {
        String search;
        String nomeMetodo = "serviziApplicativiList";
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        boolean error = false;
        Long idProprietario = null;
        int idLista = 27;
        String string = search = "undefined".equals(filters.getSearchString(idLista)) ? "" : filters.getSearchString(idLista);
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource(nomeMetodo);
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            if (proprietario != null && (idProprietario = Long.valueOf(DBUtils.getIdSoggetto(proprietario.getNome(), proprietario.getTipo(), con, this.tipoDB))) < 0L) {
                new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Il proprietario [" + proprietario.toString() + "] non esiste.");
            }
            ISQLQueryObject sqlQueryObject = this.getServiziApplicativiSearchFiltratiTipologia(proprietario, erogazione, searchSoloErogazione, fruizione, serchSoloFruizione, filters, checkAssociazionePorta, search, true, fruizioneIsBound, erogazioneIsBound);
            String queryString = sqlQueryObject.createSQLQuery();
            this.log.debug("QueryCount=[" + queryString + "]");
            stmt = con.prepareStatement(queryString);
            int index = 1;
            if (proprietario != null) {
                stmt.setLong(index++, idProprietario);
            }
            if (serchSoloFruizione) {
                if (fruizione == null) {
                    stmt.setString(index++, TipologiaFruizione.DISABILITATO.toString());
                } else if (!RicercaTipologiaFruizione.ALL.toString().equals(fruizione.toString())) {
                    stmt.setString(index++, fruizione.toString());
                }
            } else if (searchSoloErogazione) {
                if (erogazione == null) {
                    stmt.setString(index++, TipologiaErogazione.DISABILITATO.toString());
                } else if (!RicercaTipologiaErogazione.ALL.toString().equals(erogazione.toString())) {
                    stmt.setString(index++, erogazione.toString());
                }
            }
            if (fruizioneIsBound != null) {
                stmt.setString(index++, TipoAutenticazione.DISABILITATO.getValue());
            }
            if (erogazioneIsBound != null) {
                stmt.setString(index++, TipiConnettore.DISABILITATO.getNome());
                stmt.setString(index++, TipiConnettore.HTTP.getNome());
                stmt.setString(index++, TipiConnettore.HTTP.getNome());
            }
            risultato = stmt.executeQuery();
            int count = -1;
            if (risultato.next()) {
                count = risultato.getInt("count");
            }
            risultato.close();
            stmt.close();
            int n = count;
            return n;
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<TipologiaServizioApplicativo> getTipologieServiziApplicativi(ISearch filters) throws DriverConfigurazioneException {
        return this.serviziApplicativiList_engine(null, null, false, null, false, filters, false, null, null);
    }

    public List<TipologiaServizioApplicativo> getTipologieServiziApplicativi(IDSoggetto proprietario, ISearch filters) throws DriverConfigurazioneException {
        return this.serviziApplicativiList_engine(proprietario, null, false, null, false, filters, false, null, null);
    }

    public List<TipologiaServizioApplicativo> getTipologieFruizioneServiziApplicativi(ISearch filters) throws DriverConfigurazioneException {
        return this.serviziApplicativiList_engine(null, null, false, null, true, filters, false, null, null);
    }

    public List<TipologiaServizioApplicativo> getTipologieFruizioneServiziApplicativi(ISearch filters, boolean checkAssociazionePorta) throws DriverConfigurazioneException {
        return this.serviziApplicativiList_engine(null, null, false, null, true, filters, checkAssociazionePorta, null, null);
    }

    public List<TipologiaServizioApplicativo> getTipologieFruizioneServiziApplicativi(ISearch filters, boolean checkAssociazionePorta, Boolean isBound) throws DriverConfigurazioneException {
        return this.serviziApplicativiList_engine(null, null, false, null, true, filters, checkAssociazionePorta, isBound, null);
    }

    public List<TipologiaServizioApplicativo> getTipologieFruizioneServiziApplicativi(RicercaTipologiaFruizione fruizione, ISearch filters) throws DriverConfigurazioneException {
        return this.serviziApplicativiList_engine(null, null, false, fruizione, true, filters, false, null, null);
    }

    public List<TipologiaServizioApplicativo> getTipologieFruizioneServiziApplicativi(RicercaTipologiaFruizione fruizione, ISearch filters, boolean checkAssociazionePorta) throws DriverConfigurazioneException {
        return this.serviziApplicativiList_engine(null, null, false, fruizione, true, filters, checkAssociazionePorta, null, null);
    }

    public List<TipologiaServizioApplicativo> getTipologieFruizioneServiziApplicativi(RicercaTipologiaFruizione fruizione, ISearch filters, boolean checkAssociazionePorta, Boolean isBound) throws DriverConfigurazioneException {
        return this.serviziApplicativiList_engine(null, null, false, fruizione, true, filters, checkAssociazionePorta, isBound, null);
    }

    public List<TipologiaServizioApplicativo> getTipologieFruizioneServiziApplicativi(IDSoggetto proprietario, ISearch filters) throws DriverConfigurazioneException {
        return this.serviziApplicativiList_engine(proprietario, null, false, null, true, filters, false, null, null);
    }

    public List<TipologiaServizioApplicativo> getTipologieFruizioneServiziApplicativi(IDSoggetto proprietario, ISearch filters, boolean checkAssociazionePorta) throws DriverConfigurazioneException {
        return this.serviziApplicativiList_engine(proprietario, null, false, null, true, filters, checkAssociazionePorta, null, null);
    }

    public List<TipologiaServizioApplicativo> getTipologieFruizioneServiziApplicativi(IDSoggetto proprietario, ISearch filters, boolean checkAssociazionePorta, Boolean isBound) throws DriverConfigurazioneException {
        return this.serviziApplicativiList_engine(proprietario, null, false, null, true, filters, checkAssociazionePorta, isBound, null);
    }

    public List<TipologiaServizioApplicativo> getTipologieFruizioneServiziApplicativi(IDSoggetto proprietario, RicercaTipologiaFruizione fruizione, ISearch filters) throws DriverConfigurazioneException {
        return this.serviziApplicativiList_engine(proprietario, null, false, fruizione, true, filters, false, null, null);
    }

    public List<TipologiaServizioApplicativo> getTipologieFruizioneServiziApplicativi(IDSoggetto proprietario, RicercaTipologiaFruizione fruizione, ISearch filters, boolean checkAssociazionePorta) throws DriverConfigurazioneException {
        return this.serviziApplicativiList_engine(proprietario, null, false, fruizione, true, filters, checkAssociazionePorta, null, null);
    }

    public List<TipologiaServizioApplicativo> getTipologieFruizioneServiziApplicativi(IDSoggetto proprietario, RicercaTipologiaFruizione fruizione, ISearch filters, boolean checkAssociazionePorta, Boolean isBound) throws DriverConfigurazioneException {
        return this.serviziApplicativiList_engine(proprietario, null, false, fruizione, true, filters, checkAssociazionePorta, isBound, null);
    }

    public List<TipologiaServizioApplicativo> getTipologieErogazioneServiziApplicativi(ISearch filters) throws DriverConfigurazioneException {
        return this.serviziApplicativiList_engine(null, null, true, null, false, filters, false, null, null);
    }

    public List<TipologiaServizioApplicativo> getTipologieErogazioneServiziApplicativi(ISearch filters, boolean checkAssociazionePorta) throws DriverConfigurazioneException {
        return this.serviziApplicativiList_engine(null, null, true, null, false, filters, checkAssociazionePorta, null, null);
    }

    public List<TipologiaServizioApplicativo> getTipologieErogazioneServiziApplicativi(ISearch filters, boolean checkAssociazionePorta, Boolean isBound) throws DriverConfigurazioneException {
        return this.serviziApplicativiList_engine(null, null, true, null, false, filters, checkAssociazionePorta, null, isBound);
    }

    public List<TipologiaServizioApplicativo> getTipologieErogazioneServiziApplicativi(RicercaTipologiaErogazione erogazione, ISearch filters) throws DriverConfigurazioneException {
        return this.serviziApplicativiList_engine(null, erogazione, true, null, false, filters, false, null, null);
    }

    public List<TipologiaServizioApplicativo> getTipologieErogazioneServiziApplicativi(RicercaTipologiaErogazione erogazione, ISearch filters, boolean checkAssociazionePorta) throws DriverConfigurazioneException {
        return this.serviziApplicativiList_engine(null, erogazione, true, null, false, filters, checkAssociazionePorta, null, null);
    }

    public List<TipologiaServizioApplicativo> getTipologieErogazioneServiziApplicativi(RicercaTipologiaErogazione erogazione, ISearch filters, boolean checkAssociazionePorta, Boolean isBound) throws DriverConfigurazioneException {
        return this.serviziApplicativiList_engine(null, erogazione, true, null, false, filters, checkAssociazionePorta, null, isBound);
    }

    public List<TipologiaServizioApplicativo> getTipologieErogazioneServiziApplicativi(IDSoggetto proprietario, RicercaTipologiaErogazione erogazione, ISearch filters) throws DriverConfigurazioneException {
        return this.serviziApplicativiList_engine(proprietario, erogazione, true, null, false, filters, false, null, null);
    }

    public List<TipologiaServizioApplicativo> getTipologieErogazioneServiziApplicativi(IDSoggetto proprietario, RicercaTipologiaErogazione erogazione, ISearch filters, boolean checkAssociazionePorta) throws DriverConfigurazioneException {
        return this.serviziApplicativiList_engine(proprietario, erogazione, true, null, false, filters, checkAssociazionePorta, null, null);
    }

    public List<TipologiaServizioApplicativo> getTipologieErogazioneServiziApplicativi(IDSoggetto proprietario, RicercaTipologiaErogazione erogazione, ISearch filters, boolean checkAssociazionePorta, Boolean isBound) throws DriverConfigurazioneException {
        return this.serviziApplicativiList_engine(proprietario, erogazione, true, null, false, filters, checkAssociazionePorta, null, isBound);
    }

    public List<TipologiaServizioApplicativo> getTipologieErogazioneServiziApplicativi(IDSoggetto proprietario, ISearch filters) throws DriverConfigurazioneException {
        return this.serviziApplicativiList_engine(proprietario, null, true, null, false, filters, false, null, null);
    }

    public List<TipologiaServizioApplicativo> getTipologieErogazioneServiziApplicativi(IDSoggetto proprietario, ISearch filters, boolean checkAssociazionePorta) throws DriverConfigurazioneException {
        return this.serviziApplicativiList_engine(proprietario, null, true, null, false, filters, checkAssociazionePorta, null, null);
    }

    public List<TipologiaServizioApplicativo> getTipologieErogazioneServiziApplicativi(IDSoggetto proprietario, ISearch filters, boolean checkAssociazionePorta, Boolean isBound) throws DriverConfigurazioneException {
        return this.serviziApplicativiList_engine(proprietario, null, true, null, false, filters, checkAssociazionePorta, null, isBound);
    }

    private List<TipologiaServizioApplicativo> serviziApplicativiList_engine(IDSoggetto proprietario, RicercaTipologiaErogazione erogazione, boolean searchSoloErogazione, RicercaTipologiaFruizione fruizione, boolean serchSoloFruizione, ISearch filters, boolean checkAssociazionePorta, Boolean fruizioneIsBound, Boolean erogazioneIsBound) throws DriverConfigurazioneException {
        String nomeMetodo = "serviziApplicativiList";
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        boolean error = false;
        Long idProprietario = null;
        int idLista = 27;
        int limit = filters.getPageSize(idLista);
        int offset = filters.getIndexIniziale(idLista);
        String search = "undefined".equals(filters.getSearchString(idLista)) ? "" : filters.getSearchString(idLista);
        ArrayList<TipologiaServizioApplicativo> lista = new ArrayList<TipologiaServizioApplicativo>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource(nomeMetodo);
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            if (proprietario != null && (idProprietario = Long.valueOf(DBUtils.getIdSoggetto(proprietario.getNome(), proprietario.getTipo(), con, this.tipoDB))) < 0L) {
                new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Il proprietario [" + proprietario.toString() + "] non esiste.");
            }
            filters.setNumEntries(idLista, this.serviziApplicativiList_engineCount(proprietario, erogazione, searchSoloErogazione, fruizione, serchSoloFruizione, filters, checkAssociazionePorta, fruizioneIsBound, erogazioneIsBound));
            ISQLQueryObject sqlQueryObject = this.getServiziApplicativiSearchFiltratiTipologia(proprietario, erogazione, searchSoloErogazione, fruizione, serchSoloFruizione, filters, checkAssociazionePorta, search, false, fruizioneIsBound, erogazioneIsBound);
            if (limit == 0) {
                limit = 1000;
            }
            sqlQueryObject.addOrderBy("nome");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setOffset(offset);
            sqlQueryObject.setLimit(limit);
            String queryString = sqlQueryObject.createSQLQuery();
            this.log.debug("Query=[" + queryString + "]");
            stmt = con.prepareStatement(queryString);
            int index = 1;
            if (proprietario != null) {
                stmt.setLong(index++, idProprietario);
            }
            if (serchSoloFruizione) {
                if (fruizione == null) {
                    stmt.setString(index++, TipologiaFruizione.DISABILITATO.toString());
                } else if (!RicercaTipologiaFruizione.ALL.toString().equals(fruizione.toString())) {
                    stmt.setString(index++, fruizione.toString());
                }
            } else if (searchSoloErogazione) {
                if (erogazione == null) {
                    stmt.setString(index++, TipologiaErogazione.DISABILITATO.toString());
                } else if (!RicercaTipologiaErogazione.ALL.toString().equals(erogazione.toString())) {
                    stmt.setString(index++, erogazione.toString());
                }
            }
            if (fruizioneIsBound != null) {
                stmt.setString(index++, TipoAutenticazione.DISABILITATO.getValue());
            }
            if (erogazioneIsBound != null) {
                stmt.setString(index++, TipiConnettore.DISABILITATO.getNome());
                stmt.setString(index++, TipiConnettore.HTTP.getNome());
                stmt.setString(index++, TipiConnettore.HTTP.getNome());
            }
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                String tipologiaErogazione;
                IDServizioApplicativo idSA = new IDServizioApplicativo();
                if (proprietario != null) {
                    idSA.setIdSoggettoProprietario(proprietario);
                } else {
                    long idProprietarioLetto = risultato.getLong("id_soggetto");
                    Soggetto s = this.getSoggetto(idProprietarioLetto);
                    idSA.setIdSoggettoProprietario(new IDSoggetto(s.getTipo(), s.getNome()));
                }
                idSA.setNome(risultato.getString("nome"));
                TipologiaServizioApplicativo tipologia = new TipologiaServizioApplicativo();
                tipologia.setIdServizioApplicativo(idSA);
                String tipologiaFruizione = risultato.getString("tipologia_fruizione");
                if (tipologiaFruizione != null && !"".equals(tipologiaFruizione)) {
                    tipologia.setTipologiaFruizione(TipologiaFruizione.toEnumConstant(tipologiaFruizione));
                }
                if ((tipologiaErogazione = risultato.getString("tipologia_erogazione")) != null && !"".equals(tipologiaErogazione)) {
                    tipologia.setTipologiaErogazione(TipologiaErogazione.toEnumConstant(tipologiaErogazione));
                }
                lista.add(tipologia);
            }
            risultato.close();
            stmt.close();
            ArrayList<TipologiaServizioApplicativo> arrayList = lista;
            return arrayList;
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private ISQLQueryObject getServiziApplicativiSearchFiltratiTipologia(IDSoggetto proprietario, RicercaTipologiaErogazione erogazione, boolean searchSoloErogazione, RicercaTipologiaFruizione fruizione, boolean serchSoloFruizione, ISearch filters, boolean checkAssociazionePorta, String search, boolean count, Boolean fruizioneIsBound, Boolean erogazioneIsBound) throws Exception {
        ISQLQueryObject sqlQueryObjectIn;
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
        sqlQueryObject.addFromTable("servizi_applicativi");
        if (count) {
            sqlQueryObject.addSelectCountField("*", "count");
        } else {
            sqlQueryObject.addSelectField("nome");
            sqlQueryObject.addSelectField("id_soggetto");
            sqlQueryObject.addSelectField("tipologia_fruizione");
            sqlQueryObject.addSelectField("tipologia_erogazione");
        }
        if (proprietario != null) {
            sqlQueryObject.addWhereCondition("id_soggetto=?");
        }
        if (!"".equals(search)) {
            sqlQueryObject.addWhereLikeCondition("nome", search, false, true, true);
        }
        if (serchSoloFruizione) {
            if (fruizione == null) {
                sqlQueryObject.addWhereCondition(true, "tipologia_fruizione is not null", "tipologia_fruizione <> ?");
            } else if (RicercaTipologiaFruizione.DISABILITATO.toString().equals(fruizione.toString())) {
                sqlQueryObject.addWhereCondition(false, "tipologia_fruizione is null", "tipologia_fruizione = ?");
            } else if (!RicercaTipologiaFruizione.ALL.toString().equals(fruizione.toString())) {
                sqlQueryObject.addWhereCondition("tipologia_fruizione = ?");
            }
            if (checkAssociazionePorta) {
                sqlQueryObjectIn = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObjectIn.addFromTable("porte_delegate_sa");
                sqlQueryObjectIn.addSelectField("id_servizio_applicativo");
                sqlQueryObjectIn.addWhereCondition("id_servizio_applicativo=servizi_applicativi.id");
                sqlQueryObject.addWhereExistsCondition(false, sqlQueryObjectIn);
            }
        } else if (searchSoloErogazione) {
            if (erogazione == null) {
                sqlQueryObject.addWhereCondition(true, "tipologia_erogazione is not null", "tipologia_erogazione <> ?");
            } else if (RicercaTipologiaErogazione.DISABILITATO.toString().equals(erogazione.toString())) {
                sqlQueryObject.addWhereCondition(false, "tipologia_erogazione is null", "tipologia_erogazione = ?");
            } else if (!RicercaTipologiaErogazione.ALL.toString().equals(erogazione.toString())) {
                sqlQueryObject.addWhereCondition("tipologia_erogazione = ?");
            }
            if (checkAssociazionePorta) {
                sqlQueryObjectIn = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObjectIn.addFromTable("porte_applicative_sa");
                sqlQueryObjectIn.addSelectField("id_servizio_applicativo");
                sqlQueryObjectIn.addWhereCondition("id_servizio_applicativo=servizi_applicativi.id");
                sqlQueryObject.addWhereExistsCondition(false, sqlQueryObjectIn);
            }
        }
        if (fruizioneIsBound != null) {
            if (fruizioneIsBound.booleanValue()) {
                sqlQueryObject.addWhereIsNotNullCondition("tipoauth");
                sqlQueryObject.addWhereCondition("tipoauth<>?");
            } else {
                sqlQueryObject.addWhereCondition(false, "tipoauth is null", "tipoauth=?");
            }
        }
        if (erogazioneIsBound != null) {
            ISQLQueryObject sqlQueryObjectConnettore = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObjectConnettore.setANDLogicOperator(true);
            sqlQueryObjectConnettore.addFromTable("connettori");
            sqlQueryObjectConnettore.addSelectField("id");
            sqlQueryObjectConnettore.addWhereCondition("id_connettore_inv=connettori.id");
            ISQLQueryObject sqlQueryObject_NullCondition = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject_NullCondition.addWhereIsNotNullCondition("url");
            ISQLQueryObject sqlQueryObject_EmptyCondition = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject_EmptyCondition.addWhereIsNotEmptyCondition("url");
            sqlQueryObjectConnettore.addWhereCondition(false, "endpointtype<>? AND endpointtype<>?", "endpointtype=? AND " + sqlQueryObject_NullCondition.createSQLConditions() + " AND " + sqlQueryObject_EmptyCondition.createSQLConditions());
            if (erogazioneIsBound.booleanValue()) {
                sqlQueryObject.addWhereExistsCondition(false, sqlQueryObjectConnettore);
            } else {
                sqlQueryObject.addWhereExistsCondition(true, sqlQueryObjectConnettore);
            }
        }
        sqlQueryObject.setANDLogicOperator(true);
        return sqlQueryObject;
    }

    public List<IDServizioApplicativo> serviziApplicativiList(ISearch filters, IDSoggetto proprietario, TipologiaErogazione ... erogazione) throws DriverConfigurazioneException {
        String nomeMetodo = "serviziApplicativiList";
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        boolean error = false;
        long idProprietario = -1L;
        int idLista = 27;
        int limit = filters.getPageSize(idLista);
        int offset = filters.getIndexIniziale(idLista);
        String search = "undefined".equals(filters.getSearchString(idLista)) ? "" : filters.getSearchString(idLista);
        ArrayList<IDServizioApplicativo> lista = new ArrayList<IDServizioApplicativo>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource(nomeMetodo);
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            int i;
            idProprietario = DBUtils.getIdSoggetto(proprietario.getNome(), proprietario.getTipo(), con, this.tipoDB);
            if (idProprietario < 0L) {
                new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Il proprietario [" + proprietario.toString() + "] non esiste.");
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("servizi_applicativi");
            sqlQueryObject.addSelectCountField("*", "count");
            sqlQueryObject.addWhereCondition("id_soggetto=?");
            if (!"".equals(search)) {
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
            }
            String[] conditions = new String[erogazione.length];
            for (int i2 = 0; i2 < erogazione.length; ++i2) {
                conditions[i2] = "tipologia_erogazione = ?";
            }
            sqlQueryObject.addWhereCondition(false, conditions);
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idProprietario);
            int baseIdx = 1;
            for (i = 0; i < erogazione.length; ++i) {
                stmt.setString(++baseIdx, erogazione[i].toString());
            }
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                filters.setNumEntries(idLista, risultato.getInt("count"));
            }
            risultato.close();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("servizi_applicativi");
            sqlQueryObject.addSelectField("nome");
            sqlQueryObject.addSelectField("id_soggetto");
            sqlQueryObject.addSelectField("tipologia_fruizione");
            sqlQueryObject.addSelectField("tipologia_erogazione");
            sqlQueryObject.addWhereCondition("id_soggetto=?");
            if (!"".equals(search)) {
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
            }
            sqlQueryObject.addWhereCondition(false, conditions);
            sqlQueryObject.setANDLogicOperator(true);
            if (limit == 0) {
                limit = 1000;
            }
            sqlQueryObject.addOrderBy("nome");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setOffset(offset);
            sqlQueryObject.setLimit(limit);
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idProprietario);
            baseIdx = 1;
            for (i = 0; i < erogazione.length; ++i) {
                stmt.setString(++baseIdx, erogazione[i].toString());
            }
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                IDServizioApplicativo idSA = new IDServizioApplicativo();
                idSA.setIdSoggettoProprietario(proprietario);
                idSA.setNome(risultato.getString("nome"));
                lista.add(idSA);
            }
            risultato.close();
            stmt.close();
            ArrayList<IDServizioApplicativo> arrayList = lista;
            return arrayList;
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public Openspcoop2 getImmagineCompletaConfigurazionePdD() throws DriverConfigurazioneException {
        Openspcoop2 openspcoop = new Openspcoop2();
        Configurazione conf = null;
        try {
            conf = this.getConfigurazioneGenerale();
        }
        catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
            // empty catch block
        }
        if (conf != null) {
            try {
                conf.setAccessoRegistro(this.getAccessoRegistro());
            }
            catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
                // empty catch block
            }
            try {
                conf.setAccessoConfigurazione(this.getAccessoConfigurazione());
            }
            catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
                // empty catch block
            }
            try {
                conf.setAccessoDatiAutorizzazione(this.getAccessoDatiAutorizzazione());
            }
            catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
                // empty catch block
            }
            conf.setRoutingTable(this.getRoutingTable());
            GestioneErrore compIntegrazione = null;
            try {
                compIntegrazione = this.getGestioneErroreComponenteIntegrazione();
            }
            catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
                // empty catch block
            }
            GestioneErrore compCooperazione = null;
            try {
                compCooperazione = this.getGestioneErroreComponenteCooperazione();
            }
            catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
                // empty catch block
            }
            if (compIntegrazione != null && compCooperazione != null) {
                ConfigurazioneGestioneErrore gee = new ConfigurazioneGestioneErrore();
                if (compIntegrazione != null) {
                    gee.setComponenteIntegrazione(compIntegrazione);
                }
                if (compCooperazione != null) {
                    gee.setComponenteCooperazione(compCooperazione);
                }
                conf.setGestioneErrore(gee);
            }
            openspcoop.setConfigurazione(conf);
        }
        List<Soggetto> soggetti = this.getAllSoggetti();
        while (soggetti.size() > 0) {
            Soggetto soggetto = soggetti.remove(0);
            while (soggetto.sizePortaDelegataList() > 0) {
                soggetto.removePortaDelegata(0);
            }
            while (soggetto.sizePortaApplicativaList() > 0) {
                soggetto.removePortaApplicativa(0);
            }
            while (soggetto.sizeServizioApplicativoList() > 0) {
                soggetto.removeServizioApplicativo(0);
            }
            List<PortaDelegata> pd = this.getPorteDelegateBySoggetto(soggetto.getId());
            while (pd.size() > 0) {
                soggetto.addPortaDelegata(pd.remove(0));
            }
            List<PortaApplicativa> pa = this.getPorteApplicativeBySoggetto(soggetto.getId());
            while (pa.size() > 0) {
                soggetto.addPortaApplicativa(pa.remove(0));
            }
            List<ServizioApplicativo> sa = this.getServiziApplicativiBySoggetto(soggetto.getId());
            while (sa.size() > 0) {
                soggetto.addServizioApplicativo(sa.remove(0));
            }
            openspcoop.addSoggetto(soggetto);
        }
        return openspcoop;
    }

    public List<Soggetto> getAllSoggetti() throws DriverConfigurazioneException {
        String nomeMetodo = "getAllSoggetti";
        Connection con = null;
        boolean error = false;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<Soggetto> lista = new ArrayList<Soggetto>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource(nomeMetodo);
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable(this.tabellaSoggetti);
            sqlQueryObject.addSelectField("id");
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                Long id = risultato.getLong("id");
                lista.add(this.getSoggetto(id));
            }
            ArrayList<Soggetto> arrayList = lista;
            return arrayList;
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<PortaDelegata> getPorteDelegateBySoggetto(long idSoggetto) throws DriverConfigurazioneException {
        String nomeMetodo = "getPorteDelegateBySoggetto";
        Connection con = null;
        boolean error = false;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<PortaDelegata> lista = new ArrayList<PortaDelegata>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource(nomeMetodo);
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("porte_delegate");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addWhereCondition("id_soggetto=?");
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idSoggetto);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                Long id = risultato.getLong("id");
                lista.add(this.getPortaDelegata(id));
            }
            ArrayList<PortaDelegata> arrayList = lista;
            return arrayList;
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<PortaApplicativa> getPorteApplicativeBySoggetto(long idSoggetto) throws DriverConfigurazioneException {
        String nomeMetodo = "getPorteApplicativeBySoggetto";
        Connection con = null;
        boolean error = false;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<PortaApplicativa> lista = new ArrayList<PortaApplicativa>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource(nomeMetodo);
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("porte_applicative");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addWhereCondition("id_soggetto=?");
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idSoggetto);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                Long id = risultato.getLong("id");
                lista.add(this.getPortaApplicativa(id));
            }
            ArrayList<PortaApplicativa> arrayList = lista;
            return arrayList;
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<ServizioApplicativo> getServiziApplicativiBySoggetto(long idSoggetto) throws DriverConfigurazioneException {
        String nomeMetodo = "getPorteApplicativeBySoggetto";
        Connection con = null;
        boolean error = false;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<ServizioApplicativo> lista = new ArrayList<ServizioApplicativo>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource(nomeMetodo);
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("servizi_applicativi");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addWhereCondition("id_soggetto=?");
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idSoggetto);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                Long id = risultato.getLong("id");
                ServizioApplicativo sa = this.getServizioApplicativo(id);
                if (sa.getInvocazionePorta() != null && sa.getInvocazionePorta().sizeCredenzialiList() == 0) {
                    sa.setInvocazionePorta(null);
                }
                if (sa.getInvocazioneServizio() != null && (sa.getInvocazioneServizio().getConnettore() == null || CostantiConfigurazione.DISABILITATO.equals(sa.getInvocazioneServizio().getConnettore().getTipo())) && CostantiConfigurazione.DISABILITATO.equals(sa.getInvocazioneServizio().getGetMessage())) {
                    sa.setInvocazioneServizio(null);
                }
                if (sa.getRispostaAsincrona() != null && (sa.getRispostaAsincrona().getConnettore() == null || CostantiConfigurazione.DISABILITATO.equals(sa.getRispostaAsincrona().getConnettore().getTipo())) && CostantiConfigurazione.DISABILITATO.equals(sa.getRispostaAsincrona().getGetMessage())) {
                    sa.setRispostaAsincrona(null);
                }
                lista.add(sa);
            }
            ArrayList<ServizioApplicativo> arrayList = lista;
            return arrayList;
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<PortaApplicativa> getPorteApplicativeBySoggettoVirtuale(IDSoggetto soggettoVirtuale) throws DriverConfigurazioneException {
        Connection con = null;
        boolean error = false;
        Statement stm = null;
        ResultSet rs = null;
        ArrayList<PortaApplicativa> lista = new ArrayList<PortaApplicativa>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("getPorteApplicativeBySoggettoVirtuale");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getPorteApplicativeBySoggettoVirtuale] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("porte_applicative");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addWhereCondition("tipo_soggetto_virtuale is not null");
            sqlQueryObject.addWhereCondition("nome_soggetto_virtuale is not null");
            sqlQueryObject.addWhereCondition("tipo_soggetto_virtuale = ?");
            sqlQueryObject.addWhereCondition("nome_soggetto_virtuale = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(queryString);
            stm.setString(1, soggettoVirtuale.getTipo());
            stm.setString(2, soggettoVirtuale.getNome());
            rs = stm.executeQuery();
            while (rs.next()) {
                lista.add(this.getPortaApplicativa(rs.getLong("id"), con));
            }
            rs.close();
            stm.close();
            ArrayList<PortaApplicativa> arrayList = lista;
            return arrayList;
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getPorteApplicativeBySoggettoVirtuale] Errore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public Property[] getPropertiesConnettore(String nomeConnettore) throws DriverConfigurazioneException {
        Connection con = null;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("getPropertiesConnettore");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverRegistroServiziDB::getPropertiesConnettore] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        return this.getPropertiesConnettore(nomeConnettore, con);
    }

    public Property[] getPropertiesConnettore(String nomeConnettore, Connection connection) throws DriverConfigurazioneException {
        try {
            List<Property> cList = ConnettorePropertiesUtilities.getPropertiesConnettore(nomeConnettore, connection, this.tipoDB);
            return cList.toArray(new Property[cList.size()]);
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("[DriverRegistroServiziDB::getPropertiesConnettore] DriverConfigurazioneException : " + e.getMessage(), e);
        }
    }

    @Override
    public List<IDSoggetto> getAllIdSoggetti(FiltroRicercaSoggetti filtroRicerca) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        this.log.debug("getAllIdSoggetti...");
        try {
            this.log.debug("operazione atomica = " + this.atomica);
            con = this.atomica ? this.getConnectionFromDatasource("getAllIdSoggetti") : this.globalConnection;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("tipo_soggetto");
            sqlQueryObject.addSelectField("nome_soggetto");
            if (filtroRicerca != null) {
                if (filtroRicerca.getMinDate() != null) {
                    sqlQueryObject.addWhereCondition("ora_registrazione > ?");
                }
                if (filtroRicerca.getMaxDate() != null) {
                    sqlQueryObject.addWhereCondition("ora_registrazione < ?");
                }
                if (filtroRicerca.getTipo() != null) {
                    sqlQueryObject.addWhereCondition("tipo_soggetto = ?");
                }
                if (filtroRicerca.getNome() != null) {
                    sqlQueryObject.addWhereCondition("nome_soggetto = ?");
                }
            }
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            this.log.debug("eseguo query : " + sqlQuery);
            stm = con.prepareStatement(sqlQuery);
            int indexStmt = 1;
            if (filtroRicerca != null) {
                if (filtroRicerca.getMinDate() != null) {
                    this.log.debug("minDate stmt.setTimestamp(" + filtroRicerca.getMinDate() + ")");
                    stm.setTimestamp(indexStmt, new Timestamp(filtroRicerca.getMinDate().getTime()));
                    ++indexStmt;
                }
                if (filtroRicerca.getMaxDate() != null) {
                    this.log.debug("maxDate stmt.setTimestamp(" + filtroRicerca.getMaxDate() + ")");
                    stm.setTimestamp(indexStmt, new Timestamp(filtroRicerca.getMaxDate().getTime()));
                    ++indexStmt;
                }
                if (filtroRicerca.getTipo() != null) {
                    this.log.debug("tipoSoggetto stmt.setString(" + filtroRicerca.getTipo() + ")");
                    stm.setString(indexStmt, filtroRicerca.getTipo());
                    ++indexStmt;
                }
                if (filtroRicerca.getNome() != null) {
                    this.log.debug("nomeSoggetto stmt.setString(" + filtroRicerca.getNome() + ")");
                    stm.setString(indexStmt, filtroRicerca.getNome());
                    ++indexStmt;
                }
            }
            rs = stm.executeQuery();
            Vector<IDSoggetto> idSoggetti = new Vector<IDSoggetto>();
            while (rs.next()) {
                IDSoggetto idS = new IDSoggetto(rs.getString("tipo_soggetto"), rs.getString("nome_soggetto"));
                idSoggetti.add(idS);
            }
            if (idSoggetti.size() == 0) {
                if (filtroRicerca != null) {
                    throw new DriverConfigurazioneNotFound("Soggetti non trovati che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
                }
                throw new DriverConfigurazioneNotFound("Soggetti non trovati");
            }
            Vector<IDSoggetto> vector = idSoggetti;
            return vector;
        }
        catch (DriverConfigurazioneNotFound de) {
            throw de;
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("getAllIdSoggetti error", e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public List<IDPortaDelegata> getAllIdPorteDelegate(FiltroRicercaPorteDelegate filtroRicerca) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        this.log.debug("getAllIdPorteDelegate...");
        try {
            this.log.debug("operazione atomica = " + this.atomica);
            con = this.atomica ? this.getConnectionFromDatasource("getAllIdPorteDelegate") : this.globalConnection;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("porte_delegate");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("porte_delegate.nome_porta");
            sqlQueryObject.addSelectField("porte_delegate.location");
            sqlQueryObject.addSelectField("soggetti.tipo_soggetto");
            sqlQueryObject.addSelectField("soggetti.nome_soggetto");
            sqlQueryObject.addWhereCondition("porte_delegate.id_soggetto = soggetti.id");
            if (filtroRicerca != null && filtroRicerca.getIdRuolo() != null) {
                sqlQueryObject.addFromTable("pd_ruoli");
                sqlQueryObject.addWhereCondition("pd_ruoli.id_porta = porte_delegate.id");
            }
            if (filtroRicerca != null) {
                if (filtroRicerca.getMinDate() != null) {
                    sqlQueryObject.addWhereCondition("porte_delegate.ora_registrazione > ?");
                }
                if (filtroRicerca.getMaxDate() != null) {
                    sqlQueryObject.addWhereCondition("porte_delegate.ora_registrazione < ?");
                }
                if (filtroRicerca.getTipoSoggetto() != null) {
                    sqlQueryObject.addWhereCondition("soggetti.tipo_soggetto = ?");
                }
                if (filtroRicerca.getNomeSoggetto() != null) {
                    sqlQueryObject.addWhereCondition("soggetti.nome_soggetto = ?");
                }
                if (filtroRicerca.getTipoSoggettoErogatore() != null) {
                    sqlQueryObject.addWhereCondition("porte_delegate.tipo_soggetto_erogatore = ?");
                }
                if (filtroRicerca.getNomeSoggettoErogatore() != null) {
                    sqlQueryObject.addWhereCondition("porte_delegate.nome_soggetto_erogatore = ?");
                }
                if (filtroRicerca.getTipoServizio() != null) {
                    sqlQueryObject.addWhereCondition("porte_delegate.tipo_servizio = ?");
                }
                if (filtroRicerca.getNomeServizio() != null) {
                    sqlQueryObject.addWhereCondition("porte_delegate.nome_servizio = ?");
                }
                if (filtroRicerca.getAzione() != null) {
                    sqlQueryObject.addWhereCondition("porte_delegate.nome_azione = ?");
                }
                if (filtroRicerca.getNome() != null) {
                    sqlQueryObject.addWhereCondition("porte_delegate.nome_porta = ?");
                }
                if (filtroRicerca.getIdRuolo() != null) {
                    sqlQueryObject.addWhereCondition("pd_ruoli.ruolo = ?");
                }
                if (filtroRicerca.getStato() != null) {
                    sqlQueryObject.addWhereCondition("porte_delegate.stato = ?");
                }
            }
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            this.log.debug("eseguo query : " + sqlQuery);
            stm = con.prepareStatement(sqlQuery);
            int indexStmt = 1;
            if (filtroRicerca != null) {
                if (filtroRicerca.getMinDate() != null) {
                    this.log.debug("minDate stmt.setTimestamp(" + filtroRicerca.getMinDate() + ")");
                    stm.setTimestamp(indexStmt, new Timestamp(filtroRicerca.getMinDate().getTime()));
                    ++indexStmt;
                }
                if (filtroRicerca.getMaxDate() != null) {
                    this.log.debug("maxDate stmt.setTimestamp(" + filtroRicerca.getMaxDate() + ")");
                    stm.setTimestamp(indexStmt, new Timestamp(filtroRicerca.getMaxDate().getTime()));
                    ++indexStmt;
                }
                if (filtroRicerca.getTipoSoggetto() != null) {
                    this.log.debug("tipoSoggetto stmt.setString(" + filtroRicerca.getTipoSoggetto() + ")");
                    stm.setString(indexStmt, filtroRicerca.getTipoSoggetto());
                    ++indexStmt;
                }
                if (filtroRicerca.getNomeSoggetto() != null) {
                    this.log.debug("nomeSoggetto stmt.setString(" + filtroRicerca.getNomeSoggetto() + ")");
                    stm.setString(indexStmt, filtroRicerca.getNomeSoggetto());
                    ++indexStmt;
                }
                if (filtroRicerca.getTipoSoggettoErogatore() != null) {
                    this.log.debug("tipoSoggettoErogatore stmt.setString(" + filtroRicerca.getTipoSoggettoErogatore() + ")");
                    stm.setString(indexStmt, filtroRicerca.getTipoSoggettoErogatore());
                    ++indexStmt;
                }
                if (filtroRicerca.getNomeSoggettoErogatore() != null) {
                    this.log.debug("nomeSoggettoErogatore stmt.setString(" + filtroRicerca.getNomeSoggettoErogatore() + ")");
                    stm.setString(indexStmt, filtroRicerca.getNomeSoggettoErogatore());
                    ++indexStmt;
                }
                if (filtroRicerca.getTipoServizio() != null) {
                    this.log.debug("tipoServizio stmt.setString(" + filtroRicerca.getTipoServizio() + ")");
                    stm.setString(indexStmt, filtroRicerca.getTipoServizio());
                    ++indexStmt;
                }
                if (filtroRicerca.getNomeServizio() != null) {
                    this.log.debug("nomeServizio stmt.setString(" + filtroRicerca.getNomeServizio() + ")");
                    stm.setString(indexStmt, filtroRicerca.getNomeServizio());
                    ++indexStmt;
                }
                if (filtroRicerca.getAzione() != null) {
                    this.log.debug("azione stmt.setString(" + filtroRicerca.getAzione() + ")");
                    stm.setString(indexStmt, filtroRicerca.getAzione());
                    ++indexStmt;
                }
                if (filtroRicerca.getNome() != null) {
                    this.log.debug("nome stmt.setString(" + filtroRicerca.getNome() + ")");
                    stm.setString(indexStmt, filtroRicerca.getNome());
                    ++indexStmt;
                }
                if (filtroRicerca.getIdRuolo() != null) {
                    this.log.debug("ruolo stmt.setString(" + filtroRicerca.getIdRuolo().getNome() + ")");
                    stm.setString(indexStmt, filtroRicerca.getIdRuolo().getNome());
                    ++indexStmt;
                }
                if (filtroRicerca.getStato() != null) {
                    this.log.debug("ruolo stmt.setString(" + filtroRicerca.getStato().getValue() + ")");
                    stm.setString(indexStmt, filtroRicerca.getStato().getValue());
                    ++indexStmt;
                }
            }
            rs = stm.executeQuery();
            Vector<IDPortaDelegata> idsPD = new Vector<IDPortaDelegata>();
            while (rs.next()) {
                IDSoggetto idS = new IDSoggetto(rs.getString("tipo_soggetto"), rs.getString("nome_soggetto"));
                IDPortaDelegata idPD = new IDPortaDelegata();
                idPD.setSoggettoFruitore(idS);
                String location = rs.getString("location");
                if (location != null && !"".equals(location)) {
                    idPD.setLocationPD(location);
                } else {
                    idPD.setLocationPD(rs.getString("nome_porta"));
                }
                idsPD.add(idPD);
            }
            if (idsPD.size() == 0) {
                if (filtroRicerca != null) {
                    throw new DriverConfigurazioneNotFound("PorteDelegate non trovate che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
                }
                throw new DriverConfigurazioneNotFound("PorteDelegate non trovate");
            }
            Vector<IDPortaDelegata> vector = idsPD;
            return vector;
        }
        catch (DriverConfigurazioneNotFound de) {
            throw de;
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("getAllIdPorteDelegate error", e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public List<IDPortaApplicativaByNome> getAllIdPorteApplicative(FiltroRicercaPorteApplicative filtroRicerca) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        this.log.debug("getAllIdPorteApplicative...");
        try {
            this.log.debug("operazione atomica = " + this.atomica);
            con = this.atomica ? this.getConnectionFromDatasource("getAllIdPorteApplicative") : this.globalConnection;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("porte_applicative");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("porte_applicative.nome_porta");
            sqlQueryObject.addSelectField("soggetti.tipo_soggetto");
            sqlQueryObject.addSelectField("soggetti.nome_soggetto");
            sqlQueryObject.addWhereCondition("porte_applicative.id_soggetto = soggetti.id");
            if (filtroRicerca != null && filtroRicerca.getIdRuolo() != null) {
                sqlQueryObject.addFromTable("pa_ruoli");
                sqlQueryObject.addWhereCondition("pa_ruoli.id_porta = porte_applicative.id");
            }
            if (filtroRicerca != null) {
                if (filtroRicerca.getMinDate() != null) {
                    sqlQueryObject.addWhereCondition("porte_applicative.ora_registrazione > ?");
                }
                if (filtroRicerca.getMaxDate() != null) {
                    sqlQueryObject.addWhereCondition("porte_applicative.ora_registrazione < ?");
                }
                if (filtroRicerca.getTipoSoggetto() != null) {
                    sqlQueryObject.addWhereCondition("soggetti.tipo_soggetto = ?");
                }
                if (filtroRicerca.getNomeSoggetto() != null) {
                    sqlQueryObject.addWhereCondition("soggetti.nome_soggetto = ?");
                }
                if (filtroRicerca.getTipoSoggettoVirtuale() != null) {
                    sqlQueryObject.addWhereCondition("porte_applicative.tipo_soggetto_virtuale = ?");
                }
                if (filtroRicerca.getNomeSoggettoVirtuale() != null) {
                    sqlQueryObject.addWhereCondition("porte_applicative.nome_soggetto_virtuale = ?");
                }
                if (filtroRicerca.getTipoServizio() != null) {
                    sqlQueryObject.addWhereCondition("porte_applicative.tipo_servizio = ?");
                }
                if (filtroRicerca.getNomeServizio() != null) {
                    sqlQueryObject.addWhereCondition("porte_applicative.servizio = ?");
                }
                if (filtroRicerca.getAzione() != null) {
                    sqlQueryObject.addWhereCondition("porte_applicative.azione = ?");
                }
                if (filtroRicerca.getNome() != null) {
                    sqlQueryObject.addWhereCondition("porte_applicative.nome_porta = ?");
                }
                if (filtroRicerca.getIdRuolo() != null) {
                    sqlQueryObject.addWhereCondition("pa_ruoli.ruolo = ?");
                }
                if (filtroRicerca.getStato() != null) {
                    sqlQueryObject.addWhereCondition("porte_applicative.stato = ?");
                }
            }
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            this.log.debug("eseguo query : " + sqlQuery);
            stm = con.prepareStatement(sqlQuery);
            int indexStmt = 1;
            if (filtroRicerca != null) {
                if (filtroRicerca.getMinDate() != null) {
                    this.log.debug("minDate stmt.setTimestamp(" + filtroRicerca.getMinDate() + ")");
                    stm.setTimestamp(indexStmt, new Timestamp(filtroRicerca.getMinDate().getTime()));
                    ++indexStmt;
                }
                if (filtroRicerca.getMaxDate() != null) {
                    this.log.debug("maxDate stmt.setTimestamp(" + filtroRicerca.getMaxDate() + ")");
                    stm.setTimestamp(indexStmt, new Timestamp(filtroRicerca.getMaxDate().getTime()));
                    ++indexStmt;
                }
                if (filtroRicerca.getTipoSoggetto() != null) {
                    this.log.debug("tipoSoggetto stmt.setString(" + filtroRicerca.getTipoSoggetto() + ")");
                    stm.setString(indexStmt, filtroRicerca.getTipoSoggetto());
                    ++indexStmt;
                }
                if (filtroRicerca.getNomeSoggetto() != null) {
                    this.log.debug("nomeSoggetto stmt.setString(" + filtroRicerca.getNomeSoggetto() + ")");
                    stm.setString(indexStmt, filtroRicerca.getNomeSoggetto());
                    ++indexStmt;
                }
                if (filtroRicerca.getTipoSoggettoVirtuale() != null) {
                    this.log.debug("tipoSoggettoVirtuale stmt.setString(" + filtroRicerca.getTipoSoggettoVirtuale() + ")");
                    stm.setString(indexStmt, filtroRicerca.getTipoSoggettoVirtuale());
                    ++indexStmt;
                }
                if (filtroRicerca.getNomeSoggettoVirtuale() != null) {
                    this.log.debug("nomeSoggettoVirtuale stmt.setString(" + filtroRicerca.getNomeSoggettoVirtuale() + ")");
                    stm.setString(indexStmt, filtroRicerca.getNomeSoggettoVirtuale());
                    ++indexStmt;
                }
                if (filtroRicerca.getTipoServizio() != null) {
                    this.log.debug("tipoServizio stmt.setString(" + filtroRicerca.getTipoServizio() + ")");
                    stm.setString(indexStmt, filtroRicerca.getTipoServizio());
                    ++indexStmt;
                }
                if (filtroRicerca.getNomeServizio() != null) {
                    this.log.debug("nomeServizio stmt.setString(" + filtroRicerca.getNomeServizio() + ")");
                    stm.setString(indexStmt, filtroRicerca.getNomeServizio());
                    ++indexStmt;
                }
                if (filtroRicerca.getAzione() != null) {
                    this.log.debug("azione stmt.setString(" + filtroRicerca.getAzione() + ")");
                    stm.setString(indexStmt, filtroRicerca.getAzione());
                    ++indexStmt;
                }
                if (filtroRicerca.getNome() != null) {
                    this.log.debug("nome stmt.setString(" + filtroRicerca.getNome() + ")");
                    stm.setString(indexStmt, filtroRicerca.getNome());
                    ++indexStmt;
                }
                if (filtroRicerca.getIdRuolo() != null) {
                    this.log.debug("ruolo stmt.setString(" + filtroRicerca.getIdRuolo().getNome() + ")");
                    stm.setString(indexStmt, filtroRicerca.getIdRuolo().getNome());
                    ++indexStmt;
                }
                if (filtroRicerca.getStato() != null) {
                    this.log.debug("ruolo stmt.setString(" + filtroRicerca.getStato().getValue() + ")");
                    stm.setString(indexStmt, filtroRicerca.getStato().getValue());
                    ++indexStmt;
                }
            }
            rs = stm.executeQuery();
            Vector<IDPortaApplicativaByNome> idsPA = new Vector<IDPortaApplicativaByNome>();
            while (rs.next()) {
                IDSoggetto idS = new IDSoggetto(rs.getString("tipo_soggetto"), rs.getString("nome_soggetto"));
                IDPortaApplicativaByNome idPA = new IDPortaApplicativaByNome();
                idPA.setSoggetto(idS);
                idPA.setNome(rs.getString("nome_porta"));
                idsPA.add(idPA);
            }
            if (idsPA.size() == 0) {
                if (filtroRicerca != null) {
                    throw new DriverConfigurazioneNotFound("PorteApplicative non trovate che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
                }
                throw new DriverConfigurazioneNotFound("PorteApplicative non trovate");
            }
            Vector<IDPortaApplicativaByNome> vector = idsPA;
            return vector;
        }
        catch (DriverConfigurazioneNotFound de) {
            throw de;
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("getAllIdPorteApplicative error", e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public List<IDServizioApplicativo> getAllIdServiziApplicativi(FiltroRicercaServiziApplicativi filtroRicerca) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        this.log.debug("getAllIdServiziApplicativi...");
        try {
            this.log.debug("operazione atomica = " + this.atomica);
            con = this.atomica ? this.getConnectionFromDatasource("getAllIdServiziApplicativi") : this.globalConnection;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("servizi_applicativi");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("servizi_applicativi.nome");
            sqlQueryObject.addSelectField("soggetti.tipo_soggetto");
            sqlQueryObject.addSelectField("soggetti.nome_soggetto");
            sqlQueryObject.addWhereCondition("servizi_applicativi.id_soggetto = soggetti.id");
            if (filtroRicerca != null && filtroRicerca.getIdRuolo() != null) {
                sqlQueryObject.addFromTable("sa_ruoli");
                sqlQueryObject.addWhereCondition("sa_ruoli.id_servizio_applicativo = servizi_applicativi.id");
            }
            if (filtroRicerca != null) {
                if (filtroRicerca.getMinDate() != null) {
                    sqlQueryObject.addWhereCondition("servizi_applicativi.ora_registrazione > ?");
                }
                if (filtroRicerca.getMaxDate() != null) {
                    sqlQueryObject.addWhereCondition("servizi_applicativi.ora_registrazione < ?");
                }
                if (filtroRicerca.getTipoSoggetto() != null) {
                    sqlQueryObject.addWhereCondition("soggetti.tipo_soggetto = ?");
                }
                if (filtroRicerca.getNomeSoggetto() != null) {
                    sqlQueryObject.addWhereCondition("soggetti.nome_soggetto = ?");
                }
                if (filtroRicerca.getNome() != null) {
                    sqlQueryObject.addWhereCondition("servizi_applicativi.nome = ?");
                }
                if (filtroRicerca.getIdRuolo() != null) {
                    sqlQueryObject.addWhereCondition("sa_ruoli.ruolo = ?");
                }
            }
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            this.log.debug("eseguo query : " + sqlQuery);
            stm = con.prepareStatement(sqlQuery);
            int indexStmt = 1;
            if (filtroRicerca != null) {
                if (filtroRicerca.getMinDate() != null) {
                    this.log.debug("minDate stmt.setTimestamp(" + filtroRicerca.getMinDate() + ")");
                    stm.setTimestamp(indexStmt, new Timestamp(filtroRicerca.getMinDate().getTime()));
                    ++indexStmt;
                }
                if (filtroRicerca.getMaxDate() != null) {
                    this.log.debug("maxDate stmt.setTimestamp(" + filtroRicerca.getMaxDate() + ")");
                    stm.setTimestamp(indexStmt, new Timestamp(filtroRicerca.getMaxDate().getTime()));
                    ++indexStmt;
                }
                if (filtroRicerca.getTipoSoggetto() != null) {
                    this.log.debug("tipoSoggetto stmt.setString(" + filtroRicerca.getTipoSoggetto() + ")");
                    stm.setString(indexStmt, filtroRicerca.getTipoSoggetto());
                    ++indexStmt;
                }
                if (filtroRicerca.getNomeSoggetto() != null) {
                    this.log.debug("nomeSoggetto stmt.setString(" + filtroRicerca.getNomeSoggetto() + ")");
                    stm.setString(indexStmt, filtroRicerca.getNomeSoggetto());
                    ++indexStmt;
                }
                if (filtroRicerca.getNome() != null) {
                    this.log.debug("nome stmt.setString(" + filtroRicerca.getNome() + ")");
                    stm.setString(indexStmt, filtroRicerca.getNome());
                    ++indexStmt;
                }
                if (filtroRicerca.getIdRuolo() != null) {
                    this.log.debug("ruolo stmt.setString(" + filtroRicerca.getIdRuolo().getNome() + ")");
                    stm.setString(indexStmt, filtroRicerca.getIdRuolo().getNome());
                    ++indexStmt;
                }
            }
            rs = stm.executeQuery();
            Vector<IDServizioApplicativo> idsSA = new Vector<IDServizioApplicativo>();
            while (rs.next()) {
                IDSoggetto idS = new IDSoggetto(rs.getString("tipo_soggetto"), rs.getString("nome_soggetto"));
                IDServizioApplicativo idSA = new IDServizioApplicativo();
                idSA.setIdSoggettoProprietario(idS);
                idSA.setNome(rs.getString("nome"));
                idsSA.add(idSA);
            }
            if (idsSA.size() == 0) {
                if (filtroRicerca != null) {
                    throw new DriverConfigurazioneNotFound("ServiziApplicativi non trovati che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
                }
                throw new DriverConfigurazioneNotFound("ServiziApplicativi non trovati");
            }
            Vector<IDServizioApplicativo> vector = idsSA;
            return vector;
        }
        catch (DriverConfigurazioneNotFound de) {
            throw de;
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("getAllIdServiziApplicativi error", e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public List<MtomProcessorFlowParameter> porteDelegateMTOMRequestList(int idPortaDelegata, ISearch ricerca) throws DriverConfigurazioneException {
        String nomeMetodo = "porteDelegateMTOMRequestList";
        int idLista = 23;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        boolean error = false;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<MtomProcessorFlowParameter> lista = new ArrayList<MtomProcessorFlowParameter>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource(nomeMetodo);
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("pd_mtom_request");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("pd_mtom_request");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setInt(1, idPortaDelegata);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("pd_mtom_request");
                sqlQueryObject.addSelectField("id_porta");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("pattern");
                sqlQueryObject.addSelectField("content_type");
                sqlQueryObject.addSelectField("required");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("pd_mtom_request");
                sqlQueryObject.addSelectField("id_porta");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("pattern");
                sqlQueryObject.addSelectField("content_type");
                sqlQueryObject.addSelectField("required");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortaDelegata);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                MtomProcessorFlowParameter reqPar = new MtomProcessorFlowParameter();
                reqPar.setId(risultato.getLong("id_porta"));
                reqPar.setNome(risultato.getString("nome"));
                reqPar.setPattern(risultato.getString("pattern"));
                reqPar.setContentType(risultato.getString("content_type"));
                int required = risultato.getInt("required");
                boolean isrequired = false;
                if (required == 1) {
                    isrequired = true;
                }
                reqPar.setRequired(isrequired);
                lista.add(reqPar);
            }
            ArrayList<MtomProcessorFlowParameter> arrayList = lista;
            return arrayList;
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public List<MtomProcessorFlowParameter> porteDelegateMTOMResponseList(int idPortaDelegata, ISearch ricerca) throws DriverConfigurazioneException {
        String nomeMetodo = "porteDelegateMTOMResponseList";
        int idLista = 24;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        boolean error = false;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<MtomProcessorFlowParameter> lista = new ArrayList<MtomProcessorFlowParameter>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource(nomeMetodo);
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("pd_mtom_response");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("pd_mtom_response");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortaDelegata);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("pd_mtom_response");
                sqlQueryObject.addSelectField("id_porta");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("pattern");
                sqlQueryObject.addSelectField("content_type");
                sqlQueryObject.addSelectField("required");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("pd_mtom_response");
                sqlQueryObject.addSelectField("id_porta");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("pattern");
                sqlQueryObject.addSelectField("content_type");
                sqlQueryObject.addSelectField("required");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortaDelegata);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                MtomProcessorFlowParameter resPar = new MtomProcessorFlowParameter();
                resPar.setId(risultato.getLong("id_porta"));
                resPar.setNome(risultato.getString("nome"));
                resPar.setPattern(risultato.getString("pattern"));
                resPar.setContentType(risultato.getString("content_type"));
                int required = risultato.getInt("required");
                boolean isrequired = false;
                if (required == 1) {
                    isrequired = true;
                }
                resPar.setRequired(isrequired);
                lista.add(resPar);
            }
            ArrayList<MtomProcessorFlowParameter> arrayList = lista;
            return arrayList;
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public List<MtomProcessorFlowParameter> porteApplicativeMTOMRequestList(int idPortaApplicativa, ISearch ricerca) throws DriverConfigurazioneException {
        String nomeMetodo = "porteApplicativeMTOMRequestList";
        int idLista = 12;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        boolean error = false;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<MtomProcessorFlowParameter> lista = new ArrayList<MtomProcessorFlowParameter>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource(nomeMetodo);
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("pa_mtom_request");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("pa_mtom_request");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setInt(1, idPortaApplicativa);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("pa_mtom_request");
                sqlQueryObject.addSelectField("id_porta");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("pattern");
                sqlQueryObject.addSelectField("content_type");
                sqlQueryObject.addSelectField("required");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("pa_mtom_request");
                sqlQueryObject.addSelectField("id_porta");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("pattern");
                sqlQueryObject.addSelectField("content_type");
                sqlQueryObject.addSelectField("required");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortaApplicativa);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                MtomProcessorFlowParameter reqPar = new MtomProcessorFlowParameter();
                reqPar.setId(risultato.getLong("id_porta"));
                reqPar.setNome(risultato.getString("nome"));
                reqPar.setPattern(risultato.getString("pattern"));
                reqPar.setContentType(risultato.getString("content_type"));
                int required = risultato.getInt("required");
                boolean isrequired = false;
                if (required == 1) {
                    isrequired = true;
                }
                reqPar.setRequired(isrequired);
                lista.add(reqPar);
            }
            ArrayList<MtomProcessorFlowParameter> arrayList = lista;
            return arrayList;
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public List<MtomProcessorFlowParameter> porteApplicativeMTOMResponseList(int idPortaApplicativa, ISearch ricerca) throws DriverConfigurazioneException {
        String nomeMetodo = "porteApplicativeMTOMResponseList";
        int idLista = 13;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        boolean error = false;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<MtomProcessorFlowParameter> lista = new ArrayList<MtomProcessorFlowParameter>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource(nomeMetodo);
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("pa_mtom_response");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("pa_mtom_response");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortaApplicativa);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("pa_mtom_response");
                sqlQueryObject.addSelectField("id_porta");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("pattern");
                sqlQueryObject.addSelectField("content_type");
                sqlQueryObject.addSelectField("required");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("pa_mtom_response");
                sqlQueryObject.addSelectField("id_porta");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("pattern");
                sqlQueryObject.addSelectField("content_type");
                sqlQueryObject.addSelectField("required");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortaApplicativa);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                MtomProcessorFlowParameter resPar = new MtomProcessorFlowParameter();
                resPar.setId(risultato.getLong("id_porta"));
                resPar.setNome(risultato.getString("nome"));
                resPar.setPattern(risultato.getString("pattern"));
                resPar.setContentType(risultato.getString("content_type"));
                int required = risultato.getInt("required");
                boolean isrequired = false;
                if (required == 1) {
                    isrequired = true;
                }
                resPar.setRequired(isrequired);
                lista.add(resPar);
            }
            ArrayList<MtomProcessorFlowParameter> arrayList = lista;
            return arrayList;
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

