/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.driver;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.AccessoRegistro;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.AccessoRegistroRegistro;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.Attachments;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.Cache;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.Configurazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.Connettore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.CorrelazioneApplicativa;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.CorrelazioneApplicativaElemento;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.CorrelazioneApplicativaRisposta;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.CorrelazioneApplicativaRispostaElemento;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.Credenziali;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.GestioneErrore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.GestioneErroreCodiceTrasporto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.GestioneErroreSoapFault;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.IndirizzoRisposta;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.InoltroBusteNonRiscontrate;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.IntegrationManager;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.InvocazioneCredenziali;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.InvocazionePorta;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.InvocazionePortaGestioneErrore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.InvocazioneServizio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.MessageSecurity;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.MessageSecurityFlow;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.MessageSecurityFlowParameter;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.MessaggiDiagnostici;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.MtomProcessor;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.MtomProcessorFlow;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.MtomProcessorFlowParameter;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.Openspcoop2;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.OpenspcoopAppender;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.PortaApplicativa;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.PortaApplicativaAzione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.PortaApplicativaServizio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.PortaApplicativaSoggettoVirtuale;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.PortaDelegata;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.PortaDelegataAzione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.PortaDelegataServizio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.PortaDelegataSoggettoErogatore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.Property;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.ProprietaProtocollo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.RispostaAsincrona;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.Risposte;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.Route;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.RouteGateway;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.RouteRegistro;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.RoutingTable;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.RoutingTableDefault;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.RoutingTableDestinazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.ServizioApplicativo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.Soggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.StatoServiziPdd;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.StatoServiziPddIntegrationManager;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.StatoServiziPddPortaApplicativa;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.StatoServiziPddPortaDelegata;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.TipoFiltroAbilitazioneServizi;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.Tracciamento;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.ValidazioneBuste;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.ValidazioneContenutiApplicativi;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.constants.AlgoritmoCache;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.constants.CorrelazioneApplicativaGestioneIdentificazioneFallita;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.constants.CorrelazioneApplicativaRichiestaIdentificazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.constants.CorrelazioneApplicativaRispostaIdentificazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.constants.CostantiConfigurazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.constants.CredenzialeTipo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.constants.FaultIntegrazioneTipo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.constants.GestioneErroreComportamento;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.constants.InvocazioneServizioTipoAutenticazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.constants.PortaDelegataAzioneIdentificazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.constants.PortaDelegataServizioIdentificazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.constants.PortaDelegataSoggettoErogatoreIdentificazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.constants.RegistroTipo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.constants.Severita;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.constants.StatoFunzionalita;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.constants.StatoFunzionalitaConWarning;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.constants.TipoConnessioneRisposte;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.constants.ValidazioneBusteTipoControllo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.constants.ValidazioneContenutiApplicativiTipo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.driver.DriverConfigurazioneException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.constants.TipiConnettore;
import it.link.pdd.tools.migrazione_govway.utils.Utilities;
import it.link.pdd.tools.migrazione_govway.utils.beans.BaseBean;
import it.link.pdd.tools.migrazione_govway.utils.regexp.RegExpUtilities;
import it.link.pdd.tools.migrazione_govway.utils.regexp.RegularExpressionEngine;
import java.io.File;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.slf4j.Logger;

public class ValidazioneSemantica {
    private Openspcoop2 configurazione = null;
    private List<String> errori = new ArrayList<String>();
    private Logger log = null;
    private boolean validazioneConfigurazione = false;
    private List<String> tipoConnettori = new ArrayList<String>();
    private List<String> tipoSoggetti = new ArrayList<String>();
    private List<String> tipoServizi = new ArrayList<String>();
    private List<String> tipoMsgDiagnosticiAppender = new ArrayList<String>();
    private List<String> tipoTracciamentoAppender = new ArrayList<String>();
    private List<String> tipoAutenticazionePortaDelegata = new ArrayList<String>();
    private List<String> tipoAutenticazionePortaApplicativa = new ArrayList<String>();
    private List<String> tipoAutorizzazionePortaDelegata = new ArrayList<String>();
    private List<String> tipoAutorizzazionePortaApplicativa = new ArrayList<String>();
    private List<String> tipoAutorizzazioneContenutoPortaDelegata = new ArrayList<String>();
    private List<String> tipoAutorizzazioneContenutoPortaApplicativa = new ArrayList<String>();
    private List<String> tipoIntegrazionePD = new ArrayList<String>();
    private List<String> tipoIntegrazionePA = new ArrayList<String>();

    private String getTipoConnettori() {
        StringBuffer bf = new StringBuffer();
        for (int i = 0; i < this.tipoConnettori.size(); ++i) {
            if (i > 0) {
                bf.append(",");
            }
            bf.append(this.tipoConnettori.get(i));
        }
        return bf.toString();
    }

    private String getTipoSoggetti() {
        StringBuffer bf = new StringBuffer();
        for (int i = 0; i < this.tipoSoggetti.size(); ++i) {
            if (i > 0) {
                bf.append(",");
            }
            bf.append(this.tipoSoggetti.get(i));
        }
        return bf.toString();
    }

    private String getTipoServizi() {
        StringBuffer bf = new StringBuffer();
        for (int i = 0; i < this.tipoServizi.size(); ++i) {
            if (i > 0) {
                bf.append(",");
            }
            bf.append(this.tipoServizi.get(i));
        }
        return bf.toString();
    }

    private String getTipoMsgDiagnosticiAppender() {
        StringBuffer bf = new StringBuffer();
        for (int i = 0; i < this.tipoMsgDiagnosticiAppender.size(); ++i) {
            if (i > 0) {
                bf.append(",");
            }
            bf.append(this.tipoMsgDiagnosticiAppender.get(i));
        }
        return bf.toString();
    }

    private String getTipoTracciamentoAppender() {
        StringBuffer bf = new StringBuffer();
        for (int i = 0; i < this.tipoTracciamentoAppender.size(); ++i) {
            if (i > 0) {
                bf.append(",");
            }
            bf.append(this.tipoTracciamentoAppender.get(i));
        }
        return bf.toString();
    }

    private String getTipoAutenticazionePortaDelegata() {
        StringBuffer bf = new StringBuffer();
        for (int i = 0; i < this.tipoAutenticazionePortaDelegata.size(); ++i) {
            if (i > 0) {
                bf.append(",");
            }
            bf.append(this.tipoAutenticazionePortaDelegata.get(i));
        }
        return bf.toString();
    }

    private String getTipoAutenticazionePortaApplicativa() {
        StringBuffer bf = new StringBuffer();
        for (int i = 0; i < this.tipoAutenticazionePortaApplicativa.size(); ++i) {
            if (i > 0) {
                bf.append(",");
            }
            bf.append(this.tipoAutenticazionePortaApplicativa.get(i));
        }
        return bf.toString();
    }

    private String getTipoAutorizzazionePortaDelegata() {
        StringBuffer bf = new StringBuffer();
        for (int i = 0; i < this.tipoAutorizzazionePortaDelegata.size(); ++i) {
            if (i > 0) {
                bf.append(",");
            }
            bf.append(this.tipoAutorizzazionePortaDelegata.get(i));
        }
        return bf.toString();
    }

    private String getTipoAutorizzazionePortaApplicativa() {
        StringBuffer bf = new StringBuffer();
        for (int i = 0; i < this.tipoAutorizzazionePortaApplicativa.size(); ++i) {
            if (i > 0) {
                bf.append(",");
            }
            bf.append(this.tipoAutorizzazionePortaApplicativa.get(i));
        }
        return bf.toString();
    }

    private String getTipoAutorizzazioneContenutoPortaDelegata() {
        StringBuffer bf = new StringBuffer();
        for (int i = 0; i < this.tipoAutorizzazioneContenutoPortaDelegata.size(); ++i) {
            if (i > 0) {
                bf.append(",");
            }
            bf.append(this.tipoAutorizzazioneContenutoPortaDelegata.get(i));
        }
        return bf.toString();
    }

    private String getTipoAutorizzazioneContenutoPortaApplicativa() {
        StringBuffer bf = new StringBuffer();
        for (int i = 0; i < this.tipoAutorizzazioneContenutoPortaApplicativa.size(); ++i) {
            if (i > 0) {
                bf.append(",");
            }
            bf.append(this.tipoAutorizzazioneContenutoPortaApplicativa.get(i));
        }
        return bf.toString();
    }

    private String getTipoIntegrazionePD() {
        StringBuffer bf = new StringBuffer();
        for (int i = 0; i < this.tipoIntegrazionePD.size(); ++i) {
            if (i > 0) {
                bf.append(",");
            }
            bf.append(this.tipoIntegrazionePD.get(i));
        }
        return bf.toString();
    }

    private String getTipoIntegrazionePA() {
        StringBuffer bf = new StringBuffer();
        for (int i = 0; i < this.tipoIntegrazionePA.size(); ++i) {
            if (i > 0) {
                bf.append(",");
            }
            bf.append(this.tipoIntegrazionePA.get(i));
        }
        return bf.toString();
    }

    public ValidazioneSemantica(Openspcoop2 configurazione, String[] tipoConnettori, String[] tipoSoggetti, String[] tipoServizi, String[] tipoMsgDiagnosticiAppender, String[] tipoTracciamentoAppender, String[] tipoAutenticazionePortaDelegata, String[] tipoAutenticazionePortaApplicativa, String[] tipoAutorizzazionePortaDelegata, String[] tipoAutorizzazionePortaApplicativa, String[] tipoAutorizzazioneContenutoPortaDelegata, String[] tipoAutorizzazioneContenutoPortaApplicativa, String[] tipoIntegrazionePD, String[] tipoIntegrazionePA, boolean validazioneConfigurazione, Logger log) throws DriverConfigurazioneException {
        int i;
        this.configurazione = configurazione;
        this.log = log;
        this.validazioneConfigurazione = validazioneConfigurazione;
        if (tipoConnettori != null && tipoConnettori.length > 0) {
            for (i = 0; i < tipoConnettori.length; ++i) {
                this.tipoConnettori.add(tipoConnettori[i]);
            }
        } else {
            throw new DriverConfigurazioneException("Tipo di connettori ammissibili non definiti");
        }
        if (tipoSoggetti != null && tipoSoggetti.length > 0) {
            for (i = 0; i < tipoSoggetti.length; ++i) {
                this.tipoSoggetti.add(tipoSoggetti[i]);
            }
        } else {
            throw new DriverConfigurazioneException("Tipo di soggetti ammissibili non definiti");
        }
        if (tipoServizi != null && tipoServizi.length > 0) {
            for (i = 0; i < tipoServizi.length; ++i) {
                this.tipoServizi.add(tipoServizi[i]);
            }
        } else {
            throw new DriverConfigurazioneException("Tipo di servizi ammissibili non definiti");
        }
        if (tipoMsgDiagnosticiAppender != null && tipoMsgDiagnosticiAppender.length > 0) {
            for (i = 0; i < tipoMsgDiagnosticiAppender.length; ++i) {
                this.tipoMsgDiagnosticiAppender.add(tipoMsgDiagnosticiAppender[i]);
            }
        } else {
            throw new DriverConfigurazioneException("Tipo di appender ammissibili per i msg diagnostici non definiti");
        }
        if (tipoTracciamentoAppender != null && tipoTracciamentoAppender.length > 0) {
            for (i = 0; i < tipoTracciamentoAppender.length; ++i) {
                this.tipoTracciamentoAppender.add(tipoTracciamentoAppender[i]);
            }
        } else {
            throw new DriverConfigurazioneException("Tipo di appender ammissibili per le traccie non definiti");
        }
        if (tipoAutenticazionePortaDelegata != null && tipoAutenticazionePortaDelegata.length > 0) {
            for (i = 0; i < tipoAutenticazionePortaDelegata.length; ++i) {
                this.tipoAutenticazionePortaDelegata.add(tipoAutenticazionePortaDelegata[i]);
            }
        } else {
            throw new DriverConfigurazioneException("Tipo di processi di autenticazione porta delegata ammissibili non definiti");
        }
        if (tipoAutenticazionePortaApplicativa != null && tipoAutenticazionePortaApplicativa.length > 0) {
            for (i = 0; i < tipoAutenticazionePortaApplicativa.length; ++i) {
                this.tipoAutenticazionePortaApplicativa.add(tipoAutenticazionePortaApplicativa[i]);
            }
        } else {
            throw new DriverConfigurazioneException("Tipo di processi di autenticazione porta applicativa ammissibili non definiti");
        }
        if (tipoAutorizzazionePortaDelegata != null && tipoAutorizzazionePortaDelegata.length > 0) {
            for (i = 0; i < tipoAutorizzazionePortaDelegata.length; ++i) {
                this.tipoAutorizzazionePortaDelegata.add(tipoAutorizzazionePortaDelegata[i]);
            }
        } else {
            throw new DriverConfigurazioneException("Tipo di processi di autorizzazione porta delegata ammissibili non definiti");
        }
        if (tipoAutorizzazionePortaApplicativa != null && tipoAutorizzazionePortaApplicativa.length > 0) {
            for (i = 0; i < tipoAutorizzazionePortaApplicativa.length; ++i) {
                this.tipoAutorizzazionePortaApplicativa.add(tipoAutorizzazionePortaApplicativa[i]);
            }
        } else {
            throw new DriverConfigurazioneException("Tipo di processi di autorizzazione porta applicativa ammissibili non definiti");
        }
        if (tipoAutorizzazioneContenutoPortaDelegata != null && tipoAutorizzazioneContenutoPortaDelegata.length > 0) {
            for (i = 0; i < tipoAutorizzazioneContenutoPortaDelegata.length; ++i) {
                this.tipoAutorizzazioneContenutoPortaDelegata.add(tipoAutorizzazioneContenutoPortaDelegata[i]);
            }
        } else {
            throw new DriverConfigurazioneException("Tipo di processi di autorizzazione contenuto porta delegata ammissibili non definiti");
        }
        if (tipoAutorizzazioneContenutoPortaApplicativa != null && tipoAutorizzazioneContenutoPortaApplicativa.length > 0) {
            for (i = 0; i < tipoAutorizzazioneContenutoPortaApplicativa.length; ++i) {
                this.tipoAutorizzazioneContenutoPortaApplicativa.add(tipoAutorizzazioneContenutoPortaApplicativa[i]);
            }
        } else {
            throw new DriverConfigurazioneException("Tipo di processi di autorizzazione contenuto porta applicativa ammissibili non definiti");
        }
        if (tipoIntegrazionePD != null && tipoIntegrazionePD.length > 0) {
            for (i = 0; i < tipoIntegrazionePD.length; ++i) {
                this.tipoIntegrazionePD.add(tipoIntegrazionePD[i]);
            }
        } else {
            throw new DriverConfigurazioneException("Tipo di integrazione lato PortaDelegata ammissibili non definiti");
        }
        if (tipoIntegrazionePA != null && tipoIntegrazionePA.length > 0) {
            for (i = 0; i < tipoIntegrazionePA.length; ++i) {
                this.tipoIntegrazionePA.add(tipoIntegrazionePA[i]);
            }
        } else {
            throw new DriverConfigurazioneException("Tipo di integrazione lato PortaApplicativa ammissibili non definiti");
        }
    }

    public ValidazioneSemantica(Openspcoop2 configurazione, String[] tipoConnettori, String[] tipoSoggetti, String[] tipoServizi, String[] tipoMsgDiagnosticiAppender, String[] tipoTracciamentoAppender, String[] tipoAutenticazionePortaDelegata, String[] tipoAutenticazionePortaApplicativa, String[] tipoAutorizzazionePortaDelegata, String[] tipoAutorizzazionePortaApplicativa, String[] tipoAutorizzazioneContenutoPortaDelegata, String[] tipoAutorizzazioneContenutoPortaApplicativa, String[] tipoIntegrazionePD, String[] tipoIntegrazionePA, boolean validazioneConfigurazione) throws DriverConfigurazioneException {
        this(configurazione, tipoConnettori, tipoSoggetti, tipoServizi, tipoMsgDiagnosticiAppender, tipoTracciamentoAppender, tipoAutenticazionePortaDelegata, tipoAutenticazionePortaApplicativa, tipoAutorizzazionePortaDelegata, tipoAutorizzazionePortaApplicativa, tipoAutorizzazioneContenutoPortaDelegata, tipoAutorizzazioneContenutoPortaApplicativa, tipoIntegrazionePD, tipoIntegrazionePA, validazioneConfigurazione, null);
    }

    private void printMsg(String msg) {
        if (this.log == null) {
            this.printMsg(msg);
        } else {
            this.log.debug(msg);
        }
    }

    public void validazioneSemantica(boolean showIDOggettiAnalizzati) throws DriverConfigurazioneException {
        if (showIDOggettiAnalizzati) {
            this.printMsg("\n\n------------------------------------Soggetti(" + this.configurazione.sizeSoggettoList() + ")-----------------------------------------------------");
        }
        for (int i = 0; i < this.configurazione.sizeSoggettoList(); ++i) {
            Soggetto sogg = this.configurazione.getSoggetto(i);
            if (showIDOggettiAnalizzati) {
                this.printMsg("Soggetto: " + sogg.getTipo() + "/" + sogg.getNome());
            }
            this.validaSoggetto(sogg, showIDOggettiAnalizzati);
        }
        if (this.validazioneConfigurazione) {
            if (showIDOggettiAnalizzati) {
                this.printMsg("\n\n------------------------------------Configurazione-----------------------------------------------------");
            }
            this.validaConfigurazione(this.configurazione.getConfigurazione());
        }
        if (showIDOggettiAnalizzati) {
            this.printMsg("\n\n-----------------------------------------------------------------------------------------");
        }
        if (!this.errori.isEmpty()) {
            StringBuffer stringB = new StringBuffer().append("\n");
            Iterator<String> itE = this.errori.iterator();
            while (itE.hasNext()) {
                stringB.append(itE.next()).append("\n");
            }
            throw new DriverConfigurazioneException(stringB.toString());
        }
    }

    private void validaSoggetto(Soggetto sogg, boolean showIDOggettiAnalizzati) throws DriverConfigurazioneException {
        int j;
        if (sogg.getNome() == null) {
            this.errori.add("Esiste un soggetto senza nome");
            return;
        }
        if (sogg.getTipo() == null) {
            this.errori.add("Esiste un soggetto senza tipo");
            return;
        }
        for (j = 0; j < sogg.sizePortaDelegataList(); ++j) {
            PortaDelegata pd = sogg.getPortaDelegata(j);
            if (showIDOggettiAnalizzati) {
                this.printMsg("\tPorta Delegata: " + pd.getNome());
            }
            this.validaPortaDelegata(pd, sogg);
        }
        for (j = 0; j < sogg.sizePortaApplicativaList(); ++j) {
            PortaApplicativa pa = sogg.getPortaApplicativa(j);
            if (showIDOggettiAnalizzati) {
                this.printMsg("\tPortaApplicativa: " + pa.getNome());
            }
            this.validaPortaApplicativa(pa, sogg);
        }
        for (j = 0; j < sogg.sizeServizioApplicativoList(); ++j) {
            ServizioApplicativo sa = sogg.getServizioApplicativo(j);
            if (showIDOggettiAnalizzati) {
                this.printMsg("\tServizioApplicativo: " + sa.getNome());
            }
            this.validaServizioApplicativo(sa, sogg);
        }
        for (j = 0; j < sogg.sizeConnettoreList(); ++j) {
            Connettore connettore = sogg.getConnettore(j);
            if (showIDOggettiAnalizzati) {
                this.printMsg("\tConnettore definito nella root del soggetto: " + connettore.getNome());
            }
            this.validaConnettore(connettore, null, sogg);
        }
        if (!this.tipoSoggetti.contains(sogg.getTipo())) {
            this.errori.add("Il tipo del soggetto " + sogg.getTipo() + "/" + sogg.getNome() + " non \u00e8 valido (Tipi utilizzabili: " + this.getTipoSoggetti() + ")");
        }
        try {
            if (!RegularExpressionEngine.isMatch(sogg.getNome(), "^[0-9A-Za-z]+$")) {
                this.errori.add("Il nome del soggetto " + sogg.getTipo() + "/" + sogg.getNome() + " dev'essere formato solo caratteri e cifre");
            }
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("Errore durante l'analisi tramite espressione regolare del soggetto " + sogg.getTipo() + "/" + sogg.getNome() + ": " + e.getMessage(), e);
        }
        int numS = 0;
        for (int j2 = 0; j2 < this.configurazione.sizeSoggettoList(); ++j2) {
            Soggetto tmpSogg = this.configurazione.getSoggetto(j2);
            if (!sogg.getNome().equals(tmpSogg.getNome()) || !sogg.getTipo().equals(tmpSogg.getTipo())) continue;
            ++numS;
        }
        if (numS > 1) {
            this.errori.add("Non pu\u00f2 esistere pi\u00f9 di un soggetto con nome " + sogg.getNome() + " e tipo " + sogg.getTipo());
        }
        if (sogg.getRouter()) {
            int numR = 0;
            for (int j3 = 0; j3 < this.configurazione.sizeSoggettoList(); ++j3) {
                Soggetto tmpS = this.configurazione.getSoggetto(j3);
                if (!tmpS.getRouter()) continue;
                ++numR;
            }
            if (numR > 1) {
                this.errori.add("Non pu\u00f2 esistere pi\u00f9 di un soggetto abilitato alla funzione di Router");
            }
        }
        try {
            if (sogg.getPdUrlPrefixRewriter() != null && !RegularExpressionEngine.isMatch(sogg.getPdUrlPrefixRewriter(), "[A-Za-z]+:\\/\\/(.*)")) {
                this.errori.add("La funzione PdUrlPrefixRewriter contiene un valore errato che non rispetta l'espressione [A-Za-z]+:\\/\\/(.*)");
            }
            if (sogg.getPaUrlPrefixRewriter() != null && !RegularExpressionEngine.isMatch(sogg.getPaUrlPrefixRewriter(), "[A-Za-z]+:\\/\\/(.*)")) {
                this.errori.add("La funzione PaUrlPrefixRewriter contiene un valore errato che non rispetta l'espressione [A-Za-z]+:\\/\\/(.*)");
            }
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException(e);
        }
    }

    private void validaPortaDelegata(PortaDelegata pd, Soggetto sogg) throws DriverConfigurazioneException {
        StatoFunzionalita localForward;
        StatoFunzionalita stateless;
        StatoFunzionalita gestMan;
        StatoFunzionalita scartaBody;
        StatoFunzionalita allegaBody;
        String integrazione;
        StatoFunzionalita ricAsiAsim;
        StatoFunzionalita ricAsiSim;
        ValidazioneContenutiApplicativi vca;
        MtomProcessor mtom;
        Enum identificazione;
        if (pd.getNome() == null) {
            this.errori.add("Il soggetto [" + sogg.getTipo() + "/" + sogg.getNome() + "] posside una porta delegata che non contiene la definizione del nome");
            return;
        }
        String idPortaDelegata = sogg.getTipo() + "/" + sogg.getNome() + "_" + pd.getNome();
        if (pd.getSoggettoErogatore() == null) {
            this.errori.add("La porta delegata " + idPortaDelegata + " non contiene la definizione del soggetto erogatore");
        } else {
            PortaDelegataSoggettoErogatore pdsse = pd.getSoggettoErogatore();
            if (pdsse.getTipo() == null) {
                this.errori.add("Il soggetto erogatore della porta delegata " + idPortaDelegata + " non contiene la definizione del tipo.");
            } else if (!this.tipoSoggetti.contains(pdsse.getTipo())) {
                this.errori.add("Il tipo del soggetto erogatore della porta delegata " + idPortaDelegata + " non \u00e8 valido (Tipi utilizzabili: " + this.getTipoSoggetti() + ")");
            }
            identificazione = pdsse.getIdentificazione();
            if (!(identificazione == null || ((PortaDelegataSoggettoErogatoreIdentificazione)identificazione).equals(CostantiConfigurazione.PORTA_DELEGATA_SOGGETTO_EROGATORE_STATIC) || ((PortaDelegataSoggettoErogatoreIdentificazione)identificazione).equals(CostantiConfigurazione.PORTA_DELEGATA_SOGGETTO_EROGATORE_URL_BASED) || ((PortaDelegataSoggettoErogatoreIdentificazione)identificazione).equals(CostantiConfigurazione.PORTA_DELEGATA_SOGGETTO_EROGATORE_CONTENT_BASED) || ((PortaDelegataSoggettoErogatoreIdentificazione)identificazione).equals(CostantiConfigurazione.PORTA_DELEGATA_SOGGETTO_EROGATORE_INPUT_BASED))) {
                this.errori.add("La modalita d'identificazione del soggetto erogatore della porta delegata " + idPortaDelegata + " deve assumere uno dei seguente valori: " + CostantiConfigurazione.PORTA_DELEGATA_SOGGETTO_EROGATORE_STATIC + "," + CostantiConfigurazione.PORTA_DELEGATA_SOGGETTO_EROGATORE_URL_BASED + "," + CostantiConfigurazione.PORTA_DELEGATA_SOGGETTO_EROGATORE_CONTENT_BASED + " o " + CostantiConfigurazione.PORTA_DELEGATA_SOGGETTO_EROGATORE_INPUT_BASED);
            }
            if (identificazione == null) {
                identificazione = CostantiConfigurazione.PORTA_DELEGATA_SOGGETTO_EROGATORE_STATIC;
            }
            if (CostantiConfigurazione.PORTA_DELEGATA_SOGGETTO_EROGATORE_STATIC.equals((PortaDelegataSoggettoErogatoreIdentificazione)identificazione)) {
                if (pdsse.getNome() == null) {
                    this.errori.add("Il soggetto erogatore della porta delegata " + idPortaDelegata + " non contiene la definizione del nome, nonostante la modalita' di identificazione sia " + (PortaDelegataSoggettoErogatoreIdentificazione)identificazione);
                }
            } else if ((CostantiConfigurazione.PORTA_DELEGATA_SOGGETTO_EROGATORE_URL_BASED.equals((PortaDelegataSoggettoErogatoreIdentificazione)identificazione) || CostantiConfigurazione.PORTA_DELEGATA_SOGGETTO_EROGATORE_CONTENT_BASED.equals((PortaDelegataSoggettoErogatoreIdentificazione)identificazione)) && pdsse.getPattern() == null) {
                this.errori.add("Il soggetto erogatore della porta delegata " + idPortaDelegata + " non contiene la definizione del pattern, nonostante la modalita' di identificazione sia " + (PortaDelegataSoggettoErogatoreIdentificazione)identificazione);
            }
        }
        if (pd.getServizio() == null) {
            this.errori.add("La porta delegata " + idPortaDelegata + " non contiene la definizione del servizio");
        } else {
            PortaDelegataServizio pds = pd.getServizio();
            if (pds.getTipo() == null) {
                this.errori.add("Il servizio della porta delegata " + idPortaDelegata + " non contiene la definizione del tipo.");
            } else if (!this.tipoServizi.contains(pds.getTipo())) {
                this.errori.add("Il tipo del servizio della porta delegata " + idPortaDelegata + " non \u00e8 valido (Tipi utilizzabili: " + this.getTipoServizi() + ")");
            }
            identificazione = pds.getIdentificazione();
            if (!(identificazione == null || ((PortaDelegataServizioIdentificazione)identificazione).equals(CostantiConfigurazione.PORTA_DELEGATA_SERVIZIO_STATIC) || ((PortaDelegataServizioIdentificazione)identificazione).equals(CostantiConfigurazione.PORTA_DELEGATA_SERVIZIO_URL_BASED) || ((PortaDelegataServizioIdentificazione)identificazione).equals(CostantiConfigurazione.PORTA_DELEGATA_SERVIZIO_CONTENT_BASED) || ((PortaDelegataServizioIdentificazione)identificazione).equals(CostantiConfigurazione.PORTA_DELEGATA_SERVIZIO_INPUT_BASED))) {
                this.errori.add("La modalita d'identificazione del servizio della porta delegata " + idPortaDelegata + " deve assumere uno dei seguente valori: " + CostantiConfigurazione.PORTA_DELEGATA_SERVIZIO_STATIC + "," + CostantiConfigurazione.PORTA_DELEGATA_SERVIZIO_URL_BASED + "," + CostantiConfigurazione.PORTA_DELEGATA_SERVIZIO_CONTENT_BASED + " o " + CostantiConfigurazione.PORTA_DELEGATA_SERVIZIO_INPUT_BASED);
            }
            if (identificazione == null) {
                identificazione = CostantiConfigurazione.PORTA_DELEGATA_SERVIZIO_STATIC;
            }
            if (CostantiConfigurazione.PORTA_DELEGATA_SERVIZIO_STATIC.equals((PortaDelegataServizioIdentificazione)identificazione)) {
                if (pds.getNome() == null) {
                    this.errori.add("Il servizio della porta delegata " + idPortaDelegata + " non contiene la definizione del nome, nonostante la modalita' di identificazione sia " + (PortaDelegataServizioIdentificazione)identificazione);
                }
            } else if ((CostantiConfigurazione.PORTA_DELEGATA_SERVIZIO_URL_BASED.equals((PortaDelegataServizioIdentificazione)identificazione) || CostantiConfigurazione.PORTA_DELEGATA_SERVIZIO_CONTENT_BASED.equals((PortaDelegataServizioIdentificazione)identificazione)) && pds.getPattern() == null) {
                this.errori.add("Il servizio della porta delegata " + idPortaDelegata + " non contiene la definizione del pattern, nonostante la modalita' di identificazione sia " + (PortaDelegataServizioIdentificazione)identificazione);
            }
        }
        if (pd.getAzione() != null) {
            PortaDelegataAzione pda = pd.getAzione();
            identificazione = pda.getIdentificazione();
            if (!(identificazione == null || ((PortaDelegataAzioneIdentificazione)identificazione).equals(CostantiConfigurazione.PORTA_DELEGATA_AZIONE_STATIC) || ((PortaDelegataAzioneIdentificazione)identificazione).equals(CostantiConfigurazione.PORTA_DELEGATA_AZIONE_URL_BASED) || ((PortaDelegataAzioneIdentificazione)identificazione).equals(CostantiConfigurazione.PORTA_DELEGATA_AZIONE_CONTENT_BASED) || ((PortaDelegataAzioneIdentificazione)identificazione).equals(CostantiConfigurazione.PORTA_DELEGATA_AZIONE_INPUT_BASED) || ((PortaDelegataAzioneIdentificazione)identificazione).equals(CostantiConfigurazione.PORTA_DELEGATA_AZIONE_SOAP_ACTION_BASED))) {
                this.errori.add("La modalita d'identificazione dell'azione della porta delegata " + idPortaDelegata + " deve assumere uno dei seguente valori: " + CostantiConfigurazione.PORTA_DELEGATA_AZIONE_STATIC + ", " + CostantiConfigurazione.PORTA_DELEGATA_AZIONE_URL_BASED + ", " + CostantiConfigurazione.PORTA_DELEGATA_AZIONE_CONTENT_BASED + ", " + CostantiConfigurazione.PORTA_DELEGATA_AZIONE_INPUT_BASED + " o " + CostantiConfigurazione.PORTA_DELEGATA_AZIONE_SOAP_ACTION_BASED);
            }
            if (identificazione == null) {
                identificazione = CostantiConfigurazione.PORTA_DELEGATA_AZIONE_STATIC;
            }
            if (CostantiConfigurazione.PORTA_DELEGATA_AZIONE_STATIC.equals((PortaDelegataAzioneIdentificazione)identificazione)) {
                if (pda.getNome() == null) {
                    this.errori.add("L'azione della porta delegata " + idPortaDelegata + " non contiene la definizione del nome, nonostante la modalita' di identificazione sia " + (PortaDelegataAzioneIdentificazione)identificazione);
                }
            } else if ((CostantiConfigurazione.PORTA_DELEGATA_AZIONE_URL_BASED.equals((PortaDelegataAzioneIdentificazione)identificazione) || CostantiConfigurazione.PORTA_DELEGATA_AZIONE_CONTENT_BASED.equals((PortaDelegataAzioneIdentificazione)identificazione)) && pda.getPattern() == null) {
                this.errori.add("L'azione della porta delegata " + idPortaDelegata + " non contiene la definizione del pattern, nonostante la modalita' di identificazione sia " + (PortaDelegataAzioneIdentificazione)identificazione);
            }
        }
        String autenticazione = CredenzialeTipo.SSL.toString();
        if (pd.getAutenticazione() != null) {
            autenticazione = pd.getAutenticazione();
            if (!this.tipoAutenticazionePortaDelegata.contains(pd.getAutenticazione())) {
                this.errori.add("Alla porta delegata " + idPortaDelegata + " e' stato associato un processo di autenticazione [" + pd.getAutenticazione() + "] non valido; tipi conosciuti: " + this.getTipoAutenticazionePortaDelegata());
            }
        }
        String autorizzazione = "authenticated";
        if (pd.getAutorizzazione() != null) {
            autorizzazione = pd.getAutorizzazione();
            if (!this.tipoAutorizzazionePortaDelegata.contains(pd.getAutorizzazione())) {
                this.errori.add("Alla porta delegata " + idPortaDelegata + " e' stato associato un processo di autorizzazione [" + pd.getAutorizzazione() + "] non valido; tipi conosciuti: " + this.getTipoAutorizzazionePortaDelegata());
            }
        }
        if (autorizzazione != null) {
            if (autorizzazione.toLowerCase().contains("authenticated") && autorizzazione.toLowerCase().contains("roles") && !StatoFunzionalita.ABILITATO.equals(pd.getAutenticazioneOpzionale())) {
                this.errori.add("Alla porta delegata " + idPortaDelegata + " e' stato associata un'autorizzazione '" + autorizzazione + "' che richiede una autenticazione dei servizi applicativi opzionali");
            }
            if (autorizzazione.toLowerCase().contains("internal") || "authenticated".equals(autorizzazione)) {
                if ("none".equals(autenticazione)) {
                    this.errori.add("Alla porta delegata " + idPortaDelegata + " e' stato associata un'autorizzazione '" + autorizzazione + "' che richiede una autenticazione obbligatoria dei servizi applicativi, autenticazione non impostata nella porta delegata");
                }
                if (StatoFunzionalita.ABILITATO.equals(pd.getAutenticazioneOpzionale()) && !autorizzazione.toLowerCase().contains("or")) {
                    this.errori.add("Alla porta delegata " + idPortaDelegata + " e' stato associata un'autorizzazione '" + autorizzazione + "' che richiede una autenticazione obbligatoria dei servizi applicativi, autenticazione impostata come opzionale nella porta delegata");
                }
            }
        }
        if (pd.getAutorizzazioneContenuto() != null && !this.tipoAutorizzazioneContenutoPortaDelegata.contains(pd.getAutorizzazioneContenuto())) {
            this.errori.add("Alla porta delegata " + idPortaDelegata + " e' stato associato un processo di autorizzazione contenuto [" + pd.getAutorizzazioneContenuto() + "] non valido; tipi conosciuti: " + this.getTipoAutorizzazioneContenutoPortaDelegata());
        }
        for (int i = 0; i < pd.sizeServizioApplicativoList(); ++i) {
            ServizioApplicativo sa = pd.getServizioApplicativo(i);
            if (sa.getNome() == null) {
                this.errori.add("La porta delegata " + idPortaDelegata + " ha associato un servizio applicativo per cui non e' stato definito il nome");
            } else if (sa.getInvocazionePorta() == null && sa.getInvocazioneServizio() == null && sa.getRispostaAsincrona() == null) {
                if (!this.existsServizioApplicativo(sa.getNome(), sogg)) {
                    this.errori.add("La porta delegata " + idPortaDelegata + " ha associato un riferimento ad un servizio applicativo [" + sa.getNome() + "] che non risulta registrato nel soggetto " + sogg.getTipo() + "/" + sogg.getNome());
                } else {
                    sa = this.getServizioApplicativo(sa.getNome(), sogg);
                }
            } else {
                this.validaServizioApplicativo(sa, sogg);
            }
            if (CostantiConfigurazione.INVOCAZIONE_SERVIZIO_AUTENTICAZIONE_NONE.equals(autenticazione)) continue;
            if (sa.getInvocazionePorta() == null) {
                this.errori.add("La porta delegata " + idPortaDelegata + " possiede un meccanismo di autenticazione [" + autenticazione + "]: il servizio applicativo " + sa.getNome() + " non contiene la definizione dell'elemento invocazione porta");
                continue;
            }
            if (sa.getInvocazionePorta().sizeCredenzialiList() <= 0) {
                this.errori.add("La porta delegata " + idPortaDelegata + " possiede un meccanismo di autenticazione [" + autenticazione + "]: il servizio applicativo " + sa.getNome() + " non contiene la definizione di credenziali di accesso");
                continue;
            }
            if (!CostantiConfigurazione.INVOCAZIONE_SERVIZIO_AUTENTICAZIONE_BASIC.equals(autenticazione)) continue;
            boolean trovato = false;
            for (int k = 0; k < sa.getInvocazionePorta().sizeCredenzialiList(); ++k) {
                if (!CostantiConfigurazione.CREDENZIALE_BASIC.equals(sa.getInvocazionePorta().getCredenziali(k).getTipo())) continue;
                trovato = true;
                break;
            }
            if (trovato) continue;
            this.errori.add("La porta delegata " + idPortaDelegata + " possiede un meccanismo di autenticazione [" + autenticazione + "]: il servizio applicativo " + sa.getNome() + " non contiene la definizione di credenziali di accesso di tipo " + CostantiConfigurazione.CREDENZIALE_BASIC.toString());
        }
        MessageSecurity messageSecurity = pd.getMessageSecurity();
        if (messageSecurity != null) {
            this.validaMessageSecurity(messageSecurity, "PortaDelegata_" + idPortaDelegata);
        }
        if ((mtom = pd.getMtomProcessor()) != null) {
            this.validaMTOM(mtom, "PortaDelegata_" + idPortaDelegata);
        }
        if ((vca = pd.getValidazioneContenutiApplicativi()) != null) {
            this.validazioneValidazioneContenutiApplicativi(vca, "PortaDelegata_" + idPortaDelegata);
        }
        String idRisorsa = "Porta delegata " + idPortaDelegata;
        this.validaCorrelazioneApplicativaRichiesta(idRisorsa, pd.getCorrelazioneApplicativa(), true);
        this.validaCorrelazioneApplicativaRisposta(idRisorsa, pd.getCorrelazioneApplicativaRisposta(), true);
        String idPorta = null;
        idPorta = pd.getLocation() != null ? pd.getLocation() : pd.getNome();
        int numPD = 0;
        Vector<CallSite> pdTrovate = new Vector<CallSite>();
        for (int j = 0; j < this.configurazione.sizeSoggettoList(); ++j) {
            Soggetto s = this.configurazione.getSoggetto(j);
            for (int k = 0; k < s.sizePortaDelegataList(); ++k) {
                PortaDelegata tmpPd = s.getPortaDelegata(k);
                String tmpIdPorta = null;
                tmpIdPorta = tmpPd.getLocation() != null ? tmpPd.getLocation() : tmpPd.getNome();
                if (!idPorta.equals(tmpIdPorta)) continue;
                ++numPD;
                pdTrovate.add((CallSite)((Object)(s.getTipo() + "/" + s.getNome() + "_" + tmpPd.getNome())));
            }
        }
        if (numPD > 1) {
            this.errori.add("Non pu\u00f2 esistere pi\u00f9 di una porta delegata invocabile tramite identificativo " + idPorta + ". Invece l'identificativo invoca le seguenti porte delegate: " + pdTrovate.toArray(new String[1]));
        }
        if ((ricAsiSim = pd.getRicevutaAsincronaSimmetrica()) != null && !ricAsiSim.equals(CostantiConfigurazione.ABILITATO) && !ricAsiSim.equals(CostantiConfigurazione.DISABILITATO)) {
            this.errori.add("La ricevuta asincrona simmetrica della porta delegata " + idPortaDelegata + " deve assumere i valori: " + CostantiConfigurazione.ABILITATO + " o " + CostantiConfigurazione.DISABILITATO);
        }
        if ((ricAsiAsim = pd.getRicevutaAsincronaAsimmetrica()) != null && !ricAsiAsim.equals(CostantiConfigurazione.ABILITATO) && !ricAsiAsim.equals(CostantiConfigurazione.DISABILITATO)) {
            this.errori.add("La ricevuta asincrona asimmetrica della porta delegata " + idPortaDelegata + " deve assumere i valori: " + CostantiConfigurazione.ABILITATO + " o " + CostantiConfigurazione.DISABILITATO);
        }
        if ((integrazione = pd.getIntegrazione()) != null) {
            String[] tipiIntegrazione = integrazione.split(",");
            if (tipiIntegrazione == null || tipiIntegrazione.length <= 0) {
                this.errori.add("La porta delegata " + idPortaDelegata + " possiede un valore nel campo 'integrazione' non valido: " + integrazione);
            }
            for (int p = 0; p < tipiIntegrazione.length; ++p) {
                String tipoI = tipiIntegrazione[p].trim();
                if (this.tipoIntegrazionePD.contains(tipoI)) continue;
                this.errori.add("La porta delegata " + idPortaDelegata + " possiede un tipo di integrazione [" + tipoI + "] non valido: valori utilizzabili sono: " + this.getTipoIntegrazionePD());
            }
        }
        if ((allegaBody = pd.getAllegaBody()) != null && !allegaBody.equals(CostantiConfigurazione.ABILITATO) && !allegaBody.equals(CostantiConfigurazione.DISABILITATO)) {
            this.errori.add("La funzionalita' di allega-boxy della porta delegata " + idPortaDelegata + " deve assumere i valori: " + CostantiConfigurazione.ABILITATO + " o " + CostantiConfigurazione.DISABILITATO);
        }
        if ((scartaBody = pd.getScartaBody()) != null && !scartaBody.equals(CostantiConfigurazione.ABILITATO) && !scartaBody.equals(CostantiConfigurazione.DISABILITATO)) {
            this.errori.add("La funzionalita' di scarta-boxy della porta delegata " + idPortaDelegata + " deve assumere i valori: " + CostantiConfigurazione.ABILITATO + " o " + CostantiConfigurazione.DISABILITATO);
        }
        if ((gestMan = pd.getGestioneManifest()) != null && !gestMan.equals(CostantiConfigurazione.ABILITATO) && !gestMan.equals(CostantiConfigurazione.DISABILITATO)) {
            this.errori.add("La funzionalita' di gestioneManifest della porta delegata " + idPortaDelegata + " deve assumere i valori: " + CostantiConfigurazione.ABILITATO + " o " + CostantiConfigurazione.DISABILITATO);
        }
        if ((stateless = pd.getStateless()) != null && !stateless.equals(CostantiConfigurazione.ABILITATO) && !stateless.equals(CostantiConfigurazione.DISABILITATO)) {
            this.errori.add("La funzionalita' 'stateless' della porta delegata " + idPortaDelegata + " deve assumere i valori: " + CostantiConfigurazione.ABILITATO + " o " + CostantiConfigurazione.DISABILITATO);
        }
        if ((localForward = pd.getLocalForward()) != null && !localForward.equals(CostantiConfigurazione.ABILITATO) && !localForward.equals(CostantiConfigurazione.DISABILITATO)) {
            this.errori.add("La funzionalita' 'local-forward' della porta delegata " + idPortaDelegata + " deve assumere i valori: " + CostantiConfigurazione.ABILITATO + " o " + CostantiConfigurazione.DISABILITATO);
        }
        if (pd.getRuoli() != null) {
            int i;
            for (i = 0; i < pd.getRuoli().sizeRuoloList(); ++i) {
                String nomeRuolo = pd.getRuoli().getRuolo(i).getNome();
                try {
                    if (RegularExpressionEngine.isMatch(nomeRuolo, "^[0-9A-Za-z_]+$")) continue;
                    this.errori.add("Il ruolo [" + nomeRuolo + "] della porta delegata " + idPortaDelegata + " dev'essere formato solo da caratteri, cifre e '_'");
                    continue;
                }
                catch (Exception e) {
                    throw new DriverConfigurazioneException("Errore durante l'analisi tramite espressione regolare del nome del ruolo " + nomeRuolo + " della porta delegata " + idPortaDelegata + " :" + e.getMessage(), e);
                }
            }
            for (i = 0; i < pd.getRuoli().sizeRuoloList(); ++i) {
                int numRuolo = 0;
                String tmpRuolo = pd.getRuoli().getRuolo(i).getNome();
                for (int j = 0; j < pd.getRuoli().sizeRuoloList(); ++j) {
                    String checkRuolo = pd.getRuoli().getRuolo(j).getNome();
                    if (!checkRuolo.equals(tmpRuolo)) continue;
                    ++numRuolo;
                }
                if (numRuolo <= true) continue;
                this.errori.add("Non pu\u00f2 esistere pi\u00f9 di un ruolo con nome " + tmpRuolo + ". Trovate " + numRuolo + " occorrenze nella porta delegata " + idPortaDelegata);
            }
        }
    }

    private void validaPortaApplicativa(PortaApplicativa pa, Soggetto sogg) throws DriverConfigurazioneException {
        StatoFunzionalita stateless;
        StatoFunzionalita gestMan;
        StatoFunzionalita scartaBody;
        StatoFunzionalita allegaBody;
        String integrazione;
        StatoFunzionalita ricAsiAsim;
        StatoFunzionalita ricAsiSim;
        ValidazioneContenutiApplicativi vca;
        MtomProcessor mtom;
        PortaApplicativaAzione azione;
        if (pa.getNome() == null) {
            this.errori.add("Il soggetto [" + sogg.getTipo() + "/" + sogg.getNome() + "] posside una porta applicativa che non contiene la definizione del nome");
            return;
        }
        String idPortaApplicativa = sogg.getTipo() + "/" + sogg.getNome() + "_" + pa.getNome();
        boolean checkIDPA = true;
        if (pa.getSoggettoVirtuale() != null) {
            PortaApplicativaSoggettoVirtuale sv = pa.getSoggettoVirtuale();
            if (sv.getTipo() == null) {
                this.errori.add("La porta applicativa [" + idPortaApplicativa + "] possiede la definizione di un soggetto virtuale per cui non e' stato definito il tipo");
                checkIDPA = false;
            } else if (!this.tipoSoggetti.contains(sv.getTipo())) {
                this.errori.add("La porta applicativa [" + idPortaApplicativa + "] possiede la definizione di un soggetto virtuale per cui e' stato definito un tipo non valido (Tipi utilizzabili: " + this.getTipoSoggetti() + ")");
            }
            if (sv.getNome() == null) {
                this.errori.add("La porta applicativa [" + idPortaApplicativa + "] possiede la definizione di un soggetto virtuale per cui non e' stato definito il nome");
                checkIDPA = false;
            }
        }
        if (pa.getServizio() != null) {
            PortaApplicativaServizio serv = pa.getServizio();
            if (serv.getTipo() == null) {
                this.errori.add("La porta applicativa [" + idPortaApplicativa + "] possiede la definizione di un servizio erogato per cui non e' stato definito il tipo");
                checkIDPA = false;
            } else if (!this.tipoServizi.contains(serv.getTipo())) {
                this.errori.add("La porta applicativa [" + idPortaApplicativa + "] possiede la definizione di un servizio erogato per cui e' stato definito un tipo non valido (Tipi utilizzabili: " + this.getTipoServizi() + ")");
            }
            if (serv.getNome() == null) {
                this.errori.add("La porta applicativa [" + idPortaApplicativa + "] possiede la definizione di un servizio erogato per cui non e' stato definito il nome");
                checkIDPA = false;
            }
        } else {
            this.errori.add("La porta applicativa [" + idPortaApplicativa + "] non possiede la definizione del servizio erogato");
        }
        if (pa.getAzione() != null && (azione = pa.getAzione()).getNome() == null) {
            this.errori.add("La porta applicativa [" + idPortaApplicativa + "] possiede la definizione di un azione erogata per cui non e' stato definito il nome");
            checkIDPA = false;
        }
        if (pa.sizeServizioApplicativoList() < 1) {
            this.errori.add("Alla porta applicativa [" + idPortaApplicativa + "] non sono stati associati servizi applicativi");
        } else {
            for (int i = 0; i < pa.sizeServizioApplicativoList(); ++i) {
                ServizioApplicativo sa = pa.getServizioApplicativo(i);
                if (sa.getNome() == null) {
                    this.errori.add("La porta applicativa " + idPortaApplicativa + " ha associato un servizio applicativo per cui non e' stato definito il nome");
                } else if (sa.getInvocazionePorta() == null && sa.getInvocazioneServizio() == null && sa.getRispostaAsincrona() == null) {
                    if (!this.existsServizioApplicativo(sa.getNome(), sogg)) {
                        this.errori.add("La porta applicativa " + idPortaApplicativa + " ha associato un riferimento ad un servizio applicativo [" + sa.getNome() + "] che non risulta registrato nel soggetto " + sogg.getTipo() + "/" + sogg.getNome());
                    } else {
                        sa = this.getServizioApplicativo(sa.getNome(), sogg);
                    }
                } else {
                    this.validaServizioApplicativo(sa, sogg);
                }
                if (sa.getInvocazioneServizio() == null) {
                    this.errori.add("La porta applicativa " + idPortaApplicativa + " ha associato un servizio applicativo [" + sa.getNome() + "] per cui non e' stato definito l'elemento invocazione servizio");
                    continue;
                }
                boolean connettore = false;
                boolean get = false;
                if (sa.getInvocazioneServizio().getConnettore() != null && !CostantiConfigurazione.DISABILITATO.equals(sa.getInvocazioneServizio().getConnettore().getTipo())) {
                    connettore = true;
                }
                if (sa.getInvocazioneServizio().getGetMessage() != null && CostantiConfigurazione.ABILITATO.equals(sa.getInvocazioneServizio().getGetMessage())) {
                    get = true;
                }
                if (connettore || get) continue;
                this.errori.add("La porta applicativa " + idPortaApplicativa + " ha associato un servizio applicativo [" + sa.getNome() + "] per cui non e' stato definito ne una consegna trasparente (tramite connettore) ne il servizio di message box (tramite IntegrationManager)");
            }
        }
        String autenticazione = CredenzialeTipo.SSL.toString();
        if (pa.getAutenticazione() != null) {
            autenticazione = pa.getAutenticazione();
            if (!this.tipoAutenticazionePortaApplicativa.contains(pa.getAutenticazione())) {
                this.errori.add("Alla porta applicativa " + idPortaApplicativa + " e' stato associato un processo di autenticazione [" + pa.getAutenticazione() + "] non valido; tipi conosciuti: " + this.getTipoAutenticazionePortaApplicativa());
            }
        }
        String autorizzazione = "authenticated";
        if (pa.getAutorizzazione() != null) {
            autorizzazione = pa.getAutorizzazione();
            if (!this.tipoAutorizzazionePortaApplicativa.contains(pa.getAutorizzazione())) {
                this.errori.add("Alla porta applicativa " + idPortaApplicativa + " e' stato associato un processo di autorizzazione [" + pa.getAutorizzazione() + "] non valido; tipi conosciuti: " + this.getTipoAutorizzazionePortaApplicativa());
            }
        }
        if (autorizzazione != null && "PROXY".equals(sogg.getTipo())) {
            if (autorizzazione.toLowerCase().contains("authenticated") && autorizzazione.toLowerCase().contains("roles") && !StatoFunzionalita.ABILITATO.equals(pa.getAutenticazioneOpzionale())) {
                this.errori.add("Alla porta applicativa " + idPortaApplicativa + " e' stato associata un'autorizzazione '" + autorizzazione + "' che richiede una autenticazione dei soggetti opzionali");
            }
            if (autorizzazione.toLowerCase().contains("internal") || "authenticated".equals(autorizzazione)) {
                if ("none".equals(autenticazione)) {
                    this.errori.add("Alla porta applicativa " + idPortaApplicativa + " e' stato associata un'autorizzazione '" + autorizzazione + "' che richiede una autenticazione obbligatoria dei soggetti, autenticazione non impostata nella porta applicativa");
                }
                if (StatoFunzionalita.ABILITATO.equals(pa.getAutenticazioneOpzionale()) && !autorizzazione.toLowerCase().contains("or")) {
                    this.errori.add("Alla porta applicativa " + idPortaApplicativa + " e' stato associata un'autorizzazione '" + autorizzazione + "' che richiede una autenticazione obbligatoria dei soggetti, autenticazione impostata come opzionale nella porta applicativa");
                }
            }
        }
        if (pa.getAutorizzazioneContenuto() != null && !this.tipoAutorizzazioneContenutoPortaApplicativa.contains(pa.getAutorizzazioneContenuto())) {
            this.errori.add("Alla porta applicativa " + idPortaApplicativa + " e' stato associato un processo di autorizzazione contenuto [" + pa.getAutorizzazioneContenuto() + "] non valido; tipi conosciuti: " + this.getTipoAutorizzazioneContenutoPortaApplicativa());
        }
        for (int j = 0; j < pa.sizeProprietaProtocolloList(); ++j) {
            ProprietaProtocollo ssp = pa.getProprietaProtocollo(j);
            this.validaProtocolProperty(ssp, idPortaApplicativa);
        }
        MessageSecurity messageSecurity = pa.getMessageSecurity();
        if (messageSecurity != null) {
            this.validaMessageSecurity(messageSecurity, "PortaApplicativa_" + idPortaApplicativa);
        }
        if ((mtom = pa.getMtomProcessor()) != null) {
            this.validaMTOM(mtom, "PortaApplicativa_" + idPortaApplicativa);
        }
        if ((vca = pa.getValidazioneContenutiApplicativi()) != null) {
            this.validazioneValidazioneContenutiApplicativi(vca, "PortaApplicativa_" + idPortaApplicativa);
        }
        String idRisorsa = "Porta applicativa " + idPortaApplicativa;
        this.validaCorrelazioneApplicativaRichiesta(idRisorsa, pa.getCorrelazioneApplicativa(), false);
        this.validaCorrelazioneApplicativaRisposta(idRisorsa, pa.getCorrelazioneApplicativaRisposta(), false);
        int numPA = 0;
        for (int j = 0; j < sogg.sizePortaApplicativaList(); ++j) {
            PortaApplicativa tmpPa = sogg.getPortaApplicativa(j);
            if (!pa.getNome().equals(tmpPa.getNome())) continue;
            ++numPA;
        }
        if (numPA > 1) {
            this.errori.add("Non pu\u00f2 esistere pi\u00f9 di una porta applicativa del soggetto " + sogg.getTipo() + "/" + sogg.getNome() + " con nome " + pa.getNome());
        }
        String idPortaA = null;
        if (!checkIDPA) {
            idPortaA = pa.getSoggettoVirtuale() != null ? pa.getSoggettoVirtuale().getTipo() + "/" + pa.getSoggettoVirtuale().getNome() : sogg.getTipo() + "/" + sogg.getNome();
            idPortaA = idPortaA + "_" + pa.getServizio().getTipo() + "/" + pa.getServizio().getNome();
            if (pa.getAzione() != null) {
                idPortaA = idPortaA + "_" + pa.getAzione().getNome();
            }
            int cont = 0;
            for (int i = 0; i < sogg.sizePortaApplicativaList(); ++i) {
                PortaApplicativa tmp = sogg.getPortaApplicativa(i);
                String idTMPPA = null;
                if (tmp.getSoggettoVirtuale() != null) {
                    if (tmp.getSoggettoVirtuale().getTipo() == null || tmp.getSoggettoVirtuale().getNome() == null) continue;
                    idTMPPA = tmp.getSoggettoVirtuale().getTipo() + "/" + tmp.getSoggettoVirtuale().getNome();
                } else {
                    idTMPPA = sogg.getTipo() + "/" + sogg.getNome();
                }
                if (tmp.getServizio() == null || tmp.getServizio().getTipo() == null || tmp.getServizio().getNome() == null) continue;
                idTMPPA = idTMPPA + "_" + tmp.getServizio().getTipo() + "/" + tmp.getServizio().getNome();
                if (tmp.getAzione() != null) {
                    if (tmp.getAzione().getNome() == null) continue;
                    idTMPPA = idTMPPA + "_" + pa.getAzione().getNome();
                }
                if (!idPortaA.equals(idTMPPA)) continue;
                ++cont;
            }
            if (cont > 1) {
                if (pa.getSoggettoVirtuale() != null) {
                    this.errori.add("Non pu\u00f2 esistere pi\u00f9 di una porta applicativa (con soggetto virtuale) che mappa il servizio: " + idPortaA);
                } else {
                    this.errori.add("Non pu\u00f2 esistere pi\u00f9 di una porta applicativa che mappa il servizio: " + idPortaA);
                }
            }
        }
        if ((ricAsiSim = pa.getRicevutaAsincronaSimmetrica()) != null && !ricAsiSim.equals(CostantiConfigurazione.ABILITATO) && !ricAsiSim.equals(CostantiConfigurazione.DISABILITATO)) {
            this.errori.add("La ricevuta asincrona simmetrica della porta applicativa " + idPortaApplicativa + " deve assumere i valori: " + CostantiConfigurazione.ABILITATO + " o " + CostantiConfigurazione.DISABILITATO);
        }
        if ((ricAsiAsim = pa.getRicevutaAsincronaAsimmetrica()) != null && !ricAsiAsim.equals(CostantiConfigurazione.ABILITATO) && !ricAsiAsim.equals(CostantiConfigurazione.DISABILITATO)) {
            this.errori.add("La ricevuta asincrona asimmetrica della porta applicativa " + idPortaApplicativa + " deve assumere i valori: " + CostantiConfigurazione.ABILITATO + " o " + CostantiConfigurazione.DISABILITATO);
        }
        if ((integrazione = pa.getIntegrazione()) != null) {
            String[] tipiIntegrazione = integrazione.split(",");
            if (tipiIntegrazione == null || tipiIntegrazione.length <= 0) {
                this.errori.add("La porta applicativa " + idPortaApplicativa + " possiede un valore nel campo 'integrazione' non valido: " + integrazione);
            }
            for (int p = 0; p < tipiIntegrazione.length; ++p) {
                String tipoI = tipiIntegrazione[p].trim();
                if (this.tipoIntegrazionePA.contains(tipoI)) continue;
                this.errori.add("La porta applicativa " + idPortaApplicativa + " possiede un tipo di integrazione [" + tipoI + "] non valido: valori utilizzabili sono: " + this.getTipoIntegrazionePA());
            }
        }
        if ((allegaBody = pa.getAllegaBody()) != null && !allegaBody.equals(CostantiConfigurazione.ABILITATO) && !allegaBody.equals(CostantiConfigurazione.DISABILITATO)) {
            this.errori.add("La funzionalita' di allega-boxy della porta applicativa " + idPortaApplicativa + " deve assumere i valori: " + CostantiConfigurazione.ABILITATO + " o " + CostantiConfigurazione.DISABILITATO);
        }
        if ((scartaBody = pa.getScartaBody()) != null && !scartaBody.equals(CostantiConfigurazione.ABILITATO) && !scartaBody.equals(CostantiConfigurazione.DISABILITATO)) {
            this.errori.add("La funzionalita' di scarta-boxy della porta applicativa " + idPortaApplicativa + " deve assumere i valori: " + CostantiConfigurazione.ABILITATO + " o " + CostantiConfigurazione.DISABILITATO);
        }
        if ((gestMan = pa.getGestioneManifest()) != null && !gestMan.equals(CostantiConfigurazione.ABILITATO) && !gestMan.equals(CostantiConfigurazione.DISABILITATO)) {
            this.errori.add("La funzionalita' di gestioneManifest della porta applicativa " + idPortaApplicativa + " deve assumere i valori: " + CostantiConfigurazione.ABILITATO + " o " + CostantiConfigurazione.DISABILITATO);
        }
        if ((stateless = pa.getStateless()) != null && !stateless.equals(CostantiConfigurazione.ABILITATO) && !stateless.equals(CostantiConfigurazione.DISABILITATO)) {
            this.errori.add("La funzionalita' 'stateless' della porta applicativa " + idPortaApplicativa + " deve assumere i valori: " + CostantiConfigurazione.ABILITATO + " o " + CostantiConfigurazione.DISABILITATO);
        }
        if (pa.getRuoli() != null) {
            int i;
            for (i = 0; i < pa.getRuoli().sizeRuoloList(); ++i) {
                String nomeRuolo = pa.getRuoli().getRuolo(i).getNome();
                try {
                    if (RegularExpressionEngine.isMatch(nomeRuolo, "^[0-9A-Za-z_]+$")) continue;
                    this.errori.add("Il ruolo [" + nomeRuolo + "] della porta applicativa " + idPortaApplicativa + " dev'essere formato solo da caratteri, cifre e '_'");
                    continue;
                }
                catch (Exception e) {
                    throw new DriverConfigurazioneException("Errore durante l'analisi tramite espressione regolare del nome del ruolo " + nomeRuolo + " della porta applicativa " + idPortaApplicativa + " :" + e.getMessage(), e);
                }
            }
            for (i = 0; i < pa.getRuoli().sizeRuoloList(); ++i) {
                int numRuolo = 0;
                String tmpRuolo = pa.getRuoli().getRuolo(i).getNome();
                for (int j = 0; j < pa.getRuoli().sizeRuoloList(); ++j) {
                    String checkRuolo = pa.getRuoli().getRuolo(j).getNome();
                    if (!checkRuolo.equals(tmpRuolo)) continue;
                    ++numRuolo;
                }
                if (numRuolo <= true) continue;
                this.errori.add("Non pu\u00f2 esistere pi\u00f9 di un ruolo con nome " + tmpRuolo + ". Trovate " + numRuolo + " occorrenze nella porta applicativa " + idPortaApplicativa);
            }
        }
    }

    private void validaServizioApplicativo(ServizioApplicativo sa, Soggetto sogg) throws DriverConfigurazioneException {
        StatoFunzionalita sbustamentoInfoProtocollo;
        StatoFunzionalita sbustamentoSOAP;
        StatoFunzionalita rispRif;
        StatoFunzionalita invRif;
        StatoFunzionalita getMsg;
        boolean get;
        GestioneErrore ge;
        Connettore conn;
        InvocazioneServizioTipoAutenticazione auth;
        BaseBean c;
        if (sa.getNome() == null) {
            this.errori.add("Esiste un ServizioApplicativo del soggetto [" + sogg.getTipo() + "/" + sogg.getNome() + "] per cui non e' stato definito il nome");
            return;
        }
        String idServizioApplicativo = sogg.getTipo() + "/" + sogg.getNome() + "_" + sa.getNome();
        if (sa.getInvocazionePorta() == null && sa.getRispostaAsincrona() == null && sa.getInvocazioneServizio() == null) {
            this.errori.add("Il ServizioApplicativo [" + idServizioApplicativo + "] non contiene ne la definizione dell'elemento invocazione porta, ne la definizione della risposta asincrona, ne la definizione dell'elemento invocazione servizio");
            return;
        }
        InvocazionePorta ip = sa.getInvocazionePorta();
        if (ip != null) {
            InvocazionePortaGestioneErrore ipge;
            StatoFunzionalita sbustamentoInfoProtocollo2;
            if (ip.sizeCredenzialiList() < 1) {
                this.errori.add("Il ServizioApplicativo [" + idServizioApplicativo + "] non contiene credenziali di accesso, nonostante abbia definito l'elemento invocazione porta");
            }
            for (int j = 0; j < ip.sizeCredenzialiList(); ++j) {
                c = ip.getCredenziali(j);
                this.validaCredenziale((Credenziali)c, "servizio applicativo [" + idServizioApplicativo + "] (invocazione porta)");
            }
            StatoFunzionalita invRif2 = ip.getInvioPerRiferimento();
            if (invRif2 != null && !invRif2.equals(CostantiConfigurazione.ABILITATO) && !invRif2.equals(CostantiConfigurazione.DISABILITATO)) {
                this.errori.add("L'invio per riferimento dell'invocazione porta del servizio applicativo [" + idServizioApplicativo + "] deve assumere i valori: " + CostantiConfigurazione.ABILITATO + " o " + CostantiConfigurazione.DISABILITATO);
            }
            if ((sbustamentoInfoProtocollo2 = ip.getSbustamentoInformazioniProtocollo()) != null && !sbustamentoInfoProtocollo2.equals(CostantiConfigurazione.ABILITATO) && !sbustamentoInfoProtocollo2.equals(CostantiConfigurazione.DISABILITATO)) {
                this.errori.add("L'indicazione di sbustamento informazioni di protcollo dell'invocazione porta del servizio applicativo [" + idServizioApplicativo + "] deve assumere i valori: " + CostantiConfigurazione.ABILITATO + " o " + CostantiConfigurazione.DISABILITATO);
            }
            if ((ipge = ip.getGestioneErrore()) != null) {
                StatoFunzionalita genFault;
                FaultIntegrazioneTipo fault = ipge.getFault();
                if (fault != null && !fault.equals(FaultIntegrazioneTipo.SOAP) && !fault.equals(FaultIntegrazioneTipo.XML)) {
                    this.errori.add("Il fault della gestione errore dell'invocazione porta del servizio applicativo [" + idServizioApplicativo + "] deve assumere i valori: " + CostantiConfigurazione.ERRORE_APPLICATIVO_SOAP + " o " + CostantiConfigurazione.ERRORE_APPLICATIVO_XML);
                }
                if ((genFault = ipge.getGenericFaultCode()) != null && !genFault.equals(CostantiConfigurazione.ABILITATO) && !genFault.equals(CostantiConfigurazione.DISABILITATO)) {
                    this.errori.add("Il generic-fault-code della gestione errore dell'invocazione porta del servizio applicativo [" + idServizioApplicativo + "] deve assumere i valori: " + CostantiConfigurazione.ABILITATO + " o " + CostantiConfigurazione.DISABILITATO);
                }
            }
            if (ip.getRuoli() != null) {
                int i;
                for (i = 0; i < ip.getRuoli().sizeRuoloList(); ++i) {
                    String nomeRuolo = ip.getRuoli().getRuolo(i).getNome();
                    try {
                        if (RegularExpressionEngine.isMatch(nomeRuolo, "^[0-9A-Za-z_]+$")) continue;
                        this.errori.add("Il ruolo [" + nomeRuolo + "] dell'invocazione porta del servizio applicativo [" + idServizioApplicativo + "] dev'essere formato solo da caratteri, cifre e '_'");
                        continue;
                    }
                    catch (Exception e) {
                        throw new DriverConfigurazioneException("Errore durante l'analisi tramite espressione regolare del nome del ruolo " + nomeRuolo + " dell'invocazione porta del servizio applicativo [" + idServizioApplicativo + "] :" + e.getMessage(), e);
                    }
                }
                for (i = 0; i < ip.getRuoli().sizeRuoloList(); ++i) {
                    int numRuolo = 0;
                    String tmpRuolo = ip.getRuoli().getRuolo(i).getNome();
                    for (int j = 0; j < ip.getRuoli().sizeRuoloList(); ++j) {
                        String checkRuolo = ip.getRuoli().getRuolo(j).getNome();
                        if (!checkRuolo.equals(tmpRuolo)) continue;
                        ++numRuolo;
                    }
                    if (numRuolo <= true) continue;
                    this.errori.add("Non pu\u00f2 esistere pi\u00f9 di un ruolo con nome " + tmpRuolo + ". Trovate " + numRuolo + " occorrenze nell'invocazione porta del servizio applicativo [" + idServizioApplicativo + "]");
                }
            }
        }
        if (sa.getInvocazioneServizio() != null) {
            InvocazioneServizio is = sa.getInvocazioneServizio();
            c = is.getCredenziali();
            if (c != null) {
                this.validaCredenziale((InvocazioneCredenziali)c, "servizio applicativo [" + idServizioApplicativo + "] (invocazione servizio)");
            }
            if ((auth = is.getAutenticazione()) != null && !auth.equals(CostantiConfigurazione.INVOCAZIONE_SERVIZIO_AUTENTICAZIONE_BASIC) && !auth.equals(CostantiConfigurazione.INVOCAZIONE_SERVIZIO_AUTENTICAZIONE_NONE)) {
                this.errori.add("L'autenticazione dell'invocazione servizio del servizio applicativo " + idServizioApplicativo + " deve assumere uno dei seguenti valori: " + CostantiConfigurazione.INVOCAZIONE_SERVIZIO_AUTENTICAZIONE_BASIC.toString() + " o " + CostantiConfigurazione.INVOCAZIONE_SERVIZIO_AUTENTICAZIONE_NONE.toString());
            }
            if (CostantiConfigurazione.INVOCAZIONE_SERVIZIO_AUTENTICAZIONE_BASIC.equals(auth) && c == null) {
                this.errori.add("L'autenticazione " + CostantiConfigurazione.INVOCAZIONE_SERVIZIO_AUTENTICAZIONE_BASIC.toString() + " dell'invocazione servizio del servizio applicativo " + idServizioApplicativo + " richiede la presenza di credenziali");
            }
            if ((conn = is.getConnettore()) != null) {
                this.validaConnettore(conn, "servizio applicativo [" + idServizioApplicativo + "] (invocazione servizio)", sogg);
            }
            if ((ge = is.getGestioneErrore()) != null) {
                this.validaGestioneErrore(ge, "servizio applicativo [" + idServizioApplicativo + "] (invocazione servizio)");
            }
            boolean connettore = false;
            get = false;
            if (is.getConnettore() != null && !CostantiConfigurazione.DISABILITATO.equals(is.getConnettore().getTipo())) {
                connettore = true;
            }
            if (is.getGetMessage() != null && CostantiConfigurazione.ABILITATO.equals(is.getGetMessage())) {
                get = true;
            }
            if (!connettore && !get) {
                this.errori.add("Il servizio Applicativo " + idServizioApplicativo + " possiede un elemento invocazione servizio per cui non e' stato definito ne una consegna trasparente (tramite connettore) ne il servizio di message box (tramite IntegrationManager)");
            }
            if ((getMsg = is.getGetMessage()) != null && !getMsg.equals(CostantiConfigurazione.ABILITATO) && !getMsg.equals(CostantiConfigurazione.DISABILITATO)) {
                this.errori.add("Il get-message dell'invocazione servizio del servizio applicativo " + idServizioApplicativo + " deve assumere i valori: " + CostantiConfigurazione.ABILITATO + " o " + CostantiConfigurazione.DISABILITATO);
            }
            if ((invRif = is.getInvioPerRiferimento()) != null && !invRif.equals(CostantiConfigurazione.ABILITATO) && !invRif.equals(CostantiConfigurazione.DISABILITATO)) {
                this.errori.add("La funzionalita' di invio per riferimento dell'invocazione servizio del servizio applicativo " + idServizioApplicativo + " deve assumere i valori: " + CostantiConfigurazione.ABILITATO + " o " + CostantiConfigurazione.DISABILITATO);
            }
            if ((rispRif = is.getRispostaPerRiferimento()) != null && !rispRif.equals(CostantiConfigurazione.ABILITATO) && !rispRif.equals(CostantiConfigurazione.DISABILITATO)) {
                this.errori.add("La funzionalita' di risposta per riferimento dell'invocazione servizio del servizio applicativo " + idServizioApplicativo + " deve assumere i valori: " + CostantiConfigurazione.ABILITATO + " o " + CostantiConfigurazione.DISABILITATO);
            }
            if ((sbustamentoSOAP = is.getSbustamentoSoap()) != null && !sbustamentoSOAP.equals(CostantiConfigurazione.ABILITATO) && !sbustamentoSOAP.equals(CostantiConfigurazione.DISABILITATO)) {
                this.errori.add("L'indicazione di sbustamento SOAP dell'invocazione servizio del servizio applicativo [" + idServizioApplicativo + "] deve assumere i valori: " + CostantiConfigurazione.ABILITATO + " o " + CostantiConfigurazione.DISABILITATO);
            }
            if ((sbustamentoInfoProtocollo = is.getSbustamentoInformazioniProtocollo()) != null && !sbustamentoInfoProtocollo.equals(CostantiConfigurazione.ABILITATO) && !sbustamentoInfoProtocollo.equals(CostantiConfigurazione.DISABILITATO)) {
                this.errori.add("L'indicazione di sbustamento informazioni di protcollo dell'invocazione servizio del servizio applicativo [" + idServizioApplicativo + "] deve assumere i valori: " + CostantiConfigurazione.ABILITATO + " o " + CostantiConfigurazione.DISABILITATO);
            }
        }
        if (sa.getRispostaAsincrona() != null) {
            RispostaAsincrona ra = sa.getRispostaAsincrona();
            c = ra.getCredenziali();
            if (c != null) {
                this.validaCredenziale((InvocazioneCredenziali)c, "servizio applicativo [" + idServizioApplicativo + "] (risposta asincrona)");
            }
            if ((auth = ra.getAutenticazione()) != null && !auth.equals(CostantiConfigurazione.INVOCAZIONE_SERVIZIO_AUTENTICAZIONE_BASIC) && !auth.equals(CostantiConfigurazione.INVOCAZIONE_SERVIZIO_AUTENTICAZIONE_NONE)) {
                this.errori.add("L'autenticazione della risposta asincrona del servizio applicativo " + idServizioApplicativo + " deve assumere uno dei seguenti valori: " + CostantiConfigurazione.INVOCAZIONE_SERVIZIO_AUTENTICAZIONE_BASIC.toString() + " o " + CostantiConfigurazione.INVOCAZIONE_SERVIZIO_AUTENTICAZIONE_NONE.toString());
            }
            if (CostantiConfigurazione.INVOCAZIONE_SERVIZIO_AUTENTICAZIONE_BASIC.equals(auth) && c == null) {
                this.errori.add("L'autenticazione " + CostantiConfigurazione.INVOCAZIONE_SERVIZIO_AUTENTICAZIONE_BASIC + " della risposta asincrona del servizio applicativo " + idServizioApplicativo + " richiede la presenza di credenziali");
            }
            if ((conn = ra.getConnettore()) != null) {
                this.validaConnettore(conn, "servizio applicativo [" + idServizioApplicativo + "] (risposta asincrona)", sogg);
            }
            if ((ge = ra.getGestioneErrore()) != null) {
                this.validaGestioneErrore(ge, "servizio applicativo [" + idServizioApplicativo + "] (risposta asincrona)");
            }
            boolean connettore = false;
            get = false;
            if (ra.getConnettore() != null && !CostantiConfigurazione.DISABILITATO.equals(ra.getConnettore().getTipo())) {
                connettore = true;
            }
            if (ra.getGetMessage() != null && CostantiConfigurazione.ABILITATO.equals(ra.getGetMessage())) {
                get = true;
            }
            if (!connettore && !get) {
                this.errori.add("Il servizio Applicativo " + idServizioApplicativo + " possiede un elemento risposta asincrona per cui non e' stato definito ne una consegna trasparente (tramite connettore) ne il servizio di message box (tramite IntegrationManager)");
            }
            if ((getMsg = ra.getGetMessage()) != null && !getMsg.equals(CostantiConfigurazione.ABILITATO) && !getMsg.equals(CostantiConfigurazione.DISABILITATO)) {
                this.errori.add("Il get-message della risposta asincrona del servizio applicativo " + idServizioApplicativo + " deve assumere i valori: " + CostantiConfigurazione.ABILITATO + " o " + CostantiConfigurazione.DISABILITATO);
            }
            if ((invRif = ra.getInvioPerRiferimento()) != null && !invRif.equals(CostantiConfigurazione.ABILITATO) && !invRif.equals(CostantiConfigurazione.DISABILITATO)) {
                this.errori.add("La funzionalita' di invio per riferimento della risposta asincrona del servizio applicativo " + idServizioApplicativo + " deve assumere i valori: " + CostantiConfigurazione.ABILITATO + " o " + CostantiConfigurazione.DISABILITATO);
            }
            if ((rispRif = ra.getRispostaPerRiferimento()) != null && !rispRif.equals(CostantiConfigurazione.ABILITATO) && !rispRif.equals(CostantiConfigurazione.DISABILITATO)) {
                this.errori.add("La funzionalita' di risposta per riferimento della risposta asincrona del servizio applicativo " + idServizioApplicativo + " deve assumere i valori: " + CostantiConfigurazione.ABILITATO + " o " + CostantiConfigurazione.DISABILITATO);
            }
            if ((sbustamentoSOAP = ra.getSbustamentoSoap()) != null && !sbustamentoSOAP.equals(CostantiConfigurazione.ABILITATO) && !sbustamentoSOAP.equals(CostantiConfigurazione.DISABILITATO)) {
                this.errori.add("L'indicazione di sbustamento SOAP della risposta asincrona del servizio applicativo [" + idServizioApplicativo + "] deve assumere i valori: " + CostantiConfigurazione.ABILITATO + " o " + CostantiConfigurazione.DISABILITATO);
            }
            if ((sbustamentoInfoProtocollo = ra.getSbustamentoInformazioniProtocollo()) != null && !sbustamentoInfoProtocollo.equals(CostantiConfigurazione.ABILITATO) && !sbustamentoInfoProtocollo.equals(CostantiConfigurazione.DISABILITATO)) {
                this.errori.add("L'indicazione di sbustamento informazioni di protcollo della risposta asincrona del servizio applicativo [" + idServizioApplicativo + "] deve assumere i valori: " + CostantiConfigurazione.ABILITATO + " o " + CostantiConfigurazione.DISABILITATO);
            }
        }
        int numSA = 0;
        for (int j = 0; j < sogg.sizeServizioApplicativoList(); ++j) {
            ServizioApplicativo tmpSA = sogg.getServizioApplicativo(j);
            if (!sa.getNome().equals(tmpSA.getNome())) continue;
            ++numSA;
        }
        if (numSA > 1) {
            this.errori.add("Non pu\u00f2 esistere pi\u00f9 di un servizio applicativo con nome " + sa.getNome() + " associato al soggetto " + sogg.getTipo() + "/" + sogg.getNome());
        }
    }

    private void validaConnettore(Connettore conn, String identificativoElementoInternoSoggetto, Soggetto soggetto) throws DriverConfigurazioneException {
        block118: {
            String nomeConn = conn.getNome();
            String tipoConn = conn.getTipo();
            String idSoggetto = soggetto.getTipo() + "/" + soggetto.getNome();
            if (nomeConn == null) {
                if (identificativoElementoInternoSoggetto == null) {
                    this.errori.add("Esiste un connettore nella radice del soggetto[" + idSoggetto + "] per cui non \u00e8 definito il nome");
                } else {
                    this.errori.add("Esiste un connettore del " + identificativoElementoInternoSoggetto + " (Soggetto:" + idSoggetto + ") per cui non \u00e8 definito il nome");
                }
                return;
            }
            if (identificativoElementoInternoSoggetto == null) {
                int numC = 0;
                for (int j = 0; j < soggetto.sizeConnettoreList(); ++j) {
                    Connettore tmpC = soggetto.getConnettore(j);
                    if (!nomeConn.equals(tmpC.getNome())) continue;
                    ++numC;
                }
                if (numC > 1) {
                    this.errori.add("Non pu\u00f2 esistere pi\u00f9 di un connettore con nome " + nomeConn + " definito come elemento radice del soggetto[" + idSoggetto + "]");
                }
            } else {
                if (tipoConn == null) {
                    conn = null;
                    for (int j = 0; j < soggetto.sizeConnettoreList(); ++j) {
                        Connettore connettore = soggetto.getConnettore(j);
                        if (!nomeConn.equals(connettore.getNome())) continue;
                        conn = connettore;
                        break;
                    }
                }
                if (conn == null) {
                    this.errori.add("Il connettore " + nomeConn + " del " + identificativoElementoInternoSoggetto + " (Soggetto:" + idSoggetto + ") non corrisponde a nessuno dei connettori registrati");
                } else {
                    tipoConn = conn.getTipo();
                }
            }
            if (!this.tipoConnettori.contains(tipoConn)) {
                if (identificativoElementoInternoSoggetto == null) {
                    this.errori.add("Il tipo [" + tipoConn + "] del connettore " + nomeConn + ", definito nella radice del soggetto[" + idSoggetto + "], non \u00e8 valido (Tipi conosciuti: " + this.getTipoConnettori() + ")");
                } else {
                    this.errori.add("Il tipo [" + tipoConn + "] del connettore " + nomeConn + " del " + identificativoElementoInternoSoggetto + " (Soggetto:" + idSoggetto + ") non \u00e8 valido (Tipi conosciuti: " + this.getTipoConnettori() + ")");
                }
            } else {
                List<Property> cps = conn.getPropertyList();
                Property[] cpArray = null;
                if (cps.size() > 0) {
                    cpArray = cps.toArray(new Property[cps.size()]);
                }
                if (cpArray != null) {
                    for (int j = 0; j < cpArray.length; ++j) {
                        Property cp = cpArray[j];
                        if (cp.getNome() == null) {
                            if (identificativoElementoInternoSoggetto == null) {
                                this.errori.add("Il connettore " + nomeConn + ", definito nella radice del soggetto[" + idSoggetto + "], possiede una propriet\u00e0 per cui non \u00e8 definito il nome");
                            } else {
                                this.errori.add("Il connettore " + nomeConn + " del " + identificativoElementoInternoSoggetto + " (Soggetto:" + idSoggetto + ") possiede una propriet\u00e0 per cui non \u00e8 definito il nome");
                            }
                            return;
                        }
                        if (cp.getValore() != null) continue;
                        if (identificativoElementoInternoSoggetto == null) {
                            this.errori.add("Il connettore " + nomeConn + ", definito nella radice del soggetto[" + idSoggetto + "], possiede una propriet\u00e0 per cui non \u00e8 definito il valore");
                        } else {
                            this.errori.add("Il connettore " + nomeConn + " del " + identificativoElementoInternoSoggetto + " (Soggetto:" + idSoggetto + ") possiede una propriet\u00e0 per cui non \u00e8 definito il valore");
                        }
                        return;
                    }
                }
                if (tipoConn.equals(TipiConnettore.HTTP.getNome())) {
                    String urlConn = null;
                    for (int j = 0; j < cpArray.length; ++j) {
                        Property cp = cpArray[j];
                        if (!cp.getNome().equals("location")) continue;
                        urlConn = cp.getValore();
                        break;
                    }
                    if (urlConn == null) {
                        if (identificativoElementoInternoSoggetto == null) {
                            this.errori.add("Il connettore " + nomeConn + ", definito nella radice del soggetto[" + idSoggetto + "], \u00e8 di tipo http, ma non ha una url definita");
                        } else {
                            this.errori.add("Il connettore " + nomeConn + " del " + identificativoElementoInternoSoggetto + " (Soggetto:" + idSoggetto + ") \u00e8 di tipo http, ma non ha una url definita");
                        }
                    } else {
                        try {
                            RegExpUtilities.validateUrl(urlConn);
                        }
                        catch (Exception e) {
                            if (identificativoElementoInternoSoggetto == null) {
                                this.errori.add("Il connettore " + nomeConn + ", definito nella radice del soggetto[" + idSoggetto + "], \u00e8 di tipo http, ma non ha una url valida: " + e.getMessage());
                                break block118;
                            }
                            this.errori.add("Il connettore " + nomeConn + " del " + identificativoElementoInternoSoggetto + " (Soggetto:" + idSoggetto + ") \u00e8 di tipo http, ma non ha una url valida: " + e.getMessage());
                        }
                    }
                } else if (tipoConn.equals(TipiConnettore.JMS.getNome())) {
                    String jmsNome = null;
                    String jmsTipo = null;
                    String jmsConnFact = null;
                    String jmsSendAs = null;
                    for (int j = 0; j < cpArray.length; ++j) {
                        Property cp = cpArray[j];
                        if (cp.getNome().equals("location")) {
                            jmsNome = cp.getValore();
                            continue;
                        }
                        if (cp.getNome().equals("tipo")) {
                            jmsTipo = cp.getValore();
                            continue;
                        }
                        if (cp.getNome().equals("connection-factory")) {
                            jmsConnFact = cp.getValore();
                            continue;
                        }
                        if (!cp.getNome().equals("send-as")) continue;
                        jmsSendAs = cp.getValore();
                    }
                    if (jmsNome == null) {
                        if (identificativoElementoInternoSoggetto == null) {
                            this.errori.add("Il connettore " + nomeConn + ", definito nella radice del soggetto[" + idSoggetto + "], \u00e8 di tipo jms, ma non ha un nome coda/topic definito");
                        } else {
                            this.errori.add("Il connettore " + nomeConn + " del " + identificativoElementoInternoSoggetto + " (Soggetto:" + idSoggetto + ") \u00e8 di tipo jms, ma non ha un nome coda/topic definito");
                        }
                    }
                    if (jmsTipo == null) {
                        if (identificativoElementoInternoSoggetto == null) {
                            this.errori.add("Il connettore " + nomeConn + ", definito nella radice del soggetto[" + idSoggetto + "], \u00e8 di tipo jms, ma non ha un tipo coda/topic definito");
                        } else {
                            this.errori.add("Il connettore " + nomeConn + " del " + identificativoElementoInternoSoggetto + " (Soggetto:" + idSoggetto + ") \u00e8 di tipo jms, ma non ha un tipo coda/topic definito");
                        }
                    } else if (!jmsTipo.equals("queue") && !jmsTipo.equals("topic")) {
                        if (identificativoElementoInternoSoggetto == null) {
                            this.errori.add("Il connettore " + nomeConn + ", definito nella radice del soggetto[" + idSoggetto + "], \u00e8 di tipo jms, ma non ha un tipo coda/topic valido (valori assumibili sono topic/queue)");
                        } else {
                            this.errori.add("Il connettore " + nomeConn + " del " + identificativoElementoInternoSoggetto + " (Soggetto:" + idSoggetto + ") \u00e8 di tipo jms, ma non ha un tipo coda/topic valido (valori assumibili sono topic/queue)");
                        }
                    }
                    if (jmsConnFact == null) {
                        if (identificativoElementoInternoSoggetto == null) {
                            this.errori.add("Il connettore " + nomeConn + ", definito nella radice del soggetto[" + idSoggetto + "], \u00e8 di tipo jms, ma non ha una connection factory definita");
                        } else {
                            this.errori.add("Il connettore " + nomeConn + " del " + identificativoElementoInternoSoggetto + " (Soggetto:" + idSoggetto + ") \u00e8 di tipo jms, ma non ha una connection factory definita");
                        }
                    }
                    if (jmsSendAs == null) {
                        if (identificativoElementoInternoSoggetto == null) {
                            this.errori.add("Il connettore " + nomeConn + ", definito nella radice del soggetto[" + idSoggetto + "], \u00e8 di tipo jms, ma non ha un tipo di messaggio (sendAs) definito");
                        } else {
                            this.errori.add("Il connettore " + nomeConn + " del " + identificativoElementoInternoSoggetto + " (Soggetto:" + idSoggetto + ") \u00e8 di tipo jms, ma non ha un tipo di messaggio (sendAs) definito");
                        }
                    } else if (!jmsSendAs.equals("TextMessage") && !jmsSendAs.equals("BytesMessage")) {
                        if (identificativoElementoInternoSoggetto == null) {
                            this.errori.add("Il connettore " + nomeConn + ", definito nella radice del soggetto[" + idSoggetto + "], \u00e8 di tipo jms, ma non ha un tipo di messaggio (sendAs) (valori assumibili sono TextMessage/BytesMessage)");
                        } else {
                            this.errori.add("Il connettore " + nomeConn + " del " + identificativoElementoInternoSoggetto + " (Soggetto:" + idSoggetto + ") \u00e8 di tipo jms, ma non ha un tipo di messaggio (sendAs) (valori assumibili sono TextMessage/BytesMessage)");
                        }
                    }
                } else if (tipoConn.equals(TipiConnettore.HTTPS.getNome())) {
                    String urlConn = null;
                    String trustStoreLocation = null;
                    String trustStorePassword = null;
                    String keyStoreLocation = null;
                    String keyStorePassword = null;
                    String keyPassword = null;
                    String hostNameVerifier = null;
                    for (int j = 0; j < cpArray.length; ++j) {
                        Property cp = cpArray[j];
                        if (cp.getNome().equals("location")) {
                            urlConn = cp.getValore();
                            continue;
                        }
                        if (cp.getNome().equals("trustStoreLocation")) {
                            trustStoreLocation = cp.getValore();
                            continue;
                        }
                        if (cp.getNome().equals("trustStorePassword")) {
                            trustStorePassword = cp.getValore();
                            continue;
                        }
                        if (cp.getNome().equals("keyStoreLocation")) {
                            keyStoreLocation = cp.getValore();
                            continue;
                        }
                        if (cp.getNome().equals("keyStorePassword")) {
                            keyStorePassword = cp.getValore();
                            continue;
                        }
                        if (cp.getNome().equals("keyPassword")) {
                            keyPassword = cp.getValore();
                            continue;
                        }
                        if (!cp.getNome().equals("hostnameVerifier")) continue;
                        hostNameVerifier = cp.getValore();
                    }
                    if (urlConn == null) {
                        if (identificativoElementoInternoSoggetto == null) {
                            this.errori.add("Il connettore " + nomeConn + ", definito nella radice del soggetto[" + idSoggetto + "], \u00e8 di tipo http, ma non ha una url definita");
                        } else {
                            this.errori.add("Il connettore " + nomeConn + " del " + identificativoElementoInternoSoggetto + " (Soggetto:" + idSoggetto + ") \u00e8 di tipo http, ma non ha una url definita");
                        }
                    } else {
                        try {
                            RegExpUtilities.validateUrl(urlConn);
                        }
                        catch (Exception e) {
                            if (identificativoElementoInternoSoggetto == null) {
                                this.errori.add("Il connettore " + nomeConn + ", definito nella radice del soggetto[" + idSoggetto + "], \u00e8 di tipo http, ma non ha una url valida: " + e.getMessage());
                            }
                            this.errori.add("Il connettore " + nomeConn + " del " + identificativoElementoInternoSoggetto + " (Soggetto:" + idSoggetto + ") \u00e8 di tipo http, ma non ha una url valida: " + e.getMessage());
                        }
                    }
                    if (trustStoreLocation != null) {
                        File f = new File(trustStoreLocation);
                        if (!f.exists()) {
                            if (identificativoElementoInternoSoggetto == null) {
                                this.errori.add("Il connettore " + nomeConn + ", definito nella radice del soggetto[" + idSoggetto + "], definisce un truststore " + trustStoreLocation + " che non esiste");
                            } else {
                                this.errori.add("Il connettore " + nomeConn + " del " + identificativoElementoInternoSoggetto + " (Soggetto:" + idSoggetto + ") definisce un truststore " + trustStoreLocation + " che non esiste");
                            }
                        } else if (!f.isFile()) {
                            if (identificativoElementoInternoSoggetto == null) {
                                this.errori.add("Il connettore " + nomeConn + ", definito nella radice del soggetto[" + idSoggetto + "], definisce un truststore " + trustStoreLocation + " che non e' un file");
                            } else {
                                this.errori.add("Il connettore " + nomeConn + " del " + identificativoElementoInternoSoggetto + " (Soggetto:" + idSoggetto + ") definisce un truststore " + trustStoreLocation + " che non e' un file");
                            }
                        } else if (!f.canRead()) {
                            if (identificativoElementoInternoSoggetto == null) {
                                this.errori.add("Il connettore " + nomeConn + ", definito nella radice del soggetto[" + idSoggetto + "], definisce un truststore " + trustStoreLocation + " che non e' accessibile (permessi in lettura non forniti)");
                            } else {
                                this.errori.add("Il connettore " + nomeConn + " del " + identificativoElementoInternoSoggetto + " (Soggetto:" + idSoggetto + ") definisce un truststore " + trustStoreLocation + " che non e' accessibile (permessi in lettura non forniti)");
                            }
                        } else if (trustStorePassword == null) {
                            if (identificativoElementoInternoSoggetto == null) {
                                this.errori.add("Il connettore " + nomeConn + ", definito nella radice del soggetto[" + idSoggetto + "], definisce un truststore " + trustStoreLocation + " per cui non e' stata specificata una password");
                            } else {
                                this.errori.add("Il connettore " + nomeConn + " del " + identificativoElementoInternoSoggetto + " (Soggetto:" + idSoggetto + ") definisce un truststore " + trustStoreLocation + " per cui non e' stata specificata una password");
                            }
                        }
                    }
                    if (keyStoreLocation != null) {
                        File f = new File(keyStoreLocation);
                        if (!f.exists()) {
                            if (identificativoElementoInternoSoggetto == null) {
                                this.errori.add("Il connettore " + nomeConn + ", definito nella radice del soggetto[" + idSoggetto + "], definisce un keystore " + keyStoreLocation + " che non esiste");
                            } else {
                                this.errori.add("Il connettore " + nomeConn + " del " + identificativoElementoInternoSoggetto + " (Soggetto:" + idSoggetto + ") definisce un keystore " + keyStoreLocation + " che non esiste");
                            }
                        } else if (!f.isFile()) {
                            if (identificativoElementoInternoSoggetto == null) {
                                this.errori.add("Il connettore " + nomeConn + ", definito nella radice del soggetto[" + idSoggetto + "], definisce un keystore " + keyStoreLocation + " che non e' un file");
                            } else {
                                this.errori.add("Il connettore " + nomeConn + " del " + identificativoElementoInternoSoggetto + " (Soggetto:" + idSoggetto + ") definisce un keystore " + keyStoreLocation + " che non e' un file");
                            }
                        } else if (!f.canRead()) {
                            if (identificativoElementoInternoSoggetto == null) {
                                this.errori.add("Il connettore " + nomeConn + ", definito nella radice del soggetto[" + idSoggetto + "], definisce un keystore " + keyStoreLocation + " che non e' accessibile (permessi in lettura non forniti)");
                            } else {
                                this.errori.add("Il connettore " + nomeConn + " del " + identificativoElementoInternoSoggetto + " (Soggetto:" + idSoggetto + ") definisce un keystore " + keyStoreLocation + " che non e' accessibile (permessi in lettura non forniti)");
                            }
                        } else if (keyStorePassword == null) {
                            if (identificativoElementoInternoSoggetto == null) {
                                this.errori.add("Il connettore " + nomeConn + ", definito nella radice del soggetto[" + idSoggetto + "], definisce un keystore " + keyStoreLocation + " per cui non e' stata specificata una password");
                            } else {
                                this.errori.add("Il connettore " + nomeConn + " del " + identificativoElementoInternoSoggetto + " (Soggetto:" + idSoggetto + ") definisce un keystore " + keyStoreLocation + " per cui non e' stata specificata una password");
                            }
                        } else if (keyPassword == null) {
                            if (identificativoElementoInternoSoggetto == null) {
                                this.errori.add("Il connettore " + nomeConn + ", definito nella radice del soggetto[" + idSoggetto + "], definisce un keystore " + keyStoreLocation + " per cui non e' stata specificata una password per la chiave privata");
                            } else {
                                this.errori.add("Il connettore " + nomeConn + " del " + identificativoElementoInternoSoggetto + " (Soggetto:" + idSoggetto + ") definisce un keystore " + keyStoreLocation + " per cui non e' stata specificata una password per la chiave privata");
                            }
                        }
                    }
                    if (hostNameVerifier != null) {
                        try {
                            Boolean.parseBoolean(hostNameVerifier);
                        }
                        catch (Exception e) {
                            if (identificativoElementoInternoSoggetto == null) {
                                this.errori.add("Il connettore " + nomeConn + ", definito nella radice del soggetto[" + idSoggetto + "], associa un valore non valido  alla proprieta' 'hostNameVerifier'; valori utilizzabili: true e false");
                                break block118;
                            }
                            this.errori.add("Il connettore " + nomeConn + " del " + identificativoElementoInternoSoggetto + " (Soggetto:" + idSoggetto + ") associa un valore non valido  alla proprieta' 'hostNameVerifier'; valori utilizzabili: true e false");
                        }
                    }
                } else if (tipoConn.equals(TipiConnettore.DISABILITATO.getNome()) && cpArray != null) {
                    if (identificativoElementoInternoSoggetto == null) {
                        this.errori.add("Il connettore " + nomeConn + ", definito nella radice del soggetto[" + idSoggetto + "], \u00e8 di tipo disabilitato, ma ha delle properties definite");
                    } else {
                        this.errori.add("Il connettore " + nomeConn + " del " + identificativoElementoInternoSoggetto + " (Soggetto:" + idSoggetto + ") \u00e8 di tipo disabilitato, ma ha delle properties definite");
                    }
                }
            }
        }
    }

    private void validaCorrelazioneApplicativaRichiesta(String identificativoRisorsa, CorrelazioneApplicativa ca, boolean portaDelegata) throws DriverConfigurazioneException {
        if (ca != null) {
            CorrelazioneApplicativaElemento cae;
            int j;
            if (ca.getScadenza() != null) {
                try {
                    Long.parseLong(ca.getScadenza());
                }
                catch (Exception e) {
                    this.errori.add("Il valore associato alla scadenza della correlazione applicativa inserita nella " + identificativoRisorsa + " dev'essere un numero intero");
                }
            }
            if (ca.sizeElementoList() < 1) {
                this.errori.add(identificativoRisorsa + " che possiede la definizione di una correlazione applicativa senza elementi?");
            }
            for (j = 0; j < ca.sizeElementoList(); ++j) {
                cae = ca.getElemento(j);
                if (cae.getNome() != null || j == ca.sizeElementoList() - 1) continue;
                this.errori.add(identificativoRisorsa + " che possiede la definizione di una correlazione applicativa (" + (j + 1) + ") con un elemento '*' (match qualsiasi contenuto) definito non come ultima regola di correlazione");
            }
            for (j = 0; j < ca.sizeElementoList(); ++j) {
                StatoFunzionalita riusoIdentificatore;
                CorrelazioneApplicativaGestioneIdentificazioneFallita identificazioneFallita;
                CorrelazioneApplicativaRichiestaIdentificazione identificazione;
                cae = ca.getElemento(j);
                int numE = 0;
                for (int k = 0; k < ca.sizeElementoList(); ++k) {
                    CorrelazioneApplicativaElemento tmpCae = ca.getElemento(k);
                    if (cae.getNome() == null) {
                        if (tmpCae.getNome() != null) continue;
                        ++numE;
                        continue;
                    }
                    if (!cae.getNome().equals(tmpCae.getNome())) continue;
                    ++numE;
                }
                if (numE > 1) {
                    String nome = "*";
                    if (cae.getNome() != null) {
                        nome = cae.getNome();
                    }
                    this.errori.add("Non pu\u00f2 esistere pi\u00f9 di un elemento di correlazione applicativa con nome " + nome + " (" + identificativoRisorsa + ")");
                }
                if (!((identificazione = cae.getIdentificazione()) == null || identificazione.equals(CostantiConfigurazione.CORRELAZIONE_APPLICATIVA_RICHIESTA_DISABILITATO) || identificazione.equals(CostantiConfigurazione.CORRELAZIONE_APPLICATIVA_RICHIESTA_URL_BASED) || identificazione.equals(CostantiConfigurazione.CORRELAZIONE_APPLICATIVA_RICHIESTA_CONTENT_BASED) || identificazione.equals(CostantiConfigurazione.CORRELAZIONE_APPLICATIVA_RICHIESTA_INPUT_BASED))) {
                    this.errori.add("La modalita d'identificazione della correlazione applicativa (" + (j + 1) + ") nella " + identificativoRisorsa + " deve assumere uno dei seguente valori: " + CostantiConfigurazione.CORRELAZIONE_APPLICATIVA_RICHIESTA_DISABILITATO + "," + CostantiConfigurazione.CORRELAZIONE_APPLICATIVA_RICHIESTA_URL_BASED + "," + CostantiConfigurazione.CORRELAZIONE_APPLICATIVA_RICHIESTA_CONTENT_BASED + " o " + CostantiConfigurazione.CORRELAZIONE_APPLICATIVA_RICHIESTA_INPUT_BASED);
                }
                if (identificazione == null) {
                    identificazione = CostantiConfigurazione.CORRELAZIONE_APPLICATIVA_RICHIESTA_CONTENT_BASED;
                }
                if ((CostantiConfigurazione.CORRELAZIONE_APPLICATIVA_RICHIESTA_URL_BASED.equals(identificazione) || CostantiConfigurazione.CORRELAZIONE_APPLICATIVA_RICHIESTA_CONTENT_BASED.equals(identificazione)) && cae.getPattern() == null) {
                    this.errori.add("La correlazione applicativa (" + (j + 1) + ") della " + identificativoRisorsa + " non contiene la definizione del pattern, nonostante la modalita' di identificazione sia " + identificazione);
                }
                if ((identificazioneFallita = cae.getIdentificazioneFallita()) != null && !identificazioneFallita.equals(CostantiConfigurazione.BLOCCA) && !identificazioneFallita.equals(CostantiConfigurazione.ACCETTA)) {
                    this.errori.add("Il comportamento in caso di identificazione fallita della correlazione applicativa (" + (j + 1) + ") nella " + identificativoRisorsa + " deve assumere uno dei seguente valori: " + CostantiConfigurazione.BLOCCA + " o " + CostantiConfigurazione.ACCETTA);
                }
                if ((riusoIdentificatore = cae.getRiusoIdentificativo()) == null || riusoIdentificatore.equals(CostantiConfigurazione.ABILITATO) || riusoIdentificatore.equals(CostantiConfigurazione.DISABILITATO)) continue;
                this.errori.add("Il comportamento per il riuso dell'id della correlazione applicativa (" + (j + 1) + ") nella " + identificativoRisorsa + " deve assumere uno dei seguente valori: " + CostantiConfigurazione.ABILITATO + " o " + CostantiConfigurazione.DISABILITATO);
            }
        }
    }

    private void validaCorrelazioneApplicativaRisposta(String identificativoRisorsa, CorrelazioneApplicativaRisposta ca, boolean portaDelegata) throws DriverConfigurazioneException {
        if (ca != null) {
            CorrelazioneApplicativaRispostaElemento cae;
            int j;
            if (ca.sizeElementoList() < 1) {
                this.errori.add(identificativoRisorsa + " che possiede la definizione di una correlazione applicativa senza elementi?");
            }
            for (j = 0; j < ca.sizeElementoList(); ++j) {
                cae = ca.getElemento(j);
                if (cae.getNome() != null || j == ca.sizeElementoList() - 1) continue;
                this.errori.add(identificativoRisorsa + " che possiede la definizione di una correlazione applicativa (" + (j + 1) + ") con un elemento '*' (match qualsiasi contenuto) definito non come ultima regola di correlazione");
            }
            for (j = 0; j < ca.sizeElementoList(); ++j) {
                CorrelazioneApplicativaGestioneIdentificazioneFallita identificazioneFallita;
                CorrelazioneApplicativaRispostaIdentificazione identificazione;
                cae = ca.getElemento(j);
                int numE = 0;
                for (int k = 0; k < ca.sizeElementoList(); ++k) {
                    CorrelazioneApplicativaRispostaElemento tmpCae = ca.getElemento(k);
                    if (cae.getNome() == null) {
                        if (tmpCae.getNome() != null) continue;
                        ++numE;
                        continue;
                    }
                    if (!cae.getNome().equals(tmpCae.getNome())) continue;
                    ++numE;
                }
                if (numE > 1) {
                    String nome = "*";
                    if (cae.getNome() != null) {
                        nome = cae.getNome();
                    }
                    this.errori.add("Non pu\u00f2 esistere pi\u00f9 di un elemento di correlazione applicativa con nome " + nome + " (" + identificativoRisorsa + ")");
                }
                if (!((identificazione = cae.getIdentificazione()) == null || identificazione.equals(CostantiConfigurazione.CORRELAZIONE_APPLICATIVA_RISPOSTA_DISABILITATO) || identificazione.equals(CostantiConfigurazione.CORRELAZIONE_APPLICATIVA_RISPOSTA_CONTENT_BASED) || identificazione.equals(CostantiConfigurazione.CORRELAZIONE_APPLICATIVA_RISPOSTA_INPUT_BASED))) {
                    this.errori.add("La modalita d'identificazione della correlazione applicativa (" + (j + 1) + ") nella " + identificativoRisorsa + " deve assumere uno dei seguente valori: " + CostantiConfigurazione.CORRELAZIONE_APPLICATIVA_RISPOSTA_DISABILITATO + "," + CostantiConfigurazione.CORRELAZIONE_APPLICATIVA_RISPOSTA_CONTENT_BASED + " o " + CostantiConfigurazione.CORRELAZIONE_APPLICATIVA_RISPOSTA_INPUT_BASED);
                }
                if (identificazione == null) {
                    identificazione = CostantiConfigurazione.CORRELAZIONE_APPLICATIVA_RISPOSTA_CONTENT_BASED;
                }
                if (CostantiConfigurazione.CORRELAZIONE_APPLICATIVA_RISPOSTA_CONTENT_BASED.equals(identificazione) && cae.getPattern() == null) {
                    this.errori.add("La correlazione applicativa (" + (j + 1) + ") della " + identificativoRisorsa + " non contiene la definizione del pattern, nonostante la modalita' di identificazione sia " + identificazione);
                }
                if ((identificazioneFallita = cae.getIdentificazioneFallita()) == null || identificazioneFallita.equals(CostantiConfigurazione.BLOCCA) || identificazioneFallita.equals(CostantiConfigurazione.ACCETTA)) continue;
                this.errori.add("Il comportamento in caso di identificazione fallita della correlazione applicativa (" + (j + 1) + ") nella " + identificativoRisorsa + " deve assumere uno dei seguente valori: " + CostantiConfigurazione.BLOCCA + " o " + CostantiConfigurazione.ACCETTA);
            }
        }
    }

    private void validaConfigurazione(Configurazione configurazione) throws DriverConfigurazioneException {
        StatoServiziPdd s;
        String[] v;
        IntegrationManager im;
        TipoConnessioneRisposte connessione;
        Risposte rs;
        StatoFunzionalita gestione;
        Attachments attachments;
        StatoFunzionalita utilizzo;
        IndirizzoRisposta it;
        ValidazioneBuste vbe;
        AccessoRegistro ar = null;
        if (configurazione.getAccessoRegistro() == null) {
            this.errori.add("Non \u00e8 stato configurato un accesso ad un registro dei servizi");
        } else {
            ar = configurazione.getAccessoRegistro();
            if (ar.sizeRegistroList() <= 0) {
                this.errori.add("Non \u00e8 stato configurato un accesso ad un registro dei servizi");
                ar = null;
            } else {
                for (int j = 0; j < ar.sizeRegistroList(); ++j) {
                    AccessoRegistroRegistro arr = ar.getRegistro(j);
                    String nomeArr = arr.getNome();
                    if (nomeArr == null) {
                        this.errori.add("E' presente la configurazione di accesso ad un registro dei servizi anonimo; deve obbligatoriamente essere associato un nome ad un registro dei servizi");
                    } else {
                        int numAR = 0;
                        for (int k = 0; k < ar.sizeRegistroList(); ++k) {
                            AccessoRegistroRegistro tmpArr = ar.getRegistro(k);
                            if (!nomeArr.equals(tmpArr.getNome())) continue;
                            ++numAR;
                        }
                        if (numAR > 1) {
                            this.errori.add("Non pu\u00f2 esistere pi\u00f9 di un registro dei servizi con nome " + nomeArr);
                        }
                    }
                    RegistroTipo tipo = arr.getTipo();
                    if (!(tipo == null || tipo.equals(CostantiConfigurazione.REGISTRO_XML) || tipo.equals(CostantiConfigurazione.REGISTRO_UDDI) || tipo.equals(CostantiConfigurazione.REGISTRO_WEB) || tipo.equals(CostantiConfigurazione.REGISTRO_DB) || tipo.equals(CostantiConfigurazione.REGISTRO_WS))) {
                        this.errori.add("Il tipo del registro " + nomeArr + " non \u00e8 valido; deve assumere uno dei seguenti tipi: " + CostantiConfigurazione.REGISTRO_XML.toString() + "," + CostantiConfigurazione.REGISTRO_UDDI.toString() + "," + CostantiConfigurazione.REGISTRO_WEB.toString() + "," + CostantiConfigurazione.REGISTRO_DB.toString() + "," + CostantiConfigurazione.REGISTRO_WS.toString());
                    }
                    if (arr.getLocation() == null) {
                        this.errori.add("Per la configurazione di accesso al registro dei servizi [" + nomeArr + "] non \u00e8 stata fornita la location");
                    }
                    if (arr.getPassword() == null || arr.getUser() != null) continue;
                    this.errori.add("Per la configurazione di accesso al registro dei servizi [" + nomeArr + "] non \u00e8 stata fornito un username, ma \u00e8 stato specificata una password?");
                }
                Cache arc = ar.getCache();
                if (arc != null) {
                    this.validaCache(arc, "Registro dei Servizi");
                }
            }
        }
        RoutingTable rt = configurazione.getRoutingTable();
        if (rt != null) {
            if (rt.getDefault() == null) {
                this.errori.add("(RoutingTable abilitata) Non \u00e8 stata definita una rotta di default");
            } else if (rt.getDefault().sizeRouteList() == 0) {
                this.errori.add("(RoutingTable abilitata) Non \u00e8 stata definita una rotta tra quelle di default");
            } else {
                RoutingTableDefault rtDefault = rt.getDefault();
                for (int i = 0; i < rtDefault.sizeRouteList(); ++i) {
                    Route r = rtDefault.getRoute(i);
                    this.validaRotta(r, "[RottaDefault]", ar);
                    if (r.getRegistro() != null) {
                        int numRR = 0;
                        for (int h = 0; h < rtDefault.sizeRouteList(); ++h) {
                            Route tmpR = rtDefault.getRoute(h);
                            if (tmpR.getRegistro() == null) continue;
                            RouteRegistro tmpRR = tmpR.getRegistro();
                            if (r.getRegistro().getNome() == null) {
                                if (tmpRR.getNome() != null) continue;
                                ++numRR;
                                continue;
                            }
                            if (!r.getRegistro().getNome().equals(tmpRR.getNome())) continue;
                            ++numRR;
                        }
                        if (numRR > 1) {
                            String nome = "TuttiRegistri";
                            if (r.getRegistro().getNome() != null) {
                                nome = r.getRegistro().getNome();
                            }
                            this.errori.add("(RoutingTableAbilitata) Non pu\u00f2 esistere pi\u00f9 di una rotta di default, che utilizzi il registro " + nome);
                        }
                    }
                    if (r.getGateway() == null || r.getGateway().getTipo() == null || r.getGateway().getNome() == null) continue;
                    RouteGateway rg = r.getGateway();
                    String idRG = rg.getTipo() + "/" + rg.getNome();
                    int numRG = 0;
                    for (int h = 0; h < rtDefault.sizeRouteList(); ++h) {
                        RouteGateway tmpRG;
                        String tmpIdRG;
                        Route tmpR = rtDefault.getRoute(h);
                        if (tmpR.getGateway() == null || tmpR.getGateway().getTipo() == null || tmpR.getGateway().getNome() == null || !idRG.equals(tmpIdRG = (tmpRG = tmpR.getGateway()).getTipo() + "/" + tmpRG.getNome())) continue;
                        ++numRG;
                    }
                    if (numRG <= true) continue;
                    this.errori.add("(RoutingTableAbilitata) Non pu\u00f2 esistere pi\u00f9 di una rotta di default di tipo gateway con identificativo soggetto " + idRG);
                }
            }
            for (int j = 0; j < rt.sizeDestinazioneList(); ++j) {
                int k;
                RoutingTableDestinazione rtd = rt.getDestinazione(j);
                if (rtd.getTipo() == null) {
                    this.errori.add("(RoutingTable abilitata) E' stata definita una rotta di destinazone statica, senza aver specificato il tipo");
                    continue;
                }
                if (rtd.getNome() == null) {
                    this.errori.add("(RoutingTable abilitata) E' stata definita una rotta di destinazone statica, senza aver specificato il nome");
                    continue;
                }
                String idDest = rtd.getTipo() + "/" + rtd.getNome();
                int numD = 0;
                for (k = 0; k < rt.sizeDestinazioneList(); ++k) {
                    RoutingTableDestinazione tmpRtd = rt.getDestinazione(k);
                    String tmpIdDest = tmpRtd.getTipo() + "/" + tmpRtd.getNome();
                    if (!idDest.equals(tmpIdDest)) continue;
                    ++numD;
                }
                if (numD > 1) {
                    this.errori.add("(RoutingTable abilitata)  Non pu\u00f2 esistere pi\u00f9 di una rotta di destinazione statico con identificativo soggetto" + idDest);
                }
                for (k = 0; k < rtd.sizeRouteList(); ++k) {
                    Route r = rtd.getRoute(k);
                    this.validaRotta(r, "[RottaDestinazioneStatica(" + idDest + ")]", ar);
                    if (r.getRegistro() != null) {
                        int numRR = 0;
                        for (int h = 0; h < rtd.sizeRouteList(); ++h) {
                            Route tmpR = rtd.getRoute(h);
                            if (tmpR.getRegistro() == null) continue;
                            RouteRegistro tmpRR = tmpR.getRegistro();
                            if (r.getRegistro().getNome() == null) {
                                if (tmpRR.getNome() != null) continue;
                                ++numRR;
                                continue;
                            }
                            if (!r.getRegistro().getNome().equals(tmpRR.getNome())) continue;
                            ++numRR;
                        }
                        if (numRR > 1) {
                            String nome = "TuttiRegistri";
                            if (r.getRegistro().getNome() != null) {
                                nome = r.getRegistro().getNome();
                            }
                            this.errori.add("(RoutingTableAbilitata) Non pu\u00f2 esistere pi\u00f9 di una rotta per la destinazione statica [" + idDest + "], che utilizzi il registro " + nome);
                        }
                    }
                    if (r.getGateway() == null || r.getGateway().getTipo() == null || r.getGateway().getNome() == null) continue;
                    RouteGateway rg = r.getGateway();
                    String idRG = rg.getTipo() + "/" + rg.getNome();
                    int numRG = 0;
                    for (int h = 0; h < rtd.sizeRouteList(); ++h) {
                        RouteGateway tmpRG;
                        String tmpIdRG;
                        Route tmpR = rtd.getRoute(h);
                        if (tmpR.getGateway() == null || tmpR.getGateway().getTipo() == null || tmpR.getGateway().getNome() == null || !idRG.equals(tmpIdRG = (tmpRG = tmpR.getGateway()).getTipo() + "/" + tmpRG.getNome())) continue;
                        ++numRG;
                    }
                    if (numRG <= true) continue;
                    this.errori.add("(RoutingTableAbilitata) Non pu\u00f2 esistere pi\u00f9 di una rotta per la destinazione statica [" + idDest + "] di tipo gateway con identificativo soggetto " + idRG);
                }
            }
        }
        if (configurazione.getAccessoConfigurazione() != null && configurazione.getAccessoConfigurazione().getCache() != null) {
            this.validaCache(configurazione.getAccessoConfigurazione().getCache(), "ConfigurazionePdD");
        }
        if (configurazione.getAccessoDatiAutorizzazione() != null && configurazione.getAccessoDatiAutorizzazione().getCache() != null) {
            this.validaCache(configurazione.getAccessoDatiAutorizzazione().getCache(), "DatiAutorizzazione");
        }
        if ((vbe = configurazione.getValidazioneBuste()) != null) {
            StatoFunzionalita manifest;
            StatoFunzionalita profColl;
            ValidazioneBusteTipoControllo controllo;
            StatoFunzionalitaConWarning statoBuste = vbe.getStato();
            if (!(statoBuste == null || statoBuste.equals(CostantiConfigurazione.STATO_CON_WARNING_ABILITATO) || statoBuste.equals(CostantiConfigurazione.STATO_CON_WARNING_DISABILITATO) || statoBuste.equals(CostantiConfigurazione.STATO_CON_WARNING_WARNING_ONLY))) {
                this.errori.add("Lo stato della validazione buste deve possedere uno dei seguenti valori: " + CostantiConfigurazione.STATO_CON_WARNING_ABILITATO + ", " + CostantiConfigurazione.STATO_CON_WARNING_DISABILITATO + " o " + CostantiConfigurazione.STATO_CON_WARNING_WARNING_ONLY);
            }
            if ((controllo = vbe.getControllo()) != null && !controllo.equals(CostantiConfigurazione.VALIDAZIONE_PROTOCOL_LIVELLO_NORMALE) && !controllo.equals(CostantiConfigurazione.VALIDAZIONE_PROTOCOL_LIVELLO_RIGIDO)) {
                this.errori.add("Il controllo della validazione buste deve possedere uno dei seguenti valori: " + CostantiConfigurazione.VALIDAZIONE_PROTOCOL_LIVELLO_NORMALE + " o " + CostantiConfigurazione.VALIDAZIONE_PROTOCOL_LIVELLO_RIGIDO);
            }
            if ((profColl = vbe.getProfiloCollaborazione()) != null && !profColl.equals(CostantiConfigurazione.ABILITATO) && !profColl.equals(CostantiConfigurazione.DISABILITATO)) {
                this.errori.add("Il profilo di collaborazione della validazione buste deve possedere i valori " + CostantiConfigurazione.ABILITATO + " o " + CostantiConfigurazione.DISABILITATO);
            }
            if ((manifest = vbe.getManifestAttachments()) != null && !manifest.equals("abilitato") && !manifest.equals("disabilitato")) {
                this.errori.add("Il manifest-attachments della validazione buste deve possedere i valori " + CostantiConfigurazione.ABILITATO + " o " + CostantiConfigurazione.DISABILITATO);
            }
        }
        if (configurazione.getValidazioneContenutiApplicativi() != null) {
            this.validazioneValidazioneContenutiApplicativi(configurazione.getValidazioneContenutiApplicativi(), "ConfigurazioneGeneralePdD");
        }
        if ((it = configurazione.getIndirizzoRisposta()) != null && (utilizzo = it.getUtilizzo()) != null && !utilizzo.equals(CostantiConfigurazione.ABILITATO) && !utilizzo.equals(CostantiConfigurazione.DISABILITATO)) {
            this.errori.add("L'utilizzo dell'indirizzo per la risposta nella configurazione generale della PdD deve assumere i valori: " + CostantiConfigurazione.ABILITATO + " o " + CostantiConfigurazione.DISABILITATO);
        }
        if ((attachments = configurazione.getAttachments()) != null && (gestione = attachments.getGestioneManifest()) != null && !gestione.equals(CostantiConfigurazione.ABILITATO) && !gestione.equals(CostantiConfigurazione.DISABILITATO)) {
            this.errori.add("La gestione dei manifest degli attachments nella configurazione generale della PdD deve assumere i valori: " + CostantiConfigurazione.ABILITATO + " o " + CostantiConfigurazione.DISABILITATO);
        }
        if ((rs = configurazione.getRisposte()) != null && (connessione = rs.getConnessione()) != null && !connessione.equals(CostantiConfigurazione.NEW_CONNECTION) && !connessione.equals(CostantiConfigurazione.CONNECTION_REPLY)) {
            this.errori.add("La connessione delle risposte nella configurazione generale della PdD deve assumere i valori:" + CostantiConfigurazione.CONNECTION_REPLY + " o " + CostantiConfigurazione.NEW_CONNECTION);
        }
        if (configurazione.getInoltroBusteNonRiscontrate() == null) {
            this.errori.add("Definizione della cadenza delle buste non riscontrate non presente nella configurazione generale della PdD");
        } else {
            InoltroBusteNonRiscontrate inoltro = configurazione.getInoltroBusteNonRiscontrate();
            if (inoltro.getCadenza() == null) {
                this.errori.add("Definizione della cadenza delle buste non riscontrate non presente nella configurazione generale della PdD");
            } else {
                try {
                    Long.parseLong(inoltro.getCadenza());
                }
                catch (Exception e) {
                    this.errori.add("Il valore associato alla cadenza delle buste non riscontrate, presente nella configurazione generale della PdD, dev'essere un numero intero");
                }
            }
        }
        MessaggiDiagnostici md = configurazione.getMessaggiDiagnostici();
        if (md != null) {
            Severita severitaLog4j;
            for (int j = 0; j < md.sizeOpenspcoopAppenderList(); ++j) {
                OpenspcoopAppender oa = md.getOpenspcoopAppender(j);
                if (oa.getTipo() == null) {
                    this.errori.add("E' stato definito un appender dei msg diagnostici per cui non e' stato definito il tipo");
                    continue;
                }
                if (!this.tipoMsgDiagnosticiAppender.contains(oa.getTipo())) {
                    this.errori.add("E' stato definito un appender dei msg diagnostici per cui e' stato definito un tipo[" + oa.getTipo() + "] non valido, valori ammessi sono: " + this.getTipoMsgDiagnosticiAppender());
                }
                for (int k = 0; k < oa.sizePropertyList(); ++k) {
                    Property oap = oa.getProperty(k);
                    if (oap.getNome() == null) continue;
                    if (oap.getValore() == null) {
                        this.errori.add("E' stato definito un appender[" + oa.getTipo() + "] dei msg diagnostici per cui esiste una proprieta' senza un valore?");
                        continue;
                    }
                    String nomeOap = oap.getNome();
                    int numOap = 0;
                    for (int h = 0; h < oa.sizePropertyList(); ++h) {
                        Property tmpOap = oa.getProperty(h);
                        if (!nomeOap.equals(tmpOap.getNome())) continue;
                        ++numOap;
                    }
                    if (numOap <= true) continue;
                    this.errori.add("Non pu\u00f2 esistere pi\u00f9 di una propriet\u00e0 con nome " + nomeOap + " per lo stesso appender[" + oa.getTipo() + "] dei msg diagnostici");
                }
            }
            Severita severita = md.getSeverita();
            if (!(severita == null || severita.equals(Severita.OFF) || severita.equals(Severita.FATAL) || severita.equals(Severita.ERROR_PROTOCOL) || severita.equals(Severita.ERROR_INTEGRATION) || severita.equals(Severita.INFO_PROTOCOL) || severita.equals(Severita.INFO_INTEGRATION) || severita.equals(Severita.DEBUG_LOW) || severita.equals(Severita.DEBUG_MEDIUM) || severita.equals(Severita.DEBUG_HIGH) || severita.equals(Severita.ALL))) {
                this.errori.add("L'opzione 'severita' della configurazione dei messaggi diagnostici nella configurazione generale della PdD deve assumere uno dei seguenti valori: off, fatal, errorProtocol, errorIntegration, infoProtocol, infoIntegration, debugLow, debugMedium, debugHigh, all");
            }
            if (!((severitaLog4j = md.getSeveritaLog4j()) == null || severitaLog4j.equals(Severita.OFF) || severitaLog4j.equals(Severita.FATAL) || severitaLog4j.equals(Severita.ERROR_PROTOCOL) || severitaLog4j.equals(Severita.ERROR_INTEGRATION) || severitaLog4j.equals(Severita.INFO_PROTOCOL) || severitaLog4j.equals(Severita.INFO_INTEGRATION) || severitaLog4j.equals(Severita.DEBUG_LOW) || severitaLog4j.equals(Severita.DEBUG_MEDIUM) || severitaLog4j.equals(Severita.DEBUG_HIGH) || severitaLog4j.equals(Severita.ALL))) {
                this.errori.add("L'opzione 'severita-log4j' della configurazione dei messaggi diagnostici nella configurazione generale della PdD deve assumere uno dei seguenti valori: off, fatal, errorProtocol, errorIntegration, infoProtocol, infoIntegration, debugLow, debugMedium, debugHigh, all");
            }
        } else {
            this.errori.add("Non e' stata definita la configurazione dei messaggi diagnostici nella configurazione generale della PdD");
        }
        Tracciamento t = configurazione.getTracciamento();
        if (t != null) {
            StatoFunzionalita dump;
            for (int j = 0; j < t.sizeOpenspcoopAppenderList(); ++j) {
                OpenspcoopAppender oa = t.getOpenspcoopAppender(j);
                if (oa.getTipo() == null) {
                    this.errori.add("E' stato definito un appender delle tracce per cui non e' stato definito il tipo");
                    continue;
                }
                if (!this.tipoTracciamentoAppender.contains(oa.getTipo())) {
                    this.errori.add("E' stato definito un appender delle tracce per cui e' stato definito un tipo[" + oa.getTipo() + "] non valido, valori ammessi sono: " + this.getTipoTracciamentoAppender());
                }
                for (int k = 0; k < oa.sizePropertyList(); ++k) {
                    Property oap = oa.getProperty(k);
                    if (oap.getNome() == null) {
                        this.errori.add("E' stato definito un appender[" + oa.getTipo() + "] delle tracce per cui esiste una proprieta' senza un nome?");
                        continue;
                    }
                    if (oap.getValore() == null) {
                        this.errori.add("E' stato definito un appender[" + oa.getTipo() + "] delle tracce per cui esiste una proprieta' senza un valore?");
                        continue;
                    }
                    String nomeOap = oap.getNome();
                    int numOap = 0;
                    for (int h = 0; h < oa.sizePropertyList(); ++h) {
                        Property tmpOap = oa.getProperty(h);
                        if (!nomeOap.equals(tmpOap.getNome())) continue;
                        ++numOap;
                    }
                    if (numOap <= true) continue;
                    this.errori.add("Non pu\u00f2 esistere pi\u00f9 di una propriet\u00e0 con nome " + nomeOap + " per lo stesso appender[" + oa.getTipo() + "] delle tracce");
                }
            }
            StatoFunzionalita tracciamentoBuste = t.getBuste();
            if (tracciamentoBuste != null && !tracciamentoBuste.equals(CostantiConfigurazione.ABILITATO) && !tracciamentoBuste.equals(CostantiConfigurazione.DISABILITATO)) {
                this.errori.add("Il valore 'buste' della configurazione per il tracciamento delle buste deve assumere i valori " + CostantiConfigurazione.ABILITATO + " o " + CostantiConfigurazione.DISABILITATO);
            }
            if ((dump = t.getDump()) != null && !dump.equals(CostantiConfigurazione.ABILITATO) && !dump.equals(CostantiConfigurazione.DISABILITATO)) {
                this.errori.add("Il valore 'dump' della configurazione per il tracciamento delle buste deve assumere i valori " + CostantiConfigurazione.ABILITATO + " o " + CostantiConfigurazione.DISABILITATO);
            }
        }
        if (configurazione.getGestioneErrore() != null) {
            if (configurazione.getGestioneErrore().getComponenteCooperazione() != null) {
                this.validaGestioneErrore(configurazione.getGestioneErrore().getComponenteCooperazione(), "ConfigurazioneGenerale-GestioneErroreComponenteCooperazione");
            }
            if (configurazione.getGestioneErrore().getComponenteIntegrazione() != null) {
                this.validaGestioneErrore(configurazione.getGestioneErrore().getComponenteIntegrazione(), "ConfigurazioneGenerale-GestioneErroreComponenteIntegrazione");
            }
        }
        if ((im = configurazione.getIntegrationManager()) != null && im.getAutenticazione() != null && (v = im.getAutenticazione().split(",")) != null && v.length > 0) {
            for (int l = 0; l < v.length; ++l) {
                if (this.tipoAutenticazionePortaDelegata.contains(v[l].trim())) continue;
                this.errori.add("Processo di autenticazione[" + v[l].trim() + "] associato al servizio di IntegrationManager non conosciuto, valori ammessi: " + this.getTipoAutenticazionePortaDelegata());
            }
        }
        if ((s = configurazione.getStatoServiziPdd()) != null) {
            StatoServiziPddIntegrationManager sIM;
            StatoFunzionalita integrationManager;
            if (s.getPortaDelegata() != null) {
                StatoServiziPddPortaDelegata sPD = s.getPortaDelegata();
                StatoFunzionalita portaDelegata = sPD.getStato();
                if (portaDelegata != null && !portaDelegata.equals(CostantiConfigurazione.ABILITATO) && !portaDelegata.equals(CostantiConfigurazione.DISABILITATO)) {
                    this.errori.add("Il valore 'stato' della configurazione per quanto concerne i servizi attivi sulla porta (PD) deve assumere i valori " + CostantiConfigurazione.ABILITATO + " o " + CostantiConfigurazione.DISABILITATO);
                }
                this.validaFiltriStatoServiziPdD("FiltroAbilitazione", sPD.getFiltroAbilitazioneList());
                this.validaFiltriStatoServiziPdD("FiltroDisabilitazione", sPD.getFiltroDisabilitazioneList());
            }
            if (s.getPortaApplicativa() != null) {
                StatoServiziPddPortaApplicativa sPA = s.getPortaApplicativa();
                StatoFunzionalita portaApplicativa = sPA.getStato();
                if (portaApplicativa != null && !portaApplicativa.equals(CostantiConfigurazione.ABILITATO) && !portaApplicativa.equals(CostantiConfigurazione.DISABILITATO)) {
                    this.errori.add("Il valore 'porta_applicativa' della configurazione per quanto concerne i servizi attivi sulla porta (PA) deve assumere i valori " + CostantiConfigurazione.ABILITATO + " o " + CostantiConfigurazione.DISABILITATO);
                }
                this.validaFiltriStatoServiziPdD("FiltroAbilitazione", sPA.getFiltroAbilitazioneList());
                this.validaFiltriStatoServiziPdD("FiltroDisabilitazione", sPA.getFiltroDisabilitazioneList());
            }
            if (s.getIntegrationManager() != null && (integrationManager = (sIM = s.getIntegrationManager()).getStato()) != null && !integrationManager.equals(CostantiConfigurazione.ABILITATO) && !integrationManager.equals(CostantiConfigurazione.DISABILITATO)) {
                this.errori.add("Il valore 'integration_manager' della configurazione per quanto concerne i servizi attivi sulla porta (IM) assumere i valori " + CostantiConfigurazione.ABILITATO + " o " + CostantiConfigurazione.DISABILITATO);
            }
        }
    }

    private void validaCache(Cache cache, String posizione) {
        AlgoritmoCache algoritmo;
        if (cache.getDimensione() != null) {
            try {
                Integer.parseInt(cache.getDimensione());
            }
            catch (Exception e) {
                this.errori.add("Il valore associato alla dimensione della cache [" + posizione + "] dev'essere un numero intero");
            }
        }
        if ((algoritmo = cache.getAlgoritmo()) != null && !algoritmo.equals(CostantiConfigurazione.CACHE_LRU) && !algoritmo.equals(CostantiConfigurazione.CACHE_MRU)) {
            this.errori.add("L'algoritmo dell'accesso alla cache [" + posizione + "] dev'essere " + CostantiConfigurazione.CACHE_LRU + " o " + CostantiConfigurazione.CACHE_MRU);
        }
        if (cache.getItemIdleTime() != null) {
            try {
                Long.parseLong(cache.getItemIdleTime());
            }
            catch (Exception e) {
                this.errori.add("Il valore associato all'item-idle-time della cache  [" + posizione + "] dev'essere un numero intero");
            }
        }
        if (cache.getItemLifeSecond() != null) {
            try {
                Long.parseLong(cache.getItemLifeSecond());
            }
            catch (Exception e) {
                this.errori.add("Il valore associato all'item-life-seconds della cache [" + posizione + "] dev'essere un numero intero");
            }
        }
    }

    private void validaFiltriStatoServiziPdD(String tipologiaFiltri, List<TipoFiltroAbilitazioneServizi> lista) {
        if (lista != null) {
            for (int j = 0; j < lista.size(); ++j) {
                TipoFiltroAbilitazioneServizi tipoFiltroAbilitazioneServizi = lista.get(j);
            }
        }
    }

    private void validaRotta(Route route, String tipo, AccessoRegistro ar) throws DriverConfigurazioneException {
        if (route.getGateway() == null && route.getRegistro() == null) {
            this.errori.add("(RoutingTable) \u00e8 stata definita una rotta " + tipo + " senza aver specificato ne un Gateway ne un Registro");
        } else if (route.getGateway() != null && route.getRegistro() != null) {
            this.errori.add("(RoutingTable) \u00e8 stata definita una rotta " + tipo + " che possiede sia un Gateway che un Registro (Solo un tipo deve essere selezionato)");
        } else if (route.getGateway() != null) {
            if (route.getGateway().getNome() == null) {
                this.errori.add("(RoutingTable) \u00e8 stata definita una rotta " + tipo + " senza aver specificato il nome del soggetto Gateway");
            }
            if (route.getGateway().getTipo() == null) {
                this.errori.add("(RoutingTable) \u00e8 stata definita una rotta " + tipo + " senza aver specificato il tipo del soggetto Gateway");
            }
        } else if (route.getRegistro().getNome() != null && ar != null) {
            boolean trovato = false;
            for (int i = 0; i < ar.sizeRegistroList(); ++i) {
                if (!ar.getRegistro(i).getNome().equals(route.getRegistro().getNome())) continue;
                trovato = true;
                break;
            }
            if (!trovato) {
                this.errori.add("(RoutingTable) \u00e8 stata definita una rotta " + tipo + " per cui \u00e8 stata specificato un registro [" + route.getRegistro().getNome() + "] non esistente neella configurazione");
            }
        }
    }

    private void validaMessageSecurity(MessageSecurity messageSecurity, String idOggetto) throws DriverConfigurazioneException {
        MessageSecurityFlowParameter tmpSecurityParameter;
        int k;
        int numRF;
        MessageSecurityFlowParameter securityParameter;
        int j;
        MessageSecurityFlow messageSecurityFlow;
        if (messageSecurity.getRequestFlow() != null) {
            messageSecurityFlow = messageSecurity.getRequestFlow();
            for (j = 0; j < messageSecurityFlow.sizeParameterList(); ++j) {
                securityParameter = messageSecurityFlow.getParameter(j);
                if (securityParameter.getNome() == null) {
                    this.errori.add("(" + idOggetto + " MessageSecurity) Nella request-flow esiste una proprieta' per cui non e' stato definito il nome");
                }
                if (securityParameter.getValore() == null) {
                    this.errori.add("(" + idOggetto + " MessageSecurity) Nella request-flow esiste una proprieta' per cui non e' stato definito il valore");
                }
                numRF = 0;
                for (k = 0; k < messageSecurityFlow.sizeParameterList(); ++k) {
                    tmpSecurityParameter = messageSecurityFlow.getParameter(k);
                    if (!securityParameter.getNome().equals(tmpSecurityParameter.getNome())) continue;
                    ++numRF;
                }
                if (numRF <= true) continue;
                this.errori.add("(" + idOggetto + " MessageSecurity) Nella request-flow non pu\u00f2 esistere pi\u00f9 di una proprieta' con lo stess nome " + securityParameter.getNome());
            }
        }
        if (messageSecurity.getResponseFlow() != null) {
            messageSecurityFlow = messageSecurity.getResponseFlow();
            for (j = 0; j < messageSecurityFlow.sizeParameterList(); ++j) {
                securityParameter = messageSecurityFlow.getParameter(j);
                if (securityParameter.getNome() == null) {
                    this.errori.add("(" + idOggetto + " MessageSecurity) Nella response-flow esiste una proprieta' per cui non e' stato definito il nome");
                }
                if (securityParameter.getValore() == null) {
                    this.errori.add("(" + idOggetto + " MessageSecurity) Nella response-flow esiste una proprieta' per cui non e' stato definito il valore");
                }
                numRF = 0;
                for (k = 0; k < messageSecurityFlow.sizeParameterList(); ++k) {
                    tmpSecurityParameter = messageSecurityFlow.getParameter(k);
                    if (!securityParameter.getNome().equals(tmpSecurityParameter.getNome())) continue;
                    ++numRF;
                }
                if (numRF <= true) continue;
                this.errori.add("(" + idOggetto + " MessageSecurity) Nella response-flow non pu\u00f2 esistere pi\u00f9 di una proprieta' con lo stess nome " + securityParameter.getNome());
            }
        }
    }

    private void validaMTOM(MtomProcessor mtomProcessor, String idOggetto) throws DriverConfigurazioneException {
        MtomProcessorFlowParameter tmpMtomtFlowParameter;
        int k;
        int numRF;
        MtomProcessorFlowParameter mtomtFlowParameter;
        int j;
        if (mtomProcessor.getRequestFlow() != null) {
            MtomProcessorFlow mtomtFlow = mtomProcessor.getRequestFlow();
            for (j = 0; j < mtomtFlow.sizeParameterList(); ++j) {
                mtomtFlowParameter = mtomtFlow.getParameter(j);
                if (mtomtFlowParameter.getNome() == null) {
                    this.errori.add("(" + idOggetto + " MTOM-Processor) Nella request-flow esiste una proprieta' per cui non e' stato definito il nome");
                }
                if (mtomtFlowParameter.getPattern() == null) {
                    this.errori.add("(" + idOggetto + " MTOM-Processor) Nella request-flow esiste una proprieta' per cui non e' stato definito il valore");
                }
                numRF = 0;
                for (k = 0; k < mtomtFlow.sizeParameterList(); ++k) {
                    tmpMtomtFlowParameter = mtomtFlow.getParameter(k);
                    if (!mtomtFlowParameter.getNome().equals(tmpMtomtFlowParameter.getNome())) continue;
                    ++numRF;
                }
                if (numRF <= true) continue;
                this.errori.add("(" + idOggetto + " MTOM-Processor) Nella request-flow non pu\u00f2 esistere pi\u00f9 di una proprieta' con lo stess nome " + mtomtFlowParameter.getNome());
            }
        }
        if (mtomProcessor.getResponseFlow() != null) {
            MtomProcessorFlow mtomFlow = mtomProcessor.getResponseFlow();
            for (j = 0; j < mtomFlow.sizeParameterList(); ++j) {
                mtomtFlowParameter = mtomFlow.getParameter(j);
                if (mtomtFlowParameter.getNome() == null) {
                    this.errori.add("(" + idOggetto + " MTOM-Processor) Nella response-flow esiste una proprieta' per cui non e' stato definito il nome");
                }
                if (mtomtFlowParameter.getPattern() == null) {
                    this.errori.add("(" + idOggetto + " MTOM-Processor) Nella response-flow esiste una proprieta' per cui non e' stato definito il valore");
                }
                numRF = 0;
                for (k = 0; k < mtomFlow.sizeParameterList(); ++k) {
                    tmpMtomtFlowParameter = mtomFlow.getParameter(k);
                    if (!mtomtFlowParameter.getNome().equals(tmpMtomtFlowParameter.getNome())) continue;
                    ++numRF;
                }
                if (numRF <= true) continue;
                this.errori.add("(" + idOggetto + " MTOM-Processor) Nella response-flow non pu\u00f2 esistere pi\u00f9 di una proprieta' con lo stess nome " + mtomtFlowParameter.getNome());
            }
        }
    }

    private void validazioneValidazioneContenutiApplicativi(ValidazioneContenutiApplicativi vca, String tipo) throws DriverConfigurazioneException {
        ValidazioneContenutiApplicativiTipo tipoV;
        StatoFunzionalitaConWarning stato = vca.getStato();
        if (!(stato == null || stato.equals(CostantiConfigurazione.STATO_CON_WARNING_ABILITATO) || stato.equals(CostantiConfigurazione.STATO_CON_WARNING_DISABILITATO) || stato.equals(CostantiConfigurazione.STATO_CON_WARNING_WARNING_ONLY))) {
            this.errori.add("Lo stato della validazione contenuti applicativi (" + tipo + ") deve possedere uno dei seguenti valori: " + CostantiConfigurazione.STATO_CON_WARNING_ABILITATO + ", " + CostantiConfigurazione.STATO_CON_WARNING_DISABILITATO + " o " + CostantiConfigurazione.STATO_CON_WARNING_WARNING_ONLY);
        }
        if (!((tipoV = vca.getTipo()) == null || tipoV.equals(CostantiConfigurazione.VALIDAZIONE_CONTENUTI_APPLICATIVI_OPENSPCOOP) || tipoV.equals(CostantiConfigurazione.VALIDAZIONE_CONTENUTI_APPLICATIVI_WSDL) || tipoV.equals(CostantiConfigurazione.VALIDAZIONE_CONTENUTI_APPLICATIVI_XSD))) {
            this.errori.add("Il tipo di validazione contenuti applicativi da attuare (" + tipo + ") deve possedere uno dei seguenti valori: " + CostantiConfigurazione.VALIDAZIONE_CONTENUTI_APPLICATIVI_XSD + ", " + CostantiConfigurazione.VALIDAZIONE_CONTENUTI_APPLICATIVI_WSDL + " o " + CostantiConfigurazione.VALIDAZIONE_CONTENUTI_APPLICATIVI_OPENSPCOOP);
        }
    }

    private void validaProtocolProperty(ProprietaProtocollo ssp, String oggetto) throws DriverConfigurazioneException {
        String valore;
        if (ssp.getNome() == null) {
            this.errori.add("Esiste una ProprietaProtocollo della porta applicativa " + oggetto + " che non contiene la definizione del nome");
        }
        if (ssp.getValore() == null) {
            this.errori.add("Esiste una ProprietaProtocollo della porta applicativa " + oggetto + " che non contiene la definizione del valore");
        }
        if ((valore = ssp.getValore()) == null) {
            this.errori.add("Il valore della ProprietaProtocollo " + ssp.getNome() + " della porta applicativa " + oggetto + " non e' valorizzato");
        }
    }

    private void validaCredenziale(Credenziali c, String oggetto) throws DriverConfigurazioneException {
        CredenzialeTipo tipo = CostantiConfigurazione.CREDENZIALE_SSL;
        if (c.getTipo() != null) {
            tipo = c.getTipo();
        }
        if (!(tipo.equals(CostantiConfigurazione.CREDENZIALE_BASIC) || tipo.equals(CostantiConfigurazione.CREDENZIALE_SSL) || tipo.equals(CostantiConfigurazione.CREDENZIALE_PRINCIPAL))) {
            this.errori.add("Il tipo delle credenziali del " + oggetto + " deve possedere i valori: " + CostantiConfigurazione.CREDENZIALE_BASIC.toString() + " o " + CostantiConfigurazione.CREDENZIALE_SSL.toString() + " o " + CostantiConfigurazione.CREDENZIALE_PRINCIPAL.toString());
        }
        if (c.getTipo().equals(CostantiConfigurazione.CREDENZIALE_BASIC) && (c.getUser() == null || c.getUser().equals("") || c.getPassword() == null || c.getPassword().equals(""))) {
            this.errori.add("Le credenziali di tipo basic del " + oggetto + " devono avere username e password valorizzati");
        }
        if (c.getTipo().equals(CostantiConfigurazione.CREDENZIALE_SSL)) {
            if (c.getSubject() == null || c.getSubject().equals("")) {
                this.errori.add("Le credenziali di tipo ssl del " + oggetto + " devono avere subject valorizzato");
            } else {
                try {
                    Utilities.validaSubject(c.getSubject());
                }
                catch (Exception e) {
                    this.errori.add("Le credenziali di tipo ssl del " + oggetto + " possiedono un subject non valido: " + e.getMessage());
                }
            }
        }
        if (c.getTipo().equals(CostantiConfigurazione.CREDENZIALE_PRINCIPAL) && (c.getUser() == null || c.getUser().equals(""))) {
            this.errori.add("Le credenziali di tipo principal del " + oggetto + " devono avere user valorizzato");
        }
    }

    private void validaCredenziale(InvocazioneCredenziali c, String oggetto) throws DriverConfigurazioneException {
        if (c.getUser() == null || c.getUser().equals("") || c.getPassword() == null || c.getPassword().equals("")) {
            this.errori.add("Le credenziali di tipo basic del " + oggetto + " devono avere username e password valorizzati");
        }
    }

    private void validaGestioneErrore(GestioneErrore ge, String tipo) throws DriverConfigurazioneException {
        int j;
        for (j = 0; j < ge.sizeCodiceTrasportoList(); ++j) {
            GestioneErroreComportamento comportamento;
            GestioneErroreCodiceTrasporto gect = ge.getCodiceTrasporto(j);
            if (gect.getValoreMinimo() == null || gect.getValoreMassimo() == null) {
                this.errori.add("Gli elementi codice-trasporto devono possedere almeno un valore minimo o un valore massimo");
            }
            if (gect.getValoreMinimo() != null && gect.getValoreMinimo().longValue() < 0L) {
                this.errori.add("Il valore minimo di un codice-trasporto associato alla gestione errore (" + tipo + "), dev'essere un numero intero >= 0 (Attualemente:" + gect.getValoreMinimo().longValue() + ")");
            }
            if (gect.getValoreMassimo() != null && gect.getValoreMassimo().longValue() <= 0L) {
                this.errori.add("Il valore massimo di un codice-trasporto associato alla gestione errore (" + tipo + "), dev'essere un numero intero > 0 (Attualemente:" + gect.getValoreMassimo().longValue() + ")");
            }
            if (gect.getValoreMassimo() != null && gect.getValoreMinimo().longValue() >= 0L && gect.getValoreMinimo() != null && gect.getValoreMassimo().longValue() > 0L && gect.getValoreMassimo().longValue() < gect.getValoreMinimo().longValue()) {
                this.errori.add("Il valore massimo di un codice-trasporto associato alla gestione errore (" + tipo + "), dev'essere un numero intero maggiore del valore associate al valore minimo (Attualemente max:" + gect.getValoreMassimo().longValue() + " min:" + gect.getValoreMinimo().longValue() + ")");
            }
            if ((comportamento = gect.getComportamento()) == null) {
                this.errori.add("Non e' stato definito il comportamento di adottato per la gestione errore (" + tipo + ") per un codice-trasporto");
            } else if (!comportamento.equals(CostantiConfigurazione.GESTIONE_ERRORE_ACCETTA_MSG) && !comportamento.equals(CostantiConfigurazione.GESTIONE_ERRORE_RISPEDISCI_MSG)) {
                this.errori.add("Il comportamento associato alla gestione errore (" + tipo + "-CodiceTrasporto) deve assumere uno dei seguenti valori: " + CostantiConfigurazione.GESTIONE_ERRORE_ACCETTA_MSG + " o " + CostantiConfigurazione.GESTIONE_ERRORE_RISPEDISCI_MSG);
            }
            if (gect.getCadenzaRispedizione() == null) continue;
            try {
                Long.parseLong(gect.getCadenzaRispedizione());
                continue;
            }
            catch (Exception e) {
                this.errori.add("Il valore della cadenza di rispedizione associato alla gestione errore (" + tipo + ") per un codice-trasporto, dev'essere un numero intero");
            }
        }
        for (j = 0; j < ge.sizeSoapFaultList(); ++j) {
            GestioneErroreComportamento comportamento;
            GestioneErroreSoapFault gesf = ge.getSoapFault(j);
            Object identificativo = "";
            identificativo = gesf.getFaultActor() == null ? "NULL-" : gesf.getFaultActor() + "-";
            identificativo = gesf.getFaultCode() == null ? (String)identificativo + "NULL-" : (String)identificativo + gesf.getFaultCode() + "-";
            identificativo = gesf.getFaultString() == null ? (String)identificativo + "NULL" : (String)identificativo + gesf.getFaultString();
            int numSF = 0;
            for (int k = 0; k < ge.sizeSoapFaultList(); ++k) {
                GestioneErroreSoapFault tmpGesf = ge.getSoapFault(k);
                Object tmpId = "";
                tmpId = tmpGesf.getFaultActor() == null ? "NULL-" : tmpGesf.getFaultActor() + "-";
                tmpId = tmpGesf.getFaultCode() == null ? (String)tmpId + "NULL-" : (String)tmpId + tmpGesf.getFaultCode() + "-";
                tmpId = tmpGesf.getFaultString() == null ? (String)tmpId + "NULL" : (String)tmpId + tmpGesf.getFaultString();
                if (!((String)identificativo).equals(tmpId)) continue;
                ++numSF;
            }
            if (numSF > 1) {
                this.errori.add("Non pu\u00f2 esistere pi\u00f9 di un elemento soap-fault con identificativo " + (String)identificativo + " associato alla gestione errore (" + tipo + ")");
            }
            if ((comportamento = gesf.getComportamento()) == null) {
                this.errori.add("Non e' stato definito il comportamento di adottato per la gestione errore (" + tipo + ") per un soap-fault");
            } else if (!comportamento.equals(CostantiConfigurazione.GESTIONE_ERRORE_ACCETTA_MSG) && !comportamento.equals(CostantiConfigurazione.GESTIONE_ERRORE_RISPEDISCI_MSG)) {
                this.errori.add("Il comportamento associato alla gestione errore (" + tipo + "-SoapFault) deve assumere uno dei seguenti valori: " + CostantiConfigurazione.GESTIONE_ERRORE_ACCETTA_MSG + " o " + CostantiConfigurazione.GESTIONE_ERRORE_RISPEDISCI_MSG);
            }
            if (gesf.getCadenzaRispedizione() == null) continue;
            try {
                Long.parseLong(gesf.getCadenzaRispedizione());
                continue;
            }
            catch (Exception e) {
                this.errori.add("Il valore della cadenza di rispedizione associato alla gestione errore (" + tipo + ") per un soap-fault, dev'essere un numero intero");
            }
        }
        GestioneErroreComportamento comportamento = ge.getComportamento();
        if (comportamento == null) {
            this.errori.add("Non e' stato definito il comportamento di default adottato per la gestione errore (" + tipo + ")");
        } else if (!comportamento.equals(CostantiConfigurazione.GESTIONE_ERRORE_ACCETTA_MSG) && !comportamento.equals(CostantiConfigurazione.GESTIONE_ERRORE_RISPEDISCI_MSG)) {
            this.errori.add("Il comportamento di default associato alla gestione errore (" + tipo + ") deve assumere uno dei seguenti valori: " + CostantiConfigurazione.GESTIONE_ERRORE_ACCETTA_MSG + " o " + CostantiConfigurazione.GESTIONE_ERRORE_RISPEDISCI_MSG);
        }
        if (ge.getCadenzaRispedizione() != null) {
            try {
                Long.parseLong(ge.getCadenzaRispedizione());
            }
            catch (Exception e) {
                this.errori.add("Il valore della cadenza di rispedizione di default associato alla gestione errore (" + tipo + "), dev'essere un numero intero");
            }
        }
    }

    private boolean existsServizioApplicativo(String nome, Soggetto soggetto) {
        return this.getServizioApplicativo(nome, soggetto) != null;
    }

    private ServizioApplicativo getServizioApplicativo(String nome, Soggetto soggetto) {
        for (int j = 0; j < soggetto.sizeServizioApplicativoList(); ++j) {
            ServizioApplicativo sa = soggetto.getServizioApplicativo(j);
            if (!nome.equals(sa.getNome())) continue;
            return sa;
        }
        return null;
    }
}

