/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.driver;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.commons.CoreException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.commons.DBUtils;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.Property;
import it.link.pdd.tools.migrazione_govway.utils.sql.ISQLQueryObject;
import it.link.pdd.tools.migrazione_govway.utils.sql.SQLObjectFactory;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;

public class ConnettorePropertiesUtilities {
    public static ArrayList<Property> fromPropertiesToCollectionConfig(Properties props) {
        ArrayList<Property> lista = new ArrayList<Property>();
        Property tmp = null;
        Enumeration<Object> en = props.keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            String value = (String)props.get(key);
            tmp = new Property();
            tmp.setNome(key);
            tmp.setValore(value);
            lista.add(tmp);
        }
        return lista;
    }

    public static List<Property> getPropertiesConnettore(String nome_connettore, Connection con, String tipoDB) throws CoreException {
        Statement stmt = null;
        ResultSet risultato = null;
        String path = null;
        Properties prop = new Properties();
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
            sqlQueryObject.addFromTable("connettori_properties");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("nome_connettore = ?");
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setString(1, nome_connettore);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                path = risultato.getString("path");
            }
            if (path == null || path.equals("")) {
                throw new CoreException("getPropertiesConnettore : nessun path impostato per il connettore : " + nome_connettore);
            }
            InputStream ins = DBUtils.class.getResourceAsStream(path);
            prop.load(ins);
            ArrayList<Property> collection = ConnettorePropertiesUtilities.fromPropertiesToCollectionConfig(prop);
            ArrayList<Property> list = new ArrayList<Property>();
            list.addAll(collection);
            ArrayList<Property> arrayList = list;
            return arrayList;
        }
        catch (FileNotFoundException fe) {
            throw new CoreException("Impossibile aprire il file :" + path + " Errore: " + fe.getMessage(), fe);
        }
        catch (Exception e) {
            throw new CoreException("Errore durante la lettura delle properties dal file [" + path + "]: " + e.getMessage(), e);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

