/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.constants;

import it.link.pdd.tools.migrazione_govway.generic_project.beans.IEnumeration;
import it.link.pdd.tools.migrazione_govway.generic_project.exception.NotFoundException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public enum TipoAutorizzazione implements IEnumeration,
Serializable,
Cloneable
{
    DISABILITATO("none", "disabilitato"),
    AUTHENTICATED("authenticated", "authenticated"),
    ROLES("roles", "roles"),
    INTERNAL_ROLES("internalRoles", "internalRoles"),
    EXTERNAL_ROLES("externalRoles", "externalRoles"),
    AUTHENTICATED_ROLES("authenticatedOrRoles", "authenticatedOrRoles"),
    AUTHENTICATED_INTERNAL_ROLES("authenticatedOrInternalRoles", "authenticatedOrInternalRoles"),
    AUTHENTICATED_EXTERNAL_ROLES("authenticatedOrExternalRoles", "authenticatedOrExternalRoles"),
    XACML_POLICY("xacmlPolicy", "xacmlPolicy"),
    INTERNAL_XACML_POLICY("internalXacmlPolicy", "internalXacmlPolicy"),
    EXTERNAL_XACML_POLICY("externalXacmlPolicy", "externalXacmlPolicy");

    private String value;
    private String label;

    public String getLabel() {
        return this.label;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    private TipoAutorizzazione(String value, String label) {
        this.value = value;
        this.label = label;
    }

    public String toString() {
        return this.value;
    }

    public boolean equals(TipoAutorizzazione object) {
        if (object == null) {
            return false;
        }
        if (object.getValue() == null) {
            return false;
        }
        return object.getValue().equals(this.getValue());
    }

    public boolean equals(String object) {
        if (object == null) {
            return false;
        }
        return object.equals(this.getValue());
    }

    public boolean equals(Object object, List<String> fieldsNotCheck) {
        if (!(object instanceof TipoAutorizzazione)) {
            throw new RuntimeException("Wrong type: " + object.getClass().getName());
        }
        return this.equals((TipoAutorizzazione)object);
    }

    public String toString(boolean reportHTML) {
        return this.toString();
    }

    public String toString(boolean reportHTML, List<String> fieldsNotIncluded) {
        return this.toString();
    }

    public String diff(Object object, StringBuffer bf, boolean reportHTML) {
        return bf.toString();
    }

    public String diff(Object object, StringBuffer bf, boolean reportHTML, List<String> fieldsNotIncluded) {
        return bf.toString();
    }

    public static boolean isInternalRolesRequired(String autorizzazione) {
        return TipoAutorizzazione.isInternalRolesRequired(TipoAutorizzazione.toEnumConstant(autorizzazione));
    }

    public static boolean isInternalRolesRequired(TipoAutorizzazione autorizzazione) {
        return INTERNAL_ROLES.equals(autorizzazione) || AUTHENTICATED_INTERNAL_ROLES.equals(autorizzazione);
    }

    public static boolean isExternalRolesRequired(String autorizzazione) {
        return TipoAutorizzazione.isExternalRolesRequired(TipoAutorizzazione.toEnumConstant(autorizzazione));
    }

    public static boolean isExternalRolesRequired(TipoAutorizzazione autorizzazione) {
        return EXTERNAL_ROLES.equals(autorizzazione) || AUTHENTICATED_EXTERNAL_ROLES.equals(autorizzazione);
    }

    public static boolean isRolesRequired(String autorizzazione) {
        return TipoAutorizzazione.isRolesRequired(TipoAutorizzazione.toEnumConstant(autorizzazione));
    }

    public static boolean isRolesRequired(TipoAutorizzazione autorizzazione) {
        return ROLES.equals(autorizzazione) || AUTHENTICATED_ROLES.equals(autorizzazione) || INTERNAL_ROLES.equals(autorizzazione) || AUTHENTICATED_INTERNAL_ROLES.equals(autorizzazione) || EXTERNAL_ROLES.equals(autorizzazione) || AUTHENTICATED_EXTERNAL_ROLES.equals(autorizzazione);
    }

    public static boolean isAuthenticationRequired(String autorizzazione) {
        return TipoAutorizzazione.isAuthenticationRequired(TipoAutorizzazione.toEnumConstant(autorizzazione));
    }

    public static boolean isAuthenticationRequired(TipoAutorizzazione autorizzazione) {
        return AUTHENTICATED.equals(autorizzazione) || AUTHENTICATED_EXTERNAL_ROLES.equals(autorizzazione) || AUTHENTICATED_INTERNAL_ROLES.equals(autorizzazione) || AUTHENTICATED_ROLES.equals(autorizzazione);
    }

    public static boolean isXacmlPolicyRequired(String autorizzazione) {
        return TipoAutorizzazione.isXacmlPolicyRequired(TipoAutorizzazione.toEnumConstant(autorizzazione));
    }

    public static boolean isXacmlPolicyRequired(TipoAutorizzazione autorizzazione) {
        return XACML_POLICY.equals(autorizzazione) || EXTERNAL_XACML_POLICY.equals(autorizzazione) || INTERNAL_XACML_POLICY.equals(autorizzazione);
    }

    public static List<String> getAllValues() {
        ArrayList<String> l = new ArrayList<String>();
        for (TipoAutorizzazione tmp : TipoAutorizzazione.values()) {
            l.add(tmp.getValue());
        }
        return l;
    }

    public static List<String> getValues(boolean authenticated, boolean optionalAuthenticated) {
        ArrayList<String> l = new ArrayList<String>();
        for (TipoAutorizzazione tmp : TipoAutorizzazione.values()) {
            if (TipoAutorizzazione.isAuthenticationRequired(tmp) && !authenticated || (TipoAutorizzazione.isAuthenticationRequired(tmp) && TipoAutorizzazione.isRolesRequired(tmp) ? !optionalAuthenticated : (TipoAutorizzazione.isInternalRolesRequired(tmp) || INTERNAL_XACML_POLICY.equals(tmp)) && optionalAuthenticated)) continue;
            l.add(tmp.getValue());
        }
        return l;
    }

    public static List<String> getLabels() {
        ArrayList<String> l = new ArrayList<String>();
        for (TipoAutorizzazione tmp : TipoAutorizzazione.values()) {
            l.add(tmp.getLabel());
        }
        return l;
    }

    public static String[] toArray() {
        String[] res = new String[TipoAutorizzazione.values().length];
        int i = 0;
        for (TipoAutorizzazione tmp : TipoAutorizzazione.values()) {
            res[i] = tmp.getValue();
            ++i;
        }
        return res;
    }

    public static String[] toStringArray() {
        String[] res = new String[TipoAutorizzazione.values().length];
        int i = 0;
        for (TipoAutorizzazione tmp : TipoAutorizzazione.values()) {
            res[i] = tmp.toString();
            ++i;
        }
        return res;
    }

    public static String[] toEnumNameArray() {
        String[] res = new String[TipoAutorizzazione.values().length];
        int i = 0;
        for (TipoAutorizzazione tmp : TipoAutorizzazione.values()) {
            res[i] = tmp.name();
            ++i;
        }
        return res;
    }

    public static boolean contains(String value) {
        return TipoAutorizzazione.toEnumConstant(value) != null;
    }

    public static TipoAutorizzazione toEnumConstant(String value) {
        try {
            return TipoAutorizzazione.toEnumConstant(value, false);
        }
        catch (NotFoundException notFound) {
            return null;
        }
    }

    public static TipoAutorizzazione toEnumConstant(String value, boolean throwNotFoundException) throws NotFoundException {
        TipoAutorizzazione res = null;
        for (TipoAutorizzazione tmp : TipoAutorizzazione.values()) {
            if (!tmp.getValue().equals(value)) continue;
            res = tmp;
            break;
        }
        if (res == null && throwNotFoundException) {
            throw new NotFoundException("Enum with value [" + value + "] not found");
        }
        return res;
    }

    public static IEnumeration toEnumConstantFromString(String value) {
        try {
            return TipoAutorizzazione.toEnumConstantFromString(value, false);
        }
        catch (NotFoundException notFound) {
            return null;
        }
    }

    public static IEnumeration toEnumConstantFromString(String value, boolean throwNotFoundException) throws NotFoundException {
        TipoAutorizzazione res = null;
        for (TipoAutorizzazione tmp : TipoAutorizzazione.values()) {
            if (!tmp.toString().equals(value)) continue;
            res = tmp;
            break;
        }
        if (res == null && throwNotFoundException) {
            throw new NotFoundException("Enum with value [" + value + "] not found");
        }
        return res;
    }
}

