/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.commons;

import it.link.pdd.tools.migrazione_govway.generic_project.dao.jdbc.utils.JDBCObject;
import it.link.pdd.tools.migrazione_govway.generic_project.dao.jdbc.utils.JDBCParameterUtilities;
import it.link.pdd.tools.migrazione_govway.generic_project.dao.jdbc.utils.JDBCSqlLogger;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.commons.AccordiUtils;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.commons.CoreException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDAccordo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDAccordoCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDRuolo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDServizio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDSoggetto;
import it.link.pdd.tools.migrazione_govway.utils.TipiDatabase;
import it.link.pdd.tools.migrazione_govway.utils.sql.ISQLQueryObject;
import it.link.pdd.tools.migrazione_govway.utils.sql.SQLObjectFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public class DBUtils {
    public static String estraiTipoDatabaseFromLocation(String location) throws CoreException {
        if (location == null) {
            throw new CoreException("Location del db is null");
        }
        if (location.indexOf("@") == -1) {
            throw new CoreException("Tipo di database non indicato nella location, sintassi corretta e' tipoDatabase@datasource");
        }
        String tipoDatabase = location.split("@")[0].trim();
        if (!TipiDatabase.isAMember(tipoDatabase)) {
            throw new CoreException("Tipo di database indicato nella location [" + tipoDatabase + "] non supportato");
        }
        return tipoDatabase;
    }

    public static List<List<Object>> readCustom(Logger log, Connection connection, String tipoDB, ISQLQueryObject sqlQueryObject, List<Class<?>> returnTypes, List<JDBCObject> paramTypes) throws CoreException {
        Statement stm = null;
        ResultSet rs = null;
        try {
            if (returnTypes == null || returnTypes.size() <= 0) {
                throw new CoreException("Non sono stati definiti tipi da ritornare");
            }
            ArrayList<List<Object>> lista = new ArrayList<List<Object>>();
            String sql = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sql);
            JDBCParameterUtilities jdbcParameterUtilities = new JDBCParameterUtilities(TipiDatabase.toEnumConstant(tipoDB));
            JDBCObject[] paramsArray = null;
            if (paramTypes != null && paramTypes.size() > 0) {
                paramsArray = paramTypes.toArray(new JDBCObject[1]);
            }
            jdbcParameterUtilities.setParameters((PreparedStatement)stm, paramsArray);
            JDBCSqlLogger sqlLogger = new JDBCSqlLogger(log);
            sqlLogger.infoSql(sql, paramsArray);
            rs = stm.executeQuery();
            while (rs.next()) {
                ArrayList<Object> listaInterna = new ArrayList<Object>();
                for (int i = 0; i < returnTypes.size(); ++i) {
                    listaInterna.add(jdbcParameterUtilities.readParameter(rs, i + 1, returnTypes.get(i)));
                }
                lista.add(listaInterna);
            }
            ArrayList<List<Object>> arrayList = lista;
            return arrayList;
        }
        catch (SQLException e) {
            throw new CoreException(e);
        }
        catch (Exception e) {
            throw new CoreException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static long getIdSoggetto(String nomeSoggetto, String tipoSoggetto, Connection con, String tipoDB) throws CoreException {
        return DBUtils.getIdSoggetto(nomeSoggetto, tipoSoggetto, con, tipoDB, "soggetti");
    }

    public static long getIdSoggetto(String nomeSoggetto, String tipoSoggetto, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        Statement stm = null;
        ResultSet rs = null;
        long idSoggetto = -1L;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
            sqlQueryObject.addFromTable(tabellaSoggetti);
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("tipo_soggetto = ?");
            sqlQueryObject.addWhereCondition("nome_soggetto = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String query = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(query);
            stm.setString(1, tipoSoggetto);
            stm.setString(2, nomeSoggetto);
            rs = stm.executeQuery();
            if (rs.next()) {
                idSoggetto = rs.getLong("id");
            }
            long l = idSoggetto;
            return l;
        }
        catch (SQLException e) {
            throw new CoreException(e);
        }
        catch (Exception e) {
            throw new CoreException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static long getIdConnettore(String nomeConnettore, Connection con, String tipoDB) throws CoreException {
        Statement stm = null;
        ResultSet rs = null;
        long idConnettore = -1L;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
            sqlQueryObject.addFromTable("connettori");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("nome_connettore = ?");
            String query = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(query);
            stm.setString(1, nomeConnettore);
            rs = stm.executeQuery();
            if (rs.next()) {
                idConnettore = rs.getLong("id");
            }
            long l = idConnettore;
            return l;
        }
        catch (SQLException e) {
            throw new CoreException(e);
        }
        catch (Exception e) {
            throw new CoreException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static long getIdServizio(String nomeServizio, String tipoServizio, String nomeProprietario, String tipoProprietario, Connection con, String tipoDB) throws CoreException {
        return DBUtils.getIdServizio(nomeServizio, tipoServizio, nomeProprietario, tipoProprietario, con, false, tipoDB, "soggetti");
    }

    public static long getIdServizio(String nomeServizio, String tipoServizio, String nomeProprietario, String tipoProprietario, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        return DBUtils.getIdServizio(nomeServizio, tipoServizio, nomeProprietario, tipoProprietario, con, false, tipoDB, tabellaSoggetti);
    }

    public static long getIdServizio(String nomeServizio, String tipoServizio, String nomeProprietario, String tipoProprietario, Connection con, boolean testServizioNonCorrelato, String tipoDB) throws CoreException {
        return DBUtils.getIdServizio(nomeServizio, tipoServizio, nomeProprietario, tipoProprietario, con, testServizioNonCorrelato, tipoDB, "soggetti");
    }

    public static long getIdServizio(String nomeServizio, String tipoServizio, String nomeProprietario, String tipoProprietario, Connection con, boolean testServizioNonCorrelato, String tipoDB, String tabellaSoggetti) throws CoreException {
        Statement stm = null;
        ResultSet rs = null;
        long idServizio = 0L;
        try {
            long idSoggetto = DBUtils.getIdSoggetto(nomeProprietario, tipoProprietario, con, tipoDB, tabellaSoggetti);
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("tipo_servizio = ?");
            sqlQueryObject.addWhereCondition("nome_servizio = ?");
            sqlQueryObject.addWhereCondition("id_soggetto = ?");
            sqlQueryObject.setANDLogicOperator(true);
            Object query = sqlQueryObject.createSQLQuery();
            if (testServizioNonCorrelato) {
                query = (String)query + " AND servizio_correlato=?";
            }
            stm = con.prepareStatement((String)query);
            stm.setString(1, tipoServizio);
            stm.setString(2, nomeServizio);
            stm.setLong(3, idSoggetto);
            if (testServizioNonCorrelato) {
                stm.setString(4, "disabilitato");
            }
            if ((rs = stm.executeQuery()).next()) {
                idServizio = rs.getLong("id");
            }
            long l = idServizio;
            return l;
        }
        catch (SQLException e) {
            throw new CoreException(e);
        }
        catch (Exception e) {
            throw new CoreException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static long getIdPortaApplicativa(String nomePorta, String tipoProprietario, String nomeProprietario, Connection con, String tipoDB) throws CoreException {
        return DBUtils.getIdPortaApplicativa(nomePorta, tipoProprietario, nomeProprietario, con, tipoDB, "soggetti");
    }

    public static long getIdPortaApplicativa(String nomePorta, String tipoProprietario, String nomeProprietario, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        Statement stm = null;
        ResultSet rs = null;
        long idPortaApplicativa = -1L;
        try {
            long idSoggetto = DBUtils.getIdSoggetto(nomeProprietario, tipoProprietario, con, tipoDB, tabellaSoggetti);
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
            sqlQueryObject.addFromTable("porte_applicative");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addWhereCondition("id_soggetto = ?");
            sqlQueryObject.addWhereCondition("nome_porta = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idSoggetto);
            stm.setString(2, nomePorta);
            rs = stm.executeQuery();
            if (rs.next()) {
                idPortaApplicativa = rs.getLong("id");
            }
            long l = idPortaApplicativa;
            return l;
        }
        catch (SQLException e) {
            throw new CoreException(e);
        }
        catch (Exception e) {
            throw new CoreException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static long getIdPortaDelegata(String nomePorta, String tipoProprietario, String nomeProprietario, Connection con, String tipoDB) throws CoreException {
        return DBUtils.getIdPortaDelegata(nomePorta, tipoProprietario, nomeProprietario, con, tipoDB, "soggetti");
    }

    public static long getIdPortaDelegata(String nomePorta, String tipoProprietario, String nomeProprietario, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        Statement stm = null;
        ResultSet rs = null;
        long idPortaDelegata = -1L;
        try {
            long idSoggetto = DBUtils.getIdSoggetto(nomeProprietario, tipoProprietario, con, tipoDB, tabellaSoggetti);
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
            sqlQueryObject.addFromTable("porte_delegate");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addWhereCondition("id_soggetto = ?");
            sqlQueryObject.addWhereCondition("nome_porta = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idSoggetto);
            stm.setString(2, nomePorta);
            rs = stm.executeQuery();
            if (rs.next()) {
                idPortaDelegata = rs.getLong("id");
            }
            long l = idPortaDelegata;
            return l;
        }
        catch (SQLException e) {
            throw new CoreException(e);
        }
        catch (Exception e) {
            throw new CoreException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static long getIdServizioApplicativo(String nomeServizioApplicativo, String tipoProprietario, String nomeProprietario, Connection con, String tipoDB) throws CoreException {
        return DBUtils.getIdServizioApplicativo(nomeServizioApplicativo, tipoProprietario, nomeProprietario, con, tipoDB, "soggetti");
    }

    public static long getIdServizioApplicativo(String nomeServizioApplicativo, String tipoProprietario, String nomeProprietario, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        Statement stm = null;
        ResultSet rs = null;
        long idServizioApplicativo = -1L;
        try {
            long idSoggetto = DBUtils.getIdSoggetto(nomeProprietario, tipoProprietario, con, tipoDB, tabellaSoggetti);
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
            sqlQueryObject.addFromTable("servizi_applicativi");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addWhereCondition("id_soggetto = ?");
            sqlQueryObject.addWhereCondition("nome = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idSoggetto);
            stm.setString(2, nomeServizioApplicativo);
            rs = stm.executeQuery();
            if (rs.next()) {
                idServizioApplicativo = rs.getLong("id");
            }
            long l = idServizioApplicativo;
            return l;
        }
        catch (SQLException e) {
            throw new CoreException(e);
        }
        catch (Exception e) {
            throw new CoreException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static long getIdPortaDominio(String nome, Connection con, String tipoDB) throws CoreException {
        Statement stm = null;
        ResultSet rs = null;
        long idPdD = -1L;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
            sqlQueryObject.addFromTable("pdd");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("nome = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String query = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(query);
            stm.setString(1, nome);
            rs = stm.executeQuery();
            if (rs.next()) {
                idPdD = rs.getLong("id");
            }
            long l = idPdD;
            return l;
        }
        catch (SQLException e) {
            throw new CoreException(e);
        }
        catch (Exception e) {
            throw new CoreException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static long getIdRuolo(IDRuolo idRuolo, Connection con, String tipoDB) throws CoreException {
        Statement stm = null;
        ResultSet rs = null;
        long idPdD = -1L;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
            sqlQueryObject.addFromTable("ruoli");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("nome = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String query = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(query);
            stm.setString(1, idRuolo.getNome());
            rs = stm.executeQuery();
            if (rs.next()) {
                idPdD = rs.getLong("id");
            }
            long l = idPdD;
            return l;
        }
        catch (SQLException e) {
            throw new CoreException(e);
        }
        catch (Exception e) {
            throw new CoreException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static long getIdAccordo(String nomeServizio, String tipoServizio, String nomeProprietario, String tipoProprietario, Connection con, String tipoDB) throws CoreException {
        return DBUtils.getIdAccordo(nomeServizio, tipoServizio, nomeProprietario, tipoProprietario, con, tipoDB, "soggetti");
    }

    public static long getIdAccordo(String nomeServizio, String tipoServizio, String nomeProprietario, String tipoProprietario, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        Statement stm = null;
        ResultSet rs = null;
        long idAccordo = -1L;
        try {
            long idServizio = DBUtils.getIdServizio(nomeServizio, tipoServizio, nomeProprietario, tipoProprietario, con, tipoDB, tabellaSoggetti);
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id = ?");
            String query = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(query);
            stm.setLong(1, idServizio);
            rs = stm.executeQuery();
            if (rs.next()) {
                idAccordo = rs.getLong("id_accordo");
            }
            long l = idAccordo;
            return l;
        }
        catch (SQLException e) {
            throw new CoreException(e);
        }
        catch (Exception e) {
            throw new CoreException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static long getIdPortType(Long idAccordo, String nomePortType, Connection con) throws CoreException {
        PreparedStatement selectStmt = null;
        ResultSet selectRS = null;
        long id = -1L;
        try {
            String selectQuery = "SELECT id FROM port_type WHERE id_accordo = ? AND nome=?";
            selectStmt = con.prepareStatement(selectQuery);
            selectStmt.setLong(1, idAccordo);
            selectStmt.setString(2, nomePortType);
            selectRS = selectStmt.executeQuery();
            if (selectRS.next()) {
                id = selectRS.getLong("id");
            }
            selectRS.close();
            selectStmt.close();
            long l = id;
            return l;
        }
        catch (Exception e) {
            throw new CoreException(e);
        }
        finally {
            try {
                if (selectRS != null) {
                    selectRS.close();
                }
                if (selectStmt != null) {
                    selectStmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static long getIdAccordoServizioParteComune(IDAccordo idAccordo, Connection con, String tipoDB) throws CoreException {
        Statement stm = null;
        ResultSet rs = null;
        long idAccordoLong = -1L;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
            sqlQueryObject.addFromTable("accordi");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("nome = ?");
            sqlQueryObject.addWhereCondition("id_referente = ?");
            if (AccordiUtils.versioneNonDefinita(idAccordo.getVersione())) {
                sqlQueryObject.addWhereCondition(false, "versione = ?", "versione is null");
            } else {
                sqlQueryObject.addWhereCondition("versione = ?");
            }
            sqlQueryObject.setANDLogicOperator(true);
            String query = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(query);
            stm.setString(1, idAccordo.getNome());
            long idSoggettoReferente = 0L;
            if (idAccordo.getSoggettoReferente() != null && (idSoggettoReferente = DBUtils.getIdSoggetto(idAccordo.getSoggettoReferente().getNome(), idAccordo.getSoggettoReferente().getTipo(), con, tipoDB)) <= 0L) {
                throw new CoreException("[getIdAccordoServizioParteComune] Soggetto Referente [" + idAccordo.getSoggettoReferente().toString() + "] non esiste");
            }
            stm.setLong(2, idSoggettoReferente);
            String vers = "";
            if (idAccordo.getVersione() != null) {
                vers = idAccordo.getVersione();
            }
            stm.setString(3, vers);
            rs = stm.executeQuery();
            if (rs.next()) {
                idAccordoLong = rs.getLong("id");
            }
            long l = idAccordoLong;
            return l;
        }
        catch (SQLException e) {
            throw new CoreException(e);
        }
        catch (Exception e) {
            throw new CoreException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static long getIdAccordoCooperazione(IDAccordoCooperazione idAccordo, Connection con, String tipoDB) throws CoreException {
        Statement stm = null;
        ResultSet rs = null;
        long idAccordoLong = -1L;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
            sqlQueryObject.addFromTable("accordi_cooperazione");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("nome = ?");
            if (AccordiUtils.versioneNonDefinita(idAccordo.getVersione())) {
                sqlQueryObject.addWhereCondition(false, "versione = ?", "versione is null");
            } else {
                sqlQueryObject.addWhereCondition("versione = ?");
            }
            sqlQueryObject.setANDLogicOperator(true);
            String query = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(query);
            stm.setString(1, idAccordo.getNome());
            String vers = "";
            if (idAccordo.getVersione() != null) {
                vers = idAccordo.getVersione();
            }
            stm.setString(2, vers);
            rs = stm.executeQuery();
            if (rs.next()) {
                idAccordoLong = rs.getLong("id");
            }
            long l = idAccordoLong;
            return l;
        }
        catch (SQLException e) {
            throw new CoreException(e);
        }
        catch (Exception e) {
            throw new CoreException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static long getIdAccordoServizioParteSpecifica(IDAccordo idAccordo, Connection con, String tipoDB) throws CoreException {
        Statement stm = null;
        ResultSet rs = null;
        long idAccordoLong = -1L;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("aps_nome = ?");
            sqlQueryObject.addWhereCondition("id_soggetto = ?");
            sqlQueryObject.addWhereCondition("aps_versione = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String query = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(query);
            stm.setString(1, idAccordo.getNome());
            long idSoggettoReferente = DBUtils.getIdSoggetto(idAccordo.getSoggettoReferente().getNome(), idAccordo.getSoggettoReferente().getTipo(), con, tipoDB);
            if (idSoggettoReferente <= 0L) {
                throw new CoreException("[getIdAccordoServizio] Soggetto Referente [" + idAccordo.getSoggettoReferente().toString() + "] non esiste");
            }
            stm.setLong(2, idSoggettoReferente);
            stm.setString(3, idAccordo.getVersione());
            rs = stm.executeQuery();
            if (rs.next()) {
                idAccordoLong = rs.getLong("id");
            }
            long l = idAccordoLong;
            return l;
        }
        catch (SQLException e) {
            throw new CoreException(e);
        }
        catch (Exception e) {
            throw new CoreException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static long getIdAccordoServizioParteSpecifica(IDServizio idServizio, Connection con, String tipoDB) throws CoreException {
        Statement stm = null;
        ResultSet rs = null;
        long idAccordoLong = -1L;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addWhereCondition("servizi.id_soggetto = soggetti.id");
            sqlQueryObject.addWhereCondition("tipo_soggetto = ?");
            sqlQueryObject.addWhereCondition("nome_soggetto = ?");
            sqlQueryObject.addWhereCondition("tipo_servizio = ?");
            sqlQueryObject.addWhereCondition("nome_servizio = ?");
            String query = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(query);
            stm.setString(1, idServizio.getSoggettoErogatore().getTipo());
            stm.setString(2, idServizio.getSoggettoErogatore().getNome());
            stm.setString(3, idServizio.getTipoServizio());
            stm.setString(4, idServizio.getServizio());
            rs = stm.executeQuery();
            if (rs.next()) {
                idAccordoLong = rs.getLong("id");
            }
            long l = idAccordoLong;
            return l;
        }
        catch (SQLException e) {
            throw new CoreException(e);
        }
        catch (Exception e) {
            throw new CoreException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static long getIdFruizioneServizio(IDAccordo idServizio, IDSoggetto idFruitore, Connection con, String tipoDB) throws CoreException {
        return DBUtils.getIdFruizioneServizio(idServizio, idFruitore, con, tipoDB, "soggetti");
    }

    public static long getIdFruizioneServizio(IDAccordo idServizio, IDSoggetto idFruitore, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        return DBUtils._getIdFruizioneServizio(DBUtils.getIdAccordoServizioParteSpecifica(idServizio, con, tipoDB), idFruitore, con, tipoDB, tabellaSoggetti);
    }

    public static long getIdFruizioneServizio(IDServizio idServizio, IDSoggetto idFruitore, Connection con, String tipoDB) throws CoreException {
        return DBUtils.getIdFruizioneServizio(idServizio, idFruitore, con, tipoDB, "soggetti");
    }

    public static long getIdFruizioneServizio(IDServizio idServizio, IDSoggetto idFruitore, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        return DBUtils._getIdFruizioneServizio(DBUtils.getIdAccordoServizioParteSpecifica(idServizio, con, tipoDB), idFruitore, con, tipoDB, tabellaSoggetti);
    }

    private static long _getIdFruizioneServizio(long idServizio, IDSoggetto idFruitore, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        Statement stm = null;
        ResultSet rs = null;
        long idFruizione = -1L;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
            sqlQueryObject.addFromTable("servizi_fruitori");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addWhereCondition("servizi_fruitori.id_servizio = ?");
            sqlQueryObject.addWhereCondition("servizi_fruitori.id_soggetto = ?");
            String query = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(query);
            stm.setLong(1, idServizio);
            stm.setLong(2, DBUtils.getIdSoggetto(idFruitore.getNome(), idFruitore.getTipo(), con, tipoDB, tabellaSoggetti));
            rs = stm.executeQuery();
            if (rs.next()) {
                idFruizione = rs.getLong("id");
            }
            long l = idFruizione;
            return l;
        }
        catch (SQLException e) {
            throw new CoreException(e);
        }
        catch (Exception e) {
            throw new CoreException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static long getIdDocumento(String nome, String tipo, String ruolo, long idProprietario, Connection con, String tipoDB, String tipoProprietario) throws CoreException {
        Statement stm = null;
        ResultSet rs = null;
        long idDoc = -1L;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
            sqlQueryObject.addFromTable("documenti");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addWhereCondition("id_proprietario = ?");
            sqlQueryObject.addWhereCondition("nome = ?");
            sqlQueryObject.addWhereCondition("tipo = ?");
            sqlQueryObject.addWhereCondition("ruolo = ?");
            sqlQueryObject.addWhereCondition("tipo_proprietario = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idProprietario);
            stm.setString(2, nome);
            stm.setString(3, tipo);
            stm.setString(4, ruolo);
            stm.setString(5, tipoProprietario);
            rs = stm.executeQuery();
            if (rs.next()) {
                idDoc = rs.getLong("id");
            }
            rs.close();
            stm.close();
            long l = idDoc;
            return l;
        }
        catch (SQLException e) {
            throw new CoreException(e);
        }
        catch (Exception e) {
            throw new CoreException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static String formatSQLString(String sql, Object ... params) {
        String res = sql;
        for (int i = 0; i < params.length; ++i) {
            res = res.replaceFirst("\\?", "{" + i + "}");
        }
        return MessageFormat.format(res, params);
    }
}

