/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.commons;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.commons.CoreException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.commons.DBUtils;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDAccordo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDPortaApplicativaByNome;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDPortaDelegata;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDServizio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDSoggetto;
import it.link.pdd.tools.migrazione_govway.utils.sql.ISQLQueryObject;
import it.link.pdd.tools.migrazione_govway.utils.sql.SQLObjectFactory;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;

public class DBMappingUtils {
    public static int countMappingErogazione(Connection con, String tipoDB) throws CoreException {
        return DBMappingUtils._countMappingErogazione(con, tipoDB, "soggetti");
    }

    public static int countMappingErogazione(Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        return DBMappingUtils._countMappingErogazione(con, tipoDB, tabellaSoggetti);
    }

    private static int _countMappingErogazione(Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
            sqlQueryObject.addFromTable("mapping_erogazione_pa");
            sqlQueryObject.addSelectCountField("id", "mapping_count");
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            rs = stmt.executeQuery();
            if (rs.next()) {
                int n = rs.getInt("mapping_count");
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception e) {
            throw new CoreException("createMappingErogazione error", e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static void createMappingErogazione(IDAccordo idServizio, IDPortaApplicativaByNome idPortaApplicativaByNome, Connection con, String tipoDB) throws CoreException {
        DBMappingUtils.createMappingErogazione(idServizio, idPortaApplicativaByNome, con, tipoDB, "soggetti");
    }

    public static void createMappingErogazione(IDAccordo idServizio, IDPortaApplicativaByNome idPortaApplicativaByNome, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        long idServizioLong = DBUtils.getIdAccordoServizioParteSpecifica(idServizio, con, tipoDB);
        if (idServizioLong <= 0L) {
            throw new CoreException("Servizio [" + idServizio.toString() + "] non esistente");
        }
        DBMappingUtils._createMappingErogazione(idServizioLong, idPortaApplicativaByNome, con, tipoDB, tabellaSoggetti);
    }

    public static void createMappingErogazione(IDServizio idServizio, IDPortaApplicativaByNome idPortaApplicativaByNome, Connection con, String tipoDB) throws CoreException {
        DBMappingUtils.createMappingErogazione(idServizio, idPortaApplicativaByNome, con, tipoDB, "soggetti");
    }

    public static void createMappingErogazione(IDServizio idServizio, IDPortaApplicativaByNome idPortaApplicativaByNome, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        long idServizioLong = DBUtils.getIdAccordoServizioParteSpecifica(idServizio, con, tipoDB);
        if (idServizioLong <= 0L) {
            throw new CoreException("Servizio [" + idServizio.toString() + "] non esistente");
        }
        DBMappingUtils._createMappingErogazione(idServizioLong, idPortaApplicativaByNome, con, tipoDB, tabellaSoggetti);
    }

    private static void _createMappingErogazione(long idServizioLong, IDPortaApplicativaByNome idPortaApplicativaByNome, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        Statement stmt = null;
        try {
            if (idServizioLong <= 0L) {
                throw new Exception("IdServizio non fornito");
            }
            long idPA = DBUtils.getIdPortaApplicativa(idPortaApplicativaByNome.getNome(), idPortaApplicativaByNome.getSoggetto().getTipo(), idPortaApplicativaByNome.getSoggetto().getNome(), con, tipoDB, tabellaSoggetti);
            if (idPA <= 0L) {
                throw new Exception("PortaApplicativa [" + idPortaApplicativaByNome + "] non esistente");
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
            sqlQueryObject.addInsertTable("mapping_erogazione_pa");
            sqlQueryObject.addInsertField("id_erogazione", "?");
            sqlQueryObject.addInsertField("id_porta", "?");
            String queryString = sqlQueryObject.createSQLInsert();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idServizioLong);
            stmt.setLong(2, idPA);
            stmt.executeUpdate();
            stmt.close();
        }
        catch (Exception e) {
            throw new CoreException("createMappingErogazione error", e);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static void deleteMappingErogazione(IDAccordo idServizio, Connection con, String tipoDB) throws CoreException {
        DBMappingUtils.deleteMappingErogazione(idServizio, null, con, tipoDB, "soggetti");
    }

    public static void deleteMappingErogazione(IDAccordo idServizio, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        DBMappingUtils.deleteMappingErogazione(idServizio, null, con, tipoDB, tabellaSoggetti);
    }

    public static void deleteMappingErogazione(IDAccordo idServizio, IDPortaApplicativaByNome idPortaApplicativaByNome, Connection con, String tipoDB) throws CoreException {
        DBMappingUtils.deleteMappingErogazione(idServizio, idPortaApplicativaByNome, con, tipoDB, "soggetti");
    }

    public static void deleteMappingErogazione(IDAccordo idServizio, IDPortaApplicativaByNome idPortaApplicativaByNome, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        long idServizioLong = DBUtils.getIdAccordoServizioParteSpecifica(idServizio, con, tipoDB);
        if (idServizioLong <= 0L) {
            throw new CoreException("Servizio [" + idServizio.toString() + "] non esistente");
        }
        DBMappingUtils._deleteMappingErogazione(idServizioLong, idPortaApplicativaByNome, con, tipoDB, tabellaSoggetti);
    }

    public static void deleteMappingErogazione(IDServizio idServizio, Connection con, String tipoDB) throws CoreException {
        DBMappingUtils.deleteMappingErogazione(idServizio, null, con, tipoDB, "soggetti");
    }

    public static void deleteMappingErogazione(IDServizio idServizio, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        DBMappingUtils.deleteMappingErogazione(idServizio, null, con, tipoDB, tabellaSoggetti);
    }

    public static void deleteMappingErogazione(IDServizio idServizio, IDPortaApplicativaByNome idPortaApplicativaByNome, Connection con, String tipoDB) throws CoreException {
        DBMappingUtils.deleteMappingErogazione(idServizio, idPortaApplicativaByNome, con, tipoDB, "soggetti");
    }

    public static void deleteMappingErogazione(IDServizio idServizio, IDPortaApplicativaByNome idPortaApplicativaByNome, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        long idServizioLong = DBUtils.getIdAccordoServizioParteSpecifica(idServizio, con, tipoDB);
        if (idServizioLong <= 0L) {
            throw new CoreException("Servizio [" + idServizio.toString() + "] non esistente");
        }
        DBMappingUtils._deleteMappingErogazione(idServizioLong, idPortaApplicativaByNome, con, tipoDB, tabellaSoggetti);
    }

    private static void _deleteMappingErogazione(long idServizioLong, IDPortaApplicativaByNome idPortaApplicativaByNome, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        Statement stmt = null;
        try {
            if (idServizioLong <= 0L) {
                throw new Exception("IdServizio non fornito");
            }
            long idPA = -1L;
            if (idPortaApplicativaByNome != null && (idPA = DBUtils.getIdPortaApplicativa(idPortaApplicativaByNome.getNome(), idPortaApplicativaByNome.getSoggetto().getTipo(), idPortaApplicativaByNome.getSoggetto().getNome(), con, tipoDB, tabellaSoggetti)) <= 0L) {
                throw new Exception("PortaApplicativa [" + idPortaApplicativaByNome + "] non esistente");
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
            sqlQueryObject.addDeleteTable("mapping_erogazione_pa");
            sqlQueryObject.addWhereCondition("id_erogazione=?");
            if (idPortaApplicativaByNome != null) {
                sqlQueryObject.addWhereCondition("id_porta=?");
            }
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idServizioLong);
            if (idPortaApplicativaByNome != null) {
                stmt.setLong(2, idPA);
            }
            stmt.executeUpdate();
            stmt.close();
        }
        catch (Exception e) {
            throw new CoreException("deleteMappingErogazione error", e);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static IDPortaApplicativaByNome getIDPortaApplicativaAssociata(IDAccordo idServizio, Connection con, String tipoDB) throws CoreException {
        return DBMappingUtils.getIDPortaApplicativaAssociata(idServizio, con, tipoDB, "soggetti");
    }

    public static IDPortaApplicativaByNome getIDPortaApplicativaAssociata(IDAccordo idServizio, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        long idServizioLong = DBUtils.getIdAccordoServizioParteSpecifica(idServizio, con, tipoDB);
        if (idServizioLong <= 0L) {
            throw new CoreException("Servizio [" + idServizio.toString() + "] non esistente");
        }
        return DBMappingUtils._getIDPortaApplicativaAssociata(idServizioLong, con, tipoDB, tabellaSoggetti);
    }

    public static IDPortaApplicativaByNome getIDPortaApplicativaAssociata(IDServizio idServizio, Connection con, String tipoDB) throws CoreException {
        return DBMappingUtils.getIDPortaApplicativaAssociata(idServizio, con, tipoDB, "soggetti");
    }

    public static IDPortaApplicativaByNome getIDPortaApplicativaAssociata(IDServizio idServizio, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        long idServizioLong = DBUtils.getIdAccordoServizioParteSpecifica(idServizio, con, tipoDB);
        if (idServizioLong <= 0L) {
            throw new CoreException("Servizio [" + idServizio.toString() + "] non esistente");
        }
        return DBMappingUtils._getIDPortaApplicativaAssociata(idServizioLong, con, tipoDB, tabellaSoggetti);
    }

    private static IDPortaApplicativaByNome _getIDPortaApplicativaAssociata(long idServizioLong, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        Statement stm = null;
        ResultSet rs = null;
        try {
            if (idServizioLong <= 0L) {
                throw new Exception("IdServizio non fornito");
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
            sqlQueryObject.addFromTable("mapping_erogazione_pa");
            sqlQueryObject.addFromTable("porte_applicative");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("porte_applicative.nome_porta");
            sqlQueryObject.addSelectField("soggetti.tipo_soggetto");
            sqlQueryObject.addSelectField("soggetti.nome_soggetto");
            sqlQueryObject.addWhereCondition("id_erogazione = ?");
            sqlQueryObject.addWhereCondition("porte_applicative.id=mapping_erogazione_pa.id_porta");
            sqlQueryObject.addWhereCondition("soggetti.id=porte_applicative.id_soggetto");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            int indexStmt = 1;
            stm.setLong(indexStmt++, idServizioLong);
            rs = stm.executeQuery();
            if (rs.next()) {
                IDPortaApplicativaByNome idPA = new IDPortaApplicativaByNome();
                String nome = rs.getString("nome_porta");
                idPA.setNome(nome);
                IDSoggetto idS = new IDSoggetto(rs.getString("tipo_soggetto"), rs.getString("nome_soggetto"));
                idPA.setSoggetto(idS);
                IDPortaApplicativaByNome iDPortaApplicativaByNome = idPA;
                return iDPortaApplicativaByNome;
            }
            IDPortaApplicativaByNome iDPortaApplicativaByNome = null;
            return iDPortaApplicativaByNome;
        }
        catch (CoreException de) {
            throw de;
        }
        catch (Exception e) {
            throw new CoreException("getIDPortaApplicativaAssociata error", e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static boolean existsIDPortaApplicativaAssociata(IDAccordo idServizio, Connection con, String tipoDB) throws CoreException {
        return DBMappingUtils.existsIDPortaApplicativaAssociata(idServizio, con, tipoDB, "soggetti");
    }

    public static boolean existsIDPortaApplicativaAssociata(IDAccordo idServizio, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        long idServizioLong = DBUtils.getIdAccordoServizioParteSpecifica(idServizio, con, tipoDB);
        if (idServizioLong <= 0L) {
            throw new CoreException("Servizio [" + idServizio.toString() + "] non esistente");
        }
        return DBMappingUtils._existsIDPortaApplicativaAssociata(idServizioLong, con, tipoDB, tabellaSoggetti);
    }

    public static boolean existsIDPortaApplicativaAssociata(IDServizio idServizio, Connection con, String tipoDB) throws CoreException {
        return DBMappingUtils.existsIDPortaApplicativaAssociata(idServizio, con, tipoDB, "soggetti");
    }

    public static boolean existsIDPortaApplicativaAssociata(IDServizio idServizio, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        long idServizioLong = DBUtils.getIdAccordoServizioParteSpecifica(idServizio, con, tipoDB);
        if (idServizioLong <= 0L) {
            throw new CoreException("Servizio [" + idServizio.toString() + "] non esistente");
        }
        return DBMappingUtils._existsIDPortaApplicativaAssociata(idServizioLong, con, tipoDB, tabellaSoggetti);
    }

    private static boolean _existsIDPortaApplicativaAssociata(long idServizioLong, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        Statement stm = null;
        ResultSet rs = null;
        try {
            if (idServizioLong <= 0L) {
                throw new Exception("IdServizio non fornito");
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
            sqlQueryObject.addFromTable("mapping_erogazione_pa");
            sqlQueryObject.addWhereCondition("id_erogazione = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            int indexStmt = 1;
            stm.setLong(indexStmt++, idServizioLong);
            rs = stm.executeQuery();
            boolean bl = rs.next();
            return bl;
        }
        catch (CoreException de) {
            throw de;
        }
        catch (Exception e) {
            throw new CoreException("existsIDPortaApplicativaAssociata error", e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static boolean existsMappingErogazione(IDServizio idServizio, IDPortaApplicativaByNome idPortaApplicativaByNome, Connection con, String tipoDB) throws CoreException {
        return DBMappingUtils.existsMappingErogazione(idServizio, idPortaApplicativaByNome, con, tipoDB, "soggetti");
    }

    public static boolean existsMappingErogazione(IDServizio idServizio, IDPortaApplicativaByNome idPortaApplicativaByNome, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        try {
            long id = DBMappingUtils.getTableIdMappingErogazione(idServizio, idPortaApplicativaByNome, con, tipoDB);
            return id > 0L;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static long getTableIdMappingErogazione(IDServizio idServizio, IDPortaApplicativaByNome idPortaApplicativaByNome, Connection con, String tipoDB) throws CoreException {
        return DBMappingUtils.getTableIdMappingErogazione(idServizio, idPortaApplicativaByNome, con, tipoDB, "soggetti");
    }

    public static long getTableIdMappingErogazione(IDServizio idServizio, IDPortaApplicativaByNome idPortaApplicativaByNome, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        long idServizioLong = DBUtils.getIdAccordoServizioParteSpecifica(idServizio, con, tipoDB);
        if (idServizioLong <= 0L) {
            throw new CoreException("Servizio [" + idServizio.toString() + "] non esistente");
        }
        return DBMappingUtils._getTableIdMappingErogazione(idServizioLong, idPortaApplicativaByNome, con, tipoDB, tabellaSoggetti);
    }

    private static long _getTableIdMappingErogazione(long idServizioLong, IDPortaApplicativaByNome idPortaApplicativaByNome, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        Statement stm = null;
        ResultSet rs = null;
        try {
            if (idServizioLong <= 0L) {
                throw new Exception("IdServizio non fornito");
            }
            long idPA = DBUtils.getIdPortaApplicativa(idPortaApplicativaByNome.getNome(), idPortaApplicativaByNome.getSoggetto().getTipo(), idPortaApplicativaByNome.getSoggetto().getNome(), con, tipoDB, tabellaSoggetti);
            if (idPA <= 0L) {
                throw new Exception("PortaApplicativa [" + idPortaApplicativaByNome + "] non esistente");
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
            sqlQueryObject.addFromTable("mapping_erogazione_pa");
            sqlQueryObject.addWhereCondition("id_erogazione=?");
            sqlQueryObject.addWhereCondition("id_porta=?");
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(queryString);
            stm.setLong(1, idServizioLong);
            stm.setLong(2, idPA);
            rs = stm.executeQuery();
            if (rs.next()) {
                long l = rs.getLong("id");
                return l;
            }
            try {
                throw new CoreException("Mapping tra PA (id:" + idPA + ") e servizio (id:" + idServizioLong + ") non esistente");
            }
            catch (CoreException de) {
                throw de;
            }
            catch (Exception e) {
                throw new CoreException("getIDPortaApplicativaAssociata error", e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static int countMappingFruizione(Connection con, String tipoDB) throws CoreException {
        return DBMappingUtils._countMappingFruizione(con, tipoDB, "soggetti");
    }

    public static int countMappingFruizione(Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        return DBMappingUtils._countMappingFruizione(con, tipoDB, tabellaSoggetti);
    }

    private static int _countMappingFruizione(Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
            sqlQueryObject.addFromTable("mapping_fruizione_pd");
            sqlQueryObject.addSelectCountField("id", "mapping_count");
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            rs = stmt.executeQuery();
            if (rs.next()) {
                int n = rs.getInt("mapping_count");
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception e) {
            throw new CoreException("createMappingFruizione error", e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static void createMappingFruizione(IDAccordo idServizio, IDSoggetto idFruitore, IDPortaDelegata idPortaDelegata, Connection con, String tipoDB) throws CoreException {
        DBMappingUtils.createMappingFruizione(idServizio, idFruitore, idPortaDelegata, con, tipoDB, "soggetti");
    }

    public static void createMappingFruizione(IDAccordo idServizio, IDSoggetto idFruitore, IDPortaDelegata idPortaDelegata, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        long idFruizione = DBUtils.getIdFruizioneServizio(idServizio, idFruitore, con, tipoDB, tabellaSoggetti);
        if (idFruizione <= 0L) {
            throw new CoreException("Fruizione da parte del soggetto [" + idFruitore.toString() + "] del servizio [" + idServizio.toString() + "] non esistente");
        }
        DBMappingUtils._createMappingFruizione(idFruizione, idPortaDelegata, con, tipoDB, tabellaSoggetti);
    }

    public static void createMappingFruizione(IDServizio idServizio, IDSoggetto idFruitore, IDPortaDelegata idPortaDelegata, Connection con, String tipoDB) throws CoreException {
        DBMappingUtils.createMappingFruizione(idServizio, idFruitore, idPortaDelegata, con, tipoDB, "soggetti");
    }

    public static void createMappingFruizione(IDServizio idServizio, IDSoggetto idFruitore, IDPortaDelegata idPortaDelegata, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        long idFruizione = DBUtils.getIdFruizioneServizio(idServizio, idFruitore, con, tipoDB, tabellaSoggetti);
        if (idFruizione <= 0L) {
            throw new CoreException("Fruizione da parte del soggetto [" + idFruitore.toString() + "] del servizio [" + idServizio.toString() + "] non esistente");
        }
        DBMappingUtils._createMappingFruizione(idFruizione, idPortaDelegata, con, tipoDB, tabellaSoggetti);
    }

    private static void _createMappingFruizione(long idFruizione, IDPortaDelegata idPortaDelegata, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        Statement stmt = null;
        try {
            if (idFruizione <= 0L) {
                throw new Exception("IdFruizione non fornita");
            }
            long idPD = DBUtils.getIdPortaDelegata(idPortaDelegata.getLocationPD(), idPortaDelegata.getSoggettoFruitore().getTipo(), idPortaDelegata.getSoggettoFruitore().getNome(), con, tipoDB, tabellaSoggetti);
            if (idPD <= 0L) {
                throw new Exception("PortaDelegata [" + idPortaDelegata + "] non esistente");
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
            sqlQueryObject.addInsertTable("mapping_fruizione_pd");
            sqlQueryObject.addInsertField("id_fruizione", "?");
            sqlQueryObject.addInsertField("id_porta", "?");
            String queryString = sqlQueryObject.createSQLInsert();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idFruizione);
            stmt.setLong(2, idPD);
            stmt.executeUpdate();
            stmt.close();
        }
        catch (Exception e) {
            throw new CoreException("createMappingFruizione error", e);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static void deleteMappingFruizione(IDAccordo idServizio, IDSoggetto idFruitore, Connection con, String tipoDB) throws CoreException {
        DBMappingUtils.deleteMappingFruizione(idServizio, idFruitore, null, con, tipoDB, "soggetti");
    }

    public static void deleteMappingFruizione(IDAccordo idServizio, IDSoggetto idFruitore, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        DBMappingUtils.deleteMappingFruizione(idServizio, idFruitore, null, con, tipoDB, tabellaSoggetti);
    }

    public static void deleteMappingFruizione(IDAccordo idServizio, IDSoggetto idFruitore, IDPortaDelegata idPortaDelegata, Connection con, String tipoDB) throws CoreException {
        DBMappingUtils.deleteMappingFruizione(idServizio, idFruitore, idPortaDelegata, con, tipoDB, "soggetti");
    }

    public static void deleteMappingFruizione(IDAccordo idServizio, IDSoggetto idFruitore, IDPortaDelegata idPortaDelegata, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        long idFruizione = DBUtils.getIdFruizioneServizio(idServizio, idFruitore, con, tipoDB, tabellaSoggetti);
        if (idFruizione <= 0L) {
            throw new CoreException("Fruizione da parte del soggetto [" + idFruitore.toString() + "] del servizio [" + idServizio.toString() + "] non esistente");
        }
        DBMappingUtils._deleteMappingFruizione(idFruizione, idPortaDelegata, con, tipoDB, tabellaSoggetti);
    }

    public static void deleteMappingFruizione(IDServizio idServizio, IDSoggetto idFruitore, Connection con, String tipoDB) throws CoreException {
        DBMappingUtils.deleteMappingFruizione(idServizio, idFruitore, null, con, tipoDB, "soggetti");
    }

    public static void deleteMappingFruizione(IDServizio idServizio, IDSoggetto idFruitore, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        DBMappingUtils.deleteMappingFruizione(idServizio, idFruitore, null, con, tipoDB, tabellaSoggetti);
    }

    public static void deleteMappingFruizione(IDServizio idServizio, IDSoggetto idFruitore, IDPortaDelegata idPortaDelegata, Connection con, String tipoDB) throws CoreException {
        DBMappingUtils.deleteMappingFruizione(idServizio, idFruitore, idPortaDelegata, con, tipoDB, "soggetti");
    }

    public static void deleteMappingFruizione(IDServizio idServizio, IDSoggetto idFruitore, IDPortaDelegata idPortaDelegata, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        long idFruizione = DBUtils.getIdFruizioneServizio(idServizio, idFruitore, con, tipoDB, tabellaSoggetti);
        if (idFruizione <= 0L) {
            throw new CoreException("Fruizione da parte del soggetto [" + idFruitore.toString() + "] del servizio [" + idServizio.toString() + "] non esistente");
        }
        DBMappingUtils._deleteMappingFruizione(idFruizione, idPortaDelegata, con, tipoDB, tabellaSoggetti);
    }

    private static void _deleteMappingFruizione(long idFruizione, IDPortaDelegata idPortaDelegata, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        Statement stmt = null;
        try {
            if (idFruizione <= 0L) {
                throw new Exception("IdFruizione non fornita");
            }
            long idPD = -1L;
            if (idPortaDelegata != null && (idPD = DBUtils.getIdPortaDelegata(idPortaDelegata.getLocationPD(), idPortaDelegata.getSoggettoFruitore().getTipo(), idPortaDelegata.getSoggettoFruitore().getNome(), con, tipoDB, tabellaSoggetti)) <= 0L) {
                throw new Exception("PortaDelegata [" + idPortaDelegata + "] non esistente");
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
            sqlQueryObject.addDeleteTable("mapping_fruizione_pd");
            sqlQueryObject.addWhereCondition("id_fruizione=?");
            if (idPortaDelegata != null) {
                sqlQueryObject.addWhereCondition("id_porta=?");
            }
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idFruizione);
            if (idPortaDelegata != null) {
                stmt.setLong(2, idPD);
            }
            stmt.executeUpdate();
            stmt.close();
        }
        catch (Exception e) {
            throw new CoreException("deleteMappingFruizione error", e);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static IDPortaDelegata getIDPortaDelegataAssociata(IDAccordo idServizio, IDSoggetto idFruitore, Connection con, String tipoDB) throws CoreException {
        return DBMappingUtils.getIDPortaDelegataAssociata(idServizio, idFruitore, con, tipoDB, "soggetti");
    }

    public static IDPortaDelegata getIDPortaDelegataAssociata(IDAccordo idServizio, IDSoggetto idFruitore, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        long idFruizione = DBUtils.getIdFruizioneServizio(idServizio, idFruitore, con, tipoDB, tabellaSoggetti);
        if (idFruizione <= 0L) {
            throw new CoreException("Fruizione da parte del soggetto [" + idFruitore.toString() + "] del servizio [" + idServizio.toString() + "] non esistente");
        }
        return DBMappingUtils._getIDPortaDelegataAssociata(idFruizione, con, tipoDB, tabellaSoggetti);
    }

    public static IDPortaDelegata getIDPortaDelegataAssociata(IDServizio idServizio, IDSoggetto idFruitore, Connection con, String tipoDB) throws CoreException {
        return DBMappingUtils.getIDPortaDelegataAssociata(idServizio, idFruitore, con, tipoDB, "soggetti");
    }

    public static IDPortaDelegata getIDPortaDelegataAssociata(IDServizio idServizio, IDSoggetto idFruitore, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        long idFruizione = DBUtils.getIdFruizioneServizio(idServizio, idFruitore, con, tipoDB, tabellaSoggetti);
        if (idFruizione <= 0L) {
            throw new CoreException("Fruizione da parte del soggetto [" + idFruitore.toString() + "] del servizio [" + idServizio.toString() + "] non esistente");
        }
        return DBMappingUtils._getIDPortaDelegataAssociata(idFruizione, con, tipoDB, tabellaSoggetti);
    }

    private static IDPortaDelegata _getIDPortaDelegataAssociata(long idFruizione, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        Statement stm = null;
        ResultSet rs = null;
        try {
            if (idFruizione <= 0L) {
                throw new Exception("IdFruizione non fornita");
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
            sqlQueryObject.addFromTable("mapping_fruizione_pd");
            sqlQueryObject.addFromTable("porte_delegate");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("porte_delegate.nome_porta");
            sqlQueryObject.addSelectField("porte_delegate.location");
            sqlQueryObject.addSelectField("soggetti.tipo_soggetto");
            sqlQueryObject.addSelectField("soggetti.nome_soggetto");
            sqlQueryObject.addWhereCondition("id_fruizione = ?");
            sqlQueryObject.addWhereCondition("porte_delegate.id=mapping_fruizione_pd.id_porta");
            sqlQueryObject.addWhereCondition("soggetti.id=porte_delegate.id_soggetto");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            int indexStmt = 1;
            stm.setLong(indexStmt++, idFruizione);
            rs = stm.executeQuery();
            if (rs.next()) {
                IDPortaDelegata idPD = new IDPortaDelegata();
                String location = rs.getString("location");
                String nome = rs.getString("nome_porta");
                if (location != null && !"".equals(location)) {
                    idPD.setLocationPD(location);
                } else {
                    idPD.setLocationPD(nome);
                }
                IDSoggetto idS = new IDSoggetto(rs.getString("tipo_soggetto"), rs.getString("nome_soggetto"));
                idPD.setSoggettoFruitore(idS);
                IDPortaDelegata iDPortaDelegata = idPD;
                return iDPortaDelegata;
            }
            IDPortaDelegata iDPortaDelegata = null;
            return iDPortaDelegata;
        }
        catch (CoreException de) {
            throw de;
        }
        catch (Exception e) {
            throw new CoreException("getIDPortaDelegataAssociata error", e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static boolean existsIDPortaDelegataAssociata(IDAccordo idServizio, IDSoggetto idFruitore, Connection con, String tipoDB) throws CoreException {
        return DBMappingUtils.existsIDPortaDelegataAssociata(idServizio, idFruitore, con, tipoDB, "soggetti");
    }

    public static boolean existsIDPortaDelegataAssociata(IDAccordo idServizio, IDSoggetto idFruitore, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        long idFruizione = DBUtils.getIdFruizioneServizio(idServizio, idFruitore, con, tipoDB, tabellaSoggetti);
        if (idFruizione <= 0L) {
            throw new CoreException("Fruizione da parte del soggetto [" + idFruitore.toString() + "] del servizio [" + idServizio.toString() + "] non esistente");
        }
        return DBMappingUtils._existsIDPortaDelegataAssociata(idFruizione, con, tipoDB, tabellaSoggetti);
    }

    public static boolean existsIDPortaDelegataAssociata(IDServizio idServizio, IDSoggetto idFruitore, Connection con, String tipoDB) throws CoreException {
        return DBMappingUtils.existsIDPortaDelegataAssociata(idServizio, idFruitore, con, tipoDB, "soggetti");
    }

    public static boolean existsIDPortaDelegataAssociata(IDServizio idServizio, IDSoggetto idFruitore, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        long idFruizione = DBUtils.getIdFruizioneServizio(idServizio, idFruitore, con, tipoDB, tabellaSoggetti);
        if (idFruizione <= 0L) {
            throw new CoreException("Fruizione da parte del soggetto [" + idFruitore.toString() + "] del servizio [" + idServizio.toString() + "] non esistente");
        }
        return DBMappingUtils._existsIDPortaDelegataAssociata(idFruizione, con, tipoDB, tabellaSoggetti);
    }

    private static boolean _existsIDPortaDelegataAssociata(long idFruizione, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        Statement stm = null;
        ResultSet rs = null;
        try {
            if (idFruizione <= 0L) {
                throw new Exception("IdFruizione non fornita");
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
            sqlQueryObject.addFromTable("mapping_fruizione_pd");
            sqlQueryObject.addWhereCondition("id_fruizione = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            int indexStmt = 1;
            stm.setLong(indexStmt++, idFruizione);
            rs = stm.executeQuery();
            boolean bl = rs.next();
            return bl;
        }
        catch (CoreException de) {
            throw de;
        }
        catch (Exception e) {
            throw new CoreException("existsIDPortaDelegataAssociata error", e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static boolean existsMappingFruizione(IDServizio idServizio, IDSoggetto idFruitore, IDPortaDelegata idPortaDelegata, Connection con, String tipoDB) throws CoreException {
        return DBMappingUtils.existsMappingFruizione(idServizio, idFruitore, idPortaDelegata, con, tipoDB, "soggetti");
    }

    public static boolean existsMappingFruizione(IDServizio idServizio, IDSoggetto idFruitore, IDPortaDelegata idPortaDelegata, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        try {
            long id = DBMappingUtils.getTableIdMappingFruizione(idServizio, idFruitore, idPortaDelegata, con, tipoDB);
            return id > 0L;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static long getTableIdMappingFruizione(IDAccordo idServizio, IDSoggetto idFruitore, IDPortaDelegata idPortaDelegata, Connection con, String tipoDB) throws CoreException {
        return DBMappingUtils.getTableIdMappingFruizione(idServizio, idFruitore, idPortaDelegata, con, tipoDB, "soggetti");
    }

    public static long getTableIdMappingFruizione(IDAccordo idServizio, IDSoggetto idFruitore, IDPortaDelegata idPortaDelegata, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        long idFruizione = DBUtils.getIdFruizioneServizio(idServizio, idFruitore, con, tipoDB, tabellaSoggetti);
        if (idFruizione <= 0L) {
            throw new CoreException("Fruizione da parte del soggetto [" + idFruitore.toString() + "] del servizio [" + idServizio.toString() + "] non esistente");
        }
        return DBMappingUtils._getTableIdMappingFruizione(idFruizione, idPortaDelegata, con, tipoDB, tabellaSoggetti);
    }

    public static long getTableIdMappingFruizione(IDServizio idServizio, IDSoggetto idFruitore, IDPortaDelegata idPortaDelegata, Connection con, String tipoDB) throws CoreException {
        return DBMappingUtils.getTableIdMappingFruizione(idServizio, idFruitore, idPortaDelegata, con, tipoDB, "soggetti");
    }

    public static long getTableIdMappingFruizione(IDServizio idServizio, IDSoggetto idFruitore, IDPortaDelegata idPortaDelegata, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        long idFruizione = DBUtils.getIdFruizioneServizio(idServizio, idFruitore, con, tipoDB, tabellaSoggetti);
        if (idFruizione <= 0L) {
            throw new CoreException("Fruizione da parte del soggetto [" + idFruitore.toString() + "] del servizio [" + idServizio.toString() + "] non esistente");
        }
        return DBMappingUtils._getTableIdMappingFruizione(idFruizione, idPortaDelegata, con, tipoDB, tabellaSoggetti);
    }

    private static long _getTableIdMappingFruizione(long idFruizione, IDPortaDelegata idPortaDelegata, Connection con, String tipoDB, String tabellaSoggetti) throws CoreException {
        Statement stm = null;
        ResultSet rs = null;
        try {
            if (idFruizione <= 0L) {
                throw new Exception("IdFruizione non fornita");
            }
            long idPD = DBUtils.getIdPortaDelegata(idPortaDelegata.getLocationPD(), idPortaDelegata.getSoggettoFruitore().getTipo(), idPortaDelegata.getSoggettoFruitore().getNome(), con, tipoDB, tabellaSoggetti);
            if (idPD <= 0L) {
                throw new Exception("PortaDelegata [" + idPortaDelegata + "] non esistente");
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(tipoDB);
            sqlQueryObject.addFromTable("mapping_fruizione_pd");
            sqlQueryObject.addWhereCondition("id_fruizione=?");
            sqlQueryObject.addWhereCondition("id_porta=?");
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(queryString);
            stm.setLong(1, idFruizione);
            stm.setLong(2, idPD);
            rs = stm.executeQuery();
            if (rs.next()) {
                long l = rs.getLong("id");
                return l;
            }
            try {
                throw new CoreException("Mapping tra PD (id:" + idPD + ") e Fruizione (id:" + idFruizione + ") non esistente");
            }
            catch (CoreException de) {
                throw de;
            }
            catch (Exception e) {
                throw new CoreException("getIDPortaApplicativaAssociata error", e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

