/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.generic_project.utils;

import it.link.pdd.tools.migrazione_govway.generic_project.exception.ServiceException;
import it.link.pdd.tools.migrazione_govway.generic_project.exception.ValidationException;
import it.link.pdd.tools.migrazione_govway.utils.beans.BaseBean;
import it.link.pdd.tools.migrazione_govway.utils.xml.AbstractValidatoreXSD;
import it.link.pdd.tools.migrazione_govway.utils.xml.AbstractXMLUtils;
import it.link.pdd.tools.migrazione_govway.utils.xml.ValidatoreXSD;
import it.link.pdd.tools.migrazione_govway.utils.xml.XMLException;
import it.link.pdd.tools.migrazione_govway.utils.xml.XMLUtils;
import it.link.pdd.tools.migrazione_govway.utils.xml.XSDResourceResolver;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.w3c.dom.ls.LSResourceResolver;

public class XSDValidator {
    private AbstractValidatoreXSD xsdValidator = null;
    private static AbstractXMLUtils xmlUtils = null;

    public XSDValidator(Logger log, Class<?> cXmlRoot, String xsdPath) throws ServiceException {
        this(log, cXmlRoot, ValidatoreXSD.class, xsdPath, new String[0]);
    }

    public XSDValidator(Logger log, Class<?> cXmlRoot, String xsdPath, String ... xsdImported) throws ServiceException {
        this(log, cXmlRoot, ValidatoreXSD.class, xsdPath, xsdImported);
    }

    public XSDValidator(Logger log, Class<?> cXmlRoot, Class<?> xsdValidatorImpl, String xsdPath) throws ServiceException {
        this(log, cXmlRoot, xsdValidatorImpl, xsdPath, new String[0]);
    }

    public XSDValidator(Logger log, Class<?> cXmlRoot, Class<?> xsdValidatorImpl, String xsdPath, String ... xsdImported) throws ServiceException {
        if (xsdPath == null) {
            throw new ServiceException("New Instance failure: xsdPath is null");
        }
        InputStream isSchema = null;
        ArrayList<FileInputStream> listInputStreams = new ArrayList<FileInputStream>();
        XSDResourceResolver xsdResourceResolver = null;
        try {
            File f = new File(xsdPath);
            if (f.exists()) {
                isSchema = new FileInputStream(f);
            } else {
                isSchema = cXmlRoot.getResourceAsStream(xsdPath);
                if (isSchema == null) {
                    isSchema = cXmlRoot.getResourceAsStream("/" + xsdPath);
                }
            }
            if (isSchema == null) {
                throw new Exception("Creating InputStream from xsdPath[" + xsdPath + "] failure");
            }
        }
        catch (Exception e) {
            try {
                if (isSchema != null) {
                    isSchema.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new ServiceException("Init xsd schema failure: " + e.getMessage(), e);
        }
        if (xsdImported != null && xsdImported.length > 0) {
            xsdResourceResolver = new XSDResourceResolver();
            for (int i = 0; i < xsdImported.length; ++i) {
                InputStream is = null;
                try {
                    File f = new File(xsdImported[i]);
                    if (f.exists()) {
                        is = new FileInputStream(f);
                    } else {
                        is = cXmlRoot.getResourceAsStream(xsdImported[i]);
                        if (is == null) {
                            is = cXmlRoot.getResourceAsStream("/" + xsdImported[i]);
                        }
                    }
                    if (is == null) {
                        throw new Exception("Creating InputStream from xsdPath[" + i + "][" + xsdImported[i] + "] failure");
                    }
                    xsdResourceResolver.addResource(f.getName(), is);
                    listInputStreams.add((FileInputStream)is);
                    continue;
                }
                catch (Exception e) {
                    try {
                        if (isSchema != null) {
                            isSchema.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    for (InputStream inputStream : listInputStreams) {
                        try {
                            if (inputStream == null) continue;
                            inputStream.close();
                        }
                        catch (Exception exception) {}
                    }
                    throw new ServiceException("Init xsd schema failure: " + e.getMessage(), e);
                }
            }
        }
        try {
            Object constructor;
            if (xsdResourceResolver != null) {
                constructor = xsdValidatorImpl.getConstructor(Logger.class, String.class, LSResourceResolver.class, InputStream.class);
                this.xsdValidator = (AbstractValidatoreXSD)((Constructor)constructor).newInstance(log, "org.apache.xerces.jaxp.validation.XMLSchemaFactory", xsdResourceResolver, isSchema);
            } else {
                constructor = xsdValidatorImpl.getConstructor(Logger.class, String.class, InputStream.class);
                this.xsdValidator = (AbstractValidatoreXSD)((Constructor)constructor).newInstance(log, "org.apache.xerces.jaxp.validation.XMLSchemaFactory", isSchema);
            }
        }
        catch (Exception e) {
            throw new ServiceException("Init xsd schema failure: " + e.getMessage(), e);
        }
        finally {
            try {
                if (isSchema != null) {
                    isSchema.close();
                }
            }
            catch (Exception exception) {}
            for (InputStream inputStream : listInputStreams) {
                try {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public AbstractValidatoreXSD getXsdValidator() {
        return this.xsdValidator;
    }

    private static synchronized void initXmlUtils() {
        if (xmlUtils == null) {
            xmlUtils = XMLUtils.getInstance();
        }
    }

    public static void validate(BaseBean object, Logger log, AbstractValidatoreXSD xsdValidator) throws ServiceException, ValidationException {
        if (object == null) {
            throw new ServiceException("Paramter object is not defined");
        }
        if (log == null) {
            throw new ServiceException("Paramter log is not defined");
        }
        if (xsdValidator == null) {
            throw new ServiceException("Paramter xsdValidator is not defined");
        }
        String xml = null;
        try {
            xml = object.toXml_Jaxb();
        }
        catch (Exception e) {
            log.debug("XMLSerialization error with jaxb: " + e.getMessage(), (Throwable)e);
            try {
                xml = object.toXml_Jibx();
            }
            catch (Exception eInternal) {
                log.error("XMLSerialization error with jibx: " + e.getMessage(), (Throwable)e);
                throw new ValidationException(eInternal.getMessage(), eInternal);
            }
        }
        if (xmlUtils == null) {
            XSDValidator.initXmlUtils();
        }
        try {
            xsdValidator.valida(xmlUtils.newDocument(xml.getBytes()));
        }
        catch (XMLException xmlException) {
            throw new ValidationException("Object is not valid for xml structure: " + xmlException.getMessage(), xmlException);
        }
        catch (Exception e) {
            throw new ValidationException("Object is not valid: " + e.getMessage(), e);
        }
    }
}

