/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.generic_project.utils;

import it.link.pdd.tools.migrazione_govway.generic_project.exception.ServiceException;
import it.link.pdd.tools.migrazione_govway.generic_project.utils.DatabaseProperties;
import it.link.pdd.tools.migrazione_govway.generic_project.utils.ServiceManagerProperties;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.util.Properties;
import javax.sql.DataSource;
import org.slf4j.Logger;

public class DatabaseFactory<T> {
    private Logger log = null;
    private DatabaseProperties databaseProperties = null;
    private Class<T> cServiceManager = null;

    public DatabaseFactory(Class<T> cServiceManager, String PROPERTIES_LOCAL_PATH, String PROPERTIES_NAME, String nomeFileProperties, Logger log) throws ServiceException {
        try {
            this.cServiceManager = cServiceManager;
            DatabaseProperties.initialize(PROPERTIES_LOCAL_PATH, PROPERTIES_NAME, nomeFileProperties, log);
            this.log = log;
            this.databaseProperties = DatabaseProperties.getInstance(log);
        }
        catch (Exception e) {
            throw new ServiceException(e.getMessage(), e);
        }
    }

    private T getServiceManager(DataSource ds, Connection connection, Boolean isAutocommit) throws ServiceException {
        try {
            Constructor<T> constrServiceManager = null;
            T object = null;
            ServiceManagerProperties smProperties = this.databaseProperties.getServiceManagerProperties();
            if (isAutocommit != null) {
                smProperties.setAutomaticTransactionManagement(isAutocommit);
            }
            if (ds != null) {
                constrServiceManager = this.cServiceManager.getConstructor(DataSource.class, ServiceManagerProperties.class, Logger.class);
                object = constrServiceManager.newInstance(ds, smProperties, this.log);
            } else if (connection != null) {
                constrServiceManager = this.cServiceManager.getConstructor(Connection.class, ServiceManagerProperties.class, Logger.class);
                object = constrServiceManager.newInstance(connection, smProperties, this.log);
            } else if (this.databaseProperties.isTipoAccessoTramiteDatasource()) {
                constrServiceManager = this.cServiceManager.getConstructor(String.class, Properties.class, ServiceManagerProperties.class, Logger.class);
                object = constrServiceManager.newInstance(this.databaseProperties.getDatasourceJNDIName(), this.databaseProperties.getDatasourceJNDIContext(), smProperties, this.log);
            } else {
                constrServiceManager = this.cServiceManager.getConstructor(String.class, String.class, String.class, String.class, ServiceManagerProperties.class, Logger.class);
                object = constrServiceManager.newInstance(this.databaseProperties.getConnectionUrl(), this.databaseProperties.getConnectionDriverJDBC(), this.databaseProperties.getConnectionAuthUsername(), this.databaseProperties.getConnectionAuthPassword(), smProperties, this.log);
            }
            return object;
        }
        catch (Exception e) {
            throw new ServiceException(e.getMessage(), e);
        }
    }

    public Object getServiceManager() throws ServiceException {
        return this.getServiceManager(null, null, null);
    }

    public Object getServiceManager(boolean autoCommit) throws ServiceException {
        return this.getServiceManager(null, null, autoCommit);
    }

    public Object getServiceManager(DataSource ds) throws ServiceException {
        return this.getServiceManager(ds, null, null);
    }

    public Object getServiceManager(DataSource ds, boolean autoCommit) throws ServiceException {
        return this.getServiceManager(ds, null, autoCommit);
    }

    public Object getServiceManager(Connection connection) throws ServiceException {
        return this.getServiceManager(null, connection, null);
    }

    public Object getServiceManager(Connection connection, boolean autoCommit) throws ServiceException {
        return this.getServiceManager(null, connection, autoCommit);
    }
}

