/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.generic_project.serializer;

import it.link.pdd.tools.migrazione_govway.generic_project.exception.SerializerException;
import it.link.pdd.tools.migrazione_govway.generic_project.io.IOUtilities;
import it.link.pdd.tools.migrazione_govway.utils.resources.FileSystemUtilities;
import it.link.pdd.tools.migrazione_govway.utils.xml.PrettyPrintXMLUtils;
import it.link.pdd.tools.migrazione_govway.utils.xml.XMLUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.OutputStream;

public abstract class AbstractSerializer {
    private void createFile(String fileName) throws Exception {
        File f = new File(fileName);
        if (!f.exists()) {
            IOUtilities.mkdirParentDirectory(fileName);
            boolean create = f.createNewFile();
            if (!create) {
                throw new FileNotFoundException("File [" + fileName + "] cannot exists and creating failure");
            }
        }
    }

    public <T> void objToXml(String fileName, Class<T> c, T object) throws SerializerException {
        this.objToXml(fileName, c, object, false);
    }

    public <T> void objToXml(String fileName, Class<T> c, T object, boolean pretty) throws SerializerException {
        try {
            this.createFile(fileName);
            this._objToXml(fileName, c, object, pretty);
        }
        catch (Exception e) {
            throw new SerializerException(e);
        }
    }

    protected abstract <T> void _objToXml(String var1, Class<T> var2, T var3, boolean var4) throws Exception;

    public <T> void objToXml(OutputStream out, Class<T> c, T object) throws SerializerException {
        this.objToXml(out, c, object, false);
    }

    public <T> void objToXml(OutputStream out, Class<T> c, T object, boolean pretty) throws SerializerException {
        try {
            this._objToXml(out, c, object, pretty);
        }
        catch (Exception e) {
            throw new SerializerException(e.getMessage(), e);
        }
    }

    protected abstract <T> void _objToXml(OutputStream var1, Class<T> var2, T var3, boolean var4) throws Exception;

    public void objToXml(String fileName, byte[] contenuto) throws SerializerException {
        this.objToXml(fileName, contenuto, false);
    }

    public void objToXml(String fileName, byte[] contenuto, boolean pretty) throws SerializerException {
        try {
            this.createFile(fileName);
            if (pretty) {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                PrettyPrintXMLUtils.prettyPrintWithTrAX(XMLUtils.getInstance().newDocument(contenuto), (OutputStream)bout, false);
                bout.flush();
                bout.close();
                FileSystemUtilities.writeFile(fileName, bout.toByteArray());
            } else {
                FileSystemUtilities.writeFile(fileName, contenuto);
            }
        }
        catch (Exception e) {
            throw new SerializerException(e);
        }
    }

    public <T> byte[] objToXmlAsByteArray(Class<T> c, T object) throws SerializerException {
        return this.objToXmlAsByteArray(c, object, false);
    }

    public <T> byte[] objToXmlAsByteArray(Class<T> c, T object, boolean pretty) throws SerializerException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            this._objToXml(bout, c, object, pretty);
            bout.flush();
            bout.close();
            return bout.toByteArray();
        }
        catch (Exception e) {
            throw new SerializerException(e.getMessage(), e);
        }
    }

    public <T> String objToXmlAsString(Class<T> c, T object) throws SerializerException {
        return this.objToXmlAsString(c, object, false);
    }

    public <T> String objToXmlAsString(Class<T> c, T object, boolean pretty) throws SerializerException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            this._objToXml(bout, c, object, pretty);
            bout.flush();
            bout.close();
            return bout.toString();
        }
        catch (Exception e) {
            throw new SerializerException(e.getMessage(), e);
        }
    }
}

