/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.generic_project.serializer;

import it.link.pdd.tools.migrazione_govway.generic_project.exception.DeserializerException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public abstract class AbstractDeserializer {
    public <T> T xmlToObj(String fileName, Class<T> c) throws DeserializerException {
        try {
            return this._xmlToObj(fileName, c);
        }
        catch (Exception e) {
            throw new DeserializerException(e);
        }
    }

    protected abstract <T> T _xmlToObj(String var1, Class<T> var2) throws Exception;

    public <T> T xmlToObj(InputStream is, Class<T> c) throws DeserializerException {
        try {
            return this._xmlToObj(is, c);
        }
        catch (Exception e) {
            throw new DeserializerException(e);
        }
    }

    protected abstract <T> T _xmlToObj(InputStream var1, Class<T> var2) throws Exception;

    public <T> T xmlToObjByByteArray(byte[] xml, Class<T> c) throws DeserializerException {
        T t;
        ByteArrayInputStream bin = null;
        try {
            bin = new ByteArrayInputStream(xml);
            t = this._xmlToObj(bin, c);
        }
        catch (Exception e) {
            throw new DeserializerException(e);
        }
        finally {
            try {
                bin.close();
            }
            catch (Exception exception) {}
        }
        return t;
    }

    public <T> T xmlToObjByString(String xml, Class<T> c) throws DeserializerException {
        try {
            return this.xmlToObjByByteArray(xml.getBytes(), c);
        }
        catch (Exception e) {
            throw new DeserializerException(e);
        }
    }
}

