/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.generic_project.io;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class IOUtilities {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(String in, String out) throws IOException {
        FileInputStream fin = null;
        FileOutputStream fout = null;
        try {
            fin = new FileInputStream(in);
            fout = new FileOutputStream(out);
            IOUtilities.copy(fin, fout);
            fout.flush();
        }
        finally {
            try {
                if (fin != null) {
                    fin.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (fout != null) {
                    fout.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream in, OutputStream out) throws IOException {
        InputStream inputStream = in;
        synchronized (inputStream) {
            OutputStream outputStream = out;
            synchronized (outputStream) {
                int bytesRead;
                byte[] buffer = new byte[256];
                while ((bytesRead = in.read(buffer)) != -1) {
                    out.write(buffer, 0, bytesRead);
                }
            }
        }
    }

    public static void copyDirectory(String srcPath, String dstPath) throws IOException {
        IOUtilities.copyDirectory(new File(srcPath), new File(dstPath));
    }

    public static void copyDirectory(File srcPath, File dstPath) throws IOException {
        if (srcPath.isDirectory()) {
            if (!dstPath.exists()) {
                dstPath.mkdir();
            }
            String[] files = srcPath.list();
            for (int i = 0; i < files.length; ++i) {
                if (".svn".equals(files[i])) continue;
                IOUtilities.copyDirectory(new File(srcPath, files[i]), new File(dstPath, files[i]));
            }
        } else {
            int len;
            if (!srcPath.exists()) {
                return;
            }
            FileInputStream in = new FileInputStream(srcPath);
            FileOutputStream out = new FileOutputStream(dstPath);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
    }

    public static String readFile(File f) throws Exception {
        FileInputStream fis = new FileInputStream(f);
        ByteArrayOutputStream byteInputBuffer = new ByteArrayOutputStream();
        byte[] readB = new byte[8192];
        int readByte = 0;
        while ((readByte = fis.read(readB)) != -1) {
            byteInputBuffer.write(readB, 0, readByte);
        }
        fis.close();
        byteInputBuffer.flush();
        byteInputBuffer.close();
        return byteInputBuffer.toString();
    }

    public static byte[] readBytesFromFile(File f) throws Exception {
        FileInputStream fis = new FileInputStream(f);
        ByteArrayOutputStream byteInputBuffer = new ByteArrayOutputStream();
        byte[] readB = new byte[8192];
        int readByte = 0;
        while ((readByte = fis.read(readB)) != -1) {
            byteInputBuffer.write(readB, 0, readByte);
        }
        fis.close();
        byteInputBuffer.flush();
        byteInputBuffer.close();
        return byteInputBuffer.toByteArray();
    }

    public static void writeFile(File f, byte[] contenuto) throws Exception {
        FileOutputStream fos = new FileOutputStream(f);
        fos.write(contenuto);
        fos.flush();
        fos.close();
    }

    public static void writeFile(File f, byte[] ... args) throws Exception {
        if (args != null) {
            FileOutputStream fos = new FileOutputStream(f);
            for (int i = 0; i < args.length; ++i) {
                fos.write(args[i]);
            }
            fos.flush();
            fos.close();
        }
    }

    public static void copyFileAndReplaceAllKeywords(File read, File write, String keyword, String values) throws Exception {
        String[] k = new String[]{keyword};
        String[] v = new String[]{values};
        IOUtilities.copyFileAndReplaceAllKeywords(read, write, k, v);
    }

    public static void copyFileAndReplaceAllKeywords(File read, File write, String[] keyword, String[] values) throws Exception {
        String file = IOUtilities.readFile(read);
        for (int i = 0; i < keyword.length; ++i) {
            int indexOf = file.indexOf(keyword[i]);
            while (indexOf >= 0) {
                file = file.replace(keyword[i], values[i]);
                indexOf = file.indexOf(keyword[i], indexOf + values[i].length());
            }
        }
        IOUtilities.writeFile(write, file.getBytes());
    }

    public static void copyFileAndReplaceKeywords(File read, File write, String keyword, String values) throws Exception {
        String[] k = new String[]{keyword};
        String[] v = new String[]{values};
        IOUtilities.copyFileAndReplaceKeywords(read, write, k, v);
    }

    public static void copyFileAndReplaceKeywords(File read, File write, String[] keyword, String[] values) throws Exception {
        String file = IOUtilities.readFile(read);
        for (int i = 0; i < keyword.length; ++i) {
            file = file.replace(keyword[i], values[i]);
        }
        IOUtilities.writeFile(write, file.getBytes());
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = IOUtilities.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        boolean delete = dir.delete();
        return delete;
    }

    public static void moveToDir(String src, String destDir) throws Exception {
        File file = new File(src);
        File dir = new File(destDir);
        IOUtilities.moveToDir(file, dir);
    }

    public static void moveToDir(File src, File destDir) throws Exception {
        IOUtilities.copy(src.getAbsolutePath(), destDir.getAbsolutePath() + File.separatorChar + src.getName());
        if (src.isDirectory()) {
            if (!IOUtilities.deleteDir(src)) {
                throw new Exception("Directory [" + src.getAbsolutePath() + "] non eliminabile");
            }
        } else if (!src.delete()) {
            throw new Exception("File [" + src.getAbsolutePath() + "] non eliminabile");
        }
    }

    public static void moveToFile(String src, String destFile) throws Exception {
        File file = new File(src);
        File dir = new File(destFile);
        IOUtilities.moveToFile(file, dir);
    }

    public static void moveToFile(File src, File destFile) throws Exception {
        IOUtilities.copy(src.getAbsolutePath(), destFile.getAbsolutePath());
        if (src.isDirectory()) {
            if (!IOUtilities.deleteDir(src)) {
                throw new Exception("Directory [" + src.getAbsolutePath() + "] non eliminabile");
            }
        } else if (!src.delete()) {
            throw new Exception("File [" + src.getAbsolutePath() + "] non eliminabile");
        }
    }

    public static void mkdirParentDirectory(String file) throws Exception {
        try {
            File p = new File(file);
            if (p.getParentFile() == null) {
                return;
            }
            if (p.getParentFile().exists()) {
                return;
            }
            IOUtilities.mkdirParentDirectory(p.getParentFile().getAbsolutePath());
            if (!p.getParentFile().mkdir()) {
                throw new Exception("Directory [" + p.getParentFile().getAbsolutePath() + "] non esistente e creazione non riuscita");
            }
        }
        catch (Exception e) {
            throw new Exception("mkdirParentDirectory non riuscito: " + e.getMessage(), e);
        }
    }
}

