/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.generic_project.expression.impl.sql;

import it.link.pdd.tools.migrazione_govway.generic_project.beans.AliasField;
import it.link.pdd.tools.migrazione_govway.generic_project.beans.ComplexField;
import it.link.pdd.tools.migrazione_govway.generic_project.beans.ConstantField;
import it.link.pdd.tools.migrazione_govway.generic_project.beans.CustomField;
import it.link.pdd.tools.migrazione_govway.generic_project.beans.Field;
import it.link.pdd.tools.migrazione_govway.generic_project.beans.Function;
import it.link.pdd.tools.migrazione_govway.generic_project.beans.FunctionField;
import it.link.pdd.tools.migrazione_govway.generic_project.beans.IAliasTableField;
import it.link.pdd.tools.migrazione_govway.generic_project.beans.IField;
import it.link.pdd.tools.migrazione_govway.generic_project.beans.IModel;
import it.link.pdd.tools.migrazione_govway.generic_project.beans.UnixTimestampIntervalField;
import it.link.pdd.tools.migrazione_govway.generic_project.exception.ExpressionException;
import it.link.pdd.tools.migrazione_govway.generic_project.exception.ExpressionNotImplementedException;
import it.link.pdd.tools.migrazione_govway.generic_project.expression.Index;
import it.link.pdd.tools.migrazione_govway.generic_project.expression.LikeMode;
import it.link.pdd.tools.migrazione_govway.generic_project.expression.SortOrder;
import it.link.pdd.tools.migrazione_govway.generic_project.expression.impl.BetweenExpressionImpl;
import it.link.pdd.tools.migrazione_govway.generic_project.expression.impl.Comparator;
import it.link.pdd.tools.migrazione_govway.generic_project.expression.impl.ComparatorExpressionImpl;
import it.link.pdd.tools.migrazione_govway.generic_project.expression.impl.ConjunctionExpressionImpl;
import it.link.pdd.tools.migrazione_govway.generic_project.expression.impl.ExpressionImpl;
import it.link.pdd.tools.migrazione_govway.generic_project.expression.impl.InExpressionImpl;
import it.link.pdd.tools.migrazione_govway.generic_project.expression.impl.LikeExpressionImpl;
import it.link.pdd.tools.migrazione_govway.generic_project.expression.impl.OrderedField;
import it.link.pdd.tools.migrazione_govway.generic_project.expression.impl.formatter.IObjectFormatter;
import it.link.pdd.tools.migrazione_govway.generic_project.expression.impl.sql.BetweenExpressionSQL;
import it.link.pdd.tools.migrazione_govway.generic_project.expression.impl.sql.ComparatorExpressionSQL;
import it.link.pdd.tools.migrazione_govway.generic_project.expression.impl.sql.ConjunctionExpressionSQL;
import it.link.pdd.tools.migrazione_govway.generic_project.expression.impl.sql.ISQLExpression;
import it.link.pdd.tools.migrazione_govway.generic_project.expression.impl.sql.ISQLFieldConverter;
import it.link.pdd.tools.migrazione_govway.generic_project.expression.impl.sql.InExpressionSQL;
import it.link.pdd.tools.migrazione_govway.generic_project.expression.impl.sql.LikeExpressionSQL;
import it.link.pdd.tools.migrazione_govway.generic_project.expression.impl.sql.PaginatedExpressionSQL;
import it.link.pdd.tools.migrazione_govway.utils.TipiDatabase;
import it.link.pdd.tools.migrazione_govway.utils.sql.ISQLQueryObject;
import it.link.pdd.tools.migrazione_govway.utils.sql.SQLQueryObjectAlreadyExistsException;
import it.link.pdd.tools.migrazione_govway.utils.sql.SQLQueryObjectCore;
import it.link.pdd.tools.migrazione_govway.utils.sql.SQLQueryObjectException;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

public class ExpressionSQL
extends ExpressionImpl {
    private boolean throwExpressionNotInitialized = false;
    private TipiDatabase databaseType;
    private ISQLFieldConverter sqlFieldConverter;
    private boolean usedForCountExpression = false;
    private List<Object> fieldsManuallyAdd = new ArrayList<Object>();
    private boolean checkFieldManuallyAdd = true;
    private static final String _PREFIX_ALIASFIELD = "_______ALIASFIELD_______";

    public TipiDatabase getDatabaseType() {
        return this.databaseType;
    }

    public ISQLFieldConverter getSqlFieldConverter() {
        return this.sqlFieldConverter;
    }

    public void setSqlFieldConverter(ISQLFieldConverter sqlFieldConverter) {
        this.sqlFieldConverter = sqlFieldConverter;
    }

    public boolean isUsedForCountExpression() {
        return this.usedForCountExpression;
    }

    public void setUsedForCountExpression(boolean usedForCountExpression) {
        this.usedForCountExpression = usedForCountExpression;
    }

    public ExpressionSQL(ISQLFieldConverter sqlFieldConverter) throws ExpressionException {
        this.sqlFieldConverter = sqlFieldConverter;
        if (this.sqlFieldConverter != null) {
            this.databaseType = this.sqlFieldConverter.getDatabaseType();
        }
    }

    public ExpressionSQL(ISQLFieldConverter sqlFieldConverter, IObjectFormatter objectFormatter) throws ExpressionException {
        super(objectFormatter);
        this.sqlFieldConverter = sqlFieldConverter;
        if (this.sqlFieldConverter != null) {
            this.databaseType = this.sqlFieldConverter.getDatabaseType();
        }
    }

    public ExpressionSQL(PaginatedExpressionSQL expression) throws ExpressionException {
        super(expression);
        this.sqlFieldConverter = expression.getSqlFieldConverter();
        this.fieldsManuallyAdd = expression.getFieldsManuallyAdd();
        if (this.sqlFieldConverter != null) {
            this.databaseType = this.sqlFieldConverter.getDatabaseType();
        }
    }

    public List<Object> getFieldsManuallyAdd() {
        return this.fieldsManuallyAdd;
    }

    public void removeFieldManuallyAdd(Object o) {
        if (this.fieldsManuallyAdd.contains(o)) {
            this.fieldsManuallyAdd.remove(o);
        }
    }

    public void setCheckFieldManuallyAdd(boolean checkFieldManuallyAdd) {
        this.checkFieldManuallyAdd = checkFieldManuallyAdd;
    }

    @Override
    public boolean inUseField(IField field, boolean checkOnlyWhereCondition) throws ExpressionNotImplementedException, ExpressionException {
        return ExpressionSQL.inUse(field, checkOnlyWhereCondition, super.inUseField(field, checkOnlyWhereCondition), this.getFieldsManuallyAdd(), this.checkFieldManuallyAdd);
    }

    @Override
    public boolean inUseModel(IModel<?> model, boolean checkOnlyWhereCondition) throws ExpressionNotImplementedException, ExpressionException {
        return ExpressionSQL.inUse(model, checkOnlyWhereCondition, super.inUseModel(model, checkOnlyWhereCondition), this.getFieldsManuallyAdd(), this.checkFieldManuallyAdd);
    }

    @Override
    public List<IField> getFields(boolean onlyWhereCondition) throws ExpressionNotImplementedException, ExpressionException {
        return ExpressionSQL.getFields(onlyWhereCondition, super.getFields(onlyWhereCondition), this.getFieldsManuallyAdd(), this.checkFieldManuallyAdd);
    }

    public static Comparator getCorrectComparator(Comparator comparator, TipiDatabase databaseType) {
        if (databaseType != null && TipiDatabase.ORACLE.equals(databaseType)) {
            if (Comparator.IS_EMPTY.equals((Object)comparator)) {
                return Comparator.IS_NULL;
            }
            if (Comparator.IS_NOT_EMPTY.equals((Object)comparator)) {
                return Comparator.IS_NOT_NULL;
            }
        }
        return comparator;
    }

    @Override
    protected Comparator getCorrectComparator(Comparator comparator) {
        return ExpressionSQL.getCorrectComparator(comparator, this.databaseType);
    }

    private String toSqlForceIndex() throws ExpressionException {
        return ExpressionSQL.sqlForceIndex(this.sqlFieldConverter, this.getForceIndexes());
    }

    protected static String sqlForceIndex(ISQLFieldConverter fieldConverter, List<Index> forceIndexes) throws ExpressionException {
        try {
            StringBuffer bf = new StringBuffer();
            if (forceIndexes.size() > 0) {
                for (Index forceIndex : forceIndexes) {
                    String forceIndexSql = "/*+ index(" + fieldConverter.toTable(forceIndex.getModel(), false) + " " + forceIndex.getName() + ") */";
                    bf.append(" ");
                    bf.append(forceIndexSql);
                }
            }
            return bf.toString();
        }
        catch (Exception e) {
            throw new ExpressionException(e);
        }
    }

    private void toSqlForceIndex(ISQLQueryObject sqlQueryObject) throws ExpressionException {
        ExpressionSQL.sqlForceIndex(this.sqlFieldConverter, sqlQueryObject, this.getForceIndexes());
    }

    protected static void sqlForceIndex(ISQLFieldConverter fieldConverter, ISQLQueryObject sqlQueryObject, List<Index> forceIndexes) throws ExpressionException {
        try {
            if (forceIndexes.size() > 0) {
                for (Index forceIndex : forceIndexes) {
                    sqlQueryObject.addSelectForceIndex(fieldConverter.toTable(forceIndex.getModel(), false), forceIndex.getName());
                }
            }
        }
        catch (Exception e) {
            throw new ExpressionException(e);
        }
    }

    private String toSqlOrder() throws ExpressionException {
        return ExpressionSQL.sqlOrder(this.sqlFieldConverter, this.getSortOrder(), this.getOrderedFields());
    }

    protected static String sqlOrder(ISQLFieldConverter fieldConverter, SortOrder sortOrder, List<OrderedField> orderedFields) throws ExpressionException {
        try {
            StringBuffer bf = new StringBuffer();
            if (!SortOrder.UNSORTED.equals(sortOrder)) {
                bf.append(" ORDER BY ");
                if (orderedFields.size() > 0) {
                    int index = 0;
                    for (OrderedField orderedField : orderedFields) {
                        IField field = orderedField.getField();
                        if (index > 0) {
                            bf.append(" , ");
                        }
                        bf.append(fieldConverter.toColumn(field, true));
                        bf.append(" ");
                        bf.append(orderedField.getSortOrder().name());
                        ++index;
                    }
                } else {
                    bf.append(" id");
                    bf.append(" ");
                    bf.append(sortOrder.name());
                }
            }
            return bf.toString();
        }
        catch (Exception e) {
            throw new ExpressionException(e);
        }
    }

    private void toSqlOrder(ISQLQueryObject sqlQueryObject) throws ExpressionException {
        ExpressionSQL.sqlOrder(this.sqlFieldConverter, sqlQueryObject, this.getSortOrder(), this.getOrderedFields(), this.getGroupByFields());
    }

    protected static void sqlOrder(ISQLFieldConverter fieldConverter, ISQLQueryObject sqlQueryObject, SortOrder sortOrder, List<OrderedField> orderedFields, List<IField> groupByFields) throws ExpressionException {
        block21: {
            try {
                if (SortOrder.UNSORTED.equals(sortOrder)) break block21;
                if (orderedFields.size() > 0) {
                    for (OrderedField orderedField : orderedFields) {
                        IField field = orderedField.getField();
                        String columnOrderAlias = fieldConverter.toColumn(field, true, true);
                        String columnOrderBy = fieldConverter.toColumn(field, true);
                        sqlQueryObject.addOrderBy(columnOrderBy, SortOrder.ASC.equals(orderedField.getSortOrder()));
                        Vector<Object> v = new Vector();
                        try {
                            v = sqlQueryObject.getFieldsName();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        boolean contains = false;
                        if (v.contains(columnOrderAlias)) {
                            contains = true;
                        }
                        if (!contains) {
                            try {
                                v = ((SQLQueryObjectCore)sqlQueryObject).getFields();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (v.contains(columnOrderBy)) {
                                contains = true;
                            }
                        }
                        if (!contains) {
                            for (int i = 0; i < v.size(); ++i) {
                                String[] tmp;
                                String column = (String)v.get(0);
                                if (column.contains(" as ")) {
                                    tmp = column.split(" as ");
                                    if (!tmp[0].equals(columnOrderBy)) continue;
                                    contains = true;
                                    break;
                                }
                                if (!column.contains(" ") || !(tmp = column.split(" "))[0].equals(columnOrderBy)) continue;
                                contains = true;
                                break;
                            }
                        }
                        if (contains) continue;
                        boolean add = true;
                        if (groupByFields != null) {
                            for (IField groupByField : groupByFields) {
                                if (!groupByField.equals(field)) continue;
                                add = false;
                                break;
                            }
                        }
                        if (!add) continue;
                        if (field instanceof UnixTimestampIntervalField) {
                            UnixTimestampIntervalField unix = (UnixTimestampIntervalField)field;
                            String alias = null;
                            if (!unix.existsAlias()) {
                                unix.buildAlias();
                            }
                            alias = unix.getAlias();
                            sqlQueryObject.addSelectAliasField(columnOrderBy, alias);
                            continue;
                        }
                        sqlQueryObject.addSelectField(columnOrderBy);
                    }
                } else {
                    sqlQueryObject.addOrderBy("id");
                }
                if (SortOrder.ASC.equals(sortOrder)) {
                    sqlQueryObject.setSortType(true);
                } else {
                    sqlQueryObject.setSortType(false);
                }
            }
            catch (Exception e) {
                throw new ExpressionException(e);
            }
        }
    }

    private String toSqlGroupBy() throws ExpressionException {
        return ExpressionSQL.sqlGroupBy(this.sqlFieldConverter, this.groupByFields);
    }

    protected static String sqlGroupBy(ISQLFieldConverter fieldConverter, List<IField> groupByFields) throws ExpressionException {
        try {
            StringBuffer bf = new StringBuffer();
            if (groupByFields.size() > 0) {
                bf.append(" GROUP BY ");
                int index = 0;
                for (IField field : groupByFields) {
                    if (index > 0) {
                        bf.append(" , ");
                    }
                    bf.append(fieldConverter.toColumn(field, true));
                    ++index;
                }
            }
            return bf.toString();
        }
        catch (Exception e) {
            throw new ExpressionException(e);
        }
    }

    private void toSqlGroupBy(ISQLQueryObject sqlQueryObject) throws ExpressionException {
        ExpressionSQL.sqlGroupBy(this.sqlFieldConverter, sqlQueryObject, this.groupByFields);
    }

    protected static void sqlGroupBy(ISQLFieldConverter fieldConverter, ISQLQueryObject sqlQueryObject, List<IField> groupByFields) throws ExpressionException {
        try {
            if (groupByFields.size() > 0) {
                for (IField field : groupByFields) {
                    sqlQueryObject.addGroupBy(fieldConverter.toColumn(field, true));
                }
            }
        }
        catch (Exception e) {
            throw new ExpressionException(e);
        }
    }

    private void toSqlGroupBySelectField(ISQLQueryObject sqlQueryObject) throws ExpressionException {
        ExpressionSQL.sqlGroupBySelectField(this.sqlFieldConverter, sqlQueryObject, this.fieldsManuallyAdd, this.groupByFields, this.usedForCountExpression);
    }

    protected static void sqlGroupBySelectField(ISQLFieldConverter fieldConverter, ISQLQueryObject sqlQueryObject, List<Object> selectFieldsManuallyAdd, List<IField> groupByFields, boolean usedForCountExpression) throws ExpressionException {
        block7: {
            if (!usedForCountExpression) {
                try {
                    if (groupByFields == null) break block7;
                    for (IField iField : groupByFields) {
                        boolean found = false;
                        for (Object checkSelectFieldManuallyAdd : selectFieldsManuallyAdd) {
                            if (!(checkSelectFieldManuallyAdd instanceof IField) || !iField.equals((IField)checkSelectFieldManuallyAdd)) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        String column1 = fieldConverter.toColumn(iField, true);
                        String column2 = fieldConverter.toColumn(iField, false);
                        boolean insert = true;
                        try {
                            insert = !sqlQueryObject.getFieldsName().contains(column1) && !sqlQueryObject.getFieldsName().contains(column2);
                        }
                        catch (SQLQueryObjectException sQLQueryObjectException) {
                            // empty catch block
                        }
                        if (!insert) continue;
                        ExpressionSQL.addField_engine(sqlQueryObject, fieldConverter, iField, null, true);
                        selectFieldsManuallyAdd.add(iField);
                    }
                }
                catch (Exception e) {
                    throw new ExpressionException(e.getMessage(), e);
                }
            }
        }
    }

    protected static void sqlFrom(ISQLQueryObject sqlQueryObject, List<IField> fields, ISQLFieldConverter sqlFieldConverter, String tableNamePrincipale, List<Object> fieldsManuallyAdd, List<OrderedField> orderByFields, List<IField> groupByFields) throws ExpressionException {
        ExpressionSQL.sqlFrom(sqlQueryObject, fields, sqlFieldConverter, tableNamePrincipale, fieldsManuallyAdd, orderByFields, groupByFields, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static void sqlFrom(ISQLQueryObject sqlQueryObject, List<IField> fields, ISQLFieldConverter sqlFieldConverter, String tableNamePrincipale, List<Object> fieldsManuallyAdd, List<OrderedField> orderByFields, List<IField> groupByFields, boolean ignoreAlreadyExistsException) throws ExpressionException {
        try {
            String tableName;
            String tableName2;
            ArrayList<String> tables = new ArrayList<String>();
            if (fields != null) {
                for (IField iField : fields) {
                    tableName2 = ExpressionSQL.getTableName(iField, sqlFieldConverter);
                    if (tables.contains(tableName2)) continue;
                    tables.add(tableName2);
                }
            }
            if (fieldsManuallyAdd != null) {
                for (Object object : fieldsManuallyAdd) {
                    IField field = null;
                    if (object instanceof IField) {
                        field = (IField)object;
                        tableName = ExpressionSQL.getTableName(field, sqlFieldConverter);
                        if (tables.contains(tableName)) continue;
                        tables.add(tableName);
                        continue;
                    }
                    if (!(object instanceof FunctionField)) throw new ExpressionException("Field type unknown [" + object.getClass().getName() + "]");
                    List<IField> fieldsFF = ((FunctionField)object).getFields();
                    for (IField iFieldFF : fieldsFF) {
                        String tableName3 = ExpressionSQL.getTableName(iFieldFF, sqlFieldConverter);
                        if (tables.contains(tableName3)) continue;
                        tables.add(tableName3);
                    }
                }
            }
            if (orderByFields != null) {
                for (OrderedField orderedField : orderByFields) {
                    IField iField = orderedField.getField();
                    tableName = ExpressionSQL.getTableName(iField, sqlFieldConverter);
                    if (tables.contains(tableName)) continue;
                    tables.add(tableName);
                }
            }
            if (groupByFields != null) {
                for (IField iField : groupByFields) {
                    tableName2 = ExpressionSQL.getTableName(iField, sqlFieldConverter);
                    if (tables.contains(tableName2)) continue;
                    tables.add(tableName2);
                }
            }
            if (tableNamePrincipale != null && !tables.contains(tableNamePrincipale)) {
                tables.add(tableNamePrincipale);
            }
            for (String string : tables) {
                if (string == null || "".equals(string)) continue;
                try {
                    if (string.contains(_PREFIX_ALIASFIELD)) {
                        String originalTableName = string.split(_PREFIX_ALIASFIELD)[0];
                        String aliasTable = string.split(_PREFIX_ALIASFIELD)[1];
                        sqlQueryObject.addFromTable(originalTableName, aliasTable);
                        continue;
                    }
                    sqlQueryObject.addFromTable(string);
                }
                catch (SQLQueryObjectAlreadyExistsException alreadyExists) {
                    if (ignoreAlreadyExistsException) continue;
                    throw new ExpressionException(alreadyExists.getMessage(), alreadyExists);
                    return;
                }
            }
        }
        catch (Exception e) {
            throw new ExpressionException(e.getMessage(), e);
        }
    }

    private static String getTableName(IField iField, ISQLFieldConverter sqlFieldConverter) throws ExpressionException {
        Object tableName = null;
        if (iField instanceof AliasField) {
            AliasField af = (AliasField)iField;
            if (af.getAlias().contains(".")) {
                String originaleTableName = sqlFieldConverter.toTable(iField);
                tableName = originaleTableName + _PREFIX_ALIASFIELD + af.getAlias().split("\\.")[0];
            } else {
                tableName = sqlFieldConverter.toTable(iField);
            }
        } else if (iField instanceof IAliasTableField) {
            IAliasTableField atf = (IAliasTableField)iField;
            String originaleTableName = sqlFieldConverter.toTable(iField, false);
            tableName = originaleTableName + _PREFIX_ALIASFIELD + atf.getAliasTable();
        } else {
            tableName = sqlFieldConverter.toTable(iField);
        }
        return tableName;
    }

    protected static void addField_engine(ISQLQueryObject sqlQueryObject, ISQLFieldConverter sqlFieldConverter, Object field, String aliasField, boolean appendTablePrefix) throws ExpressionException {
        ExpressionSQL.addField_engine(sqlQueryObject, sqlFieldConverter, field, aliasField, appendTablePrefix, true);
    }

    protected static void addField_engine(ISQLQueryObject sqlQueryObject, ISQLFieldConverter sqlFieldConverter, Object field, String aliasField, boolean appendTablePrefix, boolean ignoreAlreadyExistsException) throws ExpressionException {
        block27: {
            try {
                if (field == null) {
                    throw new ExpressionException("Field is null");
                }
                if (field instanceof FunctionField) {
                    FunctionField ff = (FunctionField)field;
                    boolean customFunction = ff.isCustomFunction();
                    String prefixCustomFunction = ff.getPrefixFunctionCustom();
                    String suffixCustomFunction = ff.getSuffixFunctionCustom();
                    Function function = ff.getFunction();
                    String functionValue = ff.getFunctionValue();
                    String operator = ff.getOperator();
                    List<IField> fields = ff.getFields();
                    String column = null;
                    boolean timestamp = false;
                    if (ff.getFieldType().getName().equals(Timestamp.class.getName()) || ff.getFieldType().getName().equals(java.util.Date.class.getName()) || ff.getFieldType().getName().equals(Date.class.getName()) || ff.getFieldType().getName().equals(Calendar.class.getName())) {
                        timestamp = true;
                    }
                    String alias = ff.getAlias();
                    if (functionValue != null) {
                        column = functionValue;
                    } else if (operator != null) {
                        if (fields.size() > 1 && timestamp) {
                            throw new ExpressionException("Multiple fields with operator and \"time\" type (" + ff.getFieldType().getName() + ") not supported. For Timestamp Interval use FunctionField(new UnixTimestampIntervalField(...), Function.TIPE, columnName)");
                        }
                        StringBuffer bf = new StringBuffer();
                        for (int i = 0; i < fields.size(); ++i) {
                            if (i > 0) {
                                bf.append(" ").append(operator).append(" ");
                            }
                            bf.append(sqlFieldConverter.toColumn(fields.get(i), appendTablePrefix));
                        }
                        column = bf.toString();
                    } else {
                        column = sqlFieldConverter.toColumn(fields.get(0), appendTablePrefix);
                    }
                    if (customFunction) {
                        sqlQueryObject.addSelectAliasField(prefixCustomFunction + " " + column + " " + suffixCustomFunction, alias);
                    } else {
                        ExpressionSQL.setFunction(function, timestamp, column, alias, sqlQueryObject);
                    }
                    break block27;
                }
                if (field instanceof ConstantField) {
                    sqlQueryObject.addSelectAliasField(sqlFieldConverter.toColumn((ConstantField)field, appendTablePrefix), ((ConstantField)field).getAlias());
                    break block27;
                }
                if (field instanceof CustomField) {
                    if (aliasField != null) {
                        sqlQueryObject.addSelectAliasField(sqlFieldConverter.toColumn((Field)field, appendTablePrefix), aliasField);
                    } else {
                        sqlQueryObject.addSelectField(sqlFieldConverter.toColumn((Field)field, appendTablePrefix));
                    }
                    break block27;
                }
                if (field instanceof AliasField) {
                    AliasField af = (AliasField)field;
                    IField afField = af.getField();
                    sqlQueryObject.addSelectAliasField(sqlFieldConverter.toColumn(afField, appendTablePrefix), af.getAlias());
                    break block27;
                }
                if (field instanceof Field) {
                    if (aliasField != null) {
                        sqlQueryObject.addSelectAliasField(sqlFieldConverter.toColumn((Field)field, appendTablePrefix), aliasField);
                    } else {
                        sqlQueryObject.addSelectField(sqlFieldConverter.toColumn((Field)field, appendTablePrefix));
                    }
                    break block27;
                }
                if (field instanceof ComplexField) {
                    if (aliasField != null) {
                        sqlQueryObject.addSelectAliasField(sqlFieldConverter.toColumn((ComplexField)field, appendTablePrefix), aliasField);
                    } else {
                        sqlQueryObject.addSelectField(sqlFieldConverter.toColumn((ComplexField)field, appendTablePrefix));
                    }
                    break block27;
                }
                throw new ExpressionException("Field unknown type: " + field.getClass().getName());
            }
            catch (SQLQueryObjectAlreadyExistsException e) {
                if (!ignoreAlreadyExistsException) {
                    throw new ExpressionException(e.getMessage(), e);
                }
            }
            catch (Exception e) {
                throw new ExpressionException(e.getMessage(), e);
            }
        }
    }

    protected static void addAliasField_engine(ISQLQueryObject sqlQueryObject, ISQLFieldConverter sqlFieldConverter, Object field, String aliasField, boolean appendTablePrefix) throws ExpressionException {
        ExpressionSQL.addAliasField_engine(sqlQueryObject, sqlFieldConverter, field, aliasField, appendTablePrefix, true);
    }

    protected static void addAliasField_engine(ISQLQueryObject sqlQueryObject, ISQLFieldConverter sqlFieldConverter, Object field, String aliasField, boolean appendTablePrefix, boolean ignoreAlreadyExistsException) throws ExpressionException {
        block11: {
            try {
                if (field == null) {
                    throw new ExpressionException("Field is null");
                }
                if (field instanceof FunctionField) {
                    FunctionField ff = (FunctionField)field;
                    String alias = ff.getAlias();
                    sqlQueryObject.addSelectField(alias);
                    break block11;
                }
                if (field instanceof ConstantField) {
                    sqlQueryObject.addSelectField(((ConstantField)field).getAlias());
                    break block11;
                }
                if (field instanceof CustomField) {
                    sqlQueryObject.addSelectField(((CustomField)field).getAliasColumnName());
                    break block11;
                }
                if (field instanceof AliasField) {
                    AliasField af = (AliasField)field;
                    sqlQueryObject.addSelectField(af.getAlias());
                    break block11;
                }
                if (field instanceof Field) {
                    sqlQueryObject.addSelectField(sqlFieldConverter.toAliasColumn((Field)field, false));
                    break block11;
                }
                if (field instanceof ComplexField) {
                    sqlQueryObject.addSelectField(sqlFieldConverter.toAliasColumn((ComplexField)field, false));
                    break block11;
                }
                throw new ExpressionException("Field unknown type: " + field.getClass().getName());
            }
            catch (SQLQueryObjectAlreadyExistsException e) {
                if (!ignoreAlreadyExistsException) {
                    throw new ExpressionException(e.getMessage(), e);
                }
            }
            catch (Exception e) {
                throw new ExpressionException(e.getMessage(), e);
            }
        }
    }

    public static void setFunction(Function function, boolean timestamp, String column, String alias, ISQLQueryObject sqlQueryObject) throws SQLQueryObjectException {
        switch (function) {
            case AVG: 
            case AVG_DOUBLE: {
                if (timestamp) {
                    sqlQueryObject.addSelectAvgTimestampField(column, alias);
                    break;
                }
                sqlQueryObject.addSelectAvgField(column, alias);
                break;
            }
            case MAX: {
                if (timestamp) {
                    sqlQueryObject.addSelectMaxTimestampField(column, alias);
                    break;
                }
                sqlQueryObject.addSelectMaxField(column, alias);
                break;
            }
            case MIN: {
                if (timestamp) {
                    sqlQueryObject.addSelectMinTimestampField(column, alias);
                    break;
                }
                sqlQueryObject.addSelectMinField(column, alias);
                break;
            }
            case SUM: {
                if (timestamp) {
                    sqlQueryObject.addSelectSumTimestampField(column, alias);
                    break;
                }
                sqlQueryObject.addSelectSumField(column, alias);
                break;
            }
            case COUNT: {
                sqlQueryObject.addSelectCountField(column, alias, false);
                break;
            }
            case COUNT_DISTINCT: {
                sqlQueryObject.addSelectCountField(column, alias, true);
            }
        }
    }

    protected static boolean inUse(IField fieldParam, boolean checkOnlyWhereCondition, boolean useFieldExpressionBase, List<Object> fieldsManuallyAdd, boolean checkFieldManuallyAdd) throws ExpressionNotImplementedException, ExpressionException {
        if (!checkFieldManuallyAdd) {
            return useFieldExpressionBase;
        }
        if (checkOnlyWhereCondition) {
            return useFieldExpressionBase;
        }
        for (Object iField : fieldsManuallyAdd) {
            IField field = null;
            if (iField instanceof IField) {
                field = (IField)iField;
                boolean inUse = fieldParam.equals(field);
                if (!inUse) continue;
                return true;
            }
            if (iField instanceof FunctionField) {
                List<IField> fieldsFF = ((FunctionField)iField).getFields();
                for (IField iFieldFF : fieldsFF) {
                    boolean inUse = fieldParam.equals(iFieldFF);
                    if (!inUse) continue;
                    return true;
                }
                continue;
            }
            throw new ExpressionException("Field type unknown [" + iField.getClass().getName() + "]");
        }
        return useFieldExpressionBase;
    }

    protected static boolean inUse(IModel<?> model, boolean checkOnlyWhereCondition, boolean useModelExpressionBase, List<Object> fieldsManuallyAdd, boolean checkFieldManuallyAdd) throws ExpressionNotImplementedException, ExpressionException {
        if (!checkFieldManuallyAdd) {
            return useModelExpressionBase;
        }
        if (checkOnlyWhereCondition) {
            return useModelExpressionBase;
        }
        for (Object iField : fieldsManuallyAdd) {
            IField field = null;
            if (iField instanceof IField) {
                field = (IField)iField;
                if (!ExpressionSQL._inUse(model, field)) continue;
                return true;
            }
            if (iField instanceof FunctionField) {
                List<IField> fieldsFF = ((FunctionField)iField).getFields();
                for (IField iFieldFF : fieldsFF) {
                    if (!ExpressionSQL._inUse(model, iFieldFF)) continue;
                    return true;
                }
                continue;
            }
            throw new ExpressionException("Field type unknown [" + iField.getClass().getName() + "]");
        }
        return useModelExpressionBase;
    }

    private static boolean _inUse(IModel<?> model, IField field) {
        boolean inUse = false;
        if (model.getBaseField() != null) {
            if (field instanceof ComplexField) {
                ComplexField c = (ComplexField)field;
                inUse = c.getFather().equals(model.getBaseField());
            } else {
                inUse = model.getModeledClass().getName().equals(field.getClassType().getName());
            }
        } else {
            inUse = model.getModeledClass().getName().equals(field.getClassType().getName());
        }
        return inUse;
    }

    protected static List<IField> getFields(boolean onlyWhereCondition, List<IField> getFieldExpressionBase, List<Object> fieldsManuallyAdd, boolean checkFieldManuallyAdd) throws ExpressionNotImplementedException, ExpressionException {
        if (!checkFieldManuallyAdd) {
            return getFieldExpressionBase;
        }
        if (onlyWhereCondition) {
            return getFieldExpressionBase;
        }
        ArrayList<IField> newFields = new ArrayList<IField>();
        if (getFieldExpressionBase != null) {
            newFields.addAll(getFieldExpressionBase);
        }
        for (Object iField : fieldsManuallyAdd) {
            IField field = null;
            if (iField instanceof IField) {
                field = (IField)iField;
                if (getFieldExpressionBase != null && getFieldExpressionBase.contains(field)) continue;
                newFields.add(field);
                continue;
            }
            if (iField instanceof FunctionField) {
                List<IField> fieldsFF = ((FunctionField)iField).getFields();
                for (IField iFieldFF : fieldsFF) {
                    if (getFieldExpressionBase != null && getFieldExpressionBase.contains(iFieldFF)) continue;
                    newFields.add(iFieldFF);
                }
                continue;
            }
            throw new ExpressionException("Field type unknown [" + iField.getClass().getName() + "]");
        }
        return newFields;
    }

    public String toSql() throws ExpressionException {
        if (this.expressionEngine == null && this.throwExpressionNotInitialized) {
            throw new ExpressionException("Expression is not initialized");
        }
        StringBuffer bf = null;
        if (this.expressionEngine == null) {
            bf = new StringBuffer("");
        } else if (this.expressionEngine instanceof ISQLExpression) {
            bf = new StringBuffer(((ISQLExpression)((Object)this.expressionEngine)).toSql());
        } else {
            throw new ExpressionException("ExpressioneEngine (type:" + this.expressionEngine.getClass().getName() + ") is not as cast with " + ISQLExpression.class.getName());
        }
        bf.append(this.toSqlGroupBy());
        bf.append(this.toSqlOrder());
        bf.append(this.toSqlForceIndex());
        return bf.toString();
    }

    protected String toSqlPreparedStatement(List<Object> oggetti) throws ExpressionException {
        if (this.expressionEngine == null && this.throwExpressionNotInitialized) {
            throw new ExpressionException("Expression is not initialized");
        }
        StringBuffer bf = null;
        if (this.expressionEngine == null) {
            bf = new StringBuffer("");
        } else if (this.expressionEngine instanceof ISQLExpression) {
            bf = new StringBuffer(((ISQLExpression)((Object)this.expressionEngine)).toSqlPreparedStatement(oggetti));
        } else {
            throw new ExpressionException("ExpressioneEngine (type:" + this.expressionEngine.getClass().getName() + ") is not as cast with " + ISQLExpression.class.getName());
        }
        bf.append(this.toSqlGroupBy());
        bf.append(this.toSqlOrder());
        bf.append(this.toSqlForceIndex());
        return bf.toString();
    }

    protected String toSqlJPA(Hashtable<String, Object> oggetti) throws ExpressionException {
        if (this.expressionEngine == null && this.throwExpressionNotInitialized) {
            throw new ExpressionException("Expression is not initialized");
        }
        StringBuffer bf = null;
        if (this.expressionEngine == null) {
            bf = new StringBuffer("");
        } else if (this.expressionEngine instanceof ISQLExpression) {
            bf = new StringBuffer(((ISQLExpression)((Object)this.expressionEngine)).toSqlJPA(oggetti));
        } else {
            throw new ExpressionException("ExpressioneEngine (type:" + this.expressionEngine.getClass().getName() + ") is not as cast with " + ISQLExpression.class.getName());
        }
        bf.append(this.toSqlGroupBy());
        bf.append(this.toSqlOrder());
        bf.append(this.toSqlForceIndex());
        return bf.toString();
    }

    public void toSql(ISQLQueryObject sqlQueryObject) throws ExpressionException {
        if (this.expressionEngine == null && this.throwExpressionNotInitialized) {
            throw new ExpressionException("Expression is not initialized");
        }
        if (this.expressionEngine != null) {
            if (this.expressionEngine instanceof ISQLExpression) {
                ((ISQLExpression)((Object)this.expressionEngine)).toSql(sqlQueryObject);
            } else {
                throw new ExpressionException("ExpressioneEngine (type:" + this.expressionEngine.getClass().getName() + ") is not as cast with " + ISQLExpression.class.getName());
            }
        }
        this.toSqlGroupBy(sqlQueryObject);
        this.toSqlOrder(sqlQueryObject);
        this.toSqlGroupBySelectField(sqlQueryObject);
        this.toSqlForceIndex(sqlQueryObject);
    }

    public void toSqlWithFromCondition(ISQLQueryObject sqlQueryObject, String tableNamePrincipale) throws ExpressionException, ExpressionNotImplementedException {
        this.toSql(sqlQueryObject);
        ExpressionSQL.sqlFrom(sqlQueryObject, this.getFields(false), this.getSqlFieldConverter(), tableNamePrincipale, this.getFieldsManuallyAdd(), this.getOrderedFields(), this.getGroupByFields());
    }

    protected void toSqlPreparedStatement(ISQLQueryObject sqlQueryObject, List<Object> oggetti) throws ExpressionException {
        if (this.expressionEngine == null && this.throwExpressionNotInitialized) {
            throw new ExpressionException("Expression is not initialized");
        }
        if (this.expressionEngine != null) {
            if (this.expressionEngine instanceof ISQLExpression) {
                ((ISQLExpression)((Object)this.expressionEngine)).toSqlPreparedStatement(sqlQueryObject, oggetti);
            } else {
                throw new ExpressionException("ExpressioneEngine (type:" + this.expressionEngine.getClass().getName() + ") is not as cast with " + ISQLExpression.class.getName());
            }
        }
        this.toSqlGroupBy(sqlQueryObject);
        this.toSqlOrder(sqlQueryObject);
        this.toSqlGroupBySelectField(sqlQueryObject);
        this.toSqlForceIndex(sqlQueryObject);
    }

    protected void toSqlPreparedStatementWithFromCondition(ISQLQueryObject sqlQueryObject, List<Object> oggetti, String tableNamePrincipale) throws ExpressionException, ExpressionNotImplementedException {
        this.toSqlPreparedStatement(sqlQueryObject, oggetti);
        ExpressionSQL.sqlFrom(sqlQueryObject, this.getFields(false), this.getSqlFieldConverter(), tableNamePrincipale, this.getFieldsManuallyAdd(), this.getOrderedFields(), this.getGroupByFields());
    }

    protected void toSqlJPA(ISQLQueryObject sqlQueryObject, Hashtable<String, Object> oggetti) throws ExpressionException {
        if (this.expressionEngine == null && this.throwExpressionNotInitialized) {
            throw new ExpressionException("Expression is not initialized");
        }
        if (this.expressionEngine != null) {
            if (this.expressionEngine instanceof ISQLExpression) {
                ((ISQLExpression)((Object)this.expressionEngine)).toSqlJPA(sqlQueryObject, oggetti);
            } else {
                throw new ExpressionException("ExpressioneEngine (type:" + this.expressionEngine.getClass().getName() + ") is not as cast with " + ISQLExpression.class.getName());
            }
        }
        this.toSqlGroupBy(sqlQueryObject);
        this.toSqlOrder(sqlQueryObject);
        this.toSqlGroupBySelectField(sqlQueryObject);
        this.toSqlForceIndex(sqlQueryObject);
    }

    protected void toSqlJPAWithFromCondition(ISQLQueryObject sqlQueryObject, Hashtable<String, Object> oggetti, String tableNamePrincipale) throws ExpressionException, ExpressionNotImplementedException {
        this.toSqlJPA(sqlQueryObject, oggetti);
        ExpressionSQL.sqlFrom(sqlQueryObject, this.getFields(false), this.getSqlFieldConverter(), tableNamePrincipale, this.getFieldsManuallyAdd(), this.getOrderedFields(), this.getGroupByFields());
    }

    public void addField(ISQLQueryObject sqlQueryObject, IField field, boolean appendTablePrefix) throws ExpressionException {
        ExpressionSQL.addField_engine(sqlQueryObject, this.getSqlFieldConverter(), field, null, appendTablePrefix);
        this.getFieldsManuallyAdd().add(field);
    }

    public void addField(ISQLQueryObject sqlQueryObject, IField field, String aliasField, boolean appendTablePrefix) throws ExpressionException {
        ExpressionSQL.addField_engine(sqlQueryObject, this.getSqlFieldConverter(), field, aliasField, appendTablePrefix);
        this.getFieldsManuallyAdd().add(field);
    }

    public void addAliasField(ISQLQueryObject sqlQueryObject, IField field, boolean appendTablePrefix) throws ExpressionException {
        ExpressionSQL.addAliasField_engine(sqlQueryObject, this.getSqlFieldConverter(), field, null, appendTablePrefix);
        this.getFieldsManuallyAdd().add(field);
    }

    public void addField(ISQLQueryObject sqlQueryObject, FunctionField field, boolean appendTablePrefix) throws ExpressionException {
        ExpressionSQL.addField_engine(sqlQueryObject, this.getSqlFieldConverter(), field, null, appendTablePrefix);
        this.getFieldsManuallyAdd().add(field);
    }

    @Override
    protected ComparatorExpressionImpl getComparatorExpression(IField field, Object value, Comparator c) throws ExpressionException {
        return new ComparatorExpressionSQL(this.sqlFieldConverter, this.objectFormatter, field, value, c);
    }

    @Override
    protected BetweenExpressionImpl getBetweenExpression(IField field, Object lower, Object high) throws ExpressionException {
        return new BetweenExpressionSQL(this.sqlFieldConverter, this.objectFormatter, field, lower, high);
    }

    @Override
    protected InExpressionImpl getInExpression(IField field, Object ... values) throws ExpressionException {
        ArrayList<Object> lista = new ArrayList<Object>();
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                lista.add(values[i]);
            }
        }
        return new InExpressionSQL(this.sqlFieldConverter, this.objectFormatter, field, lista);
    }

    @Override
    protected LikeExpressionImpl getLikeExpression(IField field, String value, LikeMode mode, boolean caseInsensitive) throws ExpressionException {
        return new LikeExpressionSQL(this.sqlFieldConverter, this.objectFormatter, field, value, mode, caseInsensitive);
    }

    @Override
    protected ConjunctionExpressionImpl getConjunctionExpression() throws ExpressionException {
        return new ConjunctionExpressionSQL(this.sqlFieldConverter, this.objectFormatter);
    }
}

