/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.generic_project.expression.impl.sql;

import it.link.pdd.tools.migrazione_govway.generic_project.exception.ExpressionException;
import it.link.pdd.tools.migrazione_govway.generic_project.expression.impl.AbstractBaseExpressionImpl;
import it.link.pdd.tools.migrazione_govway.generic_project.expression.impl.ConjunctionExpressionImpl;
import it.link.pdd.tools.migrazione_govway.generic_project.expression.impl.formatter.IObjectFormatter;
import it.link.pdd.tools.migrazione_govway.generic_project.expression.impl.sql.ISQLExpression;
import it.link.pdd.tools.migrazione_govway.generic_project.expression.impl.sql.ISQLFieldConverter;
import it.link.pdd.tools.migrazione_govway.generic_project.expression.impl.sql.SQLMode;
import it.link.pdd.tools.migrazione_govway.utils.sql.ISQLQueryObject;
import java.util.Hashtable;
import java.util.List;

public class ConjunctionExpressionSQL
extends ConjunctionExpressionImpl
implements ISQLExpression {
    private ISQLFieldConverter sqlFieldConverter;

    public ConjunctionExpressionSQL(ISQLFieldConverter sqlFieldConverter, IObjectFormatter objectFormatter) {
        super(objectFormatter);
        this.sqlFieldConverter = sqlFieldConverter;
    }

    public String toSql_engine(SQLMode mode, ISQLQueryObject sqlQueryObject, List<Object> oggettiPreparedStatement, Hashtable<String, Object> oggettiJPA) throws ExpressionException {
        StringBuffer bf = new StringBuffer();
        if (this.isNot()) {
            bf.append("( NOT ");
        }
        bf.append("( ");
        int index = 0;
        for (AbstractBaseExpressionImpl exp : this.getLista()) {
            if (index > 0) {
                if (this.isAndConjunction()) {
                    bf.append(" AND ");
                } else {
                    bf.append(" OR ");
                }
            }
            if (exp instanceof ISQLExpression) {
                if (sqlQueryObject != null) {
                    ISQLQueryObject sqlQ = null;
                    try {
                        sqlQ = sqlQueryObject.newSQLQueryObject();
                        switch (mode) {
                            case STANDARD: {
                                ((ISQLExpression)((Object)exp)).toSql(sqlQ);
                                bf.append(sqlQ.createSQLConditions());
                                break;
                            }
                            case PREPARED_STATEMENT: {
                                ((ISQLExpression)((Object)exp)).toSqlPreparedStatement(sqlQ, oggettiPreparedStatement);
                                bf.append(sqlQ.createSQLConditions());
                                break;
                            }
                            case JPA: {
                                ((ISQLExpression)((Object)exp)).toSqlJPA(sqlQ, oggettiJPA);
                                bf.append(sqlQ.createSQLConditions());
                            }
                        }
                    }
                    catch (Exception e) {
                        throw new ExpressionException("Expression[" + index + "] (type:" + exp.getClass().getName() + ")  sqlQueryObject error: " + e.getMessage(), e);
                    }
                } else {
                    switch (mode) {
                        case STANDARD: {
                            bf.append(((ISQLExpression)((Object)exp)).toSql());
                            break;
                        }
                        case PREPARED_STATEMENT: {
                            bf.append(((ISQLExpression)((Object)exp)).toSqlPreparedStatement(oggettiPreparedStatement));
                            break;
                        }
                        case JPA: {
                            bf.append(((ISQLExpression)((Object)exp)).toSqlJPA(oggettiJPA));
                        }
                    }
                }
            } else {
                throw new ExpressionException("Expression[" + index + "] (type:" + exp.getClass().getName() + ") is not as cast with " + ISQLExpression.class.getName());
            }
            ++index;
        }
        bf.append(" )");
        if (this.isNot()) {
            bf.append(" )");
        }
        return bf.toString();
    }

    public void toSql_engine(ISQLQueryObject sqlQueryObject, SQLMode mode, List<Object> oggettiPreparedStatement, Hashtable<String, Object> oggettiJPA) throws ExpressionException {
        try {
            String s = this.toSql_engine(mode, sqlQueryObject, oggettiPreparedStatement, oggettiJPA);
            s = s.substring(1, s.length() - 2);
            sqlQueryObject.addWhereCondition(s);
        }
        catch (Exception e) {
            throw new ExpressionException(e);
        }
    }

    @Override
    public String toSql() throws ExpressionException {
        return this.toSql_engine(SQLMode.STANDARD, null, null, null);
    }

    @Override
    public String toSqlPreparedStatement(List<Object> oggetti) throws ExpressionException {
        return this.toSql_engine(SQLMode.PREPARED_STATEMENT, null, oggetti, null);
    }

    @Override
    public String toSqlJPA(Hashtable<String, Object> oggetti) throws ExpressionException {
        return this.toSql_engine(SQLMode.JPA, null, null, oggetti);
    }

    @Override
    public void toSql(ISQLQueryObject sqlQueryObject) throws ExpressionException {
        this.toSql_engine(sqlQueryObject, SQLMode.STANDARD, null, null);
    }

    @Override
    public void toSqlPreparedStatement(ISQLQueryObject sqlQueryObject, List<Object> oggetti) throws ExpressionException {
        this.toSql_engine(sqlQueryObject, SQLMode.PREPARED_STATEMENT, oggetti, null);
    }

    @Override
    public void toSqlJPA(ISQLQueryObject sqlQueryObject, Hashtable<String, Object> oggetti) throws ExpressionException {
        this.toSql_engine(sqlQueryObject, SQLMode.JPA, null, oggetti);
    }
}

