/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.generic_project.expression.impl.sql;

import it.link.pdd.tools.migrazione_govway.generic_project.beans.IField;
import it.link.pdd.tools.migrazione_govway.generic_project.exception.ExpressionException;
import it.link.pdd.tools.migrazione_govway.generic_project.expression.impl.Comparator;
import it.link.pdd.tools.migrazione_govway.generic_project.expression.impl.ComparatorExpressionImpl;
import it.link.pdd.tools.migrazione_govway.generic_project.expression.impl.formatter.IObjectFormatter;
import it.link.pdd.tools.migrazione_govway.generic_project.expression.impl.sql.ISQLExpression;
import it.link.pdd.tools.migrazione_govway.generic_project.expression.impl.sql.ISQLFieldConverter;
import it.link.pdd.tools.migrazione_govway.generic_project.expression.impl.sql.SQLMode;
import it.link.pdd.tools.migrazione_govway.generic_project.utils.IDGenerator;
import it.link.pdd.tools.migrazione_govway.utils.sql.ISQLQueryObject;
import java.util.Hashtable;
import java.util.List;

public class ComparatorExpressionSQL
extends ComparatorExpressionImpl
implements ISQLExpression {
    private ISQLFieldConverter sqlFieldConverter;

    public ComparatorExpressionSQL(ISQLFieldConverter sqlFieldConverter, IObjectFormatter objectFormatter, IField field, Object object, Comparator comparator) {
        super(objectFormatter, field, object, comparator);
        this.sqlFieldConverter = sqlFieldConverter;
    }

    public String toSql_engine(SQLMode mode, List<Object> oggettiPreparedStatement, Hashtable<String, Object> oggettiJPA) throws ExpressionException {
        StringBuffer bf = new StringBuffer();
        if (this.isNot()) {
            bf.append("( NOT ");
        }
        bf.append("( ");
        bf.append(this.sqlFieldConverter.toColumn(this.getField(), true));
        bf.append(" ");
        bf.append(this.getComparator().getOperatore(this.sqlFieldConverter));
        if (this.getObject() != null) {
            bf.append(" ");
            switch (mode) {
                case STANDARD: {
                    try {
                        bf.append(super.getObjectFormatter().toSQLString(this.getObject()));
                        break;
                    }
                    catch (Exception e) {
                        return "ERROR: " + e.getMessage();
                    }
                }
                case PREPARED_STATEMENT: {
                    bf.append("?");
                    oggettiPreparedStatement.add(this.getObject());
                    break;
                }
                case JPA: {
                    String id = IDGenerator.getUniqueID(this.getField());
                    bf.append(":" + id);
                    oggettiJPA.put(id, this.getObject());
                }
            }
        }
        bf.append(" )");
        if (this.isNot()) {
            bf.append(" )");
        }
        return bf.toString();
    }

    public void toSql_engine(ISQLQueryObject sqlQueryObject, SQLMode mode, List<Object> oggettiPreparedStatement, Hashtable<String, Object> oggettiJPA) throws ExpressionException {
        try {
            String s = this.toSql_engine(mode, oggettiPreparedStatement, oggettiJPA);
            s = s.substring(1, s.length() - 2);
            sqlQueryObject.addWhereCondition(s);
        }
        catch (Exception e) {
            throw new ExpressionException(e);
        }
    }

    @Override
    public String toSql() throws ExpressionException {
        return this.toSql_engine(SQLMode.STANDARD, null, null);
    }

    @Override
    public String toSqlPreparedStatement(List<Object> oggetti) throws ExpressionException {
        return this.toSql_engine(SQLMode.PREPARED_STATEMENT, oggetti, null);
    }

    @Override
    public String toSqlJPA(Hashtable<String, Object> oggetti) throws ExpressionException {
        return this.toSql_engine(SQLMode.JPA, null, oggetti);
    }

    @Override
    public void toSql(ISQLQueryObject sqlQueryObject) throws ExpressionException {
        this.toSql_engine(sqlQueryObject, SQLMode.STANDARD, null, null);
    }

    @Override
    public void toSqlPreparedStatement(ISQLQueryObject sqlQueryObject, List<Object> oggetti) throws ExpressionException {
        this.toSql_engine(sqlQueryObject, SQLMode.PREPARED_STATEMENT, oggetti, null);
    }

    @Override
    public void toSqlJPA(ISQLQueryObject sqlQueryObject, Hashtable<String, Object> oggetti) throws ExpressionException {
        this.toSql_engine(sqlQueryObject, SQLMode.JPA, null, oggetti);
    }
}

