/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.generic_project.expression.impl.sql;

import it.link.pdd.tools.migrazione_govway.generic_project.beans.IField;
import it.link.pdd.tools.migrazione_govway.generic_project.exception.ExpressionException;
import it.link.pdd.tools.migrazione_govway.generic_project.expression.impl.BetweenExpressionImpl;
import it.link.pdd.tools.migrazione_govway.generic_project.expression.impl.formatter.IObjectFormatter;
import it.link.pdd.tools.migrazione_govway.generic_project.expression.impl.sql.ISQLExpression;
import it.link.pdd.tools.migrazione_govway.generic_project.expression.impl.sql.ISQLFieldConverter;
import it.link.pdd.tools.migrazione_govway.generic_project.expression.impl.sql.SQLMode;
import it.link.pdd.tools.migrazione_govway.generic_project.utils.IDGenerator;
import it.link.pdd.tools.migrazione_govway.utils.sql.ISQLQueryObject;
import java.util.Hashtable;
import java.util.List;

public class BetweenExpressionSQL
extends BetweenExpressionImpl
implements ISQLExpression {
    private ISQLFieldConverter sqlFieldConverter;

    public BetweenExpressionSQL(ISQLFieldConverter sqlFieldConverter, IObjectFormatter objectFormatter, IField field, Object lower, Object high) {
        super(objectFormatter, field, lower, high);
        this.sqlFieldConverter = sqlFieldConverter;
    }

    public String toSql_engine(SQLMode mode, List<Object> oggettiPreparedStatement, Hashtable<String, Object> oggettiJPA) throws ExpressionException {
        String id;
        StringBuffer bf = new StringBuffer();
        if (this.isNot()) {
            bf.append("( NOT ");
        }
        bf.append("( ");
        bf.append(this.sqlFieldConverter.toColumn(this.getField(), true));
        bf.append(" BETWEEN ");
        bf.append(" ");
        switch (mode) {
            case STANDARD: {
                try {
                    bf.append(super.getObjectFormatter().toSQLString(this.getLower()));
                    break;
                }
                catch (Exception e) {
                    return "ERROR-LOWER: " + e.getMessage();
                }
            }
            case PREPARED_STATEMENT: {
                bf.append("?");
                oggettiPreparedStatement.add(this.getLower());
                break;
            }
            case JPA: {
                id = "Lower_" + IDGenerator.getUniqueID(this.getField());
                bf.append(":" + id);
                oggettiJPA.put(id, this.getLower());
            }
        }
        bf.append(" AND ");
        switch (mode) {
            case STANDARD: {
                try {
                    bf.append(super.getObjectFormatter().toSQLString(this.getHigh()));
                    break;
                }
                catch (Exception e) {
                    return "ERROR-HIGH: " + e.getMessage();
                }
            }
            case PREPARED_STATEMENT: {
                bf.append("?");
                oggettiPreparedStatement.add(this.getHigh());
                break;
            }
            case JPA: {
                id = "High_" + IDGenerator.getUniqueID(this.getField());
                bf.append(":" + id);
                oggettiJPA.put(id, this.getHigh());
            }
        }
        bf.append(" )");
        if (this.isNot()) {
            bf.append(" )");
        }
        return bf.toString();
    }

    public void toSql_engine(ISQLQueryObject sqlQueryObject, SQLMode mode, List<Object> oggettiPreparedStatement, Hashtable<String, Object> oggettiJPA) throws ExpressionException {
        try {
            String s = this.toSql_engine(mode, oggettiPreparedStatement, oggettiJPA);
            s = s.substring(1, s.length() - 2);
            sqlQueryObject.addWhereCondition(s);
        }
        catch (Exception e) {
            throw new ExpressionException(e);
        }
    }

    @Override
    public String toSql() throws ExpressionException {
        return this.toSql_engine(SQLMode.STANDARD, null, null);
    }

    @Override
    public String toSqlPreparedStatement(List<Object> oggetti) throws ExpressionException {
        return this.toSql_engine(SQLMode.PREPARED_STATEMENT, oggetti, null);
    }

    @Override
    public String toSqlJPA(Hashtable<String, Object> oggetti) throws ExpressionException {
        return this.toSql_engine(SQLMode.JPA, null, oggetti);
    }

    @Override
    public void toSql(ISQLQueryObject sqlQueryObject) throws ExpressionException {
        this.toSql_engine(sqlQueryObject, SQLMode.STANDARD, null, null);
    }

    @Override
    public void toSqlPreparedStatement(ISQLQueryObject sqlQueryObject, List<Object> oggetti) throws ExpressionException {
        this.toSql_engine(sqlQueryObject, SQLMode.PREPARED_STATEMENT, oggetti, null);
    }

    @Override
    public void toSqlJPA(ISQLQueryObject sqlQueryObject, Hashtable<String, Object> oggetti) throws ExpressionException {
        this.toSql_engine(sqlQueryObject, SQLMode.JPA, null, oggetti);
    }
}

