/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.generic_project.expression.impl.sql;

import it.link.pdd.tools.migrazione_govway.generic_project.beans.AliasField;
import it.link.pdd.tools.migrazione_govway.generic_project.beans.ConstantField;
import it.link.pdd.tools.migrazione_govway.generic_project.beans.CustomField;
import it.link.pdd.tools.migrazione_govway.generic_project.beans.IAliasTableField;
import it.link.pdd.tools.migrazione_govway.generic_project.beans.IField;
import it.link.pdd.tools.migrazione_govway.generic_project.beans.IModel;
import it.link.pdd.tools.migrazione_govway.generic_project.exception.ExpressionException;
import it.link.pdd.tools.migrazione_govway.generic_project.expression.impl.sql.ISQLFieldConverter;

public abstract class AbstractSQLFieldConverter
implements ISQLFieldConverter {
    @Override
    public String toColumn(IField field, boolean returnAlias, boolean appendTablePrefix) throws ExpressionException {
        if (field instanceof CustomField) {
            CustomField cf = (CustomField)field;
            if (appendTablePrefix) {
                String table = this.toAliasTable(field);
                if (table != null && !"".equals(table)) {
                    if (returnAlias) {
                        return table + "." + cf.getAliasColumnName();
                    }
                    return table + "." + cf.getColumnName();
                }
                if (returnAlias) {
                    return cf.getAliasColumnName();
                }
                return cf.getColumnName();
            }
            if (returnAlias) {
                return cf.getAliasColumnName();
            }
            return cf.getColumnName();
        }
        if (field instanceof ConstantField) {
            ConstantField cf = (ConstantField)field;
            if (returnAlias) {
                return cf.getAlias();
            }
            return cf.getConstantValue(this.getDatabaseType());
        }
        if (field instanceof AliasField) {
            AliasField af = (AliasField)field;
            return af.getAlias();
        }
        if (field instanceof IAliasTableField) {
            IAliasTableField atf = (IAliasTableField)field;
            if (appendTablePrefix) {
                return atf.getAliasTable() + "." + this.toColumn(atf.getField(), returnAlias, false);
            }
            return this.toColumn(atf.getField(), returnAlias, false);
        }
        throw new ExpressionException("Field [" + field.toString() + "] not supported by converter.toColumn: " + this.getClass().getName());
    }

    @Override
    public String toColumn(IField field, boolean appendTablePrefix) throws ExpressionException {
        return this.toColumn(field, false, appendTablePrefix);
    }

    @Override
    public String toAliasColumn(IField field, boolean appendTablePrefix) throws ExpressionException {
        return this.toColumn(field, true, appendTablePrefix);
    }

    @Override
    public String toTable(IField field, boolean returnAlias) throws ExpressionException {
        if (field instanceof CustomField) {
            CustomField cf = (CustomField)field;
            if (returnAlias) {
                return cf.getAliasTableName();
            }
            return cf.getTableName();
        }
        if (field instanceof ConstantField) {
            return this.toTable(this.getRootModel(), returnAlias);
        }
        if (field instanceof AliasField) {
            AliasField af = (AliasField)field;
            return this.toTable(af.getField(), returnAlias);
        }
        if (field instanceof IAliasTableField) {
            IAliasTableField af = (IAliasTableField)field;
            if (returnAlias) {
                return af.getAliasTable();
            }
            return this.toTable(af.getField());
        }
        throw new ExpressionException("Field [" + field.toString() + "] not supported by converter.toTable: " + this.getClass().getName());
    }

    @Override
    public String toTable(IField field) throws ExpressionException {
        return this.toTable(field, false);
    }

    @Override
    public String toAliasTable(IField field) throws ExpressionException {
        return this.toTable(field, true);
    }

    @Override
    public String toTable(IModel<?> model, boolean returnAlias) throws ExpressionException {
        throw new ExpressionException("Model [" + model.toString() + "] not supported by converter.toTable: " + this.getClass().getName());
    }

    @Override
    public String toTable(IModel<?> model) throws ExpressionException {
        return this.toTable(model, false);
    }

    @Override
    public String toAliasTable(IModel<?> model) throws ExpressionException {
        return this.toTable(model, true);
    }
}

