/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.generic_project.expression.impl.formatter;

import it.link.pdd.tools.migrazione_govway.generic_project.exception.ExpressionException;
import it.link.pdd.tools.migrazione_govway.generic_project.expression.impl.formatter.ITypeFormatter;
import it.link.pdd.tools.migrazione_govway.generic_project.expression.impl.formatter.StringTypeFormatter;
import it.link.pdd.tools.migrazione_govway.utils.TipiDatabase;
import java.net.URI;

public class URITypeFormatter
implements ITypeFormatter<URI> {
    @Override
    public String toString(URI o) throws ExpressionException {
        if (o == null) {
            throw new ExpressionException("Object parameter is null");
        }
        return o.toString();
    }

    @Override
    public String toSQLString(URI o) throws ExpressionException {
        return this.toSQLString(o, TipiDatabase.DEFAULT);
    }

    @Override
    public String toSQLString(URI o, TipiDatabase databaseType) throws ExpressionException {
        switch (databaseType) {
            case POSTGRESQL: {
                return "'" + StringTypeFormatter.escapeStringValue(this.toString(o)) + "'::text";
            }
        }
        return "'" + StringTypeFormatter.escapeStringValue(this.toString(o)) + "'";
    }

    @Override
    public URI toObject(String o, Class<?> c) throws ExpressionException {
        if (o == null) {
            throw new ExpressionException("Object parameter is null");
        }
        try {
            return new URI(o);
        }
        catch (Exception e) {
            throw new ExpressionException("Conversion failure: " + e.getMessage(), e);
        }
    }

    @Override
    public Class<URI> getTypeSupported() {
        return URI.class;
    }
}

